/* -*- mode: C++; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/*
 *  Main authors:
 *     Christian Schulte <schulte@gecode.org>
 *
 *  Last modified:
 *     $Date: 2009-10-29 16:09:00 +0100 (Thu, 29 Oct 2009) $ by $Author: zayenz $
 *     $Revision: 10003 $
 *
 *  This file is part of Gecode, the generic constraint
 *  development environment:
 *     http://www.gecode.org
 *
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

namespace {

  /*
   * The following wordlists are taken from SCOWL, english-55. Please
   * see below for details and copyright information.
   *
   */
  const char* w_0[] = {
    ""
  };

  const char* w_1[] = {
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l",
    "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x",
    "y", "z"
  };

  const char* w_2[] = {
    "ad", "ah", "am", "an", "as", "at", "be", "by", "cs", "do",
    "eh", "em", "es", "ex", "fa", "go", "gs", "ha", "he", "hi",
    "hm", "ho", "id", "if", "in", "is", "it", "kc", "ks", "la",
    "lo", "ls", "ma", "me", "mi", "ms", "mu", "my", "no", "nu",
    "of", "oh", "oi", "on", "or", "ow", "ox", "pa", "pi", "re",
    "rs", "sh", "so", "ta", "ti", "to", "ts", "uh", "um", "up",
    "us", "vs", "we", "ya", "ye", "yo"
  };

  const char* w_3[] = {
    "aah", "ace", "act", "add", "ado", "ads", "adz", "aft",
    "age", "ago", "aha", "aid", "ail", "aim", "air", "alb",
    "ale", "all", "amp", "and", "ant", "any", "ape", "apt",
    "arc", "are", "ark", "arm", "art", "ash", "ask", "asp",
    "ate", "auk", "awe", "awl", "aye", "baa", "bad", "bag",
    "bah", "ban", "bap", "bar", "bat", "bay", "bed", "bee",
    "beg", "bet", "bib", "bid", "big", "bin", "bit", "biz",
    "boa", "bob", "bod", "bog", "boo", "bop", "bow", "box",
    "boy", "bra", "brr", "bub", "bud", "bug", "bum", "bun",
    "bur", "bus", "but", "buy", "bye", "cab", "cad", "cam",
    "can", "cap", "car", "cat", "caw", "chi", "cob", "cod",
    "cog", "con", "coo", "cop", "cot", "cow", "cox", "coy",
    "cry", "cub", "cud", "cue", "cup", "cur", "cut", "dab",
    "dad", "dag", "dam", "day", "deb", "den", "dew", "did",
    "die", "dig", "dim", "din", "dip", "dis", "dob", "doc",
    "doe", "dog", "don", "dos", "dot", "dry", "dub", "dud",
    "due", "dug", "duh", "dun", "duo", "dye", "ear", "eat",
    "ebb", "ecu", "eek", "eel", "eff", "egg", "ego", "eke",
    "elf", "elk", "ell", "elm", "ems", "emu", "end", "eon",
    "era", "ere", "erg", "err", "eta", "eve", "ewe", "eye",
    "fab", "fad", "fag", "fan", "far", "fat", "fax", "fed",
    "fee", "fen", "fer", "few", "fey", "fez", "fib", "fie",
    "fig", "fin", "fir", "fit", "fix", "flu", "fly", "fob",
    "foe", "fog", "fop", "for", "fox", "fro", "fry", "fug",
    "fun", "fur", "gab", "gad", "gag", "gal", "gap", "gas",
    "gay", "gee", "gel", "gem", "get", "gig", "gin", "git",
    "gnu", "gob", "god", "goo", "gos", "got", "gum", "gun",
    "gut", "guv", "guy", "gym", "gyp", "had", "hag", "haj",
    "ham", "has", "hat", "haw", "hay", "hem", "hen", "hep",
    "her", "hes", "hew", "hex", "hey", "hid", "hie", "him",
    "hip", "his", "hit", "hob", "hod", "hoe", "hog", "hop",
    "hos", "hot", "how", "hub", "hue", "hug", "huh", "hum",
    "hut", "ice", "icy", "ids", "ifs", "ilk", "ill", "imp",
    "ink", "inn", "ins", "ion", "ire", "irk", "ism", "its",
    "ivy", "jab", "jag", "jam", "jar", "jaw", "jay", "jet",
    "jib", "jig", "job", "jog", "jot", "joy", "jug", "jut",
    "keg", "ken", "key", "kid", "kin", "kip", "kit", "lab",
    "lad", "lag", "lam", "lap", "lav", "law", "lax", "lay",
    "lea", "led", "lee", "leg", "lei", "let", "lib", "lid",
    "lie", "lip", "lit", "lob", "log", "loo", "lop", "lot",
    "low", "lox", "lug", "luv", "lye", "mac", "mad", "mam",
    "man", "map", "mar", "mas", "mat", "maw", "may", "meg",
    "men", "mes", "met", "mew", "mic", "mid", "mil", "mix",
    "mob", "mod", "moi", "mom", "moo", "mop", "mow", "mud",
    "mug", "mum", "mys", "nab", "nae", "nag", "nah", "nan",
    "nap", "nay", "net", "new", "nib", "nil", "nip", "nit",
    "nix", "nob", "nod", "non", "nor", "not", "now", "nth",
    "nub", "nun", "nut", "oaf", "oak", "oar", "oat", "och",
    "odd", "ode", "off", "oft", "ohm", "oho", "ohs", "oik",
    "oil", "old", "one", "ooh", "ops", "opt", "orb", "ore",
    "our", "out", "ova", "owe", "owl", "own", "pad", "pah",
    "pal", "pan", "pap", "par", "pas", "pat", "paw", "pay",
    "pea", "pee", "peg", "pen", "pep", "per", "pet", "pew",
    "pic", "pie", "pig", "pin", "pip", "pis", "pit", "pix",
    "ply", "pod", "poi", "pol", "pom", "poo", "pop", "pot",
    "pow", "pox", "pro", "pry", "pub", "pud", "pug", "pun",
    "pup", "pus", "put", "pyx", "qua", "rag", "ram", "ran",
    "rap", "rat", "raw", "ray", "red", "ref", "rep", "rev",
    "rho", "rib", "rid", "rig", "rim", "rip", "rob", "rod",
    "roe", "rot", "row", "rub", "rue", "rug", "rum", "run",
    "rut", "rye", "sac", "sad", "sag", "sap", "sat", "saw",
    "sax", "say", "sea", "see", "set", "sew", "sex", "she",
    "shh", "shy", "sic", "sin", "sip", "sir", "sis", "sit",
    "six", "ska", "ski", "sky", "sly", "sob", "sod", "sol",
    "son", "sop", "sot", "sou", "sow", "soy", "spa", "spy",
    "ssh", "sty", "sub", "sue", "sum", "sun", "sup", "tab",
    "tad", "tag", "tam", "tan", "tap", "tar", "tat", "tax",
    "tea", "tee", "ten", "the", "tho", "thy", "tic", "tie",
    "til", "tin", "tip", "tit", "toe", "tog", "tom", "ton",
    "too", "top", "tor", "tot", "tow", "toy", "try", "tub",
    "tug", "tum", "tun", "tut", "tux", "two", "ugh", "ump",
    "uni", "ups", "urn", "use", "vac", "van", "vat", "veg",
    "vet", "vex", "via", "vie", "vim", "vow", "wad", "wag",
    "wan", "war", "was", "wax", "way", "web", "wed", "wee",
    "wen", "wet", "who", "why", "wig", "win", "wit", "woe",
    "wog", "wok", "won", "woo", "wop", "wot", "wow", "wry",
    "yak", "yam", "yap", "yaw", "yea", "yen", "yep", "yer",
    "yes", "yet", "yew", "yid", "yin", "yip", "yob", "yon",
    "you", "yuk", "yum", "yup", "zap", "zed", "zip", "zit",
    "zoo"
  };

  const char* w_4[] = {
    "abed", "abet", "able", "ably", "abut", "aced", "aces",
    "ache", "achy", "acid", "acme", "acne", "acre", "acts",
    "adds", "afar", "agar", "aged", "ages", "agog", "ague",
    "ahas", "ahem", "ahoy", "aide", "aids", "ails", "aims",
    "airs", "airy", "ajar", "akin", "alas", "albs", "ales",
    "alga", "ally", "alms", "aloe", "also", "alto", "alum",
    "amen", "amid", "ammo", "amok", "amps", "anal", "ands",
    "anew", "ankh", "anon", "ante", "anti", "ants", "anus",
    "aped", "apes", "apex", "apse", "aqua", "arch", "arcs",
    "area", "ares", "aria", "arid", "arks", "arms", "army",
    "arts", "arty", "ashy", "asks", "asps", "ates", "atom",
    "atop", "auks", "aunt", "aura", "auto", "aver", "avid",
    "avow", "away", "awed", "awes", "awls", "awry", "axed",
    "axes", "axis", "axle", "axon", "ayes", "baas", "babe",
    "baby", "back", "bade", "bags", "bahs", "bail", "bait",
    "bake", "bald", "bale", "balk", "ball", "balm", "band",
    "bane", "bang", "bani", "bank", "bans", "baps", "barb",
    "bard", "bare", "barf", "bark", "barn", "bars", "base",
    "bash", "bask", "bass", "bast", "bate", "bath", "bats",
    "baud", "bawl", "bays", "bead", "beak", "beam", "bean",
    "bear", "beat", "beau", "beck", "beds", "beef", "been",
    "beep", "beer", "bees", "beet", "begs", "bell", "belt",
    "bend", "bent", "berg", "berk", "berm", "best", "beta",
    "bets", "bevy", "bias", "bibs", "bide", "bids", "bier",
    "biff", "bike", "bile", "bilk", "bill", "bind", "bins",
    "bird", "bite", "bits", "blab", "blag", "blah", "bled",
    "blew", "blip", "blob", "bloc", "blot", "blow", "blue",
    "blur", "boar", "boas", "boat", "bobs", "bode", "bods",
    "body", "bogs", "boil", "bola", "bold", "bole", "boll",
    "bolt", "bomb", "bond", "bone", "bong", "bonk", "bony",
    "boob", "book", "boom", "boon", "boor", "boos", "boot",
    "bops", "bore", "born", "bosh", "boss", "both", "bout",
    "bowl", "bows", "boxy", "boys", "bozo", "brad", "brae",
    "brag", "bran", "bras", "brat", "bray", "bred", "brew",
    "brie", "brig", "brim", "brow", "bubs", "buck", "buds",
    "buff", "bugs", "bulb", "bulk", "bull", "bumf", "bump",
    "bums", "bung", "bunk", "buns", "bunt", "buoy", "burg",
    "burk", "burn", "burp", "burr", "burs", "bury", "bush",
    "busk", "buss", "bust", "busy", "buts", "butt", "buys",
    "buzz", "byes", "byre", "byte", "cabs", "cads", "caff",
    "cage", "cake", "calf", "call", "calm", "came", "camp",
    "cams", "cane", "cans", "cant", "cape", "caps", "card",
    "care", "carp", "cars", "cart", "case", "cash", "cask",
    "cast", "cats", "cave", "caws", "cede", "cell", "cent",
    "chap", "char", "chat", "chef", "chew", "chic", "chin",
    "chip", "chit", "choc", "chop", "chow", "chug", "chum",
    "ciao", "cine", "cite", "city", "clad", "clam", "clan",
    "clap", "claw", "clay", "clef", "clew", "clip", "clod",
    "clog", "clop", "clot", "cloy", "club", "clue", "coal",
    "coat", "coax", "cobs", "cock", "coda", "code", "cods",
    "coed", "cogs", "coif", "coil", "coin", "coir", "coke",
    "cola", "cold", "cols", "colt", "coma", "comb", "come",
    "cone", "conk", "cons", "cony", "cook", "cool", "coon",
    "coop", "coos", "coot", "cope", "cops", "copy", "cord",
    "core", "cork", "corm", "corn", "cosh", "cost", "cote",
    "cots", "coup", "cove", "cowl", "cows", "crab", "crag",
    "cram", "crap", "craw", "cred", "crew", "crib", "crop",
    "crow", "crud", "crux", "cube", "cubs", "cuds", "cued",
    "cues", "cuff", "cull", "cult", "cums", "cunt", "cups",
    "curd", "cure", "curl", "curs", "curt", "cusp", "cuss",
    "cute", "cuts", "cyan", "cyst", "dabs", "dado", "dads",
    "daft", "dago", "dags", "dais", "dale", "dame", "damn",
    "damp", "dams", "dang", "dank", "dare", "dark", "darn",
    "dart", "dash", "data", "date", "daub", "dawn", "days",
    "daze", "dead", "deaf", "deal", "dean", "dear", "debs",
    "debt", "deck", "deed", "deem", "deep", "deer", "deft",
    "defy", "deli", "dell", "demo", "dens", "dent", "deny",
    "derv", "desk", "dewy", "dhow", "dial", "dice", "dick",
    "died", "dies", "diet", "digs", "dike", "dill", "dime",
    "dims", "dine", "ding", "dins", "dint", "dips", "dire",
    "dirk", "dirt", "disc", "dish", "disk", "diva", "dive",
    "dobs", "dock", "docs", "dodo", "doer", "does", "doff",
    "dogs", "dole", "doll", "dolt", "dome", "done", "dons",
    "doom", "door", "dope", "dork", "dorm", "dory", "dose",
    "dosh", "doss", "dost", "dote", "doth", "dots", "dour",
    "dove", "down", "doze", "dozy", "drab", "drag", "dram",
    "drat", "draw", "dray", "drew", "drip", "drop", "drub",
    "drug", "drum", "drys", "dual", "dubs", "duck", "duct",
    "dude", "duds", "duel", "dues", "duet", "duff", "duke",
    "dull", "duly", "dumb", "dump", "dune", "dung", "dunk",
    "duns", "duos", "dupe", "dusk", "dust", "duty", "dyed",
    "dyer", "dyes", "each", "earl", "earn", "ears", "ease",
    "east", "easy", "eats", "eave", "ebbs", "echo", "ecru",
    "eddy", "edge", "edgy", "edit", "eels", "effs", "eggs",
    "egos", "eked", "ekes", "elks", "ells", "elms", "else",
    "emir", "emit", "emus", "ends", "envy", "eons", "epic",
    "eras", "ergo", "ergs", "errs", "espy", "etch", "euro",
    "even", "ever", "eves", "evil", "ewer", "ewes", "exam",
    "exec", "exes", "exit", "expo", "eyed", "eyes", "face",
    "fact", "fade", "fads", "faff", "fags", "fail", "fain",
    "fair", "fake", "fall", "fame", "fang", "fans", "fare",
    "farm", "fart", "fast", "fate", "fats", "faun", "fave",
    "fawn", "faze", "fear", "feat", "feds", "feed", "feel",
    "fees", "feet", "fell", "felt", "fems", "fend", "fens",
    "fern", "fess", "fest", "feta", "feud", "fiat", "fibs",
    "fief", "fies", "fife", "figs", "file", "fill", "film",
    "filo", "find", "fine", "fink", "fins", "fire", "firm",
    "firs", "fish", "fist", "fits", "five", "fizz", "flab",
    "flag", "flak", "flan", "flap", "flat", "flaw", "flax",
    "flay", "flea", "fled", "flee", "flew", "flex", "flip",
    "flit", "floe", "flog", "flop", "flow", "flub", "flue",
    "flux", "foal", "foam", "fobs", "foes", "fogs", "foil",
    "fold", "folk", "fond", "font", "food", "fool", "foot",
    "fops", "ford", "fore", "fork", "form", "fort", "foul",
    "four", "fowl", "foxy", "frat", "fray", "free", "fret",
    "frig", "frog", "from", "fuck", "fuel", "full", "fume",
    "fund", "funk", "furl", "furs", "fury", "fuse", "fuss",
    "futz", "fuzz", "gabs", "gads", "gaff", "gaga", "gags",
    "gain", "gait", "gala", "gale", "gall", "gals", "game",
    "gamy", "gang", "gaol", "gape", "gaps", "garb", "gash",
    "gasp", "gate", "gave", "gawd", "gawk", "gawp", "gays",
    "gaze", "gear", "geed", "geek", "gees", "geld", "gels",
    "gems", "gene", "gens", "gent", "germ", "gets", "ghee",
    "gibe", "gift", "gigs", "gild", "gill", "gilt", "gins",
    "gird", "girl", "giro", "girt", "gist", "gite", "gits",
    "give", "glad", "glam", "glee", "glen", "glib", "glob",
    "glop", "glow", "glue", "glum", "glut", "gnat", "gnaw",
    "gnus", "goad", "goal", "goat", "gobs", "gods", "goer",
    "goes", "gold", "golf", "gone", "gong", "good", "goof",
    "gook", "goon", "goop", "gore", "gory", "gosh", "goth",
    "gout", "govs", "gown", "grab", "grad", "gram", "gran",
    "grew", "grid", "grim", "grin", "grip", "grit", "grog",
    "grow", "grub", "guff", "gulf", "gull", "gulp", "gums",
    "gunk", "guns", "guru", "gush", "gust", "guts", "guvs",
    "guys", "gyms", "gyps", "gyro", "hack", "haft", "hags",
    "hail", "hair", "hajj", "hake", "hale", "half", "hall",
    "halo", "halt", "hams", "hand", "hang", "hank", "hard",
    "hare", "hark", "harm", "harp", "hart", "hash", "hasp",
    "hast", "hate", "hath", "hats", "haul", "have", "hawk",
    "haws", "hays", "haze", "hazy", "head", "heal", "heap",
    "hear", "heat", "heck", "heed", "heel", "heft", "heir",
    "held", "hell", "helm", "help", "hemp", "hems", "hens",
    "heps", "herb", "herd", "here", "hero", "hers", "hews",
    "hick", "hide", "hied", "hies", "high", "hike", "hill",
    "hilt", "hims", "hind", "hint", "hips", "hire", "hiss",
    "hits", "hive", "hiya", "hoax", "hobo", "hobs", "hock",
    "hods", "hoed", "hoes", "hogs", "hold", "hole", "hols",
    "holy", "home", "hone", "honk", "hood", "hoof", "hook",
    "hoop", "hoot", "hope", "hops", "horn", "hose", "host",
    "hots", "hour", "hove", "howl", "hows", "hubs", "hued",
    "hues", "huff", "huge", "hugs", "huhs", "hula", "hulk",
    "hull", "hump", "hums", "hung", "hunk", "hunt", "hurl",
    "hurt", "hush", "husk", "huts", "hymn", "hype", "hypo",
    "iamb", "ibex", "ibis", "iced", "ices", "icky", "icon",
    "idea", "idem", "ides", "idle", "idly", "idol", "iffy",
    "ilks", "ills", "imam", "imps", "inch", "info", "inks",
    "inky", "inns", "inti", "into", "ions", "iota", "ired",
    "ires", "iris", "irks", "iron", "isle", "isms", "itch",
    "item", "jabs", "jack", "jade", "jags", "jail", "jamb",
    "jams", "jape", "jars", "jaws", "jays", "jazz", "jeep",
    "jeer", "jeez", "jell", "jerk", "jest", "jets", "jibs",
    "jigs", "jilt", "jink", "jinn", "jinx", "jive", "jobs",
    "jock", "joey", "jogs", "john", "join", "joke", "jolt",
    "josh", "jots", "jowl", "joys", "judo", "jugs", "jump",
    "junk", "jury", "just", "jute", "juts", "kale", "kart",
    "keel", "keen", "keep", "kegs", "kelp", "kens", "kept",
    "keys", "khan", "kick", "kids", "kike", "kill", "kiln",
    "kilo", "kilt", "kind", "king", "kink", "kins", "kips",
    "kirk", "kiss", "kite", "kith", "kits", "kiwi", "knee",
    "knew", "knit", "knob", "knot", "know", "kohl", "kook",
    "labs", "lace", "lack", "lacy", "lade", "lads", "lady",
    "lags", "laid", "lain", "lair", "lake", "lama", "lamb",
    "lame", "lamp", "lams", "land", "lane", "lank", "laps",
    "lard", "lark", "lash", "lass", "last", "late", "lath",
    "lats", "laud", "lava", "lavs", "lawn", "laws", "lays",
    "laze", "lazy", "lead", "leaf", "leak", "lean", "leap",
    "leas", "lech", "leek", "leer", "lees", "left", "legs",
    "leis", "lend", "lens", "lent", "less", "lest", "lets",
    "levy", "lewd", "liar", "libs", "lice", "lick", "lido",
    "lids", "lied", "lief", "lien", "lies", "lieu", "life",
    "lift", "like", "lilo", "lilt", "lily", "limb", "lime",
    "limn", "limo", "limp", "limy", "line", "link", "lino",
    "lint", "lion", "lips", "lira", "lire", "lisp", "list",
    "lite", "live", "load", "loaf", "loam", "loan", "lobe",
    "lobs", "loch", "loci", "lock", "loco", "lode", "loft",
    "loge", "logo", "logs", "loin", "loll", "lone", "long",
    "look", "loom", "loon", "loop", "loos", "loot", "lope",
    "lops", "lord", "lore", "lorn", "lose", "loss", "lost",
    "lots", "loud", "lour", "lout", "love", "lows", "luau",
    "lube", "luck", "ludo", "luge", "lugs", "lull", "lulu",
    "lump", "lung", "lure", "lurk", "lush", "lust", "lute",
    "luvs", "lynx", "lyre", "mace", "mack", "macs", "made",
    "mags", "maid", "mail", "maim", "main", "make", "male",
    "mall", "malt", "mama", "mams", "mane", "mans", "many",
    "maps", "mare", "mark", "mars", "mart", "mash", "mask",
    "mass", "mast", "mate", "math", "mats", "maul", "maws",
    "mayo", "maze", "mead", "meal", "mean", "meat", "meek",
    "meet", "mega", "megs", "meld", "melt", "memo", "mend",
    "menu", "mere", "mesa", "mesh", "mess", "mete", "mewl",
    "mews", "mica", "mice", "mick", "mics", "mien", "miff",
    "mike", "mild", "mile", "milk", "mill", "mils", "mime",
    "mind", "mine", "mini", "mink", "mint", "minx", "mire",
    "miss", "mist", "mite", "mitt", "moan", "moat", "mobs",
    "mock", "mode", "mods", "mole", "moll", "molt", "moms",
    "monk", "mono", "mood", "moon", "moor", "moos", "moot",
    "mope", "mops", "more", "morn", "mosh", "moss", "most",
    "mote", "moth", "move", "mows", "much", "muck", "muff",
    "mugs", "mule", "mull", "mums", "murk", "muse", "mush",
    "musk", "muss", "must", "mute", "mutt", "myna", "myth",
    "nabs", "naff", "nags", "nail", "name", "nans", "nape",
    "naps", "narc", "nary", "nave", "navy", "nays", "near",
    "neat", "neck", "need", "negs", "neon", "nerd", "nest",
    "nets", "nett", "news", "newt", "next", "nibs", "nice",
    "nick", "niff", "nigh", "nils", "nine", "nips", "nits",
    "nobs", "node", "nods", "noel", "noes", "none", "nook",
    "noon", "nope", "norm", "nose", "nosh", "note", "noun",
    "nous", "nova", "nowt", "nubs", "nude", "nuke", "null",
    "numb", "nuns", "nuts", "oafs", "oaks", "oars", "oath",
    "oats", "obey", "obit", "oboe", "odds", "odes", "offs",
    "ogle", "ogre", "ohms", "ohos", "oiks", "oils", "oily",
    "oink", "okay", "okra", "oleo", "omen", "omit", "once",
    "ones", "only", "onto", "onus", "onyx", "oohs", "oops",
    "ooze", "oozy", "opal", "open", "opts", "opus", "oral",
    "orbs", "ores", "orgy", "ouch", "ours", "oust", "outs",
    "ouzo", "oval", "oven", "over", "ovum", "owed", "owes",
    "owls", "owns", "oxen", "oxes", "pace", "pack", "pact",
    "pacy", "pads", "page", "paid", "pail", "pain", "pair",
    "pale", "pall", "palm", "pals", "pane", "pang", "pans",
    "pant", "papa", "paps", "para", "pare", "park", "pars",
    "part", "pass", "past", "pate", "path", "pats", "pave",
    "pawl", "pawn", "paws", "pays", "peak", "peal", "pear",
    "peas", "peat", "peck", "pecs", "peed", "peek", "peel",
    "peep", "peer", "pees", "pegs", "peke", "pelt", "pens",
    "pent", "peon", "peps", "perk", "perm", "pert", "peso",
    "pest", "pets", "pews", "phew", "pica", "pick", "pics",
    "pied", "pier", "pies", "pigs", "pike", "pile", "pill",
    "pimp", "pine", "ping", "pink", "pins", "pint", "piny",
    "pipe", "pips", "piss", "pita", "pith", "pits", "pity",
    "plan", "play", "plea", "pleb", "plod", "plop", "plot",
    "ploy", "plug", "plum", "plus", "pock", "pods", "poem",
    "poet", "poke", "poky", "pole", "poll", "polo", "pols",
    "poly", "pomp", "poms", "pond", "pone", "pong", "pony",
    "poof", "pooh", "pool", "poop", "poor", "poos", "pope",
    "pops", "pore", "pork", "porn", "port", "pose", "posh",
    "post", "posy", "pots", "pouf", "pour", "pout", "poxy",
    "pram", "prat", "pray", "prep", "prey", "prig", "prim",
    "prod", "prof", "prom", "prop", "pros", "prow", "psst",
    "pubs", "puce", "puck", "puds", "puff", "pugs", "puke",
    "pull", "pulp", "puma", "pump", "punk", "puns", "punt",
    "puny", "pupa", "pups", "pure", "purl", "purr", "push",
    "puss", "puts", "putt", "putz", "pyre", "quad", "quay",
    "quid", "quin", "quip", "quit", "quiz", "race", "rack",
    "racy", "raft", "raga", "rage", "rags", "raid", "rail",
    "rain", "rake", "ramp", "rams", "rand", "rang", "rank",
    "rant", "rape", "raps", "rapt", "rare", "rash", "rasp",
    "rate", "rats", "rave", "rays", "raze", "razz", "read",
    "real", "ream", "reap", "rear", "redo", "reds", "reed",
    "reef", "reek", "reel", "refs", "rein", "rely", "rend",
    "rent", "reps", "rest", "revs", "rhea", "ribs", "rice",
    "rich", "rick", "ride", "rids", "rife", "riff", "rift",
    "rigs", "rile", "rill", "rime", "rims", "rind", "ring",
    "rink", "riot", "ripe", "rips", "rise", "risk", "rite",
    "rive", "road", "roam", "roan", "roar", "robe", "robs",
    "rock", "rode", "rods", "roes", "roil", "role", "roll",
    "romp", "rood", "roof", "rook", "room", "root", "rope",
    "rose", "rosy", "rota", "rote", "rots", "rout", "roux",
    "rove", "rows", "rube", "rubs", "ruby", "ruck", "rude",
    "rued", "rues", "ruff", "rugs", "ruin", "rule", "rump",
    "rums", "rune", "rung", "runs", "runt", "ruse", "rush",
    "rusk", "rust", "ruts", "sack", "sacs", "safe", "saga",
    "sage", "sago", "sags", "said", "sail", "sake", "sale",
    "salt", "same", "sand", "sane", "sang", "sank", "sans",
    "saps", "sari", "sash", "sass", "sate", "save", "saws",
    "says", "scab", "scad", "scam", "scan", "scar", "scat",
    "scow", "scud", "scum", "seal", "seam", "sear", "seas",
    "seat", "secs", "sect", "seed", "seek", "seem", "seen",
    "seep", "seer", "sees", "self", "sell", "semi", "send",
    "sent", "sere", "serf", "sets", "sett", "sewn", "sews",
    "sexy", "shad", "shag", "shah", "sham", "shat", "shed",
    "shes", "shim", "shin", "ship", "shit", "shod", "shoe",
    "shoo", "shop", "shot", "show", "shun", "shut", "sick",
    "sics", "side", "sift", "sigh", "sign", "silk", "sill",
    "silo", "silt", "sine", "sing", "sink", "sins", "sips",
    "sire", "sirs", "site", "sits", "size", "skew", "skid",
    "skim", "skin", "skip", "skis", "skit", "skua", "slab",
    "slag", "slam", "slap", "slat", "slaw", "slay", "sled",
    "slew", "slid", "slim", "slip", "slit", "slob", "sloe",
    "slog", "slop", "slot", "slow", "slue", "slug", "slum",
    "slur", "slut", "smog", "smug", "smut", "snag", "snap",
    "snip", "snit", "snob", "snog", "snot", "snow", "snub",
    "snug", "soak", "soap", "soar", "sobs", "sock", "soda",
    "sods", "sofa", "soft", "soil", "sold", "sole", "solo",
    "sols", "some", "song", "sons", "soon", "soot", "sops",
    "sore", "sort", "sots", "souk", "soul", "soup", "sour",
    "sown", "sows", "spam", "span", "spar", "spas", "spat",
    "spay", "spec", "sped", "spew", "spic", "spin", "spit",
    "spiv", "spot", "spry", "spud", "spun", "spur", "stab",
    "stag", "star", "stay", "stem", "step", "stew", "stir",
    "stop", "stow", "stub", "stud", "stun", "subs", "such",
    "suck", "suds", "sued", "sues", "suet", "suit", "sulk",
    "sumo", "sump", "sums", "sung", "sunk", "suns", "sups",
    "sure", "surf", "suss", "swab", "swag", "swam", "swan",
    "swap", "swat", "sway", "swig", "swim", "swiz", "swot",
    "swum", "sync", "tabs", "tack", "taco", "tact", "tads",
    "tags", "tail", "take", "talc", "tale", "talk", "tall",
    "tame", "tamp", "tams", "tang", "tank", "tans", "tape",
    "taps", "tare", "tarn", "taro", "tarp", "tars", "tart",
    "task", "tats", "taut", "taxi", "teak", "teal", "team",
    "tear", "teas", "teat", "teds", "teed", "teem", "teen",
    "tees", "tell", "temp", "tend", "tens", "tent", "term",
    "tern", "test", "text", "than", "that", "thaw", "thee",
    "them", "then", "they", "thin", "this", "thou", "thud",
    "thug", "thus", "tick", "tics", "tide", "tidy", "tied",
    "tier", "ties", "tiff", "tile", "till", "tilt", "time",
    "ting", "tins", "tint", "tiny", "tips", "tits", "tizz",
    "toad", "toed", "toes", "toff", "tofu", "toga", "togs",
    "toil", "toke", "told", "toll", "tomb", "tome", "toms",
    "tone", "tong", "tons", "tony", "took", "tool", "toot",
    "tops", "tore", "torn", "tors", "tort", "tosh", "toss",
    "tote", "tots", "tour", "tout", "town", "tows", "toys",
    "trad", "tram", "trap", "tray", "tree", "trek", "trig",
    "trim", "trio", "trip", "trod", "trot", "troy", "true",
    "trug", "tuba", "tube", "tubs", "tuck", "tuft", "tugs",
    "tums", "tuna", "tune", "tuns", "turd", "turf", "turn",
    "tush", "tusk", "tuts", "tutu", "twat", "twee", "twig",
    "twin", "twit", "twos", "tyke", "type", "typo", "tyro",
    "ugly", "ulna", "umps", "undo", "unis", "unit", "unto",
    "upon", "urea", "urge", "uric", "urns", "used", "user",
    "uses", "vacs", "vain", "vale", "vamp", "vane", "vans",
    "vary", "vase", "vast", "vats", "veal", "veep", "veer",
    "veil", "vein", "veld", "vend", "vent", "verb", "very",
    "vest", "veto", "vets", "vial", "vibe", "vice", "vied",
    "vies", "view", "vile", "vine", "vino", "viol", "visa",
    "vise", "viva", "void", "vole", "volt", "vote", "vows",
    "wade", "wadi", "wads", "waft", "wage", "wags", "waif",
    "wail", "wait", "wake", "wale", "walk", "wall", "wand",
    "wane", "wank", "want", "ward", "ware", "warm", "warn",
    "warp", "wars", "wart", "wary", "wash", "wasp", "watt",
    "wave", "wavy", "waxy", "ways", "weak", "weal", "wean",
    "wear", "webs", "weds", "weed", "week", "weep", "weer",
    "wees", "weft", "weir", "weld", "well", "welt", "wend",
    "wens", "went", "wept", "were", "west", "wets", "wham",
    "what", "when", "whet", "whew", "whey", "whim", "whip",
    "whir", "whit", "whoa", "whom", "whop", "whup", "whys",
    "wick", "wide", "wife", "wigs", "wild", "wile", "will",
    "wilt", "wily", "wimp", "wind", "wine", "wing", "wink",
    "wino", "wins", "wipe", "wire", "wiry", "wise", "wish",
    "wisp", "wist", "with", "wits", "wive", "woad", "woes",
    "wogs", "woke", "woks", "wold", "wolf", "womb", "wonk",
    "wont", "wood", "woof", "wool", "woos", "wops", "word",
    "wore", "work", "worm", "worn", "wost", "wove", "wows",
    "wrap", "wren", "writ", "wuss", "yaks", "yams", "yang",
    "yank", "yaps", "yard", "yarn", "yawl", "yawn", "yaws",
    "yeah", "year", "yeas", "yell", "yelp", "yens", "yeps",
    "yest", "yeti", "yews", "yids", "yips", "yobs", "yoga",
    "yogi", "yoke", "yolk", "yore", "your", "yous", "yowl",
    "yuan", "yuck", "yuks", "yule", "yups", "zany", "zaps",
    "zeal", "zebu", "zeds", "zero", "zest", "zeta", "zinc",
    "zine", "zing", "zips", "zits", "zone", "zoom", "zoos"
  };

  const char* w_5[] = {
    "aback", "abaft", "abase", "abash", "abate", "abbey", "abbot",
    "abeam", "abets", "abhor", "abide", "abler", "ables", "abode",
    "abort", "about", "above", "abuse", "abuts", "abuzz", "abyss",
    "ached", "aches", "achoo", "acids", "acing", "acmes", "acorn",
    "acres", "acrid", "acted", "actor", "acute", "adage", "adapt",
    "added", "adder", "addle", "adept", "adieu", "adman", "admen",
    "admit", "adobe", "adopt", "adore", "adorn", "adult", "adzes",
    "aegis", "aerie", "affix", "afire", "afoot", "afoul", "after",
    "again", "agape", "agate", "agave", "agent", "aggro", "agile",
    "aglow", "agony", "agree", "ahead", "ahems", "ahoys", "aided",
    "aides", "ailed", "aimed", "aired", "aisle", "aitch", "alarm",
    "album", "alder", "alert", "algae", "algal", "alias", "alibi",
    "alien", "align", "alike", "alive", "allay", "alley", "allot",
    "allow", "alloy", "aloes", "aloft", "aloha", "alone", "along",
    "aloof", "aloud", "alpha", "altar", "alter", "altos", "alums",
    "amass", "amaze", "amber", "ambit", "amble", "amend", "amens",
    "amids", "amigo", "amiss", "amity", "among", "amour", "amped",
    "ample", "amply", "amuse", "angel", "anger", "angle", "angry",
    "angst", "anion", "anise", "ankhs", "ankle", "annex", "annoy",
    "annul", "anode", "anons", "anted", "antes", "antic", "antis",
    "antsy", "anvil", "aorta", "apace", "apart", "aphid", "aping",
    "apple", "apply", "apron", "apses", "apter", "aptly", "aquas",
    "arced", "areas", "arena", "argon", "argot", "argue", "arias",
    "arise", "armed", "aroma", "arose", "array", "arrow", "arsed",
    "arson", "artsy", "ascot", "ashed", "ashen", "ashes", "aside",
    "asked", "askew", "aspen", "aspic", "assay", "asset", "aster",
    "astir", "atlas", "atoll", "atoms", "atone", "atria", "attar",
    "attic", "audio", "audit", "auger", "aught", "augur", "aunts",
    "aural", "auras", "autos", "avail", "avast", "avers", "avert",
    "avian", "avoid", "avows", "await", "awake", "award", "aware",
    "awash", "aways", "awful", "awing", "awoke", "axial", "axing",
    "axiom", "axles", "axons", "azure", "baaed", "babel", "babes",
    "baccy", "backs", "bacon", "badge", "badly", "bagel", "baggy",
    "bails", "bairn", "baits", "baize", "baked", "baker", "bakes",
    "balds", "baldy", "baled", "bales", "balks", "balky", "balls",
    "bally", "balms", "balmy", "balsa", "banal", "bands", "bandy",
    "baned", "banes", "bangs", "banjo", "banks", "banns", "barbs",
    "bards", "bared", "barer", "bares", "barfs", "barge", "barks",
    "barmy", "barns", "baron", "basal", "based", "baser", "bases",
    "basic", "basil", "basin", "basis", "basks", "basso", "baste",
    "basts", "batch", "bated", "bates", "bathe", "baths", "batik",
    "baton", "batty", "baulk", "bawdy", "bawls", "bayed", "bayou",
    "beach", "beads", "beady", "beaks", "beams", "beans", "beard",
    "bears", "beast", "beats", "beaus", "beaut", "bebop", "becks",
    "beech", "beefs", "beefy", "beeps", "beers", "beery", "beets",
    "befit", "befog", "began", "beget", "begin", "begot", "begum",
    "begun", "beige", "being", "belay", "belch", "belie", "belle",
    "bells", "belly", "below", "belts", "bench", "bends", "bendy",
    "bents", "beret", "bergs", "berks", "berms", "berry", "berth",
    "beryl", "beset", "besom", "besot", "bests", "betas", "betel",
    "bevel", "bevvy", "bhaji", "bible", "bicep", "biddy", "bides",
    "bidet", "biers", "biffs", "bight", "bigot", "bijou", "biked",
    "biker", "bikes", "bilge", "bilks", "bills", "billy", "bimbo",
    "binds", "binge", "bingo", "biped", "birch", "birds", "birth",
    "bison", "bitch", "bites", "bitty", "blabs", "black", "blade",
    "blags", "blahs", "blame", "bland", "blank", "blare", "blast",
    "blaze", "bleak", "bleat", "bleed", "bleep", "blend", "bless",
    "blimp", "blind", "blink", "blips", "bliss", "blitz", "bloat",
    "blobs", "block", "blocs", "bloke", "blond", "blood", "bloom",
    "blots", "blown", "blows", "blowy", "blued", "bluer", "blues",
    "bluff", "blunt", "blurb", "blurs", "blurt", "blush", "board",
    "boars", "boast", "boats", "bobby", "boded", "bodes", "bodge",
    "bogey", "boggy", "bogus", "boils", "bolas", "bolds", "boles",
    "bolls", "bolts", "bombs", "bonce", "bonds", "boned", "boner",
    "bones", "bongo", "bongs", "bonks", "bonny", "bonus", "boobs",
    "booby", "booed", "books", "booms", "boons", "boors", "boost",
    "booth", "boots", "booty", "booze", "boozy", "borax", "bored",
    "borer", "bores", "borne", "boron", "bosom", "bossy", "botch",
    "bough", "bound", "bouts", "bowed", "bowel", "bower", "bowls",
    "boxed", "boxer", "boxes", "bozos", "brace", "bract", "brads",
    "brags", "braid", "brain", "brake", "brand", "brash", "brass",
    "brats", "brave", "bravo", "brawl", "brawn", "brays", "bread",
    "break", "bream", "breed", "brews", "bribe", "brick", "bride",
    "brief", "brier", "brigs", "brill", "brims", "brine", "bring",
    "brink", "briny", "brisk", "broad", "broil", "broke", "brood",
    "brook", "broom", "broth", "brown", "brows", "bruin", "bruit",
    "brunt", "brush", "brute", "bucks", "buddy", "budge", "buffs",
    "buggy", "bugle", "build", "built", "bulbs", "bulge", "bulgy",
    "bulks", "bulky", "bulls", "bully", "bumph", "bumps", "bumpy",
    "bunch", "bungs", "bunks", "bunny", "bunts", "buoys", "burgh",
    "burgs", "burks", "burly", "burns", "burnt", "burps", "burro",
    "burrs", "burst", "busby", "bused", "buses", "bushy", "busks",
    "busts", "busty", "butch", "butte", "butts", "butty", "buxom",
    "buyer", "bylaw", "byres", "bytes", "byway", "cabal", "caber",
    "cabin", "cable", "cacao", "cache", "cacti", "cadet", "cadge",
    "cadre", "caffs", "caged", "cages", "cagey", "cairn", "caked",
    "cakes", "calls", "calms", "calve", "calyx", "camel", "cameo",
    "camps", "campy", "canal", "candy", "caned", "canes", "canny",
    "canoe", "canon", "canto", "cants", "caped", "caper", "capes",
    "capon", "carat", "cards", "cared", "carer", "cares", "caret",
    "cargo", "carob", "carol", "carom", "carpi", "carps", "carry",
    "carts", "carve", "cased", "cases", "casks", "caste", "casts",
    "catch", "cater", "catty", "caulk", "cause", "caved", "caver",
    "caves", "cavil", "cawed", "cease", "cedar", "ceded", "cedes",
    "celeb", "cello", "cells", "cents", "certs", "chafe", "chaff",
    "chain", "chair", "chalk", "champ", "chant", "chaos", "chaps",
    "chard", "charm", "chars", "chart", "chary", "chase", "chasm",
    "chats", "cheap", "cheat", "cheek", "cheep", "cheer", "chefs",
    "chess", "chest", "chews", "chewy", "chick", "chide", "chief",
    "child", "chili", "chill", "chime", "chimp", "china", "chink",
    "chino", "chins", "chips", "chirp", "chits", "chive", "chivy",
    "chock", "chocs", "choir", "choke", "chomp", "chops", "chord",
    "chore", "chose", "chows", "chuck", "chugs", "chump", "chums",
    "chunk", "churl", "churn", "chute", "cider", "cigar", "ciggy",
    "cilia", "cinch", "circa", "cissy", "cited", "cites", "civet",
    "civic", "civil", "clack", "claim", "clamp", "clams", "clang",
    "clank", "clans", "claps", "clash", "clasp", "class", "claws",
    "clean", "clear", "cleat", "clefs", "cleft", "clerk", "clews",
    "click", "cliff", "climb", "clime", "cling", "clink", "clips",
    "cloak", "clock", "clods", "clogs", "clomp", "clone", "clonk",
    "clops", "close", "cloth", "clots", "cloud", "clout", "clove",
    "clown", "cloys", "clubs", "cluck", "clued", "clues", "clump",
    "clung", "clunk", "coach", "coals", "coast", "coats", "cobra",
    "cocci", "cocks", "cocky", "cocoa", "codas", "coded", "codes",
    "codex", "coeds", "coifs", "coils", "coins", "coked", "cokes",
    "colas", "colds", "coled", "coley", "colic", "colon", "colts",
    "comae", "comas", "combo", "combs", "comer", "comes", "comet",
    "comfy", "comic", "comma", "conch", "condo", "coned", "cones",
    "conga", "conic", "conks", "cooed", "cooks", "cools", "coons",
    "coops", "coots", "coped", "copes", "copra", "copse", "coral",
    "cords", "cored", "cores", "corgi", "corks", "corms", "corns",
    "corny", "corps", "costs", "cotes", "couch", "cough", "could",
    "count", "coupe", "coups", "court", "coven", "cover", "coves",
    "covet", "covey", "cowed", "cower", "cowls", "coxed", "coxes",
    "coyer", "coyly", "coypu", "cozen", "crabs", "crack", "craft",
    "crags", "cramp", "crams", "crane", "crank", "crape", "craps",
    "crash", "crass", "crate", "crave", "crawl", "craws", "craze",
    "crazy", "creak", "cream", "credo", "creed", "creek", "creel",
    "creep", "crepe", "crept", "cress", "crest", "crews", "cribs",
    "crick", "cried", "crier", "cries", "crime", "crimp", "crisp",
    "croak", "crock", "croft", "crone", "crony", "crook", "croon",
    "crops", "cross", "croup", "crowd", "crown", "crows", "crude",
    "cruel", "cruet", "crumb", "crush", "crust", "crypt", "cubed",
    "cubes", "cubic", "cubit", "cuffs", "cuing", "culls", "cults",
    "cumin", "cunts", "cupid", "cuppa", "curds", "cured", "curer",
    "cures", "curie", "curio", "curls", "curly", "curry", "curse",
    "curve", "curvy", "cushy", "cusps", "cuter", "cutes", "cutey",
    "cutie", "cutup", "cycle", "cynic", "cysts", "dacha", "daddy",
    "daffy", "dagos", "daily", "dairy", "daisy", "dales", "dally",
    "dames", "damns", "damps", "dance", "dandy", "dared", "dares",
    "darns", "darts", "dated", "dates", "datum", "daubs", "daunt",
    "davit", "dawns", "dazed", "dazes", "deals", "dealt", "deans",
    "dears", "deary", "death", "debar", "debit", "debts", "debug",
    "debut", "decaf", "decal", "decay", "decks", "decor", "decoy",
    "decry", "deeds", "deems", "deeps", "defer", "defog", "deice",
    "deify", "deign", "deism", "deity", "delay", "delis", "dells",
    "delta", "delve", "demob", "demon", "demos", "demur", "denim",
    "dense", "dents", "depot", "depth", "derby", "desks", "deter",
    "detox", "deuce", "devil", "dhoti", "dhows", "dials", "diary",
    "diced", "dices", "dicey", "dicks", "dicta", "diets", "digit",
    "dikes", "dildo", "dills", "dilly", "dimer", "dimes", "dimly",
    "dinar", "dined", "diner", "dines", "dingo", "dings", "dingy",
    "dinky", "diode", "dippy", "dipso", "direr", "dirge", "dirks",
    "dirty", "disco", "discs", "dishy", "disks", "ditch", "ditto",
    "ditty", "divan", "divas", "dived", "diver", "dives", "divot",
    "divvy", "dizzy", "docks", "dodge", "dodgy", "dodos", "doers",
    "doest", "doffs", "doggy", "dogie", "dogma", "doily", "doing",
    "doled", "doles", "dolls", "dolly", "dolts", "domed", "domes",
    "donor", "dooms", "doors", "doped", "dopes", "dopey", "dorks",
    "dorky", "dorms", "dosed", "doses", "doted", "dotes", "dotty",
    "doubt", "dough", "douse", "doves", "dowdy", "dowel", "downs",
    "downy", "dowry", "dowse", "doyen", "dozed", "dozen", "dozes",
    "drabs", "drags", "drain", "drake", "drama", "drams", "drank",
    "drape", "drawl", "drawn", "draws", "drays", "dread", "dream",
    "drear", "dregs", "dress", "dried", "drier", "dries", "drift",
    "drill", "drink", "drips", "drive", "droll", "drone", "drool",
    "droop", "drops", "dross", "drove", "drown", "drubs", "drugs",
    "druid", "drums", "drunk", "dryad", "dryer", "dryly", "ducal",
    "ducat", "duchy", "ducks", "ducky", "ducts", "duded", "dudes",
    "duels", "duets", "duffs", "duked", "dukes", "dulls", "dully",
    "dumbo", "dumbs", "dummy", "dumps", "dumpy", "dunce", "dunes",
    "dungs", "dunks", "dunno", "duped", "dupes", "dusky", "dusts",
    "dusty", "duvet", "dwarf", "dweeb", "dwell", "dwelt", "dyers",
    "dying", "eager", "eagle", "earls", "early", "earns", "earth",
    "eased", "easel", "eases", "eaten", "eater", "eaves", "ebbed",
    "ebony", "edged", "edger", "edges", "edict", "edify", "edits",
    "eerie", "effed", "egged", "egret", "eider", "eight", "eject",
    "eking", "elate", "elbow", "elder", "elect", "elegy", "elfin",
    "elide", "elite", "elope", "elude", "elves", "email", "embed",
    "ember", "emcee", "emend", "emery", "emirs", "emits", "emote",
    "empty", "enact", "ended", "endow", "endue", "enema", "enemy",
    "enjoy", "ennui", "ensue", "enter", "entry", "envoy", "epics",
    "epoch", "epoxy", "equal", "equip", "erase", "erect", "erode",
    "erred", "error", "erupt", "essay", "ester", "ether", "ethic",
    "ethos", "euros", "evade", "evens", "event", "every", "evict",
    "evils", "evoke", "ewers", "exact", "exalt", "exams", "excel",
    "execs", "exert", "exile", "exist", "exits", "expat", "expel",
    "expos", "extol", "extra", "exude", "exult", "fable", "faced",
    "faces", "facet", "facts", "faddy", "faded", "fades", "faffs",
    "fails", "fains", "faint", "fairs", "fairy", "faith", "faked",
    "faker", "fakes", "fakir", "falls", "false", "famed", "fancy",
    "fangs", "fanny", "farce", "fared", "fares", "farms", "farts",
    "fasts", "fatal", "fated", "fates", "fatso", "fatty", "fatwa",
    "fault", "fauna", "fauns", "faves", "fawns", "faxed", "faxes",
    "fazed", "fazes", "fears", "feast", "feats", "fecal", "feces",
    "feeds", "feels", "feign", "feint", "fella", "fells", "felon",
    "felts", "femur", "fence", "fends", "feral", "ferns", "ferny",
    "ferry", "fests", "fetch", "feted", "fetid", "feuds", "fever",
    "fewer", "fiats", "fiche", "fiefs", "field", "fiend", "fiery",
    "fifes", "fifth", "fifty", "fight", "filch", "filed", "files",
    "fills", "filly", "films", "filmy", "filth", "final", "finch",
    "finds", "fined", "finer", "fines", "finis", "finks", "finny",
    "fired", "fires", "firms", "first", "firth", "fishy", "fists",
    "fitly", "fiver", "fives", "fixed", "fixer", "fixes", "fizzy",
    "fjord", "flack", "flags", "flail", "flair", "flake", "flaks",
    "flaky", "flame", "flank", "flans", "flaps", "flare", "flash",
    "flask", "flats", "flaws", "flays", "fleas", "fleck", "flees",
    "fleet", "flesh", "flick", "flied", "flier", "flies", "fling",
    "flint", "flips", "flirt", "flits", "float", "flock", "floes",
    "flogs", "flood", "floor", "flops", "flora", "floss", "flour",
    "flout", "flown", "flows", "flubs", "flues", "fluff", "fluid",
    "fluke", "fluky", "flume", "flung", "flunk", "flush", "flute",
    "flyby", "foals", "foams", "foamy", "focal", "focus", "foggy",
    "foils", "foist", "folds", "folio", "folks", "folly", "fonds",
    "fonts", "foods", "fools", "foots", "footy", "foray", "force",
    "fords", "fores", "forge", "forgo", "forks", "forms", "forte",
    "forth", "forts", "forty", "forum", "fouls", "found", "fount",
    "fours", "fowls", "foxed", "foxes", "foyer", "frail", "frame",
    "franc", "frank", "frats", "fraud", "frays", "freak", "freed",
    "freer", "frees", "fresh", "frets", "friar", "fried", "fries",
    "frigs", "frill", "frisk", "frizz", "frock", "frogs", "frond",
    "front", "frosh", "frost", "froth", "frown", "froze", "fruit",
    "frump", "fryer", "fucks", "fudge", "fuels", "fuggy", "fugue",
    "fulls", "fully", "fumed", "fumes", "funds", "fungi", "funks",
    "funky", "funny", "furls", "furor", "furry", "furze", "fused",
    "fuses", "fussy", "fusty", "futon", "fuzzy", "gabby", "gable",
    "gaffe", "gaffs", "gaily", "gains", "gaits", "galas", "gales",
    "galls", "gamed", "gamer", "games", "gamin", "gamma", "gammy",
    "gamut", "gangs", "ganja", "gaols", "gaped", "gapes", "garbs",
    "gases", "gasps", "gassy", "gated", "gates", "gator", "gaudy",
    "gaunt", "gauze", "gauzy", "gavel", "gawks", "gawky", "gawps",
    "gayer", "gazed", "gazer", "gazes", "gears", "gecko", "geeks",
    "geeky", "geese", "gelds", "gelid", "genes", "genie", "genii",
    "genre", "gents", "genus", "geode", "germs", "getup", "ghost",
    "ghoul", "giant", "gibed", "gibes", "giddy", "gifts", "gilds",
    "gills", "gilts", "gimme", "gimpy", "girds", "girls", "giros",
    "girth", "girts", "gites", "given", "giver", "gives", "glade",
    "glads", "gland", "glare", "glass", "glaze", "gleam", "glean",
    "glens", "glide", "glint", "glitz", "gloat", "globe", "globs",
    "gloom", "glops", "glory", "gloss", "glove", "glows", "glued",
    "glues", "gluey", "glums", "gluts", "glyph", "gnarl", "gnash",
    "gnats", "gnaws", "gnome", "goads", "goals", "goats", "godly",
    "goers", "gofer", "going", "golds", "golfs", "golly", "gonad",
    "goner", "gongs", "gonna", "goods", "goody", "gooey", "goofs",
    "goofy", "gooks", "goons", "goose", "gored", "gores", "gorge",
    "gorse", "goths", "gotta", "gouge", "gourd", "gouty", "gowns",
    "grabs", "grace", "grade", "grads", "graft", "grail", "grain",
    "grams", "grand", "grans", "grant", "grape", "graph", "grasp",
    "grass", "grate", "grave", "gravy", "graze", "great", "grebe",
    "greed", "green", "greet", "grids", "grief", "grill", "grime",
    "grimy", "grind", "grins", "gripe", "grips", "grist", "grits",
    "groan", "groin", "groom", "grope", "gross", "group", "grout",
    "grove", "growl", "grown", "grows", "grubs", "gruel", "gruff",
    "grump", "grunt", "guano", "guard", "guava", "guess", "guest",
    "guide", "guild", "guile", "guilt", "guise", "gulag", "gulch",
    "gulfs", "gulls", "gully", "gulps", "gumbo", "gummy", "gunge",
    "gungy", "gunny", "guppy", "gurus", "gushy", "gusto", "gusts",
    "gusty", "gutsy", "guyed", "gypsy", "gyros", "habit", "hacks",
    "haded", "hades", "hafts", "haiku", "hails", "hairs", "hairy",
    "hakes", "halal", "haled", "haler", "hales", "hallo", "halls",
    "halon", "halos", "halts", "halve", "hammy", "hands", "handy",
    "hangs", "hanks", "happy", "hardy", "hared", "harem", "hares",
    "harks", "harms", "harps", "harpy", "harry", "harsh", "harts",
    "hasps", "haste", "hasty", "hatch", "hated", "hater", "hates",
    "hauls", "haunt", "haven", "haves", "havoc", "hawed", "hawks",
    "hayed", "hazed", "hazel", "hazes", "heads", "heady", "heals",
    "heaps", "heard", "hears", "heart", "heath", "heats", "heave",
    "heavy", "hedge", "heeds", "heels", "hefts", "hefty", "heirs",
    "heist", "helix", "hello", "hells", "helms", "helot", "helps",
    "hence", "henna", "herbs", "herds", "heron", "hertz", "hewed",
    "hewer", "hexed", "hexes", "hicks", "hided", "hides", "highs",
    "hiked", "hiker", "hikes", "hills", "hilly", "hilts", "hinds",
    "hinge", "hints", "hippo", "hired", "hires", "hitch", "hived",
    "hives", "hoard", "hoary", "hobby", "hobos", "hocks", "hogan",
    "hoick", "hoist", "hokey", "hokum", "holds", "holed", "holes",
    "holly", "homed", "homer", "homes", "homey", "honed", "honer",
    "hones", "honey", "honks", "honky", "hooch", "hoods", "hooey",
    "hoofs", "hooks", "hooky", "hoops", "hoots", "hoped", "hopes",
    "horde", "horns", "horny", "horse", "hosed", "hoses", "hosts",
    "hotel", "hotly", "hound", "hours", "house", "hovel", "hover",
    "howdy", "howls", "hubby", "huffs", "huffy", "huger", "hulas",
    "hulks", "hullo", "hulls", "human", "humid", "humph", "humps",
    "humus", "hunch", "hunks", "hunky", "hunts", "hurls", "hurry",
    "hurts", "husks", "husky", "hussy", "hutch", "hydra", "hyena",
    "hying", "hymen", "hymns", "hyped", "hyper", "hypes", "hypos",
    "iambs", "icier", "icily", "icing", "icons", "ideal", "ideas",
    "idiom", "idiot", "idled", "idler", "idles", "idols", "idyll",
    "igloo", "image", "imams", "imbue", "impel", "imply", "inane",
    "inapt", "incur", "index", "indie", "inept", "inert", "infer",
    "infix", "ingot", "inked", "inlay", "inlet", "inned", "inner",
    "innit", "input", "inset", "inter", "inure", "iotas", "irate",
    "iring", "irked", "irons", "irony", "isles", "islet", "issue",
    "itchy", "items", "ivied", "ivies", "ivory", "jabot", "jacks",
    "jaded", "jades", "jails", "jambs", "jammy", "japan", "japed",
    "japes", "jaunt", "jawed", "jazzy", "jeans", "jeeps", "jeers",
    "jells", "jelly", "jemmy", "jerks", "jerky", "jests", "jetty",
    "jewel", "jiffy", "jihad", "jilts", "jimmy", "jinks", "jinns",
    "jived", "jives", "jocks", "joeys", "johns", "joins", "joint",
    "joist", "joked", "joker", "jokes", "jokey", "jolly", "jolts",
    "joule", "joust", "jowls", "jowly", "joyed", "judge", "juice",
    "juicy", "julep", "jumbo", "jumps", "jumpy", "junco", "junks",
    "junta", "juror", "kabob", "kapok", "kaput", "karat", "karma",
    "karts", "kayak", "kazoo", "kebab", "keels", "keens", "keeps",
    "ketch", "keyed", "khaki", "khans", "kicks", "kicky", "kiddo",
    "kikes", "kills", "kilns", "kilos", "kilts", "kinda", "kinds",
    "kings", "kinks", "kinky", "kiosk", "kirks", "kited", "kites",
    "kiths", "kitty", "kiwis", "klutz", "knack", "knave", "knead",
    "kneed", "kneel", "knees", "knell", "knelt", "knife", "knits",
    "knobs", "knock", "knoll", "knots", "known", "knows", "koala",
    "kooks", "kooky", "korma", "krill", "krone", "kudos", "kudzu",
    "label", "labia", "laced", "laces", "lacks", "laded", "laden",
    "lades", "ladle", "lager", "laird", "lairs", "laity", "laked",
    "lakes", "lamas", "lambs", "lamed", "lamer", "lames", "lamps",
    "lance", "lands", "lanes", "lanky", "lapel", "lapse", "larch",
    "lards", "large", "largo", "larks", "larva", "laser", "lasso",
    "lasts", "latch", "later", "latex", "lathe", "laths", "latte",
    "lauds", "laugh", "lawns", "laxer", "laxes", "laxly", "layer",
    "lazed", "lazes", "leach", "leads", "leafs", "leafy", "leaks",
    "leaky", "leans", "leaps", "learn", "lease", "leash", "least",
    "leave", "ledge", "leech", "leeks", "leers", "leery", "lefts",
    "lefty", "legal", "leggy", "legit", "lemma", "lemme", "lemon",
    "lemur", "lends", "leper", "letch", "letup", "levee", "level",
    "lever", "lexis", "liars", "libel", "licit", "licks", "lidos",
    "liefs", "liege", "liens", "lifer", "lifts", "light", "liked",
    "liken", "liker", "likes", "lilac", "lilos", "lilts", "limbo",
    "limbs", "limed", "limes", "limey", "limit", "limns", "limos",
    "limps", "lined", "linen", "liner", "lines", "lingo", "lings",
    "links", "lints", "lions", "lipid", "lippy", "lisle", "lisps",
    "lists", "lites", "lithe", "lived", "liven", "liver", "lives",
    "livid", "llama", "llano", "loads", "loafs", "loamy", "loans",
    "loath", "lobby", "lobed", "lobes", "local", "lochs", "locks",
    "locos", "locum", "locus", "lodes", "lodge", "lofts", "lofty",
    "loges", "logic", "logos", "loins", "lolls", "lolly", "loner",
    "longs", "looks", "looms", "loons", "loony", "loops", "loopy",
    "loose", "loots", "loped", "lopes", "lords", "lorry", "loser",
    "loses", "lotto", "lotus", "lough", "lours", "louse", "lousy",
    "louts", "loved", "lover", "loves", "lovey", "lowed", "lower",
    "lowly", "loxed", "loxes", "loyal", "luaus", "lubed", "lubes",
    "lucid", "lucks", "lucky", "lucre", "luges", "lulls", "lulus",
    "lumps", "lumpy", "lunar", "lunch", "lunge", "lungs", "lupus",
    "lurch", "lured", "lures", "lurgy", "lurid", "lurks", "lusts",
    "lusty", "lutes", "lying", "lymph", "lynch", "lyres", "lyric",
    "macaw", "maced", "maces", "macho", "macks", "macro", "madam",
    "madly", "mafia", "magic", "magma", "maids", "mails", "maims",
    "mains", "maize", "major", "maker", "makes", "males", "malls",
    "malts", "mamas", "mamba", "mambo", "mammy", "manes", "mange",
    "mango", "mangy", "mania", "manic", "manky", "manly", "manna",
    "manor", "manse", "maple", "march", "mares", "marge", "maria",
    "marks", "marry", "marsh", "marts", "masks", "mason", "masts",
    "match", "mated", "mater", "mates", "matey", "matte", "matzo",
    "mauls", "mauve", "maven", "mawed", "maxed", "maxes", "maxim",
    "maybe", "mayor", "mazes", "meals", "mealy", "means", "meant",
    "meats", "meaty", "mecca", "medal", "media", "medic", "meets",
    "melds", "melon", "melts", "memos", "mends", "menus", "mercy",
    "mered", "merer", "meres", "merge", "merit", "merry", "mesas",
    "messy", "metal", "meted", "metes", "meths", "metro", "mewed",
    "mewls", "mezzo", "micks", "micro", "middy", "midge", "midst",
    "miens", "miffs", "might", "miked", "mikes", "milch", "miler",
    "miles", "milks", "milky", "mills", "mimed", "mimes", "mimic",
    "mince", "minds", "mined", "miner", "mines", "mingy", "minim",
    "minis", "minks", "minor", "mints", "minty", "minus", "mired",
    "mires", "mirth", "misdo", "miser", "mists", "misty", "mites",
    "mitts", "mixed", "mixer", "mixes", "moans", "moats", "mocha",
    "mocks", "modal", "model", "modem", "moder", "modes", "moggy",
    "mogul", "moire", "moist", "molar", "moles", "molls", "molts",
    "momma", "mommy", "money", "monks", "month", "mooch", "moods",
    "moody", "mooed", "moons", "moors", "moose", "moots", "moped",
    "mopes", "moral", "moray", "mores", "morns", "moron", "moses",
    "mosey", "mossy", "motel", "motes", "motet", "moths", "motif",
    "motor", "motto", "moult", "mound", "mount", "mourn", "mouse",
    "mousy", "mouth", "moved", "mover", "moves", "movie", "mowed",
    "mower", "moxie", "mucks", "mucky", "mucus", "muddy", "muffs",
    "mufti", "muggy", "mulch", "muled", "mules", "mulls", "mummy",
    "mumps", "munch", "mural", "murks", "murky", "mused", "muses",
    "mushy", "music", "musks", "musky", "mussy", "musts", "musty",
    "muted", "muter", "mutes", "mutts", "muzak", "muzzy", "mynas",
    "myrrh", "myths", "nabob", "nacho", "nacre", "nadir", "naiad",
    "nails", "naive", "naked", "named", "names", "nanny", "napes",
    "nappy", "narcs", "narky", "nasal", "nasty", "natal", "natch",
    "natty", "naval", "navel", "naves", "navvy", "nears", "neath",
    "necks", "needs", "needy", "negro", "neigh", "nerds", "nerdy",
    "nerve", "nervy", "nests", "never", "newed", "newel", "newer",
    "newly", "newsy", "newts", "nexus", "nicer", "niche", "nicks",
    "niece", "niffy", "nifty", "night", "nimbi", "nimby", "nines",
    "ninja", "ninny", "ninth", "nippy", "nixed", "nixes", "noble",
    "nobly", "nodal", "noddy", "nodes", "noels", "nohow", "noise",
    "noisy", "nomad", "nonce", "nones", "nooks", "nooky", "noons",
    "noose", "nopes", "norms", "north", "nosed", "noses", "notch",
    "noted", "notes", "nouns", "novae", "novas", "novel", "noway",
    "nuder", "nudes", "nudge", "nuked", "nukes", "nulls", "numbs",
    "nurse", "nutty", "nylon", "nymph", "oaken", "oakum", "oared",
    "oases", "oasis", "oaten", "oaths", "obese", "obeys", "obits",
    "oboes", "occur", "ocean", "ocker", "octal", "octet", "odder",
    "oddly", "odium", "offal", "offed", "offer", "often", "ofter",
    "ogled", "ogles", "ogres", "oiled", "oinks", "okays", "okras",
    "olden", "older", "oldie", "olive", "omega", "omens", "omits",
    "onion", "onset", "oohed", "oomph", "oozed", "oozes", "opals",
    "opens", "opera", "opine", "opium", "opted", "optic", "orals",
    "orate", "orbit", "order", "organ", "osier", "other", "otter",
    "ought", "ounce", "ousts", "outdo", "outed", "outer", "outgo",
    "outta", "ouzos", "ovals", "ovary", "ovens", "overs", "overt",
    "ovoid", "ovule", "owing", "owlet", "owned", "owner", "oxbow",
    "oxide", "ozone", "paced", "paces", "pacey", "packs", "pacts",
    "paddy", "padre", "paean", "pagan", "paged", "pager", "pages",
    "pails", "pains", "paint", "pairs", "paled", "paler", "pales",
    "palls", "pally", "palms", "palmy", "palsy", "panda", "panel",
    "panes", "pangs", "panic", "pansy", "panto", "pants", "papal",
    "papas", "papaw", "paper", "pappy", "paras", "parch", "pared",
    "pares", "parka", "parks", "parky", "parry", "parse", "parts",
    "party", "pasha", "pasta", "paste", "pasts", "pasty", "patch",
    "pater", "pates", "paths", "patio", "patsy", "patty", "pause",
    "paved", "paves", "pawed", "pawls", "pawns", "payed", "payee",
    "payer", "peace", "peach", "peaks", "peaky", "peals", "pearl",
    "pears", "peaty", "pecan", "pecks", "pedal", "peeks", "peels",
    "peeps", "peers", "peeve", "pekes", "pekoe", "pelts", "penal",
    "pence", "pends", "penis", "penny", "pents", "peons", "peony",
    "peppy", "perch", "peril", "perks", "perky", "perms", "perts",
    "pervs", "pesky", "pesos", "pesto", "pests", "petal", "peter",
    "petty", "pewee", "phase", "phial", "phlox", "phone", "phony",
    "photo", "phyla", "piano", "picks", "picky", "piece", "piers",
    "piety", "piggy", "piing", "piked", "piker", "pikes", "pilaf",
    "piled", "piles", "pills", "pilot", "pimps", "pinch", "pined",
    "pines", "pings", "pinko", "pinks", "pinny", "pinto", "pints",
    "pinup", "pious", "piped", "piper", "pipes", "pipit", "pique",
    "piste", "pitas", "pitch", "pithy", "piton", "pitta", "pivot",
    "pixel", "pixie", "pizza", "place", "plaid", "plain", "plait",
    "plane", "plank", "plans", "plant", "plate", "plays", "plaza",
    "plead", "pleas", "pleat", "plebe", "plebs", "plied", "plies",
    "plods", "plonk", "plops", "plots", "ploys", "pluck", "plugs",
    "plumb", "plume", "plump", "plums", "plunk", "plush", "poach",
    "pocks", "poems", "poesy", "poets", "point", "poise", "poked",
    "poker", "pokes", "polar", "poled", "poles", "polio", "polka",
    "polls", "polyp", "pommy", "ponce", "poncy", "ponds", "pones",
    "pongs", "pooch", "pooed", "poofs", "poohs", "pools", "poops",
    "popes", "poppa", "poppy", "porch", "pored", "pores", "porky",
    "porno", "ports", "posed", "poser", "poses", "posit", "posse",
    "posts", "potty", "pouch", "poufs", "pound", "pours", "pouts",
    "power", "poxed", "poxes", "prams", "prang", "prank", "prate",
    "prats", "prawn", "prays", "preen", "preps", "press", "preys",
    "price", "prick", "pride", "pried", "prier", "pries", "prigs",
    "prime", "primp", "print", "prion", "prior", "prism", "privy",
    "probe", "prods", "profs", "prole", "promo", "proms", "prone",
    "prong", "proof", "props", "prose", "prosy", "proud", "prove",
    "prowl", "prows", "proxy", "prude", "prune", "psalm", "pshaw",
    "pssts", "psych", "pubes", "pubic", "pubis", "pucks", "pudgy",
    "puffs", "puffy", "puked", "pukes", "pukka", "pulls", "pulps",
    "pulpy", "pulse", "pumas", "pumps", "punch", "punks", "punts",
    "pupae", "pupal", "pupil", "puppy", "pured", "puree", "purer",
    "purge", "purls", "purrs", "purse", "pushy", "pussy", "putts",
    "putty", "pygmy", "pylon", "pyres", "pyxed", "pyxes", "pzazz",
    "quack", "quads", "quaff", "quail", "quake", "qualm", "quark",
    "quart", "quash", "quasi", "quays", "queen", "queer", "quell",
    "query", "quest", "queue", "quick", "quids", "quiet", "quiff",
    "quill", "quilt", "quins", "quint", "quips", "quire", "quirk",
    "quite", "quits", "quoit", "quota", "quote", "quoth", "rabbi",
    "rabid", "raced", "racer", "races", "racks", "radar", "radii",
    "radio", "radon", "rafts", "ragas", "raged", "rages", "ragga",
    "raids", "rails", "rains", "rainy", "raise", "rajah", "raked",
    "rakes", "rally", "ramps", "ranch", "randy", "ranee", "range",
    "rangy", "ranks", "rants", "raped", "rapes", "rapid", "rared",
    "rarer", "rares", "rasps", "raspy", "rated", "rates", "ratio",
    "ratty", "raved", "ravel", "raven", "raver", "raves", "rawer",
    "rayon", "razed", "razes", "razor", "reach", "react", "reads",
    "ready", "realm", "reams", "reaps", "rearm", "rears", "rebel",
    "rebus", "rebut", "recap", "recce", "recon", "recto", "recur",
    "redid", "reeds", "reedy", "reefs", "reeks", "reels", "reeve",
    "refer", "refit", "regal", "rehab", "reign", "reins", "rejig",
    "relax", "relay", "relic", "remit", "remix", "renal", "rends",
    "renew", "rents", "repay", "repel", "reply", "reran", "rerun",
    "resat", "reset", "resin", "resit", "rests", "retch", "retro",
    "retry", "reuse", "revel", "revue", "rheas", "rheum", "rhino",
    "rhyme", "riced", "rices", "ricks", "rider", "rides", "ridge",
    "rifer", "riffs", "rifle", "rifts", "right", "rigid", "riled",
    "riles", "rills", "rimed", "rimes", "rinds", "rings", "rinks",
    "rinse", "riots", "riped", "ripen", "riper", "ripes", "risen",
    "riser", "rises", "risks", "risky", "rites", "ritzy", "rival",
    "riven", "river", "rives", "rivet", "roach", "roads", "roams",
    "roans", "roars", "roast", "robed", "robes", "robin", "robot",
    "rocks", "rocky", "roded", "rodeo", "rodes", "roger", "rogue",
    "roils", "roles", "rolls", "roman", "romps", "rondo", "roods",
    "roofs", "rooks", "rooms", "roomy", "roost", "roots", "roped",
    "ropes", "ropey", "roses", "rosin", "rotas", "roted", "rotes",
    "rotor", "rouge", "rough", "round", "rouse", "roust", "route",
    "routs", "roved", "rover", "roves", "rowan", "rowdy", "rowed",
    "rowel", "rower", "royal", "rubes", "rucks", "ruddy", "ruder",
    "ruffs", "rugby", "ruing", "ruins", "ruled", "ruler", "rules",
    "rumba", "rummy", "rumps", "runes", "rungs", "runic", "runny",
    "runts", "rupee", "rural", "ruses", "rusks", "rusts", "rusty",
    "sable", "sacks", "sades", "sadhu", "sadly", "safer", "safes",
    "sagas", "sager", "sages", "saggy", "sahib", "sails", "saint",
    "saith", "salad", "sales", "sally", "salon", "salsa", "salts",
    "salty", "salve", "salvo", "samba", "sames", "samey", "sands",
    "sandy", "saned", "saner", "sanes", "sangs", "sappy", "sarge",
    "saris", "sarky", "sassy", "satay", "sated", "sates", "satin",
    "satyr", "sauce", "saucy", "sauna", "saved", "saver", "saves",
    "savoy", "savvy", "sawed", "saxes", "scabs", "scads", "scald",
    "scale", "scalp", "scaly", "scamp", "scams", "scans", "scant",
    "scare", "scarf", "scarp", "scars", "scary", "scats", "scene",
    "scent", "schwa", "scion", "scoff", "scold", "scone", "scoop",
    "scoot", "scope", "score", "scorn", "scour", "scout", "scowl",
    "scows", "scram", "scrap", "scree", "screw", "scrip", "scrod",
    "scrub", "scrum", "scuba", "scuds", "scuff", "scull", "scums",
    "scurf", "seals", "seams", "seamy", "sears", "seats", "sebum",
    "sects", "sedan", "sedge", "seeds", "seedy", "seeks", "seems",
    "seeps", "seers", "segue", "seize", "sells", "semen", "semis",
    "sends", "senna", "sense", "sepal", "sepia", "septa", "sered",
    "serer", "seres", "serfs", "serge", "serif", "serum", "serve",
    "servo", "setts", "setup", "seven", "sever", "sewed", "sewer",
    "sexed", "sexes", "shack", "shade", "shads", "shady", "shaft",
    "shags", "shahs", "shake", "shaky", "shale", "shall", "shalt",
    "shame", "shams", "shank", "shape", "shard", "share", "shark",
    "sharp", "shave", "shawl", "sheaf", "shear", "sheds", "sheen",
    "sheep", "sheer", "sheet", "sheik", "shelf", "shell", "shied",
    "shies", "shift", "shill", "shims", "shine", "shins", "shiny",
    "ships", "shire", "shirk", "shirr", "shirt", "shite", "shits",
    "shoal", "shock", "shoes", "shone", "shook", "shoos", "shoot",
    "shops", "shore", "short", "shots", "shout", "shove", "shown",
    "shows", "showy", "shred", "shrew", "shrub", "shrug", "shuck",
    "shuns", "shunt", "shush", "shuts", "shyer", "shyly", "sibyl",
    "sicko", "sicks", "sided", "sides", "sidle", "siege", "sieve",
    "sifts", "sighs", "sight", "sigma", "signs", "silks", "silky",
    "sills", "silly", "silos", "silts", "since", "sines", "sinew",
    "singe", "sings", "sinks", "sinus", "sired", "siren", "sires",
    "sisal", "sises", "sissy", "sitar", "sited", "sites", "sixes",
    "sixth", "sixty", "sized", "sizer", "sizes", "skate", "skeet",
    "skein", "skews", "skids", "skied", "skier", "skies", "skiff",
    "skill", "skimp", "skims", "skins", "skint", "skips", "skirt",
    "skits", "skive", "skuas", "skulk", "skull", "skunk", "slabs",
    "slack", "slags", "slain", "slake", "slams", "slang", "slant",
    "slaps", "slash", "slate", "slats", "slave", "slays", "sleds",
    "sleek", "sleep", "sleet", "slept", "slews", "slice", "slick",
    "slide", "slier", "slime", "slims", "slimy", "sling", "slink",
    "slips", "slits", "slobs", "sloes", "slogs", "sloop", "slope",
    "slops", "slosh", "sloth", "slots", "slows", "slued", "slues",
    "slugs", "slump", "slums", "slung", "slunk", "slurp", "slurs",
    "slush", "sluts", "slyly", "smack", "small", "smart", "smash",
    "smear", "smell", "smelt", "smile", "smirk", "smite", "smith",
    "smock", "smogs", "smoke", "smoky", "smote", "smugs", "smuts",
    "snack", "snafu", "snags", "snail", "snake", "snaky", "snaps",
    "snare", "snarl", "sneak", "sneer", "snick", "snide", "sniff",
    "snipe", "snips", "snits", "snobs", "snogs", "snoop", "snoot",
    "snore", "snort", "snots", "snout", "snows", "snowy", "snubs",
    "snuff", "snugs", "soaks", "soaps", "soapy", "soars", "sober",
    "socks", "sodas", "sofas", "softy", "soggy", "soils", "solar",
    "soled", "soles", "solid", "solos", "solve", "sonar", "songs",
    "sonic", "sonny", "sooth", "sooty", "soppy", "sored", "sorer",
    "sores", "sorry", "sorta", "sorts", "sough", "souks", "souls",
    "sound", "soups", "soupy", "sours", "souse", "south", "sowed",
    "sower", "space", "spade", "spake", "spams", "spank", "spans",
    "spare", "spark", "spars", "spasm", "spate", "spats", "spawn",
    "spays", "speak", "spear", "speck", "specs", "speed", "spell",
    "spend", "spent", "sperm", "spews", "spice", "spics", "spicy",
    "spied", "spiel", "spies", "spiff", "spike", "spiky", "spill",
    "spine", "spins", "spiny", "spire", "spite", "spits", "spivs",
    "splat", "splay", "split", "spoil", "spoke", "spoof", "spook",
    "spool", "spoon", "spoor", "spore", "sport", "spots", "spout",
    "sprat", "spray", "spree", "sprig", "sprog", "spuds", "spume",
    "spunk", "spurn", "spurs", "spurt", "squab", "squad", "squat",
    "squaw", "squib", "squid", "stabs", "stack", "staff", "stage",
    "stags", "stagy", "staid", "stain", "stair", "stake", "stale",
    "stalk", "stall", "stamp", "stand", "stank", "staph", "stare",
    "stark", "stars", "start", "stash", "state", "stats", "stave",
    "stays", "stead", "steak", "steal", "steam", "steed", "steel",
    "steep", "steer", "stein", "stems", "steno", "steps", "stern",
    "stews", "stick", "sties", "stiff", "stile", "still", "stilt",
    "sting", "stink", "stint", "stirs", "stoat", "stock", "stogy",
    "stoic", "stoke", "stole", "stomp", "stone", "stony", "stood",
    "stool", "stoop", "stops", "store", "stork", "storm", "stoup",
    "stout", "stove", "stows", "strap", "straw", "stray", "strep",
    "strew", "strip", "strop", "strum", "strut", "stubs", "stuck",
    "studs", "study", "stuff", "stump", "stung", "stunk", "stuns",
    "stunt", "style", "styli", "suave", "sucks", "sudsy", "suede",
    "sugar", "suing", "suite", "suits", "sulks", "sulky", "sully",
    "sumac", "sumps", "sunks", "sunny", "sunup", "super", "surer",
    "surfs", "surge", "surly", "sushi", "swabs", "swags", "swain",
    "swami", "swamp", "swank", "swans", "swaps", "sward", "swarm",
    "swash", "swath", "swats", "sways", "swear", "sweat", "swede",
    "sweep", "sweet", "swell", "swept", "swift", "swigs", "swill",
    "swims", "swine", "swing", "swipe", "swirl", "swish", "swizz",
    "swoon", "swoop", "sword", "swore", "sworn", "swots", "swung",
    "sylph", "syncs", "synod", "syrup", "tabby", "table", "taboo",
    "tacit", "tacks", "tacky", "tacos", "taffy", "tails", "taint",
    "taken", "taker", "takes", "tales", "talks", "tally", "talon",
    "tamed", "tamer", "tames", "tamps", "tango", "tangs", "tangy",
    "tanks", "tansy", "tapas", "taped", "taper", "tapes", "tapir",
    "tardy", "tared", "tares", "tarns", "taros", "tarot", "tarps",
    "tarry", "tarts", "tarty", "tasks", "taste", "tasty", "tater",
    "tatty", "taunt", "taupe", "tauts", "tawny", "taxed", "taxes",
    "taxis", "teach", "teaed", "teaks", "teals", "teams", "tears",
    "teary", "tease", "teats", "techs", "teddy", "teems", "teens",
    "teeny", "teeth", "telex", "tells", "telly", "tempo", "temps",
    "tempt", "tench", "tends", "tenet", "tenon", "tenor", "tense",
    "tenth", "tents", "tepee", "tepid", "terms", "terns", "terry",
    "terse", "tests", "testy", "texts", "thank", "thaws", "theed",
    "thees", "theft", "their", "theme", "there", "therm", "these",
    "theta", "thick", "thief", "thigh", "thine", "thing", "think",
    "thins", "third", "thong", "thorn", "those", "thous", "three",
    "threw", "throb", "throe", "throw", "thrum", "thuds", "thugs",
    "thumb", "thump", "thyme", "tiara", "tibia", "ticks", "tidal",
    "tided", "tides", "tiers", "tiffs", "tiger", "tight", "tilde",
    "tiled", "tiler", "tiles", "tills", "tilts", "timed", "timer",
    "times", "timid", "tinge", "tings", "tinny", "tints", "tipsy",
    "titan", "titch", "tithe", "title", "titty", "tizzy", "toads",
    "toady", "toast", "today", "toddy", "toffs", "togas", "toils",
    "toked", "token", "tokes", "tolls", "tombs", "tomes", "tonal",
    "toned", "toner", "tones", "tongs", "tonic", "tonne", "tools",
    "tooth", "toots", "topaz", "topee", "topic", "toque", "torch",
    "torso", "torte", "torts", "torus", "total", "toted", "totem",
    "totes", "touch", "tough", "tours", "touts", "towed", "towel",
    "tower", "towns", "toxic", "toxin", "toyed", "trace", "track",
    "tract", "trade", "trail", "train", "trait", "tramp", "trams",
    "traps", "trash", "trawl", "trays", "tread", "treat", "treed",
    "trees", "treks", "trend", "tress", "trews", "triad", "trial",
    "tribe", "trice", "trick", "tried", "trier", "tries", "trike",
    "trill", "trims", "trios", "tripe", "trips", "trite", "troll",
    "tromp", "troop", "trope", "troth", "trots", "trout", "troys",
    "truce", "truck", "trued", "truer", "trues", "trugs", "truly",
    "trump", "trunk", "truss", "trust", "truth", "tryst", "tubae",
    "tubas", "tubby", "tubed", "tuber", "tubes", "tucks", "tufts",
    "tulip", "tulle", "tumid", "tummy", "tunas", "tuned", "tuner",
    "tunes", "tunic", "tunny", "tuque", "turbo", "turds", "turfs",
    "turns", "turps", "tusks", "tutor", "tutus", "tuxes", "twain",
    "twang", "twats", "tweak", "tweed", "tweet", "twerp", "twice",
    "twigs", "twill", "twine", "twins", "twirl", "twist", "twits",
    "twixt", "tying", "tykes", "typed", "types", "typos", "tyros",
    "udder", "ulcer", "ulnae", "ultra", "umbel", "umber", "umiak",
    "umped", "unbar", "uncle", "uncut", "under", "undid", "undue",
    "unfit", "unify", "union", "unite", "units", "unity", "unlit",
    "unman", "unmet", "unpin", "unsay", "unset", "untie", "until",
    "unwed", "unzip", "upend", "upped", "upper", "upset", "urban",
    "urged", "urges", "urine", "urned", "usage", "users", "usher",
    "using", "usual", "usurp", "usury", "uteri", "utter", "uvula",
    "vague", "vales", "valet", "valid", "value", "valve", "vamps",
    "vanes", "vapid", "vases", "vasts", "vault", "vaunt", "veals",
    "veeps", "veers", "vegan", "veges", "veils", "veins", "velar",
    "velds", "venal", "vends", "venom", "vents", "venue", "verbs",
    "verge", "verse", "verso", "verve", "vests", "vetch", "vexed",
    "vexes", "vials", "viand", "vibes", "vicar", "viced", "vices",
    "video", "views", "vigil", "viler", "villa", "vined", "vines",
    "vinyl", "viola", "viols", "viper", "viral", "vireo", "virus",
    "visas", "vised", "vises", "visit", "visor", "vista", "vital",
    "vivas", "vivid", "vixen", "vocal", "vodka", "vogue", "voice",
    "voids", "voile", "voled", "voles", "volts", "vomit", "voted",
    "voter", "votes", "vouch", "vowed", "vowel", "vulva", "vying",
    "wacko", "wacky", "waded", "wader", "wades", "wadge", "wadis",
    "wafer", "wafts", "waged", "wager", "wages", "waifs", "wails",
    "waist", "waits", "waive", "waked", "waken", "wakes", "waled",
    "wales", "walks", "walla", "walls", "wally", "waltz", "wands",
    "waned", "wanes", "wanks", "wanly", "wanna", "wants", "wards",
    "wares", "warms", "warns", "warps", "warts", "warty", "wases",
    "wasps", "waste", "watch", "water", "watts", "waved", "waver",
    "waves", "waxed", "waxen", "waxes", "wazoo", "weals", "weans",
    "wears", "weary", "weave", "wedge", "weeds", "weedy", "weeks",
    "weeny", "weeps", "weepy", "weest", "wefts", "weigh", "weird",
    "weirs", "welds", "wells", "welly", "welsh", "welts", "wench",
    "wends", "wests", "wetly", "whack", "whale", "whams", "wharf",
    "whats", "wheal", "wheat", "wheel", "whelk", "whelp", "whens",
    "where", "whets", "whews", "which", "whiff", "while", "whims",
    "whine", "whiny", "whips", "whirl", "whirs", "whisk", "whist",
    "white", "whits", "whole", "whoop", "whops", "whore", "whorl",
    "whose", "whups", "wicks", "widen", "wider", "widow", "width",
    "wield", "wight", "wilds", "wiled", "wiles", "wills", "willy",
    "wilts", "wimps", "wimpy", "wince", "winch", "winds", "windy",
    "wined", "wines", "wings", "winks", "winos", "wiped", "wiper",
    "wipes", "wired", "wires", "wised", "wiser", "wises", "wisps",
    "wispy", "witch", "withe", "withs", "witty", "wives", "wodge",
    "woken", "wolds", "wolfs", "woman", "wombs", "women", "wonks",
    "wonky", "woods", "woody", "wooed", "wooer", "woofs", "woozy",
    "words", "wordy", "works", "world", "worms", "wormy", "worry",
    "worse", "worst", "worth", "would", "wound", "woven", "wowed",
    "wrack", "wraps", "wrath", "wreak", "wreck", "wrens", "wrest",
    "wried", "wries", "wring", "wrist", "write", "writs", "wrong",
    "wrote", "wroth", "wrung", "wryer", "wryly", "xenon", "xerox",
    "xylem", "yacht", "yahoo", "yanks", "yards", "yarns", "yawed",
    "yawls", "yawns", "yeahs", "yearn", "years", "yeast", "yells",
    "yelps", "yeses", "yetis", "yield", "yikes", "yobbo", "yodel",
    "yogic", "yogis", "yoked", "yokel", "yokes", "yolks", "yonks",
    "young", "yours", "youth", "yowls", "yucca", "yucks", "yucky",
    "yukky", "yummy", "zappy", "zebra", "zebus", "zeros", "zests",
    "zilch", "zincs", "zines", "zings", "zingy", "zippy", "zonal",
    "zoned", "zones", "zooms"
  };

  const char* w_6[] = {
    "abacus", "abased", "abases", "abated", "abates", "abbess",
    "abbeys", "abbots", "abduct", "abhors", "abides", "abject",
    "abjure", "ablaze", "ablest", "abloom", "aboard", "aboded",
    "abodes", "aborts", "abound", "abouts", "abrade", "abroad",
    "abrupt", "abseil", "absent", "absorb", "absurd", "abused",
    "abuser", "abuses", "acacia", "accede", "accent", "accept",
    "access", "accord", "accost", "accrue", "accuse", "acetic",
    "achier", "aching", "acidic", "acidly", "acorns", "acquit",
    "across", "acting", "action", "active", "actors", "actual",
    "acuity", "acumen", "acuter", "acutes", "adages", "adagio",
    "adapts", "addend", "adders", "addict", "adding", "addled",
    "addles", "adduce", "adepts", "adhere", "adieus", "adjoin",
    "adjure", "adjust", "admire", "admits", "adobes", "adopts",
    "adored", "adores", "adorns", "adrift", "adroit", "adults",
    "advent", "adverb", "advert", "advice", "advise", "aerate",
    "aerial", "aerier", "aeries", "affair", "affect", "affirm",
    "afford", "affray", "afghan", "afield", "aflame", "afloat",
    "afraid", "afresh", "afters", "agates", "ageism", "ageist",
    "agency", "agenda", "agents", "aghast", "agiler", "agleam",
    "agreed", "agrees", "ahchoo", "aiding", "ailing", "aiming",
    "airbag", "airbed", "airgun", "airier", "airily", "airing",
    "airman", "airmen", "airway", "aisled", "aisles", "akimbo",
    "alarms", "alases", "albeit", "albino", "albums", "alcove",
    "alders", "alerts", "alibis", "aliens", "alight", "aligns",
    "alkali", "allays", "allege", "alleys", "allied", "allies",
    "allots", "allows", "alloys", "allude", "allure", "almond",
    "almost", "alohas", "alpaca", "alphas", "alpine", "altars",
    "alters", "alumna", "alumni", "always", "amazed", "amazes",
    "amazon", "ambled", "ambles", "ambush", "amends", "amened",
    "amidst", "amigos", "amoeba", "amoral", "amount", "amours",
    "ampere", "amping", "ampler", "ampule", "amulet", "amused",
    "amuses", "anally", "analog", "anchor", "angels", "angers",
    "angina", "angled", "angler", "angles", "angora", "animal",
    "animus", "anions", "ankled", "ankles", "anklet", "annals",
    "anneal", "annexe", "annoys", "annual", "annuls", "anodes",
    "anoint", "anorak", "answer", "anthem", "anther", "antics",
    "anting", "antler", "anuses", "anvils", "anyhow", "anyone",
    "anyway", "aortas", "apathy", "apexes", "aphids", "apiary",
    "apiece", "aplomb", "apogee", "appeal", "appear", "append",
    "apples", "applet", "aprons", "aptest", "arable", "arcade",
    "arcane", "arched", "archer", "arches", "archly", "arcing",
    "arctic", "ardent", "arenas", "argosy", "argots", "argued",
    "argues", "argyle", "arider", "aright", "arisen", "arises",
    "armada", "armful", "armies", "arming", "armlet", "armpit",
    "aromas", "around", "arouse", "arrant", "arrays", "arrest",
    "arrive", "arrows", "arroyo", "arsing", "artery", "artful",
    "artier", "artist", "ascend", "ascent", "ascots", "ashcan",
    "ashier", "ashing", "ashore", "ashram", "asides", "asking",
    "aslant", "asleep", "aspect", "aspens", "aspics", "aspire",
    "assail", "assays", "assent", "assert", "assess", "assets",
    "assign", "assist", "assize", "assort", "assume", "assure",
    "astern", "asters", "asthma", "astral", "astray", "astute",
    "asylum", "atolls", "atomic", "atonal", "atoned", "atones",
    "atrium", "attach", "attack", "attain", "attend", "attest",
    "attics", "attire", "attune", "auburn", "audios", "audits",
    "augers", "aughts", "augurs", "augury", "august", "auntie",
    "author", "autism", "autoed", "autumn", "avails", "avasts",
    "avatar", "avenge", "avenue", "averse", "averts", "avians",
    "aviary", "avider", "avidly", "avoids", "avowal", "avowed",
    "awaits", "awaken", "awakes", "awards", "awarer", "aweigh",
    "awhile", "awning", "awoken", "axioms", "axises", "azalea",
    "azures", "baaing", "babble", "babels", "babied", "babier",
    "babies", "baboon", "backed", "backer", "backup", "badder",
    "baddie", "badger", "badges", "baffle", "bagels", "bagful",
    "bagged", "baggie", "bailed", "bailey", "bairns", "baited",
    "bakers", "bakery", "baking", "balded", "balder", "baldly",
    "baleen", "baling", "balked", "ballad", "balled", "ballet",
    "ballot", "ballsy", "balsam", "balsas", "bamboo", "banana",
    "banded", "bandit", "banged", "banger", "bangle", "baning",
    "banish", "banjos", "banked", "banker", "banned", "banner",
    "bantam", "banter", "banyan", "baobab", "barbed", "barber",
    "barbie", "barely", "barest", "barfed", "barfly", "barged",
    "barges", "baring", "barium", "barked", "barker", "barley",
    "barman", "barmen", "barney", "barons", "barony", "barred",
    "barrel", "barren", "barrio", "barrow", "barter", "basalt",
    "basely", "basest", "bashed", "bashes", "basics", "basing",
    "basins", "basked", "basket", "basque", "basses", "basset",
    "bassos", "basted", "bastes", "bathed", "bather", "bathes",
    "bathos", "batiks", "bating", "batman", "batmen", "batons",
    "batted", "batten", "batter", "battle", "bauble", "baulks",
    "bawled", "baying", "bayous", "bazaar", "beacon", "beaded",
    "beagle", "beaked", "beaker", "beamed", "beaned", "beanie",
    "beards", "bearer", "beasts", "beaten", "beater", "beauts",
    "beauty", "beaver", "bebops", "becalm", "became", "beckon",
    "become", "bedaub", "bedbug", "bedded", "bedder", "bedeck",
    "bedlam", "bedpan", "bedsit", "beefed", "beeped", "beeper",
    "beetle", "beeves", "befall", "befell", "befits", "befogs",
    "before", "befoul", "begets", "beggar", "begged", "begins",
    "begone", "begums", "behalf", "behave", "behead", "beheld",
    "behest", "behind", "behold", "beings", "belays", "belfry",
    "belied", "belief", "belies", "belled", "belles", "bellow",
    "belong", "belows", "belted", "bemoan", "bemuse", "bender",
    "benign", "benumb", "berate", "bereft", "berets", "berths",
    "beryls", "besets", "beside", "besoms", "besots", "bested",
    "bestir", "bestow", "betake", "betcha", "betide", "betook",
    "betray", "better", "bettor", "bevels", "bevies", "bewail",
    "beware", "beyond", "biased", "biases", "bibles", "bicarb",
    "biceps", "bicker", "bidden", "bidder", "bidets", "biding",
    "biffed", "bigamy", "bigger", "biggie", "bights", "bigots",
    "bigwig", "bikers", "biking", "bikini", "bilges", "bilked",
    "billed", "billet", "billow", "bimbos", "binary", "binder",
    "binged", "binges", "binman", "binmen", "binned", "bionic",
    "biopic", "biopsy", "bipeds", "birded", "birdie", "births",
    "bisect", "bishop", "bisque", "bistro", "bitchy", "biting",
    "bitmap", "bitten", "bitter", "blacks", "bladed", "blades",
    "blahed", "blamed", "blamer", "blames", "blanch", "blanks",
    "blared", "blares", "blasts", "blazed", "blazer", "blazes",
    "blazon", "bleach", "bleary", "bleats", "bleeds", "bleeps",
    "blench", "blends", "blight", "blimey", "blimps", "blinds",
    "blinks", "blintz", "blithe", "bloats", "blocks", "blokes",
    "blonds", "bloods", "bloody", "blooms", "blotch", "blotto",
    "blouse", "blower", "blowup", "blowzy", "bluest", "bluesy",
    "bluffs", "bluing", "bluish", "blunts", "blurbs", "blurry",
    "blurts", "boards", "boasts", "boated", "boater", "bobbed",
    "bobbin", "bobble", "bobcat", "bodega", "bodged", "bodges",
    "bodice", "bodies", "bodily", "boding", "bodkin", "boffin",
    "bogeys", "bogged", "boggle", "boiled", "boiler", "bolder",
    "boldly", "bolero", "bolled", "bolshy", "bolted", "bombed",
    "bomber", "bonbon", "bonces", "bonded", "boners", "bonged",
    "bongos", "bonier", "boning", "bonito", "bonked", "bonnet",
    "bonnie", "bonsai", "boobed", "boodle", "booger", "boogie",
    "boohoo", "booing", "booked", "bookie", "boomed", "boomer",
    "boosts", "booted", "bootee", "booths", "boozed", "boozer",
    "boozes", "bopped", "border", "borers", "boring", "borrow",
    "bosoms", "bosomy", "bossed", "bosser", "bosses", "botany",
    "bother", "bottle", "bottom", "boughs", "bought", "boules",
    "bounce", "bouncy", "bounds", "bounty", "bovine", "bovver",
    "bowels", "bowers", "bowing", "bowled", "bowler", "bowman",
    "bowmen", "boxcar", "boxers", "boxing", "boyish", "braced",
    "braces", "bracts", "braids", "brains", "brainy", "braise",
    "braked", "brakes", "branch", "brands", "brandy", "brassy",
    "bratty", "braved", "braver", "braves", "bravos", "brawls",
    "brawny", "brayed", "brazen", "breach", "breads", "breaks",
    "breams", "breast", "breath", "breded", "bredes", "breech",
    "breeds", "breeze", "breezy", "brewed", "brewer", "bribed",
    "bribes", "bricks", "bridal", "brides", "bridge", "bridle",
    "briefs", "briers", "bright", "brings", "brinks", "brisks",
    "broach", "broads", "brogan", "brogue", "broils", "broken",
    "broker", "brolly", "bronco", "bronze", "brooch", "broods",
    "broody", "brooks", "brooms", "broths", "browns", "browse",
    "bruins", "bruise", "bruits", "brunch", "brunet", "brunts",
    "brutal", "brutes", "bubble", "bubbly", "bucked", "bucket",
    "buckle", "budded", "budged", "budges", "budget", "budgie",
    "buffed", "buffer", "buffet", "bugged", "bugger", "bugled",
    "bugler", "bugles", "builds", "bulbed", "bulged", "bulges",
    "bulked", "bulled", "bullet", "bumbag", "bumble", "bummed",
    "bummer", "bumped", "bumper", "bundle", "bunged", "bungee",
    "bungle", "bunion", "bunked", "bunker", "bunkum", "bunted",
    "buoyed", "burble", "burden", "bureau", "burger", "burghs",
    "burgle", "burial", "buried", "buries", "burlap", "burned",
    "burner", "burped", "burred", "burros", "burrow", "bursar",
    "bursts", "busboy", "bushed", "bushel", "bushes", "busied",
    "busier", "busies", "busily", "busing", "busked", "busker",
    "bussed", "busted", "buster", "bustle", "butane", "butler",
    "butted", "butter", "buttes", "button", "buyers", "buying",
    "buyout", "buzzed", "buzzer", "buzzes", "bygone", "bylaws",
    "byline", "bypass", "byplay", "byways", "byword", "cabals",
    "cabana", "cabbed", "cabers", "cabins", "cabled", "cables",
    "cacaos", "cached", "caches", "cachet", "cackle", "cactus",
    "cadets", "cadged", "cadger", "cadges", "cadres", "caftan",
    "cagier", "cagily", "caging", "cahoot", "cairns", "cajole",
    "caking", "calico", "caliph", "called", "caller", "callow",
    "callus", "calmed", "calmer", "calmly", "calved", "calves",
    "camber", "camels", "cameos", "camera", "camped", "camper",
    "campus", "canals", "canard", "canary", "cancan", "cancel",
    "cancer", "candid", "candle", "canine", "caning", "canker",
    "canned", "cannon", "cannot", "canoed", "canoes", "canons",
    "canopy", "canted", "canter", "canton", "cantor", "cantos",
    "canvas", "canyon", "capers", "caplet", "capons", "capped",
    "captor", "carafe", "carats", "carbon", "carboy", "carded",
    "careen", "career", "carers", "caress", "carets", "carhop",
    "caries", "caring", "carnal", "carobs", "carols", "caroms",
    "carpal", "carped", "carpel", "carpet", "carpus", "carrel",
    "carrot", "carted", "cartel", "carter", "carton", "carved",
    "carver", "carves", "casein", "cashed", "cashes", "cashew",
    "casing", "casino", "casket", "cassia", "casted", "caster",
    "castes", "castle", "casual", "catchy", "caters", "catgut",
    "cation", "catkin", "catnap", "catnip", "cattle", "caucus",
    "caudal", "caught", "caulks", "causal", "caused", "causes",
    "caveat", "cavern", "cavers", "caviar", "cavils", "caving",
    "cavity", "cavort", "cawing", "cayman", "ceased", "ceases",
    "cedars", "ceding", "celebs", "celery", "cellar", "celled",
    "cellos", "cement", "censer", "censor", "census", "cereal",
    "cerise", "cervix", "chafed", "chafes", "chaffs", "chains",
    "chairs", "chaise", "chalet", "chalks", "chalky", "champs",
    "chance", "chancy", "change", "chants", "chapel", "chappy",
    "charge", "charms", "charts", "chased", "chaser", "chases",
    "chasms", "chaste", "chatty", "cheapo", "cheats", "cheeks",
    "cheeky", "cheeps", "cheers", "cheery", "cheese", "cheesy",
    "cherry", "cherub", "chests", "chesty", "chewed", "chewer",
    "chicer", "chichi", "chicks", "chicle", "chided", "chides",
    "chiefs", "chills", "chilly", "chimed", "chimes", "chimps",
    "chinks", "chinos", "chintz", "chippy", "chirps", "chirpy",
    "chisel", "chitin", "chived", "chives", "chivvy", "chocks",
    "choice", "choirs", "choked", "choker", "chokes", "choler",
    "chomps", "choose", "choosy", "choppy", "choral", "chords",
    "chored", "chores", "chorus", "chosen", "chowed", "chrome",
    "chubby", "chucks", "chummy", "chumps", "chunks", "chunky",
    "church", "churls", "churns", "chutes", "cicada", "ciders",
    "cigars", "cilium", "cinder", "cinema", "cipher", "circle",
    "circus", "cirrus", "cities", "citing", "citric", "citron",
    "citrus", "civets", "civics", "clacks", "claims", "clammy",
    "clamps", "clangs", "clanks", "claret", "clasps", "classy",
    "clause", "clawed", "clayey", "cleans", "clears", "cleats",
    "cleave", "clefts", "clench", "clergy", "cleric", "clerks",
    "clever", "clewed", "clicks", "client", "cliffs", "climax",
    "climbs", "climes", "clinch", "clings", "clingy", "clinic",
    "clinks", "clique", "cloaks", "cloche", "clocks", "clomps",
    "cloned", "clones", "clonks", "closed", "closer", "closes",
    "closet", "clothe", "cloths", "clouds", "cloudy", "clouts",
    "cloven", "clover", "cloves", "clowns", "cloyed", "clucks",
    "cluing", "clumps", "clumpy", "clumsy", "clunks", "clunky",
    "clutch", "coaled", "coarse", "coasts", "coated", "coater",
    "coaxed", "coaxes", "cobalt", "cobbed", "cobber", "cobble",
    "cobnut", "cobras", "cobweb", "coccis", "coccus", "coccyx",
    "cocked", "cockle", "cocoas", "cocoon", "codded", "coddle",
    "codger", "codify", "coding", "coerce", "coeval", "coffee",
    "coffer", "coffin", "cogent", "cognac", "cohere", "cohort",
    "coiled", "coined", "coital", "coitus", "coking", "colder",
    "coldly", "coleys", "collar", "collie", "colons", "colony",
    "column", "combat", "combed", "combos", "comedy", "comely",
    "comers", "comets", "comics", "coming", "comity", "commas",
    "commie", "commit", "common", "compel", "comply", "conchs",
    "concur", "condom", "condor", "condos", "confab", "confer",
    "congas", "conger", "conics", "conies", "coning", "conked",
    "conker", "conned", "consul", "convex", "convey", "convoy",
    "cooing", "cooked", "cooker", "cookie", "cooled", "cooler",
    "coolie", "coolly", "cooped", "cooper", "cootie", "copied",
    "copier", "copies", "coping", "copped", "copper", "copsed",
    "copses", "copter", "copula", "corals", "corded", "cordon",
    "corgis", "coring", "corked", "corker", "cornea", "corned",
    "corner", "cornet", "corona", "corpse", "corpus", "corral",
    "corrie", "corset", "cortex", "coshed", "coshes", "cosign",
    "cosily", "cosine", "cosmic", "cosmos", "cosset", "costar",
    "costly", "coting", "cotted", "cotter", "cotton", "cougar",
    "coughs", "coulis", "counts", "county", "couped", "coupes",
    "couple", "coupon", "course", "courts", "cousin", "covens",
    "covers", "covert", "covets", "coveys", "coward", "cowboy",
    "cowers", "cowing", "cowpat", "cowpox", "cowrie", "coxing",
    "coyest", "coyote", "coypus", "cozens", "cozily", "crabby",
    "cracks", "cradle", "crafts", "crafty", "craggy", "cramps",
    "craned", "cranes", "cranks", "cranky", "cranny", "crapes",
    "crappy", "crated", "crater", "crates", "cravat", "craved",
    "craven", "craves", "crawls", "crayon", "crazed", "crazes",
    "creaks", "creaky", "creams", "creamy", "crease", "create",
    "credit", "credos", "creeds", "creeks", "creels", "creeps",
    "creepy", "creole", "crepes", "crests", "cretin", "crewed",
    "cricks", "criers", "crikey", "crimed", "crimes", "crimps",
    "cringe", "cripes", "crises", "crisis", "crisps", "crispy",
    "critic", "croaks", "crocks", "crocus", "crofts", "crones",
    "crooks", "croons", "crotch", "crouch", "croups", "croupy",
    "crowds", "crowed", "crowns", "cruddy", "cruder", "cruels",
    "cruets", "cruise", "crumbs", "crumby", "crummy", "crunch",
    "crusts", "crusty", "crutch", "cruxes", "crying", "crypts",
    "cubing", "cubism", "cubist", "cubits", "cuboid", "cuckoo",
    "cuddle", "cuddly", "cudgel", "cuffed", "culled", "cumuli",
    "cupful", "cupids", "cupola", "cuppas", "cupped", "curacy",
    "curate", "curdle", "curfew", "curies", "curing", "curios",
    "curled", "curler", "curlew", "curred", "cursed", "curses",
    "cursor", "curter", "curtly", "curtsy", "curved", "curves",
    "cuspid", "cussed", "cusses", "custom", "cutely", "cutest",
    "cutesy", "cuteys", "cuties", "cutlet", "cutoff", "cutout",
    "cutter", "cutups", "cyborg", "cycled", "cycles", "cyclic",
    "cygnet", "cymbal", "cynics", "cypher", "cystic", "dabbed",
    "dabble", "dachas", "dactyl", "dadoes", "daemon", "dafter",
    "dagger", "dagoes", "dahlia", "dainty", "daises", "damage",
    "damask", "dammed", "dammit", "damned", "damped", "dampen",
    "damper", "damply", "damsel", "damson", "danced", "dancer",
    "dances", "dander", "dandle", "danger", "dangle", "danker",
    "dankly", "dapper", "dapple", "daring", "darken", "darker",
    "darkie", "darkly", "darned", "darted", "dashed", "dashes",
    "dating", "dative", "datums", "daubed", "dauber", "daunts",
    "davits", "dawdle", "dawned", "daybed", "dazing", "dazzle",
    "deacon", "deaden", "deader", "deadly", "deafen", "deafer",
    "dealer", "deaned", "dearer", "dearly", "dearth", "deaths",
    "deaves", "debark", "debars", "debase", "debate", "debits",
    "debris", "debtor", "debugs", "debunk", "debuts", "decade",
    "decaff", "decafs", "decals", "decamp", "decant", "decays",
    "deceit", "decent", "decide", "decked", "decode", "decors",
    "decoys", "decree", "deduce", "deduct", "deeded", "deejay",
    "deemed", "deepen", "deeper", "deeply", "deface", "defame",
    "defeat", "defect", "defend", "defers", "defied", "defies",
    "defile", "define", "defogs", "deform", "defray", "defter",
    "deftly", "defuse", "degree", "deiced", "deicer", "deices",
    "deigns", "deject", "delays", "delete", "deltas", "delude",
    "deluge", "deluxe", "delved", "delves", "demand", "demean",
    "demise", "demist", "demobs", "demoed", "demons", "demote",
    "demure", "demurs", "denial", "denied", "denier", "denies",
    "denims", "denote", "denser", "dental", "dented", "dentin",
    "denude", "depart", "depend", "depict", "deploy", "deport",
    "depose", "depots", "depths", "depute", "deputy", "derail",
    "deride", "derive", "dermis", "descry", "desert", "design",
    "desire", "desist", "despot", "detach", "detail", "detain",
    "detect", "deters", "detest", "detour", "deuced", "deuces",
    "device", "devils", "devise", "devoid", "devote", "devour",
    "devout", "dewier", "dewlap", "dhotis", "diadem", "diaper",
    "diatom", "dibble", "dicier", "dicing", "dicker", "dickey",
    "dictum", "diddle", "diddly", "dieing", "diesel", "dieted",
    "dieter", "differ", "digest", "digger", "digits", "diktat",
    "dilate", "dildos", "dilled", "dilute", "dimmed", "dimmer",
    "dimple", "dimwit", "dinars", "diners", "dinged", "dinghy",
    "dining", "dinned", "dinner", "diodes", "dioxin", "dipole",
    "dipped", "dipper", "dipsos", "direct", "direst", "dirges",
    "disarm", "disbar", "discos", "discus", "dished", "dishes",
    "dismal", "dismay", "disown", "dispel", "dissed", "disses",
    "disuse", "dither", "dittos", "divans", "divers", "divert",
    "divest", "divide", "divine", "diving", "divots", "doable",
    "dobbed", "docent", "docile", "docked", "docker", "docket",
    "doctor", "dodder", "doddle", "dodged", "dodgem", "dodger",
    "dodges", "doffed", "dogged", "dogies", "dogleg", "dogmas",
    "doings", "doling", "dollar", "dolled", "dollop", "dolmen",
    "domain", "doming", "domino", "donate", "donkey", "donned",
    "donors", "doodad", "doodah", "doodle", "doomed", "doored",
    "dopier", "doping", "dories", "dormer", "dorsal", "dosage",
    "dosing", "dossed", "dosser", "dotage", "doting", "dotted",
    "double", "doubly", "doubts", "douche", "doughy", "dourer",
    "dourly", "doused", "douses", "dovish", "dowels", "downed",
    "downer", "dowsed", "dowser", "dowses", "doyens", "dozens",
    "dozier", "dozily", "dozing", "drably", "dragon", "drains",
    "drakes", "dramas", "draped", "draper", "drapes", "drawer",
    "drawls", "dreads", "dreams", "dreamy", "dreary", "dredge",
    "drench", "dressy", "driers", "driest", "drifts", "drills",
    "drinks", "drippy", "drivel", "driven", "driver", "drives",
    "drolly", "droned", "drones", "drools", "droops", "droopy",
    "dropsy", "drover", "droves", "drowns", "drowse", "drowsy",
    "drudge", "druids", "drunks", "dryads", "dryers", "drying",
    "dubbed", "dubbin", "ducats", "ducked", "duding", "duffed",
    "duffer", "dugout", "duking", "dulcet", "dulled", "duller",
    "dumbed", "dumber", "dumbly", "dumbos", "dumped", "dumper",
    "dunces", "dunged", "dunked", "dunned", "dunner", "duping",
    "duplex", "duress", "during", "dusted", "duster", "duties",
    "duvets", "dwarfs", "dweebs", "dwells", "dyadic", "dyeing",
    "dynamo", "eagles", "eaglet", "earful", "earned", "earner",
    "earths", "earthy", "earwax", "earwig", "easels", "easier",
    "easies", "easily", "easing", "eaters", "eatery", "eating",
    "ebbing", "echoed", "echoes", "eczema", "eddied", "eddies",
    "edgier", "edgily", "edging", "edible", "edicts", "edited",
    "editor", "eerier", "eerily", "efface", "effect", "effete",
    "effigy", "effing", "effort", "eggcup", "egging", "eggnog",
    "egoism", "egoist", "egress", "egrets", "eiders", "eighth",
    "eights", "eighty", "either", "ejects", "elapse", "elated",
    "elates", "elbows", "elders", "eldest", "elects", "eleven",
    "elfish", "elicit", "elided", "elides", "elites", "elixir",
    "eloped", "elopes", "eluded", "eludes", "emails", "embalm",
    "embark", "embeds", "embers", "emblem", "embody", "emboss",
    "embryo", "emceed", "emcees", "emends", "emerge", "emetic",
    "emoted", "emotes", "empire", "employ", "enable", "enacts",
    "enamel", "encamp", "encase", "encode", "encore", "endear",
    "ending", "endive", "endows", "endued", "endues", "endure",
    "enemas", "energy", "enfold", "engage", "engine", "engulf",
    "enigma", "enjoin", "enjoys", "enlist", "enmesh", "enmity",
    "enough", "enrage", "enrich", "ensign", "ensued", "ensues",
    "ensure", "entail", "enters", "entice", "entire", "entity",
    "entomb", "entrap", "envied", "envies", "envoys", "enzyme",
    "epochs", "equals", "equate", "equine", "equips", "equity",
    "erased", "eraser", "erases", "erects", "ermine", "eroded",
    "erodes", "erotic", "errand", "errant", "errata", "erring",
    "errors", "ersatz", "erupts", "escape", "eschew", "escort",
    "escrow", "escudo", "espied", "espies", "essays", "estate",
    "esteem", "esters", "etched", "etcher", "etches", "ethics",
    "ethnic", "eulogy", "eunuch", "eureka", "evaded", "evades",
    "evened", "evener", "evenly", "events", "evicts", "evilly",
    "evince", "evoked", "evokes", "evolve", "exacts", "exalts",
    "exceed", "excels", "except", "excess", "excise", "excite",
    "excuse", "exempt", "exerts", "exeunt", "exhale", "exhort",
    "exhume", "exiled", "exiles", "exists", "exited", "exodus",
    "exotic", "expand", "expats", "expect", "expels", "expend",
    "expert", "expire", "expiry", "export", "expose", "extant",
    "extend", "extent", "extols", "extort", "extras", "exuded",
    "exudes", "exults", "eyeful", "eyelet", "eyelid", "fabled",
    "fables", "fabric", "facade", "facets", "facial", "facile",
    "facing", "factor", "fading", "faffed", "fagged", "failed",
    "fained", "fainer", "faints", "fairer", "fairly", "faiths",
    "fakers", "faking", "fakirs", "falcon", "fallen", "fallow",
    "falser", "falsie", "falter", "family", "famine", "famish",
    "famous", "fanned", "farces", "farina", "faring", "farmed",
    "farmer", "farrow", "farted", "fascia", "fasted", "fasten",
    "faster", "father", "fathom", "fating", "fatsos", "fatten",
    "fatter", "fatwas", "faucet", "faults", "faulty", "faunas",
    "fawned", "faxing", "fazing", "fealty", "feared", "feasts",
    "fecund", "fedora", "feeble", "feebly", "feeder", "feeler",
    "feigns", "feints", "feisty", "feline", "fellas", "felled",
    "feller", "fellow", "felons", "felony", "felted", "female",
    "femurs", "fenced", "fencer", "fences", "fended", "fender",
    "fennel", "ferret", "ferric", "fervid", "fessed", "fesses",
    "festal", "fester", "feting", "fetish", "fetter", "fettle",
    "feudal", "feuded", "fevers", "fewest", "fezzes", "fiasco",
    "fibbed", "fibber", "fibula", "fiches", "fickle", "fiddle",
    "fiddly", "fidget", "fields", "fiends", "fierce", "fiesta",
    "fifths", "figged", "fights", "figure", "filial", "filing",
    "filled", "filler", "fillet", "fillip", "filmed", "filter",
    "filthy", "finale", "finals", "finder", "finely", "finery",
    "finest", "finger", "fining", "finish", "finite", "finked",
    "finner", "firing", "firmed", "firmer", "firmly", "firsts",
    "firths", "fiscal", "fished", "fisher", "fishes", "fitful",
    "fitted", "fitter", "fivers", "fixate", "fixers", "fixing",
    "fixity", "fizzed", "fizzes", "fizzle", "fjords", "flabby",
    "flacks", "flagon", "flails", "flairs", "flaked", "flakes",
    "flamed", "flames", "flange", "flanks", "flared", "flares",
    "flashy", "flasks", "flatly", "flaunt", "flawed", "flaxen",
    "flayed", "flecks", "fleece", "fleecy", "fleets", "fleshy",
    "flexed", "flexes", "flicks", "fliers", "fliest", "flight",
    "flimsy", "flinch", "flings", "flints", "flinty", "flirts",
    "flirty", "floats", "flocks", "floods", "floors", "floozy",
    "floppy", "floral", "floras", "floret", "florid", "florin",
    "flours", "floury", "flouts", "flowed", "flower", "fluent",
    "fluffs", "fluffy", "fluids", "fluked", "flukes", "flumes",
    "flunks", "flunky", "flurry", "fluted", "flutes", "fluxed",
    "fluxes", "flybys", "flying", "foaled", "foamed", "fobbed",
    "fodder", "foetid", "fogged", "foible", "foiled", "foists",
    "folded", "folder", "folios", "folksy", "follow", "foment",
    "fonded", "fonder", "fondle", "fondly", "fondue", "foodie",
    "fooled", "footed", "footer", "footie", "fopped", "forage",
    "forays", "forbid", "forced", "forces", "forded", "forest",
    "forged", "forger", "forges", "forget", "forgot", "forked",
    "formal", "format", "formed", "former", "fortes", "forums",
    "fossil", "foster", "fought", "fouled", "fouler", "foully",
    "founds", "founts", "fourth", "fowled", "foxier", "foxing",
    "foyers", "fracas", "framed", "framer", "frames", "francs",
    "franks", "frauds", "frayed", "freaks", "freaky", "freely",
    "freest", "freeze", "french", "frenzy", "fresco", "friars",
    "friary", "fridge", "friend", "frieze", "fright", "frigid",
    "frills", "frilly", "fringe", "frisks", "frisky", "frizzy",
    "frocks", "frolic", "fronds", "fronts", "frosts", "frosty",
    "froths", "frothy", "frowns", "frowzy", "frozen", "frugal",
    "fruits", "fruity", "frumps", "frumpy", "fryers", "frying",
    "fucked", "fucker", "fuddle", "fudged", "fudges", "fugues",
    "fulled", "fuller", "fumble", "fuming", "funded", "fungal",
    "fungus", "funked", "funnel", "funner", "furies", "furled",
    "furore", "furors", "furred", "furrow", "fusing", "fusion",
    "fussed", "fusses", "futile", "futons", "future", "futzed",
    "futzes", "fuzzed", "fuzzes", "gabbed", "gabble", "gabled",
    "gables", "gadded", "gadfly", "gadget", "gaffed", "gaffer",
    "gaffes", "gagged", "gaggle", "gaiety", "gained", "gainer",
    "gaiter", "galaxy", "galena", "galled", "galley", "gallon",
    "gallop", "galore", "galosh", "gambit", "gamble", "gambol",
    "gamely", "gamest", "gamete", "gamier", "gamine", "gaming",
    "gamins", "gammas", "gammon", "gamuts", "gander", "ganged",
    "gannet", "gantry", "gaoled", "gaoler", "gaping", "garage",
    "garbed", "garble", "garden", "gargle", "garish", "garlic",
    "garner", "garnet", "garret", "garter", "gasbag", "gashed",
    "gashes", "gasket", "gasman", "gasmen", "gasped", "gassed",
    "gateau", "gather", "gating", "gators", "gauche", "gaucho",
    "gaunts", "gavels", "gawked", "gawped", "gayest", "gazebo",
    "gazers", "gazing", "gazump", "geared", "geckos", "geddit",
    "geeing", "geezer", "geisha", "gelded", "gelled", "gender",
    "genera", "genial", "genies", "genius", "genned", "genome",
    "genres", "gentle", "gently", "gentry", "geodes", "gerbil",
    "gerund", "gewgaw", "geyser", "ghetto", "ghosts", "ghouls",
    "giants", "gibber", "gibbet", "gibbon", "gibing", "giblet",
    "gifted", "gigged", "giggle", "giggly", "gigolo", "gilded",
    "gillie", "gimlet", "ginger", "ginkgo", "ginned", "girded",
    "girder", "girdle", "girlie", "girted", "girths", "givens",
    "givers", "giving", "glades", "gladly", "glance", "glands",
    "glared", "glares", "glassy", "glazed", "glazes", "gleams",
    "gleans", "glibly", "glided", "glider", "glides", "glints",
    "glitch", "glitzy", "gloats", "global", "globed", "globes",
    "gloomy", "glossy", "gloved", "gloves", "glowed", "glower",
    "gluier", "gluing", "glumly", "gluten", "gnarls", "gnarly",
    "gnawed", "gneiss", "gnomes", "gnomic", "goaded", "goaled",
    "goalie", "goatee", "gobbed", "gobbet", "gobble", "goblet",
    "goblin", "godson", "gofers", "goggle", "goings", "golden",
    "golder", "golfed", "golfer", "gonads", "goners", "gonged",
    "goober", "goodly", "goofed", "googly", "gooier", "goosed",
    "gooses", "gopher", "gorged", "gorges", "gorgon", "gorier",
    "goring", "goshes", "gospel", "gossip", "gotcha", "gotten",
    "gouged", "gouger", "gouges", "gourds", "govern", "gowned",
    "grabby", "graced", "graces", "graded", "grader", "grades",
    "grafts", "grains", "grainy", "gramme", "grands", "grange",
    "granny", "grants", "graped", "grapes", "graphs", "grasps",
    "grassy", "grated", "grater", "grates", "gratin", "gratis",
    "graved", "gravel", "graven", "graver", "graves", "grazed",
    "grazes", "grease", "greasy", "greats", "grebes", "greedy",
    "greens", "greets", "griefs", "grieve", "grille", "grills",
    "grimed", "grimes", "grimly", "grinds", "gringo", "griped",
    "gripes", "grippe", "grisly", "gritty", "groans", "grocer",
    "groggy", "groins", "grooms", "groove", "groovy", "groped",
    "gropes", "grotto", "grotty", "grouch", "ground", "groups",
    "grouse", "grouts", "grovel", "groves", "grower", "growls",
    "growth", "groyne", "grubby", "grudge", "gruels", "gruffs",
    "grumps", "grumpy", "grunge", "grungy", "grunts", "guards",
    "guavas", "guests", "guffaw", "guided", "guides", "guilds",
    "guiled", "guiles", "guilty", "guinea", "guises", "guitar",
    "gulags", "gulled", "gullet", "gulped", "gumbos", "gummed",
    "gunman", "gunmen", "gunned", "gunner", "gurgle", "gurney",
    "gushed", "gusher", "gushes", "gusset", "gusted", "gutted",
    "gutter", "guvnor", "guying", "guzzle", "gypped", "gypsum",
    "gyrate", "habits", "hacked", "hacker", "hackle", "hading",
    "hagged", "haggis", "haggle", "hailed", "hairdo", "haired",
    "hajjes", "halest", "haling", "hallos", "hallow", "haloed",
    "halted", "halter", "halved", "halves", "hamlet", "hammed",
    "hammer", "hamper", "handed", "handle", "hangar", "hanged",
    "hanger", "hanker", "hankie", "hansom", "happen", "harass",
    "harden", "harder", "hardly", "harems", "haring", "harked",
    "harlot", "harmed", "harped", "harrow", "hashed", "hashes",
    "hassle", "hasted", "hasten", "hastes", "hatbox", "haters",
    "hating", "hatpin", "hatred", "hatted", "hatter", "hauled",
    "hauler", "haunch", "haunts", "havens", "having", "hawing",
    "hawked", "hawker", "hawser", "haying", "haymow", "hazard",
    "hazels", "hazier", "hazily", "hazing", "headed", "header",
    "healed", "healer", "health", "heaped", "hearer", "hearse",
    "hearth", "hearts", "hearty", "heated", "heater", "heaths",
    "heaved", "heaven", "heaves", "heckle", "hectic", "hector",
    "hedged", "hedges", "heeded", "heehaw", "heeled", "hefted",
    "heifer", "height", "heists", "helium", "hellos", "helmet",
    "helots", "helped", "helper", "hemmed", "hempen", "hences",
    "hennas", "hepper", "herald", "herbal", "herded", "hereby",
    "herein", "hereof", "heresy", "hereto", "hermit", "hernia",
    "heroes", "heroic", "heroin", "herons", "herpes", "hetero",
    "hewers", "hewing", "hexing", "heyday", "hiatus", "hickey",
    "hidden", "hiding", "hieing", "higher", "highly", "hijack",
    "hikers", "hiking", "hinder", "hinged", "hinges", "hinted",
    "hipped", "hipper", "hippie", "hippos", "hiring", "hissed",
    "hisses", "hither", "hitter", "hiving", "hoards", "hoarse",
    "hoaxed", "hoaxer", "hoaxes", "hobbit", "hobble", "hobnob",
    "hoboed", "hocked", "hockey", "hoeing", "hogans", "hogged",
    "hoicks", "hoists", "hokier", "holder", "holdup", "holier",
    "holing", "holism", "holler", "hollow", "homage", "homely",
    "homers", "homeys", "homier", "homily", "homing", "hominy",
    "honcho", "honest", "honeys", "honing", "honked", "hooded",
    "hoodoo", "hoofed", "hoofer", "hookah", "hooked", "hooker",
    "hookup", "hooped", "hoopla", "hooray", "hooted", "hooter",
    "hoover", "hooves", "hoping", "hopped", "hopper", "horded",
    "hordes", "horned", "hornet", "horrid", "horror", "horsed",
    "horses", "horsey", "hosing", "hosted", "hostel", "hotbed",
    "hotels", "hotpot", "hotted", "hotter", "hounds", "hourly",
    "housed", "houses", "hovels", "hovers", "howdah", "howled",
    "howler", "hubbub", "hubcap", "hubris", "huddle", "huffed",
    "hugely", "hugest", "hugged", "hugger", "hulaed", "hulled",
    "hullos", "humane", "humans", "humble", "humbly", "humbug",
    "humeri", "hummed", "hummus", "humped", "hunger", "hungry",
    "hunker", "hunted", "hunter", "hurdle", "hurled", "hurler",
    "hurtle", "hushed", "hushes", "husked", "husker", "hussar",
    "hustle", "hybrid", "hydras", "hyenas", "hymens", "hymnal",
    "hymned", "hyphen", "hyping", "iambic", "ibexes", "ibises",
    "icebox", "icecap", "icicle", "iciest", "icings", "ickier",
    "iconic", "ideals", "idiocy", "idioms", "idiots", "idlers",
    "idlest", "idling", "idylls", "iffier", "igloos", "ignite",
    "ignore", "iguana", "imaged", "images", "imbibe", "imbued",
    "imbues", "immune", "immure", "impact", "impair", "impala",
    "impale", "impart", "impede", "impels", "impend", "impish",
    "import", "impose", "impugn", "impure", "impute", "inaner",
    "inborn", "inbred", "incest", "inched", "inches", "incise",
    "incite", "income", "incurs", "indeed", "indent", "indict",
    "indies", "indigo", "indoor", "induce", "induct", "inerts",
    "infamy", "infant", "infect", "infers", "infest", "infill",
    "infirm", "inflow", "influx", "inform", "infuse", "ingest",
    "ingots", "inhale", "inhere", "inject", "injure", "injury",
    "inkier", "inking", "inlaid", "inland", "inlays", "inlets",
    "inmate", "inmost", "innate", "inners", "inning", "inputs",
    "inroad", "insane", "inseam", "insect", "insert", "insets",
    "inside", "insist", "insole", "instep", "insult", "insure",
    "intact", "intake", "intend", "intent", "intern", "inters",
    "intone", "intros", "intuit", "inured", "inures", "invade",
    "invent", "invert", "invest", "invite", "invoke", "inward",
    "iodine", "ipecac", "irater", "irises", "irking", "ironed",
    "ironic", "island", "islets", "isobar", "issued", "issues",
    "italic", "itched", "itches", "itself", "jabbed", "jabber",
    "jabots", "jackal", "jacked", "jacket", "jading", "jagged",
    "jaguar", "jailed", "jailer", "jalopy", "jambed", "jammed",
    "jangle", "japans", "japing", "jargon", "jarred", "jasper",
    "jaunts", "jaunty", "jawing", "jazzed", "jazzes", "jeered",
    "jejune", "jelled", "jerked", "jerkin", "jersey", "jested",
    "jester", "jetsam", "jetted", "jewels", "jibbed", "jigged",
    "jigger", "jiggle", "jigsaw", "jihads", "jilted", "jingle",
    "jinked", "jinxed", "jinxes", "jitney", "jiving", "jobbed",
    "jobber", "jocked", "jockey", "jocose", "jocund", "jogged",
    "jogger", "joggle", "johnny", "joined", "joiner", "joints",
    "joists", "jojoba", "jokers", "jokier", "joking", "jolted",
    "joshed", "joshes", "jostle", "jotted", "jotter", "joules",
    "jounce", "journo", "jousts", "jovial", "joyful", "joying",
    "joyous", "judder", "judged", "judges", "jugful", "jugged",
    "juggle", "juiced", "juicer", "juices", "jujube", "juleps",
    "jumble", "jumbos", "jumped", "jumper", "juncos", "jungle",
    "junior", "junked", "junker", "junket", "junkie", "juntas",
    "juries", "jurist", "jurors", "juster", "justly", "jutted",
    "kabobs", "kaboom", "kabuki", "kaolin", "karate", "karats",
    "kayaks", "kazoos", "kebabs", "keeled", "keened", "keener",
    "keenly", "keeper", "kegged", "kelvin", "kenned", "kennel",
    "kernel", "kettle", "keying", "keypad", "khakis", "kibitz",
    "kibosh", "kicked", "kicker", "kidded", "kidder", "kiddie",
    "kiddos", "kidnap", "kidney", "killed", "killer", "kilned",
    "kilted", "kilter", "kimono", "kinder", "kindle", "kindly",
    "kingly", "kinked", "kiosks", "kipped", "kipper", "kirked",
    "kirsch", "kismet", "kissed", "kisser", "kisses", "kithed",
    "kiting", "kitsch", "kitted", "kitten", "klaxon", "klutzy",
    "knacks", "knaves", "kneads", "kneels", "knells", "knifed",
    "knifes", "knight", "knives", "knobby", "knocks", "knolls",
    "knotty", "koalas", "kooked", "kopeck", "kosher", "kowtow",
    "kroner", "kronor", "kudzus", "kvetch", "labels", "labial",
    "labium", "lacier", "lacing", "lacked", "lackey", "lactic",
    "lacuna", "ladder", "laddie", "ladies", "lading", "ladled",
    "ladles", "lagers", "lagged", "lagoon", "lairds", "laking",
    "lambda", "lambed", "lamely", "lament", "lamest", "laming",
    "lammed", "lammer", "lanced", "lancer", "lances", "lancet",
    "landed", "lander", "lanker", "lapdog", "lapels", "lapped",
    "lapsed", "lapses", "laptop", "larded", "larder", "larger",
    "larges", "largos", "lariat", "larked", "larvae", "larval",
    "larynx", "lasers", "lashed", "lashes", "lasses", "lassie",
    "lassos", "lasted", "lastly", "lately", "latent", "latest",
    "lathed", "lather", "lathes", "latter", "lattes", "lauded",
    "laughs", "launch", "laurel", "lavish", "lawful", "lawman",
    "lawmen", "lawyer", "laxest", "laxity", "layers", "laying",
    "layman", "laymen", "layoff", "layout", "lazied", "lazier",
    "lazies", "lazily", "lazing", "leaded", "leaden", "leader",
    "leafed", "league", "leaked", "leaned", "leaner", "leaped",
    "learns", "leased", "leases", "leaved", "leaven", "leaver",
    "leaves", "leched", "lecher", "leches", "ledger", "ledges",
    "leered", "leeway", "lefter", "legacy", "legals", "legate",
    "legato", "legend", "legged", "legion", "legman", "legmen",
    "legume", "lemmas", "lemons", "lemony", "lemurs", "lender",
    "length", "lenses", "lentil", "lepers", "lesion", "lessee",
    "lessen", "lesser", "lesson", "lessor", "lethal", "letter",
    "letups", "levees", "levels", "levers", "levied", "levies",
    "levity", "lewder", "lewdly", "liable", "liaise", "libbed",
    "libels", "libido", "lichen", "licked", "lidded", "liefer",
    "lieges", "lifers", "lifted", "lights", "likely", "likens",
    "likest", "liking", "lilacs", "lilies", "lilted", "limber",
    "limbos", "limeys", "limier", "liming", "limits", "limned",
    "limped", "limper", "limpet", "limpid", "limply", "linage",
    "linden", "lineal", "linear", "linens", "liners", "lineup",
    "linger", "lining", "linked", "linker", "linkup", "linnet",
    "lintel", "lipids", "liquid", "liquor", "lisped", "listed",
    "listen", "litany", "litchi", "lither", "litmus", "litter",
    "little", "lively", "livens", "livers", "livery", "livest",
    "living", "lizard", "llamas", "llanos", "loaded", "loader",
    "loafed", "loafer", "loaned", "loaner", "loathe", "loaves",
    "lobbed", "lobing", "locale", "locals", "locate", "locked",
    "locker", "locket", "lockup", "locums", "locust", "lodged",
    "lodger", "lodges", "lofted", "logged", "logger", "logjam",
    "loiter", "lolled", "lollop", "lonely", "loners", "longed",
    "longer", "loofah", "looked", "looker", "loomed", "looped",
    "loosed", "loosen", "looser", "looses", "looted", "looter",
    "loping", "lopped", "lorded", "lordly", "losers", "losing",
    "losses", "lotion", "louche", "louder", "loudly", "loughs",
    "lounge", "loured", "loused", "louses", "lovely", "lovers",
    "loveys", "loving", "lowers", "lowest", "lowing", "lowish",
    "loxing", "lubber", "lubing", "lucked", "lugged", "lulled",
    "lumbar", "lumber", "lummox", "lumped", "lumpen", "lunacy",
    "lunged", "lunges", "luring", "lurked", "lusher", "lushes",
    "lusted", "luvvie", "luxury", "lyceum", "lynxes", "lyrics",
    "macaws", "macing", "macron", "macros", "madame", "madams",
    "madcap", "madden", "madder", "madman", "madmen", "madras",
    "mafias", "maggot", "magics", "magnet", "magnum", "magpie",
    "maiden", "mailed", "mailer", "maimed", "mainly", "maizes",
    "majors", "makers", "makeup", "making", "malady", "malice",
    "malign", "malled", "mallet", "mallow", "malted", "mambas",
    "mambos", "mammal", "mammon", "manage", "manful", "manged",
    "manger", "manges", "mangle", "maniac", "manias", "manics",
    "manila", "manioc", "manned", "manner", "manors", "manses",
    "mantel", "mantis", "mantle", "mantra", "manual", "manure",
    "maples", "mapped", "mapper", "maraca", "maraud", "marble",
    "margin", "marina", "marine", "marked", "marker", "market",
    "markup", "marlin", "marmot", "maroon", "marque", "marred",
    "marrow", "marshy", "marted", "marten", "martin", "martyr",
    "marvel", "mascot", "mashed", "masher", "mashes", "masked",
    "masons", "masque", "massed", "masses", "massif", "master",
    "mastic", "mateys", "mating", "matins", "matrix", "matron",
    "matted", "matter", "mattes", "mature", "matzoh", "matzos",
    "matzot", "mauled", "mavens", "mawing", "maxims", "maxing",
    "maybes", "mayday", "mayfly", "mayhem", "mayors", "meadow",
    "mealed", "meaner", "meanie", "meanly", "measly", "meccas",
    "medals", "meddle", "medial", "median", "medias", "medico",
    "medics", "medium", "medley", "meeker", "meekly", "meeter",
    "melded", "mellow", "melody", "melons", "melted", "member",
    "memoir", "memory", "menace", "menage", "mended", "mender",
    "menial", "menses", "mental", "mentor", "merely", "merest",
    "merged", "merger", "merges", "mering", "merino", "merits",
    "merman", "mermen", "mescal", "meshed", "meshes", "messed",
    "messes", "metals", "meteor", "method", "meting", "metric",
    "metros", "mettle", "mewing", "mewled", "mezzos", "miasma",
    "mickey", "micron", "micros", "midair", "midday", "middle",
    "midges", "midget", "midway", "miffed", "mighty", "miking",
    "milder", "mildew", "mildly", "milers", "milieu", "milked",
    "milker", "milled", "miller", "millet", "mimics", "miming",
    "mimosa", "minced", "mincer", "minces", "minded", "minder",
    "miners", "mingle", "minims", "mining", "minion", "minnow",
    "minors", "minted", "minuet", "minute", "minxes", "mirage",
    "miring", "mirror", "miscue", "misdid", "misers", "misery",
    "misfit", "mishap", "mishit", "mislay", "misled", "missal",
    "missed", "misses", "missus", "misted", "mister", "misuse",
    "mitten", "mixers", "mixing", "mizzen", "moaned", "moaner",
    "moated", "mobbed", "mobile", "mocked", "mocker", "modals",
    "models", "modems", "modern", "modest", "modify", "modish",
    "module", "moggie", "moguls", "mohair", "moiety", "moires",
    "molars", "molder", "molest", "molted", "molten", "moment",
    "mommas", "moneys", "monger", "mongol", "monies", "monkey",
    "months", "mooing", "mooned", "moored", "mooted", "mooter",
    "mopeds", "moping", "mopped", "moppet", "morale", "morals",
    "morass", "morays", "morbid", "morgue", "morned", "morons",
    "morose", "morphs", "morrow", "morsel", "mortal", "mortar",
    "mosaic", "moseys", "moshed", "moshes", "mosque", "mossed",
    "mosses", "mostly", "motels", "motets", "mother", "motifs",
    "motile", "motion", "motive", "motley", "motors", "mottle",
    "moults", "mounds", "mounts", "mourns", "moused", "mouser",
    "mouses", "mousse", "mouths", "mouthy", "movers", "movies",
    "moving", "mowers", "mowing", "mucked", "mucous", "muddle",
    "muesli", "muffed", "muffin", "muffle", "muftis", "mugged",
    "mugger", "mukluk", "muling", "mulish", "mullah", "mulled",
    "mullet", "mumble", "mummer", "murals", "murder", "murmur",
    "muscat", "muscle", "muscly", "museum", "mushed", "musher",
    "mushes", "musics", "musing", "musked", "musket", "muslin",
    "mussed", "mussel", "musses", "muster", "mutant", "mutate",
    "mutely", "mutest", "muting", "mutiny", "mutter", "mutton",
    "mutual", "muumuu", "muzzle", "myopia", "myopic", "myriad",
    "myrtle", "myself", "mystic", "mythic", "nabbed", "nabobs",
    "nachos", "nadirs", "naffer", "nagged", "naiads", "nailed",
    "naiver", "naives", "namely", "naming", "napalm", "napkin",
    "napped", "narced", "narrow", "nasals", "nation", "native",
    "natter", "nature", "nausea", "navels", "navies", "nearby",
    "neared", "nearer", "nearly", "neaten", "neater", "neatly",
    "nebula", "necked", "nectar", "needed", "needle", "negate",
    "neighs", "nephew", "nerved", "nerves", "nested", "nestle",
    "nether", "netted", "nettle", "neural", "neuron", "neuter",
    "newbie", "newels", "newest", "newing", "newsed", "newses",
    "newton", "niacin", "nibbed", "nibble", "nicely", "nicest",
    "nicety", "niches", "nicked", "nickel", "nieces", "nigger",
    "niggle", "nigher", "nights", "nilled", "nimble", "nimbly",
    "nimbus", "ninety", "ninjas", "ninths", "nipped", "nipper",
    "nipple", "nitwit", "nixing", "nobble", "nobler", "nobles",
    "nobody", "nodded", "noddle", "nodule", "noggin", "noised",
    "noises", "nomads", "noncom", "nonfat", "noodle", "nookie",
    "nooned", "nooses", "normal", "normed", "noshed", "noshes",
    "nosing", "notary", "notice", "notify", "noting", "notion",
    "nougat", "novels", "novice", "noways", "nowise", "nozzle",
    "nuance", "nubile", "nuclei", "nudest", "nudged", "nudges",
    "nudism", "nudist", "nudity", "nugget", "nuking", "numbed",
    "number", "numbly", "nuncio", "nursed", "nurses", "nutmeg",
    "nutria", "nutted", "nutter", "nuzzle", "nylons", "nympho",
    "nymphs", "oafish", "oaring", "obeyed", "object", "oblate",
    "oblige", "oblong", "oboist", "obsess", "obtain", "obtuse",
    "occult", "occupy", "occurs", "oceans", "ocelot", "ockers",
    "octane", "octave", "octets", "ocular", "oddest", "oddity",
    "odious", "oeuvre", "offend", "offers", "office", "offing",
    "offish", "offset", "oftest", "ogling", "oilcan", "oilier",
    "oiling", "oilman", "oilmen", "oinked", "oldens", "oldest",
    "oldies", "oldish", "olives", "omegas", "omelet", "onions",
    "onrush", "onsets", "onside", "onuses", "onward", "onyxes",
    "oodles", "oohing", "oopses", "oozing", "opaque", "opened",
    "opener", "openly", "operas", "opiate", "opined", "opines",
    "oppose", "optics", "optima", "opting", "option", "opuses",
    "oracle", "orally", "orange", "orated", "orates", "orator",
    "orbits", "orchid", "ordain", "ordeal", "orders", "ordure",
    "organs", "orgasm", "orgies", "orient", "origin", "oriole",
    "ormolu", "ornate", "ornery", "orphan", "osiers", "osprey",
    "ossify", "ostler", "others", "otiose", "otters", "ounces",
    "ousted", "ouster", "outage", "outbid", "outcry", "outdid",
    "outers", "outfit", "outfox", "outgun", "outing", "outlaw",
    "outlay", "outlet", "output", "outran", "outrun", "outset",
    "outwit", "overdo", "overly", "ovoids", "ovules", "owlets",
    "owlish", "owners", "owning", "oxbows", "oxcart", "oxford",
    "oxides", "oxtail", "oxygen", "oyster", "pacier", "pacify",
    "pacing", "packed", "packer", "packet", "padded", "paddle",
    "padres", "paeans", "paella", "pagans", "pagers", "paging",
    "pagoda", "pained", "paints", "paired", "palace", "palate",
    "palest", "paling", "palish", "palled", "pallet", "pallid",
    "pallor", "palmed", "paltry", "pampas", "pamper", "panama",
    "pandas", "pander", "panels", "panged", "panics", "panned",
    "panted", "pantie", "pantos", "pantry", "papacy", "papaws",
    "papaya", "papers", "papery", "papist", "papped", "papyri",
    "parade", "parcel", "pardon", "parent", "pariah", "paring",
    "parish", "parity", "parkas", "parked", "parlay", "parley",
    "parody", "parole", "parred", "parrot", "parsec", "parsed",
    "parser", "parses", "parson", "parted", "partly", "pashas",
    "passed", "passel", "passer", "passes", "passim", "pastas",
    "pasted", "pastel", "pastes", "pastor", "pastry", "patchy",
    "patent", "paters", "pathos", "patina", "patios", "patois",
    "patrol", "patron", "patted", "patter", "paunch", "pauper",
    "paused", "pauses", "paving", "pawing", "pawned", "payday",
    "payees", "payers", "paying", "payoff", "payola", "payout",
    "peaces", "peachy", "peahen", "peaked", "pealed", "peanut",
    "pearls", "pearly", "pebble", "pebbly", "pecans", "pecked",
    "pecker", "pectin", "pedalo", "pedals", "pedant", "peddle",
    "peeing", "peeked", "peeled", "peeler", "peepbo", "peeped",
    "peeper", "peered", "peeved", "peeves", "peewee", "peewit",
    "pegged", "pellet", "pelmet", "pelted", "pelvic", "pelvis",
    "pencil", "pended", "penile", "penned", "pennon", "penury",
    "people", "pepped", "pepper", "pepsin", "peptic", "perils",
    "period", "perish", "perked", "permed", "permit", "person",
    "perter", "pertly", "peruse", "peseta", "pester", "pestle",
    "petals", "petard", "peters", "petite", "petrel", "petrol",
    "petted", "pewees", "pewter", "peyote", "phalli", "phased",
    "phases", "phenom", "phials", "phlegm", "phloem", "phobia",
    "phobic", "phoebe", "phoned", "phones", "phonic", "phooey",
    "photon", "photos", "phrase", "phylae", "phylum", "physic",
    "physio", "pianos", "piazza", "pickax", "picked", "picker",
    "picket", "pickle", "pickup", "picnic", "piddle", "pidgin",
    "pieced", "pieces", "pieing", "pierce", "piffle", "pigeon",
    "pigged", "piglet", "pigpen", "pigsty", "pikers", "piking",
    "pilafs", "pileup", "pilfer", "piling", "pillar", "pillow",
    "pilots", "pimped", "pimple", "pimply", "pincer", "pinged",
    "pining", "pinion", "pinked", "pinker", "pinkie", "pinkos",
    "pinned", "pintos", "pinups", "pipers", "piping", "pipits",
    "pipped", "pippin", "piqued", "piques", "piracy", "pirate",
    "pissed", "pisser", "pisses", "pistes", "pistil", "pistol",
    "piston", "pitied", "pities", "pitons", "pittas", "pitted",
    "pivots", "pixels", "pixies", "pizazz", "pizzas", "placed",
    "placer", "places", "placid", "plague", "plaice", "plaids",
    "plains", "plaint", "plaits", "planar", "planed", "planer",
    "planes", "planet", "planks", "plants", "plaque", "plasma",
    "plated", "platen", "plates", "played", "player", "plazas",
    "pleads", "please", "pleats", "plebby", "plebes", "pledge",
    "plenty", "plenum", "plexus", "pliant", "pliers", "plight",
    "plinth", "plonks", "plover", "plucks", "plucky", "plumbs",
    "plumed", "plumes", "plummy", "plumps", "plunge", "plunks",
    "plural", "pluses", "plushy", "plying", "pocked", "pocket",
    "podded", "podium", "poetic", "poetry", "pogrom", "points",
    "pointy", "poised", "poises", "poison", "pokers", "pokier",
    "poking", "polars", "police", "policy", "poling", "polios",
    "polish", "polite", "polity", "polkas", "polled", "pollen",
    "polyps", "pomade", "pommel", "pompom", "ponced", "ponces",
    "poncey", "poncho", "ponder", "ponged", "ponied", "ponies",
    "poodle", "poohed", "pooing", "pooled", "pooped", "poorer",
    "poorly", "popgun", "poplar", "poplin", "poppas", "popped",
    "popper", "poppet", "poring", "porker", "porous", "portal",
    "ported", "porter", "portly", "posers", "poseur", "poshed",
    "posher", "poshes", "posies", "posing", "posits", "posses",
    "possum", "postal", "posted", "poster", "postie", "potash",
    "potato", "potent", "potful", "potion", "potpie", "potted",
    "potter", "pouffe", "pounce", "pounds", "poured", "pouted",
    "powder", "powers", "powwow", "poxing", "praise", "prance",
    "prangs", "pranks", "prated", "prates", "prawns", "prayed",
    "prayer", "preach", "preens", "prefab", "prefer", "prefix",
    "prepay", "preppy", "preses", "preset", "presto", "pretax",
    "pretty", "prewar", "preyed", "priced", "prices", "pricey",
    "pricks", "prided", "prides", "priest", "primal", "primed",
    "primer", "primes", "primly", "primps", "prince", "prints",
    "prions", "priors", "priory", "prisms", "prison", "prissy",
    "privet", "probed", "probes", "profit", "proles", "prolix",
    "promos", "prompt", "prongs", "pronto", "proofs", "propel",
    "proper", "proses", "proton", "proved", "proves", "prowls",
    "prudes", "pruned", "prunes", "prying", "psalms", "pseudo",
    "pseuds", "pseudy", "pshaws", "psyche", "psycho", "psychs",
    "pubbed", "public", "pucked", "pucker", "puddle", "pueblo",
    "puffed", "puffer", "puffin", "puking", "pulled", "puller",
    "pullet", "pulley", "pulped", "pulpit", "pulsar", "pulsed",
    "pulses", "pumice", "pummel", "pumped", "punchy", "pundit",
    "punier", "punish", "punker", "punned", "punnet", "punted",
    "punter", "pupate", "pupils", "pupped", "puppet", "purdah",
    "pureed", "purees", "purely", "purest", "purged", "purges",
    "purify", "puring", "purism", "purist", "purity", "purled",
    "purple", "purred", "pursed", "purser", "purses", "pursue",
    "purvey", "pushed", "pusher", "pushes", "pusses", "putrid",
    "putsch", "putted", "putter", "putzes", "puzzle", "pylons",
    "pyrite", "python", "pyxing", "quacks", "quaffs", "quahog",
    "quails", "quaint", "quaked", "quakes", "qualms", "quango",
    "quanta", "quarks", "quarry", "quarto", "quarts", "quartz",
    "quasar", "quaver", "queasy", "queens", "queers", "quells",
    "quench", "quests", "queued", "queues", "quiche", "quiets",
    "quiffs", "quills", "quilts", "quince", "quints", "quires",
    "quirks", "quirky", "quited", "quites", "quiver", "quoits",
    "quorum", "quotas", "quoted", "quotes", "qwerty", "rabbis",
    "rabbit", "rabble", "rabies", "raceme", "racers", "racial",
    "racier", "racily", "racing", "racism", "racist", "racked",
    "racket", "radars", "radial", "radios", "radish", "radium",
    "radius", "raffia", "raffle", "rafted", "rafter", "ragbag",
    "ragged", "raging", "raglan", "ragout", "ragtag", "raided",
    "raider", "railed", "rained", "raised", "raises", "raisin",
    "rajahs", "raking", "rakish", "ramble", "ramify", "rammed",
    "ramrod", "rancid", "random", "ranees", "ranged", "ranger",
    "ranges", "ranked", "ranker", "rankle", "ransom", "ranted",
    "ranter", "rapids", "rapier", "rapine", "raping", "rapist",
    "rapped", "rappel", "rapper", "raptor", "rarefy", "rarely",
    "rarest", "raring", "rarity", "rascal", "rasher", "rashes",
    "rashly", "rasped", "raster", "ratbag", "rather", "ratify",
    "rating", "ration", "ratios", "rattan", "ratted", "rattle",
    "ravage", "ravels", "ravens", "ravers", "ravine", "raving",
    "ravish", "rawest", "razing", "razors", "razzed", "razzes",
    "reacts", "reader", "realer", "really", "realms", "realty",
    "reamed", "reamer", "reaped", "reaper", "reared", "rearms",
    "reason", "rebate", "rebels", "rebind", "reboot", "reborn",
    "rebuff", "rebuke", "rebuts", "recall", "recant", "recaps",
    "recast", "recces", "recede", "recent", "recess", "recipe",
    "recite", "reckon", "recoil", "recons", "recopy", "record",
    "recoup", "rectal", "rector", "rectos", "rectum", "recurs",
    "redcap", "redden", "redder", "redeem", "redoes", "redone",
    "redraw", "redrew", "reduce", "reefed", "reefer", "reeked",
    "reeled", "reeves", "refers", "reffed", "refile", "refill",
    "refine", "refits", "reflex", "reform", "refuel", "refuge",
    "refund", "refuse", "refute", "regain", "regale", "regals",
    "regard", "regent", "reggae", "regime", "region", "regret",
    "rehabs", "rehash", "reheat", "rehire", "reigns", "reined",
    "reject", "rejigs", "rejoin", "relaid", "relate", "relays",
    "relent", "relics", "relied", "relief", "relies", "relish",
    "relive", "reload", "remade", "remain", "remake", "remand",
    "remark", "remedy", "remind", "remiss", "remits", "remold",
    "remote", "remove", "rename", "render", "renege", "renews",
    "rennet", "renown", "rental", "rented", "renter", "reopen",
    "repaid", "repair", "repast", "repays", "repeal", "repeat",
    "repels", "repent", "replay", "report", "repose", "repute",
    "reread", "reruns", "resale", "rescue", "resell", "resend",
    "resent", "resets", "reside", "resign", "resins", "resist",
    "resits", "resold", "resort", "rested", "result", "resume",
    "retail", "retain", "retake", "retard", "retell", "retina",
    "retire", "retold", "retook", "retool", "retort", "retrod",
    "return", "retype", "reused", "reuses", "revamp", "reveal",
    "revels", "revere", "revert", "review", "revile", "revise",
    "revive", "revoke", "revolt", "revues", "revved", "reward",
    "rewind", "rewire", "reword", "rework", "rheumy", "rhinos",
    "rhymed", "rhymes", "rhythm", "ribald", "ribbed", "ribbon",
    "richer", "riches", "richly", "ricing", "ricked", "ridden",
    "riddle", "riders", "ridged", "ridges", "riding", "rifest",
    "riffed", "riffle", "rifled", "rifles", "rifted", "rigged",
    "righto", "rights", "riling", "rilled", "riming", "rimmed",
    "rinded", "ringed", "ringer", "rinked", "rinsed", "rinses",
    "rioted", "rioter", "ripely", "ripens", "ripest", "riping",
    "ripped", "ripper", "ripple", "ripsaw", "risers", "rising",
    "risked", "ritual", "rivals", "rivers", "rivets", "roadie",
    "roamed", "roamer", "roared", "roasts", "robbed", "robber",
    "robing", "robins", "robots", "robust", "rocked", "rocker",
    "rocket", "rococo", "rodent", "rodeos", "roding", "rogers",
    "rogues", "roiled", "rolled", "roller", "romped", "romper",
    "rondos", "roofed", "roofer", "rooked", "rookie", "roomed",
    "roomer", "roosts", "rooted", "rooter", "roping", "rosary",
    "rosier", "rosily", "rosins", "roster", "rotary", "rotate",
    "roting", "rotors", "rotted", "rotten", "rotter", "rotund",
    "rouged", "rouges", "roughs", "rounds", "roused", "rouses",
    "rousts", "routed", "router", "routes", "rovers", "roving",
    "rowans", "rowels", "rowers", "rowing", "royals", "rubbed",
    "rubber", "rubble", "rubied", "rubier", "rubies", "rubric",
    "ruched", "rucked", "ruckus", "rudder", "rudely", "rudest",
    "rueful", "ruffed", "ruffle", "rugged", "rugger", "ruined",
    "rulers", "ruling", "rumbas", "rumble", "rummer", "rumped",
    "rumple", "rumpus", "runnel", "runner", "runoff", "runway",
    "rupees", "rushed", "rushes", "russet", "rusted", "rustic",
    "rustle", "rutted", "sabled", "sables", "sachem", "sachet",
    "sacked", "sacred", "sadden", "sadder", "saddle", "sadhus",
    "sadism", "sadist", "safari", "safely", "safest", "safety",
    "sagely", "sagest", "sagged", "sagger", "sahibs", "sailed",
    "sailor", "saints", "saiths", "salaam", "salads", "salami",
    "salary", "saline", "saliva", "sallow", "salmon", "salons",
    "saloon", "salsas", "salted", "salter", "salute", "salved",
    "salver", "salves", "salvos", "sambas", "samosa", "sampan",
    "sample", "sandal", "sanded", "sander", "sanely", "sanest",
    "saning", "sanity", "sapped", "sapper", "sarges", "sarnie",
    "sarong", "sashay", "sashes", "sassed", "sasses", "sateen",
    "sating", "satins", "satiny", "satire", "satrap", "satyrs",
    "sauced", "saucer", "sauces", "saunas", "savage", "savant",
    "savers", "saving", "savoys", "sawing", "sawyer", "saying",
    "scabby", "scalar", "scalds", "scaled", "scales", "scalps",
    "scampi", "scamps", "scants", "scanty", "scarab", "scarce",
    "scared", "scares", "scarfs", "scarps", "scatty", "scened",
    "scenes", "scenic", "scents", "schema", "scheme", "schism",
    "schist", "schizo", "schlep", "school", "schuss", "schwas",
    "scions", "scoffs", "scolds", "sconce", "scones", "scoops",
    "scoots", "scoped", "scopes", "scorch", "scored", "scorer",
    "scores", "scorns", "scotch", "scours", "scouts", "scowls",
    "scrams", "scrape", "scraps", "scrawl", "scream", "screed",
    "screen", "screes", "screws", "screwy", "scribe", "scrimp",
    "scrips", "script", "scroll", "scrota", "scrubs", "scruff",
    "scrump", "scrums", "scubas", "scuffs", "sculls", "sculpt",
    "scummy", "scurfy", "scurry", "scurvy", "scuzzy", "scythe",
    "seabed", "sealed", "sealer", "seaman", "seamed", "seamen",
    "search", "seared", "season", "seated", "seaway", "secede",
    "second", "secret", "sector", "secure", "sedans", "sedate",
    "seduce", "seeded", "seeing", "seeker", "seemed", "seemly",
    "seeped", "seesaw", "seethe", "segued", "segues", "seized",
    "seizes", "seldom", "select", "seller", "selves", "senate",
    "sender", "senile", "senior", "sensed", "senses", "sensor",
    "sentry", "sepals", "sepsis", "septet", "septic", "septum",
    "sequel", "sequin", "serape", "seraph", "serene", "serest",
    "serial", "series", "serifs", "sering", "sermon", "serous",
    "serums", "served", "server", "serves", "servos", "sesame",
    "settee", "setter", "settle", "setups", "sevens", "severe",
    "severs", "sewage", "sewers", "sewing", "sexier", "sexily",
    "sexing", "sexism", "sexist", "sexpot", "sextet", "sexton",
    "sexual", "shabby", "shacks", "shaded", "shades", "shadow",
    "shafts", "shaggy", "shaikh", "shaken", "shaker", "shakes",
    "shalom", "shaman", "shamed", "shames", "shandy", "shanks",
    "shanty", "shaped", "shapes", "shards", "shared", "shares",
    "sharia", "sharks", "sharps", "shaved", "shaver", "shaves",
    "shawls", "shears", "sheath", "sheave", "sheers", "sheets",
    "sheiks", "sheila", "shekel", "shells", "shelve", "sherry",
    "shield", "shifts", "shifty", "shills", "shimmy", "shined",
    "shiner", "shines", "shinny", "shires", "shirks", "shirrs",
    "shirts", "shirty", "shites", "shitty", "shiver", "shoals",
    "shocks", "shoddy", "shogun", "shooed", "shoots", "shored",
    "shores", "shorts", "shorty", "should", "shouts", "shoved",
    "shovel", "shoves", "showed", "shower", "shrank", "shreds",
    "shrewd", "shrews", "shriek", "shrift", "shrike", "shrill",
    "shrimp", "shrine", "shrink", "shrive", "shroud", "shrubs",
    "shrugs", "shrunk", "shtick", "shucks", "shunts", "shyest",
    "shying", "sibyls", "sicked", "sicken", "sicker", "sickie",
    "sickle", "sickly", "sickos", "siding", "sidled", "sidles",
    "sieges", "sienna", "sierra", "siesta", "sieved", "sieves",
    "sifted", "sifter", "sighed", "sights", "signal", "signed",
    "signer", "signet", "silage", "silent", "silica", "silken",
    "silted", "silver", "simian", "simile", "simmer", "simper",
    "simple", "simply", "sinews", "sinewy", "sinful", "singed",
    "singer", "singes", "single", "singly", "sinker", "sinned",
    "sinner", "sipped", "sirens", "siring", "sirrah", "sirred",
    "sister", "sitars", "sitcom", "siting", "sitter", "sixths",
    "sizing", "sizzle", "skated", "skater", "skates", "skeins",
    "sketch", "skewed", "skewer", "skibob", "skiers", "skiffs",
    "skiing", "skills", "skimps", "skimpy", "skinny", "skirts",
    "skited", "skived", "skiver", "skives", "skivvy", "skulks",
    "skulls", "skunks", "skycap", "skying", "slacks", "slaked",
    "slakes", "slalom", "slangy", "slants", "slated", "slates",
    "slaved", "slaver", "slaves", "slayed", "slayer", "sleaze",
    "sleazy", "sledge", "sleeks", "sleeps", "sleepy", "sleets",
    "sleety", "sleeve", "sleigh", "sleuth", "slewed", "sliced",
    "slicer", "slices", "slicks", "slided", "slider", "slides",
    "sliest", "slight", "slings", "slinks", "slinky", "slippy",
    "sliver", "slogan", "sloops", "sloped", "slopes", "sloppy",
    "sloths", "slouch", "slough", "sloven", "slowed", "slower",
    "slowly", "sludge", "sludgy", "sluice", "sluing", "slummy",
    "slumps", "slurps", "slurry", "slushy", "slutty", "smacks",
    "smalls", "smarmy", "smarts", "smears", "smells", "smelly",
    "smelts", "smiled", "smiles", "smiley", "smirch", "smirks",
    "smites", "smiths", "smithy", "smocks", "smoggy", "smoked",
    "smoker", "smokes", "smokey", "smooch", "smooth", "smudge",
    "smudgy", "smugly", "smutty", "snacks", "snafus", "snails",
    "snaked", "snakes", "snappy", "snared", "snares", "snarls",
    "snatch", "snazzy", "sneaks", "sneaky", "sneers", "sneeze",
    "snicks", "snider", "snides", "sniffs", "sniffy", "sniped",
    "sniper", "snipes", "snippy", "snitch", "snivel", "snobby",
    "snoops", "snoopy", "snoots", "snooty", "snooze", "snored",
    "snorer", "snores", "snorts", "snotty", "snouts", "snowed",
    "snuffs", "snugly", "soaked", "soaped", "soared", "sobbed",
    "sobers", "soccer", "social", "socked", "socket", "sodded",
    "sodden", "sodium", "sodomy", "soften", "softer", "softly",
    "soiled", "solace", "solder", "solely", "solemn", "solids",
    "soling", "soloed", "solved", "solver", "solves", "somber",
    "sombre", "sonars", "sonata", "sonics", "sonnet", "sooner",
    "soothe", "sooths", "sopped", "sorbet", "sordid", "sorely",
    "sorest", "soring", "sorrel", "sorrow", "sorted", "sorter",
    "sortie", "soughs", "sought", "sounds", "souped", "source",
    "soured", "sourer", "sourly", "soused", "souses", "soviet",
    "sowers", "sowing", "spaced", "spaces", "spacey", "spaded",
    "spades", "spanks", "spared", "sparer", "spares", "sparks",
    "sparky", "sparse", "spasms", "spates", "spawns", "spayed",
    "speaks", "spears", "specie", "specks", "speech", "speeds",
    "speedy", "spells", "spends", "sperms", "spewed", "sphere",
    "sphinx", "spiced", "spices", "spider", "spiels", "spiffs",
    "spiffy", "spigot", "spiked", "spikes", "spills", "spinal",
    "spines", "spinet", "spiral", "spirea", "spires", "spirit",
    "spited", "spites", "splash", "splats", "splays", "spleen",
    "splice", "spliff", "spline", "splint", "splits", "splosh",
    "spoils", "spoken", "spokes", "sponge", "spongy", "spoofs",
    "spooks", "spooky", "spools", "spoons", "spoors", "spored",
    "spores", "sports", "sporty", "spotty", "spouse", "spouts",
    "sprain", "sprang", "sprats", "sprawl", "sprays", "spread",
    "spreed", "sprees", "sprier", "sprigs", "spring", "sprint",
    "sprite", "spritz", "sprogs", "sprout", "spruce", "sprung",
    "spryly", "spumed", "spumes", "spunks", "spunky", "spurns",
    "spurts", "sputum", "spying", "squabs", "squads", "squall",
    "square", "squash", "squats", "squawk", "squaws", "squeak",
    "squeal", "squibs", "squids", "squint", "squire", "squirm",
    "squirt", "squish", "stable", "stably", "stacks", "staffs",
    "staged", "stages", "stains", "stairs", "staked", "stakes",
    "staled", "staler", "stales", "stalks", "stalls", "stamen",
    "stamps", "stance", "stanch", "stands", "stanks", "stanza",
    "staple", "starch", "stared", "stares", "starks", "starry",
    "starts", "starve", "stasis", "stated", "stater", "states",
    "static", "statue", "status", "staved", "stayed", "steads",
    "steady", "steaks", "steals", "steams", "steamy", "steeds",
    "steels", "steely", "steeps", "steers", "steins", "stench",
    "stenos", "steppe", "stereo", "sterns", "stewed", "sticks",
    "sticky", "stiffs", "stifle", "stigma", "stiled", "stiles",
    "stills", "stilts", "stings", "stingy", "stinks", "stints",
    "stitch", "stoats", "stocks", "stocky", "stodge", "stodgy",
    "stoics", "stoked", "stoker", "stokes", "stolen", "stoles",
    "stolid", "stomps", "stoned", "stones", "stooge", "stools",
    "stoops", "stored", "stores", "storks", "storms", "stormy",
    "stoups", "stouts", "stoves", "stowed", "strafe", "strain",
    "strait", "strand", "straps", "strata", "straws", "strays",
    "streak", "stream", "street", "stress", "strewn", "strews",
    "strict", "stride", "strife", "strike", "string", "stripe",
    "strips", "stripy", "strive", "strobe", "strode", "stroke",
    "stroll", "strong", "strops", "strove", "struck", "strums",
    "strung", "struts", "stubby", "stucco", "studio", "stuffs",
    "stuffy", "stumps", "stumpy", "stunts", "stupid", "stupor",
    "sturdy", "stying", "styled", "styles", "stylus", "stymie",
    "suaver", "subbed", "subdue", "sublet", "submit", "suborn",
    "subset", "subtle", "subtly", "suburb", "subway", "sucked",
    "sucker", "suckle", "sudden", "suffer", "suffix", "sugars",
    "sugary", "suited", "suites", "suitor", "sulked", "sullen",
    "sultan", "sultry", "summat", "summed", "summer", "summit",
    "summon", "sunbed", "sundae", "sunder", "sundry", "sunhat",
    "sunken", "sunlit", "sunned", "sunset", "suntan", "superb",
    "supers", "supine", "supped", "supper", "supple", "supply",
    "surely", "surest", "surety", "surfed", "surfer", "surged",
    "surges", "surrey", "surtax", "survey", "sussed", "susses",
    "suttee", "suture", "svelte", "swains", "swamis", "swamps",
    "swampy", "swanks", "swanky", "swards", "swarms", "swatch",
    "swathe", "swaths", "swayed", "swears", "sweats", "sweaty",
    "swedes", "sweeps", "sweets", "swells", "swerve", "swifts",
    "swills", "swines", "swings", "swiped", "swipes", "swirls",
    "swirly", "switch", "swivel", "swoons", "swoops", "swoosh",
    "swords", "sylphs", "sylvan", "symbol", "synced", "synods",
    "syntax", "syrupy", "system", "tabbed", "tabled", "tables",
    "tablet", "taboos", "tacked", "tackle", "tactic", "tagged",
    "tailed", "tailor", "taints", "takers", "taking", "talent",
    "talked", "talker", "talkie", "taller", "tallow", "talons",
    "tamale", "tamely", "tamers", "tamest", "taming", "tamped",
    "tamper", "tampon", "tandem", "tangle", "tangos", "tanked",
    "tanker", "tanned", "tanner", "tannin", "tapers", "taping",
    "tapirs", "tapped", "tappet", "target", "tariff", "taring",
    "tarmac", "tarots", "tarpon", "tarred", "tartan", "tartar",
    "tarted", "tarter", "tartly", "tasked", "tassel", "tasted",
    "taster", "tastes", "taters", "tatted", "tatter", "tattie",
    "tattle", "tattoo", "taught", "taunts", "tauted", "tauten",
    "tauter", "tautly", "tavern", "tawdry", "taxied", "taxing",
    "taxman", "taxmen", "teabag", "teacup", "teaing", "teamed",
    "teapot", "teared", "teased", "teasel", "teaser", "teases",
    "techie", "techno", "tedium", "teeing", "teemed", "teeter",
    "teethe", "teller", "temped", "temper", "temple", "tempos",
    "tempts", "tenant", "tended", "tender", "tendon", "tenets",
    "tenner", "tennis", "tenons", "tenors", "tenpin", "tensed",
    "tenser", "tenses", "tensor", "tented", "tenths", "tenure",
    "tepees", "termed", "termly", "terned", "terror", "terser",
    "tested", "tester", "testes", "testis", "tetchy", "tether",
    "thanks", "thatch", "thawed", "thefts", "theirs", "theism",
    "theist", "themed", "themes", "thence", "theory", "therms",
    "theses", "thesis", "thicko", "thieve", "thighs", "things",
    "thingy", "thinks", "thinly", "thirds", "thirst", "thirty",
    "thongs", "thorax", "thorns", "thorny", "though", "thrall",
    "thrash", "thread", "threat", "threes", "thresh", "thrice",
    "thrift", "thrill", "thrive", "throat", "throbs", "throed",
    "throes", "throne", "throng", "thrown", "throws", "thrums",
    "thrush", "thrust", "thumbs", "thumps", "thwack", "thwart",
    "thymus", "tiaras", "tibiae", "ticked", "ticker", "ticket",
    "tickle", "tidbit", "tiddly", "tidied", "tidier", "tidies",
    "tidily", "tiding", "tiepin", "tiered", "tiffed", "tigers",
    "tights", "tildes", "tilers", "tiling", "tilled", "tiller",
    "tilted", "timber", "timbre", "timely", "timers", "timing",
    "tinder", "tinged", "tinges", "tingle", "tingly", "tinier",
    "tinker", "tinkle", "tinned", "tinpot", "tinsel", "tinted",
    "tipped", "tipper", "tippex", "tipple", "tiptoe", "tiptop",
    "tirade", "tissue", "titans", "titchy", "tithed", "tithes",
    "titian", "titled", "titles", "titted", "titter", "tittle",
    "toasts", "toasty", "tocsin", "toddle", "toecap", "toeing",
    "toerag", "toffee", "togged", "toggle", "toiled", "toiler",
    "toilet", "tokens", "toking", "tolled", "tomato", "tombed",
    "tomboy", "tomcat", "toners", "tongue", "tonics", "tonier",
    "toning", "tonnes", "tonsil", "tooled", "tooted", "toothy",
    "tootle", "topees", "topics", "topped", "topper", "topple",
    "toques", "torpid", "torpor", "torque", "torrid", "torsos",
    "tortes", "tossed", "tosser", "tosses", "tossup", "totals",
    "totems", "toting", "totted", "totter", "toucan", "touchy",
    "toughs", "toupee", "toured", "tousle", "touted", "toward",
    "towels", "towers", "towing", "townee", "townie", "toxins",
    "toyboy", "toying", "traced", "tracer", "traces", "tracks",
    "tracts", "traded", "trader", "trades", "tragic", "trails",
    "trains", "traits", "tramps", "trance", "trashy", "trauma",
    "travel", "trawls", "treads", "treats", "treaty", "treble",
    "tremor", "trench", "trends", "trendy", "triads", "triage",
    "trials", "tribal", "tribes", "tricks", "tricky", "triers",
    "trifle", "triked", "trikes", "trilby", "trills", "trimly",
    "triple", "triply", "tripod", "tripos", "triter", "trites",
    "trivet", "trivia", "trodes", "troika", "trolls", "tromps",
    "troops", "tropes", "trophy", "tropic", "troths", "trough",
    "troupe", "trouts", "trowel", "truant", "truces", "trucks",
    "trudge", "truest", "truing", "truism", "trumps", "trunks",
    "trusts", "trusty", "truths", "trying", "tryout", "trysts",
    "tubers", "tubing", "tucked", "tucker", "tufted", "tugged",
    "tulips", "tumble", "tumult", "tundra", "tuners", "tunics",
    "tuning", "tunnel", "tuques", "turban", "turbid", "turbos",
    "turbot", "tureen", "turfed", "turgid", "turkey", "turned",
    "turner", "turnip", "turret", "turtle", "tushed", "tushes",
    "tusked", "tussle", "tutors", "tutted", "tuxedo", "twangs",
    "tweaks", "tweeds", "tweedy", "tweets", "twelve", "twenty",
    "twerps", "twiggy", "twilit", "twined", "twines", "twinge",
    "twirls", "twirly", "twists", "twisty", "twitch", "twofer",
    "tycoon", "typhus", "typify", "typing", "typist", "tyrant",
    "udders", "uglied", "uglier", "uglies", "ulcers", "ultras",
    "umbels", "umiaks", "umlaut", "umping", "umpire", "unable",
    "unbars", "unbend", "unbent", "unbind", "unbolt", "unborn",
    "uncled", "uncles", "uncoil", "uncool", "uncork", "uncurl",
    "undies", "undoes", "undone", "unduly", "unease", "uneasy",
    "uneven", "unfair", "unfits", "unfold", "unfurl", "unhand",
    "unholy", "unhook", "unhurt", "unions", "unique", "unisex",
    "unison", "united", "unites", "unjust", "unkind", "unlace",
    "unless", "unlike", "unload", "unlock", "unmade", "unmake",
    "unmans", "unmask", "unpack", "unpaid", "unpick", "unpins",
    "unplug", "unread", "unreal", "unrest", "unripe", "unroll",
    "unruly", "unsafe", "unsaid", "unsays", "unseal", "unseat",
    "unseen", "unsent", "unsnap", "unsold", "unstop", "unsung",
    "unsure", "untidy", "untied", "unties", "untold", "untrue",
    "unused", "unveil", "unwary", "unwell", "unwind", "unwise",
    "unwrap", "unzips", "upbeat", "update", "upends", "upheld",
    "uphill", "uphold", "upkeep", "upland", "uplift", "upload",
    "uppers", "upping", "uppity", "uproar", "uproot", "upsets",
    "upshot", "upside", "uptake", "uptown", "upturn", "upward",
    "upwind", "urbane", "urchin", "urgent", "urging", "urinal",
    "urning", "usable", "usages", "useful", "ushers", "usurer",
    "usurps", "uterus", "utmost", "utopia", "utters", "uvular",
    "uvulas", "vacant", "vacate", "vacuum", "vagary", "vagina",
    "vagued", "vaguer", "vagues", "vainer", "vainly", "valets",
    "valise", "valley", "valued", "valuer", "values", "valved",
    "valves", "vamped", "vandal", "vanish", "vanity", "vanned",
    "varied", "varies", "varlet", "vassal", "vaster", "vastly",
    "vatted", "vaults", "vaunts", "vealed", "vector", "veered",
    "vegans", "vegged", "vegges", "veggie", "veiled", "veined",
    "velars", "vellum", "velvet", "vended", "vendor", "veneer",
    "venial", "venous", "vented", "venues", "verbal", "verged",
    "verger", "verges", "verier", "verify", "verily", "verity",
    "vermin", "vernal", "versed", "verses", "versos", "versus",
    "vertex", "vesper", "vessel", "vested", "vestry", "vetoed",
    "vetoes", "vetted", "vexing", "viable", "viably", "viands",
    "vicars", "vicing", "victim", "victor", "videos", "viewed",
    "viewer", "vigils", "vilely", "vilest", "vilify", "villas",
    "vining", "vinyls", "violas", "violet", "violin", "vipers",
    "virago", "vireos", "virgin", "virile", "virtue", "visaed",
    "visage", "viscid", "viscus", "vising", "vision", "visits",
    "visors", "vistas", "visual", "vitals", "vivace", "vivaed",
    "vivify", "vixens", "vizier", "vocals", "vodkas", "vogued",
    "vogues", "voiced", "voices", "voided", "voling", "volley",
    "volume", "vomits", "voodoo", "vortex", "votary", "voters",
    "voting", "votive", "vowels", "vowing", "voyage", "voyeur",
    "vulgar", "vulvae", "wackos", "wadded", "waddle", "waders",
    "wadges", "wading", "wafers", "waffle", "wafted", "wagers",
    "wagged", "waggle", "waging", "waifed", "wailed", "waists",
    "waited", "waiter", "waived", "waiver", "waives", "wakens",
    "waking", "waling", "walked", "walker", "wallah", "wallas",
    "walled", "wallet", "wallop", "wallow", "walnut", "walrus",
    "wampum", "wander", "wangle", "waning", "wanked", "wanker",
    "wanner", "wanted", "wanton", "wapiti", "warble", "warded",
    "warden", "warder", "warier", "warily", "warmed", "warmer",
    "warmly", "warmth", "warned", "warped", "warred", "warren",
    "washed", "washer", "washes", "wasted", "waster", "wastes",
    "waters", "watery", "watter", "wattle", "wavers", "wavier",
    "waving", "waxier", "waxing", "waylay", "wazoos", "weaken",
    "weaker", "weakly", "wealth", "weaned", "weapon", "wearer",
    "weasel", "weaved", "weaver", "weaves", "webbed", "wedded",
    "wedder", "wedged", "wedges", "weeded", "weeder", "weeing",
    "weekly", "weenie", "weeper", "weevil", "wefted", "weighs",
    "weight", "weirdo", "weirds", "weired", "welded", "welder",
    "welkin", "welled", "wellie", "welted", "welter", "wended",
    "wested", "wetter", "whacks", "whaled", "whaler", "whales",
    "whammy", "wharfs", "wheals", "wheels", "wheeze", "wheezy",
    "whelks", "whelps", "whence", "wheres", "whewed", "whiffs",
    "whiled", "whiles", "whilst", "whimsy", "whined", "whiner",
    "whines", "whinge", "whinny", "whirls", "whisks", "whited",
    "whiten", "whiter", "whites", "whitey", "wholes", "wholly",
    "whoops", "whoosh", "whores", "whorls", "wicked", "wicker",
    "wicket", "widely", "widens", "widest", "widget", "widows",
    "widths", "wields", "wiener", "wienie", "wifely", "wigeon",
    "wigged", "wiggle", "wiggly", "wights", "wigwag", "wigwam",
    "wilded", "wilder", "wildly", "wilier", "wiling", "willed",
    "willie", "willow", "wilted", "wimped", "wimple", "winced",
    "winces", "winded", "window", "windup", "winery", "winged",
    "winger", "wining", "winked", "winkle", "winner", "winnow",
    "winter", "wintry", "wipers", "wiping", "wirier", "wiring",
    "wisdom", "wisely", "wisest", "wished", "wisher", "wishes",
    "wising", "withal", "withed", "wither", "withes", "within",
    "witter", "wizard", "wobble", "wobbly", "wodges", "woeful",
    "wolfed", "wolves", "wombat", "wonder", "wonted", "wooded",
    "wooden", "woodsy", "wooers", "woofed", "woofer", "wooing",
    "woolly", "worded", "worked", "worker", "worlds", "wormed",
    "worsen", "worsts", "worthy", "wotcha", "woulds", "wounds",
    "wovens", "wowing", "wracks", "wraith", "wraths", "wreaks",
    "wreath", "wrecks", "wrench", "wrests", "wretch", "wright",
    "wrings", "wrists", "writer", "writes", "writhe", "wrongs",
    "wryest", "wrying", "wusses", "yachts", "yahoos", "yakked",
    "yammer", "yanked", "yapped", "yawing", "yawned", "yearly",
    "yearns", "yeasts", "yeasty", "yelled", "yellow", "yelped",
    "yeoman", "yeomen", "yessed", "yields", "yipped", "yippee",
    "yobbos", "yodels", "yogurt", "yokels", "yoking", "yonder",
    "youths", "yowled", "yuccas", "yucked", "yukked", "yuppie",
    "zanied", "zanier", "zanies", "zapped", "zapper", "zealot",
    "zebras", "zenith", "zephyr", "zeroed", "zigzag", "zinged",
    "zinger", "zinnia", "zipped", "zipper", "zircon", "zither",
    "zodiac", "zombie", "zoning", "zonked", "zoomed", "zydeco",
    "zygote"
  };

  const char* w_7[] = {
    "abalone", "abandon", "abashed", "abashes", "abasing", "abating",
    "abdomen", "abducts", "abetted", "abettor", "abiding", "ability",
    "abjects", "abjured", "abjures", "aboding", "abolish", "aborted",
    "abounds", "abraded", "abrades", "abreast", "abridge", "abscess",
    "abscond", "abseils", "absence", "absents", "absolve", "absorbs",
    "abstain", "abusers", "abusing", "abusive", "abutted", "abysmal",
    "abysses", "acacias", "academe", "academy", "acceded", "accedes",
    "accents", "accepts", "acclaim", "accords", "accosts", "account",
    "accrual", "accrued", "accrues", "accused", "accuser", "accuses",
    "acerbic", "acetate", "acetone", "achiest", "achieve", "acidify",
    "acidity", "acolyte", "aconite", "acquire", "acquits", "acreage",
    "acrider", "acrobat", "acronym", "acrylic", "actions", "actives",
    "actress", "actuary", "actuate", "acutely", "acutest", "adagios",
    "adamant", "adapted", "addenda", "addends", "addicts", "addling",
    "address", "adduced", "adduces", "adenoid", "adepter", "adeptly",
    "adhered", "adheres", "adipose", "adjoins", "adjourn", "adjudge",
    "adjunct", "adjured", "adjures", "adjusts", "admiral", "admired",
    "admirer", "admires", "adopted", "adoring", "adorned", "adrenal",
    "adulate", "advance", "advents", "adverbs", "adverse", "adverts",
    "advised", "adviser", "advises", "aerated", "aerates", "aerator",
    "aerials", "aeriest", "aerobic", "aerosol", "affable", "affably",
    "affairs", "affects", "affirms", "affixed", "affixes", "afflict",
    "affords", "affrays", "affront", "afghans", "against", "ageists",
    "ageless", "agendas", "agilely", "agilest", "agility", "agitate",
    "agonies", "aground", "aileron", "ailment", "aimless", "airbags",
    "airbase", "airbeds", "aircrew", "airdrop", "airfare", "airflow",
    "airguns", "airhead", "airiest", "airings", "airless", "airlift",
    "airline", "airlock", "airmail", "airplay", "airport", "airship",
    "airshow", "airsick", "airtime", "airways", "aisling", "aitches",
    "alarmed", "albinos", "albumen", "albumin", "alchemy", "alcohol",
    "alcoves", "alerted", "alerter", "alertly", "alfalfa", "algebra",
    "aliased", "aliases", "alibied", "aliened", "alights", "aligned",
    "alimony", "allayed", "alleged", "alleges", "allegro", "allergy",
    "allover", "allowed", "alloyed", "alluded", "alludes", "allured",
    "allures", "allying", "almanac", "almonds", "almoner", "alpacas",
    "alpines", "already", "alright", "altered", "alumnae", "alumnus",
    "amalgam", "amassed", "amasses", "amateur", "amatory", "amazing",
    "amazons", "ambient", "ambling", "amended", "amening", "amenity",
    "amiable", "amiably", "ammeter", "ammonia", "amnesia", "amnesty",
    "amoebas", "amoebic", "amongst", "amorous", "amounts", "amperes",
    "amphora", "amplest", "amplify", "ampules", "amputee", "amulets",
    "amusing", "anagram", "analogs", "analogy", "analyst", "anapest",
    "anarchy", "anatomy", "anchors", "anchovy", "ancient", "andante",
    "andiron", "android", "anemone", "angelic", "angered", "anglers",
    "angling", "angoras", "angrier", "angrily", "anguish", "angular",
    "animals", "animate", "animism", "animist", "aniseed", "anklets",
    "ankling", "anneals", "annexed", "annexes", "annoyed", "annuals",
    "annuity", "annular", "anodyne", "anoints", "anomaly", "anoraks",
    "another", "answers", "antacid", "anteing", "antenna", "anthems",
    "anthers", "anthill", "anthrax", "antigen", "antique", "antiwar",
    "antlers", "antonym", "anxiety", "anxious", "anybody", "anymore",
    "anytime", "anyways", "aphasia", "aphasic", "aphelia", "aplenty",
    "apogees", "apology", "apostle", "apparel", "appeals", "appears",
    "appease", "appends", "applaud", "applets", "applied", "applies",
    "appoint", "apprise", "approve", "apricot", "apropos", "aptness",
    "aquatic", "aquavit", "aqueous", "aquifer", "arbiter", "arbutus",
    "arcades", "archaic", "archers", "archery", "archest", "arching",
    "archive", "archway", "arctics", "arduous", "arguing", "argyles",
    "aridest", "aridity", "arising", "armadas", "armband", "armfuls",
    "armhole", "armlets", "armload", "armpits", "armrest", "arousal",
    "aroused", "arouses", "arraign", "arrange", "arrayed", "arrears",
    "arrests", "arrival", "arrived", "arrives", "arroyos", "arsenal",
    "arsenic", "article", "artiest", "artisan", "artiste", "artists",
    "artless", "artsier", "artwork", "arugula", "ascends", "ascents",
    "ascetic", "ascribe", "aseptic", "asexual", "ashamed", "ashcans",
    "ashiest", "ashrams", "ashtray", "asinine", "askance", "asocial",
    "aspects", "asphalt", "aspired", "aspires", "aspirin", "assails",
    "assault", "assayed", "assents", "asserts", "assigns", "assists",
    "assizes", "assorts", "assuage", "assumed", "assumes", "assured",
    "assures", "astound", "astrals", "astride", "astuter", "asunder",
    "asylums", "atavism", "atelier", "atheism", "atheist", "athlete",
    "atishoo", "atlases", "atomics", "atoning", "atrophy", "attacks",
    "attains", "attempt", "attends", "attests", "attired", "attires",
    "attract", "attuned", "attunes", "auction", "audible", "audibly",
    "audited", "auditor", "augment", "augured", "augusts", "aunties",
    "aurally", "aureole", "auricle", "auspice", "austere", "authors",
    "autoing", "autopsy", "autumns", "availed", "avarice", "avatars",
    "avenged", "avenger", "avenges", "avenues", "average", "averred",
    "averted", "aviator", "avidest", "avidity", "avionic", "avocado",
    "avoided", "avowals", "avowing", "awaited", "awakens", "awaking",
    "awarded", "awarest", "awesome", "awfully", "awkward", "awnings",
    "azaleas", "azimuth", "babbled", "babbler", "babbles", "babiest",
    "baboons", "babying", "babyish", "babysat", "babysit", "bacilli",
    "backbit", "backers", "backhoe", "backing", "backlog", "backups",
    "baddest", "baddies", "badgers", "badness", "baffled", "baffles",
    "bagfuls", "baggage", "baggier", "baggies", "bagging", "bagpipe",
    "baileys", "bailiff", "bailing", "bailout", "baiting", "balance",
    "balcony", "baldest", "baldies", "balding", "baleful", "balkier",
    "balking", "ballads", "ballast", "ballets", "balling", "balloon",
    "ballots", "ballsed", "ballses", "balmier", "baloney", "balsams",
    "bamboos", "banaler", "bananas", "bandage", "bandied", "bandier",
    "bandies", "banding", "bandits", "baneful", "bangers", "banging",
    "bangles", "bankers", "banking", "banners", "banning", "bannock",
    "banquet", "banshee", "bantams", "banters", "banyans", "baobabs",
    "baptism", "baptist", "barbell", "barbers", "barbies", "barbing",
    "barfing", "bargain", "barging", "barkers", "barking", "barmaid",
    "barmier", "barneys", "baronet", "baroque", "barrack", "barrage",
    "barrels", "barrens", "barrier", "barring", "barrios", "barroom",
    "barrows", "barters", "baseman", "basemen", "bashful", "bashing",
    "baskets", "basking", "basques", "bassets", "bassist", "bassoon",
    "bastard", "basting", "bastion", "batched", "batches", "bathers",
    "bathing", "bathmat", "bathtub", "batsman", "batsmen", "battens",
    "batters", "battery", "battier", "batting", "battled", "battler",
    "battles", "baubles", "baulked", "bauxite", "bawdier", "bawdily",
    "bawling", "bayonet", "bazaars", "bazooka", "beached", "beaches",
    "beacons", "beadier", "beading", "beagled", "beagles", "beakers",
    "beaming", "beanbag", "beanies", "beaning", "bearded", "bearers",
    "bearing", "bearish", "beastly", "beaters", "beatify", "beating",
    "beatnik", "beavers", "becalms", "because", "beckons", "becomes",
    "bedaubs", "bedbugs", "bedding", "bedecks", "bedevil", "bedhead",
    "bedlams", "bedpans", "bedpost", "bedrock", "bedroll", "bedroom",
    "bedside", "bedsits", "bedsore", "bedtime", "beeches", "beefier",
    "beefing", "beehive", "beeline", "beepers", "beeping", "beeswax",
    "beetled", "beetles", "befalls", "befouls", "beggars", "begging",
    "begonia", "beguile", "behaved", "behaves", "beheads", "behests",
    "behinds", "beholds", "bejewel", "belated", "belayed", "belched",
    "belches", "beliefs", "believe", "bellboy", "bellhop", "bellied",
    "bellies", "belling", "bellows", "belongs", "beloved", "belting",
    "beltway", "belying", "bemoans", "bemused", "bemuses", "benched",
    "benches", "benders", "bendier", "bending", "beneath", "benefit",
    "benumbs", "benzene", "bequest", "berated", "berates", "bereave",
    "berried", "berries", "berserk", "berthed", "beseech", "besides",
    "besiege", "besomed", "bespeak", "bespoke", "bestial", "besting",
    "bestirs", "bestows", "betaken", "betakes", "bethink", "betided",
    "betides", "betoken", "betrays", "betroth", "betters", "betting",
    "bettors", "between", "betwixt", "bevvies", "bewails", "bewared",
    "bewares", "bewitch", "beyonds", "biasing", "bickers", "bicycle",
    "bidders", "biddies", "bidding", "biffing", "bifocal", "biggest",
    "biggies", "bighorn", "bigness", "bigoted", "bigotry", "bigwigs",
    "bikinis", "bilious", "bilking", "billets", "billies", "billing",
    "billion", "billows", "billowy", "binders", "bindery", "binding",
    "binging", "binning", "biology", "biomass", "bionics", "biopics",
    "bipedal", "biplane", "bipolar", "birched", "birches", "birdied",
    "birdies", "birding", "biretta", "birthed", "biscuit", "bisects",
    "bishops", "bismuth", "bistros", "bitched", "bitches", "bitings",
    "bitmaps", "bittern", "bitters", "bitumen", "bivalve", "bivouac",
    "bizarre", "blabbed", "blabber", "blacked", "blacken", "blacker",
    "bladder", "blading", "blagged", "blahing", "blaming", "blander",
    "blandly", "blanked", "blanker", "blanket", "blankly", "blaring",
    "blarney", "blasted", "blaster", "blatant", "blather", "blazers",
    "blazing", "blazons", "bleaker", "bleakly", "bleated", "bleeder",
    "bleeped", "bleeper", "blemish", "blended", "blender", "blessed",
    "blesses", "blether", "blights", "blinded", "blinder", "blindly",
    "blinked", "blinker", "blintze", "blissed", "blisses", "blister",
    "blither", "blitzed", "blitzes", "bloated", "bloater", "blobbed",
    "blocked", "blokish", "blonder", "blooded", "bloomed", "bloomer",
    "blooper", "blossom", "blotchy", "blotted", "blotter", "bloused",
    "blouses", "blowers", "blowgun", "blowing", "blowout", "blowups",
    "blubber", "blueish", "bluffed", "bluffer", "blunder", "blunted",
    "blunter", "bluntly", "blurred", "blurted", "blushed", "blusher",
    "blushes", "bluster", "boarded", "boarder", "boasted", "boaster",
    "boaters", "boating", "boatman", "boatmen", "bobbies", "bobbing",
    "bobbins", "bobbled", "bobbles", "bobcats", "bobsled", "bobtail",
    "bodegas", "bodging", "bodices", "bodkins", "boffins", "bogeyed",
    "boggier", "bogging", "boggled", "boggles", "boilers", "boiling",
    "boldest", "boleros", "bollard", "bolling", "bologna", "bolshie",
    "bolster", "bolting", "bombard", "bombast", "bombers", "bombing",
    "bonanza", "bonbons", "bondage", "bonding", "bonfire", "bonging",
    "boniest", "bonitos", "bonkers", "bonking", "bonnets", "bonnier",
    "bonsais", "bonuses", "boobies", "boobing", "boodles", "boogers",
    "boogied", "boogies", "bookend", "bookies", "booking", "bookish",
    "booklet", "boomers", "booming", "boonies", "boorish", "boosted",
    "booster", "bootees", "booties", "booting", "bootleg", "boozers",
    "boozier", "boozing", "bopping", "borders", "boredom", "borough",
    "borrows", "borscht", "borstal", "bossier", "bossily", "bossing",
    "botched", "botches", "bothers", "bottled", "bottler", "bottles",
    "bottoms", "boudoir", "boulder", "bounced", "bouncer", "bounces",
    "bounded", "bounden", "bounder", "bouquet", "bourbon", "bovines",
    "bowlers", "bowling", "boxcars", "boxroom", "boxwood", "boycott",
    "boyhood", "bracing", "bracken", "bracket", "bradawl", "bragged",
    "bragger", "braided", "braille", "brained", "braised", "braises",
    "braking", "bramble", "branded", "brasher", "brashly", "brassed",
    "brasses", "bravado", "bravely", "bravery", "bravest", "braving",
    "bravura", "brawled", "brawler", "braying", "brazens", "brazier",
    "breaded", "breadth", "breaker", "breakup", "breasts", "breathe",
    "breaths", "breathy", "breding", "breeder", "breezed", "breezes",
    "brevity", "brewers", "brewery", "brewing", "bribery", "bribing",
    "bricked", "brickie", "bridals", "bridged", "bridges", "bridled",
    "bridles", "briefed", "briefer", "briefly", "brigade", "brigand",
    "brights", "brimful", "brimmed", "brinier", "brioche", "brisked",
    "brisker", "brisket", "briskly", "bristle", "bristly", "brittle",
    "broaden", "broader", "broadly", "brocade", "brogans", "brogues",
    "broiled", "broiler", "brokers", "bromide", "bromine", "bronchi",
    "broncos", "bronzed", "bronzes", "brooded", "brooder", "brooked",
    "brothel", "brother", "brought", "browned", "browner", "brownie",
    "browsed", "browser", "browses", "bruised", "bruiser", "bruises",
    "bruited", "brunets", "brunted", "brushed", "brushes", "brusque",
    "brutish", "bubbled", "bubbles", "buckets", "buckeye", "bucking",
    "buckled", "buckler", "buckles", "buckram", "bucksaw", "bucolic",
    "buddies", "budding", "budgets", "budgies", "budging", "buffalo",
    "buffers", "buffets", "buffing", "buffoon", "bugaboo", "bugbear",
    "buggers", "buggery", "buggier", "buggies", "bugging", "buglers",
    "bugling", "builder", "buildup", "bulbing", "bulbous", "bulgier",
    "bulging", "bulimia", "bulimic", "bulkier", "bulking", "bulldog",
    "bullets", "bullied", "bullier", "bullies", "bulling", "bullion",
    "bullish", "bullock", "bullpen", "bulrush", "bulwark", "bumbags",
    "bumbled", "bumbler", "bumbles", "bummers", "bummest", "bumming",
    "bumpers", "bumpier", "bumping", "bumpkin", "bunched", "bunches",
    "bundled", "bundles", "bungees", "bunging", "bungled", "bungler",
    "bungles", "bunions", "bunkers", "bunking", "bunnies", "bunting",
    "buoyant", "buoying", "burbled", "burbles", "burdens", "burdock",
    "bureaus", "burgeon", "burgers", "burgher", "burglar", "burgled",
    "burgles", "burials", "burlier", "burners", "burning", "burnish",
    "burnout", "burping", "burring", "burrito", "burrows", "bursars",
    "bursary", "burying", "busbies", "busboys", "bushels", "bushier",
    "bushing", "bushman", "bushmen", "busiest", "buskers", "busking",
    "busload", "busters", "bustier", "busting", "bustled", "bustles",
    "busying", "butcher", "butches", "butlers", "butters", "buttery",
    "butties", "butting", "buttock", "buttons", "buxomer", "buyouts",
    "buzzard", "buzzers", "buzzing", "bygones", "bylines", "bywords",
    "cabanas", "cabaret", "cabbage", "cabbing", "cabinet", "cabling",
    "caboose", "cachets", "caching", "cackled", "cackles", "cadaver",
    "caddied", "caddies", "caddish", "cadence", "cadenza", "cadgers",
    "cadging", "cadmium", "caducei", "caesura", "caftans", "cagiest",
    "cagoule", "cahoots", "caisson", "cajoled", "cajoles", "calcify",
    "calcine", "calcite", "calcium", "calculi", "caliphs", "callers",
    "calling", "callous", "calmest", "calming", "caloric", "calorie",
    "calumny", "calving", "calypso", "calyxes", "cambers", "cambium",
    "cambric", "cameoed", "camerae", "cameras", "campers", "campest",
    "camphor", "campier", "camping", "canards", "canasta", "cancans",
    "cancels", "cancers", "candida", "candied", "candies", "candled",
    "candles", "canines", "cankers", "cannery", "cannier", "cannily",
    "canning", "cannons", "cantata", "canteen", "canters", "canting",
    "cantons", "cantors", "canvass", "canyons", "capable", "capably",
    "capered", "capital", "capitol", "caplets", "capping", "caprice",
    "capsize", "capstan", "capsule", "captain", "caption", "captive",
    "captors", "capture", "carafes", "caramel", "caravan", "caraway",
    "carbide", "carbine", "carbons", "carboys", "carcase", "carcass",
    "cardiac", "cardies", "carding", "careens", "careers", "careful",
    "carfare", "cargoes", "carhops", "caribou", "carjack", "carload",
    "carmine", "carnage", "caromed", "carotid", "carouse", "carpals",
    "carpels", "carpets", "carping", "carpool", "carport", "carrels",
    "carried", "carrier", "carries", "carrion", "carrots", "carroty",
    "carsick", "cartels", "carters", "carting", "cartons", "cartoon",
    "carvers", "carvery", "carving", "cascade", "cashews", "cashier",
    "cashing", "casings", "casinos", "caskets", "cassava", "cassias",
    "cassock", "casters", "casting", "castled", "castles", "castoff",
    "casuals", "casuist", "catalpa", "catarrh", "catbird", "catboat",
    "catcall", "catcher", "catches", "catered", "caterer", "catfish",
    "cathode", "cations", "catkins", "catnaps", "catsuit", "cattail",
    "cattery", "cattier", "cattily", "catwalk", "caulked", "causals",
    "causing", "caustic", "caution", "cavalry", "caveats", "caveman",
    "cavemen", "caverns", "cavorts", "cayenne", "caymans", "ceasing",
    "cedilla", "ceilidh", "ceiling", "celesta", "cellars", "celling",
    "cellist", "cements", "censers", "censors", "censure", "centaur",
    "centime", "central", "century", "ceramic", "cereals", "cerebra",
    "certain", "certify", "cession", "cesspit", "chaffed", "chafing",
    "chagrin", "chained", "chaired", "chaises", "chalets", "chalice",
    "chalked", "chamber", "chamois", "champed", "chanced", "chancel",
    "chances", "changed", "changes", "channel", "chanted", "chanter",
    "chantey", "chaotic", "chapati", "chapels", "chaplet", "chapped",
    "chapter", "charade", "charged", "charger", "charges", "charier",
    "charily", "chariot", "charity", "charlie", "charmed", "charmer",
    "charred", "charted", "charter", "chasers", "chasing", "chassis",
    "chasten", "chaster", "chatted", "chattel", "chatter", "cheapen",
    "cheaper", "cheaply", "cheated", "cheater", "checked", "checkup",
    "cheddar", "cheeked", "cheeped", "cheered", "cheerio", "cheesed",
    "cheeses", "cheetah", "cheffed", "chemise", "chemist", "cherish",
    "cheroot", "cherubs", "chervil", "chevron", "chewers", "chewier",
    "chewing", "chicane", "chicest", "chichis", "chicken", "chicory",
    "chiding", "chiefer", "chiefly", "chiffon", "chigger", "chignon",
    "childed", "childes", "chilies", "chilled", "chiller", "chimera",
    "chiming", "chimney", "chinked", "chinned", "chintzy", "chinwag",
    "chipped", "chipper", "chippie", "chirped", "chirrup", "chisels",
    "chivied", "chivies", "chiving", "chocked", "choicer", "choices",
    "chokers", "choking", "cholera", "chomped", "chooses", "chopped",
    "chopper", "chorale", "chorals", "choring", "chortle", "chowder",
    "chowing", "chromed", "chromes", "chronic", "chucked", "chuckle",
    "chuffed", "chugged", "chummed", "chunder", "chunter", "churned",
    "chutney", "cicadas", "ciggies", "cinched", "cinches", "cinders",
    "cinemas", "ciphers", "circled", "circles", "circlet", "circuit",
    "cissies", "cistern", "citadel", "citizen", "citrons", "civilly",
    "civvies", "clacked", "claimed", "clamber", "clammed", "clamped",
    "clanged", "clanger", "clanked", "clapped", "clapper", "clarets",
    "clarify", "clarion", "clarity", "clashed", "clashes", "clasped",
    "classed", "classes", "classic", "clatter", "clauses", "clawing",
    "clayier", "cleaned", "cleaner", "cleanly", "cleanse", "cleanup",
    "cleared", "clearer", "clearly", "cleaved", "cleaver", "cleaves",
    "clefted", "clement", "clerics", "clerked", "clewing", "clicked",
    "clients", "climate", "climbed", "climber", "clinics", "clinked",
    "clinker", "clipped", "clipper", "cliques", "cliquey", "cloaked",
    "clobber", "cloches", "clocked", "clodded", "clogged", "clomped",
    "cloning", "clonked", "clopped", "closely", "closest", "closets",
    "closing", "closure", "clothed", "clothes", "clotted", "cloture",
    "clouded", "clouted", "clovers", "clowned", "cloying", "clubbed",
    "clubber", "clucked", "clumped", "clunked", "clunker", "cluster",
    "clutter", "coached", "coaches", "coaling", "coarsen", "coarser",
    "coastal", "coasted", "coaster", "coating", "coaxing", "cobbers",
    "cobbing", "cobbled", "cobbler", "cobbles", "cobnuts", "cobwebs",
    "cocaine", "cochlea", "cockade", "cockier", "cockily", "cocking",
    "cockles", "cockney", "cockpit", "coconut", "cocoons", "codding",
    "coddled", "coddles", "codeine", "codfish", "codgers", "codices",
    "codicil", "coequal", "coerced", "coerces", "coevals", "coexist",
    "coffees", "coffers", "coffins", "cogency", "cognacs", "cognate",
    "cohabit", "cohered", "coheres", "cohorts", "coiffed", "coiling",
    "coinage", "coining", "coldest", "colicky", "colitis", "collage",
    "collars", "collate", "collect", "colleen", "college", "collide",
    "collied", "collier", "collies", "colling", "colloid", "collude",
    "cologne", "colonel", "colossi", "coltish", "columns", "combats",
    "combine", "combing", "comedic", "comfier", "comfort", "comical",
    "comings", "command", "commend", "comment", "commies", "commits",
    "commode", "commons", "commune", "commute", "compact", "company",
    "compare", "compass", "compels", "compete", "compile", "complex",
    "comport", "compose", "compost", "compote", "compute", "comrade",
    "concave", "conceal", "concede", "conceit", "concept", "concern",
    "concert", "conched", "conchie", "concise", "concoct", "concord",
    "concurs", "concuss", "condemn", "condole", "condoms", "condone",
    "condors", "conduce", "conduct", "conduit", "confabs", "confers",
    "confess", "confide", "confine", "confirm", "conform", "confuse",
    "confute", "congaed", "congeal", "congers", "congest", "conical",
    "conifer", "conjoin", "conjure", "conkers", "conking", "connect",
    "conning", "connive", "connote", "conquer", "consent", "consign",
    "consist", "console", "consort", "consuls", "consult", "consume",
    "contact", "contain", "contend", "content", "contest", "context",
    "contort", "contour", "control", "contuse", "convene", "convent",
    "convert", "conveys", "convict", "convoke", "convoys", "cookers",
    "cookery", "cookies", "cooking", "cookout", "coolant", "coolers",
    "coolest", "coolies", "cooling", "coopers", "cooping", "cooties",
    "copiers", "copilot", "copings", "copious", "coppers", "coppery",
    "copping", "copsing", "copters", "copulas", "copycat", "copying",
    "copyist", "coracle", "cordial", "cording", "cordite", "cordons",
    "corkage", "corkers", "corking", "corncob", "corneal", "corneas",
    "corners", "cornets", "cornice", "cornier", "corning", "cornrow",
    "corolla", "coronas", "coroner", "coronet", "corpora", "corpses",
    "corrals", "correct", "corries", "corrode", "corrupt", "corsage",
    "corsair", "corsets", "coshing", "cosigns", "cosines", "cossets",
    "costars", "costing", "costume", "coterie", "cottage", "cotters",
    "cottons", "couched", "couches", "cougars", "coughed", "council",
    "counsel", "counted", "counter", "country", "couping", "coupled",
    "couples", "couplet", "coupons", "courage", "courier", "coursed",
    "courser", "courses", "courted", "courtly", "cousins", "couture",
    "covered", "coverts", "coveted", "cowards", "cowbell", "cowbird",
    "cowboys", "cowered", "cowgirl", "cowhand", "cowhide", "cowlick",
    "cowling", "cowpats", "cowpoke", "cowries", "cowshed", "cowslip",
    "coxcomb", "coyness", "coyotes", "cozened", "crabbed", "cracked",
    "cracker", "crackle", "crackly", "crackup", "cradled", "cradles",
    "crafted", "crammed", "crammer", "cramped", "crampon", "cranial",
    "craning", "cranium", "cranked", "cranker", "crapped", "crapper",
    "crappie", "crashed", "crashes", "crasser", "crassly", "craters",
    "crating", "cravats", "cravens", "craving", "crawled", "crawler",
    "crayons", "crazier", "crazies", "crazily", "crazing", "creaked",
    "creamed", "creamer", "creased", "creases", "created", "creates",
    "creator", "credits", "creeled", "creeper", "cremate", "creoles",
    "crested", "cretins", "crevice", "crewing", "crewman", "crewmen",
    "cribbed", "cricked", "cricket", "criming", "crimped", "crimson",
    "cringed", "cringes", "crinkle", "crinkly", "cripple", "crisped",
    "crisper", "crisply", "critics", "critter", "croaked", "crochet",
    "crocked", "crofter", "cronies", "crooked", "crooned", "crooner",
    "cropped", "cropper", "croquet", "crosier", "crossed", "crosser",
    "crosses", "crossly", "crouped", "crowbar", "crowded", "crowing",
    "crowned", "crucial", "crucify", "crudely", "crudest", "crudity",
    "crueler", "cruelly", "cruelty", "cruised", "cruiser", "cruises",
    "cruller", "crumbed", "crumble", "crumbly", "crumpet", "crumple",
    "crunchy", "crusade", "crushed", "crusher", "crushes", "crusted",
    "crybaby", "cryings", "cryptic", "crystal", "cubical", "cubicle",
    "cubists", "cuboids", "cuckold", "cuckoos", "cuddled", "cuddles",
    "cudgels", "cuffing", "cuisine", "culling", "culotte", "culprit",
    "culture", "culvert", "cumming", "cumulus", "cunning", "cupcake",
    "cupfuls", "cupolas", "cupping", "curable", "curated", "curates",
    "curator", "curdled", "curdles", "curfews", "curious", "curlers",
    "curlews", "curlier", "curling", "currant", "current", "curried",
    "curries", "curring", "cursing", "cursive", "cursors", "cursory",
    "curtail", "curtain", "curtest", "curvier", "curving", "cushier",
    "cushion", "cuspids", "cussing", "custard", "custody", "customs",
    "cutaway", "cutback", "cuticle", "cutlass", "cutlery", "cutlets",
    "cutoffs", "cutouts", "cutters", "cutting", "cyanide", "cyborgs",
    "cycling", "cyclist", "cyclone", "cygnets", "cymbals", "cynical",
    "cyphers", "cypress", "czarina", "czarism", "czarist", "dabbing",
    "dabbled", "dabbler", "dabbles", "dactyls", "daddies", "daemons",
    "daffier", "daftest", "daggers", "dahlias", "dailies", "dairies",
    "daisies", "dallied", "dallies", "damaged", "damages", "damasks",
    "damming", "damning", "dampens", "dampers", "dampest", "damping",
    "damsels", "damsons", "dancers", "dancing", "danders", "dandier",
    "dandies", "dandify", "dandled", "dandles", "dangers", "dangled",
    "dangles", "dankest", "dappers", "dappled", "dapples", "daresay",
    "darkens", "darkest", "darkies", "darling", "darning", "darting",
    "dashiki", "dashing", "datives", "daubers", "daubing", "daunted",
    "dauphin", "dawdled", "dawdler", "dawdles", "dawning", "daybeds",
    "daycare", "daylong", "daytime", "dazzled", "dazzles", "deacons",
    "deadens", "deadest", "deadpan", "deafens", "deafest", "dealers",
    "dealing", "deanery", "deaning", "dearest", "dearies", "dearths",
    "deathly", "debacle", "debarks", "debased", "debases", "debated",
    "debater", "debates", "debauch", "debited", "debrief", "debtors",
    "debunks", "debuted", "decades", "decaffs", "decamps", "decants",
    "decayed", "decease", "deceits", "deceive", "decency", "decibel",
    "decided", "decider", "decides", "decimal", "decking", "declaim",
    "declare", "decline", "decoded", "decoder", "decodes", "decorum",
    "decoyed", "decreed", "decrees", "decried", "decries", "deduced",
    "deduces", "deducts", "deeding", "deejays", "deeming", "deepens",
    "deepest", "defaced", "defaces", "defamed", "defames", "default",
    "defeats", "defects", "defends", "defiant", "deficit", "defiled",
    "defiles", "defined", "definer", "defines", "deflate", "deflect",
    "deforms", "defraud", "defrays", "defrock", "defrost", "deftest",
    "defunct", "defused", "defuses", "defying", "degrade", "degrees",
    "deicers", "deicing", "deified", "deifies", "deigned", "deities",
    "dejects", "delayed", "deleted", "deletes", "delight", "delimit",
    "deliver", "delouse", "deluded", "deludes", "deluged", "deluges",
    "delving", "demands", "demeans", "demerit", "demesne", "demigod",
    "demised", "demises", "demists", "demoing", "demonic", "demoted",
    "demotes", "demotic", "demount", "demurer", "denials", "deniers",
    "denizen", "denoted", "denotes", "densely", "densest", "density",
    "denting", "dentist", "denture", "denuded", "denudes", "denying",
    "departs", "depends", "depicts", "deplane", "deplete", "deplore",
    "deploys", "deports", "deposed", "deposes", "deposit", "deprave",
    "depress", "deprive", "deputed", "deputes", "derails", "derange",
    "derbies", "derided", "derides", "derived", "derives", "derrick",
    "dervish", "descale", "descant", "descend", "descent", "deserts",
    "deserve", "designs", "desired", "desires", "desists", "deskill",
    "desktop", "despair", "despise", "despite", "despoil", "despots",
    "dessert", "destine", "destiny", "destroy", "details", "detains",
    "detects", "detests", "detours", "detoxed", "detoxes", "detract",
    "deucing", "devalue", "develop", "deviant", "deviate", "devices",
    "devilry", "devious", "devised", "devises", "devolve", "devoted",
    "devotee", "devotes", "devours", "dewdrop", "dewiest", "dewlaps",
    "diadems", "diagram", "dialect", "diamond", "diapers", "diaries",
    "diarist", "diatoms", "dibbled", "dibbles", "diciest", "dickens",
    "dickers", "dickeys", "dickier", "dictate", "diction", "diddled",
    "diddles", "diddums", "diesels", "dietary", "dieters", "dieting",
    "differs", "diffuse", "digests", "diggers", "digging", "digital",
    "dignify", "dignity", "digraph", "digress", "diktats", "dilated",
    "dilates", "dilemma", "dillies", "dilling", "diluted", "dilutes",
    "dimmers", "dimmest", "dimming", "dimness", "dimpled", "dimples",
    "dimwits", "dinette", "dingbat", "dingier", "dingies", "dingily",
    "dinging", "dingoes", "dinkier", "dinkies", "dinners", "dinning",
    "diocese", "diorama", "dioxide", "dioxins", "diploma", "dippers",
    "dippier", "dipping", "directs", "dirtied", "dirtier", "dirties",
    "disable", "disarms", "disavow", "disband", "disbars", "discard",
    "discern", "discoed", "discord", "discuss", "disdain", "disease",
    "disgust", "dishing", "dishpan", "dishrag", "dislike", "dismays",
    "dismiss", "disobey", "disowns", "dispels", "display", "disport",
    "dispose", "dispute", "disrobe", "disrupt", "dissect", "dissent",
    "dissing", "distaff", "distant", "distend", "distill", "distort",
    "disturb", "disused", "disuses", "ditched", "ditches", "dithers",
    "ditties", "dittoed", "diurnal", "diverge", "diverse", "diverts",
    "divests", "divided", "divider", "divides", "divined", "diviner",
    "divines", "divisor", "divorce", "divulge", "divvied", "divvies",
    "dizzied", "dizzier", "dizzies", "dizzily", "dobbing", "docents",
    "dockers", "dockets", "docking", "doctors", "dodders", "doddery",
    "dodgems", "dodgers", "dodgier", "dodging", "doffing", "dogcart",
    "dogfish", "doggier", "doggies", "dogging", "doggone", "doglegs",
    "dogsled", "dogtrot", "dogwood", "doilies", "doleful", "dollars",
    "dollies", "dolling", "dollops", "dolmens", "dolphin", "doltish",
    "domains", "donated", "donates", "donkeys", "donning", "donnish",
    "doodads", "doodahs", "doodled", "doodler", "doodles", "dooming",
    "dooring", "doorman", "doormat", "doormen", "doorway", "dopiest",
    "dorkier", "dormant", "dormers", "dormice", "dorsals", "dosages",
    "dossers", "dossier", "dossing", "dotings", "dottier", "dotting",
    "doubled", "doubles", "doublet", "doubted", "doubter", "douched",
    "douches", "doughty", "dourest", "dousing", "dovecot", "dowager",
    "dowdier", "dowdies", "dowdily", "downers", "downier", "downing",
    "dowries", "dowsers", "dowsing", "doyenne", "doziest", "drabber",
    "drachma", "draftee", "dragged", "dragnet", "dragons", "dragoon",
    "drained", "drainer", "drapers", "drapery", "draping", "drastic",
    "dratted", "drawers", "drawing", "drawled", "dreaded", "dreamer",
    "dredged", "dredger", "dredges", "dressed", "dresser", "dresses",
    "dribble", "driblet", "drifted", "drifter", "drilled", "drinker",
    "dripped", "drivels", "drivers", "driving", "drizzle", "drizzly",
    "droller", "droning", "drooled", "drooped", "droplet", "dropout",
    "dropped", "dropper", "drought", "drovers", "drowned", "drowsed",
    "drowses", "drubbed", "drudged", "drudges", "drugged", "druggie",
    "drummed", "drummer", "drunken", "drunker", "dryness", "drywall",
    "dualism", "duality", "dubbing", "dubiety", "dubious", "duchess",
    "duchies", "duckies", "ducking", "ductile", "ducting", "dudgeon",
    "duffers", "duffing", "dugouts", "dukedom", "dullard", "dullest",
    "dulling", "dumbest", "dumbing", "dummies", "dumpers", "dumpier",
    "dumpies", "dumping", "dungeon", "dunging", "dunking", "dunnest",
    "dunning", "duodena", "duopoly", "durable", "durably", "duskier",
    "dustbin", "dusters", "dustier", "dusting", "dustman", "dustmen",
    "dustpan", "duteous", "dutiful", "dwarfed", "dwarfer", "dweller",
    "dwindle", "dynamic", "dynamos", "dynasty", "eagerer", "eagerly",
    "eaglets", "earache", "eardrum", "earfuls", "earldom", "earlier",
    "earlobe", "earmark", "earmuff", "earners", "earnest", "earning",
    "earplug", "earring", "earshot", "earthed", "earthen", "earthly",
    "earwigs", "easiest", "eastern", "eatable", "ebonies", "echelon",
    "echoing", "eclipse", "ecology", "economy", "ecstasy", "eddying",
    "edgiest", "edgings", "edibles", "edifice", "edified", "edifies",
    "editing", "edition", "editors", "educate", "eeriest", "effaced",
    "effaces", "effects", "efforts", "eggcups", "egghead", "egoists",
    "egotism", "egotist", "eighths", "ejected", "elapsed", "elapses",
    "elastic", "elating", "elation", "elbowed", "elderly", "elected",
    "elector", "elegant", "elegiac", "elegies", "element", "elevate",
    "elevens", "elicits", "eliding", "elision", "elitism", "elitist",
    "elixirs", "ellipse", "eloping", "eluding", "elusive", "emailed",
    "emanate", "embalms", "embargo", "embarks", "embassy", "emblems",
    "embrace", "embroil", "embryos", "emended", "emerald", "emerged",
    "emerges", "emeried", "emeries", "emetics", "eminent", "emirate",
    "emitted", "emoting", "emotion", "emotive", "empathy", "emperor",
    "empires", "employs", "empower", "empress", "emptied", "emptier",
    "empties", "emptily", "emulate", "enabled", "enabler", "enables",
    "enacted", "enamels", "encamps", "encased", "encases", "enchant",
    "enclave", "enclose", "encoded", "encoder", "encodes", "encored",
    "encores", "encrust", "encrypt", "endears", "endemic", "endgame",
    "endings", "endives", "endless", "endorse", "endowed", "enduing",
    "endured", "endures", "endways", "enemies", "enfolds", "enforce",
    "engaged", "engages", "engined", "engines", "engorge", "engrave",
    "engross", "engulfs", "enhance", "enigmas", "enjoins", "enjoyed",
    "enlarge", "enlists", "enliven", "ennoble", "enraged", "enrages",
    "ensigns", "enslave", "ensnare", "ensuing", "ensured", "ensures",
    "entails", "entente", "entered", "enthuse", "enticed", "entices",
    "entitle", "entombs", "entrant", "entraps", "entreat", "entries",
    "entropy", "entrust", "entwine", "envelop", "envious", "envying",
    "enzymes", "epaulet", "epicure", "epigram", "episode", "epistle",
    "epitaph", "epithet", "epitome", "epochal", "epoxied", "epoxies",
    "epsilon", "equable", "equably", "equally", "equated", "equates",
    "equator", "equerry", "equines", "equinox", "erasers", "erasing",
    "erasure", "erected", "erectly", "ermines", "eroding", "erosion",
    "erosive", "erotica", "errands", "errants", "erratas", "erratic",
    "erratum", "erudite", "erupted", "escaped", "escapee", "escapes",
    "eschews", "escorts", "escrows", "escudos", "espouse", "espying",
    "esquire", "essayed", "essence", "estates", "esteems", "estuary",
    "etchers", "etching", "eternal", "ethanol", "ethical", "ethnics",
    "eugenic", "eunuchs", "euphony", "eurekas", "evacuee", "evading",
    "evasion", "evasive", "evenest", "evening", "evicted", "evident",
    "evinced", "evinces", "evoking", "evolved", "evolves", "exacted",
    "exacter", "exactly", "exalted", "examine", "example", "exceeds",
    "excepts", "excerpt", "excised", "excises", "excited", "excites",
    "exclaim", "exclude", "excreta", "excrete", "excused", "excuses",
    "execute", "exempts", "exerted", "exhaled", "exhales", "exhaust",
    "exhibit", "exhorts", "exhumed", "exhumes", "exigent", "exiling",
    "existed", "exiting", "exotica", "exotics", "expands", "expanse",
    "expects", "expends", "expense", "experts", "expiate", "expired",
    "expires", "explain", "explode", "exploit", "explore", "exports",
    "exposed", "exposes", "expound", "express", "expunge", "extends",
    "extents", "extinct", "extorts", "extract", "extreme", "extrude",
    "exuding", "exulted", "eyeball", "eyebrow", "eyefuls", "eyelash",
    "eyelets", "eyelids", "eyesore", "fabrics", "facades", "faceted",
    "facials", "facings", "faction", "factors", "factory", "factual",
    "faculty", "faddish", "faffing", "fagging", "failing", "failure",
    "fainest", "faining", "fainted", "fainter", "faintly", "fairest",
    "fairies", "fairway", "faithed", "falcons", "fallacy", "falling",
    "falloff", "fallout", "fallows", "falsely", "falsest", "falsies",
    "falsify", "falsity", "falters", "famines", "fanatic", "fancied",
    "fancier", "fancies", "fancily", "fanfare", "fannies", "fanning",
    "fantasy", "fanzine", "faraway", "farmers", "farming", "farrago",
    "farrier", "farrows", "farther", "farting", "fascias", "fascism",
    "fascist", "fashion", "fastens", "fastest", "fasting", "fatally",
    "fateful", "fathead", "fathers", "fathoms", "fatigue", "fatness",
    "fattens", "fattest", "fattier", "fatties", "fatuous", "faucets",
    "faulted", "fawning", "fearful", "fearing", "feasted", "feather",
    "feature", "febrile", "federal", "fedoras", "feebler", "feedbag",
    "feeders", "feeding", "feelers", "feeling", "feigned", "feinted",
    "felines", "fellers", "fellest", "felling", "fellows", "felting",
    "females", "femoral", "fencers", "fencing", "fenders", "fending",
    "ferment", "ferrets", "ferried", "ferries", "ferrous", "ferrule",
    "fertile", "fervent", "fessing", "festals", "festers", "festive",
    "festoon", "fetched", "fetches", "fetlock", "fetters", "feuding",
    "fevered", "fibbers", "fibbing", "fibroid", "fibrous", "fibulae",
    "fickler", "fiction", "fiddled", "fiddler", "fiddles", "fidgets",
    "fidgety", "fielded", "fielder", "fiercer", "fierier", "fiestas",
    "fifteen", "fifties", "figging", "fighter", "figment", "figured",
    "figures", "filbert", "filched", "filches", "filings", "fillers",
    "fillets", "fillies", "filling", "fillips", "filmier", "filming",
    "filters", "finagle", "finales", "finally", "finance", "finches",
    "finders", "finding", "finesse", "fingers", "finicky", "finises",
    "finking", "finnier", "firearm", "firebug", "firefly", "fireman",
    "firemen", "firings", "firmest", "firming", "firring", "firstly",
    "fiscals", "fishers", "fishery", "fishier", "fishing", "fishnet",
    "fissile", "fission", "fissure", "fistful", "fitment", "fitness",
    "fitters", "fittest", "fitting", "fixable", "fixated", "fixates",
    "fixedly", "fixings", "fixture", "fizzier", "fizzing", "fizzled",
    "fizzles", "flaccid", "flagged", "flagons", "flailed", "flakier",
    "flaking", "flambes", "flaming", "flanges", "flanked", "flannel",
    "flapped", "flapper", "flaring", "flashed", "flasher", "flashes",
    "flatbed", "flatcar", "flatlet", "flatted", "flatten", "flatter",
    "flattop", "flaunts", "flawing", "flaying", "fleabag", "fleapit",
    "flecked", "fledged", "fleeced", "fleeces", "fleeing", "fleeted",
    "fleeter", "fleshed", "fleshes", "fleshly", "flexing", "flicked",
    "flicker", "flights", "flighty", "flipped", "flipper", "flirted",
    "flitted", "floated", "floater", "flocked", "flogged", "flooded",
    "flooder", "floored", "flopped", "florets", "florins", "florist",
    "flossed", "flosses", "flotsam", "flounce", "floured", "flouted",
    "flowers", "flowery", "flowing", "flubbed", "fluency", "fluents",
    "fluffed", "fluidly", "flukier", "fluking", "flummox", "flunked",
    "flushed", "flusher", "flushes", "fluster", "fluting", "flutist",
    "flutter", "fluvial", "fluxing", "flyaway", "flyleaf", "flyover",
    "flypast", "foaling", "foamier", "foaming", "fobbing", "focused",
    "focuses", "fodders", "foggier", "fogging", "foghorn", "foibles",
    "foiling", "foisted", "folders", "folding", "foliage", "follies",
    "follows", "foments", "fondant", "fondest", "fonding", "fondled",
    "fondles", "fondues", "foodies", "foolery", "fooling", "foolish",
    "footage", "footers", "footing", "footman", "footmen", "footsie",
    "fopping", "foppish", "foraged", "forager", "forages", "forayed",
    "forbade", "forbear", "forbids", "forbore", "forceps", "forcing",
    "fording", "forearm", "foreign", "foreleg", "foreman", "foremen",
    "foresaw", "foresee", "forests", "forever", "forfeit", "forgave",
    "forgers", "forgery", "forgets", "forging", "forgive", "forgoes",
    "forgone", "forkful", "forking", "forlorn", "formals", "formats",
    "forming", "formula", "forsake", "forsook", "forties", "fortify",
    "fortune", "forward", "forwent", "fossils", "fosters", "foulest",
    "fouling", "founded", "founder", "foundry", "fourths", "fowling",
    "foxhole", "foxhunt", "foxiest", "foxtrot", "fractal", "fragile",
    "frailer", "frailty", "framers", "framing", "franked", "franker",
    "frankly", "frantic", "frappes", "fraught", "fraying", "frazzle",
    "freaked", "freckle", "freebie", "freedom", "freeing", "freeman",
    "freemen", "freesia", "freeway", "freezer", "freezes", "freight",
    "freshen", "fresher", "freshet", "freshly", "fretful", "fretted",
    "friable", "fridges", "friends", "friezed", "friezes", "frigate",
    "frigged", "frights", "frilled", "fringed", "fringes", "frisked",
    "frisson", "fritter", "frizzed", "frizzes", "frizzle", "frogman",
    "frogmen", "frolics", "frontal", "fronted", "frosted", "frothed",
    "frowned", "fruited", "fuchsia", "fuckers", "fucking", "fuddled",
    "fuddles", "fudging", "fulcrum", "fullest", "fulling", "fulsome",
    "fumbled", "fumbler", "fumbles", "funding", "funeral", "funfair",
    "fungals", "fungoid", "fungous", "funkier", "funking", "funnels",
    "funnest", "funnier", "funnies", "funnily", "furbish", "furious",
    "furling", "furlong", "furnace", "furnish", "furrier", "furring",
    "furrows", "further", "furtive", "fusible", "fusions", "fussier",
    "fussily", "fussing", "fusspot", "fustian", "fustier", "futures",
    "futzing", "fuzzier", "fuzzily", "fuzzing", "gabbier", "gabbing",
    "gabbled", "gabbles", "gabling", "gadding", "gadgets", "gaffers",
    "gaffing", "gagging", "gaggles", "gainers", "gainful", "gaining",
    "gainsay", "gaiters", "gallant", "galleon", "gallery", "galleys",
    "galling", "gallium", "gallons", "gallops", "gallows", "galores",
    "galumph", "gambits", "gambled", "gambler", "gambles", "gambols",
    "gametes", "gamiest", "gamines", "ganders", "ganging", "ganglia",
    "gangsta", "gangway", "gannets", "gantlet", "gaolers", "gaoling",
    "gapings", "garaged", "garages", "garbage", "garbing", "garbled",
    "garbles", "gardens", "gargled", "gargles", "garland", "garlics",
    "garment", "garners", "garnets", "garnish", "garrets", "garrote",
    "garters", "gasbags", "gaseous", "gashing", "gaskets", "gasohol",
    "gasping", "gassier", "gassing", "gastric", "gateaux", "gateway",
    "gathers", "gaucher", "gauchos", "gaudier", "gaudily", "gaunted",
    "gaunter", "gauzier", "gavotte", "gawkier", "gawkies", "gawkily",
    "gawking", "gawping", "gayness", "gazebos", "gazelle", "gazette",
    "gazumps", "gearbox", "gearing", "geekier", "geezers", "gelatin",
    "gelding", "gelling", "genders", "general", "generic", "geneses",
    "genesis", "genetic", "genital", "genning", "genomes", "genteel",
    "gentian", "gentile", "gentled", "gentler", "gentles", "genuine",
    "geology", "gerbils", "germane", "gerunds", "gestalt", "gestate",
    "gesture", "getaway", "getting", "gewgaws", "geysers", "ghastly",
    "gherkin", "ghettos", "ghosted", "ghostly", "gibbers", "gibbets",
    "gibbons", "giblets", "giddier", "giddily", "gifting", "gigging",
    "giggled", "giggler", "giggles", "gigolos", "gilding", "gillies",
    "gimlets", "gimmick", "gimpier", "gingers", "gingery", "gingham",
    "ginning", "ginseng", "giraffe", "girders", "girding", "girdled",
    "girdles", "girlish", "girting", "gizzard", "glacial", "glacier",
    "gladden", "gladder", "glanced", "glances", "glaring", "glassed",
    "glasses", "glazier", "glazing", "gleamed", "gleaned", "gleeful",
    "glibber", "gliders", "gliding", "glimmer", "glimpse", "glinted",
    "glisten", "glitter", "gloated", "globing", "globule", "glopped",
    "gloried", "glories", "glorify", "glossed", "glosses", "glottis",
    "gloving", "glowers", "glowing", "glucose", "gluiest", "glummer",
    "glutted", "glutton", "gnarled", "gnashed", "gnashes", "gnawing",
    "gnocchi", "gnomish", "goading", "goalies", "goaling", "goatees",
    "gobbets", "gobbing", "gobbled", "gobbler", "gobbles", "goblets",
    "goblins", "goddamn", "goddess", "godhood", "godless", "godlier",
    "godlike", "godsend", "godsons", "goggled", "goggles", "goldest",
    "golfers", "golfing", "gollies", "gondola", "gonging", "goobers",
    "goodbye", "goodies", "goodish", "goofier", "goofing", "gooiest",
    "goosing", "gophers", "gorging", "gorgons", "goriest", "gorilla",
    "gosling", "gospels", "gossips", "gossipy", "gouache", "gougers",
    "gouging", "goulash", "gourmet", "goutier", "governs", "gowning",
    "grabbed", "grabber", "gracing", "grackle", "graders", "grading",
    "gradual", "grafted", "grafter", "grammar", "grammes", "granary",
    "grandad", "grandee", "grander", "grandly", "grandma", "grandpa",
    "granges", "granite", "granola", "granted", "granule", "graphed",
    "graphic", "graping", "grapnel", "grapple", "grasped", "grassed",
    "grasses", "graters", "gratify", "grating", "gratins", "gravels",
    "gravely", "gravest", "gravies", "graving", "gravity", "grayish",
    "grazing", "greased", "greaser", "greases", "greater", "greatly",
    "greened", "greener", "greeted", "gremlin", "grenade", "gridded",
    "griddle", "griding", "grieved", "grieves", "griffin", "grilled",
    "grilles", "grimace", "grimier", "griming", "grimmer", "grinder",
    "gringos", "grinned", "griping", "gripped", "grippes", "gristle",
    "gristly", "gritted", "gritter", "grizzle", "grizzly", "groaned",
    "grocers", "grocery", "grommet", "groomed", "grooved", "grooves",
    "groping", "grossed", "grosser", "grosses", "grossly", "grouchy",
    "grounds", "grouped", "grouper", "groupie", "groused", "grouses",
    "grouted", "grovels", "growers", "growing", "growled", "grownup",
    "growths", "groynes", "grubbed", "grudged", "grudges", "gruffed",
    "gruffer", "gruffly", "grumble", "grunted", "guarded", "guessed",
    "guesser", "guesses", "guested", "guffaws", "guiding", "guilder",
    "guiling", "guineas", "guitars", "gulches", "gullets", "gullies",
    "gulling", "gulping", "gumball", "gumboot", "gumdrop", "gummier",
    "gumming", "gumshoe", "gunboat", "gunfire", "gunners", "gunnery",
    "gunning", "gunshot", "gunwale", "guppies", "gurgled", "gurgles",
    "gurneys", "gushers", "gushier", "gushing", "gussets", "gustier",
    "gusting", "gutless", "gutsier", "gutters", "gutting", "guvnors",
    "guzzled", "guzzler", "guzzles", "gymnast", "gymslip", "gypping",
    "gypsies", "gyrated", "gyrates", "habitat", "hackers", "hacking",
    "hackles", "hackney", "hacksaw", "haddock", "hafnium", "haggard",
    "hagging", "haggled", "haggler", "haggles", "hailing", "haircut",
    "hairdos", "hairier", "hairnet", "hairpin", "halberd", "halcyon",
    "halfway", "halfwit", "halibut", "hallows", "hallway", "halogen",
    "haloing", "halters", "halting", "halving", "halyard", "hamlets",
    "hammers", "hamming", "hammock", "hampers", "hamster", "handbag",
    "handcar", "handful", "handgun", "handier", "handily", "handing",
    "handled", "handler", "handles", "handout", "handsaw", "handset",
    "hangars", "hangdog", "hangers", "hanging", "hangman", "hangmen",
    "hangout", "hankers", "hankies", "hansoms", "hapless", "happens",
    "happier", "happily", "hardens", "hardest", "hardier", "hardily",
    "hardtop", "harelip", "haricot", "harking", "harlots", "harmful",
    "harming", "harmony", "harness", "harpies", "harping", "harpist",
    "harpoon", "harried", "harries", "harrows", "harsher", "harshly",
    "harvest", "hashing", "hashish", "hassled", "hassles", "hassock",
    "hastens", "hastier", "hastily", "hasting", "hatband", "hatched",
    "hatches", "hatchet", "hateful", "hatpins", "hatreds", "hatters",
    "hatting", "haughty", "haulage", "haulers", "haulier", "hauling",
    "haunted", "hauteur", "hawkers", "hawking", "hawkish", "hawsers",
    "haycock", "hayloft", "haymows", "hayrick", "hayride", "hayseed",
    "haywire", "hazards", "haziest", "hazings", "headers", "headier",
    "heading", "headman", "headmen", "headset", "headway", "healers",
    "healing", "healthy", "heaping", "hearers", "hearing", "hearken",
    "hearsay", "hearsed", "hearses", "hearted", "hearten", "hearths",
    "heaters", "heathen", "heather", "heating", "heavens", "heavier",
    "heavies", "heavily", "heaving", "heckled", "heckler", "heckles",
    "hectare", "hectics", "hectors", "hedging", "heedful", "heeding",
    "heehaws", "heeling", "heftier", "heftily", "hefting", "heifers",
    "heights", "heinous", "heiress", "heisted", "helical", "helices",
    "helipad", "helling", "hellion", "hellish", "helluva", "helmets",
    "helpers", "helpful", "helping", "hemline", "hemlock", "hemming",
    "hennaed", "henpeck", "hepatic", "heppest", "heralds", "herbage",
    "herbals", "herding", "heretic", "hermits", "hernias", "heroics",
    "heroine", "heroins", "heroism", "herring", "herself", "hessian",
    "heteros", "hexagon", "heydays", "hibachi", "hickeys", "hickory",
    "hideous", "hideout", "hidings", "highboy", "highers", "highest",
    "highway", "hijacks", "hillier", "hillock", "hilltop", "himself",
    "hinders", "hinging", "hinting", "hipbath", "hippest", "hippier",
    "hippies", "hipping", "hipster", "hirsute", "hissing", "history",
    "hitched", "hitches", "hitters", "hitting", "hoarded", "hoarder",
    "hoarier", "hoarser", "hoaxers", "hoaxing", "hobbies", "hobbled",
    "hobbles", "hobnail", "hobnobs", "hoboing", "hocking", "hoedown",
    "hogging", "hoggish", "hogwash", "hoicked", "hoisted", "hokiest",
    "holdall", "holders", "holding", "holdout", "holdups", "holiday",
    "holiest", "hollers", "hollies", "hollows", "holster", "homaged",
    "homages", "homburg", "homeboy", "homered", "homiest", "homonym",
    "honchos", "honesty", "honeyed", "honkies", "honking", "hooding",
    "hoodlum", "hoodoos", "hoofers", "hoofing", "hookahs", "hookers",
    "hookier", "hooking", "hookups", "hooping", "hoorays", "hooters",
    "hooting", "hoovers", "hopeful", "hoppers", "hopping", "hording",
    "horizon", "hormone", "hornets", "hornier", "horrify", "horrors",
    "horsier", "horsing", "hosanna", "hosiery", "hospice", "hostage",
    "hostels", "hostess", "hostile", "hosting", "hostler", "hotbeds",
    "hotcake", "hotfoot", "hothead", "hotness", "hotpots", "hotshot",
    "hottest", "hotting", "hounded", "housing", "hovered", "howdahs",
    "howdied", "howdies", "however", "howlers", "howling", "hubbies",
    "hubbubs", "hubcaps", "huddled", "huddles", "huffier", "huffily",
    "huffing", "hugging", "hulaing", "hulking", "hulling", "humaner",
    "humanly", "humbled", "humbler", "humbles", "humbugs", "humdrum",
    "humerus", "humidor", "humming", "hummock", "humping", "hunched",
    "hunches", "hundred", "hungers", "hunkers", "hunkier", "hunters",
    "hunting", "hurdled", "hurdler", "hurdles", "hurlers", "hurling",
    "hurried", "hurries", "hurtful", "hurting", "hurtled", "hurtles",
    "husband", "hushing", "huskers", "huskier", "huskies", "huskily",
    "husking", "hussars", "hussies", "hustled", "hustler", "hustles",
    "hutched", "hutches", "hybrids", "hydrant", "hydrate", "hygiene",
    "hymnals", "hymning", "hyphens", "iambics", "iceberg", "icecaps",
    "icicles", "iciness", "ickiest", "ideally", "idiotic", "idyllic",
    "iffiest", "igneous", "ignited", "ignites", "ignoble", "ignobly",
    "ignored", "ignores", "iguanas", "illegal", "illicit", "illness",
    "imagery", "imagine", "imaging", "imbibed", "imbibes", "imbuing",
    "imitate", "immense", "immerse", "immoral", "immured", "immures",
    "impacts", "impairs", "impalas", "impaled", "impales", "impanel",
    "imparts", "impasse", "impeach", "impeded", "impedes", "impends",
    "imperil", "impetus", "impiety", "impinge", "impious", "implant",
    "implied", "implies", "implode", "implore", "imports", "imposed",
    "imposes", "impound", "impress", "imprint", "improve", "impugns",
    "impulse", "impurer", "imputed", "imputes", "inanely", "inanest",
    "inanity", "inboard", "inbound", "inbreds", "inbreed", "inbuilt",
    "incense", "inching", "incised", "incises", "incisor", "incited",
    "incites", "incline", "include", "incomer", "incomes", "incubus",
    "indeeds", "indents", "indexed", "indexes", "indicts", "indoors",
    "induced", "induces", "inducts", "indulge", "ineptly", "inertia",
    "inertly", "inexact", "infancy", "infants", "infects", "inferno",
    "infests", "infidel", "infield", "infills", "inflame", "inflate",
    "inflect", "inflict", "inflows", "informs", "infused", "infuses",
    "ingests", "ingrain", "ingrate", "ingress", "ingrown", "inhabit",
    "inhaled", "inhaler", "inhales", "inhered", "inheres", "inherit",
    "inhibit", "inhuman", "initial", "injects", "injured", "injures",
    "inkblot", "inkiest", "inkling", "inkwell", "inmates", "innards",
    "innings", "inquest", "inroads", "insaner", "inseams", "insects",
    "inserts", "inshore", "insider", "insides", "insight", "insipid",
    "insists", "insofar", "insoles", "inspect", "inspire", "install",
    "instant", "instead", "insteps", "instill", "insular", "insulin",
    "insults", "insured", "insurer", "insures", "intakes", "integer",
    "intends", "intense", "intents", "interim", "interns", "intoned",
    "intones", "intrude", "intuits", "inuring", "invaded", "invader",
    "invades", "invalid", "inveigh", "invents", "inverse", "inverts",
    "invests", "invited", "invites", "invoice", "invoked", "invokes",
    "involve", "inwards", "ipecacs", "irately", "iratest", "iridium",
    "irksome", "ironies", "ironing", "islands", "isobars", "isolate",
    "isotope", "issuing", "isthmus", "italics", "itchier", "itching",
    "iterate", "ivories", "jabbers", "jabbing", "jackals", "jackass",
    "jackdaw", "jackets", "jacking", "jackpot", "jaguars", "jailers",
    "jailing", "jambing", "jammier", "jamming", "jangled", "jangles",
    "janitor", "jarring", "jasmine", "jaunted", "javelin", "jawbone",
    "jawline", "jaywalk", "jazzier", "jazzing", "jealous", "jeering",
    "jellied", "jellies", "jelling", "jemmied", "jemmies", "jerkier",
    "jerkily", "jerking", "jerkins", "jerseys", "jesters", "jesting",
    "jetties", "jetting", "jewelry", "jibbing", "jiffies", "jiggers",
    "jigging", "jiggled", "jiggles", "jigsaws", "jilting", "jimmied",
    "jimmies", "jingled", "jingles", "jinking", "jinxing", "jitneys",
    "jitters", "jittery", "jobbers", "jobbing", "jobless", "jockeys",
    "jocking", "jocular", "joggers", "jogging", "joggled", "joggles",
    "joiners", "joinery", "joining", "jointed", "jointly", "jokiest",
    "jollied", "jollier", "jollies", "jollity", "jolting", "jonquil",
    "joshing", "jostled", "jostles", "jotters", "jotting", "jounced",
    "jounces", "journal", "journey", "journos", "jousted", "joyless",
    "joyride", "joyrode", "jubilee", "judders", "judging", "jugfuls",
    "jugging", "juggled", "juggler", "juggles", "jugular", "juicers",
    "juicier", "juicing", "jujitsu", "jujubes", "jukebox", "jumbled",
    "jumbles", "jumpers", "jumpier", "jumping", "jungles", "juniors",
    "juniper", "junkers", "junkets", "junkier", "junkies", "junking",
    "jurists", "juryman", "jurymen", "justest", "justice", "justify",
    "jutting", "karakul", "karaoke", "katydid", "kayaked", "keeling",
    "keenest", "keening", "keepers", "keeping", "kegging", "kelvins",
    "kennels", "kenning", "keratin", "kernels", "kestrel", "ketches",
    "ketchup", "kettles", "keyhole", "keynote", "keypads", "keyword",
    "kibbutz", "kickers", "kickier", "kicking", "kickoff", "kidders",
    "kiddied", "kiddies", "kidding", "kidnaps", "kidneys", "killers",
    "killing", "killjoy", "kilning", "kiloton", "kimonos", "kindest",
    "kindled", "kindles", "kindred", "kinetic", "kinfolk", "kingdom",
    "kingpin", "kinkier", "kinking", "kinship", "kinsman", "kinsmen",
    "kippers", "kipping", "kirking", "kissers", "kissing", "kitchen",
    "kithing", "kitschy", "kittens", "kitties", "kitting", "klaxons",
    "klutzes", "knacked", "knacker", "knavery", "knavish", "kneaded",
    "kneader", "kneecap", "kneeing", "knelled", "knicker", "knifing",
    "knights", "knitted", "knitter", "knobbly", "knocked", "knocker",
    "knotted", "knowing", "knuckle", "kookier", "kooking", "kopecks",
    "koshers", "kowtows", "krypton", "kumquat", "labials", "laciest",
    "lackeys", "lacking", "laconic", "lacquer", "lactate", "lactose",
    "lacunae", "ladders", "laddies", "laddish", "ladings", "ladling",
    "ladybug", "laggard", "lagging", "lagoons", "lambada", "lambent",
    "lambing", "lambkin", "laments", "lamming", "lampoon", "lamprey",
    "lancers", "lancets", "lancing", "landing", "languid", "languor",
    "lankest", "lankier", "lanolin", "lantern", "lanyard", "lapdogs",
    "lapping", "lapsing", "laptops", "lapwing", "larceny", "larches",
    "larders", "larding", "largely", "largess", "largest", "largish",
    "lariats", "larking", "lasagna", "lashing", "lassies", "lassoed",
    "lasting", "latched", "latches", "latency", "latents", "lateral",
    "lathers", "lathery", "lathing", "latrine", "lattice", "lauding",
    "laughed", "launder", "laundry", "laurels", "lawless", "lawsuit",
    "lawyers", "laxness", "layaway", "layered", "layette", "layoffs",
    "layouts", "layover", "laziest", "lazying", "leached", "leaches",
    "leaders", "leading", "leafier", "leafing", "leaflet", "leagued",
    "leagues", "leakage", "leakier", "leaking", "leanest", "leaning",
    "leaping", "learner", "leashed", "leashes", "leasing", "leather",
    "leavens", "leavers", "leaving", "lechers", "lechery", "leching",
    "lectern", "lecture", "ledgers", "leeched", "leeches", "leerier",
    "leering", "leeward", "leftest", "lefties", "leftism", "leftist",
    "legally", "legated", "legatee", "legates", "legatos", "legends",
    "leggier", "legging", "legible", "legibly", "legions", "legless",
    "legroom", "legumes", "legwork", "leisure", "lemming", "lemoned",
    "lenders", "lending", "lengths", "lengthy", "lenient", "lentils",
    "leonine", "leopard", "leotard", "leprosy", "leprous", "lesbian",
    "lesions", "lessees", "lessens", "lessons", "lessors", "letches",
    "letdown", "lethals", "letters", "letting", "lettuce", "levered",
    "levying", "lewdest", "lexical", "lexicon", "liaised", "liaises",
    "liaison", "libbing", "liberal", "liberty", "libidos", "library",
    "lichens", "licking", "liefest", "lifting", "liftoff", "lighted",
    "lighten", "lighter", "lightly", "lignite", "likable", "likened",
    "lilting", "limbers", "limboed", "limeade", "limiest", "limited",
    "limning", "limpest", "limpets", "limping", "linctus", "lindens",
    "lineage", "lineman", "linemen", "lineups", "lingers", "lingoes",
    "lingual", "linings", "linkage", "linking", "linkman", "linkmen",
    "linkups", "linnets", "linseed", "lintels", "lioness", "lipread",
    "liquefy", "liqueur", "liquids", "liquors", "lisping", "lissome",
    "listens", "listing", "litchis", "literal", "lithely", "lithest",
    "lithium", "litters", "littler", "liturgy", "livable", "livened",
    "lividly", "livings", "lizards", "loaders", "loading", "loafers",
    "loafing", "loamier", "loaners", "loaning", "loathed", "loather",
    "loathes", "lobbied", "lobbies", "lobbing", "lobster", "localed",
    "locales", "locally", "located", "locates", "lockers", "lockets",
    "locking", "lockjaw", "lockout", "lockups", "locusts", "lodgers",
    "lodging", "loftier", "loftily", "lofting", "logbook", "loggers",
    "logging", "logical", "logjams", "loiters", "lollies", "lolling",
    "lollops", "longbow", "longest", "longing", "longish", "loofahs",
    "lookers", "looking", "lookout", "looming", "loonier", "loonies",
    "loopier", "looping", "loosely", "loosens", "loosest", "loosing",
    "looters", "looting", "lopping", "lording", "lorries", "lotions",
    "lottery", "lotuses", "loudest", "lounged", "lounger", "lounges",
    "louring", "lousier", "lousing", "loutish", "lovable", "lovings",
    "lowbrow", "lowdown", "lowered", "lowland", "lowlier", "lowness",
    "loyaler", "loyally", "loyalty", "lozenge", "lubbers", "lucidly",
    "luckier", "luckily", "lucking", "luggage", "lugging", "lughole",
    "lullaby", "lulling", "lumbago", "lumbers", "lumpier", "lumping",
    "lumpish", "lunatic", "lunched", "lunches", "lungful", "lunging",
    "lurched", "lurches", "luridly", "lurking", "lushest", "lustful",
    "lustier", "lustily", "lusting", "luvvies", "lyceums", "lynched",
    "lynches", "lyrical", "macabre", "macadam", "machete", "machine",
    "macrons", "madcaps", "maddens", "madders", "maddest", "madness",
    "maestro", "mafiosi", "mafioso", "magenta", "maggots", "magical",
    "magnate", "magneto", "magnets", "magnify", "magnums", "magpies",
    "mahatma", "maidens", "mailbag", "mailbox", "mailers", "mailing",
    "mailman", "mailmen", "maiming", "majesty", "majored", "majorly",
    "makeups", "makings", "malaise", "malaria", "maliced", "malices",
    "maligns", "mallard", "mallets", "malling", "mallows", "malteds",
    "malting", "mamboed", "mammals", "mammary", "mammies", "mammoth",
    "manacle", "managed", "manager", "manages", "manatee", "mandala",
    "mandate", "mangers", "mangier", "manging", "mangled", "mangles",
    "mangoes", "manhole", "manhood", "manhunt", "maniacs", "manikin",
    "mankind", "manlier", "manners", "manning", "mannish", "mansard",
    "mansion", "mantels", "mantled", "mantles", "mantras", "manuals",
    "manumit", "manured", "manures", "mapping", "marabou", "maracas",
    "marauds", "marbled", "marbles", "marched", "marcher", "marches",
    "margins", "marimba", "marinas", "mariner", "marines", "marital",
    "markers", "markets", "marking", "markups", "marlins", "marmots",
    "maroons", "marquee", "marques", "marquis", "married", "marries",
    "marring", "marrows", "marshal", "marshes", "martens", "martial",
    "marting", "martini", "martins", "martyrs", "marvels", "mascara",
    "mascots", "mashers", "mashing", "masking", "masonic", "masonry",
    "masques", "massage", "masseur", "massifs", "massing", "massive",
    "masters", "mastery", "mastiff", "mastoid", "matador", "matched",
    "matches", "matrons", "matters", "matting", "mattock", "matured",
    "maturer", "matures", "matzohs", "matzoth", "maudlin", "mauling",
    "maunder", "mawkish", "maxilla", "maximal", "maximum", "maydays",
    "mayoral", "maypole", "meadows", "mealier", "mealies", "mealing",
    "meander", "meanest", "meanies", "meaning", "measles", "measure",
    "meatier", "meddled", "meddler", "meddles", "medians", "mediate",
    "medical", "medicos", "mediums", "medleys", "medulla", "meekest",
    "meeting", "megaton", "melange", "melanin", "melding", "mellows",
    "melodic", "melting", "members", "memento", "memoirs", "menaced",
    "menaces", "menages", "menders", "mending", "menfolk", "menials",
    "menorah", "menthol", "mention", "mentors", "mercies", "mercury",
    "mergers", "merging", "merinos", "merited", "mermaid", "merrier",
    "merrily", "mescals", "meshing", "message", "messiah", "messier",
    "messily", "messing", "mestizo", "meteors", "methane", "methods",
    "metrics", "mewling", "miasmas", "mickeys", "microbe", "microns",
    "middies", "middles", "midgets", "midland", "midmost", "midriff",
    "midterm", "midtown", "midways", "midweek", "midwife", "midyear",
    "miffing", "migrant", "migrate", "mildest", "mildews", "mileage",
    "milieus", "militia", "milkier", "milking", "milkman", "milkmen",
    "milksop", "millage", "millers", "milling", "million", "mimetic",
    "mimicry", "mimosas", "minaret", "mincers", "mincing", "minders",
    "mindful", "minding", "mindset", "mineral", "mingled", "mingles",
    "minibar", "minibus", "minicab", "minicam", "minimal", "minimum",
    "minions", "minivan", "minnows", "minored", "minster", "mintier",
    "minting", "minuend", "minuets", "minuses", "minuted", "minuter",
    "minutes", "minutia", "miracle", "mirages", "mirrors", "miscall",
    "miscast", "miscued", "miscues", "misdeal", "misdeed", "misdoes",
    "misdone", "miserly", "misfire", "misfits", "mishaps", "mishear",
    "mishits", "mislaid", "mislays", "mislead", "misname", "misplay",
    "misread", "misrule", "missals", "missile", "missing", "mission",
    "missive", "misstep", "mistake", "misters", "mistier", "mistily",
    "mistime", "misting", "mistook", "mistype", "misused", "misuses",
    "mitosis", "mittens", "mixture", "mizzens", "moaners", "moaning",
    "moating", "mobbing", "mobiles", "mobster", "mockers", "mockery",
    "mocking", "moderns", "modesty", "modicum", "modular", "modules",
    "modulus", "moggies", "moisten", "moister", "moistly", "molders",
    "molests", "mollify", "mollusk", "molting", "moments", "mommies",
    "monarch", "moneyed", "mongers", "mongols", "mongrel", "moniker",
    "monitor", "monkeys", "monocle", "monsoon", "monster", "montage",
    "monthly", "mooched", "moocher", "mooches", "moodier", "moodily",
    "mooning", "moonlit", "moorhen", "mooring", "mooting", "moppets",
    "mopping", "moraine", "morally", "mordant", "moreish", "morgues",
    "morning", "morocco", "moronic", "morphed", "morphia", "morrows",
    "morsels", "mortals", "mortars", "mortify", "mortise", "mosaics",
    "moseyed", "moshing", "mosques", "mossier", "mossies", "mossing",
    "mothers", "motiles", "motions", "motives", "motleys", "motlier",
    "motored", "mottled", "mottles", "mottoes", "moulder", "moulted",
    "mounded", "mounted", "mourned", "mourner", "mousers", "mousier",
    "mousing", "moussed", "mousses", "mouthed", "movable", "muckier",
    "mucking", "muddied", "muddier", "muddies", "muddled", "muddles",
    "mudflap", "mudflat", "mudpack", "muezzin", "muffing", "muffins",
    "muffled", "muffler", "muffles", "muggers", "muggier", "mugging",
    "muggins", "mukluks", "mulatto", "mulched", "mulches", "mullahs",
    "mullets", "mulling", "mullion", "mumbled", "mumbler", "mumbles",
    "mummers", "mummery", "mummies", "mummify", "munched", "munches",
    "mundane", "murders", "murkier", "murkily", "murmurs", "muscled",
    "muscles", "museums", "mushers", "mushier", "mushing", "musical",
    "musings", "muskets", "muskier", "musking", "muskrat", "mussels",
    "mussier", "mussing", "mustang", "mustard", "musters", "mustier",
    "mutable", "mutants", "mutated", "mutates", "mutters", "muumuus",
    "muzzily", "muzzled", "muzzles", "myopics", "myriads", "myrtles",
    "mystery", "mystics", "mystify", "nabbing", "naffest", "nagging",
    "nailing", "naively", "naivest", "naivety", "nakeder", "nakedly",
    "nannied", "nannies", "napalms", "naphtha", "napkins", "nappier",
    "nappies", "napping", "narcing", "narrate", "narrows", "narwhal",
    "nasally", "nascent", "nastier", "nastily", "nations", "natives",
    "natters", "nattier", "nattily", "natural", "natured", "natures",
    "naughty", "navvies", "nearest", "nearing", "neatens", "neatest",
    "nebulae", "nebular", "necking", "necktie", "needful", "needier",
    "needing", "needled", "needles", "negated", "negates", "neglect",
    "negroid", "neighed", "neither", "nemeses", "nemesis", "neonate",
    "nephews", "nerdier", "nervier", "nerving", "nervous", "nesting",
    "nestled", "nestles", "netball", "netting", "nettled", "nettles",
    "network", "neurone", "neurons", "neuters", "neutral", "neutron",
    "newbies", "newborn", "newness", "newsboy", "newsier", "newsing",
    "newsman", "newsmen", "newtons", "nexuses", "nibbing", "nibbled",
    "nibbler", "nibbles", "nickels", "nicking", "niftier", "niggard",
    "niggers", "niggled", "niggles", "nighest", "nightie", "nightly",
    "nilling", "nimbler", "ninepin", "ninnies", "nippers", "nippier",
    "nipping", "nippled", "nipples", "nirvana", "nitpick", "nitrate",
    "nitwits", "nobbled", "nobbles", "noblest", "nodding", "noddles",
    "nodular", "nodules", "noggins", "noisier", "noisily", "noising",
    "noisome", "nomadic", "nominal", "nominee", "noncoms", "nonplus",
    "nonskid", "nonstop", "nonuser", "nonzero", "noodled", "noodles",
    "noonday", "nooning", "norming", "nosebag", "nosegay", "noshing",
    "nostril", "nostrum", "notable", "notably", "notched", "notches",
    "notelet", "notepad", "nothing", "noticed", "notices", "notions",
    "nougats", "nourish", "novella", "novelty", "novices", "nowhere",
    "noxious", "nozzles", "nuanced", "nuances", "nuclear", "nucleic",
    "nucleus", "nudging", "nudists", "nuggets", "nullify", "nullity",
    "numbers", "numbest", "numbing", "numeral", "numeric", "nuncios",
    "nunnery", "nuptial", "nursery", "nursing", "nurture", "nutcase",
    "nutmeat", "nutmegs", "nutrias", "nutters", "nuttier", "nutting",
    "nuzzled", "nuzzles", "nymphet", "nymphos", "oarlock", "oarsman",
    "oarsmen", "oatcake", "oatmeal", "obelisk", "obesity", "obeying",
    "objects", "obliged", "obliges", "oblique", "oblongs", "obloquy",
    "oboists", "obscene", "obscure", "obsequy", "observe", "obtains",
    "obtrude", "obtuser", "obverse", "obviate", "obvious", "ocarina",
    "occlude", "oceanic", "ocelots", "octagon", "octanes", "octaves",
    "octopus", "oculars", "oculist", "oddball", "oddment", "oddness",
    "odorous", "odyssey", "oeuvres", "offbeat", "offends", "offered",
    "offhand", "officer", "offices", "offings", "offload", "offsets",
    "offside", "oftener", "oilcans", "oiliest", "oilskin", "oinking",
    "oldened", "oldster", "omelets", "ominous", "omitted", "omnibus",
    "oneness", "onerous", "oneself", "onetime", "ongoing", "onioned",
    "onliest", "onshore", "onstage", "onwards", "opacity", "opaqued",
    "opaquer", "opaques", "openers", "openest", "opening", "operand",
    "operate", "opiates", "opining", "opinion", "opossum", "opposed",
    "opposes", "oppress", "optical", "optimal", "optimum", "options",
    "opulent", "oracled", "oracles", "oranges", "orating", "oration",
    "orators", "oratory", "orbital", "orbited", "orchard", "orchids",
    "ordains", "ordeals", "ordered", "orderly", "ordinal", "oregano",
    "organdy", "organic", "orgasms", "orients", "orifice", "origami",
    "origins", "orioles", "orotund", "orphans", "osmosis", "osmotic",
    "ospreys", "ostlers", "ostrich", "ottered", "ottoman", "ousters",
    "ousting", "outages", "outback", "outbids", "outcast", "outcome",
    "outcrop", "outdoes", "outdone", "outdoor", "outface", "outfall",
    "outfits", "outflow", "outgoes", "outgrew", "outgrow", "outguns",
    "outings", "outlaid", "outlast", "outlaws", "outlays", "outlets",
    "outline", "outlive", "outlook", "outpace", "outplay", "outpost",
    "outputs", "outrage", "outrank", "outruns", "outsell", "outsets",
    "outside", "outsize", "outsold", "outstay", "outtake", "outvote",
    "outward", "outwear", "outwith", "outwits", "outwore", "outwork",
    "outworn", "ovarian", "ovaries", "ovation", "overact", "overage",
    "overall", "overarm", "overate", "overawe", "overbid", "overdid",
    "overdue", "overeat", "overfly", "overjoy", "overlap", "overlay",
    "overlie", "overpay", "overran", "overrun", "oversaw", "oversee",
    "overtax", "overtly", "overuse", "oviduct", "ovulate", "oxcarts",
    "oxfords", "oxtails", "oxymora", "oysters", "paciest", "pacific",
    "package", "packers", "packets", "packing", "paddies", "padding",
    "paddled", "paddles", "paddock", "padlock", "paellas", "pageant",
    "pageboy", "pagodas", "pailful", "painful", "paining", "painted",
    "painter", "pairing", "paisley", "palaces", "palatal", "palates",
    "palaver", "palette", "palings", "pallets", "palling", "palmier",
    "palming", "palmist", "palmtop", "palpate", "palsied", "palsies",
    "pampers", "panacea", "panache", "panamas", "pancake", "panders",
    "panging", "panicky", "pannier", "panning", "panoply", "pansies",
    "panther", "panties", "panting", "papayas", "papered", "papilla",
    "papists", "papoose", "papping", "paprika", "papyrus", "parable",
    "paraded", "parades", "paradox", "paragon", "parapet", "parasol",
    "parboil", "parcels", "parched", "parches", "pardner", "pardons",
    "parents", "parfait", "pariahs", "parings", "parking", "parkway",
    "parlays", "parleys", "parlous", "paroled", "parolee", "paroles",
    "parquet", "parried", "parries", "parring", "parrots", "parsecs",
    "parsing", "parsley", "parsnip", "parsons", "partake", "partial",
    "partied", "parties", "parting", "partner", "partook", "partway",
    "parvenu", "paschal", "passage", "passels", "passing", "passion",
    "passive", "passkey", "pastels", "pastern", "pastier", "pasties",
    "pastime", "pasting", "pastors", "pasture", "patched", "patches",
    "patella", "patents", "pathway", "patient", "patinas", "patriot",
    "patrols", "patrons", "patsies", "pattern", "patters", "patties",
    "patting", "paucity", "paunchy", "paupers", "pausing", "pavings",
    "pavlova", "pawning", "payable", "payback", "paydays", "payload",
    "payment", "payoffs", "payouts", "payroll", "payslip", "peaches",
    "peacock", "peafowl", "peahens", "peaking", "pealing", "peanuts",
    "pearled", "peasant", "pebbled", "pebbles", "peccary", "peckers",
    "pecking", "peckish", "pedalos", "pedants", "peddled", "peddler",
    "peddles", "peeking", "peelers", "peeling", "peepers", "peeping",
    "peerage", "peeress", "peering", "peeving", "peevish", "peewees",
    "peewits", "pegging", "pelagic", "pelican", "pellets", "pelmets",
    "pelting", "pelvics", "penalty", "penance", "pencils", "pendant",
    "pendent", "pending", "penguin", "penises", "pennant", "pennies",
    "penning", "pennons", "pension", "pensive", "peonage", "peonies",
    "peopled", "peoples", "peppers", "peppery", "peppier", "pepping",
    "peptics", "percale", "percent", "perched", "perches", "perfect",
    "perfidy", "perform", "perfume", "pergola", "perhaps", "perigee",
    "periods", "periwig", "perjure", "perjury", "perkier", "perkily",
    "perking", "perming", "permits", "permute", "perplex", "persist",
    "persona", "persons", "perspex", "pertain", "pertest", "perturb",
    "perusal", "perused", "peruses", "pervade", "pervert", "pesetas",
    "peskier", "pessary", "pesters", "pestled", "pestles", "petards",
    "petered", "petiole", "petites", "petrels", "petrify", "pettier",
    "petties", "pettily", "petting", "petunia", "pewters", "pfennig",
    "phalanx", "phallic", "phallus", "phantom", "pharaoh", "pharynx",
    "phasing", "phenoms", "philter", "philtre", "phobias", "phobics",
    "phoebes", "phoenix", "phoneme", "phonics", "phonied", "phonier",
    "phonies", "phoning", "phooeys", "photoed", "photons", "phrasal",
    "phrased", "phrases", "physics", "physios", "pianist", "pianola",
    "piazzas", "picador", "piccolo", "pickers", "pickets", "pickier",
    "picking", "pickled", "pickles", "pickups", "picnics", "picture",
    "piddled", "piddles", "pidgins", "piebald", "piecing", "pierced",
    "pierces", "pigeons", "piggery", "piggier", "piggies", "pigging",
    "piggish", "piglets", "pigment", "pigpens", "pigskin", "pigtail",
    "pileups", "pilfers", "pilgrim", "pilings", "pillage", "pillars",
    "pillbox", "pillion", "pillock", "pillory", "pillows", "piloted",
    "pimento", "pimping", "pimpled", "pimples", "pinball", "pincers",
    "pinched", "pinches", "pinging", "pinhead", "pinhole", "pinions",
    "pinkest", "pinkeye", "pinkies", "pinking", "pinkish", "pinnate",
    "pinnies", "pinning", "pioneer", "piously", "pipette", "pipping",
    "pippins", "piquant", "piquing", "piranha", "pirated", "pirates",
    "pissers", "pissing", "pissoir", "pistils", "pistols", "pistons",
    "pitched", "pitcher", "pitches", "piteous", "pitfall", "pithead",
    "pithier", "pithily", "pitiful", "pitting", "pitying", "pivotal",
    "pivoted", "placard", "placate", "placebo", "placers", "placing",
    "placket", "plagued", "plagues", "plaided", "plainer", "plainly",
    "plaints", "plaited", "planers", "planets", "planing", "planked",
    "planned", "planner", "planted", "planter", "plaques", "plaster",
    "plastic", "plateau", "platens", "plating", "platoon", "platter",
    "plaudit", "playact", "playboy", "players", "playful", "playing",
    "playoff", "playpen", "pleaded", "pleader", "pleased", "pleases",
    "pleated", "plectra", "pledged", "pledges", "plenary", "plenums",
    "pliable", "pliancy", "plights", "plinths", "plodded", "plodder",
    "plonked", "plonker", "plopped", "plosive", "plotted", "plotter",
    "plovers", "plucked", "plugged", "plumage", "plumbed", "plumber",
    "pluming", "plummet", "plumped", "plumper", "plunder", "plunged",
    "plunger", "plunges", "plunked", "plurals", "plusher", "plussed",
    "plywood", "poached", "poacher", "poaches", "pockets", "pocking",
    "podding", "podiums", "poesied", "poesies", "poetess", "pogroms",
    "pointed", "pointer", "poising", "poisons", "pokiest", "poleaxe",
    "polecat", "polemic", "policed", "polices", "politer", "politic",
    "polkaed", "pollard", "polling", "pollute", "polygon", "polymer",
    "pomaded", "pomades", "pommels", "pommies", "pompoms", "pompous",
    "ponchos", "poncing", "ponders", "ponging", "poniard", "pontiff",
    "pontoon", "ponying", "pooched", "pooches", "poodles", "poofter",
    "poohing", "pooling", "pooping", "poorest", "popcorn", "popguns",
    "poplars", "popover", "poppers", "poppets", "poppies", "popping",
    "popular", "porches", "porcine", "porkers", "porkies", "portage",
    "portals", "portend", "portent", "porters", "portico", "porting",
    "portion", "portray", "poseurs", "poshest", "poshing", "posited",
    "possess", "possums", "postage", "postbag", "postbox", "postdoc",
    "posters", "posties", "posting", "postman", "postmen", "posture",
    "postwar", "potable", "potency", "potfuls", "pothead", "pothole",
    "pothook", "potions", "potluck", "potpies", "potshot", "pottage",
    "potters", "pottery", "pottier", "potties", "potting", "pouched",
    "pouches", "pouffes", "poultry", "pounced", "pounces", "pounded",
    "pouring", "pouting", "poverty", "powders", "powdery", "powered",
    "powwows", "prairie", "praised", "praises", "praline", "pranced",
    "prancer", "prances", "pranged", "prating", "prattle", "prawned",
    "prayers", "praying", "preachy", "precast", "precede", "precept",
    "precise", "precook", "predate", "predict", "preemie", "preempt",
    "preened", "prefabs", "preface", "prefect", "prefers", "preheat",
    "prelate", "prelims", "prelude", "premier", "premise", "premium",
    "prepaid", "prepare", "prepays", "prepped", "prequel", "presage",
    "present", "presets", "preside", "pressed", "presses", "pressie",
    "prestos", "presume", "preteen", "pretend", "pretext", "pretzel",
    "prevail", "prevent", "preview", "preying", "prezzie", "pricier",
    "pricing", "pricked", "prickle", "prickly", "priding", "priests",
    "primacy", "primary", "primate", "primers", "priming", "primmer",
    "primped", "primula", "princes", "printed", "printer", "prisons",
    "prithee", "privacy", "private", "privets", "privier", "privies",
    "probate", "probing", "probity", "problem", "proceed", "process",
    "proctor", "procure", "prodded", "prodigy", "produce", "product",
    "profane", "profess", "proffer", "profile", "profits", "profuse",
    "progeny", "project", "prolong", "promise", "promote", "prompts",
    "pronged", "pronoun", "proofed", "propane", "propels", "prophet",
    "propose", "propped", "prorate", "prosaic", "prosier", "prosody",
    "prosper", "protean", "protect", "protein", "protest", "protons",
    "prouder", "proudly", "proverb", "provide", "proving", "proviso",
    "provoke", "provost", "prowess", "prowled", "prowler", "proxies",
    "prudent", "prudery", "prudish", "pruning", "psyched", "psyches",
    "psychic", "psychos", "pubbing", "puberty", "publish", "puckers",
    "pucking", "puckish", "pudding", "puddled", "puddles", "pudenda",
    "pudgier", "pueblos", "puerile", "puffers", "puffier", "puffing",
    "puffins", "pullers", "pullets", "pulleys", "pulling", "pullout",
    "pulpier", "pulping", "pulpits", "pulsars", "pulsate", "pulsing",
    "pumices", "pummels", "pumping", "pumpkin", "punched", "punches",
    "pundits", "pungent", "puniest", "punkest", "punnets", "punning",
    "punster", "punters", "punting", "pupated", "pupates", "puppets",
    "puppied", "puppies", "pupping", "purging", "purists", "puritan",
    "purling", "purloin", "purpler", "purples", "purport", "purpose",
    "purring", "pursers", "pursing", "pursued", "pursuer", "pursues",
    "pursuit", "purveys", "purview", "pushers", "pushier", "pushily",
    "pushing", "pushpin", "pussier", "pussies", "pustule", "putrefy",
    "putters", "puttied", "putties", "putting", "puzzled", "puzzler",
    "puzzles", "pygmies", "pyramid", "pyrites", "pythons", "quacked",
    "quaffed", "quahogs", "quailed", "quaking", "qualify", "quality",
    "quangos", "quantum", "quarrel", "quarter", "quartet", "quartos",
    "quasars", "quashed", "quashes", "quavers", "quavery", "queened",
    "queenly", "queered", "queerer", "queerly", "quelled", "queried",
    "queries", "quested", "quibble", "quiches", "quicken", "quicker",
    "quickie", "quickly", "quieted", "quieten", "quieter", "quietly",
    "quietus", "quilted", "quilter", "quinces", "quinine", "quintet",
    "quipped", "quirked", "quiting", "quitter", "quivers", "quizzed",
    "quizzes", "quoited", "quondam", "quorate", "quorums", "quoting",
    "rabbits", "rabbles", "rabidly", "raccoon", "racemes", "raceway",
    "raciest", "racists", "rackets", "racking", "raddled", "radials",
    "radiant", "radiate", "radical", "radioed", "raffish", "raffled",
    "raffles", "rafters", "rafting", "raggedy", "ragging", "raglans",
    "ragouts", "ragtags", "ragtime", "ragweed", "ragwort", "raiders",
    "raiding", "railing", "railway", "raiment", "rainbow", "rainier",
    "raining", "raising", "raisins", "rallied", "rallies", "rambled",
    "rambler", "rambles", "ramekin", "ramming", "rampage", "rampant",
    "rampart", "ramrods", "ranched", "rancher", "ranches", "randier",
    "rangers", "rangier", "ranging", "rankest", "ranking", "rankled",
    "rankles", "ransack", "ransoms", "ranting", "rapider", "rapidly",
    "rapiers", "rapists", "rappels", "rappers", "rapping", "rapport",
    "raptors", "rapture", "rascals", "rashers", "rashest", "raspier",
    "rasping", "ratbags", "ratchet", "ratings", "rations", "rattans",
    "rattier", "ratting", "rattled", "rattler", "rattles", "rattrap",
    "raucous", "raunchy", "ravaged", "ravages", "ravened", "ravined",
    "ravines", "ravings", "ravioli", "rawhide", "rawness", "razzing",
    "reached", "reaches", "reacted", "reactor", "readers", "readied",
    "readier", "readies", "readily", "reading", "readmit", "readout",
    "reagent", "realest", "realign", "realism", "realist", "reality",
    "reamers", "reaming", "reapers", "reaping", "reapply", "rearing",
    "rearmed", "reasons", "rebated", "rebates", "rebinds", "rebirth",
    "reboots", "rebound", "rebuffs", "rebuild", "rebuilt", "rebuked",
    "rebukes", "rebuses", "recalls", "recants", "recasts", "receded",
    "recedes", "receipt", "receive", "recheck", "recipes", "recital",
    "recited", "recites", "reckons", "reclaim", "recline", "recluse",
    "recoils", "records", "recount", "recoups", "recover", "recruit",
    "rectify", "rectors", "rectory", "rectums", "recycle", "redcaps",
    "redcoat", "reddens", "reddest", "reddish", "redeems", "redhead",
    "redneck", "redness", "redoing", "redoubt", "redound", "redraft",
    "redrawn", "redraws", "redress", "redskin", "reduced", "reduces",
    "redwood", "reedier", "reefers", "reefing", "reeking", "reelect",
    "reeling", "reenact", "reenter", "reentry", "reeving", "referee",
    "reffing", "refiled", "refiles", "refills", "refined", "refiner",
    "refines", "reflate", "reflect", "refocus", "reforms", "refract",
    "refrain", "refresh", "refuels", "refugee", "refuges", "refunds",
    "refusal", "refused", "refuses", "refuted", "refutes", "regains",
    "regaled", "regales", "regalia", "regally", "regards", "regatta",
    "regency", "regents", "regimen", "regimes", "regions", "regress",
    "regrets", "regroup", "regular", "reheats", "rehired", "rehires",
    "rehouse", "reigned", "reining", "reissue", "rejects", "rejoice",
    "rejoins", "relabel", "relapse", "related", "relates", "relaxed",
    "relaxes", "relayed", "relearn", "release", "relents", "reliant",
    "reliefs", "relieve", "relived", "relives", "reloads", "relying",
    "remades", "remains", "remakes", "remands", "remarks", "remarry",
    "rematch", "reminds", "remixed", "remixes", "remnant", "remodel",
    "remolds", "remorse", "remoter", "remotes", "remould", "remount",
    "removal", "removed", "remover", "removes", "renamed", "renames",
    "renders", "rending", "reneged", "reneges", "renewal", "renewed",
    "renowns", "rentals", "renters", "renting", "reoccur", "reopens",
    "reorder", "repaint", "repairs", "repasts", "repeals", "repeats",
    "repents", "replace", "replays", "replete", "replica", "replied",
    "replies", "reports", "reposed", "reposes", "repress", "reprint",
    "reprise", "reproof", "reprove", "reptile", "repulse", "reputed",
    "reputes", "request", "requiem", "require", "requite", "rereads",
    "reroute", "resales", "rescind", "rescued", "rescuer", "rescues",
    "resells", "resents", "reserve", "reshape", "resided", "resides",
    "residue", "resigns", "resists", "resolve", "resorts", "resound",
    "respect", "respell", "respire", "respite", "respond", "restart",
    "restate", "restful", "resting", "restive", "restock", "restore",
    "restudy", "results", "resumed", "resumes", "retails", "retains",
    "retaken", "retakes", "retards", "retched", "retches", "retells",
    "rethink", "retinal", "retinas", "retinue", "retired", "retiree",
    "retires", "retools", "retorts", "retouch", "retrace", "retract",
    "retrain", "retread", "retreat", "retrial", "retried", "retries",
    "retsina", "returns", "retyped", "retypes", "reunify", "reunion",
    "reunite", "reusing", "revalue", "revamps", "reveals", "revelry",
    "revenge", "revenue", "revered", "reveres", "reverie", "reverse",
    "reverts", "reviews", "reviled", "reviler", "reviles", "revised",
    "revises", "revisit", "revival", "revived", "revives", "revoked",
    "revokes", "revolts", "revolve", "revving", "rewards", "rewinds",
    "rewired", "rewires", "rewords", "reworks", "rewound", "rewrite",
    "rewrote", "rhizome", "rhodium", "rhombus", "rhubarb", "rhyming",
    "rhythms", "ribbing", "ribbons", "richest", "rickets", "rickety",
    "ricking", "ricotta", "ridding", "riddled", "riddles", "ridging",
    "riffing", "riffled", "riffles", "rifling", "rifting", "rigging",
    "righted", "righter", "rightly", "rigidly", "rilling", "rimless",
    "rimming", "rinding", "ringers", "ringing", "ringlet", "rinking",
    "rinsing", "rioters", "rioting", "riotous", "ripcord", "ripened",
    "riposte", "rippers", "ripping", "rippled", "ripples", "ripsaws",
    "risible", "risings", "riskier", "riskily", "risking", "risotto",
    "rissole", "rituals", "ritzier", "rivalry", "riveted", "riviera",
    "rivulet", "roaches", "roadbed", "roadies", "roadway", "roamers",
    "roaming", "roaring", "roasted", "roaster", "robbers", "robbery",
    "robbing", "robotic", "rockers", "rockery", "rockets", "rockier",
    "rocking", "rodents", "roebuck", "rogered", "roguery", "roguish",
    "roiling", "roister", "rollers", "rollick", "rolling", "rollmop",
    "romaine", "romance", "rompers", "romping", "roofers", "roofing",
    "rooftop", "rookery", "rookier", "rookies", "rooking", "roomers",
    "roomful", "roomier", "rooming", "roosted", "rooster", "rooting",
    "roseate", "rosebud", "rosette", "rosiest", "rosined", "rosters",
    "rostrum", "rotated", "rotates", "rottens", "rotters", "rotting",
    "rotunda", "rotunds", "roughed", "roughen", "rougher", "roughly",
    "rouging", "rounded", "roundel", "rounder", "roundly", "roundup",
    "rousing", "rousted", "routine", "routing", "rowboat", "rowdier",
    "rowdies", "rowdily", "rowlock", "royally", "royalty", "rubbers",
    "rubbery", "rubbing", "rubbish", "rubbled", "rubbles", "rubdown",
    "rubella", "rubiest", "rubrics", "rubying", "rucking", "rudders",
    "ruddied", "ruddier", "ruddies", "ruffian", "ruffing", "ruffled",
    "ruffles", "rugging", "ruining", "ruinous", "rulered", "rulings",
    "rumbaed", "rumbled", "rumbles", "rummage", "rummest", "rumping",
    "rumpled", "rumples", "runaway", "rundown", "runnels", "runners",
    "runnier", "running", "runoffs", "runways", "rupture", "rushing",
    "russets", "rustics", "rustier", "rusting", "rustled", "rustler",
    "rustles", "rutting", "sabling", "sachems", "sachets", "sackful",
    "sacking", "saddens", "saddest", "saddled", "saddler", "saddles",
    "sadists", "sadness", "safaris", "saffron", "sagging", "saguaro",
    "sailing", "sailors", "sainted", "saintly", "salaams", "salamis",
    "salient", "salines", "sallied", "sallies", "salmons", "saloons",
    "saltbox", "saltest", "saltier", "salties", "saltine", "salting",
    "saluted", "salutes", "salvage", "salvers", "salving", "sambaed",
    "samosas", "samovar", "sampans", "sampled", "sampler", "samples",
    "samurai", "sanctum", "sandals", "sandbag", "sandbar", "sandbox",
    "sanders", "sandhog", "sandier", "sanding", "sandlot", "sandman",
    "sandmen", "sandpit", "sangria", "sapient", "sapling", "sappers",
    "sappier", "sapping", "sarcasm", "sarcoma", "sardine", "sarnies",
    "sarongs", "sashays", "sassier", "sassing", "satanic", "satchel",
    "satiate", "satiety", "satined", "satires", "satiric", "satisfy",
    "satraps", "satsuma", "saucers", "saucier", "saucily", "saucing",
    "saunaed", "saunter", "sausage", "savaged", "savager", "savages",
    "savanna", "savants", "savings", "savvied", "savvier", "savvies",
    "sawdust", "sawmill", "sawyers", "sayings", "scabbed", "scabies",
    "scalars", "scalded", "scalene", "scalier", "scaling", "scallop",
    "scalped", "scalpel", "scalper", "scammed", "scamper", "scandal",
    "scanned", "scanner", "scanted", "scanter", "scapula", "scarabs",
    "scarcer", "scarfed", "scarier", "scarify", "scaring", "scarlet",
    "scarper", "scarred", "scarves", "scatted", "scatter", "scenery",
    "scening", "scented", "schemed", "schemer", "schemes", "scherzo",
    "schisms", "schizos", "schleps", "schlock", "schmuck", "schnook",
    "scholar", "schools", "sciatic", "science", "scissor", "scoffed",
    "scolded", "sconces", "scooped", "scooted", "scooter", "scoping",
    "scorers", "scoring", "scorned", "scotchs", "scoured", "scourer",
    "scourge", "scouted", "scouter", "scowled", "scraggy", "scraped",
    "scraper", "scrapes", "scrapie", "scrappy", "scratch", "scrawls",
    "scrawny", "screams", "screech", "screeds", "screens", "screwed",
    "scribes", "scrimps", "scripts", "scrolls", "scrooge", "scrotum",
    "scrubby", "scruffs", "scruffy", "scrumps", "scrumpy", "scrunch",
    "scruple", "scubaed", "scudded", "scuffed", "scuffle", "sculled",
    "sculpts", "scumbag", "scummed", "scupper", "scuttle", "scythed",
    "scythes", "seabeds", "seabird", "seafood", "seagull", "sealant",
    "sealers", "sealing", "seamier", "seaming", "seaport", "searing",
    "seasick", "seaside", "seasons", "seating", "seaward", "seaways",
    "seaweed", "seceded", "secedes", "seclude", "seconds", "secrecy",
    "secrete", "secrets", "section", "sectors", "secular", "secured",
    "securer", "secures", "sedated", "sedater", "sedates", "seduced",
    "seducer", "seduces", "seedbed", "seedier", "seeding", "seeings",
    "seekers", "seeking", "seeming", "seepage", "seeping", "seesaws",
    "seethed", "seethes", "segment", "seismic", "seizing", "seizure",
    "selects", "selfish", "sellers", "selling", "sellout", "seltzer",
    "selvage", "seminal", "seminar", "senates", "senator", "senders",
    "sending", "seniors", "sensing", "sensors", "sensory", "sensual",
    "septets", "septics", "sequels", "sequins", "sequoia", "serapes",
    "seraphs", "serened", "serener", "serenes", "serfdom", "serials",
    "serious", "sermons", "serpent", "serried", "servant", "servers",
    "servery", "service", "servile", "serving", "sesames", "session",
    "setback", "settees", "setters", "setting", "settled", "settler",
    "settles", "seventh", "seventy", "several", "severed", "severer",
    "sexiest", "sexists", "sexless", "sexpots", "sextant", "sextets",
    "sextons", "shacked", "shackle", "shadier", "shading", "shadows",
    "shadowy", "shafted", "shagged", "shaikhs", "shakers", "shakeup",
    "shakier", "shakily", "shaking", "shallot", "shallow", "shamans",
    "shamble", "shaming", "shammed", "shampoo", "shapely", "shaping",
    "shariah", "sharing", "sharked", "sharped", "sharpen", "sharper",
    "sharply", "shatter", "shavers", "shaving", "shawled", "sheared",
    "shearer", "sheathe", "sheaths", "sheaves", "shebang", "shebeen",
    "sheered", "sheerer", "sheilas", "shekels", "shellac", "shelled",
    "sheller", "shelter", "shelved", "shelves", "sherbet", "sheriff",
    "shiatsu", "shields", "shifted", "shilled", "shimmed", "shimmer",
    "shindig", "shiners", "shingle", "shinier", "shining", "shinned",
    "shipped", "shipper", "shirked", "shirker", "shirred", "shirted",
    "shitted", "shivers", "shivery", "shoaled", "shocked", "shocker",
    "shoeing", "shoguns", "shooing", "shooter", "shopped", "shopper",
    "shoring", "shorted", "shorten", "shorter", "shortly", "shotgun",
    "shouted", "shovels", "shoving", "showbiz", "showers", "showery",
    "showier", "showily", "showing", "showman", "showmen", "showoff",
    "shrewed", "shrieks", "shrikes", "shrills", "shrilly", "shrimps",
    "shrines", "shrinks", "shrived", "shrivel", "shriven", "shrives",
    "shrouds", "shrubby", "shticks", "shucked", "shudder", "shuffle",
    "shunned", "shunted", "shushed", "shushes", "shuteye", "shutout",
    "shutter", "shuttle", "shyness", "shyster", "sibling", "sickbay",
    "sickbed", "sickens", "sickest", "sickies", "sicking", "sickled",
    "sickles", "sickout", "sidearm", "sidebar", "sidecar", "sidings",
    "sidling", "sierras", "siestas", "sieving", "sifters", "sifting",
    "sighing", "sighted", "signals", "signers", "signets", "signify",
    "signing", "silaged", "silages", "silence", "silents", "silicon",
    "silkens", "silkier", "silkies", "sillier", "sillies", "silting",
    "silvers", "silvery", "simians", "similar", "similes", "simmers",
    "simpers", "simpled", "simpler", "simples", "simplex", "sincere",
    "singers", "singing", "singled", "singles", "singlet", "sinkers",
    "sinking", "sinners", "sinning", "sinuous", "sinuses", "sipping",
    "sirloin", "sirocco", "sirring", "sissier", "sissies", "sisters",
    "sitcoms", "sitters", "sitting", "situate", "sixfold", "sixteen",
    "sixties", "sizable", "sizzled", "sizzler", "sizzles", "skaters",
    "skating", "skeeter", "skeined", "sketchy", "skewers", "skewing",
    "skibobs", "skidded", "skidpan", "skiffed", "skiffle", "skilled",
    "skillet", "skimmed", "skimped", "skinful", "skinned", "skipped",
    "skipper", "skirted", "skiting", "skitter", "skittle", "skivers",
    "skiving", "skulked", "skunked", "skycaps", "skydive", "skyjack",
    "skylark", "skyline", "skyward", "slabbed", "slacked", "slacken",
    "slacker", "slackly", "slagged", "slaking", "slaloms", "slammed",
    "slammer", "slander", "slanted", "slapped", "slapper", "slashed",
    "slashes", "slather", "slating", "slatted", "slavers", "slavery",
    "slaving", "slavish", "slayers", "slaying", "sleazes", "sledded",
    "sledged", "sledges", "sleeked", "sleeker", "sleekly", "sleeper",
    "sleeted", "sleeves", "sleighs", "slender", "sleuths", "slewing",
    "slicers", "slicing", "slicked", "slicker", "slickly", "sliders",
    "sliding", "slights", "slimier", "slimmed", "slimmer", "slipped",
    "slipper", "slipway", "slither", "slitted", "slitter", "slivers",
    "slobbed", "slobber", "slogans", "slogged", "sloping", "slopped",
    "sloshed", "sloshes", "slothed", "slotted", "slouchy", "sloughs",
    "slovens", "slowest", "slowing", "sludged", "sludges", "slugged",
    "slugger", "sluiced", "sluices", "slumber", "slummed", "slummer",
    "slumped", "slurped", "slurred", "slyness", "smacked", "smacker",
    "smalled", "smaller", "smarted", "smarten", "smarter", "smartly",
    "smashed", "smasher", "smashes", "smeared", "smelled", "smelted",
    "smelter", "smidgen", "smiling", "smirked", "smiting", "smitten",
    "smocked", "smokers", "smokier", "smokies", "smoking", "smoochy",
    "smooths", "smother", "smudged", "smudges", "smugged", "smugger",
    "smuggle", "snacked", "snaffle", "snagged", "snailed", "snakier",
    "snaking", "snapped", "snapper", "snaring", "snarled", "sneaked",
    "sneaker", "sneered", "sneezed", "sneezes", "snicked", "snicker",
    "snidely", "snidest", "sniffed", "sniffer", "sniffle", "snifter",
    "snipers", "sniping", "snipped", "snippet", "snivels", "snogged",
    "snooker", "snooped", "snooper", "snoozed", "snoozes", "snorers",
    "snoring", "snorkel", "snorted", "snotted", "snouted", "snowier",
    "snowing", "snowman", "snowmen", "snubbed", "snuffed", "snuffer",
    "snuffle", "snugged", "snugger", "snuggle", "soaking", "soapbox",
    "soapier", "soaping", "soaring", "sobbing", "sobered", "soberer",
    "soberly", "socials", "society", "sockets", "socking", "sodding",
    "softens", "softest", "softies", "soggier", "soggily", "soiling",
    "sojourn", "solaced", "solaces", "solaria", "solders", "soldier",
    "solicit", "solider", "solidly", "soloing", "soloist", "soluble",
    "solvent", "solvers", "solving", "someday", "somehow", "someone",
    "someway", "sonatas", "sonnets", "sonnies", "soonest", "soothed",
    "soother", "soothes", "sootier", "sophism", "sophist", "soppier",
    "sopping", "soprano", "sorbets", "sorcery", "sorghum", "sorrels",
    "sorrier", "sorrows", "sorters", "sortied", "sorties", "sorting",
    "sottish", "soughed", "soulful", "sounded", "sounder", "soundly",
    "soupier", "souping", "sourced", "sources", "sourest", "souring",
    "sousing", "soviets", "soybean", "sozzled", "spacial", "spacier",
    "spacing", "spading", "spammed", "spandex", "spangle", "spangly",
    "spaniel", "spanked", "spanned", "spanner", "sparely", "sparest",
    "sparing", "sparked", "sparkle", "sparkly", "sparred", "sparrer",
    "sparrow", "sparser", "spartan", "spasmed", "spastic", "spatial",
    "spatted", "spatter", "spatula", "spawned", "spaying", "speaker",
    "speared", "special", "species", "specify", "specked", "speckle",
    "spectra", "speeder", "speedup", "speller", "spender", "spewing",
    "spheres", "spicier", "spicing", "spiders", "spidery", "spieled",
    "spiffed", "spigots", "spikier", "spiking", "spinach", "spinals",
    "spindle", "spindly", "spinets", "spinier", "spinner", "spinney",
    "spirals", "spireas", "spirits", "spiting", "spitted", "spittle",
    "splashy", "splayed", "spleens", "spliced", "splicer", "splices",
    "spliffs", "splines", "splints", "splodge", "splotch", "splurge",
    "spoiler", "sponged", "sponger", "sponges", "sponsor", "spoofed",
    "spooked", "spooled", "spooned", "spoored", "sporing", "sporran",
    "sported", "spotlit", "spotted", "spotter", "spousal", "spouses",
    "spouted", "sprains", "sprangs", "sprawls", "sprayed", "sprayer",
    "spreads", "spriest", "springs", "springy", "sprints", "sprites",
    "sprouts", "spruced", "sprucer", "spruces", "spuming", "spumoni",
    "spunked", "spurned", "spurred", "spurted", "sputter", "squalid",
    "squalls", "squally", "squalor", "squared", "squarer", "squares",
    "squashy", "squawks", "squeaks", "squeaky", "squeals", "squeeze",
    "squelch", "squidgy", "squiffy", "squints", "squired", "squires",
    "squirms", "squirmy", "squirts", "squishy", "stabbed", "stabled",
    "stabler", "stables", "stacked", "stadium", "staffed", "staffer",
    "stagger", "staging", "staider", "staidly", "stained", "staking",
    "stalest", "staling", "stalked", "stalker", "stalled", "stamens",
    "stamina", "stammer", "stamped", "stances", "standby", "stanzas",
    "stapled", "stapler", "staples", "starchy", "stardom", "staring",
    "starked", "starker", "starkly", "starlet", "starlit", "starred",
    "started", "starter", "startle", "starved", "starves", "stashed",
    "stashes", "stately", "statics", "stating", "station", "statues",
    "stature", "statute", "staunch", "staving", "staying", "stealth",
    "steamed", "steamer", "steeled", "steeped", "steepen", "steeper",
    "steeple", "steeply", "steered", "steined", "stellar", "stemmed",
    "stencil", "stepped", "steppes", "stepson", "stereos", "sterile",
    "sterned", "sterner", "sternly", "sternum", "steroid", "stetson",
    "steward", "stewing", "sticker", "stickup", "stiffed", "stiffen",
    "stiffer", "stiffly", "stifled", "stifles", "stigmas", "stiling",
    "stilled", "stiller", "stilted", "stimuli", "stinger", "stinker",
    "stinted", "stipend", "stipple", "stirred", "stirrer", "stirrup",
    "stocked", "stogies", "stoical", "stokers", "stoking", "stomach",
    "stomped", "stonier", "stonily", "stoning", "stooges", "stooped",
    "stopgap", "stopped", "stopper", "storage", "storied", "storing",
    "stormed", "stouter", "stoutly", "stowage", "stowing", "strafed",
    "strafes", "strains", "straits", "strands", "strange", "stratum",
    "strawed", "strayed", "streaks", "streaky", "streams", "streets",
    "stretch", "strewed", "strewth", "strides", "striker", "strikes",
    "strings", "stringy", "striped", "stripes", "stripey", "striven",
    "strives", "strobes", "stroked", "strokes", "strolls", "strophe",
    "stroppy", "strudel", "stubbed", "stubble", "stubbly", "studded",
    "student", "studied", "studies", "studios", "stuffed", "stumble",
    "stumped", "stunned", "stunner", "stunted", "stupefy", "stupids",
    "stupors", "stutter", "styling", "stylish", "stylist", "stymied",
    "stymies", "styptic", "suavely", "suavest", "suavity", "subaqua",
    "subbing", "subdued", "subdues", "subhead", "subject", "subjoin",
    "sublets", "sublime", "submits", "suborns", "subplot", "subsets",
    "subside", "subsidy", "subsist", "subsoil", "subsume", "subteen",
    "subtend", "subtext", "subtler", "suburbs", "subvert", "subways",
    "subzero", "succeed", "success", "succubi", "succumb", "suckers",
    "sucking", "suckled", "suckles", "sucrose", "suction", "sudsier",
    "suffers", "suffice", "suffuse", "sugared", "suggest", "suicide",
    "suiting", "suitors", "sulfate", "sulfide", "sulkier", "sulkies",
    "sulkily", "sulking", "sullied", "sullies", "sultana", "sultans",
    "summary", "summers", "summery", "summing", "summits", "summons",
    "sunbeam", "sunbeds", "sunbelt", "sunburn", "sundaes", "sundeck",
    "sunders", "sundial", "sundown", "sunfish", "sunhats", "sunlamp",
    "sunless", "sunnier", "sunnies", "sunning", "sunrise", "sunroof",
    "sunsets", "sunspot", "suntans", "suntrap", "supered", "suppers",
    "supping", "suppler", "support", "suppose", "supreme", "supremo",
    "surface", "surfeit", "surfers", "surfing", "surgeon", "surgery",
    "surging", "surlier", "surmise", "surname", "surpass", "surplus",
    "surreal", "surreys", "surveys", "survive", "suspect", "suspend",
    "sussing", "sustain", "sutured", "sutures", "svelter", "swabbed",
    "swaddle", "swagged", "swagger", "swallow", "swamped", "swanked",
    "swanker", "swanned", "swapped", "swarmed", "swarthy", "swashed",
    "swashes", "swathed", "swathes", "swatted", "swatter", "swaying",
    "swearer", "sweater", "sweeper", "sweeten", "sweeter", "sweetie",
    "sweetly", "swelled", "sweller", "swelter", "swerved", "swerves",
    "swifted", "swifter", "swiftly", "swigged", "swilled", "swimmer",
    "swindle", "swinger", "swinish", "swiping", "swirled", "swished",
    "swisher", "swishes", "swivels", "swollen", "swooned", "swooped",
    "sworded", "swotted", "symbols", "symptom", "synapse", "syncing",
    "synergy", "synonym", "syringe", "systems", "tabbies", "tabbing",
    "tableau", "tablets", "tabling", "tabloid", "tabooed", "tabular",
    "tacitly", "tackier", "tackies", "tacking", "tackled", "tackler",
    "tackles", "tactful", "tactics", "tactile", "tadpole", "taffeta",
    "taffies", "tagging", "tailing", "tailors", "tainted", "takeoff",
    "takeout", "takings", "talents", "talkers", "talkies", "talking",
    "tallboy", "tallest", "tallied", "tallies", "tallyho", "tamable",
    "tamales", "tampers", "tamping", "tampons", "tanager", "tandems",
    "tangelo", "tangent", "tangier", "tangies", "tangled", "tangles",
    "tangoed", "tankard", "tankers", "tankful", "tanking", "tanners",
    "tannery", "tannest", "tanning", "tantrum", "tapered", "tapioca",
    "tappets", "tapping", "taproom", "taproot", "tardier", "tardies",
    "tardily", "targets", "tariffs", "tarmacs", "tarnish", "tarpons",
    "tarried", "tarrier", "tarries", "tarring", "tartans", "tartars",
    "tartest", "tarting", "tasking", "tasters", "tastier", "tasting",
    "tatters", "tattier", "tatties", "tatting", "tattled", "tattler",
    "tattles", "tattoos", "taunted", "tautens", "tautest", "tauting",
    "taverns", "tawnier", "taxable", "taxicab", "taxiing", "taxings",
    "taxiway", "teabags", "teacake", "teacher", "teaches", "teacups",
    "teaming", "teapots", "tearful", "teargas", "tearier", "tearing",
    "tearoom", "teasels", "teasers", "teasing", "teatime", "techies",
    "teddies", "tedious", "teeming", "teenage", "teenier", "teeters",
    "teethed", "teethes", "telexed", "telexes", "tellers", "tellies",
    "telling", "temblor", "tempera", "tempers", "tempest", "temping",
    "temples", "tempted", "tempter", "tempura", "tenable", "tenancy",
    "tenants", "tenders", "tending", "tendons", "tendril", "tenfold",
    "tenners", "tenpins", "tensely", "tensest", "tensile", "tensing",
    "tension", "tensors", "tenting", "tenuous", "tenured", "tenures",
    "tequila", "terming", "termini", "termite", "terning", "terrace",
    "terrain", "terrier", "terrify", "terrine", "terrors", "tersely",
    "tersest", "testate", "testers", "testier", "testify", "testily",
    "testing", "tetanus", "tethers", "textile", "textual", "texture",
    "thalami", "thanked", "thawing", "theeing", "theists", "theorem",
    "therapy", "thereby", "therein", "thereof", "thereon", "thereto",
    "thermal", "thermos", "thicken", "thicker", "thicket", "thickly",
    "thickos", "thieved", "thieves", "thimble", "thinker", "thinned",
    "thinner", "thirded", "thirdly", "thirsts", "thirsty", "thistle",
    "thither", "thorium", "thought", "thralls", "threads", "threats",
    "thrifts", "thrifty", "thrills", "thrived", "thrives", "throats",
    "throaty", "thrones", "throngs", "through", "thrower", "thrusts",
    "thruway", "thudded", "thumbed", "thumped", "thunder", "thwacks",
    "thwarts", "thyroid", "thyself", "tickers", "tickets", "ticking",
    "tickled", "tickles", "tidbits", "tiddler", "tidiest", "tidings",
    "tidying", "tiepins", "tiffing", "tighten", "tighter", "tightly",
    "tigress", "tillage", "tillers", "tilling", "tilting", "timbers",
    "timbres", "timider", "timidly", "timings", "timpani", "tinfoil",
    "tinging", "tingled", "tingles", "tiniest", "tinkers", "tinkled",
    "tinkles", "tinnier", "tinnies", "tinning", "tinsels", "tinting",
    "tippers", "tipping", "tippled", "tippler", "tipples", "tipsier",
    "tipsily", "tipster", "tiptoed", "tiptoes", "tiptops", "tirades",
    "tireder", "tiredly", "tirings", "tissues", "titanic", "titches",
    "tithing", "titling", "titmice", "titters", "titties", "titting",
    "tittled", "tittles", "titular", "tizzies", "toadied", "toadies",
    "toasted", "toaster", "tobacco", "toccata", "tocsins", "toddies",
    "toddled", "toddler", "toddles", "toecaps", "toehold", "toenail",
    "toerags", "toffees", "togging", "toggled", "toggles", "toilers",
    "toilets", "toiling", "tolling", "tombing", "tombola", "tomboys",
    "tomcats", "tongued", "tongues", "toniest", "tonight", "tonnage",
    "tonsils", "tonsure", "toolbar", "toolbox", "tooling", "toolkit",
    "toothed", "tooting", "tootled", "tootles", "tootsie", "topazes",
    "topcoat", "topiary", "topical", "topknot", "topless", "topmast",
    "topmost", "toppers", "topping", "toppled", "topples", "topsail",
    "topside", "topsoil", "topspin", "torched", "torches", "torment",
    "tornado", "torpedo", "torqued", "torques", "torrent", "torsion",
    "torture", "tossers", "tossing", "tossups", "totally", "totemic",
    "totters", "totting", "toucans", "touched", "touches", "toughed",
    "toughen", "tougher", "toughie", "toughly", "toupees", "touring",
    "tourism", "tourist", "tourney", "tousled", "tousles", "touting",
    "towards", "towered", "towhead", "townees", "townies", "towpath",
    "towrope", "toyboys", "tracers", "tracery", "trachea", "tracing",
    "tracked", "tracker", "tractor", "traders", "trading", "traduce",
    "traffic", "tragedy", "tragics", "trailed", "trailer", "trained",
    "trainee", "trainer", "traipse", "traitor", "tramcar", "trammed",
    "trammel", "tramped", "trample", "tramway", "trances", "tranche",
    "transit", "transom", "trapeze", "trapped", "trapper", "trashed",
    "trashes", "traumas", "travail", "travels", "trawled", "trawler",
    "treacle", "treacly", "treadle", "treason", "treated", "trebled",
    "trebles", "treeing", "treetop", "trefoil", "trekked", "trellis",
    "tremble", "tremolo", "tremors", "trended", "tresses", "trestle",
    "trialed", "tribune", "tribute", "triceps", "tricked", "trickle",
    "trident", "trifled", "trifler", "trifles", "trigger", "triking",
    "trilled", "trilogy", "trimmed", "trimmer", "trinity", "trinket",
    "tripled", "triples", "triplet", "tripods", "tripped", "tripper",
    "trisect", "tritely", "tritest", "triumph", "trivets", "trivial",
    "trochee", "trodden", "troikas", "trolled", "trolley", "trollop",
    "tromped", "trooped", "trooper", "tropics", "tropism", "trothed",
    "trotted", "trotter", "trouble", "troughs", "trounce", "trouped",
    "trouper", "troupes", "trouser", "trowels", "truancy", "truants",
    "trucked", "trucker", "truckle", "trudged", "trudges", "truffle",
    "truisms", "trumped", "trumpet", "trundle", "trunked", "trussed",
    "trusses", "trusted", "trustee", "tryings", "tryouts", "trysted",
    "tsarism", "tsarist", "tsunami", "tubbier", "tubular", "tuckers",
    "tucking", "tufting", "tugboat", "tugging", "tuition", "tumbled",
    "tumbler", "tumbles", "tumbrel", "tummies", "tumults", "tundras",
    "tuneful", "tunnels", "tunnies", "turbans", "turbine", "turbots",
    "tureens", "turfing", "turkeys", "turmoil", "turners", "turning",
    "turnips", "turnkey", "turnoff", "turnout", "turrets", "turtles",
    "tushing", "tussled", "tussles", "tussock", "tutored", "tutting",
    "tuxedos", "twaddle", "twanged", "tweaked", "tweeted", "tweeter",
    "twelfth", "twelves", "twiddle", "twiddly", "twigged", "twilled",
    "twinged", "twinges", "twining", "twinkle", "twinned", "twinset",
    "twirled", "twirler", "twisted", "twister", "twitchy", "twitted",
    "twitter", "twofers", "twofold", "twosome", "tycoons", "typeset",
    "typhoid", "typhoon", "typical", "typists", "tyranny", "tyrants",
    "ugliest", "uglying", "ukulele", "ulcered", "ululate", "umbrage",
    "umlauts", "umpired", "umpires", "umpteen", "unaided", "unarmed",
    "unasked", "unaware", "unbends", "unbinds", "unblock", "unbolts",
    "unbosom", "unbound", "unbowed", "uncanny", "uncased", "uncivil",
    "unclasp", "unclean", "unclear", "uncling", "uncoils", "uncorks",
    "uncouth", "uncover", "unction", "uncurls", "undated", "undergo",
    "undoing", "undress", "undying", "unearth", "uneaten", "unequal",
    "unfazed", "unfolds", "unfrock", "unfunny", "unfurls", "ungodly",
    "unguent", "unhands", "unhappy", "unheard", "unhinge", "unhitch",
    "unhooks", "unhorse", "unicorn", "unified", "unifies", "uniform",
    "uniquer", "unitary", "unities", "uniting", "unkempt", "unknown",
    "unlaced", "unlaces", "unlatch", "unlearn", "unleash", "unlikes",
    "unloads", "unlocks", "unloose", "unloved", "unlucky", "unmakes",
    "unmanly", "unmasks", "unmoral", "unmoved", "unnamed", "unnerve",
    "unpacks", "unpaved", "unpicks", "unplugs", "unquiet", "unquote",
    "unravel", "unready", "unrests", "unriper", "unrolls", "unsafer",
    "unscrew", "unseals", "unseats", "unseens", "unsnaps", "unsnarl",
    "unsound", "unstops", "unstuck", "untamed", "untiled", "untiles",
    "untried", "untruer", "untruth", "untwist", "untying", "unusual",
    "unveils", "unwaged", "unwinds", "unwiser", "unwound", "unwraps",
    "upbeats", "upbraid", "upchuck", "updated", "updater", "updates",
    "upended", "upfront", "upgrade", "uphills", "upholds", "uplands",
    "uplifts", "uploads", "upraise", "upright", "upriver", "uproars",
    "uproots", "upscale", "upshots", "upsides", "upstage", "upstart",
    "upstate", "upsurge", "upswing", "uptakes", "uptempo", "uptight",
    "uptrend", "upturns", "upwards", "uranium", "urbaner", "urchins",
    "urethra", "urgency", "urinals", "urinary", "urinate", "urology",
    "useless", "ushered", "usually", "usurers", "usurped", "usurper",
    "utensil", "uterine", "utility", "utopias", "uttered", "utterer",
    "utterly", "uvulars", "vacancy", "vacated", "vacates", "vaccine",
    "vacuity", "vacuous", "vacuums", "vaginae", "vaginal", "vagrant",
    "vaguely", "vaguest", "vainest", "valance", "valence", "valency",
    "valeted", "valiant", "validly", "valises", "valleys", "valuers",
    "valuing", "valving", "vamoose", "vamping", "vampire", "vandals",
    "vanilla", "vanning", "vantage", "variant", "variate", "variety",
    "various", "varlets", "varmint", "varnish", "varsity", "varying",
    "vassals", "vastest", "vatting", "vaulted", "vaulter", "vaunted",
    "vealing", "vectors", "veering", "veggies", "vegging", "vehicle",
    "veiling", "veining", "velvets", "velvety", "venally", "vending",
    "vendors", "veneers", "venison", "venting", "ventral", "venture",
    "veranda", "verbals", "verbena", "verbose", "verdant", "verdict",
    "verdure", "vergers", "verging", "veriest", "verruca", "versify",
    "versing", "version", "vertigo", "vesicle", "vespers", "vessels",
    "vestige", "vesting", "vetches", "veteran", "vetoing", "vetting",
    "viaduct", "vibrant", "vibrate", "vibrato", "viceroy", "vicious",
    "victims", "victors", "victory", "victual", "videoed", "viewers",
    "viewing", "village", "villain", "villein", "vinegar", "vintage",
    "vintner", "violate", "violent", "violets", "violins", "violist",
    "virgins", "virgule", "virtual", "virtues", "viruses", "visages",
    "visaing", "viscera", "viscose", "viscous", "visible", "visibly",
    "visions", "visited", "visitor", "vistaed", "visuals", "vitally",
    "vitamin", "vitiate", "vitriol", "vivaces", "vivaing", "vivider",
    "vividly", "viziers", "vocalic", "vocally", "voguing", "voguish",
    "voicing", "voiding", "volcano", "volleys", "voltage", "voltaic",
    "voluble", "volubly", "volumed", "volumes", "vomited", "voodoos",
    "vouched", "voucher", "vouches", "voyaged", "voyager", "voyages",
    "voyeurs", "vulture", "wackier", "wadding", "waddled", "waddles",
    "waffled", "waffles", "wafting", "wagered", "wagging", "waggish",
    "waggled", "waggles", "wagtail", "waifing", "wailing", "waisted",
    "waiters", "waiting", "waivers", "waiving", "wakeful", "wakened",
    "walkers", "walkies", "walking", "walkout", "walkway", "wallaby",
    "wallahs", "wallets", "walleye", "wallies", "walling", "wallops",
    "wallows", "walnuts", "waltzed", "waltzes", "wanders", "wangled",
    "wangles", "wankers", "wanking", "wannabe", "wannest", "wanting",
    "wantons", "wapitis", "warbled", "warbler", "warbles", "wardens",
    "warders", "warding", "warfare", "warhead", "wariest", "warlike",
    "warlock", "warlord", "warmers", "warmest", "warming", "warning",
    "warpath", "warping", "warrant", "warrens", "warring", "warrior",
    "warship", "warthog", "wartier", "wartime", "washers", "washing",
    "washout", "washtub", "waspish", "wassail", "wastage", "wasters",
    "wasting", "wastrel", "watched", "watcher", "watches", "watered",
    "wattage", "wattest", "wattled", "wattles", "wavelet", "wavered",
    "waviest", "waxiest", "waxwing", "waxwork", "waylaid", "waylays",
    "wayside", "wayward", "weakens", "weakest", "wealthy", "weaning",
    "weapons", "wearers", "wearied", "wearier", "wearies", "wearily",
    "wearing", "weasels", "weather", "weavers", "weaving", "webbing",
    "website", "wedding", "wedging", "wedlock", "weeders", "weedier",
    "weeding", "weekday", "weekend", "weenies", "weepers", "weepier",
    "weepies", "weeping", "weevils", "wefting", "weighed", "weights",
    "weighty", "weirded", "weirder", "weirdly", "weirdos", "weiring",
    "welcome", "welders", "welding", "welfare", "wellies", "welling",
    "welshed", "welshes", "welters", "welting", "wenches", "wending",
    "western", "westing", "wetback", "wetland", "wetness", "wettest",
    "wetting", "whacked", "whalers", "whaling", "whammed", "wharves",
    "whatnot", "whatsit", "wheaten", "wheedle", "wheeled", "wheeler",
    "wheelie", "wheezed", "wheezes", "whelked", "whelped", "whences",
    "whereas", "whereat", "whereby", "wherein", "whereof", "whereon",
    "whether", "whetted", "whewing", "whiffed", "whiling", "whimmed",
    "whimper", "whiners", "whinged", "whinger", "whinges", "whinier",
    "whining", "whipped", "whippet", "whirled", "whirred", "whisked",
    "whisker", "whisper", "whistle", "whitens", "whitest", "whiteys",
    "whither", "whiting", "whitish", "whitter", "whittle", "whizzed",
    "whizzes", "whoever", "whooped", "whoopee", "whopped", "whopper",
    "whoring", "whorled", "whupped", "wickers", "wickets", "widened",
    "widgets", "widowed", "widower", "wielded", "wieners", "wienies",
    "wigeons", "wigging", "wiggled", "wiggler", "wiggles", "wighted",
    "wigwags", "wigwams", "wildcat", "wildest", "wilding", "wiliest",
    "willies", "willing", "willows", "willowy", "wilting", "wimpier",
    "wimping", "wimpish", "wimpled", "wimples", "winched", "winches",
    "wincing", "windbag", "windier", "winding", "windows", "windups",
    "wingers", "winging", "wingtip", "winking", "winkled", "winkles",
    "winners", "winning", "winnows", "winsome", "winters", "wiretap",
    "wiriest", "wiseguy", "wishers", "wishful", "wishing", "wispier",
    "wistful", "witched", "witches", "withers", "withing", "without",
    "witless", "witness", "witters", "wittier", "wittily", "witting",
    "wizards", "wizened", "wobbled", "wobbles", "wolfing", "wolfish",
    "wolfram", "womanly", "wombats", "wonders", "woodcut", "woodier",
    "woodies", "wooding", "woodman", "woodmen", "woofers", "woofing",
    "woozier", "wordier", "wording", "workday", "workers", "working",
    "workman", "workmen", "workout", "workshy", "worktop", "worldly",
    "wormier", "worming", "worried", "worrier", "worries", "worsens",
    "worship", "worsted", "wounded", "wounder", "wracked", "wraiths",
    "wrangle", "wrapped", "wrapper", "wrathed", "wreaked", "wreathe",
    "wreaths", "wrecked", "wrecker", "wrested", "wrestle", "wriggle",
    "wriggly", "wringer", "wrinkle", "wrinkly", "writers", "writhed",
    "writhes", "writing", "written", "wronged", "wronger", "wrongly",
    "wrought", "wryness", "xeroxed", "xeroxes", "yachted", "yakking",
    "yammers", "yanking", "yapping", "yardage", "yardarm", "yashmak",
    "yawning", "yearned", "yelling", "yellows", "yellowy", "yelping",
    "yeshiva", "yessing", "yielded", "yippees", "yipping", "yogurts",
    "younger", "yowling", "yttrium", "yuckier", "yucking", "yukking",
    "yummier", "yuppies", "yuppify", "zaniest", "zanying", "zappers",
    "zapping", "zealots", "zealous", "zeniths", "zephyrs", "zeroing",
    "zestful", "zigzags", "zillion", "zincked", "zingers", "zinging",
    "zinnias", "zippers", "zippier", "zipping", "zircons", "zithers",
    "zodiacs", "zombies", "zonally", "zoology", "zooming", "zygotes"
  };

  const char* w_8[] = {
    "aardvark", "abacuses", "abalones", "abandons", "abashing",
    "abattoir", "abbesses", "abdicate", "abdomens", "abducted",
    "abductor", "aberrant", "abetting", "abettors", "abeyance",
    "abhorred", "abidings", "abjected", "abjectly", "abjuring",
    "ablative", "ablution", "abnegate", "abnormal", "aborting",
    "abortion", "abortive", "abounded", "abrading", "abrasion",
    "abrasive", "abridged", "abridges", "abrogate", "abrupter",
    "abruptly", "abscissa", "absconds", "abseiled", "absences",
    "absented", "absentee", "absently", "absinthe", "absolute",
    "absolved", "absolves", "absorbed", "abstains", "abstract",
    "abstruse", "absurder", "absurdly", "abundant", "abutment",
    "abutting", "academia", "academic", "acanthus", "acceding",
    "accented", "accepted", "accessed", "accesses", "accident",
    "acclaims", "accolade", "accorded", "accosted", "accounts",
    "accredit", "accruals", "accruing", "accuracy", "accurate",
    "accursed", "accusers", "accusing", "accustom", "acerbity",
    "acetates", "achieved", "achiever", "achieves", "achingly",
    "acolytes", "aconites", "acoustic", "acquaint", "acquired",
    "acquirer", "acquires", "acreages", "acridest", "acrimony",
    "acrobats", "acronyms", "acrostic", "acrylics", "actinium",
    "actioned", "activate", "actively", "activism", "activist",
    "activity", "actually", "actuated", "actuates", "actuator",
    "adapting", "adaption", "adaptive", "addendum", "addicted",
    "addition", "additive", "adducing", "adenoids", "adeptest",
    "adequacy", "adequate", "adherent", "adhering", "adhesion",
    "adhesive", "adjacent", "adjoined", "adjourns", "adjudged",
    "adjudges", "adjuncts", "adjuring", "adjusted", "adjuster",
    "adjutant", "admirals", "admirers", "admiring", "admitted",
    "admonish", "adopting", "adoption", "adoptive", "adorable",
    "adorably", "adorning", "adrenals", "adroiter", "adroitly",
    "adulated", "adulates", "adultery", "advanced", "advances",
    "adverser", "adverted", "advisers", "advising", "advisory",
    "advocacy", "advocate", "aerating", "aeration", "aerators",
    "aerobics", "aerogram", "aerosols", "aesthete", "affabler",
    "affected", "affinity", "affirmed", "affixing", "afflicts",
    "affluent", "afforded", "afforest", "affronts", "aflutter",
    "agencies", "aggrieve", "agitated", "agitates", "agitator",
    "agitprop", "aglitter", "agnostic", "agrarian", "agreeing",
    "agronomy", "ailerons", "ailments", "airbases", "airborne",
    "airbrush", "aircraft", "aircrews", "airdrome", "airdrops",
    "airfares", "airfield", "airheads", "airiness", "airlifts",
    "airliner", "airlines", "airlocks", "airmails", "airports",
    "airships", "airshows", "airspace", "airspeed", "airstrip",
    "airtight", "airwaves", "airwoman", "airwomen", "alacrity",
    "alarming", "alarmist", "albacore", "alcohols", "alderman",
    "aldermen", "alehouse", "alertest", "alerting", "alfresco",
    "algebras", "aliasing", "alibiing", "alienate", "aliening",
    "alighted", "aligning", "alkalies", "alkaline", "alkaloid",
    "allaying", "alleging", "allegory", "allegros", "alleluia",
    "allergen", "allergic", "alleyway", "alliance", "allocate",
    "allotted", "allowing", "alloying", "allspice", "alluding",
    "alluring", "allusion", "allusive", "alluvial", "alluvium",
    "almanack", "almanacs", "almighty", "almoners", "alphabet",
    "altering", "although", "altitude", "altruism", "altruist",
    "alveolar", "amalgams", "amaranth", "amassing", "amateurs",
    "ambiance", "ambition", "ambrosia", "ambushed", "ambushes",
    "amenable", "amending", "amethyst", "amicable", "amicably",
    "ammeters", "amnesiac", "amorally", "amounted", "amperage",
    "amputate", "amputees", "anaconda", "anagrams", "analogue",
    "analysis", "analysts", "analytic", "anapests", "anarchic",
    "anathema", "anatomic", "ancestor", "ancestry", "anchored",
    "ancients", "andantes", "andirons", "androgen", "androids",
    "anecdote", "anemones", "aneurysm", "angelica", "angering",
    "angriest", "angstrom", "animated", "animates", "animator",
    "animists", "annealed", "annexing", "annotate", "announce",
    "annoying", "annually", "annulars", "annulled", "anodynes",
    "anointed", "anorexia", "anorexic", "answered", "antacids",
    "anteater", "antedate", "antelope", "antennae", "antennas",
    "anterior", "anteroom", "anthills", "antibody", "anticked",
    "antidote", "antigens", "antihero", "antimony", "antiqued",
    "antiques", "antlered", "antonyms", "anyplace", "anything",
    "anywhere", "aperitif", "aperture", "aphasics", "aphelion",
    "aphorism", "apiaries", "apologia", "apoplexy", "apostasy",
    "apostate", "apostles", "appalled", "apparels", "apparent",
    "appealed", "appeared", "appeased", "appeaser", "appeases",
    "appended", "appendix", "appetite", "applauds", "applause",
    "applying", "appoints", "apposite", "appraise", "apprised",
    "apprises", "approach", "approval", "approved", "approves",
    "apricots", "aptitude", "aquanaut", "aquarium", "aquatics",
    "aquatint", "aqueduct", "aquifers", "aquiline", "arachnid",
    "arbiters", "arboreal", "archaism", "archduke", "archival",
    "archived", "archives", "archness", "archways", "ardently",
    "argosies", "arguable", "arguably", "argument", "armament",
    "armature", "armbands", "armchair", "armholes", "armloads",
    "armrests", "aromatic", "arousing", "arpeggio", "arraigns",
    "arranged", "arranger", "arranges", "arraying", "arrested",
    "arrivals", "arriving", "arrogant", "arrogate", "arsenals",
    "arsonist", "arterial", "arteries", "artfully", "articled",
    "articles", "artifact", "artifice", "artisans", "artistes",
    "artistic", "artistry", "artsiest", "artworks", "asbestos",
    "ascended", "ascetics", "ascribed", "ascribes", "ashtrays",
    "asocials", "asperity", "asphalts", "asphyxia", "aspirant",
    "aspirate", "aspiring", "aspirins", "assailed", "assassin",
    "assaults", "assaying", "assemble", "assembly", "assented",
    "asserted", "assessed", "assesses", "assessor", "assigned",
    "assisted", "assorted", "assuaged", "assuages", "assuming",
    "assureds", "assuring", "asterisk", "asteroid", "astonish",
    "astounds", "astutely", "astutest", "ateliers", "atheists",
    "athletes", "athletic", "atlantes", "atrocity", "attached",
    "attacked", "attacker", "attained", "attempts", "attended",
    "attendee", "attender", "attested", "attiring", "attitude",
    "attorney", "attracts", "attuning", "atwitter", "atypical",
    "auctions", "audacity", "audibles", "audience", "auditing",
    "audition", "auditors", "auditory", "augments", "auguries",
    "auguring", "auguster", "aureoled", "aureoles", "auricles",
    "auspices", "austerer", "authored", "autistic", "autobahn",
    "autocrat", "automate", "autonomy", "autumnal", "availing",
    "avengers", "avenging", "averaged", "averages", "averring",
    "aversion", "averting", "aviaries", "aviation", "aviators",
    "aviatrix", "avionics", "avocados", "avoiding", "avowedly",
    "awaiting", "awakened", "awarding", "awfuller", "azimuths",
    "babblers", "babbling", "babushka", "babyhood", "babysits",
    "bachelor", "bacillus", "backache", "backbite", "backbone",
    "backchat", "backcomb", "backdate", "backdoor", "backdrop",
    "backfire", "backhand", "backhoes", "backings", "backlash",
    "backless", "backlogs", "backpack", "backrest", "backroom",
    "backside", "backslid", "backspin", "backstop", "backward",
    "backwash", "backyard", "bacteria", "badgered", "badinage",
    "badlands", "badmouth", "baffling", "baggiest", "bagpipes",
    "baguette", "bailiffs", "bailouts", "bakeries", "balanced",
    "balances", "baldness", "balkiest", "ballasts", "ballcock",
    "balletic", "ballgirl", "ballgown", "balloons", "balloted",
    "ballpark", "ballroom", "ballsier", "ballsing", "ballyhoo",
    "balmiest", "balsamed", "baluster", "banalest", "banality",
    "bandaged", "bandages", "bandanna", "bandiest", "banditry",
    "bandsman", "bandsmen", "bandying", "banished", "banishes",
    "banister", "banjoist", "bankable", "bankbook", "banknote",
    "bankroll", "bankrupt", "bannered", "bannocks", "banquets",
    "banshees", "bantered", "baptisms", "baptists", "barbaric",
    "barbecue", "barbells", "barbered", "barberry", "bareback",
    "barefoot", "bareness", "barflies", "bargains", "baritone",
    "barmaids", "barmiest", "barnacle", "barnyard", "baroness",
    "baronets", "baronial", "baronies", "barracks", "barraged",
    "barrages", "barrener", "barrette", "barriers", "barrings",
    "barrooms", "bartered", "baseball", "baseless", "baseline",
    "basement", "baseness", "basilica", "basilisk", "basketry",
    "bassinet", "bassists", "bassoons", "bastards", "bastions",
    "batching", "bathmats", "bathrobe", "bathroom", "bathtubs",
    "battened", "battered", "battiest", "battlers", "battling",
    "baulking", "bawdiest", "bayberry", "bayonets", "bazookas",
    "beaching", "beadiest", "beagling", "beanbags", "beanpole",
    "bearable", "bearding", "bearings", "bearskin", "beatific",
    "beatings", "beatniks", "beauties", "beautify", "beavered",
    "becalmed", "beckoned", "becoming", "bedaubed", "bedazzle",
    "bedecked", "bedevils", "bedheads", "bedposts", "bedrocks",
    "bedrolls", "bedrooms", "bedsides", "bedsores", "bedstead",
    "bedtimes", "beechnut", "beefcake", "beefiest", "beehives",
    "beelined", "beelines", "beetling", "beetroot", "befallen",
    "befitted", "befogged", "befouled", "befriend", "befuddle",
    "begetter", "beggared", "beggarly", "beginner", "begonias",
    "begotten", "begrudge", "beguiled", "beguiles", "behalves",
    "behaving", "beheaded", "behemoth", "beholden", "beholder",
    "bejewels", "belaying", "belching", "belfries", "believed",
    "believer", "believes", "belittle", "bellboys", "bellhops",
    "bellowed", "bellyful", "bellying", "belonged", "beloveds",
    "beltways", "bemoaned", "bemusing", "benching", "bendable",
    "bendiest", "benefice", "benefits", "benignly", "benumbed",
    "bequeath", "bequests", "berating", "bereaved", "bereaves",
    "beriberi", "berrying", "berthing", "besieged", "besieger",
    "besieges", "besmirch", "besoming", "besotted", "besought",
    "bespeaks", "bespoken", "bestiary", "bestowal", "bestowed",
    "bestride", "bestrode", "betaking", "bethinks", "betiding",
    "betokens", "betrayal", "betrayed", "betrayer", "betroths",
    "bettered", "beverage", "bewailed", "bewaring", "bewigged",
    "bewilder", "biannual", "biathlon", "biblical", "bibulous",
    "bickered", "bicuspid", "bicycled", "bicycles", "biennial",
    "bifocals", "bigamist", "bigamous", "bighorns", "bigmouth",
    "bilabial", "bilberry", "billeted", "billfold", "billhook",
    "billiard", "billings", "billions", "billowed", "billycan",
    "binaries", "bindings", "bindweed", "binnacle", "binomial",
    "biopsied", "biopsies", "biplanes", "biracial", "birching",
    "birdbath", "birdcage", "birdlike", "birdseed", "birdsong",
    "birdying", "birettas", "birthday", "birthing", "biscuits",
    "bisected", "bisector", "bisexual", "bitchier", "bitching",
    "bitingly", "bitterer", "bitterly", "bitterns", "bivalves",
    "bivouacs", "biweekly", "bizarres", "blabbers", "blabbing",
    "blackens", "blackest", "blacking", "blackish", "blackleg",
    "blackout", "blacktop", "bladders", "blagging", "blanched",
    "blanches", "blandest", "blankest", "blankets", "blanking",
    "blarneys", "blasters", "blasting", "blastoff", "blathers",
    "blazoned", "bleached", "bleacher", "bleaches", "bleakest",
    "blearier", "blearily", "bleating", "bleeders", "bleeding",
    "bleepers", "bleeping", "blenched", "blenches", "blenders",
    "blending", "blessing", "blethers", "blighted", "blighter",
    "blimpish", "blinders", "blindest", "blinding", "blinkers",
    "blinking", "blintzes", "blissful", "blissing", "blisters",
    "blithely", "blithest", "blitzing", "blizzard", "bloaters",
    "bloating", "blobbing", "blockade", "blockage", "blocking",
    "blondest", "bloodied", "bloodier", "bloodies", "bloodily",
    "blooding", "bloomers", "blooming", "bloopers", "blossoms",
    "blotched", "blotches", "blotters", "blotting", "blousing",
    "blowguns", "blowhard", "blowhole", "blowlamp", "blowouts",
    "blowpipe", "blowzier", "blubbers", "bludgeon", "bluebell",
    "bluebird", "bluefish", "bluenose", "bluffers", "bluffest",
    "bluffing", "blunders", "bluntest", "blunting", "blurrier",
    "blurring", "blurting", "blushers", "blushing", "blusters",
    "blustery", "boarders", "boarding", "boasters", "boastful",
    "boasting", "boatload", "boatyard", "bobbling", "bobolink",
    "bobsleds", "bobtails", "bobwhite", "bodysuit", "bodywork",
    "bogeying", "bogeyman", "bogeymen", "boggiest", "boggling",
    "bohemian", "boilings", "boldface", "boldness", "bollards",
    "bollocks", "bolsters", "bolthole", "bombards", "bombings",
    "bombsite", "bonanzas", "bondsman", "bondsmen", "bonehead",
    "boneless", "bonfires", "bonhomie", "bonniest", "bookable",
    "bookcase", "bookends", "bookings", "booklets", "bookmark",
    "bookshop", "bookworm", "boosters", "boosting", "bootlace",
    "bootlegs", "bootless", "booziest", "bordello", "bordered",
    "borehole", "boringly", "boroughs", "borrowed", "borrower",
    "borstals", "bossiest", "botanist", "botching", "bothered",
    "bottlers", "bottling", "bottomed", "botulism", "boudoirs",
    "bouffant", "bouillon", "boulders", "bouncers", "bouncier",
    "bouncing", "boundary", "bounders", "bounding", "bounties",
    "bouquets", "bourbons", "boutique", "bowsprit", "boxrooms",
    "boycotts", "boyhoods", "boyishly", "bracelet", "brackets",
    "brackish", "bradawls", "braggart", "braggers", "bragging",
    "braiding", "brainier", "braining", "braising", "brakeman",
    "brakemen", "brambles", "branched", "branches", "brandied",
    "brandies", "branding", "brandish", "brashest", "brassier",
    "brassing", "brattier", "bravuras", "brawlers", "brawling",
    "brawnier", "brazened", "brazenly", "braziers", "breached",
    "breaches", "breadbox", "breading", "breadths", "breakage",
    "breakers", "breaking", "breakout", "breakups", "breasted",
    "breathed", "breather", "breathes", "breeches", "breeders",
    "breeding", "breezier", "breezily", "breezing", "brethren",
    "breviary", "brickbat", "brickies", "bricking", "bridging",
    "bridling", "briefest", "briefing", "brigades", "brigands",
    "brighten", "brighter", "brightly", "brimming", "brindled",
    "bringing", "briniest", "brioches", "briskest", "briskets",
    "brisking", "bristled", "bristles", "britches", "brittler",
    "broached", "broaches", "broadens", "broadest", "brocaded",
    "brocades", "broccoli", "brochure", "broilers", "broiling",
    "brokered", "brollies", "bromides", "bronchus", "bronzing",
    "brooches", "brooders", "broodily", "brooding", "brooking",
    "brothels", "brothers", "brougham", "brouhaha", "browbeat",
    "brownest", "brownier", "brownies", "browning", "brownish",
    "brownout", "browsers", "browsing", "bruisers", "bruising",
    "bruiting", "brunched", "brunches", "brunette", "brunting",
    "brushing", "brusquer", "brutally", "bubblier", "bubbling",
    "bucketed", "buckeyes", "bucklers", "buckling", "bucksaws",
    "buckshot", "buckskin", "bucolics", "buddings", "budgeted",
    "buffered", "buffeted", "buffoons", "bugaboos", "bugbears",
    "buggered", "buggiest", "builders", "building", "buildups",
    "bulgiest", "bulimics", "bulkhead", "bulkiest", "bulldogs",
    "bulldoze", "bulletin", "bullfrog", "bullhorn", "bulliest",
    "bullocks", "bullpens", "bullring", "bullshit", "bullwhip",
    "bullying", "bulwarks", "bumblers", "bumbling", "bumpiest",
    "bumpkins", "bunching", "bundling", "bungalow", "bunghole",
    "bunglers", "bungling", "buntings", "buoyancy", "burbling",
    "burdened", "burgeons", "burghers", "burglars", "burglary",
    "burgling", "burgundy", "burliest", "burnoose", "burnouts",
    "burritos", "burrowed", "bursitis", "bursting", "bushiest",
    "bushings", "business", "busloads", "bustiers", "bustiest",
    "bustling", "busybody", "busyness", "busywork", "butchers",
    "butchery", "butlered", "buttered", "buttocks", "buttoned",
    "buttress", "buxomest", "buzzards", "buzzword", "bypassed",
    "bypasses", "cabarets", "cabbages", "cabinets", "caboodle",
    "cabooses", "cacheted", "cackling", "cadavers", "cadences",
    "cadenzas", "caduceus", "caesuras", "caffeine", "caginess",
    "cagoules", "caissons", "cajolery", "cajoling", "cakewalk",
    "calabash", "calamine", "calamity", "calcined", "calcines",
    "calculus", "calendar", "calfskin", "calicoes", "callable",
    "callings", "calliope", "callower", "callused", "calluses",
    "calmness", "calories", "calypsos", "cambered", "cambiums",
    "camellia", "cameoing", "camisole", "campaign", "campfire",
    "campiest", "campsite", "campused", "campuses", "camshaft",
    "canaries", "candider", "candidly", "candling", "candying",
    "canister", "cankered", "cannabis", "cannibal", "canniest",
    "cannoned", "canoeist", "canoodle", "canopied", "canopies",
    "cantatas", "canteens", "cantered", "canticle", "canvased",
    "canvases", "capabler", "capacity", "capering", "capitals",
    "capitols", "caprices", "capsicum", "capsized", "capsizes",
    "capstans", "capsuled", "capsules", "captains", "captions",
    "captious", "captives", "captured", "captures", "caramels",
    "carapace", "caravans", "caraways", "carbides", "carbines",
    "carbolic", "carcases", "cardamom", "cardamon", "cardigan",
    "cardinal", "careened", "careered", "carefree", "careless",
    "caressed", "caresses", "careworn", "caribous", "carillon",
    "carjacks", "carloads", "carmines", "carnally", "carnival",
    "caroming", "carotids", "carousal", "caroused", "carousel",
    "carouser", "carouses", "carpeted", "carpools", "carports",
    "carriage", "carriers", "carryall", "carrycot", "carrying",
    "carryout", "cartload", "cartoons", "carvings", "caryatid",
    "cascaded", "cascades", "casebook", "caseload", "casement",
    "casework", "cashiers", "cashless", "cashmere", "cassavas",
    "cassette", "cassocks", "castanet", "castaway", "castings",
    "castling", "castoffs", "castrate", "casually", "casualty",
    "casuists", "catacomb", "catalpas", "catalyst", "catapult",
    "cataract", "catbirds", "catboats", "catcalls", "catchall",
    "catchers", "catchier", "catching", "category", "caterers",
    "catering", "catheter", "cathodes", "catholic", "catsuits",
    "cattails", "cattiest", "catwalks", "caucused", "caucuses",
    "cauldron", "caulking", "causally", "causeway", "caustics",
    "cautions", "cautious", "cavalier", "cavities", "cavorted",
    "cedillas", "ceilidhs", "ceilings", "celeriac", "celerity",
    "celestas", "celibacy", "celibate", "cellists", "cellmate",
    "cellular", "cemented", "cemetery", "cenotaph", "censored",
    "censured", "censures", "censused", "censuses", "centaurs",
    "centimes", "centrals", "centrist", "cephalic", "ceramics",
    "cerebral", "cerebrum", "ceremony", "cerulean", "cervical",
    "cervices", "cesarean", "cessions", "cesspits", "cesspool",
    "cetacean", "chaffing", "chagrins", "chaining", "chainsaw",
    "chairing", "chairman", "chairmen", "chalices", "chalkier",
    "chalking", "chambers", "chambray", "champers", "champing",
    "champion", "chancels", "chancery", "chancier", "chancing",
    "chandler", "changing", "channels", "chanters", "chanteys",
    "chanting", "chapatis", "chapatti", "chaperon", "chaplain",
    "chaplets", "chappies", "chapping", "chapters", "charades",
    "charcoal", "chargers", "charging", "chariest", "chariots",
    "charisma", "charlady", "charlies", "charmers", "charming",
    "charring", "charters", "charting", "chastely", "chastens",
    "chastest", "chastise", "chastity", "chasuble", "chateaus",
    "chatline", "chattels", "chatters", "chattier", "chattily",
    "chatting", "cheapens", "cheapest", "cheaters", "cheating",
    "checking", "checkout", "checkups", "cheekier", "cheekily",
    "cheeking", "cheeping", "cheerful", "cheerier", "cheerily",
    "cheering", "cheerses", "cheesier", "cheesing", "cheetahs",
    "cheffing", "chemical", "chemises", "chemists", "chenille",
    "cheroots", "cherries", "cherubic", "cherubim", "chessman",
    "chessmen", "chestnut", "chevrons", "chewiest", "chicanes",
    "chichier", "chickens", "chickpea", "chiefest", "chiggers",
    "chignons", "childing", "childish", "children", "chillers",
    "chillest", "chillier", "chillies", "chilling", "chimeras",
    "chimneys", "chinking", "chinless", "chinning", "chinwags",
    "chipmunk", "chippers", "chippies", "chipping", "chirpier",
    "chirpily", "chirping", "chirrups", "chiseled", "chiseler",
    "chitchat", "chivalry", "chivvied", "chivvies", "chivying",
    "chloride", "chlorine", "chocking", "choicest", "choirboy",
    "choleric", "chomping", "choosier", "choosing", "choppers",
    "choppier", "choppily", "chopping", "chorales", "chortled",
    "chortles", "chorused", "choruses", "chowders", "christen",
    "chroming", "chromium", "chronics", "chubbier", "chucking",
    "chuckled", "chuckles", "chugging", "chummier", "chummies",
    "chummily", "chumming", "chunders", "chunkier", "chunters",
    "churches", "churlish", "churning", "chutneys", "chutzpah",
    "cilantro", "cinching", "cinchona", "cincture", "cindered",
    "cinnabar", "cinnamon", "ciphered", "circlets", "circling",
    "circuits", "circular", "circuses", "cisterns", "citadels",
    "citation", "citizens", "citruses", "citywide", "civilian",
    "civility", "clacking", "cladding", "claimant", "claiming",
    "clambake", "clambers", "clammier", "clamming", "clamping",
    "clangers", "clanging", "clanking", "clannish", "clansman",
    "clansmen", "clappers", "clapping", "claptrap", "clareted",
    "clarinet", "clarions", "clashing", "clasping", "classics",
    "classier", "classify", "classing", "clatters", "clavicle",
    "clayiest", "cleaners", "cleanest", "cleaning", "cleansed",
    "cleanser", "cleanses", "cleanups", "clearest", "clearing",
    "clearway", "cleavage", "cleavers", "cleaving", "clefting",
    "clematis", "clemency", "clenched", "clenches", "clergies",
    "clerical", "clerking", "cleverer", "cleverly", "clicking",
    "clifftop", "climates", "climatic", "climaxed", "climaxes",
    "climbers", "climbing", "clinched", "clincher", "clinches",
    "clingier", "clinging", "clinical", "clinkers", "clinking",
    "clippers", "clipping", "cliquish", "clitoral", "clitoris",
    "cloaking", "clobbers", "clocking", "clodding", "clogging",
    "cloister", "clomping", "clonking", "clopping", "closeout",
    "closeted", "closures", "clothier", "clothing", "clotting",
    "clotures", "cloudier", "clouding", "clouting", "clowning",
    "clownish", "clubbers", "clubbing", "clubfeet", "clubfoot",
    "clubland", "clucking", "clueless", "clumping", "clumsier",
    "clumsily", "clunkers", "clunkier", "clunking", "clusters",
    "clutched", "clutches", "clutters", "coaching", "coachman",
    "coachmen", "coalesce", "coalface", "coalmine", "coarsely",
    "coarsens", "coarsest", "coasters", "coasting", "coatings",
    "coatroom", "coattail", "coattest", "coauthor", "cobblers",
    "cobbling", "coccyges", "cochleae", "cochleas", "cockades",
    "cockatoo", "cockerel", "cockeyed", "cockiest", "cockneys",
    "cockpits", "cocksure", "cocktail", "coconuts", "cocooned",
    "coddling", "codicils", "codified", "codifies", "codpiece",
    "coequals", "coercing", "coercion", "coercive", "coexists",
    "coffined", "cogently", "cogitate", "cognates", "cognomen",
    "cogwheel", "cohabits", "coherent", "cohering", "cohesion",
    "cohesive", "coiffing", "coiffure", "coinages", "coincide",
    "colander", "coldness", "coleslaw", "coliseum", "collagen",
    "collages", "collapse", "collared", "collated", "collates",
    "collects", "colleens", "colleges", "collided", "collides",
    "colliers", "colliery", "colloids", "colloquy", "colluded",
    "colludes", "collying", "colognes", "colonels", "colonial",
    "colonies", "colonist", "colossal", "colossus", "columned",
    "comatose", "combated", "combined", "combines", "comeback",
    "comedian", "comedies", "comedown", "comelier", "comfiest",
    "comforts", "commando", "commands", "commence", "commends",
    "comments", "commerce", "commodes", "commoner", "commonly",
    "communal", "communed", "communes", "commuted", "commuter",
    "commutes", "compacts", "compared", "compares", "competed",
    "competes", "compiled", "compiler", "compiles", "complain",
    "complete", "complied", "complies", "comports", "composed",
    "composer", "composes", "composts", "compotes", "compound",
    "compress", "comprise", "computed", "computer", "computes",
    "comrades", "conceals", "conceded", "concedes", "conceits",
    "conceive", "concepts", "concerns", "concerto", "concerts",
    "conchies", "conching", "conciser", "conclave", "conclude",
    "concocts", "concrete", "condemns", "condense", "condoled",
    "condoles", "condoned", "condones", "conduced", "conduces",
    "conducts", "conduits", "confetti", "confided", "confides",
    "confined", "confines", "confirms", "conflate", "conflict",
    "conforms", "confound", "confront", "confused", "confuses",
    "confuted", "confutes", "congaing", "congeals", "congests",
    "congress", "conicals", "conifers", "conjoins", "conjoint",
    "conjugal", "conjured", "conjurer", "conjures", "connects",
    "connived", "conniver", "connives", "connoted", "connotes",
    "conquers", "conquest", "consents", "conserve", "consider",
    "consigns", "consists", "consoled", "consoles", "consorts",
    "conspire", "constant", "construe", "consular", "consults",
    "consumed", "consumer", "consumes", "contacts", "contains",
    "contempt", "contends", "contents", "contests", "contexts",
    "continua", "continue", "contorts", "contours", "contract",
    "contrail", "contrary", "contrast", "contrite", "contrive",
    "controls", "contused", "contuses", "convened", "convener",
    "convenes", "convents", "converge", "converse", "converts",
    "convexed", "convexes", "conveyed", "conveyor", "convicts",
    "convince", "convoked", "convokes", "convoyed", "convulse",
    "cookbook", "cookouts", "cookware", "coolants", "coolness",
    "coopered", "copilots", "copulate", "copybook", "copycats",
    "copyists", "coquetry", "coquette", "coracles", "cordials",
    "cordless", "cordoned", "corduroy", "cornball", "corncobs",
    "cornered", "cornices", "corniest", "cornmeal", "cornrows",
    "corollas", "coronary", "coroners", "coronets", "corporal",
    "corporas", "corrects", "corridor", "corroded", "corrodes",
    "corrupts", "corsages", "corsairs", "corseted", "cortical",
    "cortices", "corvette", "cosigned", "cosigner", "cosiness",
    "cosmetic", "cosmoses", "cosseted", "costings", "costlier",
    "costumed", "costumer", "costumes", "coteries", "cottaged",
    "cottager", "cottages", "cottoned", "couching", "coughing",
    "councils", "counsels", "counters", "countess", "counties",
    "counting", "couplets", "coupling", "couriers", "coursing",
    "courtesy", "courtier", "courting", "couscous", "covenant",
    "coverage", "coverall", "covering", "coverlet", "covertly",
    "coveting", "covetous", "cowardly", "cowbells", "cowbirds",
    "cowering", "cowgirls", "cowhands", "cowhides", "cowlicks",
    "cowlings", "coworker", "cowpokes", "cowsheds", "cowslips",
    "coxcombs", "coxswain", "cozening", "coziness", "crabbier",
    "crabbily", "crabbing", "crabwise", "crackers", "cracking",
    "crackled", "crackles", "crackpot", "crackups", "cradling",
    "craftier", "craftily", "crafting", "craggier", "crammers",
    "cramming", "cramping", "crampons", "craniums", "crankest",
    "crankier", "cranking", "crannied", "crannies", "crappers",
    "crappier", "crappies", "crapping", "crashing", "crassest",
    "cratered", "cravenly", "cravings", "crawlers", "crawling",
    "crayfish", "crayoned", "craziest", "creakier", "creakily",
    "creaking", "creamers", "creamery", "creamier", "creaming",
    "creasing", "creating", "creation", "creative", "creators",
    "creature", "credence", "credenza", "credible", "credibly",
    "credited", "creditor", "creeling", "creepers", "creepier",
    "creepies", "creepily", "creeping", "cremated", "cremates",
    "creosote", "crescent", "cresting", "crevasse", "crevices",
    "cribbage", "cribbing", "crickets", "cricking", "criminal",
    "crimping", "crimsons", "cringing", "crinkled", "crinkles",
    "crippled", "cripples", "crispest", "crispier", "crisping",
    "criteria", "critical", "critique", "critters", "croaking",
    "crochets", "crockery", "crocuses", "crofters", "crofting",
    "cronyism", "crooking", "crooners", "crooning", "croppers",
    "cropping", "crosiers", "crossbar", "crossbow", "crossest",
    "crossing", "crotches", "crotchet", "crouched", "crouches",
    "croupier", "crouping", "crowbars", "crowding", "crowning",
    "crucible", "crucifix", "cruddier", "cruelest", "cruisers",
    "cruising", "crullers", "crumbier", "crumbing", "crumbled",
    "crumbles", "crummier", "crumpets", "crumpled", "crumples",
    "crunched", "cruncher", "crunches", "crusaded", "crusader",
    "crusades", "crushers", "crushing", "crustier", "crusties",
    "crusting", "crutches", "cryonics", "crystals", "cubicles",
    "cuckolds", "cucumber", "cuddlier", "cuddling", "cuisines",
    "culinary", "culottes", "culpable", "culpably", "culprits",
    "cultural", "cultured", "cultures", "culverts", "cupboard",
    "cupcakes", "cupidity", "cupolaed", "curacies", "curating",
    "curative", "curators", "curbside", "curdling", "curlicue",
    "curliest", "currants", "currency", "currents", "currying",
    "curseder", "cursored", "curtails", "curtains", "curtness",
    "curtsied", "curtsies", "curviest", "cushiest", "cushions",
    "cuspidor", "cussedly", "custards", "customer", "cutaways",
    "cutbacks", "cuteness", "cutesier", "cuticles", "cuttings",
    "cyclamen", "cyclical", "cyclists", "cyclones", "cyclonic",
    "cylinder", "cynicism", "cynosure", "cystitis", "cytology",
    "czarinas", "czarists", "dabblers", "dabbling", "dactylic",
    "daffiest", "daffodil", "daftness", "daintier", "dainties",
    "daintily", "daiquiri", "dairying", "dairyman", "dairymen",
    "dallying", "damaging", "damasked", "damnable", "damnably",
    "damneder", "dampened", "dampness", "dandered", "dandiest",
    "dandling", "dandruff", "dangered", "dangling", "dankness",
    "dapperer", "dappling", "daringly", "darkened", "darklier",
    "darkness", "darkroom", "darlings", "darneder", "dashikis",
    "database", "datebook", "dateline", "daughter", "daunting",
    "dauphins", "dawdlers", "dawdling", "daybreak", "daydream",
    "daylight", "dazzling", "deadbeat", "deadbolt", "deadened",
    "deadhead", "deadlier", "deadline", "deadlock", "deadpans",
    "deadwood", "deafened", "deafness", "dealings", "dearests",
    "dearness", "deathbed", "debacles", "debarked", "debarred",
    "debasing", "debaters", "debating", "debility", "debiting",
    "debonair", "debriefs", "debugged", "debugger", "debunked",
    "debuting", "decadent", "decamped", "decanted", "decanter",
    "decaying", "deceased", "deceases", "decedent", "deceived",
    "deceiver", "deceives", "decenter", "decently", "decibels",
    "deciders", "deciding", "decimals", "decimate", "decipher",
    "decision", "decisive", "deckhand", "declaims", "declared",
    "declares", "declined", "declines", "decoders", "decoding",
    "decorate", "decorous", "decouple", "decoying", "decrease",
    "decrepit", "decrying", "dedicate", "deducing", "deducted",
    "deejayed", "deepened", "deepness", "deerskin", "defacing",
    "defaming", "defaults", "defeated", "defecate", "defected",
    "defector", "defended", "defender", "deferral", "deferred",
    "defiance", "deficits", "defiling", "definers", "defining",
    "definite", "deflated", "deflates", "deflects", "deflower",
    "defogged", "defogger", "deforest", "deformed", "defrauds",
    "defrayal", "defrayed", "defrocks", "defrosts", "deftness",
    "defuncts", "defusing", "degraded", "degrades", "deifying",
    "deigning", "dejected", "delaying", "delegate", "deleting",
    "deletion", "delicacy", "delicate", "delights", "delimits",
    "delirium", "delivers", "delivery", "deloused", "delouses",
    "deluding", "deluging", "delusion", "delusive", "demagogy",
    "demanded", "demeaned", "demented", "dementia", "demerits",
    "demesnes", "demigods", "demijohn", "demising", "demisted",
    "demister", "demobbed", "democrat", "demolish", "demoniac",
    "demoting", "demotion", "demurely", "demurest", "demurred",
    "demurrer", "denature", "dendrite", "deniable", "denizens",
    "denoting", "denounce", "dentists", "dentures", "denuding",
    "departed", "depended", "depicted", "deplaned", "deplanes",
    "depleted", "depletes", "deplored", "deplores", "deployed",
    "deported", "deportee", "deposing", "deposits", "depraved",
    "depraves", "deprived", "deprives", "deputies", "deputing",
    "derailed", "deranged", "deranges", "derelict", "deriding",
    "derision", "derisive", "derisory", "deriving", "derogate",
    "derricks", "descaled", "descales", "descants", "descends",
    "descents", "describe", "descried", "descries", "deselect",
    "deserted", "deserter", "deserved", "deserves", "designed",
    "designer", "desiring", "desirous", "desisted", "deskills",
    "desktops", "desolate", "despairs", "despised", "despises",
    "despoils", "despotic", "desserts", "destined", "destines",
    "destroys", "destruct", "detached", "detaches", "detailed",
    "detained", "detainee", "detected", "detector", "detentes",
    "deterred", "detested", "dethrone", "detonate", "detoured",
    "detoxify", "detoxing", "detracts", "detritus", "devalued",
    "devalues", "develops", "deviance", "deviancy", "deviants",
    "deviated", "deviates", "devilish", "deviltry", "devising",
    "devolved", "devolves", "devotees", "devoting", "devotion",
    "devoured", "devouter", "devoutly", "dewberry", "dewdrops",
    "dextrose", "diabetes", "diabetic", "diabolic", "diagnose",
    "diagonal", "diagrams", "dialects", "dialysis", "diameter",
    "diamonds", "diapered", "diarists", "diaspora", "diatonic",
    "diatribe", "dibbling", "dickered", "dickhead", "dickiest",
    "dictated", "dictates", "dictator", "didactic", "diddling",
    "diereses", "dieresis", "dieseled", "dietetic", "differed",
    "diffract", "diffused", "diffuses", "digested", "digraphs",
    "dilating", "dilation", "dilatory", "dilemmas", "diligent",
    "diluting", "dilution", "diminish", "dimpling", "dinettes",
    "dingbats", "dinghies", "dingiest", "dinkiest", "dinnered",
    "dinosaur", "diocesan", "dioceses", "dioramas", "dioxides",
    "diplomas", "diplomat", "dippiest", "dipstick", "directed",
    "directer", "directly", "director", "dirtiest", "dirtying",
    "disabled", "disables", "disabuse", "disagree", "disallow",
    "disarmed", "disarray", "disaster", "disavows", "disbands",
    "disburse", "discards", "discerns", "disciple", "disclaim",
    "disclose", "discoing", "discords", "discount", "discover",
    "discreet", "discrete", "discuses", "disdains", "diseased",
    "diseases", "disgorge", "disgrace", "disguise", "disgusts",
    "dishevel", "dishpans", "dishrags", "disinter", "disjoint",
    "diskette", "disliked", "dislikes", "dislodge", "disloyal",
    "dismaler", "dismally", "dismayed", "dismount", "disobeys",
    "disorder", "disowned", "dispatch", "dispense", "disperse",
    "dispirit", "displace", "displays", "disports", "disposal",
    "disposed", "disposes", "disproof", "disprove", "disputed",
    "disputes", "disquiet", "disrobed", "disrobes", "disrupts",
    "dissects", "dissents", "dissolve", "dissuade", "distaffs",
    "distance", "distaste", "distends", "distills", "distinct",
    "distorts", "distract", "distrait", "distress", "district",
    "distrust", "disturbs", "disunite", "disunity", "disusing",
    "ditching", "dithered", "ditherer", "dittoing", "diuretic",
    "diverged", "diverges", "diverted", "divested", "dividend",
    "dividers", "dividing", "divinely", "diviners", "divinest",
    "divining", "divinity", "division", "divisive", "divisors",
    "divorced", "divorces", "divulged", "divulges", "divvying",
    "dizziest", "dizzying", "doberman", "docilely", "docility",
    "docketed", "dockland", "dockside", "dockyard", "doctoral",
    "doctored", "doctrine", "document", "doddered", "dodgiest",
    "dogcarts", "dogfight", "doggedly", "doggerel", "doggiest",
    "doggoned", "doggoner", "doggones", "doghouse", "dogmatic",
    "dogsbody", "dogsleds", "dogtrots", "dogwoods", "doldrums",
    "dolloped", "dolorous", "dolphins", "domestic", "domicile",
    "dominant", "dominate", "domineer", "dominion", "dominoes",
    "donating", "donation", "doodlers", "doodling", "doolally",
    "doomsday", "doomster", "doorbell", "doorjamb", "doorknob",
    "doormats", "doorpost", "doorstep", "doorstop", "doorways",
    "dorkiest", "dormancy", "dormants", "dormouse", "dossiers",
    "dotingly", "dottiest", "doublets", "doubling", "doubloon",
    "doubters", "doubtful", "doubting", "douching", "doughier",
    "dovecote", "dovecots", "dovetail", "dowagers", "dowdiest",
    "downbeat", "downcast", "downfall", "downhill", "downiest",
    "download", "downplay", "downpour", "downside", "downsize",
    "downtime", "downtown", "downturn", "downward", "downwind",
    "doxology", "doyennes", "doziness", "drabbest", "drabness",
    "drachmas", "draftees", "dragging", "dragnets", "dragoons",
    "dragster", "drainage", "drainers", "draining", "dramatic",
    "drawback", "drawings", "drawling", "dreadful", "dreading",
    "dreamers", "dreamier", "dreamily", "dreaming", "drearier",
    "drearies", "drearily", "dredgers", "dredging", "drenched",
    "drenches", "dressage", "dressers", "dressier", "dressing",
    "dribbled", "dribbler", "dribbles", "driblets", "drifters",
    "drifting", "driftnet", "drilling", "drinkers", "drinking",
    "drippier", "dripping", "driveway", "drivings", "drizzled",
    "drizzles", "drollery", "drollest", "drooling", "droopier",
    "drooping", "droplets", "dropouts", "droppers", "dropping",
    "droughts", "drowning", "drowsier", "drowsily", "drowsing",
    "drubbing", "drudgery", "drudging", "druggies", "drugging",
    "druggist", "drumbeat", "drummers", "drumming", "drunkard",
    "drunkest", "drywalls", "duckbill", "duckling", "duckweed",
    "ductless", "dukedoms", "dulcimer", "dullards", "dullness",
    "dumbbell", "dumbness", "dumpiest", "dumpling", "dumpster",
    "dungaree", "dungeons", "duodenal", "duodenum", "duplexes",
    "duration", "duskiest", "dustbins", "dustcart", "dustiest",
    "dustless", "dustpans", "dutiable", "dwarfest", "dwarfing",
    "dwarfish", "dwarfism", "dwellers", "dwelling", "dwindled",
    "dwindles", "dyestuff", "dynamics", "dynamism", "dynamite",
    "dynastic", "dyslexia", "dyslexic", "eagerest", "earaches",
    "eardrums", "earldoms", "earliest", "earlobes", "earmarks",
    "earmuffs", "earnests", "earnings", "earphone", "earpiece",
    "earplugs", "earrings", "earthier", "earthing", "easiness",
    "easterly", "eastward", "eatables", "eateries", "echelons",
    "eclectic", "eclipsed", "eclipses", "ecliptic", "economic",
    "ecstatic", "edgewise", "edginess", "edifices", "edifying",
    "editable", "editions", "educable", "educated", "educates",
    "educator", "eeriness", "effacing", "effected", "efficacy",
    "effigies", "effluent", "effusion", "effusive", "eggheads",
    "eggplant", "eggshell", "egoistic", "egomania", "egotists",
    "egresses", "eighteen", "eighties", "ejecting", "ejection",
    "elapsing", "elastics", "elbowing", "electing", "election",
    "elective", "electors", "electric", "electron", "elegance",
    "elegiacs", "elements", "elephant", "elevated", "elevates",
    "elevator", "eleventh", "elicited", "eligible", "elisions",
    "elitists", "ellipses", "ellipsis", "elliptic", "elongate",
    "eloquent", "emaciate", "emailing", "emanated", "emanates",
    "embalmed", "embalmer", "embarked", "embedded", "embezzle",
    "embitter", "emblazon", "embodied", "embodies", "embolden",
    "embolism", "embossed", "embosses", "embraced", "embraces",
    "embroils", "emceeing", "emending", "emeralds", "emergent",
    "emerging", "emeritus", "emerying", "emigrant", "emigrate",
    "eminence", "emirates", "emissary", "emission", "emitting",
    "emotions", "emperors", "emphases", "emphasis", "emphatic",
    "employed", "employee", "employer", "emporium", "empowers",
    "emptiest", "emptying", "emulated", "emulates", "emulator",
    "emulsify", "emulsion", "enablers", "enabling", "enacting",
    "encamped", "encasing", "enchants", "encircle", "enclaves",
    "enclosed", "encloses", "encoders", "encoding", "encoring",
    "encroach", "encrusts", "encrypts", "encumber", "endanger",
    "endeared", "endemics", "endgames", "endorsed", "endorser",
    "endorses", "endowing", "endpoint", "enduring", "energies",
    "enervate", "enfeeble", "enfolded", "enforced", "enforcer",
    "enforces", "engaging", "engender", "engineer", "engining",
    "engorged", "engorges", "engraved", "engraver", "engraves",
    "engulfed", "enhanced", "enhancer", "enhances", "enjoined",
    "enjoying", "enlarged", "enlarger", "enlarges", "enlisted",
    "enlistee", "enlivens", "enmeshed", "enmeshes", "enmities",
    "ennobled", "ennobles", "enormity", "enormous", "enquirer",
    "enraging", "enriched", "enriches", "enrolled", "ensconce",
    "ensemble", "enshrine", "enshroud", "enslaved", "enslaves",
    "ensnared", "ensnares", "ensuring", "entailed", "entangle",
    "ententes", "entering", "enthrone", "enthused", "enthuses",
    "enticing", "entirely", "entirety", "entities", "entitled",
    "entitles", "entombed", "entrails", "entrance", "entrants",
    "entreats", "entreaty", "entrench", "entrusts", "entryway",
    "entwined", "entwines", "envelope", "envelops", "enviable",
    "enviably", "environs", "envisage", "envision", "epaulets",
    "ephemera", "epicures", "epidemic", "epidural", "epigrams",
    "epigraph", "epilepsy", "epilogue", "epiphany", "episodes",
    "episodic", "epistles", "epitaphs", "epithets", "epitomes",
    "epoxying", "equality", "equating", "equation", "equators",
    "equipage", "equipped", "equities", "erasures", "erectile",
    "erecting", "erection", "erratics", "ersatzes", "erupting",
    "eruption", "escalate", "escalope", "escapade", "escapees",
    "escaping", "escapism", "escapist", "escarole", "eschewed",
    "escorted", "esoteric", "especial", "espousal", "espoused",
    "espouses", "espresso", "esquires", "essaying", "essayist",
    "essences", "esteemed", "estimate", "estrange", "etchings",
    "eternity", "ethereal", "ethicals", "etiology", "eugenics",
    "eulogies", "eulogist", "euphoria", "euphoric", "eutectic",
    "evacuate", "evacuees", "evaluate", "evasions", "evenings",
    "evenness", "evensong", "eventful", "eventide", "eventual",
    "evermore", "everyday", "everyone", "evicting", "eviction",
    "evidence", "evidents", "evildoer", "evincing", "evolving",
    "exactest", "exacting", "exalting", "examined", "examiner",
    "examines", "exampled", "examples", "excavate", "exceeded",
    "excelled", "excepted", "excerpts", "excesses", "exchange",
    "excising", "excision", "exciting", "exclaims", "excluded",
    "excludes", "excreted", "excretes", "excusing", "execrate",
    "executed", "executes", "executor", "exegeses", "exegesis",
    "exemplar", "exempted", "exercise", "exerting", "exertion",
    "exhaling", "exhausts", "exhibits", "exhorted", "exhuming",
    "exigency", "exigents", "exiguous", "existent", "existing",
    "exoduses", "exorcise", "exorcism", "exorcist", "expanded",
    "expanses", "expected", "expedite", "expelled", "expended",
    "expenses", "expertly", "expiated", "expiates", "expiring",
    "explains", "explicit", "exploded", "explodes", "exploits",
    "explored", "explorer", "explores", "exponent", "exported",
    "exporter", "exposing", "exposure", "expounds", "expunged",
    "expunges", "extended", "exterior", "external", "extincts",
    "extolled", "extorted", "extracts", "extremer", "extremes",
    "extruded", "extrudes", "exultant", "exulting", "eyeballs",
    "eyebrows", "eyeglass", "eyeliner", "eyepiece", "eyesight",
    "eyesores", "eyeteeth", "eyetooth", "fabulous", "faceless",
    "faceting", "facially", "facility", "factions", "factored",
    "factotum", "failings", "failures", "faintest", "fainting",
    "fairness", "fairways", "faithful", "faithing", "falconer",
    "falconry", "fallback", "fallible", "fallibly", "falloffs",
    "fallowed", "falsetto", "faltered", "familial", "familiar",
    "families", "famished", "famishes", "famously", "fanatics",
    "fanciers", "fanciest", "fanciful", "fancying", "fandango",
    "fanfares", "fanlight", "fantasia", "fanzines", "farcical",
    "farewell", "farmhand", "farmland", "farmyard", "farriers",
    "farrowed", "farthest", "farthing", "fascists", "fashions",
    "fastball", "fastened", "fastener", "fastness", "fatalism",
    "fatalist", "fatality", "fatheads", "fathered", "fatherly",
    "fathomed", "fatigued", "fatigues", "fattened", "fattiest",
    "faultier", "faultily", "faulting", "fearless", "fearsome",
    "feasible", "feasibly", "feasting", "feathers", "feathery",
    "featured", "features", "feckless", "federals", "federate",
    "feeblest", "feedback", "feedbags", "feedings", "feelgood",
    "feelings", "feigning", "feinting", "feistier", "feldspar",
    "felicity", "fellatio", "felonies", "feminine", "feminism",
    "feminist", "ferments", "ferocity", "ferreted", "ferrules",
    "ferrying", "ferryman", "ferrymen", "fervency", "fervidly",
    "festered", "festival", "festoons", "fetching", "fetishes",
    "fetlocks", "fettered", "feverish", "fiascoes", "ficklest",
    "fictions", "fiddlers", "fiddlier", "fiddling", "fidelity",
    "fidgeted", "fielders", "fielding", "fiendish", "fiercely",
    "fiercest", "fieriest", "fifteens", "fiftieth", "fighters",
    "fighting", "figments", "figurine", "figuring", "filament",
    "filberts", "filching", "filigree", "filleted", "fillings",
    "filliped", "filmiest", "filtered", "filthier", "filthily",
    "filtrate", "finagled", "finagler", "finagles", "finalist",
    "finality", "financed", "finances", "findings", "fineness",
    "finessed", "finesses", "fingered", "finished", "finisher",
    "finishes", "finitely", "finniest", "firearms", "fireball",
    "firebomb", "firebugs", "fireplug", "fireside", "firetrap",
    "firewall", "firewood", "firework", "firmness", "firmware",
    "fiscally", "fishbowl", "fishcake", "fishhook", "fishiest",
    "fishnets", "fishtail", "fishwife", "fissures", "fistfuls",
    "fitfully", "fitments", "fittings", "fixating", "fixation",
    "fixative", "fixtures", "fizziest", "fizzling", "flabbier",
    "flagella", "flagging", "flagpole", "flagrant", "flagship",
    "flailing", "flakiest", "flamenco", "flamingo", "flamings",
    "flanking", "flannels", "flapjack", "flappers", "flapping",
    "flashers", "flashest", "flashgun", "flashier", "flashily",
    "flashing", "flatbeds", "flatboat", "flatcars", "flatfeet",
    "flatfish", "flatfoot", "flatiron", "flatlets", "flatmate",
    "flatness", "flattens", "flatters", "flattery", "flattest",
    "flatting", "flattops", "flatware", "flaunted", "flautist",
    "flawless", "fleabags", "fleabite", "fleapits", "flecking",
    "fleecier", "fleecing", "fleetest", "fleeting", "fleshier",
    "fleshing", "fleshpot", "flexible", "flexibly", "flextime",
    "flickers", "flicking", "flimflam", "flimsier", "flimsily",
    "flinched", "flinches", "flinging", "flintier", "flippant",
    "flippers", "flippest", "flipping", "flirting", "flitting",
    "floaters", "floating", "flocking", "flogging", "flooding",
    "floodlit", "flooring", "floozies", "floppier", "floppies",
    "flopping", "floridly", "florists", "flossing", "flotilla",
    "flounced", "flounces", "flounder", "flourier", "flouring",
    "flourish", "flouting", "flowered", "flubbing", "fluently",
    "fluffier", "fluffing", "fluidity", "flukiest", "flunkies",
    "flunking", "fluoride", "fluorine", "fluorite", "flurried",
    "flurries", "flushest", "flushing", "flusters", "flutists",
    "flutters", "fluttery", "flyblown", "flyovers", "flypaper",
    "flypasts", "flysheet", "flyspeck", "flywheel", "foamiest",
    "focusing", "fogbound", "foggiest", "foghorns", "foisting",
    "foldaway", "folklore", "folksier", "follicle", "followed",
    "follower", "fomented", "fondants", "fondling", "fondness",
    "foolscap", "football", "footfall", "foothill", "foothold",
    "footings", "footling", "footnote", "footpath", "footrest",
    "footsies", "footsore", "footstep", "footwear", "footwork",
    "foragers", "foraging", "foraying", "forbears", "forborne",
    "forceful", "forcible", "forcibly", "forearms", "forebear",
    "forebode", "forecast", "foredoom", "forefeet", "forefoot",
    "foregone", "forehand", "forehead", "forelegs", "forelock",
    "foremast", "foremost", "forename", "forenoon", "forensic",
    "foreplay", "foresail", "foreseen", "foresees", "foreskin",
    "forested", "forester", "forestry", "foretell", "foretold",
    "forewarn", "forewent", "foreword", "forfeits", "forgiven",
    "forgives", "forgoing", "forkfuls", "forklift", "formalin",
    "formally", "formerly", "formless", "forsaken", "forsakes",
    "forsooth", "forswear", "forswore", "forsworn", "fortieth",
    "fortress", "fortunes", "forwards", "fostered", "foulness",
    "founders", "founding", "fountain", "fourfold", "foursome",
    "fourteen", "fourthly", "foxglove", "foxholes", "foxhound",
    "foxhunts", "foxtrots", "fracases", "fractals", "fraction",
    "fracture", "fragment", "fragrant", "frailest", "frankest",
    "franking", "fraughts", "frazzled", "frazzles", "freakier",
    "freaking", "freakish", "freckled", "freckles", "freebase",
    "freebies", "freedman", "freedmen", "freedoms", "freehand",
    "freehold", "freeload", "freesias", "freeware", "freeways",
    "freewill", "freezers", "freezing", "freights", "frenetic",
    "frenzied", "frenzies", "frequent", "frescoes", "freshens",
    "freshers", "freshest", "freshets", "freshman", "freshmen",
    "fretting", "fretwork", "friaries", "friction", "friendly",
    "friezing", "frigates", "frigging", "frighted", "frighten",
    "frigidly", "frillier", "frillies", "fringing", "frippery",
    "friskier", "friskily", "frisking", "frissons", "fritters",
    "frizzier", "frizzing", "frizzled", "frizzles", "frontage",
    "frontier", "fronting", "frostbit", "frostier", "frostily",
    "frosting", "frothier", "frothing", "frowning", "frowzier",
    "fructify", "fructose", "frugally", "fruitful", "fruitier",
    "fruiting", "fruition", "frumpier", "frumpish", "fuchsias",
    "fuckhead", "fuddling", "fugitive", "fulcrums", "fullback",
    "fullness", "fumblers", "fumbling", "fumigate", "function",
    "funerals", "funerary", "funereal", "funfairs", "funkiest",
    "funniest", "funnyman", "funnymen", "furbelow", "furlongs",
    "furlough", "furnaces", "furriers", "furriest", "furrowed",
    "furthers", "furthest", "fuselage", "fusilier", "fussiest",
    "fusspots", "fustiest", "futilely", "futility", "futurism",
    "futurist", "futurity", "fuzziest", "gabbiest", "gabbling",
    "gadabout", "gadflies", "gadgetry", "gainsaid", "gainsays",
    "galactic", "galaxies", "gallants", "galleons", "galloped",
    "galoshed", "galoshes", "galumphs", "galvanic", "gamblers",
    "gambling", "gamecock", "gameness", "gangland", "gangling",
    "ganglion", "gangrene", "gangstas", "gangster", "gangways",
    "gantlets", "gantries", "gaolbird", "garaging", "garbanzo",
    "garbling", "gardened", "gardener", "gardenia", "gargling",
    "gargoyle", "garishly", "garlands", "garlicky", "garments",
    "garnered", "garrison", "garroted", "garrotes", "gaslight",
    "gasoline", "gassiest", "gasworks", "gatepost", "gateways",
    "gathered", "gatherer", "gauchest", "gaudiest", "gauntest",
    "gaunting", "gauntlet", "gauziest", "gavottes", "gawkiest",
    "gazelles", "gazetted", "gazettes", "gazpacho", "gazumped",
    "geekiest", "geldings", "gemstone", "gendarme", "generals",
    "generate", "generics", "generous", "genetics", "genially",
    "genitals", "genitive", "geniuses", "genocide", "gentians",
    "gentiles", "gentlest", "gentling", "gentries", "gentrify",
    "geodesic", "geologic", "geometer", "geometry", "geranium",
    "germinal", "gestalts", "gestated", "gestates", "gestured",
    "gestures", "getaways", "gherkins", "ghosting", "ghoulish",
    "giantess", "gibbered", "gibbeted", "giddiest", "gigabyte",
    "gigantic", "gigglers", "gigglier", "giggling", "gimcrack",
    "gimleted", "gimmicks", "gimmicky", "gimpiest", "gingered",
    "gingerly", "ginkgoes", "giraffes", "girdling", "girlhood",
    "giveaway", "gizzards", "glaciers", "gladdens", "gladdest",
    "gladiola", "gladioli", "gladlier", "gladness", "glancing",
    "glasnost", "glassful", "glassier", "glassing", "glaucoma",
    "glaziers", "gleaming", "gleaning", "glibbest", "glibness",
    "glimmers", "glimpsed", "glimpses", "glinting", "glistens",
    "glitches", "glitters", "glittery", "glitzier", "gloaming",
    "gloating", "globally", "globular", "globules", "gloomier",
    "gloomily", "glopping", "glorious", "glorying", "glossary",
    "glossier", "glossies", "glossing", "glowered", "glowworm",
    "glummest", "glumness", "glutting", "gluttons", "gluttony",
    "glycerin", "glycerol", "glycogen", "gnarlier", "gnarling",
    "gnashing", "goalless", "goalpost", "goatherd", "goatskin",
    "gobblers", "gobbling", "godawful", "godchild", "godliest",
    "godsends", "godspeed", "goggling", "goldener", "goldfish",
    "goldmine", "golliwog", "gondolas", "goodbyes", "goodlier",
    "goodness", "goodwill", "goofiest", "googlies", "gorgeous",
    "gorillas", "goriness", "gormless", "goslings", "gossamer",
    "gouaches", "gourmand", "gourmets", "goutiest", "governed",
    "governor", "grabbier", "grabbing", "graceful", "gracious",
    "grackles", "gradable", "gradient", "graduate", "graffiti",
    "graffito", "grafters", "grafting", "grainier", "grammars",
    "grandads", "granddad", "grandees", "grandest", "grandeur",
    "grandmas", "grandpas", "grandson", "grannies", "granting",
    "granular", "granules", "graphics", "graphing", "graphite",
    "grapnels", "grappled", "grapples", "grasping", "grassier",
    "grassing", "grateful", "gratings", "gratuity", "gravelly",
    "gravitas", "grayness", "greasers", "greasier", "greasing",
    "greatest", "greedier", "greedily", "greenery", "greenest",
    "greenfly", "greening", "greenish", "greeting", "gremlins",
    "grenades", "greyness", "griddles", "gridiron", "gridlock",
    "grieving", "grievous", "griffins", "grilling", "grimaced",
    "grimaces", "grimiest", "grimmest", "grimness", "grinders",
    "grinding", "grinning", "gripping", "grislier", "gritters",
    "grittier", "gritting", "grizzled", "grizzles", "groaning",
    "groggier", "groggily", "grommets", "grooming", "groovier",
    "grooving", "grosbeak", "grossest", "grossing", "grottier",
    "grottoes", "grouched", "grouches", "grounded", "grounder",
    "groupers", "groupies", "grouping", "grousing", "grouting",
    "growling", "grownups", "grubbier", "grubbing", "grudging",
    "gruesome", "gruffest", "gruffing", "grumbled", "grumbler",
    "grumbles", "grumpier", "grumpily", "grungier", "grunting",
    "guaranty", "guardian", "guarding", "guessers", "guessing",
    "guesting", "guffawed", "guidance", "guilders", "guileful",
    "guiltier", "guiltily", "gullible", "gumballs", "gumboots",
    "gumdrops", "gummiest", "gumption", "gumshoes", "gunboats",
    "gunfight", "gunmetal", "gunpoint", "gunshots", "gunsmith",
    "gunwales", "gurgling", "gushiest", "gusseted", "gustiest",
    "gutsiest", "guttered", "guttural", "guzzlers", "guzzling",
    "gymkhana", "gymnasts", "gymslips", "gyrating", "gyration",
    "habitats", "habitual", "hacienda", "hackneys", "hacksaws",
    "haddocks", "haggises", "hagglers", "haggling", "hairband",
    "haircuts", "hairgrip", "hairiest", "hairless", "hairline",
    "hairnets", "hairpins", "halberds", "halfback", "halftime",
    "halftone", "halfwits", "halibuts", "hallmark", "hallowed",
    "hallways", "halogens", "haltered", "haltings", "halyards",
    "hammered", "hammocks", "hampered", "hamsters", "handbags",
    "handball", "handbill", "handbook", "handcars", "handcart",
    "handcuff", "handfuls", "handguns", "handhold", "handicap",
    "handiest", "handlers", "handling", "handmade", "handmaid",
    "handouts", "handover", "handpick", "handrail", "handsaws",
    "handsets", "handsome", "handwork", "handyman", "handymen",
    "hangings", "hangnail", "hangouts", "hangover", "hankered",
    "happened", "happiest", "harangue", "harassed", "harasses",
    "hardback", "hardball", "hardcore", "hardened", "hardener",
    "hardiest", "hardness", "hardship", "hardtack", "hardtops",
    "hardware", "hardwood", "harebell", "harelips", "haricots",
    "harmless", "harmonic", "harpists", "harpoons", "harridan",
    "harrowed", "harrumph", "harrying", "harshest", "harvests",
    "hassling", "hassocks", "hastened", "hastiest", "hatbands",
    "hatboxes", "hatchery", "hatchets", "hatching", "hatchway",
    "hatstand", "hauliers", "haunched", "haunches", "haunting",
    "hawthorn", "haycocks", "haylofts", "hayricks", "hayrides",
    "hayseeds", "haystack", "hazarded", "hazelnut", "haziness",
    "headache", "headband", "headbutt", "headcase", "headgear",
    "headhunt", "headiest", "headings", "headlamp", "headland",
    "headless", "headline", "headlock", "headlong", "headrest",
    "headroom", "headsets", "headship", "headwind", "headword",
    "hearings", "hearkens", "hearsing", "heartens", "heartier",
    "hearties", "heartily", "hearting", "heatedly", "heathens",
    "heatwave", "heavenly", "heaviest", "heavyset", "hecklers",
    "heckling", "hectares", "hectored", "hedgehog", "hedgerow",
    "hedonism", "hedonist", "heedless", "heehawed", "heftiest",
    "hegemony", "heighten", "heirloom", "heisting", "helipads",
    "heliport", "hellhole", "hellions", "helmeted", "helmsman",
    "helmsmen", "helpings", "helpless", "helpline", "helpmate",
    "hemlines", "hemlocks", "henchman", "henchmen", "hennaing",
    "henpecks", "hepatics", "heptagon", "heralded", "heraldic",
    "heraldry", "herdsman", "herdsmen", "heredity", "heresies",
    "heretics", "hereupon", "herewith", "heritage", "hermetic",
    "heroines", "herrings", "hesitant", "hesitate", "hexagons",
    "hiatuses", "hibachis", "hibiscus", "hideaway", "hideouts",
    "highball", "highborn", "highboys", "highbrow", "highland",
    "highness", "hightail", "highways", "hijacked", "hijacker",
    "hilarity", "hilliest", "hillocks", "hillside", "hilltops",
    "hindered", "hindmost", "hipbaths", "hippiest", "hipsters",
    "hireling", "historic", "hitching", "hitherto", "hoarders",
    "hoarding", "hoariest", "hoarsely", "hoarsest", "hobbling",
    "hobbyist", "hobnails", "hockshop", "hoedowns", "hogshead",
    "hoicking", "hoisting", "holdalls", "holdings", "holdouts",
    "holdover", "holidays", "holiness", "holistic", "hollered",
    "hollowed", "hollower", "hollowly", "hologram", "holsters",
    "homaging", "homburgs", "homebody", "homeboys", "homeland",
    "homeless", "homelier", "homemade", "homepage", "homering",
    "homeroom", "homesick", "homespun", "hometown", "homeward",
    "homework", "homicide", "homilies", "homonyms", "honester",
    "honestly", "honeybee", "honeydew", "honeying", "honeypot",
    "honorary", "hoodlums", "hoodooed", "hoodwink", "hookiest",
    "hookworm", "hooligan", "hoorayed", "hoovered", "hopefuls",
    "hopeless", "horizons", "hormonal", "hormones", "horniest",
    "hornless", "hornpipe", "horology", "horrible", "horribly",
    "horridly", "horrific", "horsebox", "horsefly", "horseman",
    "horsemen", "horsiest", "hosannas", "hosepipe", "hospices",
    "hospital", "hostages", "hosteled", "hosteler", "hostelry",
    "hostiles", "hostlers", "hotcakes", "hotelier", "hotfoots",
    "hotheads", "hothouse", "hotplate", "hotshots", "hounding",
    "hourlies", "houseboy", "housefly", "houseful", "houseman",
    "housemen", "housetop", "housings", "hovering", "howdying",
    "howitzer", "huckster", "huddling", "huffiest", "hugeness",
    "humanely", "humanest", "humanism", "humanist", "humanity",
    "humanoid", "humblest", "humbling", "humidify", "humidity",
    "humidors", "humility", "hummocks", "humorist", "humorous",
    "humpback", "hunching", "hundreds", "hungered", "hungover",
    "hungrier", "hungrily", "hunkered", "hunkiest", "huntress",
    "huntsman", "huntsmen", "hurdlers", "hurdling", "hurrying",
    "hurtling", "husbands", "huskiest", "hustings", "hustlers",
    "hustling", "hutching", "hyacinth", "hydrants", "hydrated",
    "hydrates", "hydrogen", "hygienic", "hyphened", "hypnoses",
    "hypnosis", "hypnotic", "hysteria", "hysteric", "icebergs",
    "icebound", "iceboxes", "idealism", "idealist", "identify",
    "identity", "ideogram", "ideology", "idiocies", "idleness",
    "idolater", "idolatry", "igniting", "ignition", "ignominy",
    "ignorant", "ignoring", "illegals", "illumine", "illusion",
    "illusive", "illusory", "imagined", "imagines", "imbecile",
    "imbibing", "imitated", "imitates", "imitator", "immanent",
    "immature", "immenser", "immersed", "immerses", "imminent",
    "immobile", "immodest", "immolate", "immortal", "immunity",
    "immuring", "impacted", "impaired", "impaling", "impanels",
    "imparted", "impasses", "impeding", "impelled", "impended",
    "imperial", "imperils", "impetigo", "impinged", "impinges",
    "impishly", "implants", "implicit", "imploded", "implodes",
    "implored", "implores", "implying", "impolite", "imported",
    "importer", "imposing", "impostor", "impotent", "impounds",
    "imprints", "imprison", "improper", "improved", "improves",
    "impudent", "impugned", "impulsed", "impulses", "impunity",
    "impurely", "impurest", "impurity", "imputing", "inaction",
    "inactive", "inasmuch", "inboards", "inbounds", "inbreeds",
    "incensed", "incenses", "inchoate", "incident", "incising",
    "incision", "incisive", "incisors", "inciting", "inclined",
    "inclines", "included", "includes", "incomers", "incoming",
    "increase", "incubate", "incurred", "indebted", "indecent",
    "indented", "indexing", "indicate", "indicted", "indigent",
    "indirect", "indolent", "inducing", "inducted", "inductee",
    "indulged", "indulges", "industry", "inedible", "inequity",
    "inertial", "inexpert", "infamies", "infamous", "infantry",
    "infected", "inferior", "infernal", "infernos", "inferred",
    "infested", "infidels", "infields", "infilled", "infinite",
    "infinity", "inflamed", "inflames", "inflated", "inflates",
    "inflects", "inflicts", "influxes", "informal", "informed",
    "informer", "infrared", "infringe", "infusing", "infusion",
    "ingested", "ingrains", "ingrates", "inhabits", "inhalant",
    "inhalers", "inhaling", "inherent", "inhering", "inherits",
    "inhibits", "inhumane", "inimical", "iniquity", "initials",
    "initiate", "injected", "injector", "injuries", "injuring",
    "inkblots", "inkiness", "inklings", "inkstand", "inkwells",
    "inlaying", "innately", "innocent", "innovate", "innuendo",
    "inputted", "inquests", "inquirer", "insanely", "insanest",
    "insanity", "inscribe", "insecure", "inserted", "insiders",
    "insights", "insignia", "insisted", "insolent", "insomnia",
    "inspects", "inspired", "inspires", "installs", "instance",
    "instants", "instills", "instinct", "instruct", "insulate",
    "insulted", "insureds", "insurers", "insuring", "intaglio",
    "integers", "integral", "intended", "intenser", "intently",
    "interact", "intercom", "interest", "interior", "internal",
    "interned", "internee", "interred", "interval", "interwar",
    "intimacy", "intimate", "intoning", "intranet", "intrepid",
    "intrigue", "intruded", "intruder", "intrudes", "intuited",
    "inundate", "invaders", "invading", "invalids", "invasion",
    "invasive", "inveighs", "inveigle", "invented", "inventor",
    "inverses", "inverted", "invested", "investor", "inviting",
    "invoiced", "invoices", "invoking", "involved", "involves",
    "inwardly", "ironclad", "ironical", "ironware", "ironwork",
    "irrigate", "irritant", "irritate", "islander", "isolated",
    "isolates", "isotherm", "isotopes", "isotopic", "issuance",
    "itchiest", "iterated", "iterates", "iterator", "jabbered",
    "jabberer", "jackboot", "jackdaws", "jackpots", "jaggeder",
    "jaggedly", "jailbird", "jalopies", "jalousie", "jamboree",
    "jammiest", "jangling", "janitors", "japanned", "jasmines",
    "jaundice", "jauntier", "jaunties", "jauntily", "jaunting",
    "javelins", "jawboned", "jawbones", "jawlines", "jaywalks",
    "jazziest", "jealousy", "jellying", "jemmying", "jeopardy",
    "jeremiad", "jerkiest", "jeroboam", "jerrycan", "jetliner",
    "jettison", "jiggered", "jiggling", "jigsawed", "jimmying",
    "jingling", "jingoism", "jingoist", "jobshare", "jockeyed",
    "jocosely", "jocosity", "jocundly", "jodhpurs", "joggling",
    "johnnies", "jointing", "jokingly", "jolliest", "jollying",
    "jonquils", "jostling", "jottings", "jouncing", "journals",
    "journeys", "jousting", "jovially", "joyfully", "joyously",
    "joyrider", "joyrides", "joystick", "jubilant", "jubilees",
    "juddered", "judicial", "jugglers", "juggling", "jugulars",
    "juiciest", "julienne", "jumbling", "jumpiest", "jumpsuit",
    "junction", "juncture", "junipers", "junketed", "junkiest",
    "junkyard", "justices", "justness", "juvenile", "kamikaze",
    "kangaroo", "karaokes", "katydids", "kayaking", "kedgeree",
    "keelhaul", "keenness", "keepsake", "kerbside", "kerchief",
    "kerosene", "kestrels", "keyboard", "keyholes", "keynoted",
    "keynotes", "keypunch", "keystone", "keywords", "kibitzed",
    "kibitzer", "kibitzes", "kickback", "kickiest", "kickoffs",
    "kiddying", "kielbasa", "killdeer", "killings", "killjoys",
    "kilobyte", "kilotons", "kilowatt", "kindlier", "kindling",
    "kindness", "kinetics", "kinfolks", "kingdoms", "kinglier",
    "kingpins", "kingship", "kinkiest", "kinsfolk", "kippered",
    "kirsches", "kitchens", "klutzier", "knackers", "knacking",
    "knapsack", "kneaders", "kneading", "kneecaps", "kneeling",
    "knelling", "knickers", "knighted", "knightly", "knitters",
    "knitting", "knitwear", "knobbier", "knockers", "knocking",
    "knockoff", "knockout", "knothole", "knottier", "knotting",
    "knowable", "knowings", "knuckled", "knuckles", "kohlrabi",
    "kookiest", "koshered", "kowtowed", "kumquats", "kvetched",
    "kvetches", "laburnum", "lacerate", "lacquers", "lacrosse",
    "lactated", "lactates", "laddered", "ladybird", "ladybugs",
    "ladylike", "ladyship", "laggards", "lakeside", "lamasery",
    "lambadas", "lambaste", "lambkins", "lambskin", "lameness",
    "lamented", "laminate", "lampoons", "lamppost", "lampreys",
    "landfall", "landfill", "landings", "landlady", "landless",
    "landlord", "landmark", "landmass", "landmine", "landslid",
    "landslip", "landward", "language", "languish", "languors",
    "lankiest", "lanterns", "lanyards", "lapidary", "lapwings",
    "larboard", "lariated", "larkspur", "larynges", "lasagnas",
    "lashings", "lassoing", "latching", "latchkey", "lateness",
    "laterals", "lathered", "latitude", "latrines", "latterly",
    "latticed", "lattices", "laudable", "laudably", "laudanum",
    "laughing", "laughter", "launched", "launcher", "launches",
    "launders", "laureate", "lavatory", "lavender", "lavished",
    "lavisher", "lavishes", "lavishly", "lawfully", "lawgiver",
    "lawmaker", "lawsuits", "laxative", "layabout", "layering",
    "layettes", "layovers", "laywoman", "laywomen", "laziness",
    "leaching", "leafiest", "leafless", "leaflets", "leaguing",
    "leakages", "leakiest", "leanings", "leanness", "leapfrog",
    "learners", "learning", "leashing", "leathers", "leathery",
    "leavened", "leavings", "lecithin", "lecterns", "lectured",
    "lecturer", "lectures", "ledgered", "leeching", "leeriest",
    "leewards", "leftists", "leftmost", "leftover", "leftward",
    "legacies", "legalese", "legalism", "legality", "legatees",
    "legating", "legation", "leggiest", "leggings", "legrooms",
    "leisured", "lemmings", "lemonade", "lemoning", "lengthen",
    "leniency", "lenients", "leopards", "leotards", "lesbians",
    "lessened", "letdowns", "lethally", "lethargy", "lettered",
    "lettings", "lettuces", "leverage", "levering", "levitate",
    "lewdness", "lexicons", "liaising", "liaisons", "libation",
    "liberals", "liberate", "libretto", "licensee", "lickings",
    "licorice", "lifebelt", "lifeboat", "lifeless", "lifelike",
    "lifeline", "lifelong", "lifespan", "lifetime", "lifework",
    "liftoffs", "ligament", "ligature", "lightens", "lighters",
    "lightest", "lighting", "likelier", "likeness", "likening",
    "likewise", "limbered", "limberer", "limbless", "limboing",
    "limeades", "limerick", "limiting", "limpidly", "limpness",
    "linchpin", "lineages", "lineally", "linearly", "linefeed",
    "linesman", "linesmen", "lingered", "lingerer", "lingerie",
    "linguist", "liniment", "linkages", "linoleum", "lipreads",
    "lipstick", "liqueurs", "liquored", "listened", "listener",
    "listeria", "listings", "listless", "litanies", "literacy",
    "literals", "literary", "literate", "literati", "litigant",
    "litigate", "littered", "littlest", "littoral", "livelier",
    "livelong", "livening", "liveried", "liveries", "liverish",
    "loadable", "loamiest", "loanword", "loathing", "lobbying",
    "lobbyist", "lobotomy", "lobsters", "localing", "locality",
    "locating", "location", "lockable", "lockouts", "lockstep",
    "locoweed", "locution", "lodestar", "lodgings", "loftiest",
    "logbooks", "logician", "logistic", "logotype", "loitered",
    "loiterer", "lollipop", "lolloped", "lonelier", "lonesome",
    "longboat", "longbows", "longhair", "longhand", "longhorn",
    "longings", "longtime", "longueur", "longways", "lookouts",
    "looniest", "loophole", "loopiest", "loosened", "lopsided",
    "lordlier", "lordship", "loudlier", "loudness", "loungers",
    "lounging", "lousiest", "lovebird", "loveless", "lovelier",
    "lovelies", "lovelorn", "lovesick", "lovingly", "lowbrows",
    "lowering", "lowlands", "lowliest", "loyalest", "loyalist",
    "lozenges", "lucidity", "luckiest", "luckless", "lugholes",
    "lukewarm", "lumbered", "luminary", "luminous", "lummoxes",
    "lumpiest", "lunacies", "lunatics", "lunchbox", "luncheon",
    "lunching", "lungfuls", "lurching", "luscious", "lushness",
    "lustiest", "lustrous", "luxuries", "lychgate", "lymphoma",
    "lynching", "lyrebird", "lyricism", "lyricist", "macaroni",
    "macaroon", "macerate", "machetes", "machined", "machines",
    "machismo", "mackerel", "mackinaw", "maddened", "madhouse",
    "madrases", "madrigal", "madwoman", "madwomen", "maestros",
    "magazine", "magician", "magicked", "magnates", "magnesia",
    "magnetic", "magnetos", "magnolia", "maharani", "mahatmas",
    "mahogany", "maidenly", "mailbags", "mailings", "mailshot",
    "mainland", "mainline", "mainmast", "mainsail", "mainstay",
    "maintain", "majestic", "majoring", "majority", "makeover",
    "maladies", "malarial", "malarkey", "maleness", "malicing",
    "maligned", "malinger", "mallards", "maltreat", "mamboing",
    "mammoths", "manacled", "manacles", "managers", "managing",
    "manatees", "mandalas", "mandarin", "mandated", "mandates",
    "mandible", "mandolin", "mandrake", "mandrill", "manfully",
    "mangiest", "mangling", "mangrove", "manholes", "manhunts",
    "maniacal", "manicure", "manifest", "manifold", "manikins",
    "manliest", "mannered", "mannerly", "manorial", "manpower",
    "mansards", "mansions", "mantilla", "mantises", "mantissa",
    "mantling", "manually", "manumits", "manuring", "mappings",
    "marabous", "marathon", "marauded", "marauder", "marbling",
    "marchers", "marching", "marginal", "mariachi", "marigold",
    "marimbas", "marinade", "marinate", "mariners", "maritime",
    "marjoram", "markdown", "markedly", "marketed", "marketer",
    "markings", "marksman", "marksmen", "marmoset", "marooned",
    "marquees", "marquess", "marquise", "marriage", "marrieds",
    "marrowed", "marrying", "marshals", "marshier", "martinet",
    "martinis", "martyred", "marzipan", "mascaras", "massacre",
    "massaged", "massages", "masseurs", "masseuse", "mastered",
    "masterly", "masthead", "mastiffs", "mastitis", "mastodon",
    "mastoids", "matadors", "matchbox", "matching", "material",
    "maternal", "matrices", "matronly", "mattered", "mattocks",
    "mattress", "maturely", "maturest", "maturing", "maturity",
    "maunders", "maverick", "maxillae", "maximals", "maximums",
    "mayflies", "mayoress", "maypoles", "meagerly", "mealiest",
    "mealtime", "meanders", "meanings", "meanness", "meantime",
    "measlier", "measured", "measures", "meatball", "meatiest",
    "meatloaf", "mechanic", "meddlers", "meddling", "mediated",
    "mediates", "mediator", "medicals", "medicate", "medicine",
    "medieval", "mediocre", "meditate", "medullas", "meekness",
    "meetings", "megabyte", "megalith", "megastar", "megatons",
    "megawatt", "melamine", "melanges", "melanoma", "mellowed",
    "mellower", "melodics", "melodies", "meltdown", "membrane",
    "mementos", "memorial", "memories", "memsahib", "menacing",
    "menhaden", "menially", "menorahs", "menswear", "mentally",
    "mentions", "mentored", "merchant", "merciful", "mercuric",
    "meridian", "meringue", "meriting", "mermaids", "merriest",
    "mescalin", "mesdames", "mesmeric", "mesquite", "messaged",
    "messages", "messiahs", "messiest", "mestizos", "metallic",
    "metaphor", "meteoric", "methanol", "methinks", "metrical",
    "microbes", "middling", "midfield", "midlands", "midmosts",
    "midnight", "midpoint", "midriffs", "midsized", "midterms",
    "midweeks", "midwifed", "midwifes", "midwives", "midyears",
    "mightier", "mightily", "migraine", "migrants", "migrated",
    "migrates", "mildewed", "mildness", "mileages", "milepost",
    "militant", "military", "militate", "militias", "milkiest",
    "milkmaid", "milksops", "milkweed", "millibar", "milliner",
    "millions", "millpond", "millrace", "mimicked", "minarets",
    "minatory", "mindless", "mindsets", "minerals", "mingling",
    "minibars", "minibike", "minicabs", "minicams", "minimals",
    "minimums", "minister", "ministry", "minivans", "minoring",
    "minority", "minsters", "minstrel", "mintiest", "minuends",
    "minutely", "minutest", "minutiae", "minuting", "miracles",
    "mirrored", "mirthful", "misapply", "miscalls", "miscarry",
    "miscasts", "mischief", "miscount", "miscuing", "misdeals",
    "misdealt", "misdeeds", "misdoing", "miseries", "misfired",
    "misfires", "misguide", "misheard", "mishears", "mishmash",
    "misjudge", "misleads", "mismatch", "misnamed", "misnames",
    "misnomer", "misogyny", "misplace", "misplays", "misprint",
    "misquote", "misreads", "misruled", "misrules", "missiles",
    "missions", "missives", "misspell", "misspend", "misspent",
    "misstate", "missteps", "mistaken", "mistakes", "mistiest",
    "mistimed", "mistimes", "mistreat", "mistress", "mistrial",
    "mistrust", "mistypes", "misusing", "mitigate", "mixtures",
    "mnemonic", "mobility", "mobsters", "moccasin", "moderate",
    "moderner", "modester", "modestly", "modicums", "modified",
    "modifier", "modifies", "modishly", "modulate", "moieties",
    "moistens", "moistest", "moisture", "molasses", "moldered",
    "molecule", "molehill", "moleskin", "molested", "molester",
    "mollusks", "momentum", "monarchs", "monarchy", "monastic",
    "monaural", "monetary", "moneybag", "moneybox", "mongered",
    "mongoose", "mongrels", "monikers", "monitors", "monkeyed",
    "monocles", "monogamy", "monogram", "monolith", "monopoly",
    "monorail", "monotone", "monotony", "monoxide", "monsieur",
    "monsoons", "monsters", "montages", "monument", "moochers",
    "mooching", "moodiest", "moonbeam", "moonless", "moonshot",
    "moorhens", "moorings", "moorland", "moraines", "moralist",
    "morality", "moralled", "morasses", "morbidly", "mordants",
    "moreover", "moribund", "mornings", "morosely", "morpheme",
    "morphine", "morphing", "mortally", "mortared", "mortgage",
    "mortised", "mortises", "mortuary", "moseying", "mosquito",
    "mossiest", "mothball", "mothered", "motherly", "motioned",
    "motivate", "motliest", "motorcar", "motoring", "motorist",
    "motorman", "motormen", "motorway", "mottling", "moulders",
    "moulting", "mounding", "mountain", "mounting", "mourners",
    "mournful", "mourning", "mousiest", "moussaka", "moussing",
    "mouthful", "mouthing", "movables", "movement", "movingly",
    "mucilage", "muckiest", "muckrake", "muddiest", "muddling",
    "muddying", "mudflaps", "mudflats", "mudguard", "mudpacks",
    "mudslide", "muezzins", "mufflers", "muffling", "muggiest",
    "muggings", "mulberry", "mulching", "muleteer", "mulishly",
    "mullions", "multiple", "multiply", "mumblers", "mumbling",
    "munchies", "munching", "mundanes", "munition", "muralist",
    "murdered", "murderer", "murkiest", "murmured", "muscatel",
    "muscling", "muscular", "mushiest", "mushroom", "musicale",
    "musicals", "musician", "musicked", "musketry", "muskiest",
    "muskrats", "mussiest", "mustangs", "mustered", "mustiest",
    "mutating", "mutation", "muteness", "mutilate", "mutineer",
    "mutinied", "mutinies", "mutinous", "muttered", "mutually",
    "muzzling", "mycology", "mystical", "mystique", "mythical",
    "nakedest", "nameless", "namesake", "nannying", "napalmed",
    "nappiest", "narcosis", "narcotic", "narrated", "narrates",
    "narrator", "narrowed", "narrower", "narrowly", "narwhals",
    "nastiest", "national", "nativity", "nattered", "nattiest",
    "naturals", "naturing", "naturism", "naturist", "nauseate",
    "nauseous", "nautical", "nautilus", "navigate", "naysayer",
    "nearlier", "nearness", "nearside", "neatened", "neatness",
    "nebulous", "neckband", "necklace", "neckline", "neckties",
    "necrosis", "needfuls", "neediest", "needless", "needling",
    "negating", "negation", "negative", "neglects", "negligee",
    "neighing", "nematode", "neonatal", "neonates", "neophyte",
    "neoprene", "nepotism", "nerdiest", "nerviest", "nestling",
    "nettling", "networks", "neuritis", "neurones", "neuroses",
    "neurosis", "neurotic", "neutered", "neutrals", "neutrino",
    "neutrons", "newborns", "newcomer", "newlywed", "newsboys",
    "newscast", "newsiest", "newsreel", "newsroom", "nibblers",
    "nibbling", "niceness", "niceties", "nickname", "nicotine",
    "niftiest", "niggards", "niggling", "nightcap", "nighties",
    "nihilism", "nihilist", "nimblest", "ninepins", "nineteen",
    "nineties", "nippered", "nippiest", "nippling", "nitpicks",
    "nitrated", "nitrates", "nitrogen", "nobbling", "nobility",
    "nobleman", "noblemen", "nobodies", "nocturne", "noisiest",
    "nominate", "nominees", "nondairy", "nonempty", "nonesuch",
    "nonevent", "nonfatal", "nonhuman", "nonrigid", "nonsense",
    "nonstick", "nontoxic", "nonunion", "nonusers", "nonwhite",
    "noodling", "noontime", "normalcy", "normally", "northern",
    "nosebags", "nosedive", "nosegays", "nosiness", "nostrils",
    "nostrums", "notables", "notaries", "notation", "notching",
    "notebook", "notelets", "notepads", "nothings", "noticing",
    "notified", "notifies", "notional", "novelist", "novellas",
    "nowadays", "nugatory", "nuisance", "numbered", "numbness",
    "numeracy", "numerals", "numerate", "numerous", "numinous",
    "numskull", "nuptials", "nurtured", "nurtures", "nutcases",
    "nuthatch", "nuthouse", "nutmeats", "nutrient", "nutshell",
    "nuttiest", "nuzzling", "nymphets", "oarlocks", "oatcakes",
    "obduracy", "obdurate", "obedient", "obeisant", "obelisks",
    "obituary", "objected", "objector", "oblation", "obligate",
    "obliging", "obliques", "oblivion", "obscener", "obscured",
    "obscurer", "obscures", "observed", "observer", "observes",
    "obsessed", "obsesses", "obsidian", "obsolete", "obstacle",
    "obstruct", "obtained", "obtruded", "obtrudes", "obtusely",
    "obtusest", "obverses", "obviated", "obviates", "ocarinas",
    "occasion", "occluded", "occludes", "occupant", "occupied",
    "occupier", "occupies", "occurred", "octagons", "oculists",
    "oddballs", "oddities", "oddments", "odiously", "odometer",
    "odysseys", "offbeats", "offended", "offender", "offering",
    "officers", "official", "offloads", "offshoot", "offshore",
    "offsides", "offstage", "oftenest", "oilcloth", "oilfield",
    "oiliness", "oilskins", "ointment", "oldening", "oleander",
    "oligarch", "omission", "omitting", "omnivore", "oncology",
    "oncoming", "ongoings", "onioning", "onlooker", "onrushes",
    "ontology", "opaquely", "opaquest", "opaquing", "opencast",
    "openings", "openness", "openwork", "operable", "operands",
    "operated", "operates", "operatic", "operator", "operetta",
    "opinions", "opossums", "opponent", "opposing", "opposite",
    "optician", "optimism", "optimist", "optimums", "optional",
    "optioned", "opulence", "oracling", "oracular", "orangery",
    "orations", "oratorio", "orbitals", "orbiting", "orchards",
    "ordained", "ordering", "ordinals", "ordinary", "ordnance",
    "organics", "organism", "organist", "orgasmic", "oriental",
    "oriented", "orifices", "original", "ornament", "ornately",
    "ornerier", "orphaned", "orthodox", "ossified", "ossifies",
    "ottering", "ottomans", "outbacks", "outboard", "outbound",
    "outbreak", "outbroke", "outburst", "outcasts", "outclass",
    "outcomes", "outcries", "outcrops", "outdated", "outdoing",
    "outdoors", "outfaced", "outfaces", "outfalls", "outfield",
    "outflank", "outflows", "outfoxed", "outfoxes", "outgoing",
    "outgrown", "outgrows", "outguess", "outhouse", "outlasts",
    "outlawed", "outlined", "outlines", "outlived", "outlives",
    "outlooks", "outlying", "outmoded", "outpaced", "outpaces",
    "outplays", "outpoint", "outposts", "outraged", "outrages",
    "outranks", "outreach", "outrider", "outright", "outsells",
    "outshine", "outshone", "outsider", "outsides", "outsizes",
    "outskirt", "outsmart", "outstays", "outstrip", "outtakes",
    "outvoted", "outvotes", "outwards", "outwears", "outweigh",
    "ovations", "ovenware", "overacts", "overages", "overalls",
    "overawed", "overawes", "overbear", "overbids", "overbite",
    "overbook", "overbore", "overcame", "overcast", "overcoat",
    "overcome", "overcook", "overdoes", "overdone", "overdose",
    "overdraw", "overdrew", "overeats", "overflew", "overflow",
    "overfull", "overgrew", "overgrow", "overhand", "overhang",
    "overhaul", "overhead", "overhear", "overheat", "overhung",
    "overjoys", "overkill", "overlaid", "overlain", "overland",
    "overlaps", "overlays", "overleaf", "overlies", "overload",
    "overlong", "overlook", "overlord", "overmuch", "overpaid",
    "overpass", "overpays", "overplay", "overrate", "override",
    "overripe", "overrode", "overrule", "overruns", "overseas",
    "overseen", "overseer", "oversees", "oversell", "overshoe",
    "overshot", "oversize", "oversold", "overstay", "overstep",
    "overtake", "overtime", "overtire", "overtone", "overtook",
    "overture", "overturn", "overused", "overuses", "overview",
    "overwork", "oviducts", "ovulated", "ovulates", "owlishly",
    "oxymoron", "pacified", "pacifier", "pacifies", "pacifism",
    "pacifist", "packaged", "packages", "paddling", "paddocks",
    "padlocks", "paganism", "pageants", "pageboys", "paginate",
    "pailfuls", "painless", "paintbox", "painters", "painting",
    "pairings", "pairwise", "paisleys", "palatals", "palatial",
    "palavers", "paleface", "paleness", "palettes", "palimony",
    "palisade", "palliate", "palmetto", "palmiest", "palmists",
    "palmtops", "palomino", "palpable", "palpably", "palpated",
    "palpates", "palsying", "paltrier", "pampered", "pamphlet",
    "panaceas", "pancaked", "pancakes", "pancreas", "pandemic",
    "pandered", "panderer", "panelist", "panicked", "panniers",
    "panorama", "panpipes", "pantheon", "panthers", "pantries",
    "pantsuit", "papacies", "paperboy", "papering", "papillae",
    "papooses", "parabled", "parables", "parabola", "paradigm",
    "parading", "paradise", "paraffin", "paragons", "parakeet",
    "parallax", "parallel", "paramour", "paranoia", "paranoid",
    "parapets", "paraquat", "parasite", "parasols", "parboils",
    "parching", "pardners", "pardoned", "parental", "parented",
    "parfaits", "parishes", "parities", "parkland", "parkways",
    "parlance", "parlayed", "parleyed", "parodied", "parodies",
    "parodist", "parolees", "paroling", "paroxysm", "parquets",
    "parroted", "parrying", "parsnips", "partaken", "partaker",
    "partakes", "parterre", "partials", "particle", "partings",
    "partisan", "partners", "partying", "parvenus", "passable",
    "passably", "passages", "passbook", "passerby", "passions",
    "passives", "passkeys", "passport", "password", "pasterns",
    "pastiche", "pastiest", "pastille", "pastimes", "pastoral",
    "pastrami", "pastries", "pastured", "pastures", "patchier",
    "patchily", "patching", "patellae", "patellas", "patented",
    "patently", "paternal", "pathetic", "pathogen", "pathways",
    "patience", "patients", "patriots", "pattered", "patterns",
    "paunched", "paunches", "pavement", "pavilion", "pavlovas",
    "pawnshop", "paybacks", "paycheck", "payloads", "payments",
    "payphone", "payrolls", "payslips", "peaceful", "peacocks",
    "peafowls", "pearlier", "pearling", "peasants", "pebblier",
    "pebbling", "pectoral", "peculiar", "pedagogy", "pedantic",
    "pedantry", "peddlers", "peddling", "pederast", "pedestal",
    "pedicure", "pedigree", "pediment", "peekaboo", "peelings",
    "peephole", "peepshow", "peerages", "peerless", "pelicans",
    "pellagra", "pelleted", "pellucid", "pelvises", "penanced",
    "penances", "penchant", "pendants", "pendents", "pendulum",
    "penguins", "penitent", "penknife", "penlight", "pennants",
    "penology", "pensions", "pentagon", "penumbra", "peopling",
    "peppered", "peppiest", "percales", "perceive", "percents",
    "perching", "perfects", "perforce", "performs", "perfumed",
    "perfumes", "pergolas", "perigees", "perilous", "periodic",
    "perished", "perisher", "perishes", "periwigs", "perjured",
    "perjurer", "perjures", "perkiest", "permeate", "permuted",
    "permutes", "peroxide", "persists", "personae", "personal",
    "perspire", "persuade", "pertains", "pertness", "perturbs",
    "perusals", "perusing", "pervaded", "pervades", "perverse",
    "perverts", "peskiest", "pestered", "pestling", "petering",
    "petioles", "petition", "pettiest", "pettifog", "petulant",
    "petunias", "pfennigs", "phantasm", "phantoms", "pharaohs",
    "pharmacy", "pheasant", "phialled", "philters", "philtres",
    "phonemes", "phonemic", "phonetic", "phoniest", "phonying",
    "phosphor", "photoing", "phrasing", "physical", "physique",
    "pianists", "pianolas", "picadors", "picayune", "piccolos",
    "pickaxed", "pickaxes", "pickerel", "picketed", "picketer",
    "pickiest", "pickings", "pickling", "pictured", "pictures",
    "piddling", "piebalds", "piercing", "piffling", "pigeoned",
    "piggiest", "pigments", "pigskins", "pigsties", "pigswill",
    "pigtails", "pilaster", "pilchard", "pilfered", "pilferer",
    "pilgrims", "pillaged", "pillages", "pillared", "pillions",
    "pillocks", "pillowed", "piloting", "pimentos", "pimiento",
    "pimplier", "pinafore", "pinching", "pinewood", "pinheads",
    "pinholes", "pinioned", "pinkness", "pinnacle", "pinochle",
    "pinpoint", "pinprick", "pinwheel", "pioneers", "pipeline",
    "pipettes", "pipework", "piquancy", "piranhas", "pirating",
    "pissoirs", "pitchers", "pitching", "pitchman", "pitchmen",
    "pitfalls", "pitheads", "pithiest", "pitiable", "pitiably",
    "pitiless", "pittance", "pivoting", "pizzeria", "placards",
    "placated", "placates", "placebos", "placenta", "placidly",
    "placings", "plackets", "plaguing", "plaiding", "plainest",
    "plaiting", "plangent", "planking", "plankton", "planners",
    "planning", "plantain", "planters", "planting", "plasters",
    "plastics", "plateaus", "plateful", "platelet", "platform",
    "platinum", "platonic", "platoons", "platters", "platypus",
    "plaudits", "playable", "playacts", "playback", "playbill",
    "playboys", "playgoer", "playmate", "playoffs", "playpens",
    "playroom", "playtime", "pleaders", "pleading", "pleasant",
    "pleasing", "pleasure", "pleating", "plebeian", "plectrum",
    "pledging", "plethora", "pleurisy", "plexuses", "pliantly",
    "plighted", "plimsoll", "plodders", "plodding", "plonkers",
    "plonking", "plopping", "plosives", "plotters", "plotting",
    "pluckier", "plucking", "plugging", "plughole", "plumbers",
    "plumbing", "plummets", "plumpest", "plumping", "plunders",
    "plungers", "plunging", "plunking", "plushest", "plushier",
    "plussing", "poachers", "poaching", "pocketed", "pockmark",
    "podiatry", "poesying", "poetical", "pogromed", "poignant",
    "pointers", "pointier", "pointing", "poisoned", "poisoner",
    "polarity", "poleaxed", "poleaxes", "polecats", "polemics",
    "polestar", "policies", "policing", "polished", "polisher",
    "polishes", "politely", "politest", "politico", "politics",
    "polities", "polkaing", "pollards", "polliwog", "pollster",
    "polluted", "polluter", "pollutes", "polonium", "poltroon",
    "polygamy", "polyglot", "polygons", "polymath", "polymers",
    "pomading", "pomander", "pondered", "poniards", "pontiffs",
    "pontoons", "ponytail", "pooching", "poofters", "poolside",
    "popinjay", "popovers", "poppadom", "populace", "populars",
    "populate", "populism", "populist", "populous", "porosity",
    "porphyry", "porpoise", "porridge", "portable", "portaged",
    "portages", "portends", "portents", "portered", "porthole",
    "portions", "portlier", "portrait", "portrays", "positing",
    "position", "positive", "positron", "possible", "possibly",
    "postbags", "postcard", "postcode", "postdate", "postdocs",
    "postings", "postlude", "postmark", "postpaid", "postpone",
    "postural", "postured", "postures", "potables", "potatoes",
    "potbelly", "potently", "potheads", "potholed", "potholer",
    "potholes", "pothooks", "potlucks", "potsherd", "potshots",
    "pottered", "pottiest", "pouching", "poultice", "pouncing",
    "poundage", "pounding", "powdered", "powerful", "powering",
    "powwowed", "prairies", "praising", "pralines", "prancers",
    "prancing", "pranging", "pratfall", "prattled", "prattler",
    "prattles", "prawning", "preached", "preacher", "preaches",
    "preamble", "preceded", "precedes", "precepts", "precinct",
    "precious", "preciser", "precises", "preclude", "precooks",
    "predated", "predates", "predator", "predicts", "preemies",
    "preempts", "preening", "preexist", "prefaced", "prefaces",
    "prefects", "prefixed", "prefixes", "pregnant", "preheats",
    "prejudge", "prelates", "preludes", "premiere", "premiers",
    "premised", "premises", "premiums", "prenatal", "prepared",
    "prepares", "preppier", "preppies", "prepping", "prequels",
    "presaged", "presages", "presence", "presents", "preserve",
    "presided", "presides", "pressies", "pressing", "pressman",
    "pressmen", "pressure", "prestige", "presumed", "presumes",
    "preteens", "pretends", "preterit", "pretexts", "prettied",
    "prettier", "pretties", "prettify", "prettily", "pretzels",
    "prevails", "prevents", "previews", "previous", "prezzies",
    "priciest", "pricking", "prickled", "prickles", "priestly",
    "priggish", "primates", "primeval", "primmest", "primness",
    "primping", "primrose", "primulas", "princely", "princess",
    "printers", "printing", "printout", "prioress", "priories",
    "priority", "prisoned", "prisoner", "prissier", "prissies",
    "prissily", "pristine", "prithees", "privater", "privates",
    "priviest", "probable", "probably", "probated", "probates",
    "probings", "problems", "proceeds", "proclaim", "proctors",
    "procured", "procurer", "procures", "prodding", "prodigal",
    "produced", "producer", "produces", "products", "profaned",
    "profanes", "proffers", "profiled", "profiles", "profited",
    "proforma", "profound", "progress", "prohibit", "projects",
    "prolapse", "prolific", "prologue", "prolongs", "promised",
    "promises", "promoted", "promoter", "promotes", "prompted",
    "prompter", "promptly", "pronouns", "proofing", "properer",
    "properly", "property", "prophecy", "prophesy", "prophets",
    "proposal", "proposed", "proposer", "proposes", "propound",
    "propping", "prorated", "prorates", "prosiest", "prospect",
    "prospers", "prostate", "proteans", "protects", "proteins",
    "protests", "protocol", "protozoa", "protract", "protrude",
    "proudest", "provable", "provably", "proverbs", "provided",
    "provider", "provides", "province", "provisos", "provoked",
    "provokes", "provosts", "prowlers", "prowling", "prudence",
    "prurient", "psalmist", "psychics", "psyching", "ptomaine",
    "publican", "publicly", "puckered", "puddings", "puddling",
    "pudendum", "pudgiest", "puffball", "puffiest", "pugilism",
    "pugilist", "pullback", "pullouts", "pullover", "pulpiest",
    "pulsated", "pulsates", "pumpkins", "punchbag", "punchier",
    "punching", "punctual", "puncture", "pungency", "punished",
    "punishes", "punitive", "punsters", "pupating", "puppetry",
    "puppying", "purblind", "purchase", "purebred", "pureeing",
    "pureness", "purified", "purifier", "purifies", "puritans",
    "purloins", "purplest", "purplish", "purports", "purposed",
    "purposes", "pursuant", "pursuers", "pursuing", "pursuits",
    "purulent", "purveyed", "purveyor", "pushbike", "pushcart",
    "pushiest", "pushover", "pushpins", "pussiest", "pussycat",
    "pustules", "putative", "putsches", "puttered", "puttying",
    "puzzlers", "puzzling", "pyramids", "quackery", "quacking",
    "quadrant", "quaffing", "quagmire", "quailing", "quainter",
    "quaintly", "quandary", "quantify", "quantity", "quarrels",
    "quarried", "quarries", "quarters", "quartets", "quashing",
    "quatrain", "quavered", "quayside", "queasier", "queasily",
    "queening", "queerest", "queering", "quelling", "quenched",
    "quenches", "querying", "questing", "question", "quibbled",
    "quibbler", "quibbles", "quickens", "quickest", "quickies",
    "quietens", "quietest", "quieting", "quietism", "quietude",
    "quilters", "quilting", "quintets", "quipping", "quirkier",
    "quirking", "quisling", "quitters", "quitting", "quivered",
    "quixotic", "quizzing", "quoiting", "quotable", "quotient",
    "rabbinic", "rabbited", "raccoons", "racegoer", "raceways",
    "racially", "raciness", "racketed", "radially", "radiance",
    "radiated", "radiates", "radiator", "radicals", "radioing",
    "radishes", "raffling", "raggeder", "raggedly", "railcard",
    "railings", "raillery", "railroad", "railways", "rainbows",
    "raincoat", "raindrop", "rainfall", "rainiest", "rakishly",
    "rallying", "ramblers", "rambling", "ramekins", "ramified",
    "ramifies", "rampaged", "rampages", "ramparts", "ranchers",
    "ranching", "randiest", "randomly", "rangiest", "rankings",
    "rankling", "rankness", "ransacks", "ransomed", "rantings",
    "rapacity", "rapidest", "rapidity", "rapports", "raptures",
    "rarefied", "rarefies", "rareness", "rarities", "rascally",
    "rashness", "raspiest", "ratchets", "ratified", "ratifies",
    "rational", "rationed", "rattiest", "rattlers", "rattling",
    "rattraps", "ravaging", "ravening", "ravenous", "ravining",
    "raviolis", "ravished", "ravishes", "rawboned", "reaching",
    "reactant", "reacting", "reaction", "reactive", "reactors",
    "readable", "readiest", "readings", "readjust", "readmits",
    "readouts", "readying", "reaffirm", "reagents", "realigns",
    "realists", "reallied", "reallies", "reappear", "rearming",
    "rearmost", "rearward", "reasoned", "reassert", "reassess",
    "reassign", "reassure", "reawaken", "rebating", "rebelled",
    "rebirths", "rebooted", "rebounds", "rebuffed", "rebuilds",
    "rebuking", "rebuttal", "rebutted", "recalled", "recanted",
    "recapped", "receding", "receipts", "received", "receiver",
    "receives", "recenter", "recently", "receptor", "recessed",
    "recesses", "recharge", "rechecks", "recitals", "reciting",
    "reckless", "reckoned", "reclaims", "reclined", "recliner",
    "reclines", "recluses", "recoiled", "recopied", "recopies",
    "recorded", "recorder", "recounts", "recouped", "recourse",
    "recovers", "recovery", "recreant", "recreate", "recruits",
    "recurred", "recycled", "recycles", "redbrick", "redcoats",
    "reddened", "redeemed", "redeemer", "redefine", "redeploy",
    "redesign", "redheads", "redirect", "rednecks", "redolent",
    "redouble", "redoubts", "redounds", "redrafts", "redskins",
    "reducing", "redwoods", "reediest", "reelects", "reemerge",
    "reenacts", "reenlist", "reenters", "refereed", "referees",
    "referent", "referral", "referred", "refiling", "refilled",
    "refiners", "refinery", "refining", "refinish", "refitted",
    "reflated", "reflates", "reflects", "reflexes", "reforest",
    "reformat", "reformed", "reformer", "refracts", "refrains",
    "refugees", "refunded", "refusals", "refusing", "refuting",
    "regained", "regaling", "regarded", "regattas", "regicide",
    "regimens", "regiment", "regional", "register", "registry",
    "regroups", "regulars", "regulate", "rehabbed", "rehashed",
    "rehashes", "rehearse", "reheated", "rehiring", "rehoused",
    "rehouses", "reigning", "reimpose", "reindeer", "reinsert",
    "reinvent", "reinvest", "reissued", "reissues", "rejected",
    "rejigged", "rejigger", "rejoiced", "rejoices", "rejoined",
    "rekindle", "relabels", "relapsed", "relapses", "relating",
    "relation", "relative", "relaunch", "relaxant", "relaxing",
    "relaying", "relearns", "released", "releases", "relegate",
    "relented", "relevant", "reliable", "reliably", "reliance",
    "relieved", "relieves", "religion", "relished", "relishes",
    "reliving", "reloaded", "relocate", "remained", "remaking",
    "remanded", "remarked", "remaster", "remedial", "remedied",
    "remedies", "remember", "reminded", "reminder", "remitted",
    "remixing", "remnants", "remodels", "remolded", "remotely",
    "remotest", "remoulds", "remounts", "removals", "removers",
    "removing", "renaming", "rendered", "renegade", "reneging",
    "renewals", "renewing", "renounce", "renovate", "renowned",
    "renumber", "reoccupy", "reoccurs", "reopened", "reorders",
    "repaints", "repaired", "repairer", "repartee", "repasted",
    "repaying", "repealed", "repeated", "repeater", "repelled",
    "repented", "rephrase", "replaced", "replaces", "replayed",
    "repleted", "repletes", "replicas", "replying", "reported",
    "reporter", "reposing", "reprieve", "reprints", "reprisal",
    "reprises", "reproach", "reproofs", "reproved", "reproves",
    "reptiles", "republic", "repulsed", "repulses", "reputing",
    "requests", "requiems", "required", "requires", "requital",
    "requited", "requites", "rerouted", "reroutes", "rescinds",
    "rescuers", "rescuing", "research", "resemble", "resented",
    "reserved", "reserves", "resettle", "reshaped", "reshapes",
    "resident", "residing", "residual", "residues", "resigned",
    "resinous", "resisted", "resister", "resistor", "resolute",
    "resolved", "resolver", "resolves", "resonant", "resonate",
    "resorted", "resounds", "resource", "respects", "respells",
    "respired", "respires", "respites", "responds", "response",
    "restarts", "restated", "restates", "restless", "restocks",
    "restored", "restorer", "restores", "restrain", "restrict",
    "restroom", "resubmit", "resulted", "resuming", "resupply",
    "retailed", "retailer", "retained", "retainer", "retaking",
    "retarded", "retching", "rethinks", "reticent", "retinues",
    "retirees", "retiring", "retooled", "retorted", "retraced",
    "retraces", "retracts", "retrains", "retreads", "retreats",
    "retrench", "retrials", "retrieve", "retrofit", "retrying",
    "returned", "returnee", "returner", "retyping", "reunions",
    "reunited", "reunites", "reusable", "revalued", "revalues",
    "revamped", "revealed", "reveille", "revenged", "revenges",
    "revenues", "reverend", "reverent", "reveries", "revering",
    "reversal", "reversed", "reverses", "reverted", "reviewed",
    "reviewer", "revilers", "reviling", "revising", "revision",
    "revisits", "revivals", "revivify", "reviving", "revoking",
    "revolted", "revolved", "revolver", "revolves", "rewarded",
    "rewiring", "reworded", "reworked", "rewrites", "rhapsody",
    "rheostat", "rhetoric", "rheumier", "rhizomes", "rhomboid",
    "rhubarbs", "rhythmic", "ribaldry", "richness", "rickshaw",
    "ricochet", "riddance", "riddling", "ridicule", "riffling",
    "riffraff", "rifleman", "riflemen", "rightest", "rightful",
    "righting", "rightist", "rigidity", "rigorous", "ringlets",
    "ringside", "ringworm", "ripcords", "ripeness", "ripening",
    "riposted", "ripostes", "rippling", "risibles", "riskiest",
    "risottos", "rissoles", "ritually", "ritziest", "riverbed",
    "riveting", "rivieras", "rivulets", "roadbeds", "roadkill",
    "roadshow", "roadside", "roadster", "roadways", "roadwork",
    "roasters", "roasting", "robotics", "robuster", "robustly",
    "rocketed", "rocketry", "rockfall", "rockiest", "roebucks",
    "roentgen", "rogering", "roisters", "rollback", "rollicks",
    "rollmops", "rollover", "romaines", "romanced", "romances",
    "romantic", "roofless", "rooftops", "rookiest", "roomfuls",
    "roomiest", "roommate", "roosters", "roosting", "rootless",
    "rosaries", "rosebuds", "rosebush", "rosemary", "rosetted",
    "rosettes", "rosewood", "rosiness", "rosining", "rostered",
    "rostrums", "rotaries", "rotating", "rotation", "rottener",
    "rotundas", "rotunded", "roughage", "roughens", "roughest",
    "roughing", "roulette", "roundels", "rounders", "roundest",
    "rounding", "roundish", "roundups", "rousting", "routines",
    "rowboats", "rowdiest", "rowdyism", "rowlocks", "royalist",
    "rubbings", "rubbishy", "rubbling", "rubdowns", "rubicund",
    "rucksack", "ruckuses", "ructions", "ruddiest", "ruddying",
    "rudeness", "rudiment", "ruefully", "ruffians", "ruffling",
    "ruggeder", "ruggedly", "rulering", "rumbaing", "rumbling",
    "ruminant", "ruminate", "rummaged", "rummages", "rumpling",
    "rumpuses", "runabout", "runaways", "rundowns", "runniest",
    "ruptured", "ruptures", "russeted", "rustiest", "rustlers",
    "rustling", "rutabaga", "ruthless", "sabotage", "saboteur",
    "sackfuls", "sackings", "sacredly", "sacristy", "saddened",
    "saddlers", "saddlery", "saddling", "sadistic", "safaried",
    "safeness", "safetied", "safeties", "saffrons", "sagacity",
    "saguaros", "sailboat", "sailfish", "sailings", "salaamed",
    "salaried", "salaries", "saleroom", "salesman", "salesmen",
    "salience", "salients", "salinity", "salivary", "salivate",
    "sallower", "sallying", "saltiest", "saltines", "salutary",
    "saluting", "salvaged", "salvages", "sambaing", "sameness",
    "samovars", "samplers", "sampling", "sanctify", "sanction",
    "sanctity", "sanctums", "sandbags", "sandbank", "sandbars",
    "sandhogs", "sandiest", "sandlots", "sandpits", "sandwich",
    "sanguine", "sanitary", "sanserif", "sapience", "saplings",
    "sapphire", "sappiest", "sarcasms", "sarcomas", "sardined",
    "sardines", "sardonic", "sashayed", "sassiest", "satanism",
    "satanist", "satchels", "satiated", "satiates", "satining",
    "satirist", "satsumas", "saturate", "saucepan", "sauciest",
    "saunaing", "saunters", "sausages", "savagely", "savagery",
    "savagest", "savaging", "savannas", "savviest", "savvying",
    "sawdusts", "sawhorse", "sawmills", "scabbard", "scabbier",
    "scabbing", "scabrous", "scaffold", "scalawag", "scalding",
    "scaliest", "scallion", "scallops", "scalpels", "scalpers",
    "scalping", "scamming", "scampers", "scandals", "scanners",
    "scanning", "scansion", "scantest", "scantier", "scanties",
    "scantily", "scanting", "scapulae", "scarcely", "scarcest",
    "scarcity", "scarfing", "scariest", "scarlets", "scarpers",
    "scarring", "scathing", "scatters", "scatting", "scavenge",
    "scenario", "scenting", "schedule", "schemata", "schemers",
    "scheming", "scherzos", "schizoid", "schlocky", "schmaltz",
    "schmooze", "schmucks", "schnapps", "schnooks", "scholars",
    "schooled", "schooner", "schussed", "schusses", "sciatica",
    "sciences", "scimitar", "scissors", "scoffing", "scofflaw",
    "scolding", "scooping", "scooters", "scooting", "scorched",
    "scorcher", "scorches", "scornful", "scorning", "scorpion",
    "scotched", "scotches", "scourers", "scourged", "scourges",
    "scouring", "scouters", "scouting", "scowling", "scrabble",
    "scraggly", "scramble", "scrammed", "scrapers", "scraping",
    "scrapped", "scratchy", "scrawled", "screamed", "screechy",
    "screened", "screwier", "screwing", "scribble", "scrimped",
    "scripted", "scrofula", "scrolled", "scrooges", "scrounge",
    "scrubbed", "scrubber", "scrummed", "scrumped", "scrunchy",
    "scrupled", "scruples", "scrutiny", "scubaing", "scudding",
    "scuffing", "scuffled", "scuffles", "scullery", "sculling",
    "scullion", "sculpted", "sculptor", "scumbags", "scummier",
    "scumming", "scuppers", "scurfier", "scurried", "scurries",
    "scurvier", "scuttled", "scuttles", "scuzzier", "scything",
    "seabirds", "seaboard", "seaborne", "seacoast", "seafarer",
    "seafloor", "seafront", "seagoing", "seagulls", "seahorse",
    "sealants", "sealskin", "seamiest", "seamless", "seaplane",
    "seaports", "searched", "searcher", "searches", "seascape",
    "seashell", "seashore", "seasides", "seasonal", "seasoned",
    "seawards", "seaweeds", "seceding", "secluded", "secludes",
    "seconded", "seconder", "secondly", "secreted", "secreter",
    "secretes", "secretly", "sections", "securely", "securest",
    "securing", "security", "sedately", "sedatest", "sedating",
    "sedation", "sedative", "sediment", "sedition", "seducers",
    "seducing", "sedulous", "seedbeds", "seediest", "seedless",
    "seedling", "seemlier", "seesawed", "seething", "segments",
    "segueing", "seizures", "selected", "selector", "selenium",
    "selfless", "selfsame", "sellouts", "seltzers", "selvaged",
    "selvages", "semantic", "semester", "seminars", "seminary",
    "semiotic", "semitone", "semolina", "senators", "senility",
    "sensible", "sensibly", "sensuous", "sentence", "sentient",
    "sentinel", "sentries", "separate", "sequence", "sequined",
    "sequoias", "seraglio", "seraphic", "serenade", "serenely",
    "serenest", "serening", "serenity", "sergeant", "serially",
    "sermoned", "serpents", "serrated", "servants", "serviced",
    "services", "serviles", "servings", "sessions", "setbacks",
    "settable", "settings", "settlers", "settling", "sevenths",
    "severely", "severest", "severing", "severity", "sewerage",
    "sexiness", "sexology", "sextants", "sexually", "shabbier",
    "shabbily", "shacking", "shackled", "shackles", "shadiest",
    "shadings", "shadowed", "shafting", "shaggier", "shagging",
    "shakeout", "shakeups", "shakiest", "shallots", "shallows",
    "shambled", "shambles", "shameful", "shamming", "shampoos",
    "shamrock", "shandies", "shanghai", "shanties", "shantung",
    "sharking", "sharpens", "sharpers", "sharpest", "sharping",
    "sharpish", "shatters", "shavings", "shawling", "shearers",
    "shearing", "sheathed", "sheathes", "shebangs", "shebeens",
    "shedding", "sheepdog", "sheepish", "sheerest", "sheering",
    "sheeting", "sheikdom", "shellacs", "shelling", "shelters",
    "shelving", "shepherd", "sherbets", "sheriffs", "sherries",
    "shielded", "shiftier", "shiftily", "shifting", "shilling",
    "shimmers", "shimmery", "shimmied", "shimmies", "shimming",
    "shinbone", "shindigs", "shingled", "shingles", "shiniest",
    "shinnied", "shinnies", "shinning", "shipload", "shipmate",
    "shipment", "shippers", "shipping", "shipyard", "shirkers",
    "shirking", "shirring", "shirting", "shithead", "shitload",
    "shittier", "shitting", "shivered", "shoaling", "shockers",
    "shocking", "shoddier", "shoddily", "shoehorn", "shoelace",
    "shoetree", "shooters", "shooting", "shootout", "shoplift",
    "shoppers", "shopping", "shoptalk", "shopworn", "shortage",
    "shortcut", "shortens", "shortest", "shorties", "shorting",
    "shortish", "shotguns", "shoulder", "shouting", "showboat",
    "showcase", "showdown", "showered", "showgirl", "showiest",
    "showings", "showoffs", "showroom", "showtime", "shrapnel",
    "shredded", "shredder", "shrewder", "shrewdly", "shrewing",
    "shrewish", "shrieked", "shrilled", "shriller", "shrimped",
    "shrimper", "shrivels", "shriving", "shrouded", "shrubbed",
    "shrugged", "shrunken", "shucking", "shuckses", "shudders",
    "shuffled", "shuffler", "shuffles", "shunning", "shunting",
    "shushing", "shutdown", "shutouts", "shutters", "shutting",
    "shuttled", "shuttles", "shysters", "sibilant", "siblings",
    "sickbays", "sickbeds", "sickened", "sicklier", "sickling",
    "sickness", "sickouts", "sickroom", "sidearms", "sidebars",
    "sidecars", "sidekick", "sideline", "sidelong", "sidereal",
    "sideshow", "sidestep", "sidewalk", "sidewall", "sideways",
    "sighting", "signally", "signings", "signpost", "silaging",
    "silenced", "silencer", "silences", "silenter", "silently",
    "silicate", "silicone", "silkened", "silkiest", "silkworm",
    "silliest", "silvered", "simmered", "simpered", "simplest",
    "simplify", "simpling", "simulate", "sincerer", "sinecure",
    "sinfully", "singeing", "singlets", "singling", "singsong",
    "singular", "sinister", "sinkable", "sinkhole", "sinology",
    "sirloins", "siroccos", "sissiest", "sistered", "sisterly",
    "sittings", "situated", "situates", "sixpence", "sixteens",
    "sixtieth", "sizzlers", "sizzling", "skeeters", "skeining",
    "skeletal", "skeleton", "sketched", "sketches", "skewbald",
    "skewered", "skidding", "skidpans", "skiffing", "skillets",
    "skillful", "skimming", "skimpier", "skimping", "skincare",
    "skinhead", "skinless", "skinnier", "skinning", "skippers",
    "skipping", "skirmish", "skirting", "skitters", "skittish",
    "skittles", "skivvied", "skivvies", "skulking", "skullcap",
    "skunking", "skydived", "skydiver", "skydives", "skyjacks",
    "skylarks", "skylight", "skylines", "skywards", "slabbing",
    "slackens", "slackers", "slackest", "slacking", "slagging",
    "slagheap", "slalomed", "slammers", "slamming", "slanders",
    "slangier", "slanting", "slapdash", "slappers", "slapping",
    "slashing", "slathers", "slattern", "slavered", "slayings",
    "sleazier", "sleazily", "sledding", "sledging", "sleekest",
    "sleeking", "sleepers", "sleepier", "sleepily", "sleeping",
    "sleetier", "sleeting", "sleighed", "slickers", "slickest",
    "slicking", "slighted", "slighter", "slightly", "slimiest",
    "slimline", "slimmers", "slimmest", "slimming", "slimness",
    "slinging", "slinkier", "slinking", "slipcase", "slipknot",
    "slippage", "slippers", "slippery", "slipping", "slipshod",
    "slipways", "slithers", "slithery", "slitting", "slivered",
    "slobbers", "slobbery", "slobbing", "slogging", "sloppier",
    "sloppily", "slopping", "sloshing", "slothful", "slothing",
    "slotting", "slouched", "slouches", "sloughed", "slovenly",
    "slowdown", "slowness", "slowpoke", "sludging", "sluggard",
    "sluggers", "slugging", "sluggish", "sluicing", "slumbers",
    "slumlord", "slumming", "slumping", "slurping", "slurring",
    "slushier", "sluttish", "smackers", "smacking", "smallest",
    "smalling", "smallish", "smallpox", "smarmier", "smartens",
    "smartest", "smarting", "smashers", "smashing", "smearing",
    "smellier", "smelling", "smelters", "smelting", "smidgens",
    "smirched", "smirches", "smirking", "smithies", "smocking",
    "smoggier", "smokiest", "smolders", "smooched", "smooches",
    "smoothed", "smoother", "smoothie", "smoothly", "smothers",
    "smudgier", "smudging", "smuggest", "smugging", "smuggled",
    "smuggler", "smuggles", "smugness", "smuttier", "snacking",
    "snaffled", "snaffles", "snagging", "snailing", "snakiest",
    "snappers", "snappier", "snappily", "snapping", "snappish",
    "snapshot", "snarling", "snatched", "snatcher", "snatches",
    "snazzier", "snazzily", "sneakers", "sneakier", "sneakily",
    "sneaking", "sneering", "sneezing", "snickers", "snicking",
    "sniffers", "sniffier", "sniffing", "sniffled", "sniffles",
    "snifters", "snippets", "snippier", "snipping", "snitched",
    "snitches", "snobbery", "snobbier", "snobbish", "snogging",
    "snookers", "snoopers", "snoopier", "snooping", "snootier",
    "snootily", "snoozing", "snorkels", "snorting", "snottier",
    "snotting", "snouting", "snowball", "snowdrop", "snowfall",
    "snowiest", "snowline", "snowplow", "snowshoe", "snowsuit",
    "snubbing", "snuffbox", "snuffers", "snuffing", "snuffled",
    "snuffles", "snuggest", "snugging", "snuggled", "snuggles",
    "snugness", "soakings", "soapiest", "soapsuds", "soberest",
    "sobering", "sobriety", "sociable", "sociably", "socially",
    "societal", "sodomite", "softback", "softball", "softened",
    "softener", "softness", "software", "softwood", "soggiest",
    "sojourns", "solacing", "solarium", "soldered", "soldiers",
    "soldiery", "solecism", "solemner", "solemnly", "solenoid",
    "solicits", "solidest", "solidify", "solidity", "solitary",
    "solitude", "soloists", "solstice", "solubles", "solution",
    "solvable", "solvency", "solvents", "sombrero", "somebody",
    "someones", "sometime", "someways", "somewhat", "songbird",
    "songbook", "songster", "sonogram", "sonority", "sonorous",
    "soothest", "soothing", "sootiest", "sophists", "soppiest",
    "soppings", "sopranos", "sorcerer", "sordidly", "sorehead",
    "soreness", "sorority", "sorriest", "sorrowed", "soughing",
    "soulless", "soundest", "sounding", "soupiest", "sourcing",
    "sourness", "sourpuss", "southern", "southpaw", "souvenir",
    "soybeans", "spaceman", "spacemen", "spaciest", "spacious",
    "spadeful", "spamming", "spangled", "spangles", "spaniels",
    "spanking", "spanners", "spanning", "sparkier", "sparking",
    "sparkled", "sparkler", "sparkles", "sparring", "sparrows",
    "sparsely", "sparsest", "sparsity", "spasming", "spastics",
    "spatters", "spatting", "spatulas", "spawning", "speakers",
    "speaking", "spearing", "specials", "specific", "specimen",
    "specious", "specking", "speckled", "speckles", "spectate",
    "spectral", "spectrum", "speeched", "speeches", "speeders",
    "speedier", "speedily", "speeding", "speedups", "speedway",
    "spellers", "spelling", "spenders", "spending", "sphagnum",
    "spheroid", "sphinxes", "spiciest", "spieling", "spiffied",
    "spiffier", "spiffies", "spiffing", "spikiest", "spillage",
    "spilling", "spillway", "spindled", "spindles", "spiniest",
    "spinners", "spinneys", "spinning", "spinster", "spirally",
    "spirited", "spitball", "spiteful", "spitfire", "spitting",
    "spittoon", "splashed", "splashes", "splatted", "splatter",
    "splaying", "splendid", "splicers", "splicing", "splinted",
    "splinter", "splodges", "sploshed", "sploshes", "splotchy",
    "splurged", "splurges", "splutter", "spoilage", "spoilers",
    "spoiling", "spongers", "spongier", "sponging", "sponsors",
    "spoofing", "spookier", "spooking", "spooling", "spoonful",
    "spooning", "spooring", "sporadic", "sporrans", "sportier",
    "sporting", "sportive", "spotless", "spotters", "spottier",
    "spotting", "spouting", "sprained", "sprawled", "sprayers",
    "spraying", "spreader", "spreeing", "sprigged", "sprinkle",
    "sprinted", "sprinter", "spritzed", "spritzer", "spritzes",
    "sprocket", "sprouted", "sprucest", "sprucing", "spryness",
    "spunkier", "spunkies", "spunking", "spurious", "spurning",
    "spurring", "spurting", "sputters", "spyglass", "squabbed",
    "squabble", "squadded", "squaddie", "squadron", "squalled",
    "squander", "squarely", "squarest", "squaring", "squarish",
    "squashed", "squashes", "squatted", "squatter", "squawked",
    "squeaked", "squealed", "squealer", "squeegee", "squeezed",
    "squeezer", "squeezes", "squelchy", "squidded", "squiggle",
    "squiggly", "squinted", "squinter", "squiring", "squirmed",
    "squirrel", "squirted", "squished", "squishes", "stabbing",
    "stablest", "stabling", "staccato", "stacking", "stadiums",
    "staffers", "staffing", "staggers", "stagings", "stagnant",
    "stagnate", "staidest", "staining", "stairway", "stakeout",
    "stalkers", "stalking", "stalling", "stallion", "stalwart",
    "stammers", "stampede", "stamping", "stanched", "stancher",
    "stanches", "standard", "standbys", "standing", "standoff",
    "standout", "staplers", "stapling", "starched", "starches",
    "stardust", "starfish", "stargaze", "starkers", "starkest",
    "starking", "starless", "starlets", "starling", "starrier",
    "starring", "starters", "starting", "startled", "startles",
    "starving", "stashing", "stations", "statuary", "statures",
    "statuses", "statutes", "steadied", "steadier", "steadies",
    "steadily", "stealing", "stealthy", "steamers", "steamier",
    "steamies", "steaming", "steelier", "steelies", "steeling",
    "steepens", "steepest", "steeping", "steeples", "steerage",
    "steering", "steining", "stemming", "stenched", "stenches",
    "stencils", "stepping", "stepsons", "sterling", "sternest",
    "sterning", "sternums", "steroids", "stetsons", "stewards",
    "stickers", "stickied", "stickier", "stickies", "sticking",
    "stickler", "stickpin", "stickups", "stiffens", "stiffest",
    "stiffing", "stifling", "stigmata", "stiletto", "stillest",
    "stilling", "stimulus", "stingers", "stingier", "stingily",
    "stinging", "stingray", "stinkers", "stinking", "stinting",
    "stipends", "stippled", "stipples", "stirrers", "stirring",
    "stirrups", "stitched", "stitches", "stockade", "stockier",
    "stockily", "stocking", "stockist", "stodgier", "stoicism",
    "stolider", "stolidly", "stomachs", "stomping", "stoniest",
    "stonking", "stooping", "stopcock", "stopgaps", "stopover",
    "stoppage", "stoppers", "stopping", "stormier", "stormily",
    "storming", "stoutest", "stowaway", "straddle", "strafing",
    "straggle", "straggly", "straight", "strained", "strainer",
    "straited", "straiten", "stranded", "stranger", "strangle",
    "strapped", "strategy", "stratify", "strawing", "straying",
    "streaked", "streaker", "streamed", "streamer", "strength",
    "stressed", "stresses", "stretchy", "strewing", "striated",
    "stricken", "stricter", "strictly", "stridden", "strident",
    "striding", "strikers", "striking", "stringed", "stringer",
    "striping", "stripped", "stripper", "striving", "stroking",
    "strolled", "stroller", "stronger", "strongly", "strophes",
    "stropped", "strudels", "struggle", "strummed", "strumpet",
    "strutted", "stubbier", "stubbies", "stubbing", "stubborn",
    "stuccoed", "stuccoes", "studbook", "studding", "students",
    "studious", "studying", "stuffier", "stuffily", "stuffing",
    "stultify", "stumbled", "stumbler", "stumbles", "stumpier",
    "stumping", "stunners", "stunning", "stunting", "stuntman",
    "stuntmen", "stupider", "stupidly", "sturdier", "sturdily",
    "sturgeon", "stutters", "stylists", "styluses", "styptics",
    "subclass", "subduing", "subgroup", "subheads", "subhuman",
    "subjects", "subjoins", "sublease", "sublimed", "sublimer",
    "sublimes", "submerge", "submerse", "suborned", "subplots",
    "subpoena", "subsided", "subsides", "subsists", "subsoils",
    "subsonic", "subspace", "subsumed", "subsumes", "subteens",
    "subtends", "subtexts", "subtitle", "subtlest", "subtlety",
    "subtotal", "subtract", "suburban", "suburbia", "subverts",
    "succeeds", "succinct", "succubus", "succumbs", "suchlike",
    "suckered", "suckling", "suctions", "suddenly", "sudsiest",
    "suffered", "sufferer", "sufficed", "suffices", "suffixed",
    "suffixes", "suffrage", "suffused", "suffuses", "sugarier",
    "sugaring", "suggests", "suicidal", "suicides", "suitable",
    "suitably", "suitcase", "sukiyaki", "sulfates", "sulfides",
    "sulkiest", "sullener", "sullenly", "sullying", "sulphate",
    "sulphide", "sultanas", "sultrier", "summered", "summitry",
    "summoned", "summoner", "sunbathe", "sunbeams", "sunblock",
    "sunburns", "sundecks", "sundered", "sundials", "sundowns",
    "sundress", "sundries", "sunlamps", "sunlight", "sunniest",
    "sunrises", "sunroofs", "sunshade", "sunshine", "sunspots",
    "suntraps", "superber", "superbly", "superego", "supering",
    "superior", "superman", "supermen", "supinely", "supplant",
    "supplest", "supplied", "supplier", "supplies", "supports",
    "supposed", "supposes", "suppress", "supremer", "supremos",
    "surcease", "surefire", "sureness", "sureties", "surfaced",
    "surfaces", "surfeits", "surgeons", "surgical", "surliest",
    "surmised", "surmises", "surmount", "surnames", "surplice",
    "surprise", "surreals", "surround", "surtaxed", "surtaxes",
    "surtitle", "surveyed", "surveyor", "survival", "survived",
    "survives", "survivor", "suspects", "suspends", "suspense",
    "sustains", "suturing", "sveltest", "swabbing", "swaddled",
    "swaddles", "swaggers", "swagging", "swallows", "swampier",
    "swamping", "swankest", "swankier", "swankies", "swanking",
    "swanning", "swansong", "swapping", "swarming", "swashing",
    "swastika", "swatches", "swathing", "swatters", "swatting",
    "swearers", "swearing", "sweaters", "sweatier", "sweating",
    "sweepers", "sweeping", "sweetens", "sweetest", "sweeties",
    "sweetish", "swellest", "swelling", "swelters", "swerving",
    "swiftest", "swifting", "swigging", "swilling", "swimmers",
    "swimming", "swimsuit", "swimwear", "swindled", "swindler",
    "swindles", "swingers", "swinging", "swirlier", "swirling",
    "swishest", "swishing", "switched", "switcher", "switches",
    "swooning", "swooping", "swooshed", "swooshes", "swording",
    "swotting", "sybarite", "sycamore", "syllabic", "syllable",
    "syllabub", "syllabus", "symbolic", "symmetry", "sympathy",
    "symphony", "symptoms", "synapses", "synaptic", "syndrome",
    "synonyms", "synopses", "synopsis", "syphilis", "syringed",
    "syringes", "systemic", "systolic", "tableaux", "tabloids",
    "tabooing", "tabulate", "taciturn", "tackiest", "tacklers",
    "tackling", "tactical", "tactless", "tadpoles", "tailback",
    "tailbone", "tailcoat", "tailgate", "tailless", "tailored",
    "tailpipe", "tailspin", "tailwind", "tainting", "takeaway",
    "takeoffs", "takeouts", "takeover", "talented", "talisman",
    "tallboys", "tallness", "tallyhos", "tallying", "tamarind",
    "tameness", "tampered", "tanagers", "tandoori", "tangelos",
    "tangents", "tangible", "tangibly", "tangiest", "tangling",
    "tangoing", "tankards", "tankfuls", "tantrums", "tapering",
    "tapestry", "tapeworm", "taprooms", "taproots", "tardiest",
    "targeted", "tarragon", "tarriest", "tarrying", "tartiest",
    "tartness", "tasteful", "tastiest", "tastings", "tattered",
    "tattiest", "tattlers", "tattling", "tattooed", "taunting",
    "tautened", "tautness", "tawdrier", "tawniest", "taxation",
    "taxicabs", "taxiways", "taxonomy", "taxpayer", "teacakes",
    "teachers", "teaching", "teammate", "teamster", "teamwork",
    "tearaway", "teardrop", "teariest", "tearooms", "teaspoon",
    "teatimes", "tectonic", "teenager", "teeniest", "teetered",
    "teething", "teetotal", "telecast", "telegram", "teletext",
    "telethon", "teletype", "televise", "telexing", "tellered",
    "telltale", "temblors", "temerity", "temperas", "tempered",
    "tempests", "template", "temporal", "tempters", "tempting",
    "tenacity", "tenanted", "tendency", "tendered", "tenderer",
    "tenderly", "tendrils", "tenement", "tenfolds", "tensions",
    "tentacle", "tenuring", "tequilas", "terminal", "terminus",
    "termites", "terraced", "terraces", "terrains", "terrapin",
    "terrible", "terribly", "terriers", "terrific", "terrines",
    "tertiary", "testable", "testates", "testicle", "testiest",
    "tetchier", "tetchily", "tethered", "textbook", "textiles",
    "textural", "textured", "textures", "thalamus", "thallium",
    "thankful", "thanking", "thatched", "thatcher", "thatches",
    "theistic", "thematic", "theology", "theorems", "theories",
    "theorist", "thermals", "thesauri", "thespian", "thiamine",
    "thickens", "thickest", "thickets", "thickset", "thievery",
    "thieving", "thievish", "thimbled", "thimbles", "thingies",
    "thinkers", "thinking", "thinners", "thinness", "thinnest",
    "thinning", "thirding", "thirsted", "thirteen", "thirties",
    "thistles", "thoracic", "thoraxes", "thornier", "thorough",
    "thoughts", "thousand", "thralled", "thrashed", "thrasher",
    "thrashes", "threaded", "threaten", "threnody", "threshed",
    "thresher", "threshes", "thrilled", "thriller", "thriving",
    "throbbed", "throeing", "thronged", "throttle", "throwers",
    "throwing", "thrummed", "thrushes", "thruways", "thudding",
    "thuggery", "thuggish", "thumbing", "thumping", "thunders",
    "thundery", "thwacked", "thwarted", "thymuses", "thyroids",
    "ticketed", "tickling", "ticklish", "tiddlers", "tidemark",
    "tidiness", "tiebreak", "tightens", "tightest", "tightwad",
    "tillable", "timbered", "timeless", "timelier", "timeworn",
    "timezone", "timidest", "timidity", "timorous", "tincture",
    "tingeing", "tinglier", "tingling", "tinkered", "tinkling",
    "tinniest", "tinnitus", "tinplate", "tinsmith", "tippexed",
    "tippexes", "tipplers", "tippling", "tipsiest", "tipsters",
    "tiredest", "tireless", "tiresome", "titanium", "titivate",
    "titmouse", "tittered", "tittling", "toadying", "toasters",
    "toastier", "toasties", "toasting", "tobaccos", "toboggan",
    "toccatas", "toddlers", "toddling", "toeholds", "toenails",
    "together", "toggling", "toileted", "toiletry", "toilette",
    "toilsome", "tokenism", "tolerant", "tolerate", "tollgate",
    "tomahawk", "tomatoes", "tombolas", "tomorrow", "tonality",
    "toneless", "tonguing", "tonnages", "tonsured", "tonsures",
    "toolbars", "toothier", "tootling", "tootsies", "topcoats",
    "topknots", "topmasts", "topology", "toppings", "toppling",
    "topsails", "topsides", "torching", "toreador", "torments",
    "torpidly", "torquing", "torrents", "torrider", "tortilla",
    "tortoise", "tortuous", "tortured", "torturer", "tortures",
    "totality", "tottered", "touchier", "touchily", "touching",
    "toughens", "toughest", "toughies", "toughing", "tourists",
    "touristy", "tourneys", "tousling", "towering", "towheads",
    "township", "townsman", "townsmen", "towpaths", "towropes",
    "toxicity", "tracheae", "tracings", "trackers", "tracking",
    "traction", "tractors", "traduced", "traduces", "traffics",
    "trailers", "trailing", "trainees", "trainers", "training",
    "traipsed", "traipses", "traitors", "tramcars", "trammels",
    "tramming", "tramping", "trampled", "tramples", "tramways",
    "tranches", "tranquil", "transact", "transept", "transfer",
    "transfix", "transits", "transmit", "transoms", "trapdoor",
    "trapezed", "trapezes", "trappers", "trapping", "trashcan",
    "trashier", "trashing", "travails", "traverse", "travesty",
    "trawlers", "trawling", "treacled", "treacles", "treading",
    "treadled", "treadles", "treasure", "treasury", "treaties",
    "treating", "treatise", "trebling", "treeless", "treeline",
    "treetops", "trefoils", "trekking", "trembled", "trembles",
    "tremolos", "trenched", "trencher", "trenches", "trendier",
    "trendies", "trendily", "trending", "trespass", "trestles",
    "trialing", "trialled", "triangle", "tribunal", "tribunes",
    "tributes", "trickery", "trickier", "tricking", "trickled",
    "trickles", "tricycle", "tridents", "triflers", "trifling",
    "triggers", "triggest", "trilbies", "trilling", "trillion",
    "trimaran", "trimmers", "trimmest", "trimming", "trimness",
    "trinkets", "triplets", "triplied", "triplies", "tripling",
    "trippers", "tripping", "triptych", "tripwire", "trisects",
    "triumphs", "trochees", "trolleys", "trolling", "trollops",
    "trombone", "tromping", "troopers", "trooping", "trophied",
    "trophies", "tropical", "tropisms", "trothing", "trotters",
    "trotting", "troubled", "troubles", "trounced", "trounces",
    "troupers", "trouping", "trousers", "truanted", "truckers",
    "trucking", "truckled", "truckles", "trudging", "truelove",
    "truffles", "trumpery", "trumpets", "trumping", "truncate",
    "trundled", "trundles", "trunking", "trussing", "trustees",
    "trustful", "trustier", "trusties", "trusting", "truthful",
    "trysting", "tsarists", "tsunamis", "tubbiest", "tubeless",
    "tubercle", "tuberous", "tuckered", "tugboats", "tumblers",
    "tumbling", "tumbrels", "tumulted", "tuneless", "tungsten",
    "tuppence", "tuppenny", "turbaned", "turbines", "turbojet",
    "turgidly", "turmeric", "turmoils", "turncoat", "turnings",
    "turniped", "turnkeys", "turnoffs", "turnouts", "turnover",
    "turnpike", "turreted", "tussling", "tussocks", "tutelage",
    "tutorial", "tutoring", "twaddled", "twaddles", "twanging",
    "tweaking", "tweedier", "tweeters", "tweeting", "tweezers",
    "twelfths", "twenties", "twiddled", "twiddles", "twiggier",
    "twigging", "twilight", "twinging", "twinkled", "twinkles",
    "twinning", "twinsets", "twirlers", "twirling", "twisters",
    "twisting", "twitched", "twitches", "twitters", "twitting",
    "twofolds", "twopence", "twopenny", "twosomes", "tympanum",
    "typecast", "typeface", "typesets", "typhoons", "typified",
    "typifies", "typology", "ubiquity", "ugliness", "ukuleles",
    "ulcerate", "ulcering", "ulcerous", "ulterior", "ultimate",
    "ululated", "ululates", "umbilici", "umbraged", "umbrages",
    "umbrella", "umpiring", "unabated", "unafraid", "unawares",
    "unbarred", "unbeaten", "unbelief", "unbiased", "unbidden",
    "unblocks", "unbolted", "unbosoms", "unbroken", "unbuckle",
    "unburden", "unbutton", "uncalled", "uncaring", "unclasps",
    "unclothe", "uncoiled", "uncommon", "uncooked", "uncorked",
    "uncouple", "uncovers", "unctions", "unctuous", "uncurled",
    "underact", "underage", "underarm", "underbid", "undercut",
    "underdog", "underfed", "underlay", "underlie", "underpay",
    "underpin", "undersea", "undertow", "underway", "undoings",
    "undulant", "undulate", "unearned", "unearths", "uneasier",
    "uneasily", "unedited", "unending", "unequals", "unerring",
    "unevener", "unevenly", "unfairer", "unfairly", "unfasten",
    "unfetter", "unfilled", "unfitted", "unfolded", "unformed",
    "unfrocks", "unfurled", "ungainly", "unguents", "ungulate",
    "unhanded", "unharmed", "unheeded", "unhinged", "unhinges",
    "unholier", "unhooked", "unhorsed", "unhorses", "unicorns",
    "unicycle", "uniforms", "unifying", "unionism", "unionist",
    "uniquely", "uniquest", "universe", "unjustly", "unkinder",
    "unkindly", "unknowns", "unlacing", "unlawful", "unleaded",
    "unlearns", "unlikely", "unlisted", "unloaded", "unlocked",
    "unloosed", "unlooses", "unlovely", "unmaking", "unmanned",
    "unmarked", "unmasked", "unneeded", "unnerved", "unnerves",
    "unopened", "unpacked", "unpicked", "unpinned", "unplaced",
    "unproved", "unproven", "unquoted", "unquotes", "unravels",
    "unrested", "unripest", "unrolled", "unrulier", "unsaddle",
    "unsafest", "unsalted", "unsaying", "unscrews", "unsealed",
    "unseated", "unseeded", "unseeing", "unseemly", "unsettle",
    "unshaken", "unshaven", "unsigned", "unsnarls", "unsocial",
    "unsolved", "unspoilt", "unspoken", "unstable", "unstated",
    "unsteady", "unstrung", "unsubtle", "unsuited", "untangle",
    "untapped", "untaught", "untested", "untidier", "untidily",
    "untiling", "untimely", "untiring", "untitled", "untoward",
    "untruest", "untruths", "untwists", "unusable", "unveiled",
    "unversed", "unvoiced", "unwanted", "unwarier", "unwashed",
    "unwieldy", "unwisely", "unwisest", "unwonted", "unworthy",
    "unzipped", "upbraids", "upchucks", "upcoming", "updating",
    "upending", "upgraded", "upgrades", "upheaval", "upholder",
    "uplifted", "uploaded", "upmarket", "uppercut", "upraised",
    "upraises", "uprights", "uprising", "uprooted", "upstaged",
    "upstages", "upstairs", "upstarts", "upstream", "upsurged",
    "upsurges", "upswings", "upturned", "upwardly", "urbanely",
    "urbanest", "urbanity", "urethrae", "urgently", "urinated",
    "urinates", "usefully", "ushering", "usurious", "usurpers",
    "usurping", "utensils", "utterest", "uttering", "vacantly",
    "vacating", "vacation", "vaccines", "vacuumed", "vagabond",
    "vagaries", "vagrancy", "vagrants", "vagueing", "valanced",
    "valances", "valences", "valeting", "validate", "validity",
    "valorous", "valuable", "vamoosed", "vamooses", "vampired",
    "vampires", "vanadium", "vanguard", "vanillas", "vanished",
    "vanishes", "vanities", "vanquish", "vantages", "vapidity",
    "vaporise", "vaporous", "variable", "variably", "variance",
    "variants", "varicose", "varmints", "vascular", "vassaled",
    "vastness", "vaulters", "vaulting", "vaunting", "vectored",
    "vegetate", "vehement", "vehicles", "velocity", "velveted",
    "venality", "vendetta", "veneered", "venerate", "venereal",
    "vengeful", "venomous", "ventrals", "ventured", "ventures",
    "veracity", "verandas", "verbally", "verbatim", "verbenas",
    "verbiage", "verdicts", "verified", "verifies", "verities",
    "vermouth", "verrucae", "verrucas", "versions", "vertebra",
    "vertexes", "vertical", "vesicles", "vestiges", "vestment",
    "vestries", "veterans", "vexation", "viaducts", "vibrancy",
    "vibrated", "vibrates", "vibrator", "vibratos", "viburnum",
    "vicarage", "viceroys", "vicinity", "victuals", "videoing",
    "viewings", "vigilant", "vignette", "vigorous", "vileness",
    "vilified", "vilifies", "villager", "villages", "villains",
    "villainy", "villeins", "vinegary", "vineyard", "vintages",
    "vintners", "violable", "violated", "violates", "violator",
    "violence", "violists", "viragoes", "virginal", "virgules",
    "virility", "virology", "virtuoso", "virtuous", "virulent",
    "visceral", "viscount", "visioned", "visiting", "visitors",
    "vistaing", "visually", "vitality", "vitamins", "vitiated",
    "vitiates", "vitreous", "vivacity", "vividest", "vivified",
    "vivifies", "vixenish", "vocalics", "vocalist", "vocation",
    "vocative", "vogueing", "volatile", "volcanic", "volition",
    "volleyed", "voltages", "voluming", "vomiting", "voodooed",
    "voracity", "vortexes", "votaries", "vouchers", "vouching",
    "voyagers", "voyaging", "vulgarer", "vulgarly", "vultures",
    "wackiest", "waddling", "waffling", "wagering", "waggling",
    "wagtails", "wainscot", "waisting", "waitress", "wakening",
    "walkaway", "walkouts", "walkover", "walkways", "walleyed",
    "walleyes", "walloped", "wallowed", "walruses", "waltzing",
    "wandered", "wanderer", "wangling", "wannabee", "wannabes",
    "wantings", "wantoned", "wantoner", "wantonly", "warblers",
    "warbling", "wardened", "wardered", "wardress", "wardrobe",
    "wardroom", "warheads", "warhorse", "wariness", "warlocks",
    "warlords", "warnings", "warpaint", "warpaths", "warplane",
    "warrants", "warranty", "warriors", "warships", "warthogs",
    "wartiest", "washable", "washbowl", "washered", "washouts",
    "washroom", "washtubs", "wassails", "wasteful", "wastered",
    "wastrels", "watchdog", "watchers", "watchful", "watching",
    "watchman", "watchmen", "waterier", "watering", "waterway",
    "wattling", "waveband", "waveform", "wavelets", "wavering",
    "waviness", "waxiness", "waxwings", "waxworks", "wayfarer",
    "waysides", "weakened", "weakfish", "weaklier", "weakling",
    "weakness", "weaponry", "wearable", "weariest", "wearying",
    "weathers", "websites", "weddings", "weediest", "weekdays",
    "weekends", "weeklies", "weepiest", "weepings", "weighing",
    "weighted", "weirdest", "weirding", "welcomed", "welcomes",
    "wellness", "welshing", "weltered", "werewolf", "westerly",
    "westerns", "westward", "wetbacks", "wetlands", "whacking",
    "whammies", "whamming", "whatever", "whatsits", "wheatens",
    "wheedled", "wheedles", "wheelies", "wheeling", "wheezier",
    "wheezily", "wheezing", "whelping", "whenever", "wherever",
    "whetting", "whiffing", "whimming", "whimpers", "whimsier",
    "whimsies", "whingers", "whinging", "whiniest", "whinnied",
    "whinnier", "whinnies", "whipcord", "whiplash", "whippets",
    "whipping", "whirling", "whirring", "whiskers", "whiskery",
    "whisking", "whispers", "whistled", "whistler", "whistles",
    "whitecap", "whitened", "whitener", "whiteout", "whithers",
    "whitings", "whittled", "whittler", "whittles", "whizzing",
    "whodunit", "whomever", "whoopees", "whooping", "whooshed",
    "whooshes", "whoppers", "whopping", "whupping", "wickeder",
    "wickedly", "wideness", "widening", "widowers", "widowing",
    "wielding", "wifelier", "wigglers", "wigglier", "wiggling",
    "wighting", "wildcats", "wildfire", "wildfowl", "wildlife",
    "wildness", "wiliness", "wimpiest", "wimpling", "winching",
    "windbags", "windburn", "windfall", "windiest", "windlass",
    "windless", "windmill", "windowed", "windpipe", "windsock",
    "windsurf", "windward", "wineries", "wingless", "wingspan",
    "wingtips", "winkling", "winnings", "winnowed", "winsomer",
    "wintered", "wintrier", "wireless", "wiretaps", "wiriness",
    "wiseacre", "wiseguys", "wiselier", "wishbone", "wispiest",
    "wisteria", "witchery", "witching", "withdraw", "withdrew",
    "withered", "withheld", "withhold", "wittered", "wittiest",
    "wizardry", "wobblier", "wobblies", "wobbling", "woefully",
    "womanish", "wondered", "wondrous", "woodbine", "woodcock",
    "woodcuts", "woodener", "woodenly", "woodiest", "woodland",
    "woodlice", "woodpile", "woodshed", "woodsier", "woodsman",
    "woodsmen", "woodwind", "woodwork", "woodworm", "woollier",
    "woollies", "wooziest", "wordiest", "wordings", "wordless",
    "wordplay", "workable", "workaday", "workbook", "workdays",
    "workfare", "workings", "workload", "workmate", "workouts",
    "workroom", "workshop", "worktops", "workweek", "wormhole",
    "wormiest", "wormwood", "worriers", "worrying", "worsened",
    "worships", "worsting", "worthier", "worthies", "worthily",
    "wounding", "wracking", "wrangled", "wrangler", "wrangles",
    "wrappers", "wrapping", "wrathful", "wrathing", "wreaking",
    "wreathed", "wreathes", "wreckage", "wreckers", "wrecking",
    "wrenched", "wrenches", "wresting", "wrestled", "wrestler",
    "wrestles", "wretched", "wretches", "wriggled", "wriggler",
    "wriggles", "wringers", "wringing", "wrinkled", "wrinkles",
    "writable", "writhing", "writings", "wrongest", "wrongful",
    "wronging", "xeroxing", "yachting", "yammered", "yardages",
    "yardarms", "yarmulke", "yashmaks", "yearbook", "yearlies",
    "yearling", "yearning", "yeastier", "yellowed", "yellower",
    "yeshivas", "yielding", "youngest", "youngish", "yourself",
    "youthful", "yuckiest", "yuletide", "yummiest", "zaniness",
    "zealotry", "zeppelin", "zillions", "zincking", "zippered",
    "zippiest", "zodiacal", "zucchini", "zwieback"
  };

  const char* w_9[] = {
    "aardvarks", "abandoned", "abasement", "abatement", "abattoirs",
    "abdicated", "abdicates", "abdominal", "abducting", "abduction",
    "abductors", "abhorrent", "abhorring", "abilities", "abjecting",
    "ablatives", "ablutions", "abnegated", "abnegates", "abolished",
    "abolishes", "abolition", "abominate", "aborigine", "abortions",
    "abounding", "abrasions", "abrasives", "abridging", "abrogated",
    "abrogates", "abruptest", "abscessed", "abscesses", "abscissas",
    "absconded", "abseiling", "absentees", "absenting", "absoluter",
    "absolutes", "absolving", "absorbent", "absorbing", "abstained",
    "abstainer", "abstinent", "abstracts", "abstruser", "absurdest",
    "absurdity", "abundance", "abusively", "abutments", "abysmally",
    "academics", "academies", "accenting", "accepting", "accessing",
    "accession", "accessory", "accidents", "acclaimed", "acclimate",
    "accoladed", "accolades", "accompany", "according", "accordion",
    "accosting", "accounted", "accredits", "accretion", "accustoms",
    "acetylene", "achievers", "achieving", "acidified", "acidifies",
    "acidulous", "acoustics", "acquaints", "acquiesce", "acquirers",
    "acquiring", "acquittal", "acquitted", "acrobatic", "acrostics",
    "actioning", "activated", "activates", "activists", "actresses",
    "actuality", "actuarial", "actuaries", "actuating", "actuators",
    "acuteness", "adamantly", "adaptable", "adaptions", "addicting",
    "addiction", "addictive", "additions", "additives", "addressed",
    "addressee", "addresses", "adenoidal", "adeptness", "adherence",
    "adherents", "adhesives", "adiabatic", "adjective", "adjoining",
    "adjourned", "adjudging", "adjusters", "adjusting", "adjutants",
    "admirable", "admirably", "admiralty", "admission", "admitting",
    "admixture", "adoptions", "adoration", "adoringly", "adornment",
    "adrenalin", "adroitest", "adulating", "adulation", "adulatory",
    "adulterer", "adulthood", "adumbrate", "advancing", "advantage",
    "adventure", "adverbial", "adversary", "adversely", "adversest",
    "adversity", "adverting", "advertise", "advisable", "advisedly",
    "advocated", "advocates", "aerialist", "aerobatic", "aerodrome",
    "aerograms", "aerospace", "aesthetes", "aesthetic", "aetiology",
    "affablest", "affecting", "affection", "affidavit", "affiliate",
    "affirming", "afflicted", "affluence", "affording", "afforests",
    "affronted", "aforesaid", "aftercare", "afterglow", "afterlife",
    "aftermath", "afternoon", "afterword", "aggravate", "aggregate",
    "aggressor", "aggrieved", "aggrieves", "agitating", "agitation",
    "agitators", "agnostics", "agrarians", "agreeable", "agreeably",
    "agreement", "aimlessly", "airdromes", "airfields", "airletter",
    "airlifted", "airliners", "airmailed", "airstrips", "airworthy",
    "alabaster", "alarmists", "albacores", "albatross", "alchemist",
    "alcoholic", "alehouses", "alertness", "algebraic", "algorithm",
    "alienable", "alienated", "alienates", "alighting", "alignment",
    "alkaloids", "allegedly", "alleluias", "allergens", "allergies",
    "allergist", "alleviate", "alleyways", "alliances", "alligator",
    "allocated", "allocates", "allotment", "allotting", "allowable",
    "allowance", "allusions", "alluviums", "almanacks", "almshouse",
    "alongside", "aloofness", "alphabets", "alterable", "alternate",
    "altimeter", "altitudes", "altruists", "alveolars", "amaranths",
    "amaryllis", "amazement", "amazingly", "amazonian", "ambergris",
    "ambiances", "ambiguity", "ambiguous", "ambitions", "ambitious",
    "ambulance", "ambushing", "amendable", "amendment", "amenities",
    "amethysts", "amidships", "amnesiacs", "amnestied", "amnesties",
    "amorality", "amorously", "amorphous", "amounting", "ampersand",
    "amphibian", "amplified", "amplifier", "amplifies", "amplitude",
    "amputated", "amputates", "amusement", "amusingly", "anacondas",
    "anaerobic", "analgesia", "analgesic", "analogies", "analogous",
    "analogues", "analytics", "anarchism", "anarchist", "anathemas",
    "anatomies", "anatomist", "ancestors", "ancestral", "anchorage",
    "anchoring", "anchorite", "anchorman", "anchormen", "anchovies",
    "ancienter", "anciently", "ancillary", "androgyny", "anecdotal",
    "anecdotes", "aneurysms", "angleworm", "anglicism", "angostura",
    "angstroms", "anguished", "anguishes", "animating", "animation",
    "animators", "animistic", "animosity", "annealing", "annotated",
    "annotates", "announced", "announcer", "announces", "annoyance",
    "annuities", "annulling", "annulment", "anointing", "anomalies",
    "anomalous", "anonymity", "anonymous", "anopheles", "anorexics",
    "answering", "antarctic", "anteaters", "antedated", "antedates",
    "antelopes", "antenatal", "anterooms", "anthology", "anticking",
    "antidotes", "antiknock", "antipasti", "antipasto", "antipathy",
    "antipodes", "antiquary", "antiquate", "antiquing", "antiquity",
    "antitoxin", "antitrust", "antiviral", "anxieties", "anxiously",
    "anybodies", "anythings", "anywheres", "apartheid", "apartment",
    "apathetic", "aperitifs", "apertures", "aphelions", "aphorisms",
    "apologias", "apologies", "apologist", "apostates", "apostolic",
    "appalling", "apparatus", "appealing", "appearing", "appeasers",
    "appeasing", "appellant", "appellate", "appendage", "appending",
    "appertain", "appetites", "applauded", "applejack", "appliance",
    "applicant", "appointed", "appointee", "apportion", "appraisal",
    "appraised", "appraiser", "appraises", "apprehend", "apprising",
    "approvals", "approving", "aptitudes", "aquanauts", "aquaplane",
    "aquariums", "aquatints", "aqueducts", "arabesque", "arachnids",
    "arbitrage", "arbitrary", "arbitrate", "arboretum", "arbutuses",
    "archaisms", "archangel", "archdukes", "archenemy", "archetype",
    "architect", "archiving", "archivist", "arduously", "arguments",
    "armadillo", "armaments", "armatured", "armatures", "armchairs",
    "armistice", "aromatics", "arpeggios", "arraigned", "arrangers",
    "arranging", "arresting", "arrogance", "arrogated", "arrogates",
    "arrowhead", "arrowroot", "arsonists", "arthritic", "arthritis",
    "arthropod", "artichoke", "artifacts", "artificer", "artifices",
    "artillery", "artlessly", "ascendant", "ascending", "ascension",
    "ascertain", "ascribing", "asexually", "ashamedly", "asparagus",
    "aspartame", "aspersion", "asphalted", "aspirants", "aspirated",
    "aspirates", "assailant", "assailing", "assassins", "assaulted",
    "assaulter", "assembled", "assembler", "assembles", "assenting",
    "asserting", "assertion", "assertive", "assessing", "assessors",
    "assiduity", "assiduous", "assigning", "assistant", "assisting",
    "associate", "assonance", "assorting", "assuaging", "assurance",
    "assuredly", "asterisks", "asteroids", "asthmatic", "astounded",
    "astrakhan", "astrology", "astronaut", "astronomy", "asymmetry",
    "atavistic", "atheistic", "athletics", "atonality", "atonement",
    "atrocious", "atrophied", "atrophies", "attaching", "attackers",
    "attacking", "attaining", "attempted", "attendant", "attendees",
    "attenders", "attending", "attention", "attentive", "attenuate",
    "attesting", "attitudes", "attorneys", "attracted", "attribute",
    "attrition", "aubergine", "auctioned", "audacious", "audiences",
    "audiotape", "auditions", "augmented", "augustest", "aureoling",
    "austerely", "austerest", "austerity", "authentic", "authoress",
    "authorial", "authoring", "authority", "autistics", "autobahns",
    "autocracy", "autocrats", "autocross", "autograph", "automaker",
    "automated", "automates", "automatic", "automaton", "autopilot",
    "autopsied", "autopsies", "auxiliary", "available", "avalanche",
    "averagely", "averaging", "aversions", "avocation", "avoidable",
    "avoidably", "avoidance", "avuncular", "awakening", "awareness",
    "awesomely", "awestruck", "awfullest", "awfulness", "awkwarder",
    "awkwardly", "axiomatic", "ayatollah", "babushkas", "bacchanal",
    "bachelors", "backaches", "backbench", "backbiter", "backbites",
    "backboard", "backbones", "backcloth", "backcombs", "backdated",
    "backdates", "backdrops", "backfield", "backfired", "backfires",
    "backhands", "backpacks", "backpedal", "backrests", "backrooms",
    "backsides", "backslash", "backslide", "backspace", "backstage",
    "backstops", "backtrack", "backwards", "backwater", "backwoods",
    "backyards", "bacterial", "bacterias", "bacterium", "badgering",
    "badminton", "badmouths", "bagatelle", "bagginess", "baguettes",
    "bailiwick", "balaclava", "balalaika", "balancing", "balconies",
    "balefully", "balladeer", "ballasted", "ballcocks", "ballerina",
    "ballgirls", "ballgowns", "ballistic", "ballooned", "balloting",
    "ballparks", "ballpoint", "ballrooms", "ballsiest", "ballyhoos",
    "balminess", "balsaming", "balusters", "bamboozle", "bandaging",
    "bandannas", "bandoleer", "bandstand", "bandwagon", "bandwidth",
    "banishing", "banisters", "banjoists", "bankbooks", "banknotes",
    "bankrolls", "bankrupts", "bannering", "banqueted", "banquette",
    "bantering", "baptismal", "barbarian", "barbarism", "barbarity",
    "barbarous", "barbecued", "barbecues", "barbering", "barefaced",
    "bargained", "bargainer", "baritones", "barkeeper", "barnacles",
    "barnstorm", "barnyards", "barometer", "baronetcy", "barracked",
    "barracuda", "barraging", "barrenest", "barrettes", "barricade",
    "barrister", "bartender", "bartering", "baseballs", "baseboard",
    "baselines", "basements", "bashfully", "basically", "basilicas",
    "basilisks", "bassinets", "bathhouse", "bathrobes", "bathrooms",
    "bathwater", "battalion", "battening", "batteries", "battering",
    "bawdiness", "bayoneted", "bazillion", "beachhead", "beachwear",
    "beanfeast", "beanpoles", "bearskins", "beastlier", "beatified",
    "beatifies", "beatitude", "beauteous", "beautiful", "beavering",
    "becalming", "beckoning", "becomings", "becquerel", "bedaubing",
    "bedazzled", "bedazzles", "bedecking", "bedfellow", "bedraggle",
    "bedridden", "bedsitter", "bedspread", "bedsteads", "beechnuts",
    "beefcakes", "beefsteak", "beekeeper", "beelining", "beetroots",
    "befalling", "befitting", "befogging", "befouling", "befriends",
    "befuddled", "befuddles", "begetters", "begetting", "beggaring",
    "beginners", "beginning", "begrudged", "begrudges", "beguiling",
    "beheading", "behemoths", "beholders", "beholding", "belatedly",
    "beleaguer", "believers", "believing", "belittled", "belittles",
    "bellicose", "bellowing", "bellyache", "bellyfuls", "belonging",
    "bemoaning", "benchmark", "benefices", "benefited", "benighted",
    "benumbing", "bequeaths", "bereaving", "beryllium", "beseeches",
    "besetting", "besiegers", "besieging", "besotting", "bestirred",
    "bestowals", "bestowing", "bestrides", "bethought", "betokened",
    "betrayals", "betrayers", "betraying", "betrothal", "betrothed",
    "bettering", "beverages", "bewailing", "bewilders", "bewitched",
    "bewitches", "biathlons", "bicameral", "bickering", "bicuspids",
    "bicycling", "bicyclist", "biennials", "bifurcate", "bigamists",
    "bigmouths", "bigotries", "bilabials", "bilateral", "bilingual",
    "billboard", "billeting", "billfolds", "billhooks", "billiards",
    "billionth", "billowier", "billowing", "billycans", "bimonthly",
    "binderies", "binnacles", "binocular", "binomials", "biography",
    "biologist", "biopsying", "biorhythm", "biosphere", "bipartite",
    "birdbaths", "birdbrain", "birdcages", "birdhouse", "birdieing",
    "birthdays", "birthmark", "birthrate", "bisecting", "bisection",
    "bisectors", "bisexuals", "bishopric", "bitchiest", "bitterest",
    "bizarrely", "blabbered", "blackball", "blackbird", "blackened",
    "blackhead", "blackjack", "blacklegs", "blacklist", "blackmail",
    "blackness", "blackouts", "blacktops", "blameless", "blanching",
    "blandness", "blanketed", "blankness", "blarneyed", "blaspheme",
    "blasphemy", "blastoffs", "blatantly", "blathered", "blazoning",
    "bleachers", "bleaching", "bleakness", "bleariest", "blemished",
    "blemishes", "blenching", "blesseder", "blessedly", "blessings",
    "blethered", "blighters", "blighting", "blindfold", "blindness",
    "blindside", "blinkered", "blistered", "blizzards", "blockaded",
    "blockades", "blockages", "blockhead", "blondness", "bloodbath",
    "bloodiest", "bloodless", "bloodline", "bloodshed", "bloodshot",
    "bloodying", "blossomed", "blotchier", "blotching", "blowhards",
    "blowholes", "blowlamps", "blowpipes", "blowtorch", "blowziest",
    "blubbered", "bludgeons", "bluebells", "blueberry", "bluebirds",
    "bluegrass", "bluenoses", "blueprint", "blundered", "blunderer",
    "bluntness", "blurriest", "blustered", "boardroom", "boardwalk",
    "boathouse", "boatloads", "boatswain", "boatyards", "bobolinks",
    "bobsleigh", "bobwhites", "bodacious", "bodyguard", "bodysuits",
    "bohemians", "bolstered", "boltholes", "bombarded", "bombastic",
    "bombshell", "bombsites", "boneheads", "boogieing", "bookcases",
    "bookended", "bookmaker", "bookmarks", "bookplate", "bookshelf",
    "bookshops", "bookstall", "bookstore", "bookworms", "boomerang",
    "boondocks", "boorishly", "bootblack", "bootlaces", "bootstrap",
    "bordellos", "bordering", "boreholes", "borrowers", "borrowing",
    "bossiness", "botanical", "botanists", "bothering", "bottoming",
    "bouffants", "bouillons", "bouldered", "boulevard", "bounciest",
    "boundless", "bounteous", "bountiful", "bourgeois", "boutiques",
    "bowlegged", "bowsprits", "bowstring", "boycotted", "boyfriend",
    "bracelets", "bracketed", "braggarts", "brainiest", "brainless",
    "brainwash", "brainwave", "branching", "brandying", "brashness",
    "brasserie", "brassiere", "brassiest", "brattiest", "brawniest",
    "brazening", "breaching", "breadline", "breakable", "breakages",
    "breakaway", "breakdown", "breakfast", "breakneck", "breakouts",
    "breastfed", "breasting", "breathers", "breathier", "breathing",
    "breeziest", "breweries", "brickbats", "brickwork", "brickyard",
    "bridleway", "briefcase", "briefings", "briefness", "brigadier",
    "brightens", "brightest", "brilliant", "brimstone", "briquette",
    "briskness", "bristlier", "bristling", "brittlest", "broaching",
    "broadcast", "broadened", "broadloom", "broadness", "broadside",
    "brocading", "brochures", "brokerage", "brokering", "bronchial",
    "brothered", "brotherly", "broughams", "brouhahas", "browbeats",
    "browniest", "brownouts", "brunching", "brunettes", "brushwood",
    "brushwork", "brusquely", "brusquest", "brutality", "brutishly",
    "bubblegum", "bubbliest", "buccaneer", "buckboard", "bucketful",
    "bucketing", "buckskins", "buckteeth", "bucktooth", "buckwheat",
    "budgetary", "budgeting", "buffaloed", "buffaloes", "buffering",
    "buffeting", "buggering", "buildings", "bulkheads", "bulkiness",
    "bulldozed", "bulldozer", "bulldozes", "bulletins", "bullfight",
    "bullfinch", "bullfrogs", "bullhorns", "bullrings", "bullshits",
    "bullwhips", "bulrushes", "bumblebee", "bumblings", "bumptious",
    "bungalows", "bungholes", "bunkhouse", "buoyantly", "burdening",
    "burgeoned", "burlesque", "burliness", "burnished", "burnishes",
    "burnooses", "burrowing", "bursaries", "bushiness", "bushwhack",
    "butchered", "butlering", "buttercup", "butterfat", "butterfly",
    "butterier", "butteries", "buttering", "butternut", "buttocked",
    "buttoning", "buzzwords", "bypassing", "byproduct", "bystander",
    "byzantine", "cabdriver", "cablecast", "cablegram", "cacheting",
    "cacophony", "cafeteria", "cafetiere", "calamined", "calamines",
    "calcified", "calcifies", "calcining", "calculate", "calendars",
    "calibrate", "caliphate", "calliopes", "calloused", "callouses",
    "callously", "callowest", "callusing", "calorific", "calumnies",
    "cambering", "camcorder", "camellias", "cameraman", "cameramen",
    "camisoles", "campaigns", "campanile", "campfires", "campsites",
    "campusing", "camshafts", "cancerous", "candidacy", "candidate",
    "candidest", "candlelit", "canisters", "cankering", "cankerous",
    "canneries", "cannibals", "canniness", "cannonade", "cannoning",
    "canoeists", "canonical", "canoodled", "canoodles", "canopying",
    "cantering", "canticles", "canvasing", "canvassed", "canvasser",
    "canvasses", "canyoning", "capablest", "capacious", "capacitor",
    "caparison", "capillary", "capsicums", "capsizing", "capsuling",
    "captaincy", "captained", "captioned", "captivate", "captivity",
    "capturing", "carapaces", "carbonate", "carbuncle", "carcasses",
    "carcinoma", "cardamoms", "cardamons", "cardboard", "cardigans",
    "cardinals", "cardsharp", "careening", "careering", "careerism",
    "careerist", "carefully", "caregiver", "caressing", "caretaker",
    "carillons", "carjacked", "carjacker", "carnation", "carnelian",
    "carnivals", "carnivore", "carousals", "carousels", "carousers",
    "carousing", "carpenter", "carpentry", "carpetbag", "carpeting",
    "carpooled", "carriages", "carryalls", "carrycots", "carryouts",
    "carthorse", "cartilage", "cartloads", "cartooned", "cartridge",
    "cartwheel", "carveries", "caryatids", "cascading", "casebooks",
    "caseloads", "casements", "cashiered", "cashpoint", "casserole",
    "cassettes", "castanets", "castaways", "castigate", "castrated",
    "castrates", "casuistry", "cataclysm", "catacombs", "catalepsy",
    "catalysis", "catalysts", "catalytic", "catamaran", "catapults",
    "cataracts", "catatonic", "catcalled", "catchalls", "catchiest",
    "catchings", "catchment", "catchword", "catechism", "caterings",
    "caterwaul", "catfishes", "catharses", "catharsis", "cathartic",
    "cathedral", "catheters", "catholics", "catnapped", "catteries",
    "cattiness", "cattleman", "cattlemen", "caucusing", "cauldrons",
    "causality", "causation", "causative", "causeless", "causeways",
    "cautioned", "cavalcade", "cavaliers", "cavalries", "caveatted",
    "cavernous", "cavorting", "ceasefire", "ceaseless", "celebrant",
    "celebrate", "celebrity", "celestial", "celibates", "cellmates",
    "cellphone", "cellulars", "cellulite", "celluloid", "cellulose",
    "cementing", "cenotaphs", "censoring", "censuring", "censusing",
    "centenary", "centipede", "centraler", "centrally", "centrists",
    "centuries", "centurion", "cephalics", "cerebrums", "certainer",
    "certainly", "certainty", "certified", "certifies", "certitude",
    "cesareans", "cessation", "cesspools", "cetaceans", "chaffinch",
    "chagrined", "chainsaws", "chairlift", "chalkiest", "challenge",
    "chameleon", "chamomile", "champagne", "champions", "chanciest",
    "chandlers", "chaparral", "chapattis", "chaperons", "chaplains",
    "charabanc", "character", "charbroil", "charcoals", "charities",
    "charlatan", "charmless", "chartered", "charwoman", "charwomen",
    "chastened", "chastised", "chastises", "chasubles", "chatlines",
    "chattered", "chatterer", "chattiest", "chauffeur", "cheapened",
    "cheapness", "checklist", "checkmate", "checkouts", "checkroom",
    "cheekbone", "cheekiest", "cheeriest", "cheerless", "cheesiest",
    "chemicals", "chemistry", "cherished", "cherishes", "chestnuts",
    "chicanery", "chichiest", "chickadee", "chickened", "chickpeas",
    "chickweed", "chicories", "chieftain", "chihuahua", "chilblain",
    "childcare", "childhood", "childless", "childlike", "chilliest",
    "chillings", "chinstrap", "chintzier", "chipboard", "chipmunks",
    "chipolata", "chippings", "chiropody", "chirpiest", "chirruped",
    "chiselers", "chiseling", "chitchats", "chivvying", "chlorides",
    "chocolate", "choirboys", "choosiest", "choppered", "choppiest",
    "chopstick", "chorister", "chortling", "chorusing", "chowdered",
    "christens", "christian", "chromatic", "chronicle", "chrysalis",
    "chubbiest", "chuckhole", "chuckling", "chummiest", "chundered",
    "chunkiest", "chuntered", "churchman", "churchmen", "cicatrice",
    "cigarette", "cigarillo", "cinchonas", "cinctures", "cindering",
    "cinematic", "ciphering", "circadian", "circuited", "circuitry",
    "circulars", "circulate", "cirrhosis", "citations", "citizenry",
    "civilians", "claimants", "clambakes", "clambered", "clammiest",
    "clamorous", "clampdown", "clapboard", "clappered", "clareting",
    "clarified", "clarifies", "clarinets", "clarioned", "classical",
    "classiest", "classless", "classmate", "classroom", "clattered",
    "clavicles", "cleanings", "cleanlier", "cleanness", "cleansers",
    "cleansing", "clearance", "clearings", "clearness", "clearways",
    "cleavages", "clenching", "clergyman", "clergymen", "cleverest",
    "clifftops", "climactic", "climaxing", "clinchers", "clinching",
    "clingfilm", "clingiest", "clinician", "clipboard", "clippings",
    "cloakroom", "clobbered", "clockwise", "clockwork", "cloisters",
    "closeness", "closeouts", "closeting", "clothiers", "cloudiest",
    "cloudless", "cloyingly", "clubbable", "clubhouse", "clumsiest",
    "clunkiest", "clustered", "clutching", "cluttered", "coachload",
    "coachwork", "coagulant", "coagulate", "coalesced", "coalesces",
    "coalfaces", "coalfield", "coalition", "coalmines", "coarsened",
    "coastline", "coatrooms", "coattails", "coauthors", "coaxingly",
    "cobwebbed", "cochineal", "cockatoos", "cockerels", "cockfight",
    "cockiness", "cockroach", "cockscomb", "cocktails", "cocooning",
    "codfishes", "codifying", "codpieces", "coexisted", "coffeepot",
    "cofferdam", "coffining", "cogitated", "cogitates", "cognition",
    "cognitive", "cognomens", "cogwheels", "cohabited", "coherence",
    "coiffured", "coiffures", "coincided", "coincides", "colanders",
    "coliseums", "collapsed", "collapses", "collaring", "collating",
    "collation", "colleague", "collected", "collector", "collegian",
    "colliding", "collision", "collocate", "colluding", "collusion",
    "collusive", "colonials", "colonists", "colonnade", "columbine",
    "columnist", "combatant", "combating", "combative", "combining",
    "comebacks", "comedians", "comedowns", "comeliest", "comforted",
    "comforter", "comically", "commanded", "commander", "commandos",
    "commenced", "commences", "commended", "commented", "commerced",
    "commerces", "commingle", "commissar", "committal", "committed",
    "committee", "commodity", "commodore", "commoners", "commonest",
    "commotion", "communing", "communion", "communism", "communist",
    "community", "commuters", "commuting", "compacted", "compacter",
    "compactly", "compactor", "companies", "companion", "comparing",
    "compassed", "compasses", "compelled", "competent", "competing",
    "compilers", "compiling", "complains", "complaint", "completed",
    "completer", "completes", "complexer", "complexes", "compliant",
    "complying", "component", "comported", "composers", "composing",
    "composite", "composted", "composure", "compounds", "comprised",
    "comprises", "computers", "computing", "comradely", "concavity",
    "concealed", "conceding", "conceited", "conceived", "conceives",
    "concerned", "concerted", "concertos", "concierge", "concisely",
    "concisest", "concision", "conclaves", "concluded", "concludes",
    "concocted", "concordat", "concourse", "concreted", "concretes",
    "concubine", "concurred", "concussed", "concusses", "condemned",
    "condensed", "condenser", "condenses", "condiment", "condition",
    "condoling", "condoning", "conducing", "conducive", "conducted",
    "conductor", "confabbed", "conferred", "conferrer", "confessed",
    "confesses", "confessor", "confidant", "confident", "confiding",
    "configure", "confining", "confirmed", "conflated", "conflates",
    "conflicts", "confluent", "conformed", "confounds", "confronts",
    "confusing", "confusion", "confuting", "congealed", "congenial",
    "congested", "congruent", "congruity", "congruous", "conjoined",
    "conjugate", "conjurers", "conjuring", "connected", "connector",
    "connexion", "connivers", "conniving", "connoting", "connubial",
    "conquered", "conqueror", "conquests", "conscious", "conscript",
    "consensus", "consented", "conserved", "conserves", "considers",
    "consigned", "consignee", "consisted", "consoling", "consonant",
    "consorted", "consortia", "conspired", "conspires", "constable",
    "constancy", "constants", "constrain", "constrict", "construct",
    "construed", "construes", "consulars", "consulate", "consulted",
    "consumers", "consuming", "contacted", "contagion", "contained",
    "container", "contended", "contender", "contented", "contested",
    "continent", "continual", "continued", "continues", "continuum",
    "contorted", "contoured", "contracts", "contrails", "contralto",
    "contrasts", "contrived", "contrives", "contumely", "contusing",
    "contusion", "conundrum", "convector", "conveners", "convening",
    "convented", "converged", "converges", "conversed", "converses",
    "converted", "converter", "convexing", "convexity", "conveying",
    "conveyors", "convicted", "convinced", "convinces", "convivial",
    "convoking", "convoying", "convulsed", "convulses", "cookbooks",
    "cookeries", "cookhouse", "cooperate", "coopering", "copiously",
    "copulated", "copulates", "copyright", "coquetted", "coquettes",
    "cordially", "cordoning", "corduroys", "coriander", "corkscrew",
    "cormorant", "cornballs", "cornbread", "corncrake", "cornering",
    "cornfield", "cornflour", "cornrowed", "cornstalk", "corollary",
    "corporals", "corporate", "corporeal", "corpulent", "corpuscle",
    "corralled", "corrected", "correcter", "correctly", "corrector",
    "correlate", "corridors", "corroding", "corrosion", "corrosive",
    "corrugate", "corrupted", "corrupter", "corruptly", "corseting",
    "cortisone", "coruscate", "cosigners", "cosigning", "cosmetics",
    "cosmogony", "cosmology", "cosmonaut", "cosponsor", "cosseting",
    "cossetted", "costarred", "costliest", "costumers", "costuming",
    "cotillion", "cottagers", "cottaging", "cottoning", "cotyledon",
    "couchette", "countable", "countably", "countdown", "countered",
    "countless", "countries", "couplings", "courgette", "couriered",
    "courteous", "courtesan", "courtiers", "courtlier", "courtroom",
    "courtship", "courtyard", "couturier", "covenants", "coveralls",
    "coverings", "coverlets", "cowardice", "coworkers", "coxswains",
    "crabbiest", "crabgrass", "crackdown", "cracklier", "crackling",
    "crackpots", "craftiest", "craftsman", "craftsmen", "craggiest",
    "cranberry", "crankcase", "crankiest", "crannying", "crappiest",
    "crassness", "cratering", "cravatted", "crayoning", "craziness",
    "creakiest", "creamiest", "creations", "creatures", "credenzas",
    "crediting", "creditors", "credulity", "credulous", "creepiest",
    "cremating", "cremation", "crematory", "creosoted", "creosotes",
    "crescendo", "crescents", "cretinous", "crevasses", "cricketer",
    "criminals", "crimsoned", "crinklier", "crinklies", "crinkling",
    "crinoline", "crippling", "crispiest", "crispness", "criterion",
    "criticism", "critiqued", "critiques", "crocheted", "crocodile",
    "croissant", "crookeder", "crookedly", "croquette", "crossbars",
    "crossbeam", "crossbows", "crossbred", "crossfire", "crossings",
    "crossness", "crossover", "crossroad", "crosstown", "crosswalk",
    "crosswind", "crosswise", "crossword", "crotchets", "crotchety",
    "crouching", "croupiers", "croupiest", "crucially", "crucibles",
    "crucified", "crucifies", "cruciform", "cruddiest", "crudeness",
    "crudities", "cruelties", "crumbiest", "crumblier", "crumblies",
    "crumbling", "crummiest", "crumpling", "crunchier", "crunching",
    "crusaders", "crusading", "crustiest", "crybabies", "cryogenic",
    "cubbyhole", "cuckolded", "cucumbers", "cuddliest", "culminate",
    "cultivate", "culturing", "cuneiform", "cunninger", "cunningly",
    "cupboards", "cupolaing", "curatives", "curiosity", "curiouser",
    "curiously", "curlicued", "curlicues", "curliness", "currently",
    "curricula", "currycomb", "cursedest", "cursorily", "cursoring",
    "curtailed", "curtained", "curtsying", "curvature", "cushioned",
    "cuspidors", "custodial", "custodian", "customary", "customers",
    "cutesiest", "cutlasses", "cutthroat", "cyberpunk", "cyclamens",
    "cyclotron", "cylinders", "cynically", "cynosures", "cypresses",
    "cytoplasm", "dachshund", "dactylics", "daffodils", "daintiest",
    "daiquiris", "dairymaid", "dalliance", "dalmatian", "damasking",
    "damnation", "damnedest", "dampening", "dandelion", "dandering",
    "dandified", "dandifies", "dangering", "dangerous", "dapperest",
    "daredevil", "darkening", "darkliest", "darkrooms", "darnedest",
    "dartboard", "dashboard", "dashingly", "dastardly", "databased",
    "databases", "datebooks", "datelined", "datelines", "daughters",
    "dauntless", "davenport", "daydreams", "daylights", "dazzlings",
    "deaconess", "deadbeats", "deadbolts", "deadening", "deadheads",
    "deadliest", "deadlined", "deadlines", "deadlocks", "deafening",
    "deaneries", "deathbeds", "deathblow", "deathless", "deathlier",
    "deathlike", "deathtrap", "debarking", "debarment", "debarring",
    "debatable", "debauched", "debauchee", "debauches", "debenture",
    "debriefed", "debuggers", "debugging", "debunking", "decadence",
    "decadents", "decamping", "decanters", "decanting", "decathlon",
    "deceasing", "decedents", "deceitful", "deceivers", "deceiving",
    "decencies", "decentest", "deception", "deceptive", "decidedly",
    "deciduous", "decimated", "decimates", "deciphers", "decisions",
    "deckchair", "deckhands", "declaimed", "declaring", "declining",
    "declivity", "decompose", "decontrol", "decorated", "decorates",
    "decorator", "decoupled", "decouples", "decreased", "decreases",
    "decreeing", "dedicated", "dedicates", "deducible", "deducting",
    "deduction", "deductive", "deejaying", "deepening", "defaulted",
    "defaulter", "defeating", "defeatism", "defeatist", "defecated",
    "defecates", "defecting", "defection", "defective", "defectors",
    "defendant", "defenders", "defending", "deference", "deferment",
    "deferrals", "deferring", "defiantly", "deficient", "definable",
    "deflating", "deflation", "deflected", "deflector", "deflowers",
    "defoggers", "defogging", "defoliant", "defoliate", "deforests",
    "deforming", "deformity", "defrauded", "defraying", "defrocked",
    "defrosted", "defroster", "degrading", "dehydrate", "dejecting",
    "dejection", "delegated", "delegates", "deletions", "delicious",
    "delighted", "delimited", "delimiter", "delineate", "delirious",
    "deliriums", "delivered", "deliverer", "delousing", "delusions",
    "demagogic", "demagogue", "demanding", "demarcate", "demeaning",
    "demerited", "demijohns", "demisters", "demisting", "demitasse",
    "demobbing", "democracy", "democrats", "demotions", "demurring",
    "demystify", "denatured", "denatures", "dendrites", "denigrate",
    "denounced", "denounces", "denseness", "densities", "dentistry",
    "deodorant", "departing", "departure", "depending", "depicting",
    "depiction", "deplaning", "depleting", "depletion", "deploring",
    "deploying", "deportees", "deporting", "deposited", "depositor",
    "depraving", "depravity", "deprecate", "depressed", "depresses",
    "depriving", "deprogram", "derailing", "deranging", "derelicts",
    "derivable", "derogated", "derogates", "derringer", "dervishes",
    "descaling", "descanted", "descended", "descender", "described",
    "describes", "descrying", "desecrate", "deselects", "deserters",
    "deserting", "desertion", "deserving", "desiccate", "designate",
    "designers", "designing", "desirable", "desirably", "desisting",
    "deskilled", "desolated", "desolates", "despaired", "desperado",
    "desperate", "despising", "despoiled", "despotism", "destinies",
    "destining", "destitute", "destroyed", "destroyer", "destructs",
    "desultory", "detaching", "detailing", "detainees", "detaining",
    "detecting", "detection", "detective", "detectors", "detention",
    "detergent", "determine", "deterrent", "deterring", "detesting",
    "dethroned", "dethrones", "detonated", "detonates", "detonator",
    "detouring", "detracted", "detractor", "detriment", "deuterium",
    "devaluing", "devastate", "developed", "developer", "deviating",
    "deviation", "devilment", "devilries", "deviously", "devolving",
    "devotedly", "devotions", "devouring", "devoutest", "dexterity",
    "dexterous", "diabetics", "diacritic", "diagnosed", "diagnoses",
    "diagnosis", "diagonals", "dialectal", "dialectic", "diameters",
    "diapering", "diaphragm", "diastolic", "diatribes", "dichotomy",
    "dickering", "dickheads", "dickybird", "dictating", "dictation",
    "dictators", "didactics", "dieseling", "dietaries", "dietetics",
    "dietitian", "different", "differing", "difficult", "diffident",
    "diffracts", "diffusely", "diffusing", "diffusion", "digesting",
    "digestion", "digestive", "digitalis", "digitally", "dignified",
    "dignifies", "dignitary", "dignities", "digressed", "digresses",
    "diligence", "dilutions", "dimension", "dimwitted", "dinginess",
    "dinnering", "dinosaurs", "diocesans", "diphthong", "diplomacy",
    "diplomata", "diplomats", "dipsticks", "directest", "directing",
    "direction", "directive", "directors", "directory", "dirigible",
    "dirtiness", "disabling", "disabused", "disabuses", "disaffect",
    "disagreed", "disagrees", "disallows", "disappear", "disarming",
    "disarrays", "disasters", "disavowal", "disavowed", "disbanded",
    "disbarred", "disbelief", "disbursed", "disburses", "discarded",
    "discerned", "discharge", "disciples", "disclaims", "disclosed",
    "discloses", "discomfit", "discorded", "discounts", "discourse",
    "discovers", "discovery", "discredit", "discussed", "discusses",
    "disdained", "disembark", "disembody", "disengage", "disfigure",
    "disgorged", "disgorges", "disgraced", "disgraces", "disguised",
    "disguises", "disgusted", "dishcloth", "dishevels", "dishonest",
    "dishtowel", "dishwater", "disinfect", "disinters", "disjoints",
    "diskettes", "disliking", "dislocate", "dislodged", "dislodges",
    "dismalest", "dismantle", "dismaying", "dismember", "dismissal",
    "dismissed", "dismisses", "dismounts", "disobeyed", "disoblige",
    "disorders", "disorient", "disowning", "disparage", "disparate",
    "disparity", "dispelled", "dispensed", "dispenser", "dispenses",
    "dispersal", "dispersed", "disperses", "dispirits", "displaced",
    "displaces", "displayed", "displease", "disported", "disposals",
    "disposing", "disproved", "disproves", "disputant", "disputing",
    "disquiets", "disregard", "disrepair", "disrepute", "disrobing",
    "disrupted", "dissected", "dissemble", "dissented", "dissenter",
    "dissident", "dissipate", "dissolute", "dissolved", "dissolves",
    "dissonant", "dissuaded", "dissuades", "distanced", "distances",
    "distantly", "distastes", "distemper", "distended", "distilled",
    "distiller", "distorted", "distorter", "distracts", "districts",
    "distrusts", "disturbed", "disunited", "disunites", "ditherers",
    "dithering", "diuretics", "diurnally", "divergent", "diverging",
    "diversely", "diversify", "diversion", "diversity", "diverting",
    "divesting", "dividends", "divisible", "divisions", "divorcing",
    "divulging", "dixieland", "dizziness", "dobermans", "docketing",
    "docklands", "dockyards", "doctorate", "doctoring", "doctrinal",
    "doctrines", "docudrama", "documents", "doddering", "dogfights",
    "dogfishes", "dogfought", "doggonest", "doggoning", "doghouses",
    "dogmatics", "dogmatism", "dogmatist", "dolefully", "dollhouse",
    "dolloping", "domestics", "domiciled", "domiciles", "dominance",
    "dominants", "dominated", "dominates", "domineers", "dominions",
    "donations", "doohickey", "doomsayer", "doomsters", "doorbells",
    "doorjambs", "doorknobs", "doorposts", "doorsteps", "doorstops",
    "dormitory", "dosshouse", "doubloons", "doubtless", "doughiest",
    "doughtier", "dovecotes", "dovetails", "dowdiness", "downbeats",
    "downfalls", "downgrade", "downhills", "downloads", "downplays",
    "downpours", "downright", "downriver", "downscale", "downshift",
    "downsized", "downsizes", "downspout", "downstage", "downstate",
    "downswing", "downtrend", "downturns", "downwards", "draconian",
    "dragonfly", "dragooned", "dragsters", "drainpipe", "dramatics",
    "dramatist", "draperies", "drawbacks", "dreamboat", "dreamiest",
    "dreamland", "dreamless", "dreamlike", "dreariest", "drenching",
    "dressiest", "dressings", "dribblers", "dribbling", "driftnets",
    "driftwood", "drinkable", "drinkings", "drippiest", "drippings",
    "driveways", "drizzlier", "drizzling", "drollness", "dromedary",
    "droopiest", "droppings", "drownings", "drowsiest", "drubbings",
    "druggists", "drugstore", "drumbeats", "drumstick", "drunkards",
    "drunkenly", "drywalled", "dubiously", "duchesses", "duckbills",
    "ducklings", "ductility", "dulcimers", "dumbbells", "dumbfound",
    "dumplings", "dungarees", "dungeoned", "duopolies", "duplicate",
    "duplicity", "dustcarts", "dustiness", "dustsheet", "dutifully",
    "dwellings", "dwindling", "dynamical", "dynamited", "dynamites",
    "dynasties", "dysentery", "dyslexics", "dyspepsia", "dyspeptic",
    "eagerness", "earliness", "earmarked", "earnestly", "earphones",
    "earpieces", "earthiest", "earthlier", "earthling", "earthward",
    "earthwork", "earthworm", "eastbound", "easterner", "eastwards",
    "easygoing", "eavesdrop", "ebullient", "eccentric", "eclectics",
    "eclipsing", "ecologist", "economics", "economies", "economist",
    "ecosystem", "ecstasies", "edelweiss", "edibility", "editorial",
    "educables", "educating", "education", "educative", "educators",
    "effecting", "effective", "effectual", "efficient", "effluents",
    "effulgent", "effusions", "eggbeater", "eggplants", "eggshells",
    "eglantine", "egomaniac", "egotistic", "egregious", "eiderdown",
    "eighteens", "eightieth", "ejaculate", "ejections", "elaborate",
    "elbowroom", "elections", "electives", "electoral", "electrics",
    "electrify", "electrode", "electrons", "elegantly", "elemental",
    "elephants", "elevating", "elevation", "elevators", "elevenses",
    "elevenths", "eliciting", "eliminate", "elocution", "elongated",
    "elongates", "elopement", "eloquence", "elsewhere", "elucidate",
    "elusively", "emaciated", "emaciates", "emanating", "emanation",
    "embalmers", "embalming", "embargoed", "embargoes", "embarking",
    "embarrass", "embassies", "embattled", "embedding", "embellish",
    "embezzled", "embezzler", "embezzles", "embitters", "emblazons",
    "embodying", "emboldens", "embolisms", "embossing", "embracing",
    "embroider", "embroiled", "embryonic", "emergence", "emergency",
    "emigrants", "emigrated", "emigrates", "eminences", "eminently",
    "emissions", "emollient", "emolument", "emotional", "emotively",
    "emphysema", "empirical", "employees", "employers", "employing",
    "emporiums", "empowered", "empresses", "emptiness", "emulating",
    "emulation", "emulators", "emulsions", "enactment", "encamping",
    "enchanted", "enchanter", "enchilada", "encircled", "encircles",
    "enclosing", "enclosure", "encompass", "encounter", "encourage",
    "encrusted", "encrypted", "encumbers", "endangers", "endearing",
    "endlessly", "endocrine", "endorphin", "endorsers", "endorsing",
    "endowment", "endpoints", "endurable", "endurance", "energetic",
    "enervated", "enervates", "enfeebled", "enfeebles", "enfolding",
    "enforcers", "enforcing", "engenders", "engineers", "engorging",
    "engravers", "engraving", "engrossed", "engrosses", "engulfing",
    "enhancers", "enhancing", "enigmatic", "enjoining", "enjoyable",
    "enjoyably", "enjoyment", "enlargers", "enlarging", "enlighten",
    "enlistees", "enlisting", "enlivened", "enmeshing", "ennobling",
    "enquirers", "enrapture", "enriching", "enrolling", "ensconced",
    "ensconces", "ensembles", "enshrined", "enshrines", "enshrouds",
    "enslaving", "ensnaring", "entailing", "entangled", "entangles",
    "enteritis", "entertain", "enthroned", "enthrones", "enthusing",
    "enticings", "entitling", "entombing", "entourage", "entranced",
    "entrances", "entrapped", "entreated", "entrusted", "entryways",
    "entwining", "enumerate", "enunciate", "enveloped", "envelopes",
    "enviously", "envisaged", "envisages", "envisions", "ephemeral",
    "epicurean", "epidemics", "epidermal", "epidermis", "epidurals",
    "epigraphs", "epileptic", "epilogued", "epilogues", "episcopal",
    "eponymous", "equations", "equerries", "equinoxes", "equipages",
    "equipment", "equipoise", "equipping", "equitable", "equitably",
    "equivocal", "eradicate", "erections", "erectness", "ergonomic",
    "erogenous", "eroticism", "erroneous", "erstwhile", "eruditely",
    "erudition", "eruptions", "escalated", "escalates", "escalator",
    "escalopes", "escapades", "escapists", "escaroles", "eschewing",
    "escorting", "espionage", "esplanade", "espousing", "espressos",
    "essayists", "essential", "establish", "esteeming", "estimable",
    "estimated", "estimates", "estimator", "estranged", "estranges",
    "estuaries", "eternally", "ethically", "ethnicity", "ethnology",
    "etiolated", "etiquette", "etymology", "eucalypti", "eulogists",
    "euphemism", "evacuated", "evacuates", "evaluated", "evaluates",
    "evaporate", "evasively", "eventuate", "everglade", "evergreen",
    "everybody", "evictions", "evidenced", "evidences", "evidently",
    "evildoers", "evocation", "evocative", "evolution", "exactness",
    "examiners", "examining", "exampling", "excavated", "excavates",
    "excavator", "exceeding", "excellent", "excelling", "excepting",
    "exception", "excerpted", "excessive", "exchanged", "exchanges",
    "exchequer", "excisions", "excitable", "excitedly", "exclaimed",
    "excluding", "exclusion", "exclusive", "excoriate", "excrement",
    "excreting", "excretion", "excretory", "exculpate", "excursion",
    "excusable", "execrable", "execrably", "execrated", "execrates",
    "executing", "execution", "executive", "executors", "executrix",
    "exemplars", "exemplary", "exemplify", "exempting", "exemption",
    "exercised", "exercises", "exertions", "exfoliate", "exhausted",
    "exhibited", "exhibitor", "exhorting", "existence", "exonerate",
    "exorcised", "exorcises", "exorcisms", "exorcists", "exoticism",
    "expanding", "expansion", "expansive", "expatiate", "expectant",
    "expecting", "expedient", "expedited", "expediter", "expedites",
    "expelling", "expending", "expensive", "expertise", "expiating",
    "expiation", "explained", "expletive", "explicate", "explicits",
    "exploding", "exploited", "exploiter", "explorers", "exploring",
    "explosion", "explosive", "exponents", "exporters", "exporting",
    "exposures", "expounded", "expressed", "expresses", "expressly",
    "expulsion", "expunging", "expurgate", "exquisite", "extempore",
    "extending", "extension", "extensive", "extenuate", "exteriors",
    "externals", "extincted", "extirpate", "extolling", "extorting",
    "extortion", "extracted", "extractor", "extradite", "extremely",
    "extremest", "extremism", "extremist", "extremity", "extricate",
    "extrinsic", "extrovert", "extruding", "extrusion", "exuberant",
    "eyeballed", "eyelashes", "eyeliners", "eyepieces", "eyestrain",
    "fabricate", "facecloth", "facetious", "facsimile", "factional",
    "factorial", "factories", "factoring", "factotums", "factually",
    "faculties", "faddiness", "faintness", "fairyland", "faithfuls",
    "faithless", "falconers", "fallacies", "fallowing", "falsehood",
    "falseness", "falsettos", "falsified", "falsifies", "falsities",
    "faltering", "familiars", "famishing", "fanatical", "fanciable",
    "fanciness", "fandangos", "fanlights", "fantasias", "fantasied",
    "fantasies", "fantasist", "fantastic", "farewells", "farmhands",
    "farmhouse", "farmlands", "farmstead", "farmyards", "farragoes",
    "farrowing", "farthings", "fascinate", "fashioned", "fastballs",
    "fasteners", "fastening", "fatalists", "fatefully", "fatheaded",
    "fathering", "fathoming", "fatiguing", "fattening", "fatuously",
    "faultiest", "faultless", "fearfully", "feathered", "featuring",
    "fecundity", "federally", "federated", "federates", "feelingly",
    "feistiest", "felonious", "feminines", "feminists", "fermented",
    "ferocious", "ferreting", "ferryboat", "fertility", "fervently",
    "festering", "festivals", "festively", "festivity", "festooned",
    "fetishism", "fetishist", "fettering", "feudalism", "fictional",
    "fiddliest", "fidgeting", "fiduciary", "fieldsman", "fieldsmen",
    "fieldwork", "fieriness", "fifteenth", "fiftieths", "fightback",
    "figurines", "filaments", "filigreed", "filigrees", "filleting",
    "filliping", "filmmaker", "filmstrip", "filtering", "filthiest",
    "filtrated", "filtrates", "finaglers", "finagling", "finalists",
    "financial", "financier", "financing", "finessing", "fingering",
    "fingertip", "finickier", "finishers", "finishing", "fireballs",
    "firebombs", "firebrand", "firebreak", "firebrick", "firefight",
    "fireflies", "fireguard", "firehouse", "firelight", "fireplace",
    "fireplugs", "firepower", "fireproof", "firesides", "firestorm",
    "firetraps", "firewalls", "firewater", "fireworks", "firmament",
    "firstborn", "firsthand", "fishbowls", "fishcakes", "fisheries",
    "fisherman", "fishermen", "fishhooks", "fishtails", "fishwives",
    "fittingly", "fixations", "fixatives", "flabbiest", "flagellum",
    "flagpoles", "flagships", "flagstaff", "flagstone", "flakiness",
    "flambeing", "flamencos", "flamingos", "flammable", "flapjacks",
    "flashback", "flashbulb", "flashcard", "flashguns", "flashiest",
    "flatboats", "flatfoots", "flatirons", "flatmates", "flattened",
    "flattered", "flatterer", "flatulent", "flaunting", "flautists",
    "fleabites", "fledgling", "fleeciest", "fleetness", "fleshiest",
    "fleshlier", "fleshpots", "flickered", "flightier", "flimflams",
    "flimsiest", "flinching", "flintiest", "flintlock", "flippancy",
    "floggings", "floodgate", "flophouse", "floppiest", "flotation",
    "flotillas", "flouncing", "flounders", "flouriest", "flowerbed",
    "flowerier", "flowering", "flowerpot", "fluctuate", "fluffiest",
    "flummoxed", "flummoxes", "fluoresce", "fluorides", "flurrying",
    "flustered", "fluttered", "flyleaves", "flypapers", "flysheets",
    "flyspecks", "flyweight", "flywheels", "fogginess", "folksiest",
    "follicles", "followers", "following", "fomenting", "foodstuff",
    "fooleries", "foolhardy", "foolisher", "foolishly", "foolproof",
    "footballs", "footfalls", "foothills", "footholds", "footloose",
    "footnoted", "footnotes", "footpaths", "footplate", "footprint",
    "footrests", "footsteps", "footstool", "forbidden", "forearmed",
    "forebears", "foreboded", "forebodes", "forecasts", "foreclose",
    "forecourt", "foredooms", "forefront", "foregoing", "forehands",
    "foreheads", "foreigner", "forelocks", "foremasts", "forenames",
    "forenoons", "forensics", "foresails", "foreshore", "foresight",
    "foreskins", "forestall", "foresters", "foresting", "foretaste",
    "foretells", "forewarns", "forewoman", "forewomen", "forewords",
    "forfeited", "forgather", "forgeries", "forgetful", "forgiving",
    "forgotten", "forklifts", "forlorner", "forlornly", "formalism",
    "formalist", "formality", "formation", "formative", "formatted",
    "formulaic", "formulate", "fornicate", "forsaking", "forswears",
    "forsythia", "forthwith", "fortieths", "fortified", "fortifies",
    "fortitude", "fortnight", "fortunate", "forwarded", "forwarder",
    "fostering", "foundered", "foundling", "foundries", "fountains",
    "fourscore", "foursomes", "fourteens", "foxgloves", "foxhounds",
    "fractions", "fractious", "fractured", "fractures", "fragility",
    "fragments", "fragrance", "frailties", "framework", "franchise",
    "frankness", "fraternal", "fraudster", "fraughted", "frazzling",
    "freakiest", "freckling", "freebased", "freebases", "freeholds",
    "freelance", "freeloads", "freephone", "freestyle", "freewheel",
    "freighted", "freighter", "frequency", "frequents", "freshened",
    "freshness", "fretfully", "fricassee", "fricative", "frictions",
    "frightens", "frightful", "frighting", "frigidity", "frilliest",
    "friskiest", "frittered", "frivolity", "frivolous", "frizziest",
    "frizzling", "frogmarch", "frogspawn", "frolicked", "frontages",
    "frontally", "frontiers", "frostbite", "frostiest", "frothiest",
    "frowziest", "frugality", "fruitcake", "fruiterer", "fruitiest",
    "fruitless", "frumpiest", "frustrate", "fuckheads", "fugitives",
    "fulfilled", "fullbacks", "fulminate", "fulsomely", "fumigated",
    "fumigates", "fumigator", "functions", "fungicide", "funicular",
    "funniness", "furbished", "furbishes", "furiously", "furloughs",
    "furnished", "furnishes", "furniture", "furrowing", "furthered",
    "furtively", "fuselages", "fusiliers", "fusillade", "fussiness",
    "futurists", "fuzziness", "gabardine", "gadabouts", "gainfully",
    "gallantly", "gallantry", "galleried", "galleries", "gallivant",
    "galloping", "gallstone", "galoshing", "galumphed", "gamecocks",
    "gangplank", "gangrened", "gangrenes", "gangsters", "gaolbirds",
    "gaolbreak", "garbanzos", "gardeners", "gardenias", "gardening",
    "gargoyles", "garlanded", "garlicked", "garnering", "garnished",
    "garnishee", "garnishes", "garrisons", "garroting", "garrulity",
    "garrulous", "gasholder", "gaslights", "gasometer", "gastritis",
    "gatecrash", "gatehouse", "gateposts", "gatherers", "gathering",
    "gaudiness", "gauntlets", "gauntness", "gawkiness", "gazetteer",
    "gazetting", "gazillion", "gazumping", "gearboxes", "gearshift",
    "gearwheel", "gelignite", "gemstones", "gendarmes", "genealogy",
    "generally", "generated", "generates", "generator", "geniality",
    "genitalia", "genitives", "genocidal", "genocides", "genteeler",
    "genteelly", "gentility", "gentleman", "gentlemen", "genuflect",
    "genuinely", "geodesics", "geography", "geologies", "geologist",
    "geometric", "geraniums", "geriatric", "germanium", "germicide",
    "germinate", "gestating", "gestation", "gesturing", "ghastlier",
    "ghostlier", "gibbering", "gibberish", "gibbeting", "giddiness",
    "gigabytes", "giggliest", "gimcracks", "gimleting", "gimmickry",
    "gingering", "ginormous", "girlhoods", "girlishly", "giveaways",
    "glacially", "gladdened", "gladiator", "gladiolas", "gladiolus",
    "gladliest", "glamorous", "glandular", "glaringly", "glassfuls",
    "glassiest", "glassware", "gleamings", "gleefully", "glimmered",
    "glimpsing", "glissandi", "glissando", "glistened", "glittered",
    "glitziest", "gloamings", "gloomiest", "glorified", "glorifies",
    "glossiest", "glottises", "glowering", "glowingly", "glowworms",
    "glutinous", "gnarliest", "goalmouth", "goalposts", "goatherds",
    "goatskins", "goddammit", "goddesses", "godfather", "godlessly",
    "godliness", "godmother", "godparent", "goldbrick", "goldenest",
    "goldenrod", "goldfield", "goldfinch", "goldmines", "goldsmith",
    "golliwogs", "gondolier", "goodliest", "goodnight", "goosestep",
    "goulashes", "gourmands", "governess", "governing", "governors",
    "grabbiest", "graceless", "gradation", "gradients", "gradually",
    "graduated", "graduates", "grainiest", "granaries", "grandaddy",
    "granddads", "grandiose", "grandness", "grandsons", "granulate",
    "grapevine", "graphical", "grappling", "grassiest", "grassland",
    "gratified", "gratifies", "gratitude", "graveside", "graveyard",
    "gravitate", "graybeard", "greasiest", "greatcoat", "greatness",
    "greediest", "greenback", "greengage", "greenhorn", "greenness",
    "greetings", "grenadier", "grenadine", "greyhound", "gridirons",
    "gridlocks", "grievance", "grillings", "grimacing", "grisliest",
    "gristlier", "grittiest", "grizzlier", "grizzlies", "grizzling",
    "groceries", "groggiest", "groomsman", "groomsmen", "grooviest",
    "grosbeaks", "grossness", "grotesque", "grottiest", "grouchier",
    "grouching", "grounders", "groundhog", "grounding", "groundnut",
    "groupings", "grubbiest", "grubstake", "grudgings", "gruesomer",
    "gruffness", "grumblers", "grumbling", "grumpiest", "grungiest",
    "guacamole", "guarantee", "guarantor", "guardedly", "guardians",
    "guardrail", "guardroom", "guardsman", "guardsmen", "guerrilla",
    "guessable", "guesswork", "guestroom", "guffawing", "guidebook",
    "guideline", "guildhall", "guileless", "guillemot", "guiltiest",
    "guiltless", "guitarist", "gunfights", "gunfought", "gunnysack",
    "gunpowder", "gunrunner", "gunsmiths", "gushingly", "gusseting",
    "gustatory", "guttering", "gutturals", "gymkhanas", "gymnasium",
    "gymnastic", "gyrations", "gyroscope", "habitable", "habituals",
    "habituate", "haciendas", "hackneyed", "hacksawed", "hailstone",
    "hailstorm", "hairbands", "hairbrush", "hairdryer", "hairgrips",
    "hairiness", "hairlines", "hairpiece", "hairspray", "hairstyle",
    "halfbacks", "halfpence", "halfpenny", "halftimes", "halftones",
    "halitosis", "hallmarks", "hallowing", "haltering", "haltingly",
    "hamburger", "hammering", "hampering", "hamstring", "hamstrung",
    "handballs", "handbills", "handbooks", "handbrake", "handcarts",
    "handcraft", "handcuffs", "handholds", "handicaps", "handiness",
    "handiwork", "handlebar", "handmaids", "handovers", "handpicks",
    "handrails", "handshake", "handsomer", "handstand", "hangnails",
    "hangovers", "hankering", "haphazard", "happening", "happiness",
    "harangued", "harangues", "harassing", "harbinger", "hardbacks",
    "hardboard", "hardcover", "hardeners", "hardening", "hardiness",
    "hardliner", "hardships", "hardwoods", "harebells", "harlequin",
    "harmfully", "harmonica", "harmonics", "harmonies", "harnessed",
    "harnesses", "harpooned", "harridans", "harrowing", "harrumphs",
    "harshness", "harvested", "harvester", "hastening", "hastiness",
    "hatchback", "hatchways", "hatefully", "hatstands", "haughtier",
    "haughtily", "haunching", "haversack", "hawthorns", "haymaking",
    "haystacks", "hazarding", "hazardous", "hazelnuts", "headaches",
    "headbands", "headboard", "headbutts", "headcases", "headcount",
    "headdress", "headfirst", "headhunts", "headlamps", "headlands",
    "headlight", "headlined", "headliner", "headlines", "headlocks",
    "headphone", "headrests", "headscarf", "headships", "headstone",
    "headwinds", "headwords", "healthful", "healthier", "healthily",
    "hearkened", "heartache", "heartbeat", "heartburn", "heartened",
    "heartfelt", "hearthrug", "heartiest", "heartland", "heartless",
    "heartsick", "heatproof", "heatwaves", "heaviness", "hectoring",
    "hedgehogs", "hedgerows", "hedonists", "heehawing", "hegemonic",
    "heightens", "heinously", "heiresses", "heirlooms", "heliports",
    "hellebore", "hellholes", "hellishly", "helmeting", "helpfully",
    "helplines", "helpmates", "hemstitch", "henpecked", "hepatitis",
    "heptagons", "heralding", "herbalist", "herbicide", "herbivore",
    "herculean", "hereabout", "hereafter", "heretical", "heritages",
    "hermetics", "hermitage", "hesitancy", "hesitated", "hesitates",
    "heterodox", "heuristic", "hexagonal", "hexameter", "hibernate",
    "hickories", "hideaways", "hidebound", "hideously", "hierarchy",
    "highballs", "highbrows", "highchair", "highlands", "highlight",
    "hightails", "hijackers", "hijacking", "hilarious", "hillbilly",
    "hillsides", "hindering", "hindrance", "hindsight", "hirelings",
    "histamine", "histogram", "historian", "histories", "hitchhike",
    "hoardings", "hoarfrost", "hoariness", "hobbyists", "hobgoblin",
    "hobnailed", "hobnobbed", "hockshops", "hogsheads", "holdovers",
    "holidayed", "hollering", "hollowest", "hollowing", "hollyhock",
    "holocaust", "holograms", "holograph", "holstered", "homegrown",
    "homelands", "homeliest", "homemaker", "homeowner", "homepages",
    "homerooms", "homestead", "hometowns", "homeyness", "homicidal",
    "homicides", "homograph", "homophone", "honestest", "honeybees",
    "honeycomb", "honeydews", "honeymoon", "honeypots", "honorific",
    "hoodooing", "hoodwinks", "hookworms", "hooligans", "hooraying",
    "hoovering", "hopefully", "hopscotch", "hornpipes", "horoscope",
    "horribles", "horrified", "horrifies", "horseback", "horsehair",
    "horsehide", "horseplay", "horseshit", "horseshoe", "horsetail",
    "horsewhip", "hosepipes", "hospitals", "hostelers", "hosteling",
    "hostessed", "hostesses", "hostilely", "hostility", "hoteliers",
    "hotfooted", "hotheaded", "hothoused", "hothouses", "hotplates",
    "hourglass", "houseboat", "houseboys", "housecoat", "household",
    "housemaid", "housemate", "houseroom", "housetops", "housewife",
    "housework", "howitzers", "howsoever", "hucksters", "humanists",
    "humankind", "humanness", "humanoids", "humblings", "humbugged",
    "humdinger", "humiliate", "hummocked", "humongous", "humorists",
    "humpbacks", "hunchback", "hundredth", "hungering", "hungriest",
    "hunkering", "hurricane", "hurriedly", "hurtfully", "husbanded",
    "husbandry", "huskiness", "hyacinths", "hydrangea", "hydrating",
    "hydration", "hydraulic", "hydrofoil", "hydrology", "hygienics",
    "hygienist", "hyperbola", "hyperbole", "hyperlink", "hypertext",
    "hyphenate", "hyphening", "hypnotics", "hypnotism", "hypnotist",
    "hypocrisy", "hypocrite", "hysterics", "ibuprofen", "idealists",
    "identical", "identikit", "ideograms", "ideograph", "ideologue",
    "idiomatic", "idolaters", "ignitions", "ignoramus", "ignorance",
    "ignorants", "illegally", "illegible", "illegibly", "illiberal",
    "illicitly", "illnesses", "illogical", "illumined", "illumines",
    "illusions", "imaginary", "imagining", "imbalance", "imbeciles",
    "imbecilic", "imbroglio", "imitating", "imitation", "imitative",
    "imitators", "immanence", "immatures", "immediacy", "immediate",
    "immensely", "immensest", "immensity", "immersing", "immersion",
    "immigrant", "immigrate", "imminence", "immodesty", "immolated",
    "immolates", "immorally", "immortals", "immovable", "immovably",
    "immutable", "immutably", "impacting", "impairing", "impartial",
    "imparting", "impassive", "impatient", "impeached", "impeaches",
    "impedance", "impelling", "impending", "imperfect", "imperials",
    "imperious", "impetuous", "impetuses", "impieties", "impinging",
    "impiously", "implanted", "implement", "implicate", "imploding",
    "imploring", "implosion", "impolitic", "important", "importers",
    "importing", "importune", "impostors", "imposture", "impotence",
    "impounded", "imprecise", "impressed", "impresses", "imprinted",
    "imprisons", "impromptu", "improving", "improvise", "imprudent",
    "impudence", "impugning", "impulsing", "impulsion", "impulsive",
    "inability", "inamorata", "inanimate", "inanities", "inaudible",
    "inaudibly", "inaugural", "inbounded", "incapable", "incarnate",
    "incensing", "incentive", "inception", "incessant", "inchoated",
    "inchoates", "incidence", "incidents", "incipient", "incisions",
    "inclement", "inclining", "including", "inclusion", "inclusive",
    "incognito", "incorrect", "increased", "increases", "increment",
    "incubated", "incubates", "incubator", "incubuses", "inculcate",
    "inculpate", "incumbent", "incurable", "incurably", "incurious",
    "incurring", "incursion", "indecency", "indelible", "indelibly",
    "indemnify", "indemnity", "indenting", "indenture", "indicated",
    "indicates", "indicator", "indicting", "indigence", "indigents",
    "indignant", "indignity", "indolence", "inductees", "inducting",
    "induction", "inductive", "indulgent", "indulging", "inebriate",
    "ineffable", "ineffably", "inelastic", "inelegant", "ineptness",
    "inertness", "inexperts", "infantile", "infatuate", "infecting",
    "infection", "inference", "inferiors", "inferring", "infertile",
    "infesting", "infielder", "infilling", "infirmary", "infirmity",
    "inflaming", "inflating", "inflation", "inflected", "inflexion",
    "inflicted", "influence", "influenza", "informant", "informers",
    "informing", "infringed", "infringes", "infuriate", "infusions",
    "ingenious", "ingenuity", "ingenuous", "ingesting", "ingestion",
    "inglenook", "ingrained", "ingresses", "ingrowing", "inhabited",
    "inhalants", "inhalator", "inherited", "inheritor", "inhibited",
    "inhumanly", "initially", "initiated", "initiates", "initiator",
    "injecting", "injection", "injectors", "injurious", "injustice",
    "inkstands", "innermost", "innkeeper", "innocence", "innocents",
    "innocuous", "innovated", "innovates", "innovator", "innuendos",
    "inoculate", "inorganic", "inpatient", "inputting", "inquirers",
    "inquorate", "inscribed", "inscribes", "insensate", "inserting",
    "insertion", "insetting", "insidious", "insignias", "insincere",
    "insinuate", "insipidly", "insistent", "insisting", "insolence",
    "insoluble", "insolvent", "insomniac", "inspected", "inspector",
    "inspiring", "installed", "instanced", "instances", "instantly",
    "instigate", "instilled", "instincts", "institute", "instructs",
    "insulated", "insulates", "insulator", "insulting", "insurance",
    "insurgent", "intaglios", "integrals", "integrate", "integrity",
    "intellect", "intendeds", "intending", "intensely", "intensest",
    "intensify", "intensity", "intensive", "intention", "interacts",
    "interbred", "intercede", "intercept", "intercity", "intercoms",
    "interdict", "interests", "interface", "interfere", "interiors",
    "interject", "interlace", "interlard", "interlink", "interlock",
    "interlude", "interment", "internals", "internees", "interning",
    "internist", "interplay", "interpose", "interpret", "interring",
    "interrupt", "intersect", "intervals", "intervene", "interview",
    "interwove", "intestate", "intestine", "intimated", "intimates",
    "intranets", "intricacy", "intricate", "intrigued", "intrigues",
    "intrinsic", "introduce", "introvert", "intruders", "intruding",
    "intrusion", "intrusive", "intuiting", "intuition", "intuitive",
    "inundated", "inundates", "invalided", "invariant", "invasions",
    "invective", "inveighed", "inveigled", "inveigles", "inventing",
    "invention", "inventive", "inventors", "inventory", "inversely",
    "inversion", "inverting", "investing", "investors", "invidious",
    "inviolate", "invisible", "invisibly", "invoicing", "involving",
    "irascible", "irascibly", "irateness", "ironclads", "ironstone",
    "irradiate", "irregular", "irrigated", "irrigates", "irritable",
    "irritably", "irritants", "irritated", "irritates", "irruption",
    "isinglass", "islanders", "isolating", "isolation", "isometric",
    "isosceles", "isotherms", "isotropic", "isthmuses", "itchiness",
    "iterating", "iteration", "iterative", "iterators", "itinerant",
    "itinerary", "jabberers", "jabbering", "jackasses", "jackboots",
    "jackknife", "jaggedest", "jailbirds", "jailbreak", "jailhouse",
    "jalousies", "jamborees", "japanning", "jaundiced", "jaundices",
    "jauntiest", "jawboning", "jaywalked", "jaywalker", "jealously",
    "jeeringly", "jellybean", "jellyfish", "jeremiads", "jerkiness",
    "jerkwater", "jeroboams", "jerrycans", "jetliners", "jettisons",
    "jewelries", "jiggering", "jigsawing", "jingoists", "jitterbug",
    "jitterier", "jobshares", "jobsworth", "jockeying", "jockstrap",
    "jocularly", "jocundity", "jolliness", "journeyed", "joviality",
    "joyfuller", "joylessly", "joyridden", "joyriders", "joyriding",
    "joysticks", "juddering", "judgeship", "judiciary", "judicious",
    "juiciness", "jukeboxes", "julienned", "juliennes", "jumpiness",
    "jumpsuits", "junctions", "junctures", "junketing", "junkyards",
    "juridical", "jurywoman", "jurywomen", "justified", "justifies",
    "juveniles", "juxtapose", "kamikazes", "kangaroos", "keelhauls",
    "keepsakes", "kerchiefs", "kerfuffle", "keyboards", "keynoting",
    "keystones", "keystroke", "kibbutzes", "kibbutzim", "kibitzers",
    "kibitzing", "kickbacks", "kickstand", "kidnapped", "kidnapper",
    "kielbasas", "killdeers", "kilobytes", "kilocycle", "kilohertz",
    "kilowatts", "kindliest", "kinematic", "kingliest", "kingmaker",
    "kinswoman", "kinswomen", "kippering", "kissogram", "kitchened",
    "kittenish", "klutziest", "knackered", "knapsacks", "knighting",
    "knobbiest", "knockdown", "knockoffs", "knockouts", "knotholes",
    "knottiest", "knowinger", "knowingly", "knowledge", "knuckling",
    "kookiness", "koshering", "kowtowing", "kvetching", "laborious",
    "laburnums", "labyrinth", "lacerated", "lacerates", "lachrymal",
    "lacquered", "lactating", "lactation", "laddering", "ladybirds",
    "ladyships", "lagniappe", "lambasted", "lambastes", "lambskins",
    "lambswool", "lamebrain", "lamenting", "laminated", "laminates",
    "lampblack", "lamplight", "lampooned", "lampposts", "lampshade",
    "landfalls", "landfills", "landlords", "landmarks", "landmines",
    "landowner", "landscape", "landslide", "landslips", "landwards",
    "languages", "languidly", "lankiness", "larboards", "larcenies",
    "larcenous", "largeness", "lariating", "larkspurs", "lassitude",
    "lastingly", "latchkeys", "latecomer", "lateraled", "laterally",
    "lathering", "latitudes", "laudatory", "laughable", "laughably",
    "launchers", "launching", "laundered", "launderer", "laundress",
    "laundries", "laureated", "laureates", "lavenders", "lavishest",
    "lavishing", "lawgivers", "lawlessly", "lawmakers", "lawnmower",
    "laxatives", "layabouts", "laypeople", "layperson", "lazybones",
    "leafleted", "leapfrogs", "leaseback", "leasehold", "leastwise",
    "leavening", "lecherous", "lecturers", "lecturing", "ledgering",
    "leftovers", "leftwards", "legalisms", "legations", "legendary",
    "legionary", "legislate", "legwarmer", "leisurely", "leitmotif",
    "leitmotiv", "lemonades", "lengthens", "lengthier", "lengthily",
    "leniently", "lessening", "lethargic", "letterbox", "lettering",
    "leucotomy", "leukocyte", "levelness", "leveraged", "leverages",
    "leviathan", "levitated", "levitates", "liability", "libations",
    "liberally", "liberated", "liberates", "liberator", "liberties",
    "libertine", "librarian", "libraries", "librettos", "licensees",
    "licorices", "lifebelts", "lifeblood", "lifeboats", "lifeforms",
    "lifeguard", "lifelines", "lifesaver", "lifespans", "lifestyle",
    "lifetimes", "lifeworks", "ligaments", "ligatured", "ligatures",
    "lightened", "lightness", "lightning", "lightship", "likeliest",
    "limberest", "limbering", "limelight", "limericks", "limescale",
    "limestone", "limitings", "limitless", "limousine", "limpidity",
    "linchpins", "lineament", "linearity", "lingerers", "lingering",
    "linguists", "liniments", "lionesses", "lipsticks", "liquefied",
    "liquefies", "liqueured", "liquidate", "liquidity", "liquorice",
    "liquoring", "listeners", "listening", "literally", "literates",
    "litigants", "litigated", "litigates", "litigator", "litigious",
    "litterbug", "littering", "littorals", "liturgies", "liveliest",
    "livelongs", "livestock", "loanwords", "loathings", "loathsome",
    "lobbyists", "lobstered", "locations", "locksmith", "locoweeds",
    "locutions", "lodestars", "lodestone", "loftiness", "logarithm",
    "logically", "logicians", "logistics", "logotypes", "loincloth",
    "loiterers", "loitering", "lollipops", "lolloping", "loneliest",
    "lonesomes", "longboats", "longevity", "longhairs", "longhorns",
    "longhouse", "longingly", "longitude", "longueurs", "lookalike",
    "loopholes", "looseness", "loosening", "loquacity", "lordliest",
    "lordships", "lorgnette", "lotteries", "loudliest", "loudmouth",
    "lousiness", "lovebirds", "loveliest", "lowercase", "lowlander",
    "lowliness", "loyalists", "loyalties", "lubricant", "lubricate",
    "lucidness", "luckiness", "lucrative", "ludicrous", "lullabies",
    "lumbering", "lumberman", "lumbermen", "lumpiness", "luncheons",
    "lunchroom", "lunchtime", "luridness", "lustfully", "lustiness",
    "luxuriant", "luxuriate", "luxurious", "lychgates", "lymphatic",
    "lymphomas", "lynchings", "lyrebirds", "lyrically", "lyricists",
    "macadamia", "macaroons", "macerated", "macerates", "machinery",
    "machining", "machinist", "mackerels", "mackinaws", "macrocosm",
    "maddening", "madhouses", "madrigals", "maelstrom", "magazines",
    "magically", "magicians", "magicking", "magnesium", "magnetics",
    "magnetism", "magnified", "magnifier", "magnifies", "magnitude",
    "magnolias", "maharajah", "maharanis", "maharishi", "mailboxes",
    "mailshots", "mainframe", "mainlands", "mainlined", "mainlines",
    "mainmasts", "mainsails", "mainstays", "maintains", "majesties",
    "majordomo", "majorette", "makeovers", "makeshift", "malachite",
    "maladroit", "malformed", "malicious", "malignant", "maligning",
    "malignity", "malingers", "malleable", "maltreats", "mammalian",
    "mammogram", "manacling", "mandarins", "mandating", "mandatory",
    "mandibles", "mandolins", "mandrakes", "mandrills", "manganese",
    "mangetout", "mangroves", "manhandle", "manically", "manicured",
    "manicures", "manifesto", "manifests", "manifolds", "manliness",
    "mannequin", "mannerism", "mannishly", "mantillas", "marathons",
    "marauders", "marauding", "margarine", "margarita", "marginals",
    "mariachis", "marigolds", "marijuana", "marinaded", "marinades",
    "marinated", "marinates", "markdowns", "marketeer", "marketers",
    "marketing", "marmalade", "marmosets", "marooning", "marquetry",
    "marquises", "marriages", "marrowing", "marshaled", "marshiest",
    "marshland", "marsupial", "martinets", "martyrdom", "martyring",
    "mascaraed", "masculine", "masochism", "masochist", "massacred",
    "massacres", "massaging", "masseuses", "massively", "masterful",
    "mastering", "mastheads", "masticate", "mastodons", "matchbook",
    "matchless", "matchwood", "materials", "maternity", "matriarch",
    "matricide", "matrimony", "mattering", "maundered", "mausoleum",
    "mavericks", "mawkishly", "maxillary", "maximally", "mayflower",
    "mayoralty", "mealtimes", "meandered", "meanwhile", "measliest",
    "measuring", "meatballs", "mechanics", "mechanism", "medallion",
    "mediating", "mediation", "mediators", "medically", "medicated",
    "medicates", "medicinal", "medicines", "meditated", "meditates",
    "megabucks", "megabytes", "megacycle", "megahertz", "megaliths",
    "megaphone", "megastars", "megawatts", "melanomas", "mellowest",
    "mellowing", "melodious", "melodrama", "meltdowns", "membranes",
    "memorable", "memorably", "memorials", "memsahibs", "menagerie",
    "mendacity", "mendicant", "menopause", "menstrual", "mentality",
    "mentioned", "mentoring", "mercenary", "merchants", "merciless",
    "mercurial", "merganser", "meridians", "meringues", "merriment",
    "merriness", "mescaline", "mesmerism", "mesquites", "messaging",
    "messenger", "messianic", "messieurs", "messiness", "metabolic",
    "metacarpi", "metalwork", "metaphors", "meteorite", "meteoroid",
    "methadone", "methought", "metronome", "mezzanine", "microchip",
    "microcode", "microcosm", "microfilm", "microwave", "middleman",
    "middlemen", "midpoints", "midstream", "midsummer", "midwifery",
    "midwifing", "midwinter", "mightiest", "migraines", "migrating",
    "migration", "migratory", "mildewing", "mileposts", "milestone",
    "militancy", "militants", "militated", "militates", "milkiness",
    "milkmaids", "milkshake", "milkweeds", "millibars", "milliners",
    "millinery", "millionth", "millipede", "millponds", "millraces",
    "millstone", "milometer", "mimicking", "mimicries", "mincemeat",
    "mindfully", "minefield", "miniature", "minibikes", "minibuses",
    "minimally", "miniskirt", "ministers", "minstrels", "minuscule",
    "minuteman", "minutemen", "mirroring", "mirthless", "misbehave",
    "miscalled", "mischance", "mischiefs", "miscounts", "miscreant",
    "misdirect", "misdoings", "miserable", "miserably", "misfiring",
    "misfitted", "misgiving", "misgovern", "misguided", "misguides",
    "mishandle", "mishapped", "misinform", "misjudged", "misjudges",
    "mislaying", "mismanage", "misnaming", "misnomers", "misplaced",
    "misplaces", "misplayed", "misprints", "misquoted", "misquotes",
    "misreport", "misruling", "misshapen", "missilery", "missioned",
    "misspells", "misspends", "misstated", "misstates", "mistaking",
    "mistiming", "mistiness", "mistletoe", "mistreats", "mistrials",
    "mistrusts", "mistyping", "mitigated", "mitigates", "mnemonics",
    "moccasins", "mockeries", "mockingly", "moderated", "moderates",
    "moderator", "modernest", "modernism", "modernist", "modernity",
    "modestest", "modifiers", "modifying", "modulated", "modulates",
    "modulator", "moistened", "moistness", "moldering", "moldiness",
    "molecular", "molecules", "molehills", "molesters", "molesting",
    "mollified", "mollifies", "momentary", "momentous", "monarchic",
    "monastery", "monastics", "moneybags", "mongering", "mongolism",
    "mongooses", "monitored", "monkeying", "monograms", "monograph",
    "monoliths", "monologue", "monomania", "monoplane", "monorails",
    "monotoned", "monotones", "monotonic", "monoxides", "monsignor",
    "monstrous", "monthlies", "monuments", "moodiness", "moonbeams",
    "moonlight", "moonscape", "moonshine", "moonshots", "moonstone",
    "moorlands", "moralists", "moralling", "morbidity", "mordantly",
    "morphemed", "morphemes", "mortality", "mortaring", "mortgaged",
    "mortgagee", "mortgages", "mortgagor", "mortician", "mortified",
    "mortifies", "mortising", "mothballs", "mothering", "motioning",
    "motivated", "motivates", "motivator", "motocross", "motorbike",
    "motorboat", "motorcade", "motorcars", "motorists", "motorways",
    "mouldered", "mountains", "mountings", "mousetrap", "mousiness",
    "moussakas", "mouthfuls", "mouthwash", "movements", "moviegoer",
    "muckraked", "muckraker", "muckrakes", "muddiness", "mudguards",
    "mudslides", "mugginess", "mulattoes", "muleteers", "mullioned",
    "multiples", "multiplex", "multitude", "mummified", "mummifies",
    "mundanely", "municipal", "munitions", "muralists", "murderers",
    "murderess", "murdering", "murderous", "murkiness", "murmuring",
    "muscatels", "muscleman", "musclemen", "mushiness", "mushrooms",
    "musicales", "musically", "musicians", "musicking", "musketeer",
    "muskiness", "muskmelon", "mustering", "mustiness", "mutations",
    "mutilated", "mutilates", "mutineers", "mutinying", "muttering",
    "mutuality", "muzziness", "mysteried", "mysteries", "mysticism",
    "mystified", "mystifies", "mythology", "nailbrush", "nakedness",
    "nameplate", "namesakes", "napalming", "narcissus", "narcotics",
    "narrating", "narration", "narrative", "narrators", "narrowest",
    "narrowing", "nastiness", "nationals", "nattering", "naturally",
    "naturists", "naughtier", "naughties", "naughtily", "nauseated",
    "nauseates", "navigable", "navigated", "navigates", "navigator",
    "naysayers", "nearliest", "neatening", "necessary", "necessity",
    "neckbands", "necklaced", "necklaces", "necklines", "nectarine",
    "neediness", "nefarious", "negations", "negatived", "negatives",
    "neglected", "negligees", "negligent", "negotiate", "nematodes",
    "neodymium", "neolithic", "neologism", "neophytes", "nephritis",
    "neptunium", "nerveless", "nervously", "nestlings", "networked",
    "neuralgia", "neuralgic", "neurology", "neurotics", "neutering",
    "neutrally", "neutrinos", "nevermore", "newcomers", "newlyweds",
    "newsagent", "newscasts", "newsflash", "newsgroup", "newshound",
    "newspaper", "newsprint", "newsreels", "newsrooms", "newsstand",
    "nicknamed", "nicknames", "niggarded", "niggardly", "nigglings",
    "nightcaps", "nightclub", "nightfall", "nightgown", "nighthawk",
    "nightlife", "nightlong", "nightmare", "nightspot", "nighttime",
    "nightwear", "nihilists", "nineteens", "ninetieth", "nippering",
    "nitpicked", "nitpicker", "nitrating", "nobleness", "nocturnal",
    "nocturnes", "noiseless", "noisiness", "nominally", "nominated",
    "nominates", "nonentity", "nonevents", "nonexempt", "nonliving",
    "nonmember", "nonpareil", "nonpluses", "nonprofit", "nonsexist",
    "nonsmoker", "nonverbal", "nonvoting", "nonwhites", "normality",
    "normative", "northeast", "northerly", "northward", "northwest",
    "nosebleed", "nosedived", "nosedives", "nostalgia", "nostalgic",
    "notations", "notebooks", "notepaper", "notifying", "notoriety",
    "notorious", "nourished", "nourishes", "novelette", "novelists",
    "novelties", "novitiate", "nuisances", "nullified", "nullifies",
    "numbering", "numerated", "numerates", "numerator", "numerical",
    "numskulls", "nunneries", "nursemaid", "nurseries", "nurturing",
    "nuthouses", "nutmegged", "nutrients", "nutriment", "nutrition",
    "nutritive", "nutshells", "nuttiness", "oarswoman", "oarswomen",
    "obdurated", "obdurates", "obedience", "obeisance", "obfuscate",
    "objecting", "objection", "objective", "objectors", "oblations",
    "obligated", "obligates", "obliquely", "oblivious", "obnoxious",
    "obscenely", "obscenest", "obscenity", "obscurely", "obscurest",
    "obscuring", "obscurity", "obsequies", "observant", "observers",
    "observing", "obsessing", "obsession", "obsessive", "obsoleted",
    "obsoletes", "obstacles", "obstetric", "obstinacy", "obstinate",
    "obstructs", "obtaining", "obtruding", "obtrusive", "obviating",
    "obviously", "occasions", "occluding", "occlusion", "occultist",
    "occupancy", "occupants", "occupiers", "occupying", "occurring",
    "octagonal", "octopuses", "odometers", "offenders", "offending",
    "offerings", "offertory", "officials", "officiate", "officious",
    "offloaded", "offshoots", "offspring", "offstages", "oilcloths",
    "oilfields", "ointments", "oleanders", "olfactory", "oligarchs",
    "oligarchy", "ombudsman", "ombudsmen", "ominously", "omissions",
    "omnibuses", "omnivores", "onionskin", "onlookers", "onrushing",
    "onsetting", "onslaught", "operatics", "operating", "operation",
    "operative", "operators", "operettas", "opponents", "opportune",
    "opposites", "oppressed", "oppresses", "oppressor", "optically",
    "opticians", "optimists", "optionals", "optioning", "optometry",
    "orangeade", "orangutan", "oratories", "oratorios", "orchestra",
    "ordaining", "orderings", "orderlies", "ordinance", "organelle",
    "organisms", "organists", "orgiastic", "orientals", "orientate",
    "orienting", "originals", "originate", "ornaments", "orneriest",
    "orphanage", "orphaning", "orthodoxy", "oscillate", "ossifying",
    "osteopath", "ostracism", "ostriches", "otherness", "otherwise",
    "ourselves", "outbounds", "outbreaks", "outbroken", "outbursts",
    "outermost", "outerwear", "outfacing", "outfields", "outfitted",
    "outfitter", "outflanks", "outfoxing", "outgoings", "outgrowth",
    "outgunned", "outhouses", "outlasted", "outlawing", "outlaying",
    "outlining", "outliving", "outlooked", "outnumber", "outpacing",
    "outplayed", "outpoints", "outputted", "outraging", "outranked",
    "outriders", "outrigger", "outshines", "outsiders", "outskirts",
    "outsmarts", "outsource", "outspoken", "outspread", "outstayed",
    "outstrips", "outvoting", "outwardly", "outweighs", "outwitted",
    "outworker", "ovenproof", "overacted", "overawing", "overbears",
    "overbites", "overblown", "overboard", "overbooks", "overborne",
    "overcasts", "overcoats", "overcomes", "overcooks", "overcrowd",
    "overdoing", "overdosed", "overdoses", "overdraft", "overdrawn",
    "overdraws", "overdress", "overdrive", "overeager", "overeaten",
    "overflies", "overflown", "overflows", "overgrown", "overgrows",
    "overhands", "overhangs", "overhauls", "overheads", "overheard",
    "overhears", "overheats", "overjoyed", "overkills", "overladen",
    "overlands", "overloads", "overlooks", "overlords", "overlying",
    "overnight", "overplays", "overpower", "overprice", "overprint",
    "overrated", "overrates", "overreach", "overreact", "overrides",
    "overruled", "overrules", "overseers", "oversells", "oversexed",
    "overshoes", "overshoot", "oversight", "oversizes", "oversleep",
    "overslept", "overspend", "overspent", "overspill", "overstate",
    "overstays", "oversteps", "overstock", "overtaken", "overtakes",
    "overtaxed", "overtaxes", "overthrew", "overthrow", "overtimes",
    "overtired", "overtires", "overtones", "overtures", "overturns",
    "overusing", "overvalue", "overviews", "overwhelm", "overworks",
    "overwrite", "overwrote", "oviparous", "ovulating", "ovulation",
    "ownership", "oxidation", "oxygenate", "pacemaker", "pachyderm",
    "pacifiers", "pacifists", "pacifying", "packaging", "paddocked",
    "padlocked", "paederast", "pageantry", "paginated", "paginates",
    "painfully", "paintball", "painterly", "paintings", "paintwork",
    "palatable", "palavered", "palefaces", "palisades", "palladium",
    "palliated", "palliates", "palmettos", "palmistry", "palominos",
    "palpating", "palpation", "palpitate", "paltriest", "pampering",
    "pamphlets", "panatella", "pancaking", "pandemics", "panderers",
    "pandering", "panegyric", "panelists", "panellist", "panhandle",
    "panickier", "panicking", "panoplies", "panoramas", "panoramic",
    "pantheism", "pantheist", "pantheons", "pantomime", "pantsuits",
    "pantyhose", "paparazzi", "paparazzo", "paperback", "paperbark",
    "paperboys", "paperclip", "papergirl", "paperless", "paperwork",
    "parabling", "parabolas", "parabolic", "parachute", "paradigms",
    "paradises", "paradoxes", "paragraph", "parakeets", "paralegal",
    "parallels", "paralysis", "paralytic", "paramecia", "paramedic",
    "parameter", "paramount", "paramours", "paranoiac", "paranoids",
    "parasites", "parasitic", "paratroop", "parboiled", "parchment",
    "pardoning", "parentage", "parenting", "parlaying", "parleying",
    "parochial", "parodists", "parodying", "paroxysms", "parqueted",
    "parquetry", "parricide", "parroting", "parsimony", "parsonage",
    "partakers", "partaking", "parterres", "partially", "particles",
    "partisans", "partition", "partitive", "partnered", "partridge",
    "passbooks", "passenger", "passersby", "passioned", "passively",
    "passivise", "passivity", "passivize", "passports", "passwords",
    "pastiches", "pastilles", "pastorals", "pastorate", "pasturage",
    "pasturing", "patchiest", "patchouli", "patchwork", "patenting",
    "paternity", "pathogens", "pathology", "patienter", "patiently",
    "patriarch", "patrician", "patricide", "patrimony", "patriotic",
    "patrolled", "patrolman", "patrolmen", "patronage", "patroness",
    "pattering", "patterned", "paunchier", "paunching", "pauperism",
    "pavements", "pavilions", "pawnshops", "paychecks", "paymaster",
    "payphones", "peaceable", "peaceably", "peacetime", "pearliest",
    "peasantry", "pebbliest", "peccaries", "pectorals", "pecuniary",
    "pedagogic", "pedagogue", "pederasts", "pederasty", "pedestals",
    "pedicured", "pedicures", "pedigreed", "pedigrees", "pediments",
    "pedometer", "peepholes", "peepshows", "peeresses", "peevishly",
    "pekineses", "pekingese", "pelleting", "penalties", "penancing",
    "penchants", "pendulous", "pendulums", "penetrate", "penfriend",
    "peninsula", "penitence", "penitents", "penknives", "penlights",
    "penniless", "pensioned", "pensioner", "pensively", "pentagons",
    "penthouse", "penumbras", "penurious", "peppering", "pepperoni",
    "perceived", "perceives", "perchance", "percolate", "perdition",
    "peregrine", "perennial", "perfected", "perfecter", "perfectly",
    "perfidies", "perforate", "performed", "performer", "perfumery",
    "perfuming", "perhapses", "perihelia", "perimeter", "perinatal",
    "periphery", "periscope", "perishers", "perishing", "perjurers",
    "perjuries", "perjuring", "perkiness", "permanent", "permeable",
    "permeated", "permeates", "permitted", "permuting", "peroxided",
    "peroxides", "perpetual", "perplexed", "perplexes", "persecute",
    "persevere", "persimmon", "persisted", "personage", "personals",
    "personify", "personnel", "perspired", "perspires", "persuaded",
    "persuades", "pertained", "pertinent", "perturbed", "pertussis",
    "pervading", "pervasive", "perverted", "pessaries", "pessimism",
    "pessimist", "pestering", "pesticide", "pestilent", "petitions",
    "petrified", "petrifies", "petroleum", "petrology", "petticoat",
    "pettifogs", "pettiness", "petulance", "phagocyte", "phalanges",
    "phalanxes", "phantasms", "pharynges", "pheasants", "phenomena",
    "phenotype", "pheromone", "phialling", "philander", "philately",
    "philippic", "philology", "phlebitis", "phoenixes", "phonecard",
    "phonemics", "phonetics", "phoniness", "phonology", "phosphate",
    "phosphors", "photocell", "photocopy", "photostat", "phrasings",
    "physicals", "physician", "physicist", "physicked", "physiques",
    "pickaxing", "pickerels", "picketers", "picketing", "picnicked",
    "picnicker", "pictorial", "picturing", "piecemeal", "piecework",
    "piercings", "pigeoning", "piggeries", "piggyback", "pigheaded",
    "pigmented", "pilasters", "pilchards", "pilferers", "pilfering",
    "pillaging", "pillboxes", "pillioned", "pilloried", "pillories",
    "pillowing", "pimientos", "pimpernel", "pimpliest", "pinafores",
    "pineapple", "pinewoods", "pinioning", "pinnacles", "pinpoints",
    "pinpricks", "pinstripe", "pinwheels", "pioneered", "piousness",
    "pipelines", "pipsqueak", "piquantly", "piratical", "pirouette",
    "pistachio", "pitchfork", "piteously", "pitifully", "pittances",
    "pituitary", "pityingly", "pizzerias", "pizzicati", "pizzicato",
    "placarded", "placating", "placation", "placatory", "placement",
    "placental", "placentas", "placidity", "plainness", "plainsong",
    "plaintiff", "plaintive", "planeload", "planetary", "plannings",
    "plantains", "plantings", "plastered", "plasterer", "plateaued",
    "platefuls", "platelets", "platforms", "platitude", "platooned",
    "plausible", "plausibly", "playacted", "playbacks", "playbills",
    "playfully", "playgoers", "playgroup", "playhouse", "playmates",
    "playrooms", "plaything", "pleadings", "pleasings", "pleasured",
    "pleasures", "plebeians", "plectrums", "plenaries", "plenitude",
    "plenteous", "plentiful", "plighting", "plimsolls", "ploddings",
    "plottered", "pluckiest", "plugholes", "plummeted", "plumpness",
    "plundered", "plunderer", "pluralism", "pluralist", "plurality",
    "plushiest", "plutocrat", "plutonium", "pneumatic", "pneumonia",
    "pocketful", "pocketing", "pockmarks", "poetesses", "pogroming",
    "poignancy", "pointedly", "pointiest", "pointless", "poisoners",
    "poisoning", "poisonous", "poleaxing", "polemical", "polestars",
    "policeman", "policemen", "polishers", "polishing", "politburo",
    "politesse", "political", "politicos", "pollinate", "polliwogs",
    "pollsters", "pollutant", "polluters", "polluting", "pollution",
    "polonaise", "poltroons", "polyandry", "polyester", "polyglots",
    "polygonal", "polygraph", "polymaths", "polymeric", "polyphony",
    "polythene", "pomanders", "pompadour", "pomposity", "pompously",
    "pondering", "ponderous", "pontooned", "ponytails", "poolsides",
    "poorhouse", "popinjays", "poppadoms", "poppycock", "populaces",
    "popularly", "populated", "populates", "populists", "porcelain",
    "porcupine", "porpoised", "porpoises", "porringer", "portables",
    "portaging", "portended", "portering", "portfolio", "portholes",
    "porticoes", "portioned", "portliest", "portraits", "portrayal",
    "portrayed", "positions", "positiver", "positives", "positrons",
    "possessed", "possesses", "possessor", "possibler", "possibles",
    "postboxes", "postcards", "postcodes", "postdated", "postdates",
    "posterior", "posterity", "posthaste", "postludes", "postmarks",
    "postnatal", "postponed", "postpones", "postulate", "posturing",
    "postwoman", "postwomen", "potassium", "potboiler", "potentate",
    "potential", "potholder", "potholers", "potholing", "potpourri",
    "potsherds", "potteries", "pottering", "pottiness", "poulticed",
    "poultices", "poundings", "powdering", "powerboat", "powerless",
    "powwowing", "practical", "pragmatic", "prankster", "pratfalls",
    "prattlers", "prattling", "preachers", "preachier", "preaching",
    "preambled", "preambles", "precedent", "preceding", "preceptor",
    "precincts", "precipice", "precisely", "precisest", "precision",
    "precluded", "precludes", "precocity", "precooked", "precursor",
    "predating", "predators", "predatory", "predicate", "predicted",
    "predictor", "predigest", "preempted", "preexists", "prefabbed",
    "prefacing", "prefatory", "preferred", "prefigure", "prefixing",
    "pregnancy", "preheated", "prejudged", "prejudges", "prejudice",
    "premature", "premiered", "premieres", "premising", "preoccupy",
    "preordain", "prepacked", "preparing", "prepaying", "preppiest",
    "prerecord", "presaging", "preschool", "prescient", "prescribe",
    "presences", "presented", "presenter", "presently", "preserved",
    "preserver", "preserves", "preshrank", "preshrink", "preshrunk",
    "president", "presiding", "presidium", "pressings", "pressured",
    "pressures", "presuming", "pretended", "pretender", "preterits",
    "pretexted", "prettiest", "prettying", "prevailed", "prevalent",
    "prevented", "previewed", "previewer", "priceless", "pricklier",
    "prickling", "priestess", "primaries", "primarily", "primitive",
    "primrosed", "primroses", "principal", "principle", "printable",
    "printings", "printouts", "prismatic", "prisoners", "prisoning",
    "prissiest", "privateer", "privately", "privatest", "privation",
    "privilege", "proactive", "probables", "probating", "probation",
    "probosces", "proboscis", "procedure", "proceeded", "processed",
    "processes", "processor", "proclaims", "procreate", "proctored",
    "procurers", "procuring", "prodigals", "prodigies", "producers",
    "producing", "profanely", "profaning", "profanity", "professed",
    "professes", "professor", "proffered", "profiling", "profiteer",
    "profiting", "profusely", "profusion", "prognoses", "prognosis",
    "prohibits", "projected", "projector", "prolapsed", "prolapses",
    "prolixity", "prologues", "prolonged", "promenade", "prominent",
    "promising", "promoters", "promoting", "promotion", "prompters",
    "promptest", "prompting", "proneness", "pronghorn", "pronounce",
    "proofread", "propagate", "propelled", "propeller", "properest",
    "prophetic", "proponent", "proposals", "proposers", "proposing",
    "propounds", "propriety", "prorating", "proscribe", "prosecute",
    "proselyte", "prosodies", "prospects", "prospered", "prostates",
    "prostrate", "protected", "protector", "protested", "protester",
    "protocols", "prototype", "protozoan", "protracts", "protruded",
    "protrudes", "provender", "provident", "providers", "providing",
    "provinces", "provision", "provoking", "proximate", "proximity",
    "prudently", "prudishly", "prurience", "psalmists", "pseudonym",
    "psoriasis", "psychical", "psychoses", "psychosis", "psychotic",
    "ptarmigan", "ptomaines", "pubescent", "publicans", "publicist",
    "publicity", "published", "publisher", "publishes", "puckering",
    "pudginess", "puerility", "puffballs", "puffiness", "pugilists",
    "pugnacity", "pullbacks", "pullovers", "pulmonary", "pulsating",
    "pulsation", "punchbags", "punchiest", "punchline", "punctuate",
    "punctured", "punctures", "pungently", "punishing", "puppeteer",
    "purchased", "purchaser", "purchases", "purebreds", "purgative",
    "purgatory", "purifiers", "purifying", "purloined", "purported",
    "purposely", "purposing", "pursuance", "purulence", "purveying",
    "purveyors", "pushbikes", "pushcarts", "pushchair", "pushiness",
    "pushovers", "pussycats", "pussyfoot", "putrefied", "putrefies",
    "puttering", "pyramidal", "pyramided", "pyromania", "quadrants",
    "quadratic", "quadrille", "quadruped", "quadruple", "quagmired",
    "quagmires", "quaintest", "qualified", "qualifier", "qualifies",
    "qualities", "quarrying", "quartered", "quarterly", "quatrains",
    "quavering", "quaysides", "queasiest", "queenlier", "queerness",
    "quenching", "querulous", "questions", "quibblers", "quibbling",
    "quickened", "quickfire", "quicklime", "quickness", "quicksand",
    "quickstep", "quiescent", "quietened", "quietness", "quietuses",
    "quintuple", "quirkiest", "quislings", "quivering", "quizzical",
    "quotation", "quotidian", "quotients", "rabbinate", "rabbiting",
    "racegoers", "racehorse", "racetrack", "racialism", "racialist",
    "racketeer", "racketing", "raconteur", "radiantly", "radiating",
    "radiation", "radiators", "radically", "radicchio", "radiogram",
    "radiology", "raggedest", "raggedier", "railcards", "railroads",
    "raincoats", "raindrops", "rainfalls", "rainmaker", "rainproof",
    "rainstorm", "rainwater", "ramblings", "ramifying", "rampaging",
    "rampantly", "ramrodded", "rancidity", "rancorous", "randiness",
    "ranginess", "ransacked", "ransoming", "rapacious", "rappelled",
    "rapturous", "rarefying", "raspberry", "ratcheted", "ratepayer",
    "ratifying", "rationale", "rationals", "rationing", "rattlings",
    "raucously", "raunchier", "raunchily", "ravishing", "reachable",
    "reactants", "reactions", "readdress", "readiness", "readjusts",
    "reaffirms", "realigned", "realistic", "realities", "reallying",
    "reanimate", "reappears", "reapplied", "reapplies", "reappoint",
    "rearguard", "rearrange", "rearwards", "reasoning", "reasserts",
    "reassigns", "reassured", "reassures", "reawakens", "rebelling",
    "rebellion", "rebinding", "rebooting", "rebounded", "rebuffing",
    "rebuttals", "rebutting", "recalling", "recanting", "recapping",
    "recapture", "recasting", "receipted", "receivers", "receiving",
    "recentest", "reception", "receptive", "receptors", "recessing",
    "recession", "recessive", "recharged", "recharges", "rechecked",
    "recipient", "reckoning", "reclaimed", "recliners", "reclining",
    "reclusive", "recoiling", "recollect", "recombine", "recommend",
    "recompile", "reconcile", "recondite", "reconnect", "reconquer",
    "reconvene", "recopying", "recorders", "recording", "recounted",
    "recouping", "recovered", "recreants", "recreated", "recreates",
    "recruited", "recruiter", "rectangle", "rectified", "rectifier",
    "rectifies", "rectitude", "rectories", "recumbent", "recurrent",
    "recurring", "recursion", "recursive", "recycling", "redbreast",
    "reddening", "redeemers", "redeeming", "redefined", "redefines",
    "redeploys", "redesigns", "redevelop", "redheaded", "redirects",
    "redolence", "redoubled", "redoubles", "redoubted", "redounded",
    "redrafted", "redrawing", "redressed", "redresses", "reducible",
    "reduction", "reductive", "redundant", "reeducate", "reelected",
    "reemerged", "reemerges", "reenacted", "reenlists", "reentered",
    "reentries", "reexamine", "refashion", "refectory", "referable",
    "reference", "referrals", "referring", "refilling", "refinance",
    "refitting", "reflating", "reflation", "reflected", "reflector",
    "reflexive", "refocused", "refocuses", "reforests", "reformers",
    "reforming", "reformist", "refracted", "refrained", "refreshed",
    "refresher", "refreshes", "refulgent", "refunding", "refurbish",
    "refurnish", "refutable", "regaining", "regarding", "regencies",
    "regicides", "regiments", "registers", "registrar", "regressed",
    "regresses", "regretful", "regretted", "regrouped", "regularly",
    "regulated", "regulates", "regulator", "rehabbing", "rehashing",
    "rehearsal", "rehearsed", "rehearses", "reheating", "rehousing",
    "reimburse", "reimposed", "reimposes", "reinforce", "reinserts",
    "reinstate", "reinvents", "reinvests", "reissuing", "reiterate",
    "rejecting", "rejection", "rejiggers", "rejigging", "rejoicing",
    "rejoinder", "rejoining", "rekindled", "rekindles", "relapsing",
    "relations", "relatives", "relaxants", "relearned", "releasing",
    "relegated", "relegates", "relenting", "relevance", "relevancy",
    "reliables", "relieving", "religions", "religious", "reliquary",
    "relishing", "reloading", "relocated", "relocates", "reluctant",
    "remainder", "remaining", "remanding", "remarking", "remarried",
    "remarries", "remasters", "rematches", "remedying", "remembers",
    "reminders", "reminding", "reminisce", "remission", "remitting",
    "remolding", "remoulded", "remounted", "removable", "renascent",
    "rendering", "rendition", "renegaded", "renegades", "renewable",
    "renounced", "renounces", "renovated", "renovates", "renovator",
    "renowning", "renumbers", "reopening", "reordered", "repackage",
    "repainted", "repairers", "repairing", "repairman", "repairmen",
    "reparteed", "repartees", "repasting", "repayable", "repayment",
    "repealing", "repeaters", "repeating", "repellent", "repelling",
    "repentant", "repenting", "repertory", "rephrased", "rephrases",
    "replacing", "replaying", "replenish", "repleting", "repletion",
    "replicate", "reportage", "reporters", "reporting", "reposeful",
    "repossess", "reprehend", "represent", "repressed", "represses",
    "reprieved", "reprieves", "reprimand", "reprinted", "reprisals",
    "reprising", "reprobate", "reprocess", "reproduce", "reproofed",
    "reproving", "reptilian", "republics", "republish", "repudiate",
    "repugnant", "repulsing", "repulsion", "repulsive", "reputable",
    "reputably", "reputedly", "requested", "requester", "requiring",
    "requisite", "requiting", "rereading", "rerouting", "rerunning",
    "rescinded", "reselling", "resembled", "resembles", "resentful",
    "resenting", "reserving", "reservist", "reservoir", "resetting",
    "resettled", "resettles", "reshaping", "reshuffle", "residence",
    "residency", "residents", "residuals", "resigning", "resilient",
    "resistant", "resisters", "resisting", "resistors", "resitting",
    "resoluter", "resolutes", "resolving", "resonance", "resonated",
    "resonates", "resonator", "resorting", "resounded", "resourced",
    "resources", "respected", "respecter", "respelled", "respiring",
    "responded", "responses", "restarted", "restating", "restfully",
    "restively", "restocked", "restorers", "restoring", "restrains",
    "restraint", "restricts", "restrooms", "restudied", "restudies",
    "resubmits", "resultant", "resulting", "resurface", "resurgent",
    "resurrect", "retailers", "retailing", "retainers", "retaining",
    "retaliate", "retardant", "retarding", "retelling", "retention",
    "retentive", "rethought", "reticence", "retooling", "retorting",
    "retouched", "retouches", "retracing", "retracted", "retrained",
    "retreaded", "retreated", "retrieval", "retrieved", "retriever",
    "retrieves", "retrodden", "retrofits", "returnees", "returners",
    "returning", "reunified", "reunifies", "reuniting", "revaluing",
    "revamping", "revealing", "revelries", "revenging", "reverence",
    "reverends", "reversals", "reversing", "reversion", "reverting",
    "reviewers", "reviewing", "revisions", "revisited", "revocable",
    "revolting", "revolvers", "revolving", "revulsion", "rewarding",
    "rewinding", "rewording", "reworking", "rewriting", "rewritten",
    "rhapsodic", "rheostats", "rheumatic", "rheumiest", "rhomboids",
    "rhombuses", "ricketier", "rickshaws", "ricochets", "ridgepole",
    "ridiculed", "ridicules", "righteous", "rightists", "rightmost",
    "rightness", "rightward", "rigidness", "rigmarole", "riotously",
    "riposting", "riskiness", "ritualism", "rivalries", "riverbeds",
    "riverside", "roadblock", "roadhouse", "roadshows", "roadsides",
    "roadsters", "roadworks", "robberies", "robustest", "rockeries",
    "rocketing", "rockfalls", "rockiness", "roentgens", "roguishly",
    "roistered", "roisterer", "rollbacks", "rollicked", "rollovers",
    "romancing", "romantics", "rookeries", "roominess", "roommates",
    "rosetting", "rosewater", "rosewoods", "rostering", "rotations",
    "rottenest", "rotunding", "rotundity", "roughcast", "roughened",
    "roughneck", "roughness", "roughshod", "roundelay", "roundness",
    "roundworm", "routinely", "rowdiness", "royalists", "royalties",
    "rubberier", "rubbished", "rubbishes", "rucksacks", "ruddiness",
    "rudiments", "ruffianed", "ruggedest", "ruination", "ruinously",
    "rumblings", "ruminants", "ruminated", "ruminates", "rummaging",
    "runabouts", "runaround", "rupturing", "rusticity", "rustiness",
    "rustlings", "rustproof", "rutabagas", "sabotaged", "sabotages",
    "saboteurs", "saccharin", "sackcloth", "sacrament", "sacrifice",
    "sacrilege", "sacristan", "saddening", "saddlebag", "safariing",
    "safeguard", "safetying", "safflower", "sagacious", "sagebrush",
    "sailboard", "sailboats", "sailcloth", "sainthood", "saintlier",
    "salaaming", "salacious", "salarying", "salerooms", "salesgirl",
    "salesroom", "salivated", "salivates", "sallowest", "saltboxes",
    "saltiness", "saltwater", "salvaging", "salvation", "sanctions",
    "sanctuary", "sandbanks", "sandblast", "sandboxes", "sandiness",
    "sandpaper", "sandpiper", "sandstone", "sandstorm", "sangfroid",
    "sanguined", "sanguines", "sapphires", "sapsucker", "sarcastic",
    "sardining", "sartorial", "sashaying", "sassafras", "satanists",
    "satellite", "satiating", "satinwood", "satirical", "satirists",
    "satisfied", "satisfies", "saturated", "saturates", "saturnine",
    "saucepans", "sauciness", "sauntered", "sawdusted", "sawhorses",
    "saxophone", "scabbards", "scabbiest", "scaffolds", "scalawags",
    "scaldings", "scaliness", "scallions", "scalloped", "scallywag",
    "scampered", "scantiest", "scapegoat", "scarecrow", "scarified",
    "scarifies", "scarleted", "scarpered", "scattered", "scavenged",
    "scavenger", "scavenges", "scenarios", "scheduled", "scheduler",
    "schedules", "schematic", "schemings", "schizoids", "schlemiel",
    "schlepped", "schmaltzy", "schmoozed", "schmoozer", "schmoozes",
    "schnauzer", "schnitzel", "scholarly", "schoolbag", "schoolboy",
    "schooling", "schoolkid", "schooners", "schussing", "scientist",
    "scimitars", "scintilla", "sclerosis", "sclerotic", "scofflaws",
    "scoldings", "scoliosis", "scorchers", "scorching", "scorecard",
    "scoreless", "scoreline", "scorpions", "scotching", "scoundrel",
    "scourging", "scrabbled", "scrabbles", "scraggier", "scrambled",
    "scrambler", "scrambles", "scramming", "scrapbook", "scrapheap",
    "scrapings", "scrappier", "scrapping", "scrapyard", "scratched",
    "scratches", "scrawling", "scrawnier", "screaming", "screeched",
    "screeches", "screening", "screwball", "screwiest", "scribbled",
    "scribbler", "scribbles", "scrimmage", "scrimping", "scrimshaw",
    "scripting", "scripture", "scrolling", "scrounged", "scrounger",
    "scrounges", "scrubbers", "scrubbier", "scrubbing", "scruffier",
    "scruffily", "scrumhalf", "scrummage", "scrumming", "scrumping",
    "scrunched", "scrunches", "scrupling", "scuffling", "scullions",
    "sculpting", "sculptors", "sculpture", "scummiest", "scuppered",
    "scurfiest", "scurrying", "scurviest", "scuttling", "scuzziest",
    "seaboards", "seacoasts", "seafarers", "seafaring", "seafronts",
    "seahorses", "seaplanes", "searchers", "searching", "searingly",
    "seascapes", "seashells", "seashores", "seasoning", "seaworthy",
    "sebaceous", "secateurs", "secession", "secluding", "seclusion",
    "seclusive", "secondary", "seconders", "seconding", "secretary",
    "secretest", "secreting", "secretion", "secretive", "sectarian",
    "sectional", "sectioned", "sedatives", "sedentary", "sediments",
    "seditious", "seduction", "seductive", "seediness", "seedlings",
    "seemingly", "seemliest", "seesawing", "seethings", "segmented",
    "segregate", "selecting", "selection", "selective", "selectman",
    "selectmen", "selectors", "selfishly", "sellotape", "selvaging",
    "semantics", "semaphore", "semblance", "semesters", "semibreve",
    "semicolon", "semifinal", "semiotics", "semitones", "semivowel",
    "senescent", "seniority", "sensation", "senseless", "sensibler",
    "sensibles", "sensitive", "sensually", "sentenced", "sentences",
    "sentience", "sentiment", "sentinels", "separable", "separated",
    "separates", "separator", "sequenced", "sequencer", "sequences",
    "sequester", "sequining", "seraglios", "serenaded", "serenades",
    "sergeants", "seriously", "sermoning", "serotonin", "serpented",
    "servanted", "serveries", "servicing", "serviette", "servility",
    "servitude", "setsquare", "seventeen", "seventies", "severally",
    "severance", "sextuplet", "sexuality", "shabbiest", "shackling",
    "shadiness", "shadowbox", "shadowier", "shadowing", "shaggiest",
    "shakedown", "shakeouts", "shakiness", "shallower", "shallowly",
    "shamanism", "shambling", "shambolic", "shameless", "shampooed",
    "shamrocks", "shanghais", "shapeless", "shapelier", "shareware",
    "sharkskin", "sharpened", "sharpener", "sharpness", "shattered",
    "sheathing", "sheepdogs", "sheepfold", "sheepskin", "sheikdoms",
    "shellfire", "shellfish", "sheltered", "shepherds", "shielding",
    "shiftiest", "shiftless", "shillings", "shimmered", "shimmying",
    "shinbones", "shingling", "shininess", "shinnying", "shipboard",
    "shiploads", "shipmates", "shipments", "shipowner", "shipshape",
    "shipwreck", "shipyards", "shirrings", "shirttail", "shitfaced",
    "shitheads", "shittiest", "shivering", "shoddiest", "shoehorns",
    "shoelaces", "shoemaker", "shoeshine", "shoetrees", "shootings",
    "shootouts", "shopfront", "shoplifts", "shoreline", "shortages",
    "shortcake", "shortcuts", "shortened", "shortfall", "shorthand",
    "shorthorn", "shortlist", "shortness", "shortstop", "shortwave",
    "shoulders", "shouldest", "shovelful", "showboats", "showcased",
    "showcases", "showdowns", "showerier", "showering", "showgirls",
    "showiness", "showpiece", "showplace", "showrooms", "shredders",
    "shredding", "shrewdest", "shrieking", "shrillest", "shrilling",
    "shrimpers", "shrimping", "shrinkage", "shrinking", "shrouding",
    "shrubbery", "shrubbier", "shrubbing", "shrugging", "shuddered",
    "shufflers", "shuffling", "shutdowns", "shuttered", "shuttling",
    "sibilants", "sickening", "sickliest", "sickrooms", "sideboard",
    "sideburns", "sidekicks", "sidelight", "sidelined", "sidelines",
    "sideshows", "sidesteps", "sideswipe", "sidetrack", "sidewalks",
    "sidewalls", "sightings", "sightless", "sightread", "sightseer",
    "signalman", "signalmen", "signatory", "signature", "signboard",
    "signified", "signifies", "signposts", "silencers", "silencing",
    "silentest", "silicates", "siliceous", "silicosis", "silkening",
    "silkiness", "silkworms", "silliness", "silverier", "silvering",
    "similarly", "simmering", "simpatico", "simpering", "simpleton",
    "simulacra", "simulated", "simulates", "simulator", "simulcast",
    "sincerely", "sincerest", "sincerity", "sinecures", "singalong",
    "singleton", "singsongs", "singulars", "sinkholes", "sinuously",
    "sinusitis", "sistering", "situating", "situation", "sixpences",
    "sixteenth", "sixtieths", "skedaddle", "skeletons", "sketchier",
    "sketchily", "sketching", "sketchpad", "skewbalds", "skewering",
    "skilfully", "skimpiest", "skinflint", "skinheads", "skinniest",
    "skintight", "skippered", "skittered", "skivvying", "skullcaps",
    "skydivers", "skydiving", "skyjacked", "skyjacker", "skylarked",
    "skylights", "skyrocket", "skywriter", "slackened", "slackness",
    "slagheaps", "slaloming", "slandered", "slanderer", "slangiest",
    "slantwise", "slaphappy", "slapstick", "slathered", "slatterns",
    "slaughter", "slavering", "slavishly", "sleazebag", "sleaziest",
    "sleekness", "sleepiest", "sleepless", "sleepover", "sleepwalk",
    "sleepwear", "sleetiest", "sleighing", "slenderer", "sleuthing",
    "slickness", "slightest", "slighting", "sliminess", "slingback",
    "slingshot", "slinkiest", "slipcases", "slipcover", "slipknots",
    "slippages", "slithered", "slivering", "slobbered", "sloppiest",
    "slouchier", "slouching", "sloughing", "slowcoach", "slowdowns",
    "slowpokes", "sluggards", "slumbered", "slumlords", "slushiest",
    "smallness", "smarmiest", "smartened", "smartness", "smelliest",
    "smilingly", "smirching", "smoggiest", "smokeless", "smokiness",
    "smoldered", "smooching", "smoothest", "smoothies", "smoothing",
    "smothered", "smudgiest", "smugglers", "smuggling", "smuttiest",
    "snaffling", "snakebite", "snakeskin", "snappiest", "snapshots",
    "snatchers", "snatching", "snazziest", "sneakiest", "snickered",
    "sniffiest", "sniffling", "sniftered", "snippiest", "snitching",
    "snobbiest", "snookered", "snoopiest", "snootiest", "snorkeled",
    "snorkeler", "snottiest", "snowballs", "snowboard", "snowbound",
    "snowdrift", "snowdrops", "snowfalls", "snowfield", "snowflake",
    "snowplows", "snowshoes", "snowstorm", "snowsuits", "snuffling",
    "snuggling", "soapboxed", "soapboxes", "soapiness", "soapstone",
    "soberness", "sobriquet", "sociables", "socialism", "socialist",
    "socialite", "societies", "sociology", "sociopath", "sodomites",
    "softballs", "softcover", "softeners", "softening", "softwoods",
    "sogginess", "sojourned", "soldering", "soldiered", "soldierly",
    "solecisms", "solemnest", "solemnity", "solenoids", "solicited",
    "solicitor", "solidness", "soliloquy", "solipsism", "solitaire",
    "solstices", "solutions", "sombreros", "someplace", "something",
    "sometimes", "somewhats", "somewhere", "somnolent", "songbirds",
    "songbooks", "songsters", "sonograms", "soothings", "sophistry",
    "sophomore", "soporific", "sorcerers", "sorceress", "soreheads",
    "sorrowful", "sorrowing", "sortieing", "soulfully", "soundbite",
    "soundings", "soundless", "soundness", "sourdough", "southeast",
    "southerly", "southerns", "southpaws", "southward", "southwest",
    "souvenirs", "sovereign", "spaceship", "spacesuit", "spacewalk",
    "spadefuls", "spadework", "spaghetti", "spangling", "spankings",
    "spareness", "spareribs", "sparingly", "sparkiest", "sparklers",
    "sparkling", "spasmodic", "spatially", "spattered", "speakeasy",
    "spearhead", "spearmint", "specialer", "specially", "specifics",
    "specified", "specifier", "specifies", "specimens", "speckling",
    "spectacle", "spectated", "spectates", "spectator", "speculate",
    "speechify", "speeching", "speedboat", "speediest", "speedster",
    "speedways", "spellbind", "spellings", "spelunker", "spherical",
    "spheroids", "sphincter", "spiciness", "spiderier", "spiderweb",
    "spiffiest", "spiffying", "spikiness", "spillages", "spillover",
    "spillways", "spindlier", "spindling", "spineless", "spinnaker",
    "spinsters", "spiriting", "spiritual", "spitballs", "spitfires",
    "spittoons", "splashier", "splashing", "splatters", "splatting",
    "splenetic", "splinters", "splinting", "splitting", "sploshing",
    "splotched", "splotches", "splurging", "splutters", "spokesman",
    "spokesmen", "spongiest", "sponsored", "spookiest", "spoonbill",
    "spoonfuls", "sportiest", "sportsman", "sportsmen", "spotlight",
    "spottiest", "spraining", "sprawling", "spreaders", "spreading",
    "sprightly", "springbok", "springier", "springing", "sprinkled",
    "sprinkler", "sprinkles", "sprinters", "sprinting", "spritzers",
    "spritzing", "sprockets", "sprouting", "spunkiest", "sputtered",
    "spymaster", "squabbing", "squabbled", "squabbles", "squaddies",
    "squadding", "squadrons", "squalider", "squalling", "squanders",
    "squashier", "squashing", "squatters", "squattest", "squatting",
    "squawking", "squeakier", "squeaking", "squealers", "squealing",
    "squeamish", "squeegeed", "squeegees", "squeezers", "squeezing",
    "squelched", "squelches", "squidding", "squiggled", "squiggles",
    "squintest", "squinting", "squirmier", "squirming", "squirrels",
    "squirting", "squishier", "squishing", "stabbings", "stability",
    "stableman", "stablemen", "staccatos", "stagehand", "staggered",
    "stagnated", "stagnates", "stainless", "staircase", "stairways",
    "stairwell", "stakeouts", "stalemate", "staleness", "stalkings",
    "stallions", "stalwarts", "stammered", "stammerer", "stampeded",
    "stampedes", "stanchest", "stanching", "stanchion", "standards",
    "standings", "standoffs", "standouts", "standpipe", "starboard",
    "starchier", "starchily", "starching", "starfruit", "stargazed",
    "stargazer", "stargazes", "starkness", "starlight", "starlings",
    "starriest", "startling", "starvings", "statehood", "stateless",
    "statelier", "statement", "stateroom", "stateside", "statesman",
    "statesmen", "statewide", "stationed", "stationer", "statistic",
    "statuette", "statutory", "staunched", "stauncher", "staunches",
    "staunchly", "steadfast", "steadiest", "steadying", "steamboat",
    "steamiest", "steamroll", "steamship", "steeliest", "steepened",
    "steepness", "stenching", "stepchild", "sterility", "sternness",
    "stevedore", "stewarded", "stickiest", "sticklers", "stickpins",
    "stickying", "stiffened", "stiffener", "stiffness", "stiflings",
    "stilettos", "stillborn", "stillness", "stiltedly", "stimulant",
    "stimulate", "stingiest", "stingrays", "stinkings", "stippling",
    "stipulate", "stirrings", "stitching", "stockaded", "stockades",
    "stockiest", "stockings", "stockists", "stockpile", "stockroom",
    "stockyard", "stodgiest", "stoically", "stolidest", "stolidity",
    "stomached", "stonewall", "stoneware", "stonework", "stonkered",
    "stopcocks", "stoplight", "stopovers", "stoppable", "stoppages",
    "stoppered", "stopwatch", "storeroom", "stormiest", "storybook",
    "stoutness", "stovepipe", "stowaways", "straddled", "straddles",
    "straggled", "straggler", "straggles", "straights", "strainers",
    "straining", "straitens", "straiting", "stranding", "strangely",
    "strangers", "strangest", "strangled", "strangler", "strangles",
    "strapless", "strapping", "stratagem", "strategic", "streakers",
    "streakier", "streaking", "streamers", "streaming", "streetcar",
    "strengths", "strenuous", "stressful", "stressing", "stretched",
    "stretcher", "stretches", "striation", "strictest", "stricture",
    "stridency", "strikeout", "strikings", "stringent", "stringers",
    "stringier", "stringing", "stripling", "strippers", "stripping",
    "strollers", "strolling", "strongbox", "strongest", "strongman",
    "strongmen", "strontium", "stroppier", "stroppily", "stropping",
    "structure", "struggled", "struggles", "strumming", "strumpets",
    "strutting", "stubbiest", "stubblier", "stubborns", "stuccoing",
    "studbooks", "stuffiest", "stumblers", "stumbling", "stumpiest",
    "stupefied", "stupefies", "stupidest", "stupidity", "sturdiest",
    "sturgeons", "stuttered", "stutterer", "stylishly", "stylistic",
    "stymieing", "subaltern", "subarctic", "subatomic", "subdivide",
    "subeditor", "subgroups", "subhumans", "subjected", "subjoined",
    "subjugate", "subleased", "subleases", "sublimate", "sublimely",
    "sublimest", "subliming", "sublimity", "submarine", "submerged",
    "submerges", "submersed", "submerses", "submitted", "submitter",
    "subnormal", "suborning", "subpoenas", "subscribe", "subscript",
    "subsidies", "subsiding", "subsisted", "subsoiled", "substance",
    "substrata", "substrate", "subsuming", "subsystem", "subtenant",
    "subtended", "subtitled", "subtitles", "subtotals", "subtracts",
    "suburbans", "subverted", "succeeded", "successes", "successor",
    "succotash", "succulent", "succumbed", "suckering", "sucklings",
    "suctioned", "sufferers", "suffering", "sufficing", "suffixing",
    "suffocate", "suffragan", "suffusing", "suffusion", "sugarcane",
    "sugarcoat", "sugariest", "sugarless", "suggested", "suggester",
    "suitcases", "sulkiness", "sullenest", "sulphates", "sulphides",
    "sultanate", "sultriest", "summaries", "summarily", "summation",
    "summerier", "summering", "summoners", "summoning", "summonsed",
    "summonses", "sumptuous", "sunbathed", "sunbather", "sunbathes",
    "sunblocks", "sunbonnet", "sunburned", "sundering", "sunfishes",
    "sunflower", "sunrising", "sunscreen", "sunshades", "sunstroke",
    "suntanned", "superbest", "superegos", "superglue", "superhero",
    "superiors", "supernova", "supersede", "superstar", "supervene",
    "supervise", "supplants", "suppliant", "suppliers", "supplying",
    "supported", "supporter", "supposing", "suppurate", "supremacy",
    "supremely", "supremest", "surceased", "surceases", "surcharge",
    "surfacing", "surfboard", "surfeited", "surgeries", "surliness",
    "surmising", "surmounts", "surpassed", "surpasses", "surplices",
    "surpluses", "surprised", "surprises", "surrender", "surrogacy",
    "surrogate", "surrounds", "surtaxing", "surtitles", "surveying",
    "surveyors", "survivals", "surviving", "survivors", "suspected",
    "suspended", "suspender", "suspicion", "sustained", "swaddling",
    "swaggered", "swaggerer", "swallowed", "swampiest", "swankiest",
    "swansongs", "swarthier", "swastikas", "swattered", "swearword",
    "sweatband", "sweatiest", "sweatshop", "sweatsuit", "sweepings",
    "sweetcorn", "sweetened", "sweetener", "sweetmeat", "sweetness",
    "swellhead", "swellings", "sweltered", "swiftness", "swimsuits",
    "swindlers", "swindling", "swingeing", "swirliest", "switching",
    "swooshing", "swordfish", "swordplay", "swordsman", "swordsmen",
    "sybarites", "sybaritic", "sycamores", "sycophant", "syllabify",
    "syllables", "syllabubs", "syllogism", "sylphlike", "symbioses",
    "symbiosis", "symbiotic", "symbolics", "symbolism", "symmetric",
    "symphonic", "symposium", "synagogue", "syncopate", "syndicate",
    "syndromes", "synergies", "synergism", "syntactic", "syntheses",
    "synthesis", "synthetic", "syringing", "systemics", "tableland",
    "tableware", "tabulated", "tabulates", "tabulator", "tacitness",
    "tackiness", "tactfully", "tactician", "tailbacks", "tailboard",
    "tailbones", "tailcoats", "tailgated", "tailgates", "taillight",
    "tailoring", "tailpiece", "tailpipes", "tailspins", "tailwinds",
    "takeaways", "takeovers", "talismans", "talkative", "tallyhoed",
    "tamarinds", "tamoxifen", "tampering", "tangerine", "tangibles",
    "tanneries", "tapeworms", "tarantula", "tardiness", "targeting",
    "tarmacked", "tarnished", "tarnishes", "tarpaulin", "tarragons",
    "tasteless", "tastiness", "tattering", "tattooing", "tattooist",
    "tautening", "tautology", "tawdriest", "taxidermy", "taxonomic",
    "taxpayers", "teachable", "teachings", "teakettle", "teammates",
    "teamsters", "tearaways", "teardrops", "tearfully", "teargases",
    "teasingly", "teaspoons", "technical", "technique", "tectonics",
    "tediously", "teenagers", "teetering", "telecasts", "telegenic",
    "telegrams", "telegraph", "telemeter", "telemetry", "teleology",
    "telepathy", "telephone", "telephony", "telephoto", "telesales",
    "telescope", "telethons", "teletypes", "televised", "televises",
    "tellering", "tellingly", "telltales", "temperate", "tempering",
    "templates", "temporary", "temptings", "temptress", "tenacious",
    "tenancies", "tenanting", "tenderest", "tendering", "tenements",
    "tenseness", "tentacles", "tentative", "tenuously", "termagant",
    "terminals", "terminate", "terracing", "terrapins", "terrarium",
    "terrified", "terrifies", "territory", "terrorism", "terrorist",
    "terseness", "testament", "testicles", "testified", "testifies",
    "testimony", "testiness", "tetchiest", "tethering", "textbooks",
    "textually", "thankless", "thatchers", "thatching", "thematics",
    "theocracy", "theoretic", "theorists", "theosophy", "therapies",
    "therapist", "therefore", "therefrom", "thereupon", "therewith",
    "thermally", "thermoses", "thesaurus", "thespians", "thickened",
    "thickener", "thickness", "thighbone", "thimbling", "thingummy",
    "thinkable", "thirstier", "thirstily", "thirsting", "thirteens",
    "thirtieth", "thorniest", "thousands", "thralldom", "thralling",
    "thrashers", "thrashing", "threading", "threatens", "threefold",
    "threesome", "threshers", "threshing", "threshold", "thriftier",
    "thriftily", "thrillers", "thrilling", "thrivings", "throatier",
    "throatily", "throbbing", "thronging", "throttled", "throttles",
    "throwaway", "throwback", "thrumming", "thrusting", "thumbnail",
    "thumbtack", "thundered", "thwacking", "thwarting", "ticketing",
    "tidemarks", "tidewater", "tiebreaks", "tightened", "tightness",
    "tightrope", "tightwads", "tigresses", "timeliest", "timepiece",
    "timescale", "timeshare", "timetable", "timpanist", "tinctured",
    "tinctures", "tinderbox", "tingliest", "tinkering", "tinsmiths",
    "tippexing", "tipsiness", "tiptoeing", "tiredness", "titillate",
    "titivated", "titivates", "tittering", "toadstool", "toastiest",
    "toboggans", "toileting", "tolerable", "tolerably", "tolerance",
    "tolerated", "tolerates", "tollbooth", "tollgates", "tomahawks",
    "tombstone", "tomorrows", "tonsorial", "tonsuring", "toolboxes",
    "toothache", "toothiest", "toothless", "toothpick", "toothsome",
    "topically", "toreadors", "tormented", "tormentor", "tornadoes",
    "torpedoed", "torpedoes", "torpidity", "torridest", "tortillas",
    "tortoises", "torturers", "torturing", "torturous", "tottering",
    "touchdown", "touchiest", "touchings", "touchline", "toughened",
    "toughness", "towelette", "towheaded", "townhouse", "townsfolk",
    "townships", "traceable", "traceries", "trackball", "tracksuit",
    "tractable", "trademark", "tradesman", "tradesmen", "tradition",
    "traducing", "tragedian", "tragedies", "trailered", "traipsing",
    "tramlines", "trampling", "transacts", "transcend", "transepts",
    "transfers", "transform", "transfuse", "transient", "transited",
    "translate", "transmits", "transmute", "transpire", "transport",
    "transpose", "transship", "trapdoors", "trapezing", "trapezium",
    "trapezoid", "trappable", "trappings", "trashcans", "trashiest",
    "traumatic", "travailed", "traversed", "traverses", "treachery",
    "treacling", "treadling", "treadmill", "treasured", "treasurer",
    "treasures", "treatable", "treatises", "treatment", "trellised",
    "trellises", "trembling", "tremulous", "trenchant", "trenchers",
    "trenching", "trendiest", "trialling", "triangles", "triathlon",
    "tribalism", "tribesman", "tribesmen", "tribunals", "tributary",
    "tricepses", "trickiest", "trickling", "trickster", "tricycled",
    "tricycles", "triennial", "trifocals", "triggered", "trillions",
    "trilogies", "trimarans", "trimester", "trimmings", "trinities",
    "triplying", "triptychs", "tripwires", "trisected", "triteness",
    "triumphal", "triumphed", "trivially", "trolloped", "trombones",
    "troopship", "trophying", "tropicals", "troubling", "trouncing",
    "trousseau", "truanting", "truckling", "truckload", "truculent",
    "trueloves", "trumpeted", "trumpeter", "truncated", "truncates",
    "truncheon", "trundling", "trustiest", "tubercles", "tuckering",
    "tumescent", "tumulting", "tunefully", "turbidity", "turbojets",
    "turboprop", "turbulent", "turgidity", "turmerics", "turmoiled",
    "turnabout", "turncoats", "turniping", "turnovers", "turnpikes",
    "turnround", "turnstile", "turntable", "turpitude", "turquoise",
    "tutorials", "twaddling", "tweediest", "twentieth", "twiddling",
    "twiggiest", "twinkling", "twitchier", "twitching", "twittered",
    "twopences", "tympanums", "typecasts", "typefaces", "typewrite",
    "typewrote", "typically", "typifying", "tyrannies", "tyrannous",
    "ulcerated", "ulcerates", "ultimated", "ultimates", "ultimatum",
    "ululating", "ululation", "umbilical", "umbilicus", "umbraging",
    "umbrellas", "umpteenth", "unabashed", "unadorned", "unadvised",
    "unalloyed", "unaltered", "unanimity", "unanimous", "unashamed",
    "unbalance", "unbarring", "unbeknown", "unbending", "unbinding",
    "unblocked", "unbolting", "unbosomed", "unbounded", "unbranded",
    "unbridled", "unbuckled", "unbuckles", "unburdens", "unbuttons",
    "uncannier", "uncannily", "unceasing", "uncertain", "unchanged",
    "uncharted", "unchecked", "unclaimed", "unclasped", "uncleaner",
    "uncleanly", "unclearer", "unclothed", "unclothes", "uncoiling",
    "unconcern", "uncorking", "uncounted", "uncoupled", "uncouples",
    "uncovered", "uncurling", "undamaged", "undaunted", "undeceive",
    "undecided", "undefined", "underacts", "underarms", "underbids",
    "undercoat", "undercuts", "underdogs", "underdone", "underfeed",
    "underflow", "underfoot", "undergoes", "undergone", "undergrad",
    "underhand", "underlain", "underlays", "underlies", "underline",
    "underling", "undermine", "undermost", "underpaid", "underpass",
    "underpays", "underpins", "underplay", "underrate", "underseas",
    "undersell", "undershot", "underside", "undersign", "undersold",
    "undertake", "undertone", "undertook", "undertows", "underused",
    "underwear", "underwent", "undiluted", "undivided", "undoubted",
    "undressed", "undresses", "undulated", "undulates", "unearthed",
    "unearthly", "uneasiest", "uneatable", "unequally", "unethical",
    "unevenest", "unfailing", "unfairest", "unfastens", "unfeeling",
    "unfeigned", "unfetters", "unfitting", "unfocused", "unfolding",
    "unfounded", "unfrocked", "unfurling", "ungodlier", "unguarded",
    "ungulates", "unhanding", "unhappier", "unhappily", "unhealthy",
    "unhelpful", "unhinging", "unhitched", "unhitches", "unholiest",
    "unhooking", "unhorsing", "unhurried", "unicycles", "uniformed",
    "uniformer", "uniformly", "unimpeded", "uninjured", "uninsured",
    "uninvited", "unionists", "universal", "universes", "unkindest",
    "unknowing", "unlatched", "unlatches", "unleashed", "unleashes",
    "unlimited", "unloading", "unlocking", "unloosing", "unluckier",
    "unluckily", "unmanlier", "unmanning", "unmarried", "unmasking",
    "unmatched", "unmindful", "unmusical", "unnatural", "unnerving",
    "unnoticed", "unopposed", "unpacking", "unpainted", "unpicking",
    "unpinning", "unplanned", "unplugged", "unplumbed", "unpopular",
    "unquoting", "unreadier", "unreality", "unrefined", "unrelated",
    "unresting", "unrolling", "unruffled", "unruliest", "unsaddled",
    "unsaddles", "unsalable", "unscathed", "unscrewed", "unsealing",
    "unseating", "unsecured", "unselfish", "unsettled", "unsettles",
    "unsheathe", "unsightly", "unskilled", "unsmiling", "unsnapped",
    "unsnarled", "unsounder", "unsparing", "unspoiled", "unstabler",
    "unstopped", "unstudied", "unsullied", "untainted", "untangled",
    "untangles", "untenable", "untidiest", "untouched", "untrained",
    "untreated", "untutored", "untwisted", "untypical", "unusually",
    "unvarying", "unveiling", "unwariest", "unwelcome", "unwilling",
    "unwinding", "unwitting", "unworldly", "unwrapped", "unwritten",
    "unzipping", "upbraided", "upchucked", "upcountry", "upgrading",
    "upheavals", "upholders", "upholding", "upholster", "uplifting",
    "uploading", "uppercase", "uppercuts", "uppermost", "upraising",
    "uprisings", "uprooting", "upsetting", "upstaging", "upstarted",
    "upstreams", "upsurging", "upturning", "urinating", "urination",
    "urologist", "uselessly", "usherette", "utilities", "utterance",
    "uttermost", "vacancies", "vacations", "vaccinate", "vacillate",
    "vacuously", "vacuuming", "vagabonds", "vagueness", "vainglory",
    "valancing", "valencies", "valentine", "valiantly", "validated",
    "validates", "validness", "valuables", "valuation", "valueless",
    "vamoosing", "vampiring", "vandalism", "vanguards", "vanishing",
    "vapidness", "vaporised", "vaporises", "variables", "variances",
    "variation", "varicoses", "variegate", "varieties", "variously",
    "varnished", "varnishes", "varsities", "vasectomy", "vassalage",
    "vassaling", "vectoring", "vegetable", "vegetated", "vegetates",
    "vehemence", "vehicular", "velodrome", "velveteen", "velvetier",
    "velveting", "vendettas", "veneering", "venerable", "venerated",
    "venerates", "vengeance", "ventilate", "ventricle", "venturing",
    "venturous", "veracious", "verballed", "verbosely", "verbosity",
    "verdigris", "verifying", "veritable", "veritably", "vermilion",
    "verminous", "versatile", "versified", "versifies", "vertebrae",
    "vertebral", "verticals", "vestibule", "vestigial", "vestments",
    "vexations", "vexatious", "viability", "vibrantly", "vibrating",
    "vibration", "vibrators", "viburnums", "vicarages", "vicarious",
    "viciously", "victories", "videodisc", "videotape", "viewpoint",
    "vigilance", "vigilante", "vignetted", "vignettes", "vilifying",
    "villagers", "vindicate", "vineyards", "violating", "violation",
    "violators", "violently", "violinist", "virginals", "virginity",
    "virtually", "virtuosos", "virulence", "viscosity", "viscounts",
    "visionary", "visioning", "vitiating", "vitiation", "vitriolic",
    "vivacious", "vividness", "vivifying", "vocalists", "vocations",
    "vocatives", "voiceless", "volcanics", "volcanoes", "volleying",
    "voltmeter", "voluntary", "volunteer", "voodooing", "voodooism",
    "voracious", "vouchsafe", "voyeurism", "vulgarest", "vulgarism",
    "vulgarity", "wackiness", "wainscots", "waistband", "waistcoat",
    "waistline", "walkabout", "walkaways", "walkovers", "wallabies",
    "wallboard", "walloping", "wallowing", "wallpaper", "wanderers",
    "wandering", "wannabees", "wantoning", "wardening", "wardering",
    "wardrobes", "wardrooms", "warehouse", "warhorses", "warmonger",
    "warplanes", "warranted", "washables", "washbasin", "washboard",
    "washbowls", "washcloth", "washering", "washrooms", "washstand",
    "waspishly", "wassailed", "wasteland", "wastering", "watchable",
    "watchband", "watchdogs", "watchword", "waterfall", "waterfowl",
    "waterhole", "wateriest", "waterline", "watermark", "watermill",
    "watershed", "waterside", "waterways", "wavebands", "wayfarers",
    "wayfaring", "waylaying", "waywardly", "weakening", "weakliest",
    "weaklings", "wealthier", "weariness", "wearisome", "weathered",
    "webmaster", "weekended", "weekender", "weeknight", "weightier",
    "weightily", "weighting", "weirdness", "welcoming", "weltering",
    "westbound", "westerner", "westwards", "whackings", "whalebone",
    "wheatgerm", "wheatmeal", "wheedling", "wheelbase", "wheeziest",
    "wherefore", "whereupon", "whetstone", "whichever", "whimpered",
    "whimsical", "whimsiest", "whingeing", "whinniest", "whinnying",
    "whippings", "whirligig", "whirlpool", "whirlwind", "whiskered",
    "whispered", "whistlers", "whistling", "whitebait", "whitecaps",
    "whitefish", "whiteners", "whiteness", "whitening", "whitewall",
    "whitewash", "whithered", "whittlers", "whittling", "whodunits",
    "wholefood", "wholemeal", "wholeness", "wholesale", "wholesome",
    "whooshing", "whoppings", "whosoever", "wickedest", "widowhood",
    "wifeliest", "wiggliest", "wigwagged", "wildfires", "willinger",
    "willingly", "willowier", "willpower", "windblown", "windbreak",
    "windburns", "windfalls", "windiness", "windmills", "windowing",
    "windpipes", "windsocks", "windstorm", "windsurfs", "windswept",
    "wineglass", "wingspans", "winnowing", "winsomely", "winsomest",
    "wintering", "wintriest", "wiseacres", "wisecrack", "wiseliest",
    "wishbones", "wishfully", "wisterias", "wistfully", "withdrawn",
    "withdraws", "withering", "withholds", "withstand", "withstood",
    "witlessly", "witnessed", "witnesses", "wittering", "witticism",
    "wittiness", "wittingly", "wobbliest", "woebegone", "woefuller",
    "wolfhound", "wolverine", "womanhood", "womankind", "womanlier",
    "womanlike", "womenfolk", "wonderful", "wondering", "woodblock",
    "woodchuck", "woodcocks", "woodcraft", "woodenest", "woodiness",
    "woodlands", "woodlouse", "woodpiles", "woodsheds", "woodsiest",
    "woodwinds", "woodworms", "wooliness", "woolliest", "wooziness",
    "wordiness", "wordsmith", "workbench", "workbooks", "workforce",
    "workhorse", "workhouse", "workloads", "workmates", "workplace",
    "workrooms", "worksheet", "workshops", "workweeks", "worldlier",
    "worldwide", "wormholes", "worriedly", "worrisome", "worryings",
    "worrywart", "worsening", "worthiest", "worthless", "wranglers",
    "wrangling", "wrappings", "wreathing", "wrenching", "wrestlers",
    "wrestling", "wrigglers", "wrigglier", "wriggling", "wrinklier",
    "wrinklies", "wrinkling", "wristband", "wrongdoer", "wrongness",
    "xenophobe", "xylophone", "yachtsman", "yachtsmen", "yammering",
    "yardstick", "yarmulkes", "yearbooks", "yearlings", "yearnings",
    "yeastiest", "yellowest", "yellowing", "yellowish", "yesterday",
    "yieldings", "youngster", "yuppified", "yuppifies", "zealously",
    "zeitgeist", "zeppelins", "zestfully", "zigzagged", "zippering",
    "zirconium", "zookeeper", "zoologist", "zucchinis"
  };

  const char* w_10[] = {
    "abandoning", "abbreviate", "abdicating", "abdication",
    "abductions", "aberration", "abhorrence", "abjuration",
    "abnegating", "abnegation", "abnormally", "abolishing",
    "abominable", "abominably", "abominated", "abominates",
    "aboriginal", "aborigines", "aboveboard", "abrasively",
    "abrogating", "abrogation", "abruptness", "abscessing",
    "absconding", "absolutely", "absolutest", "absolution",
    "absolutism", "absolutist", "absorbency", "absorbents",
    "absorption", "abstainers", "abstaining", "abstemious",
    "abstention", "abstinence", "abstracted", "abstracter",
    "abstractly", "abstrusely", "abstrusest", "abundances",
    "abundantly", "academical", "acanthuses", "accelerate",
    "accentuate", "acceptable", "acceptably", "acceptance",
    "accessible", "accessibly", "accessions", "accidental",
    "acclaiming", "acclimated", "acclimates", "accolading",
    "accomplice", "accomplish", "accordance", "accordions",
    "accountant", "accounting", "accredited", "accretions",
    "accumulate", "accurately", "accusation", "accusative",
    "accusatory", "accusingly", "accustomed", "achievable",
    "achromatic", "acidifying", "acoustical", "acquainted",
    "acquiesced", "acquiesces", "acquirable", "acquittals",
    "acquitting", "acrobatics", "actionable", "activating",
    "activation", "activities", "adaptation", "addictions",
    "additional", "addressees", "addressing", "adequately",
    "adjacently", "adjectival", "adjectives", "adjourning",
    "adjudicate", "adjuration", "adjustable", "adjustment",
    "administer", "admiration", "admiringly", "admissible",
    "admissions", "admittance", "admittedly", "admixtures",
    "admonished", "admonishes", "admonition", "admonitory",
    "adolescent", "adornments", "adrenaline", "adroitness",
    "adulterant", "adulterate", "adulterers", "adulteress",
    "adulteries", "adulterous", "adumbrated", "adumbrates",
    "advantaged", "advantages", "adventured", "adventurer",
    "adventures", "adverbials", "advertised", "advertiser",
    "advertises", "advisement", "advisories", "advocating",
    "aerialists", "aerobatics", "aerodromes", "aerogramme",
    "aeronautic", "aesthetics", "affability", "affectedly",
    "affections", "affidavits", "affiliated", "affiliates",
    "affinities", "afflicting", "affliction", "affluently",
    "affordable", "afforested", "affronting", "aficionado",
    "afterbirth", "afterglows", "afterlives", "aftermaths",
    "afternoons", "aftershave", "aftershock", "aftertaste",
    "afterwords", "aggravated", "aggravates", "aggregated",
    "aggregates", "aggression", "aggressive", "aggressors",
    "aggrieving", "agitations", "agreements", "agronomist",
    "airbrushed", "airbrushes", "airdropped", "airletters",
    "airlifting", "airmailing", "alarmingly", "alchemists",
    "alcoholics", "alcoholism", "alderwoman", "alderwomen",
    "algorithms", "alienating", "alienation", "alignments",
    "alimentary", "alkalinity", "allegation", "allegiance",
    "allegories", "allergenic", "allergists", "alleviated",
    "alleviates", "alligators", "allocating", "allocation",
    "allotments", "allowances", "alluringly", "allusively",
    "almshouses", "alphabeted", "alphabetic", "altarpiece",
    "alteration", "alternated", "alternates", "alternator",
    "altimeters", "altogether", "altruistic", "amalgamate",
    "amanuenses", "amanuensis", "amateurish", "amateurism",
    "ambassador", "ambivalent", "ambulances", "ambulatory",
    "ameliorate", "amendments", "amiability", "ammunition",
    "amnestying", "ampersands", "amphibians", "amphibious",
    "amplifiers", "amplifying", "amplitudes", "amputating",
    "amputation", "amusements", "analgesics", "analytical",
    "anarchists", "anatomical", "anatomists", "ancestored",
    "ancestress", "ancestries", "anchorages", "anchorites",
    "ancientest", "anemometer", "angiosperm", "angleworms",
    "anglicisms", "anglophile", "anglophone", "anguishing",
    "angularity", "animatedly", "animations", "annexation",
    "annihilate", "annotating", "annotation", "announcers",
    "announcing", "annoyances", "annoyingly", "annulments",
    "anointment", "answerable", "antagonism", "antagonist",
    "antebellum", "antecedent", "antedating", "anthracite",
    "anthropoid", "antibiotic", "antibodies", "anticipate",
    "anticlimax", "antifreeze", "antiheroes", "antimatter",
    "antipastos", "antiphonal", "antiquated", "antiquates",
    "antiseptic", "antisocial", "antitheses", "antithesis",
    "antithetic", "antitoxins", "antivirals", "antonymous",
    "apartments", "aphoristic", "apocalypse", "apocryphal",
    "apolitical", "apologetic", "apologists", "apoplectic",
    "apoplexies", "apostasies", "apostrophe", "apothecary",
    "apotheoses", "apotheosis", "apparently", "apparition",
    "appearance", "appellants", "appendages", "appendices",
    "appendixes", "appertains", "applauding", "applesauce",
    "appliances", "applicable", "applicants", "applicator",
    "appointees", "appointing", "apportions", "appositely",
    "apposition", "appositive", "appraisals", "appraisers",
    "appraising", "appreciate", "apprehends", "apprentice",
    "approached", "approaches", "aquamarine", "aquaplaned",
    "aquaplanes", "arabesques", "arbitrager", "arbitrated",
    "arbitrates", "arbitrator", "arboretums", "arborvitae",
    "archangels", "archbishop", "archdeacon", "archetypal",
    "archetypes", "architects", "archivists", "aristocrat",
    "arithmetic", "armadillos", "armaturing", "armistices",
    "arraigning", "arrogantly", "arrogating", "arrowheads",
    "artfulness", "arthritics", "arthropods", "artichokes",
    "articulacy", "articulate", "artificers", "artificial",
    "ascendancy", "ascendants", "ascensions", "ascertains",
    "asceticism", "ascribable", "ascription", "asperities",
    "aspersions", "asphalting", "asphyxiate", "aspidistra",
    "aspirating", "aspiration", "assailable", "assailants",
    "assaulting", "assemblage", "assemblers", "assemblies",
    "assembling", "assertions", "assessment", "asseverate",
    "assignable", "assignment", "assimilate", "assistance",
    "assistants", "associated", "associates", "assortment",
    "assumption", "assurances", "asterisked", "asthmatics",
    "astigmatic", "astonished", "astonishes", "astounding",
    "astringent", "astrologer", "astronauts", "astronomer",
    "astronomic", "astuteness", "asymmetric", "asymptotic",
    "atmosphere", "atrocities", "atrophying", "attachment",
    "attainable", "attainment", "attempting", "attendance",
    "attendants", "attentions", "attenuated", "attenuates",
    "attracting", "attraction", "attractive", "attributed",
    "attributes", "atypically", "aubergines", "auctioneer",
    "auctioning", "audibility", "audiophile", "audiotapes",
    "auditioned", "auditorium", "augmenting", "auspicious",
    "authorship", "autocratic", "autographs", "autoimmune",
    "automakers", "automatics", "automating", "automation",
    "automatons", "automobile", "automotive", "autonomous",
    "autopilots", "autopsying", "autoworker", "avalanches",
    "avaricious", "aviatrices", "aviatrixes", "avocations",
    "awakenings", "awkwardest", "axiomatics", "ayatollahs",
    "babysitter", "bacchanals", "backbiters", "backbiting",
    "backbitten", "backboards", "backcloths", "backcombed",
    "backdating", "backfields", "backfiring", "backgammon",
    "background", "backhanded", "backhander", "backlashes",
    "backlogged", "backpacked", "backpacker", "backpedals",
    "backslider", "backslides", "backspaced", "backspaces",
    "backstairs", "backstreet", "backstroke", "backtracks",
    "backwaters", "badmouthed", "bafflement", "bagatelles",
    "bailiwicks", "balaclavas", "balalaikas", "balderdash",
    "balefuller", "balladeers", "ballasting", "ballerinas",
    "ballistics", "ballooning", "balloonist", "ballplayer",
    "ballpoints", "ballyhooed", "balustrade", "bamboozled",
    "bamboozles", "banalities", "bandleader", "bandmaster",
    "bandoleers", "bandstands", "bandwagons", "banefuller",
    "banishment", "bankrolled", "bankruptcy", "bankrupted",
    "banqueting", "banquettes", "baptistery", "barbarians",
    "barbarisms", "barbecuing", "barberries", "barbershop",
    "barefooted", "barehanded", "bareheaded", "bargaining",
    "barkeepers", "barnstorms", "barometers", "barometric",
    "baronesses", "barracking", "barracudas", "barrenness",
    "barricaded", "barricades", "barristers", "bartenders",
    "baseboards", "basketball", "basketwork", "bassoonist",
    "bathhouses", "battalions", "batterings", "battlement",
    "battleship", "bayberries", "bayoneting", "bazillions",
    "beachfront", "beachheads", "beanfeasts", "beansprout",
    "beastliest", "beatifying", "beatitudes", "beautician",
    "beautified", "beautifier", "beautifies", "becomingly",
    "becquerels", "bedazzling", "bedchamber", "bedclothes",
    "bedfellows", "bedraggled", "bedraggles", "bedsitters",
    "bedspreads", "beefburger", "beefsteaks", "beekeepers",
    "beekeeping", "beforehand", "befriended", "befuddling",
    "beginnings", "begrudging", "behindhand", "beleaguers",
    "believable", "belittling", "belladonna", "bellwether",
    "bellyached", "bellyaches", "belongings", "benchmarks",
    "benefactor", "beneficent", "beneficial", "benefiting",
    "benevolent", "bequeathed", "beseeching", "besmirched",
    "besmirches", "bespeaking", "bestiality", "bestiaries",
    "bestirring", "bestridden", "bestriding", "bestseller",
    "bethinking", "betokening", "betrothals", "betrothing",
    "betterment", "bewildered", "bewitching", "biannually",
    "bicyclists", "biennially", "bifurcated", "bifurcates",
    "bighearted", "bilberries", "bilinguals", "billboards",
    "billionths", "billowiest", "binoculars", "biochemist",
    "biodegrade", "biographer", "biological", "biologists",
    "biophysics", "biorhythms", "biospheres", "bipartisan",
    "birdbrains", "birdhouses", "birthmarks", "birthplace",
    "birthrates", "birthright", "birthstone", "bisections",
    "bishoprics", "bitchiness", "bitterness", "bituminous",
    "bivouacked", "biweeklies", "blabbering", "blackballs",
    "blackberry", "blackbirds", "blackboard", "blackening",
    "blackguard", "blackheads", "blackjacks", "blacklists",
    "blackmails", "blacksmith", "blackthorn", "blancmange",
    "blanketing", "blarneying", "blasphemed", "blasphemer",
    "blasphemes", "blathering", "blemishing", "blessedest",
    "blethering", "blindfolds", "blindingly", "blindsided",
    "blindsides", "blinkering", "blissfully", "blistering",
    "blitzkrieg", "blockading", "blockheads", "blockhouse",
    "bloodbaths", "bloodhound", "bloodlines", "bloodstain",
    "bloodstock", "blossoming", "blotchiest", "blubbering",
    "bludgeoned", "bluebottle", "bluefishes", "bluejacket",
    "blueprints", "blunderers", "blundering", "blustering",
    "boardrooms", "boardwalks", "boastfully", "boathouses",
    "boatswains", "bobsledded", "bobsleighs", "bodyguards",
    "boisterous", "bollocking", "bolstering", "bombardier",
    "bombarding", "bombshells", "bondholder", "boneshaker",
    "bookbinder", "bookending", "bookkeeper", "bookmakers",
    "bookmaking", "bookmarked", "bookmobile", "bookplates",
    "bookseller", "bookstalls", "bookstores", "boomerangs",
    "boondoggle", "bootblacks", "bootlegged", "bootlegger",
    "bootstraps", "borderland", "borderline", "borrowings",
    "bothersome", "bottleneck", "bottomless", "bouldering",
    "boulevards", "boundaries", "bowstrings", "boycotting",
    "boyfriends", "boyishness", "bracketing", "brainchild",
    "brainpower", "brainstorm", "brainwaves", "brandished",
    "brandishes", "brasseries", "brassieres", "brawniness",
    "brazenness", "breadboard", "breadboxes", "breadcrumb",
    "breadfruit", "breakables", "breakaways", "breakdowns",
    "breakfasts", "breakwater", "breastbone", "breastfeed",
    "breastwork", "breathable", "breathiest", "breathless",
    "breeziness", "breviaries", "bricklayer", "brickyards",
    "bridegroom", "bridesmaid", "bridgehead", "bridgework",
    "bridleways", "briefcases", "brigadiers", "brigandage",
    "brigantine", "brightened", "brightness", "brilliance",
    "brilliancy", "brilliants", "briquettes", "bristliest",
    "broadcasts", "broadcloth", "broadening", "broadsheet",
    "broadsided", "broadsides", "broadsword", "brokerages",
    "bronchitic", "bronchitis", "brontosaur", "broodiness",
    "broomstick", "brothering", "browbeaten", "brownfield",
    "brownstone", "buccaneers", "buckboards", "bucketfuls",
    "budgerigar", "buffaloing", "buffetings", "buffoonery",
    "bulldogged", "bulldozers", "bulldozing", "bulletined",
    "bullfights", "bullheaded", "bumblebees", "bunkhouses",
    "burdensome", "bureaucrat", "burgeoning", "burglaries",
    "burgundies", "burlesqued", "burlesques", "burnishing",
    "bushwhacks", "businesses", "busybodies", "butcheries",
    "butchering", "buttercups", "butteriest", "buttermilk",
    "butternuts", "buttocking", "buttonhole", "buttressed",
    "buttresses", "byproducts", "bystanders", "cabdrivers",
    "cablecasts", "cablegrams", "cadaverous", "cafeterias",
    "cafetieres", "calabashes", "calamining", "calamities",
    "calamitous", "calcifying", "calculable", "calculated",
    "calculates", "calculator", "calendared", "calibrated",
    "calibrates", "calibrator", "caliphates", "callousing",
    "calumniate", "camcorders", "camerawork", "camouflage",
    "campaigned", "campaigner", "campaniles", "campground",
    "candelabra", "candidates", "candidness", "candlewick",
    "candyfloss", "canistered", "cannabises", "cannelloni",
    "cannonaded", "cannonades", "cannonball", "canonicals",
    "canoodling", "cantaloupe", "cantilever", "cantonment",
    "canvasback", "canvassers", "canvassing", "capability",
    "capacities", "capacitors", "caparisons", "capitalism",
    "capitalist", "capitation", "capitulate", "cappuccino",
    "capricious", "captaining", "captioning", "captivated",
    "captivates", "carbonated", "carbonates", "carbuncles",
    "carburetor", "carcinogen", "carcinomas", "cardholder",
    "cardiogram", "cardiology", "cardsharps", "careerists",
    "carefuller", "caregivers", "carelessly", "caretakers",
    "caricature", "carjackers", "carjacking", "carnations",
    "carnelians", "carnivores", "carpenters", "carpetbags",
    "carpooling", "carthorses", "cartilages", "cartooning",
    "cartoonist", "cartridges", "cartwheels", "caseworker",
    "cashiering", "cashpoints", "casseroled", "casseroles",
    "castigated", "castigates", "castigator", "castrating",
    "castration", "casualness", "casualties", "cataclysms",
    "catafalque", "cataleptic", "catamarans", "catapulted",
    "catatonics", "catcalling", "catchments", "catchwords",
    "catechisms", "categories", "caterwauls", "cathartics",
    "cathedrals", "catnapping", "cautionary", "cautioning",
    "cautiously", "cavalcades", "cavalryman", "cavalrymen",
    "caveatting", "ceasefires", "celebrants", "celebrated",
    "celebrates", "cellophane", "cellphones", "cemeteries",
    "censorious", "censorship", "centennial", "centigrade",
    "centipedes", "centralest", "centralism", "centralist",
    "centrality", "centrifuge", "centurions", "cerebellum",
    "ceremonial", "ceremonies", "certainest", "certifying",
    "certitudes", "cessations", "chagrining", "chainsawed",
    "chairlifts", "chairwoman", "chairwomen", "chalkboard",
    "chalkiness", "challenged", "challenger", "challenges",
    "chameleons", "chamomiles", "champagnes", "championed",
    "chancellor", "chanceries", "chandelier", "changeable",
    "changeless", "changeling", "changeover", "chaparrals",
    "chaperoned", "chaplaincy", "charabancs", "characters",
    "charbroils", "chargeable", "charioteer", "charitable",
    "charitably", "charladies", "charlatans", "charminger",
    "charmingly", "chartering", "chartreuse", "chastening",
    "chastising", "chatterbox", "chatterers", "chattering",
    "chattiness", "chauffeurs", "chauvinism", "chauvinist",
    "cheapening", "cheapskate", "checklists", "checkmated",
    "checkmates", "checkpoint", "checkrooms", "cheekbones",
    "cheekiness", "cheerfully", "cheeriness", "cheesecake",
    "chemically", "cherishing", "chessboard", "chickadees",
    "chickening", "chickenpox", "chieftains", "chihuahuas",
    "chilblains", "childbirth", "childhoods", "childishly",
    "childproof", "chilliness", "chillingly", "chimerical",
    "chimpanzee", "chinchilla", "chinstraps", "chintziest",
    "chipolatas", "chirpiness", "chirruping", "chivalrous",
    "chlorinate", "chloroform", "chocoholic", "chocolates",
    "choppering", "choppiness", "chopsticks", "choristers",
    "chowdering", "christened", "chromatics", "chromosome",
    "chronicled", "chronicler", "chronicles", "chronology",
    "chubbiness", "chuckholes", "chumminess", "chundering",
    "chunkiness", "chuntering", "churchgoer", "churchyard",
    "churlishly", "cicatrices", "cigarettes", "cigarillos",
    "circuiting", "circuitous", "circulated", "circulates",
    "circumcise", "circumflex", "circumvent", "citronella",
    "civilities", "clambering", "clamminess", "clampdowns",
    "clanswoman", "clanswomen", "clapboards", "clappering",
    "clarifying", "clarioning", "classicism", "classicist",
    "classified", "classifies", "classiness", "classmates",
    "classrooms", "clattering", "clavichord", "cleanliest",
    "clearances", "clematises", "clementine", "clerestory",
    "cleverness", "clinically", "clinicians", "clipboards",
    "clitorises", "cloakrooms", "clobbering", "clockworks",
    "clodhopper", "cloistered", "clothespin", "cloudburst",
    "cloudiness", "cloverleaf", "clownishly", "clubhouses",
    "clumsiness", "clustering", "cluttering", "coachloads",
    "coagulants", "coagulated", "coagulates", "coalescing",
    "coalfields", "coalitions", "coarseness", "coarsening",
    "coastguard", "coastlines", "coauthored", "cockamamie",
    "cockchafer", "cockfights", "cockscombs", "cocksucker",
    "codswallop", "coexisting", "coffeecake", "coffeepots",
    "cofferdams", "cogitating", "cogitation", "cohabiting",
    "coherently", "cohesively", "coiffuring", "coincident",
    "coinciding", "collapsing", "collarbone", "collarless",
    "collateral", "collations", "colleagued", "colleagues",
    "collecting", "collection", "collective", "collectors",
    "collegians", "collegiate", "collieries", "collisions",
    "collocated", "collocates", "colloquial", "colloquies",
    "colloquium", "colonnaded", "colonnades", "colossally",
    "columbines", "columnists", "combatants", "combustion",
    "comedienne", "comeliness", "comestible", "comforters",
    "comforting", "commandant", "commandeer", "commanders",
    "commanding", "commencing", "commending", "commentary",
    "commentate", "commenting", "commercial", "commercing",
    "commingled", "commingles", "commissars", "commissary",
    "commission", "commitment", "committals", "committees",
    "committing", "commodious", "commodores", "commotions",
    "communally", "communions", "communique", "communists",
    "commutable", "compactest", "compacting", "compaction",
    "compactors", "companions", "comparable", "comparably",
    "comparison", "compassing", "compassion", "compatible",
    "compatibly", "compatriot", "compelling", "compendium",
    "compensate", "competence", "competency", "competitor",
    "complacent", "complained", "complainer", "complaints",
    "complected", "complement", "completely", "completest",
    "completing", "completion", "complexest", "complexion",
    "complexity", "compliance", "complicate", "complicity",
    "compliment", "components", "comporting", "composites",
    "compositor", "composting", "compounded", "comprehend",
    "compressed", "compresses", "compressor", "comprising",
    "compromise", "compulsion", "compulsive", "compulsory",
    "concealing", "conceiving", "concentric", "conception",
    "conceptual", "concerning", "concertina", "concerting",
    "concession", "concierges", "conciliate", "concluding",
    "conclusion", "conclusive", "concocting", "concoction",
    "concordant", "concordats", "concourses", "concretely",
    "concreting", "concubines", "concurrent", "concurring",
    "concussing", "concussion", "condemning", "condensers",
    "condensing", "condescend", "condiments", "conditions",
    "condolence", "conducting", "conduction", "conductive",
    "conductors", "confabbing", "confection", "conference",
    "conferment", "conferring", "confessing", "confession",
    "confessors", "confidante", "confidants", "confidence",
    "configured", "configures", "confirming", "confiscate",
    "conflating", "conflation", "conflicted", "confluence",
    "conforming", "conformist", "conformity", "confounded",
    "confronted", "confusedly", "confusions", "congealing",
    "congenital", "congesting", "congestion", "congestive",
    "congregant", "congregate", "congresses", "congruence",
    "coniferous", "conjecture", "conjoining", "conjugated",
    "conjugates", "connecting", "connection", "connective",
    "connectors", "connexions", "connivance", "conquering",
    "conquerors", "conscience", "conscripts", "consecrate",
    "consensual", "consenting", "consequent", "conserving",
    "considered", "consignees", "consigning", "consistent",
    "consisting", "consonance", "consonants", "consorting",
    "consortium", "conspiracy", "conspiring", "constables",
    "constantly", "constipate", "constitute", "constrains",
    "constraint", "constricts", "constructs", "construing",
    "consulates", "consultant", "consulting", "consumable",
    "consumings", "consummate", "contacting", "contagions",
    "contagious", "containers", "containing", "contenders",
    "contending", "contenting", "contention", "contestant",
    "contesting", "contextual", "contiguity", "contiguous",
    "continence", "continents", "contingent", "continuing",
    "continuity", "continuous", "contorting", "contortion",
    "contouring", "contraband", "contracted", "contractor",
    "contradict", "contraflow", "contraltos", "contraries",
    "contrarily", "contrasted", "contravene", "contribute",
    "contritely", "contrition", "contriving", "controlled",
    "controller", "controvert", "contusions", "conundrums",
    "convalesce", "convection", "convectors", "convenient",
    "conventing", "convention", "convergent", "converging",
    "conversant", "conversely", "conversing", "conversion",
    "converters", "converting", "conveyance", "convicting",
    "conviction", "convincing", "convoluted", "convulsing",
    "convulsion", "convulsive", "cookhouses", "cooperated",
    "cooperates", "coordinate", "copperhead", "copulating",
    "copulation", "copycatted", "copyrights", "copywriter",
    "coquetting", "coquettish", "cordiality", "corkscrews",
    "cormorants", "corncrakes", "cornfields", "cornflakes",
    "cornflower", "cornrowing", "cornstalks", "cornstarch",
    "cornucopia", "coronaries", "coronation", "corpulence",
    "corpuscles", "corralling", "correctest", "correcting",
    "correction", "corrective", "correlated", "correlates",
    "correspond", "corrosives", "corrugated", "corrugates",
    "corruptest", "corrupting", "corruption", "coruscated",
    "coruscates", "cosmically", "cosmonauts", "cosponsors",
    "cossetting", "costarring", "costliness", "costumiers",
    "cotillions", "cottonseed", "cottontail", "cottonwood",
    "cotyledons", "couchettes", "councilman", "councilmen",
    "countdowns", "counteract", "countering", "countesses",
    "countryman", "countrymen", "countywide", "courageous",
    "courgettes", "couriering", "coursebook", "coursework",
    "courtesans", "courtesies", "courthouse", "courtliest",
    "courtrooms", "courtships", "courtyards", "couturiers",
    "covenanted", "covetously", "cowcatcher", "cowpuncher",
    "coxswained", "crabbiness", "crackdowns", "crackliest",
    "cracklings", "craftiness", "crankcases", "crankiness",
    "crankshaft", "cravatting", "crawlspace", "crayfishes",
    "creakiness", "creameries", "creaminess", "creatively",
    "creativity", "credential", "creditable", "creditably",
    "creepiness", "cremations", "crematoria", "creosoting",
    "crescendos", "cricketers", "cricketing", "criminally",
    "crimsoning", "crinkliest", "crinolines", "crispbread",
    "crisscross", "critically", "criticisms", "critiquing",
    "crocheting", "crocodiles", "croissants", "crookedest",
    "croquettes", "crossbeams", "crossbones", "crossbreed",
    "crosscheck", "crossfires", "crossovers", "crosspatch",
    "crosspiece", "crossroads", "crosswalks", "crosswinds",
    "crosswords", "crucifixes", "cruciforms", "crucifying",
    "crumbliest", "crunchiest", "crushingly", "crustacean",
    "cryogenics", "cryptogram", "cubbyholes", "cuckolding",
    "culminated", "culminates", "cultivable", "cultivated",
    "cultivates", "cultivator", "culturally", "cumbersome",
    "cummerbund", "cumulative", "cunningest", "curiousest",
    "curlicuing", "curmudgeon", "currencies", "curricular",
    "curriculum", "currycombs", "curtailing", "curtaining",
    "curvaceous", "curvatures", "cushioning", "cussedness",
    "custodians", "cutthroats", "cuttlefish", "cybernetic",
    "cyberpunks", "cyberspace", "cyclically", "cyclotrons",
    "dachshunds", "daintiness", "dairymaids", "dalliances",
    "dalmatians", "dandelions", "dandifying", "daredevils",
    "dartboards", "dashboards", "databasing", "datelining",
    "dauntingly", "davenports", "daydreamed", "daydreamer",
    "dazzlingly", "deactivate", "deadheaded", "deadliness",
    "deadlining", "deadlocked", "deadpanned", "dealership",
    "deathblows", "deathliest", "deathtraps", "debasement",
    "debauchees", "debauchery", "debauching", "debentures",
    "debilitate", "debilities", "debonairly", "debriefing",
    "decadently", "decapitate", "decathlete", "decathlons",
    "decelerate", "deceptions", "decimating", "decimation",
    "deciphered", "decisively", "deckchairs", "declaiming",
    "declarable", "declassify", "declension", "decolletes",
    "decomposed", "decomposes", "decompress", "decontrols",
    "decorating", "decoration", "decorative", "decorators",
    "decorously", "decoupling", "decreasing", "decrements",
    "dedicating", "dedication", "deductible", "deductions",
    "deescalate", "defacement", "defamation", "defamatory",
    "defaulters", "defaulting", "defeatists", "defecating",
    "defecation", "defections", "defectives", "defendants",
    "defensible", "deferments", "deficiency", "defilement",
    "definitely", "definition", "definitive", "deflecting",
    "deflection", "deflectors", "deflowered", "defoliants",
    "defoliated", "defoliates", "deforested", "defrauding",
    "defrocking", "defrosters", "defrosting", "degeneracy",
    "degenerate", "degradable", "dehumidify", "dehydrated",
    "dehydrates", "dejectedly", "delectable", "delectably",
    "delegating", "delegation", "deliberate", "delicacies",
    "delicately", "delightful", "delighting", "delimiters",
    "delimiting", "delineated", "delineates", "delinquent",
    "deliverers", "deliveries", "delivering", "delphinium",
    "delusively", "demagogues", "demarcated", "demarcates",
    "dementedly", "demeriting", "demitasses", "democratic",
    "demography", "demolished", "demolishes", "demolition",
    "demoniacal", "demonology", "demotivate", "demureness",
    "denaturing", "denigrated", "denigrates", "denominate",
    "denotation", "denouement", "denouncing", "dentifrice",
    "deodorants", "department", "departures", "dependable",
    "dependably", "dependence", "dependency", "depictions",
    "depilatory", "deplorable", "deplorably", "deployment",
    "depopulate", "deportment", "depositing", "deposition",
    "depositors", "depository", "deprecated", "deprecates",
    "depreciate", "depressant", "depressing", "depression",
    "depressive", "deprograms", "deputation", "derailment",
    "deregulate", "derisively", "derivation", "derivative",
    "dermatitis", "derogating", "derogation", "derogatory",
    "derringers", "desalinate", "descanting", "descendant",
    "descending", "describing", "descriptor", "desecrated",
    "desecrates", "deselected", "desertions", "deservedly",
    "deservings", "desiccated", "desiccates", "desiderata",
    "designated", "designates", "deskilling", "desolately",
    "desolating", "desolation", "despairing", "despicable",
    "despicably", "despoiling", "despondent", "destroyers",
    "destroying", "destructed", "detachable", "detachment",
    "detainment", "detectable", "detectives", "detentions",
    "detergents", "determined", "determiner", "determines",
    "deterrence", "deterrents", "detestable", "detestably",
    "dethroning", "detonating", "detonation", "detonators",
    "detoxified", "detoxifies", "detracting", "detraction",
    "detractors", "detriments", "devastated", "devastates",
    "developers", "developing", "deviations", "devilishly",
    "deviltries", "devolution", "devotional", "devoutness",
    "dewberries", "diabolical", "diacritics", "diagnosing",
    "diagnostic", "diagonally", "diagrammed", "dialectics",
    "diaphanous", "diaphragms", "dickybirds", "dictations",
    "dictionary", "didgeridoo", "dietitians", "difference",
    "difficulty", "diffidence", "diffracted", "digestible",
    "digestions", "digestives", "dignifying", "digressing",
    "digression", "digressive", "dilettante", "diligently",
    "dillydally", "dimensions", "diminished", "diminishes",
    "diminuendo", "diminution", "diminutive", "dinnertime",
    "dinnerware", "diphtheria", "diphthongs", "diplomatic",
    "dipsomania", "directions", "directives", "directness",
    "dirigibles", "disability", "disabusing", "disaffects",
    "disallowed", "disappears", "disappoint", "disapprove",
    "disarrange", "disarrayed", "disastrous", "disavowals",
    "disavowing", "disbanding", "disbarment", "disbarring",
    "disbelieve", "disbursing", "discarding", "discerning",
    "discharged", "discharges", "discipline", "disclaimed",
    "disclaimer", "disclosing", "disclosure", "discomfits",
    "discomfort", "discommode", "discompose", "disconcert",
    "disconnect", "discontent", "discordant", "discording",
    "discounted", "discounter", "discourage", "discoursed",
    "discourses", "discovered", "discoverer", "discredits",
    "discreeter", "discreetly", "discretely", "discretion",
    "discursive", "discussant", "discussing", "discussion",
    "disdainful", "disdaining", "disembarks", "disembowel",
    "disenchant", "disengaged", "disengages", "disfigured",
    "disfigures", "disgorging", "disgracing", "disgruntle",
    "disguising", "disgusting", "disharmony", "dishcloths",
    "dishearten", "dishonesty", "dishtowels", "dishwasher",
    "disincline", "disinfects", "disinherit", "disjointed",
    "dislocated", "dislocates", "dislodging", "disloyally",
    "disloyalty", "dismantled", "dismantles", "dismembers",
    "dismissals", "dismissing", "dismissive", "dismounted",
    "disobeying", "disobliged", "disobliges", "disordered",
    "disorderly", "disorients", "disparaged", "disparages",
    "disparates", "dispatched", "dispatcher", "dispatches",
    "dispelling", "dispensary", "dispensers", "dispensing",
    "dispersing", "dispersion", "dispirited", "displacing",
    "displaying", "displeased", "displeases", "disporting",
    "disposable", "dispossess", "disproving", "disputable",
    "disputants", "disqualify", "disquieted", "disregards",
    "disrespect", "disrupting", "disruption", "disruptive",
    "dissatisfy", "dissecting", "dissection", "dissembled",
    "dissembles", "dissension", "dissenters", "dissenting",
    "disservice", "dissidence", "dissidents", "dissimilar",
    "dissipated", "dissipates", "dissociate", "dissolutes",
    "dissolving", "dissonance", "dissuading", "dissuasion",
    "distancing", "distending", "distension", "distention",
    "distillate", "distillers", "distillery", "distilling",
    "distincter", "distinctly", "distorting", "distortion",
    "distracted", "distraught", "distressed", "distresses",
    "distribute", "distrusted", "disturbing", "disuniting",
    "disyllabic", "divergence", "diversions", "divestment",
    "divination", "divinities", "divisional", "divisively",
    "dockworker", "doctorates", "docudramas", "documented",
    "dogcatcher", "doggedness", "dogmatists", "dogsbodies",
    "dogtrotted", "dolefuller", "dollhouses", "domiciling",
    "dominantly", "dominating", "domination", "dominatrix",
    "domineered", "doohickeys", "doomsayers", "doorkeeper",
    "dosshouses", "doubtfully", "doughtiest", "dovetailed",
    "downgraded", "downgrades", "downloaded", "downmarket",
    "downplayed", "downscaled", "downscales", "downshifts",
    "downsizing", "downspouts", "downstairs", "downstream",
    "downswings", "doxologies", "dragooning", "drainboard",
    "drainpipes", "dramatists", "drawbridge", "drawstring",
    "dreadfully", "dreadlocks", "dreamboats", "dreaminess",
    "dreariness", "dressiness", "dressmaker", "drizzliest",
    "drolleries", "drowsiness", "drugstores", "drumsticks",
    "drywalling", "duckboards", "dumbfounds", "dumbstruck",
    "dumbwaiter", "dunderhead", "dungeoning", "duplicated",
    "duplicates", "duplicator", "durability", "dustsheets",
    "dynamiting", "dyspeptics", "earmarking", "earthbound",
    "earthiness", "earthliest", "earthlings", "earthquake",
    "earthwards", "earthworks", "earthworms", "easterlies",
    "easterners", "eavesdrops", "ebullience", "eccentrics",
    "ecological", "ecologists", "economical", "economists",
    "ecosystems", "ecumenical", "editorials", "editorship",
    "educations", "effacement", "effectuate", "effeminacy",
    "effeminate", "effervesce", "efficiency", "efficients",
    "effortless", "effrontery", "effulgence", "effusively",
    "eggbeaters", "eglantines", "egocentric", "egomaniacs",
    "eiderdowns", "eigenvalue", "eighteenth", "eightieths",
    "eisteddfod", "ejaculated", "ejaculates", "elaborated",
    "elaborates", "elasticity", "elderberry", "electorate",
    "electrical", "electrodes", "electronic", "elementary",
    "elevations", "eliminated", "eliminates", "eliminator",
    "elliptical", "elongating", "elongation", "elopements",
    "eloquently", "elucidated", "elucidates", "emaciating",
    "emaciation", "emanations", "emancipate", "emasculate",
    "embankment", "embargoing", "embezzlers", "embezzling",
    "embittered", "emblazoned", "emblematic", "embodiment",
    "emboldened", "embroiders", "embroidery", "embroiling",
    "embryology", "emendation", "emigrating", "emigration",
    "emissaries", "emollients", "emoluments", "empathetic",
    "empiricism", "empiricist", "employable", "employment",
    "empowering", "emulations", "emulsified", "emulsifier",
    "emulsifies", "enactments", "encampment", "enchanters",
    "enchanting", "enchiladas", "encircling", "enclosures",
    "encounters", "encouraged", "encourages", "encroached",
    "encroaches", "encrusting", "encrypting", "encryption",
    "encumbered", "encyclical", "endangered", "endearment",
    "endocrines", "endowments", "energetics", "enervating",
    "enervation", "enfeebling", "engagement", "engagingly",
    "engendered", "engineered", "engravings", "engrossing",
    "enjoyments", "enlightens", "enlistment", "enlivening",
    "enormities", "enormously", "enraptured", "enraptures",
    "enrichment", "ensconcing", "enshrining", "enshrouded",
    "entangling", "enterprise", "entertains", "enthralled",
    "enthroning", "enthusiasm", "enthusiast", "enticement",
    "enticingly", "entombment", "entomology", "entourages",
    "entrancing", "entrapment", "entrapping", "entreaties",
    "entreating", "entrenched", "entrenches", "entrusting",
    "entryphone", "enumerable", "enumerated", "enumerates",
    "enunciated", "enunciates", "enveloping", "envisaging",
    "envisioned", "epicureans", "epiglottis", "epileptics",
    "epiloguing", "episcopacy", "episcopate", "epistolary",
    "equability", "equanimity", "equatorial", "equestrian",
    "equivalent", "equivocate", "eradicated", "eradicates",
    "ergonomics", "erotically", "escalating", "escalation",
    "escalators", "escapology", "escarpment", "escutcheon",
    "espadrille", "especially", "esplanades", "essentials",
    "estimating", "estimation", "estimators", "estranging",
    "eternities", "ethereally", "ethnically", "etiologies",
    "eucalyptus", "eulogistic", "euphemisms", "euphonious",
    "euthanasia", "evacuating", "evacuation", "evaluating",
    "evaluation", "evaluative", "evanescent", "evangelism",
    "evangelist", "evaporated", "evaporates", "evenhanded",
    "eventfully", "eventually", "eventuated", "eventuates",
    "everglades", "evergreens", "everyplace", "everything",
    "everywhere", "evidencing", "eviscerate", "evocations",
    "exacerbate", "exactingly", "exactitude", "exaggerate",
    "exaltation", "exasperate", "excavating", "excavation",
    "excavators", "excellence", "exceptions", "excerpting",
    "exchanging", "exchequers", "excitation", "excitement",
    "excitingly", "exclaiming", "exclusions", "exclusives",
    "excoriated", "excoriates", "excretions", "exculpated",
    "exculpates", "excursions", "execrating", "executable",
    "executions", "executives", "exemptions", "exercising",
    "exfoliated", "exfoliates", "exhalation", "exhausting",
    "exhaustion", "exhaustive", "exhibiting", "exhibition",
    "exhibitors", "exhilarate", "exhumation", "exigencies",
    "existences", "exonerated", "exonerates", "exorbitant",
    "exorcising", "exotically", "expandable", "expansions",
    "expatiated", "expatiates", "expatriate", "expectancy",
    "expedience", "expediency", "expedients", "expediters",
    "expediting", "expedition", "expendable", "experience",
    "experiment", "expertness", "expiration", "explaining",
    "expletives", "explicable", "explicated", "explicates",
    "explicitly", "exploiters", "exploiting", "explosions",
    "explosives", "exportable", "exposition", "expository",
    "expounding", "expressing", "expression", "expressive",
    "expressway", "expulsions", "expurgated", "expurgates",
    "extempores", "extensions", "extenuated", "extenuates",
    "externally", "extincting", "extinction", "extinguish",
    "extirpated", "extirpates", "extracting", "extraction",
    "extractors", "extradited", "extradites", "extramural",
    "extraneous", "extremists", "extricated", "extricates",
    "extroverts", "extrusions", "exuberance", "exultantly",
    "exultation", "eyeballing", "eyeglasses", "eyewitness",
    "fabricated", "fabricates", "fabulously", "facecloths",
    "facilitate", "facilities", "facsimiled", "facsimiles",
    "factitious", "fairground", "fairylands", "faithfully",
    "fallacious", "falsehoods", "falsifying", "falterings",
    "familiarly", "fanaticism", "fancifully", "fantasists",
    "fantasying", "farcically", "farmhouses", "farmsteads",
    "farsighted", "fascinated", "fascinates", "fashioning",
    "fastenings", "fastidious", "fastnesses", "fatalistic",
    "fatalities", "fatherhood", "fatherland", "fatherless",
    "fathomable", "fathomless", "fattenings", "faultiness",
    "fearfuller", "fearlessly", "featherier", "feathering",
    "federalism", "federalist", "federating", "federation",
    "feebleness", "felicities", "felicitous", "fellowship",
    "femaleness", "femininity", "fermenting", "ferryboats",
    "festooning", "fetchingly", "fetishists", "feverishly",
    "fickleness", "fictitious", "fiendishly", "fierceness",
    "fifteenths", "figurative", "figurehead", "filibuster",
    "filmmakers", "filmstrips", "filterable", "filthiness",
    "filtrating", "filtration", "financiers", "fingerings",
    "fingermark", "fingernail", "fingertips", "finickiest",
    "firebombed", "firebrands", "firebreaks", "firebricks",
    "firefights", "fireguards", "firehouses", "fireplaces",
    "fireproofs", "firescreen", "firestorms", "firewalled",
    "firmaments", "firstborns", "fishmonger", "fishtailed",
    "fisticuffs", "flabbiness", "flagellant", "flagellate",
    "flagrantly", "flagstaffs", "flagstones", "flamboyant",
    "flameproof", "flammables", "flashbacks", "flashbulbs",
    "flashcards", "flashiness", "flashlight", "flatfishes",
    "flatfooted", "flattening", "flatterers", "flattering",
    "flatulence", "flawlessly", "fledglings", "fleetingly",
    "fleshliest", "flickering", "flightiest", "flightless",
    "flimsiness", "flintlocks", "flippantly", "flirtation",
    "floatation", "floodgates", "floodlight", "floorboard",
    "flophouses", "floppiness", "flotations", "floundered",
    "flourished", "flourishes", "flowerbeds", "floweriest",
    "flowerings", "flowerpots", "fluctuated", "fluctuates",
    "fluffiness", "flummoxing", "fluoresced", "fluoresces",
    "fluoridate", "flustering", "fluttering", "flycatcher",
    "flyspecked", "flyswatter", "flyweights", "followings",
    "foodstuffs", "foolishest", "footballer", "footbridge",
    "footlights", "footlocker", "footnoting", "footplates",
    "footprints", "footstools", "forbearing", "forbidding",
    "forcefully", "forearming", "foreboding", "forecaster",
    "forecastle", "foreclosed", "forecloses", "forecourts",
    "foredoomed", "forefather", "forefinger", "forefronts",
    "foregoings", "foreground", "foreigners", "foreordain",
    "forerunner", "foreseeing", "foreshadow", "foreshores",
    "forestalls", "foretasted", "foretastes", "forewarned",
    "forfeiting", "forfeiture", "forgathers", "forgetting",
    "forgivable", "forlornest", "formalists", "formations",
    "formatting", "formidable", "formidably", "formlessly",
    "formulated", "formulates", "fornicated", "fornicates",
    "fornicator", "forsythias", "forthright", "fortifying",
    "fortissimo", "fortnights", "fortressed", "fortresses",
    "fortuitous", "forwardest", "forwarding", "foundation",
    "foundering", "foundlings", "fountained", "foursquare",
    "fourteenth", "foxhunting", "foxtrotted", "fractional",
    "fracturing", "fragmented", "fragrances", "fragrantly",
    "frameworks", "franchised", "franchisee", "franchiser",
    "franchises", "fraternity", "fratricide", "fraudsters",
    "fraudulent", "fraughting", "freakishly", "freebasing",
    "freebooter", "freeholder", "freelanced", "freelancer",
    "freelances", "freeloaded", "freeloader", "freestyles",
    "freewheels", "freighters", "freighting", "frenziedly",
    "frequented", "frequenter", "frequently", "freshening",
    "freshwater", "fricasseed", "fricassees", "fricatives",
    "friendless", "friendlier", "friendlies", "friendship",
    "frightened", "fripperies", "friskiness", "frittering",
    "frolicking", "frolicsome", "frontbench", "frostbites",
    "frostiness", "fructified", "fructifies", "fruitcakes",
    "fruiterers", "fruitfully", "frustrated", "frustrates",
    "fulfilling", "fulminated", "fulminates", "fumigating",
    "fumigation", "fumigators", "functional", "functioned",
    "funereally", "fungicidal", "fungicides", "funiculars",
    "furbishing", "furloughed", "furnishing", "furthering",
    "fusillades", "fussbudget", "futuristic", "futurities",
    "gabardines", "gainsaying", "gallerying", "gallivants",
    "gallstones", "galumphing", "gamekeeper", "gangplanks",
    "gangrening", "gangrenous", "gaolbreaks", "garbageman",
    "gargantuan", "garishness", "garlanding", "garlicking",
    "garnisheed", "garnishees", "garnishing", "garrisoned",
    "gasholders", "gasometers", "gastronome", "gastronomy",
    "gatehouses", "gatekeeper", "gatherings", "gaucheness",
    "gazetteers", "gazillions", "gearshifts", "gearwheels",
    "gelatinous", "generalist", "generality", "generating",
    "generation", "generative", "generators", "generosity",
    "generously", "geneticist", "genteelest", "gentlefolk",
    "gentleness", "gentrified", "gentrifies", "genuflects",
    "geocentric", "geographer", "geographic", "geological",
    "geologists", "geometries", "geophysics", "geothermal",
    "geriatrics", "germicidal", "germicides", "germinated",
    "germinates", "gesundheit", "ghastliest", "ghostliest",
    "ghostwrite", "ghostwrote", "giantesses", "gingersnap",
    "gingivitis", "girlfriend", "glaciation", "gladdening",
    "gladiators", "glasshouse", "glimmering", "glistening",
    "glitterati", "glittering", "gloatingly", "gloominess",
    "glorifying", "gloriously", "glossaries", "glossiness",
    "gluttonous", "goalkeeper", "goalmouths", "goalscorer",
    "goaltender", "gobsmacked", "gobstopper", "godfathers",
    "godmothers", "godparents", "goldbricks", "goldfields",
    "goldfishes", "goldsmiths", "gondoliers", "gooseberry",
    "goosesteps", "gorgeously", "governable", "governance",
    "government", "gracefully", "graciously", "gradations",
    "graduating", "graduation", "grammarian", "gramophone",
    "grandchild", "granddaddy", "grandstand", "granulated",
    "granulates", "grapefruit", "grapevines", "graphology",
    "grasslands", "grassroots", "gratefully", "gratifying",
    "gratuities", "gratuitous", "gravesides", "gravestone",
    "graveyards", "gravitated", "gravitates", "graybeards",
    "greasiness", "greatcoats", "greediness", "greenbacks",
    "greenfield", "greenflies", "greengages", "greenhorns",
    "greenhouse", "greensward", "gregarious", "grenadiers",
    "greyhounds", "gridlocked", "grievances", "grievously",
    "grindstone", "gristliest", "grizzliest", "grogginess",
    "grotesques", "grouchiest", "groundhogs", "groundings",
    "groundless", "groundnuts", "groundsman", "groundsmen",
    "groundwork", "grubbiness", "grudgingly", "gruesomely",
    "gruesomest", "grumblings", "grumpiness", "guaranteed",
    "guarantees", "guarantied", "guaranties", "guarantors",
    "guardhouse", "guardrails", "guardrooms", "guerrillas",
    "guesthouse", "guestrooms", "guidebooks", "guidelines",
    "guildhalls", "guillemots", "guillotine", "guiltiness",
    "guitarists", "gunfighter", "gunnysacks", "gunrunners",
    "gunrunning", "gunslinger", "gymnasiums", "gymnastics",
    "gymnosperm", "gyroscopes", "gyroscopic", "habitation",
    "habitually", "habituated", "habituates", "hackneying",
    "hacksawing", "hailstones", "hailstorms", "hairdryers",
    "hairpieces", "hairsprays", "hairspring", "hairstyles",
    "hallelujah", "hallmarked", "halterneck", "hamburgers",
    "hammerhead", "hammerings", "hamstrings", "handbagged",
    "handbrakes", "handcrafts", "handcuffed", "handedness",
    "handicraft", "handlebars", "handmaiden", "handpicked",
    "handshakes", "handsomely", "handsomest", "handspring",
    "handstands", "hankerings", "happenings", "haranguing",
    "harassment", "harbingers", "hardcovers", "hardheaded",
    "hardliners", "harlequins", "harmlessly", "harmonicas",
    "harmonious", "harnessing", "harpooning", "harrumphed",
    "harvesters", "harvesting", "hatchbacks", "hatcheries",
    "haughtiest", "hauntingly", "haversacks", "headbanger",
    "headboards", "headbutted", "headcheese", "headcounts",
    "headhunted", "headhunter", "headlights", "headliners",
    "headlining", "headmaster", "headphones", "headstones",
    "headstrong", "headwaiter", "headwaters", "healthiest",
    "hearkening", "heartaches", "heartbeats", "heartbreak",
    "heartbroke", "heartening", "hearthrugs", "heartiness",
    "heartlands", "heartthrob", "heathenish", "heatstroke",
    "heavenlier", "heavenward", "hectically", "hedonistic",
    "heedlessly", "heightened", "helicopter", "heliotrope",
    "helplessly", "hemisphere", "hemophilia", "hemorrhage",
    "hemorrhoid", "henceforth", "henpecking", "heptagonal",
    "heptathlon", "herbaceous", "herbalists", "herbicides",
    "herbivores", "hereabouts", "hereafters", "hereditary",
    "heretofore", "hermitages", "heroically", "hesitantly",
    "hesitating", "hesitation", "heterodoxy", "heuristics",
    "hexameters", "hibernated", "hibernates", "hibiscuses",
    "hieroglyph", "highchairs", "highlander", "highlights",
    "hightailed", "highwayman", "highwaymen", "hijackings",
    "hindrances", "hinterland", "hiphuggers", "histamines",
    "histograms", "historians", "historical", "histrionic",
    "hitchhiked", "hitchhiker", "hitchhikes", "hoarseness",
    "hobbyhorse", "hobgoblins", "hobnailing", "hobnobbing",
    "hodgepodge", "holidaying", "hollowness", "hollyhocks",
    "holocausts", "holographs", "holography", "holstering",
    "homebodies", "homecoming", "homeliness", "homemakers",
    "homeowners", "homesteads", "homeworker", "homoerotic",
    "homographs", "homophobia", "homophobic", "homophones",
    "homosexual", "honeycombs", "honeymoons", "honoraries",
    "honorarium", "honorifics", "hoodwinked", "hopelessly",
    "horizontal", "horoscopes", "horrendous", "horrifying",
    "horseboxes", "horseflies", "horsepower", "horseshoed",
    "horseshoes", "horsetails", "horsewhips", "horsewoman",
    "horsewomen", "hospitable", "hospitably", "hostelries",
    "hostessing", "hotchpotch", "hotfooting", "hothousing",
    "houseboats", "housebound", "housebreak", "housebroke",
    "houseclean", "housecoats", "houseflies", "households",
    "housemaids", "housemates", "houseplant", "houseproud",
    "housewares", "housewives", "hovercraft", "huckstered",
    "hullabaloo", "humaneness", "humanistic", "humanities",
    "humbleness", "humbugging", "humdingers", "humidified",
    "humidifier", "humidifies", "humiliated", "humiliates",
    "hummocking", "humorously", "humpbacked", "hunchbacks",
    "hundredths", "huntresses", "hurricanes", "husbanding",
    "hydrangeas", "hydraulics", "hydrofoils", "hydrolysis",
    "hydrometer", "hydroplane", "hydroponic", "hygienists",
    "hygrometer", "hyperbolas", "hyperbolic", "hyperlinks",
    "hyperspace", "hyphenated", "hyphenates", "hypnotists",
    "hypocrites", "hypodermic", "hypotenuse", "hypotheses",
    "hypothesis", "hysteresis", "hysterical", "icebreaker",
    "iconoclasm", "iconoclast", "idealistic", "identified",
    "identifier", "identifies", "identikits", "identities",
    "ideographs", "ideologies", "ideologist", "ideologues",
    "idolatrous", "ignominies", "ignorantly", "illegality",
    "illiteracy", "illiterate", "illuminate", "illumining",
    "illustrate", "imaginable", "imaginably", "imaginings",
    "imbalanced", "imbalances", "imbecility", "imbroglios",
    "imitations", "immaculate", "immaterial", "immaturely",
    "immaturity", "immemorial", "immersions", "immigrants",
    "immigrated", "immigrates", "imminently", "immobility",
    "immoderate", "immodestly", "immolating", "immolation",
    "immorality", "immortally", "immunology", "impairment",
    "impalement", "impalpable", "impassable", "impatience",
    "impeaching", "impeccable", "impeccably", "impediment",
    "impenitent", "imperative", "imperfects", "imperially",
    "impersonal", "impervious", "impishness", "implacable",
    "implacably", "implanting", "implements", "implicated",
    "implicates", "implicitly", "implosions", "impolitely",
    "importance", "importuned", "importunes", "imposingly",
    "imposition", "impossible", "impossibly", "impostures",
    "impotently", "impounding", "impoverish", "impregnate",
    "impresario", "impressing", "impression", "impressive",
    "imprimatur", "imprinting", "imprisoned", "improbable",
    "improbably", "impromptus", "improperly", "improvable",
    "improvised", "improvises", "imprudence", "impudently",
    "impurities", "imputation", "inaccuracy", "inaccurate",
    "inactivity", "inadequacy", "inadequate", "inamoratas",
    "inaugurals", "inaugurate", "inbounding", "inbreeding",
    "incapacity", "incarnated", "incarnates", "incautious",
    "incendiary", "incentives", "inceptions", "incestuous",
    "inchoating", "incidences", "incidental", "incinerate",
    "incisively", "incitement", "incivility", "inclemency",
    "inclusions", "incognitos", "incoherent", "incomplete",
    "inconstant", "increasing", "incredible", "incredibly",
    "increments", "incubating", "incubation", "incubators",
    "inculcated", "inculcates", "inculpated", "inculpates",
    "incumbency", "incumbents", "incurables", "incursions",
    "indecenter", "indecently", "indecision", "indecisive",
    "indecorous", "indefinite", "indelicacy", "indelicate",
    "indentured", "indentures", "indexation", "indicating",
    "indication", "indicative", "indicators", "indictable",
    "indictment", "indigenous", "indirectly", "indiscreet",
    "indisposed", "indistinct", "individual", "indolently",
    "inducement", "inductance", "inductions", "indulgence",
    "industrial", "industries", "inebriated", "inebriates",
    "ineducable", "inelegance", "ineligible", "ineptitude",
    "inequality", "inequities", "inevitable", "inevitably",
    "inexorable", "inexorably", "inexpertly", "infallible",
    "infallibly", "infamously", "infantries", "infarction",
    "infatuated", "infatuates", "infections", "infectious",
    "infelicity", "inferences", "infidelity", "infielders",
    "infighting", "infiltrate", "infinitely", "infinities",
    "infinitive", "infinitude", "inflatable", "inflecting",
    "inflection", "inflexible", "inflexibly", "inflexions",
    "inflicting", "infliction", "influenced", "influences",
    "informally", "informants", "infraction", "infrequent",
    "infringing", "infuriated", "infuriates", "inglenooks",
    "inglorious", "ingraining", "ingratiate", "ingredient",
    "inhabitant", "inhabiting", "inhalation", "inhalators",
    "inherently", "inheriting", "inheritors", "inhibiting",
    "inhibition", "inhumanely", "inhumanity", "inimically",
    "inimitable", "inimitably", "iniquities", "iniquitous",
    "initiating", "initiation", "initiative", "initiators",
    "injections", "injunction", "injustices", "innkeepers",
    "innocenter", "innocently", "innovating", "innovation",
    "innovative", "innovators", "innovatory", "innuendoed",
    "innumeracy", "innumerate", "inoculated", "inoculates",
    "inoperable", "inordinate", "inpatients", "inquietude",
    "inquisitor", "insanitary", "insatiable", "insatiably",
    "inscribing", "insecurely", "insecurity", "inseminate",
    "insensible", "insensibly", "insentient", "insertions",
    "insightful", "insinuated", "insinuates", "insipidity",
    "insistence", "insolently", "insolubles", "insolvable",
    "insolvency", "insolvents", "insomniacs", "insouciant",
    "inspecting", "inspection", "inspectors", "installing",
    "instancing", "instigated", "instigates", "instigator",
    "instilling", "instituted", "institutes", "instructed",
    "instructor", "instrument", "insularity", "insulating",
    "insulation", "insulators", "insurances", "insurgence",
    "insurgency", "insurgents", "intangible", "intangibly",
    "integrally", "integrated", "integrates", "integrator",
    "integument", "intellects", "intensives", "intentions",
    "intentness", "interacted", "interbreed", "interceded",
    "intercedes", "intercepts", "interdicts", "interested",
    "interfaced", "interfaces", "interfaith", "interfered",
    "interferes", "interferon", "interjects", "interlaced",
    "interlaces", "interlards", "interleave", "interlinks",
    "interlocks", "interloper", "interluded", "interludes",
    "intermarry", "interments", "intermezzi", "intermezzo",
    "internally", "internists", "internment", "internship",
    "interposed", "interposes", "interprets", "interrupts",
    "intersects", "interstate", "interstice", "intertwine",
    "interurban", "intervened", "intervenes", "interviews",
    "interweave", "interwoven", "intestinal", "intestines",
    "intimacies", "intimately", "intimating", "intimation",
    "intimidate", "intolerant", "intonation", "intoxicant",
    "intoxicate", "intramural", "intrepidly", "intriguing",
    "introduced", "introduces", "introverts", "intrusions",
    "intrusives", "intuitions", "inundating", "inundation",
    "invalidate", "invaliding", "invalidity", "invaluable",
    "invariable", "invariably", "inveighing", "inveigling",
    "inventions", "inversions", "investment", "inveterate",
    "invigilate", "invigorate", "invincible", "invincibly",
    "inviolable", "invitation", "invitingly", "invocation",
    "ionosphere", "iridescent", "ironically", "ironmonger",
    "irradiated", "irradiates", "irrational", "irregulars",
    "irrelevant", "irresolute", "irreverent", "irrigating",
    "irrigation", "irritating", "irritation", "irruptions",
    "isometrics", "isomorphic", "iterations", "itinerants",
    "jackbooted", "jackhammer", "jackknifed", "jackknifes",
    "jackknives", "jackrabbit", "jaggedness", "jailbreaks",
    "jailhouses", "janitorial", "jaundicing", "jauntiness",
    "jawbreaker", "jaywalkers", "jaywalking", "jealousies",
    "jellybeans", "jettisoned", "jingoistic", "jinrikisha",
    "jitterbugs", "jitteriest", "jobsworths", "jockstraps",
    "jocularity", "journalese", "journalism", "journalist",
    "journeying", "journeyman", "journeymen", "joyfullest",
    "joyfulness", "joyousness", "jubilantly", "jubilation",
    "judicature", "judicially", "juggernaut", "julienning",
    "justifying", "juxtaposed", "juxtaposes", "kangarooed",
    "keelhauled", "kerchiefed", "kerfuffles", "kettledrum",
    "keyboarded", "keyboarder", "keypunched", "keypunches",
    "keystroked", "keystrokes", "kickboxing", "kickstands",
    "kidnappers", "kidnapping", "kilocycles", "kindliness",
    "kindnesses", "kinematics", "kingfisher", "kingmakers",
    "kissograms", "kitchening", "knackering", "knackwurst",
    "kneecapped", "knickknack", "knighthood", "knockabout",
    "knowingest", "kohlrabies", "kookaburra", "laboratory",
    "labyrinths", "lacerating", "laceration", "lachrymose",
    "lacquering", "ladyfinger", "lagniappes", "lamaseries",
    "lambasting", "lamebrains", "lamentable", "lamentably",
    "laminating", "lamination", "lampooning", "lampshades",
    "landholder", "landladies", "landlocked", "landlubber",
    "landmasses", "landowners", "landowning", "landscaped",
    "landscaper", "landscapes", "landslides", "languished",
    "languishes", "languorous", "lapidaries", "laryngitis",
    "lascivious", "latecomers", "lateraling", "laughingly",
    "launderers", "laundering", "laundrette", "laundromat",
    "laundryman", "laundrymen", "laureating", "lavatorial",
    "lavatories", "lavendered", "lavishness", "lawbreaker",
    "lawfulness", "lawnmowers", "lawrencium", "laypersons",
    "leadership", "leafleting", "leasebacks", "leaseholds",
    "legalistic", "legalities", "legibility", "legislated",
    "legislates", "legislator", "legitimacy", "legitimate",
    "leguminous", "legwarmers", "leitmotifs", "leitmotivs",
    "lemongrass", "lengthened", "lengthiest", "lengthwise",
    "leprechaun", "lesbianism", "letterhead", "leukocytes",
    "leveraging", "leviathans", "levitating", "levitation",
    "liberalism", "liberality", "liberating", "liberation",
    "liberators", "libertines", "libidinous", "librarians",
    "librettist", "licentiate", "licentious", "lieutenant",
    "lifeguards", "lifesavers", "lifesaving", "lifestyles",
    "ligaturing", "lightening", "lighthouse", "lightnings",
    "lightships", "likelihood", "likenesses", "limelights",
    "limitation", "limousines", "lineaments", "linebacker",
    "lingerings", "linguistic", "lipreading", "lipsticked",
    "liquefying", "liqueuring", "liquidated", "liquidates",
    "liquidator", "liquorices", "listenable", "listlessly",
    "literature", "lithograph", "litigating", "litigation",
    "litigators", "litterbugs", "littleness", "liturgical",
    "livability", "livelihood", "liveliness", "liverwurst",
    "lobotomies", "lobstering", "localities", "locksmiths",
    "locomotion", "locomotive", "lodestones", "loganberry",
    "logarithms", "loggerhead", "logistical", "logrolling",
    "loincloths", "loneliness", "longhouses", "longitudes",
    "lookalikes", "lopsidedly", "loquacious", "lorgnettes",
    "loudhailer", "loudmouths", "loveliness", "lovemaking",
    "lowlanders", "lubricants", "lubricated", "lubricates",
    "lubricator", "lubricious", "lugubrious", "lumberjack",
    "lumberyard", "luminaries", "luminosity", "luminously",
    "lumpectomy", "lunchboxes", "luncheoned", "lunchrooms",
    "lunchtimes", "lusciously", "luxuriance", "luxuriated",
    "luxuriates", "lymphatics", "macadamias", "macerating",
    "maceration", "machinists", "mackintosh", "macrocosms",
    "maelstroms", "magistracy", "magistrate", "magnifiers",
    "magnifying", "magnitudes", "maharajahs", "maharishis",
    "mahoganies", "maidenhair", "maidenhead", "maidenhood",
    "mainframes", "mainlining", "mainspring", "mainstream",
    "maintained", "maintainer", "maisonette", "majordomos",
    "majorettes", "majorities", "makeshifts", "makeweight",
    "malcontent", "malefactor", "malevolent", "malignancy",
    "malignants", "malingered", "malingerer", "malodorous",
    "maltreated", "mammalians", "mammograms", "manageable",
    "management", "manageress", "managerial", "mangetouts",
    "manhandled", "manhandles", "maniacally", "manicuring",
    "manicurist", "manifested", "manifestly", "manifestos",
    "manifolded", "manipulate", "mannequins", "mannerisms",
    "manservant", "manumitted", "manuscript", "maraschino",
    "marathoner", "margaritas", "marginalia", "marginally",
    "marinading", "marinating", "marionette", "marketable",
    "marketeers", "marquesses", "marshaling", "marshlands",
    "marsupials", "mascaraing", "masculines", "masochists",
    "masquerade", "massacring", "mastectomy", "mastermind",
    "masterwork", "masticated", "masticates", "masturbate",
    "matchbooks", "matchboxes", "matchmaker", "matchstick",
    "materially", "maternally", "matriarchs", "matriarchy",
    "matricides", "mattresses", "maturation", "maturities",
    "maundering", "mausoleums", "mavericked", "mayflowers",
    "mayonnaise", "mayoresses", "meadowlark", "meagerness",
    "meandering", "meaningful", "measurable", "measurably",
    "meatloaves", "mechanical", "mechanisms", "medallions",
    "meddlesome", "medicating", "medication", "medicinals",
    "mediocrity", "meditating", "meditation", "meditative",
    "megacycles", "megalithic", "megaphoned", "megaphones",
    "melancholy", "mellowness", "melodramas", "membership",
    "membranous", "memorandum", "menacingly", "menageries",
    "mendacious", "mendicants", "meningitis", "menopausal",
    "menstruate", "mentioning", "mercantile", "merchanted",
    "mercifully", "mergansers", "merrymaker", "messengers",
    "metabolism", "metacarpal", "metacarpus", "metallurgy",
    "metastases", "metastasis", "metatarsal", "meteorites",
    "meteoroids", "methodical", "meticulous", "metrically",
    "metronomes", "metropolis", "mettlesome", "mezzanines",
    "microchips", "microcosms", "microfiche", "microfilms",
    "microlight", "microphone", "microscope", "microscopy",
    "microwaved", "microwaves", "middlebrow", "midfielder",
    "midsection", "midshipman", "midshipmen", "mightiness",
    "migrations", "mileometer", "milestones", "militantly",
    "militarily", "militarism", "militarist", "militating",
    "militiaman", "militiamen", "milkshakes", "millennial",
    "millennium", "millionths", "millipedes", "millstones",
    "milometers", "mimeograph", "mindedness", "mindlessly",
    "minefields", "mineralogy", "minestrone", "miniatured",
    "miniatures", "minimalism", "minimalist", "miniseries",
    "miniskirts", "ministered", "ministrant", "ministries",
    "minorities", "minuscules", "minuteness", "miraculous",
    "mirthfully", "misapplied", "misapplies", "misbehaved",
    "misbehaves", "miscalling", "miscarried", "miscarries",
    "miscasting", "miscellany", "mischanced", "mischances",
    "mischiefed", "misconduct", "miscounted", "miscreants",
    "misdealing", "misdirects", "miserables", "misfitting",
    "misfortune", "misgivings", "misgoverns", "misguiding",
    "mishandled", "mishandles", "mishapping", "mishearing",
    "mishitting", "mishmashes", "misinforms", "misjudging",
    "misleading", "mismanaged", "mismanages", "mismatched",
    "mismatches", "misnomered", "misogynist", "misplacing",
    "misplaying", "misprinted", "misquoting", "misreading",
    "misreports", "missionary", "missioning", "misspelled",
    "misstating", "misstepped", "mistakenly", "mistreated",
    "mistresses", "mistrusted", "mitigating", "mitigation",
    "mizzenmast", "moderately", "moderating", "moderation",
    "moderators", "modernists", "modifiable", "modulating",
    "modulation", "modulators", "moistening", "mollifying",
    "molybdenum", "monarchies", "monarchism", "monarchist",
    "monetarily", "monetarism", "monetarist", "moneyboxes",
    "moneymaker", "monitoring", "monochrome", "monogamous",
    "monographs", "monolithic", "monologued", "monologues",
    "monomaniac", "monophonic", "monoplanes", "monopolies",
    "monopolist", "monotheism", "monotheist", "monotoning",
    "monotonous", "monsignors", "monstrance", "monumental",
    "moonlights", "moonscapes", "moonshines", "moonstones",
    "moonstruck", "moralistic", "moralities", "moratorium",
    "moroseness", "morpheming", "morphology", "mortgagees",
    "mortgaging", "mortgagors", "morticians", "mortifying",
    "mortuaries", "mosquitoes", "mothballed", "motherhood",
    "motherland", "motherless", "motionless", "motivating",
    "motivation", "motivators", "motiveless", "motorbiked",
    "motorbikes", "motorboats", "motorcades", "motorcycle",
    "motormouth", "mouldering", "mountebank", "mournfully",
    "mousetraps", "mouthpiece", "moviegoers", "mozzarella",
    "muckrakers", "muckraking", "mudslinger", "mujaheddin",
    "mulberries", "mulishness", "multimedia", "multiparty",
    "multiplied", "multiplier", "multiplies", "multitudes",
    "mummifying", "municipals", "munificent", "murmurings",
    "mushroomed", "musicality", "musicology", "musketeers",
    "muskmelons", "mutability", "mutilating", "mutilation",
    "mutineered", "mutinously", "mutterings", "myopically",
    "mysterious", "mysterying", "mystically", "mystifying",
    "nameplates", "nanosecond", "narcissism", "narcissist",
    "narcolepsy", "narrations", "narratives", "narrowness",
    "nasturtium", "nationally", "nationhood", "nationwide",
    "nativities", "naturalism", "naturalist", "naughtiest",
    "nauseating", "nauseously", "nautically", "nautiluses",
    "navigating", "navigation", "navigators", "necklacing",
    "necromancy", "necropolis", "nectarines", "needlessly",
    "needlework", "negatively", "negativing", "negativity",
    "neglectful", "neglecting", "negligence", "negligible",
    "negligibly", "negotiable", "negotiated", "negotiates",
    "negotiator", "neoclassic", "neologisms", "nepotistic",
    "nethermost", "nettlesome", "networking", "neutralist",
    "neutrality", "newfangled", "newsagents", "newscaster",
    "newsgroups", "newshounds", "newsletter", "newspapers",
    "newsreader", "newsstands", "newsworthy", "nicknaming",
    "niggarding", "nightclubs", "nightdress", "nightgowns",
    "nighthawks", "nightlight", "nightmares", "nightshade",
    "nightshirt", "nightspots", "nightstand", "nightstick",
    "nihilistic", "nimbleness", "nincompoop", "nineteenth",
    "ninetieths", "nitpickers", "nitpicking", "noblewoman",
    "noblewomen", "noisemaker", "nominating", "nomination",
    "nominative", "nonaligned", "nonchalant", "nondrinker",
    "nonesuches", "nonfiction", "nonmembers", "nonpareils",
    "nonpayment", "nonplussed", "nonprofits", "nonsmokers",
    "nonsmoking", "nonstarter", "nonsupport", "nontaxable",
    "nontrivial", "nonviolent", "northbound", "northerner",
    "northwards", "nosebleeds", "nosediving", "nostalgics",
    "noteworthy", "noticeable", "noticeably", "notifiable",
    "notionally", "nourishing", "novelettes", "novitiates",
    "nullifying", "numberless", "numerating", "numeration",
    "numerators", "numerology", "numismatic", "nursemaids",
    "nurseryman", "nurserymen", "nutcracker", "nuthatches",
    "nutmegging", "nutriments", "nutritious", "oafishness",
    "obdurately", "obdurating", "obediently", "obeisances",
    "obfuscated", "obfuscates", "obituaries", "objections",
    "objectives", "obligating", "obligation", "obligatory",
    "obligingly", "obliterate", "obsequious", "observable",
    "observably", "observance", "obsessions", "obsessives",
    "obsoleting", "obstetrics", "obstructed", "obtainable",
    "obtuseness", "occasional", "occasioned", "occidental",
    "occlusions", "occultists", "occupation", "occurrence",
    "oceanfront", "oceangoing", "offensives", "officially",
    "officiated", "officiates", "offloading", "offsetting",
    "oftentimes", "oleaginous", "oligarchic", "omnipotent",
    "omniscient", "omnivorous", "oncologist", "onslaughts",
    "opalescent", "opaqueness", "openhanded", "operations",
    "operatives", "ophthalmic", "opposition", "oppressing",
    "oppression", "oppressive", "oppressors", "opprobrium",
    "optimistic", "optionally", "orangeades", "orangeness",
    "orangeries", "orangutans", "oratorical", "orchestral",
    "orchestras", "ordinances", "ordinarier", "ordinaries",
    "ordinarily", "ordination", "organelles", "orientated",
    "orientates", "originally", "originated", "originates",
    "originator", "ornamental", "ornamented", "ornateness",
    "orphanages", "orthodoxes", "orthogonal", "oscillated",
    "oscillates", "oscillator", "ostensible", "ostensibly",
    "osteopaths", "osteopathy", "outbalance", "outbidding",
    "outcasting", "outclassed", "outclasses", "outcropped",
    "outfielder", "outfitters", "outfitting", "outflanked",
    "outgrowing", "outgrowths", "outguessed", "outguesses",
    "outgunning", "outlandish", "outlasting", "outlooking",
    "outnumbers", "outpatient", "outperform", "outplaying",
    "outpointed", "outpouring", "outputting", "outrageous",
    "outranking", "outreached", "outreaches", "outriggers",
    "outrunning", "outselling", "outsetting", "outshining",
    "outsmarted", "outsourced", "outsources", "outspreads",
    "outstation", "outstaying", "outstretch", "outwearing",
    "outweighed", "outwitting", "outworkers", "overacting",
    "overactive", "overbooked", "overburden", "overcharge",
    "overcoming", "overcooked", "overcrowds", "overdosing",
    "overdrafts", "overdrives", "overeating", "overexcite",
    "overexpose", "overextend", "overflight", "overflowed",
    "overflying", "overground", "overgrowth", "overhauled",
    "overheated", "overjoying", "overkilled", "overlapped",
    "overlaying", "overloaded", "overlooked", "overmanned",
    "overmuches", "overnights", "overpasses", "overpaying",
    "overplayed", "overpowers", "overpriced", "overprices",
    "overprints", "overrating", "overreacts", "overridden",
    "overriding", "overruling", "overseeing", "overshadow",
    "overshoots", "oversights", "oversizing", "oversleeps",
    "overspends", "overspread", "overstated", "overstates",
    "overstayed", "overstocks", "oversupply", "overtaking",
    "overtaxing", "overthrown", "overthrows", "overtiring",
    "overturned", "overvalued", "overvalues", "overweight",
    "overwhelms", "overwinter", "overworked", "overwrites",
    "oxygenated", "oxygenates", "pacemakers", "pacesetter",
    "pachyderms", "paddocking", "padlocking", "paederasts",
    "paginating", "pagination", "painfuller", "painkiller",
    "painlessly", "paintboxes", "paintbrush", "palavering",
    "palimpsest", "palindrome", "pallbearer", "palliating",
    "palliation", "palliative", "palpitated", "palpitates",
    "paltriness", "panatellas", "pancreases", "pancreatic",
    "panegyrics", "panellists", "panhandled", "panhandler",
    "panhandles", "panickiest", "pantaloons", "pantheists",
    "pantomimed", "pantomimes", "paperbacks", "paperbarks",
    "paperclips", "papergirls", "parachuted", "parachutes",
    "paragraphs", "paralegals", "parallaxes", "paralytics",
    "paramecium", "paramedics", "parameters", "paranoiacs",
    "paranormal", "paraphrase", "paraplegia", "paraplegic",
    "paratroops", "parboiling", "parchments", "pardonable",
    "pardonably", "parenthood", "parliament", "parqueting",
    "parricides", "parsonages", "partiality", "participle",
    "particular", "partitions", "partitives", "partnering",
    "partridges", "passageway", "passengers", "passionate",
    "passioning", "passivised", "passivises", "passivized",
    "passivizes", "pasteboard", "pastorates", "patchiness",
    "patchworks", "paternally", "pathfinder", "pathogenic",
    "patientest", "patisserie", "patriarchs", "patriarchy",
    "patricians", "patricides", "patriotism", "patrolling",
    "patronages", "patronymic", "patterning", "paunchiest",
    "pavemented", "pawnbroker", "paymasters", "peacefully",
    "peacemaker", "peashooter", "peccadillo", "peculiarly",
    "pedagogics", "pedagogued", "pedagogues", "pedestrian",
    "pediatrics", "pedicuring", "pedometers", "pejorative",
    "pekingeses", "penetrable", "penetrated", "penetrates",
    "penfriends", "penicillin", "peninsular", "peninsulas",
    "penitently", "penmanship", "pennyworth", "penologist",
    "pensioners", "pensioning", "pentagonal", "pentameter",
    "pentathlon", "penthoused", "penthouses", "peppercorn",
    "peppermint", "pepperonis", "perceiving", "percentage",
    "percentile", "perception", "perceptive", "perceptual",
    "percipient", "percolated", "percolates", "percolator",
    "percussion", "percussive", "peregrines", "peremptory",
    "perennials", "perfectest", "perfecting", "perfection",
    "perfidious", "perforated", "perforates", "performers",
    "performing", "pericardia", "perihelion", "perilously",
    "perimeters", "periodical", "peripheral", "periscoped",
    "periscopes", "perishable", "peritoneum", "periwigged",
    "periwinkle", "permafrost", "permanence", "permanency",
    "permanents", "permeating", "permeation", "permission",
    "permissive", "permitting", "pernicious", "peroration",
    "peroxiding", "perpetrate", "perpetuals", "perpetuate",
    "perpetuity", "perplexing", "perplexity", "perquisite",
    "persecuted", "persecutes", "persecutor", "persevered",
    "perseveres", "persiflage", "persimmons", "persistent",
    "persisting", "personable", "personages", "personally",
    "perspiring", "persuading", "persuasion", "persuasive",
    "pertaining", "pertinence", "pertinents", "perturbing",
    "perversely", "perversion", "perversity", "perverting",
    "pessimists", "pesticides", "pestilence", "petitioned",
    "petitioner", "petrifying", "petrolatum", "petticoats",
    "petulantly", "phagocytes", "pharmacies", "pharmacist",
    "pharyngeal", "phenomenal", "phenomenas", "phenomenon",
    "pheromones", "philanders", "philatelic", "philippics",
    "philistine", "philosophy", "phlegmatic", "phonecards",
    "phonically", "phonograph", "phosphates", "phosphoric",
    "phosphorus", "photocells", "photogenic", "photograph",
    "photostats", "phrasebook", "phrenology", "physically",
    "physicians", "physicists", "physicking", "physiology",
    "pianissimo", "pianoforte", "picaresque", "piccalilli",
    "pickpocket", "picnickers", "picnicking", "pictograph",
    "pictorials", "piercingly", "pigeonhole", "piggybacks",
    "pilgrimage", "pillioning", "pillorying", "pillowcase",
    "pillowslip", "pilothouse", "pimpernels", "pincushion",
    "pineapples", "pinfeather", "pinpointed", "pinpricked",
    "pinstriped", "pinstripes", "pinwheeled", "pioneering",
    "pipsqueaks", "pirouetted", "pirouettes", "pistachios",
    "pistillate", "pitchforks", "pitifuller", "pitilessly",
    "placarding", "placements", "placentals", "plagiarism",
    "plagiarist", "plainchant", "plaintiffs", "planeloads",
    "plantation", "plasterers", "plastering", "plasticity",
    "plateauing", "platformed", "platitudes", "platooning",
    "platypuses", "playacting", "playground", "playgroups",
    "playhouses", "playschool", "playthings", "playwright",
    "pleadingly", "pleasanter", "pleasantly", "pleasantry",
    "pleasingly", "pleasuring", "plebiscite", "plenitudes",
    "pliability", "plottering", "pluckiness", "plummeting",
    "plunderers", "plundering", "pluperfect", "pluralists",
    "plutocracy", "plutocrats", "pocketbook", "pocketfuls",
    "pockmarked", "podiatrist", "poetically", "poignantly",
    "poinsettia", "poisonings", "polarities", "polemicist",
    "politburos", "politeness", "politician", "politicked",
    "pollinated", "pollinates", "pollutants", "polonaises",
    "polyesters", "polygamist", "polygamous", "polygraphs",
    "polyhedron", "polynomial", "polyphonic", "polysemous",
    "polytheism", "polytheist", "pompadours", "pontifical",
    "pontooning", "poorhouses", "popularity", "populating",
    "population", "porcelains", "porcupines", "porpoising",
    "porringers", "portcullis", "portending", "portentous",
    "portfolios", "portioning", "portliness", "portrayals",
    "portraying", "positional", "positioned", "positively",
    "positivest", "positivism", "positivist", "possessing",
    "possession", "possessive", "possessors", "possiblest",
    "postdating", "posteriors", "posthumous", "postmarked",
    "postmaster", "postmodern", "postmortem", "postpartum",
    "postponing", "postscript", "postseason", "postulated",
    "postulates", "potbellied", "potbellies", "potboilers",
    "potentates", "potentials", "potholders", "potpourris",
    "poulticing", "powerboats", "powerfully", "powerhouse",
    "practicals", "pragmatics", "pragmatism", "pragmatist",
    "pranksters", "preachiest", "preambling", "prearrange",
    "precarious", "precaution", "precedence", "precedents",
    "preceptors", "preciosity", "preciously", "precipices",
    "precluding", "preclusion", "precocious", "precooking",
    "precursors", "predecease", "predefined", "predestine",
    "predicated", "predicates", "predicting", "prediction",
    "predictive", "predictors", "predigests", "predispose",
    "preeminent", "preempting", "preemption", "preemptive",
    "preexisted", "prefabbing", "prefecture", "preferable",
    "preferably", "preference", "preferment", "preferring",
    "prefigured", "prefigures", "preheating", "prehensile",
    "prehistory", "prejudging", "prejudiced", "prejudices",
    "premarital", "premiering", "preordains", "prepackage",
    "prepayment", "prepossess", "prerecords", "presbytery",
    "preschools", "prescience", "prescribed", "prescribes",
    "presenters", "presenting", "preservers", "preserving",
    "presetting", "preshrinks", "presidency", "presidents",
    "pressuring", "presumable", "presumably", "presuppose",
    "pretenders", "pretending", "pretexting", "prettified",
    "prettifies", "prettiness", "prevailing", "prevalence",
    "prevalents", "preventing", "prevention", "preventive",
    "previewers", "previewing", "previously", "prickliest",
    "priesthood", "priestlier", "primitives", "primordial",
    "primrosing", "princelier", "princesses", "principals",
    "principled", "principles", "prioresses", "priorities",
    "prissiness", "privateers", "privations", "privileged",
    "privileges", "prizefight", "procedural", "procedures",
    "proceeding", "processing", "procession", "processors",
    "proclaimed", "proclivity", "procreated", "procreates",
    "proctoring", "procurator", "prodigally", "prodigious",
    "production", "productive", "professing", "profession",
    "professors", "proffering", "proficient", "profitable",
    "profitably", "profiteers", "profligacy", "profligate",
    "profounder", "profoundly", "profundity", "profusions",
    "progenitor", "prognostic", "programmer", "progressed",
    "progresses", "prohibited", "projectile", "projecting",
    "projection", "projectors", "prolapsing", "prolonging",
    "promenaded", "promenades", "prominence", "promissory",
    "promontory", "promotions", "promptings", "promptness",
    "promulgate", "pronghorns", "pronominal", "pronounced",
    "pronounces", "proofreads", "propaganda", "propagated",
    "propagates", "propagator", "propellant", "propellers",
    "propelling", "propensity", "propertied", "properties",
    "prophecies", "prophesied", "prophesies", "prophetess",
    "propitiate", "propitious", "proponents", "proportion",
    "propounded", "proprietor", "propulsion", "propulsive",
    "proscenium", "prosciutto", "proscribed", "proscribes",
    "prosecuted", "prosecutes", "prosecutor", "proselyted",
    "proselytes", "prospected", "prospector", "prospectus",
    "prospering", "prosperity", "prosperous", "prostheses",
    "prosthesis", "prosthetic", "prostitute", "prostrated",
    "prostrates", "protecting", "protection", "protective",
    "protectors", "protestant", "protesters", "protesting",
    "protoplasm", "prototypes", "protozoans", "protracted",
    "protractor", "protruding", "protrusion", "provenance",
    "provenders", "proverbial", "providence", "provincial",
    "provisions", "prudential", "pruriently", "psephology",
    "pseudonyms", "psychiatry", "psychology", "psychopath",
    "psychotics", "ptarmigans", "pubescence", "publicists",
    "publishers", "publishing", "pugilistic", "pugnacious",
    "pulsations", "punchlines", "punctually", "punctuated",
    "punctuates", "puncturing", "punishable", "punishment",
    "punitively", "puppeteers", "purchasers", "purchasing",
    "purgatives", "puritanism", "purloining", "purporting",
    "purposeful", "pushchairs", "pussyfoots", "putrefying",
    "putrescent", "puzzlement", "pyramiding", "pyromaniac",
    "quadrangle", "quadrature", "quadriceps", "quadrilled",
    "quadrilles", "quadrupeds", "quadrupled", "quadruples",
    "quadruplet", "quagmiring", "quaintness", "qualifiers",
    "qualifying", "quandaries", "quantified", "quantifier",
    "quantifies", "quantities", "quarantine", "quartering",
    "queasiness", "queenliest", "questioned", "questioner",
    "quickening", "quicksands", "quicksteps", "quiescence",
    "quietening", "quintupled", "quintuples", "quintuplet",
    "quotations", "rabbinical", "racecourse", "racehorses",
    "racetracks", "racialists", "racketeers", "raconteurs",
    "radiations", "radicalism", "radiograms", "ragamuffin",
    "raggediest", "raggedness", "railleries", "railroaded",
    "railwayman", "railwaymen", "rainmakers", "rainstorms",
    "rakishness", "ramrodding", "ramshackle", "randomness",
    "ransacking", "rappelling", "rapporteur", "ratcheting",
    "ratepayers", "rationales", "rationally", "rattletrap",
    "raunchiest", "ravenously", "ravishment", "razzmatazz",
    "reactivate", "readership", "readjusted", "readmitted",
    "reaffirmed", "realigning", "reallocate", "reanimated",
    "reanimates", "reappeared", "reapplying", "reappoints",
    "reappraise", "rearmament", "rearranged", "rearranges",
    "reasonable", "reasonably", "reassemble", "reasserted",
    "reassessed", "reassesses", "reassigned", "reassuring",
    "reawakened", "rebellions", "rebellious", "rebounding",
    "rebuilding", "recaptured", "recaptures", "receipting",
    "receivable", "receptacle", "receptions", "recessions",
    "recessives", "recharging", "rechecking", "recidivism",
    "recidivist", "recipients", "reciprocal", "recitation",
    "recitative", "recklessly", "reckonings", "reclaiming",
    "reclassify", "recollects", "recombined", "recombines",
    "recommence", "recommends", "recompense", "recompiled",
    "reconciled", "reconciles", "reconnects", "reconquers",
    "reconsider", "reconvened", "reconvenes", "recordings",
    "recounting", "recoveries", "recovering", "recreating",
    "recreation", "recruiters", "recruiting", "rectangles",
    "rectifiers", "rectifying", "recuperate", "recurrence",
    "recyclable", "redbreasts", "redcurrant", "redecorate",
    "rededicate", "redeemable", "redefining", "redemption",
    "redemptive", "redeployed", "redesigned", "redevelops",
    "redirected", "rediscover", "redistrict", "redoubling",
    "redoubting", "redounding", "redrafting", "redressing",
    "reductions", "redundancy", "reeducated", "reeducates",
    "reelecting", "reelection", "reemerging", "reenacting",
    "reenlisted", "reentering", "reevaluate", "reexamined",
    "reexamines", "refashions", "refereeing", "referenced",
    "references", "referendum", "refillable", "refinanced",
    "refinances", "refinement", "refineries", "refinished",
    "refinishes", "reflations", "reflecting", "reflection",
    "reflective", "reflectors", "reflexives", "refocusing",
    "reforested", "reformists", "refracting", "refraction",
    "refractory", "refraining", "refreshers", "refreshing",
    "refulgence", "refundable", "refutation", "regardless",
    "regenerate", "regimental", "regimented", "regionally",
    "registered", "registrant", "registrars", "registries",
    "regressing", "regression", "regressive", "regretting",
    "regrouping", "regularity", "regulating", "regulation",
    "regulators", "regulatory", "rehearsals", "rehearsing",
    "reimbursed", "reimburses", "reimposing", "reinforced",
    "reinforces", "reinserted", "reinstated", "reinstates",
    "reinvented", "reinvested", "reiterated", "reiterates",
    "rejections", "rejiggered", "rejoicings", "rejoinders",
    "rejuvenate", "rekindling", "relational", "relatively",
    "relativism", "relativist", "relativity", "relaunched",
    "relaunches", "relaxation", "relearning", "releasable",
    "relegating", "relegation", "relentless", "relevantly",
    "relinquish", "relocating", "relocation", "reluctance",
    "remainders", "remarkable", "remarkably", "remarriage",
    "remarrying", "remastered", "remediable", "remembered",
    "reminisced", "reminisces", "remissions", "remissness",
    "remittance", "remorseful", "remortgage", "remoteness",
    "remoulding", "remounting", "removables", "remunerate",
    "renascence", "renderings", "rendezvous", "renditions",
    "renegading", "renouncing", "renovating", "renovation",
    "renovators", "renumbered", "reoccupied", "reoccupies",
    "reoccurred", "reordering", "repackaged", "repackages",
    "repainting", "repairable", "reparation", "repatriate",
    "repayments", "repeatable", "repeatably", "repeatedly",
    "repellents", "repentance", "repentants", "repertoire",
    "repetition", "repetitive", "rephrasing", "replicated",
    "replicates", "reportedly", "repository", "reprehends",
    "represents", "repressing", "repression", "repressive",
    "reprieving", "reprimands", "reprinting", "reproached",
    "reproaches", "reprobates", "reproduced", "reproduces",
    "reproofing", "reptilians", "republican", "repudiated",
    "repudiates", "repugnance", "reputation", "requesting",
    "requisites", "reschedule", "rescinding", "rescission",
    "researched", "researcher", "researches", "resembling",
    "resentment", "reservedly", "reservists", "reservoirs",
    "resettling", "reshuffled", "reshuffles", "residences",
    "resignedly", "resilience", "resiliency", "resistance",
    "resolutely", "resolutest", "resolution", "resonances",
    "resonantly", "resonating", "resonators", "resounding",
    "resourcing", "respecters", "respectful", "respecting",
    "respective", "respelling", "respirator", "respondent",
    "responding", "responsive", "restarting", "restaurant",
    "restfuller", "restlessly", "restocking", "restrained",
    "restraints", "restricted", "restudying", "resultants",
    "resumption", "resupplied", "resupplies", "resurfaced",
    "resurfaces", "resurgence", "resurrects", "retaliated",
    "retaliates", "retardants", "rethinking", "reticently",
    "retirement", "retouching", "retracting", "retraction",
    "retraining", "retreading", "retreating", "retrenched",
    "retrenches", "retrievals", "retrievers", "retrieving",
    "retrograde", "retrogress", "retrospect", "returnable",
    "reunifying", "revealings", "revelation", "revengeful",
    "reverenced", "reverences", "reverently", "reversible",
    "reversions", "revilement", "revisiting", "revivalism",
    "revivalist", "revivified", "revivifies", "revocation",
    "revolution", "rewindable", "reworkings", "rhapsodies",
    "rhetorical", "rheumatics", "rheumatism", "rhinestone",
    "rhinoceros", "rhythmical", "riboflavin", "ricketiest",
    "ricocheted", "ridgepoles", "ridiculing", "ridiculous",
    "rightfully", "rightwards", "rigmaroles", "rigorously",
    "ringleader", "ringmaster", "riverfront", "riversides",
    "roadblocks", "roadhouses", "roadrunner", "roadworthy",
    "robustness", "rockabilly", "roisterers", "roistering",
    "rollicking", "rosebushes", "rotational", "rotisserie",
    "rottenness", "rottweiler", "rotundness", "roughening",
    "roughhouse", "roughnecks", "roundabout", "roundelays",
    "roundhouse", "roundworms", "roustabout", "rubberiest",
    "rubberneck", "rubbishing", "rudderless", "ruffianing",
    "ruggedness", "ruminating", "rumination", "ruminative",
    "runarounds", "russetting", "rustically", "rustproofs",
    "ruthlessly", "sabbatical", "sabotaging", "saccharine",
    "sacerdotal", "sacraments", "sacredness", "sacrificed",
    "sacrifices", "sacrileges", "sacristans", "sacristies",
    "sacrosanct", "saddlebags", "safeguards", "safflowers",
    "sailboards", "sailfishes", "saintliest", "salamander",
    "salesclerk", "salesgirls", "salesrooms", "saleswoman",
    "saleswomen", "salivating", "salivation", "sallowness",
    "salmonella", "saltcellar", "saltshaker", "salubrious",
    "salutation", "sanatorium", "sanctified", "sanctifies",
    "sanctioned", "sandalwood", "sandbagged", "sandblasts",
    "sandcastle", "sandpapers", "sandpipers", "sandstorms",
    "sandwiched", "sandwiches", "sanguinary", "sanguining",
    "sanitaries", "sanitarium", "sanitation", "saprophyte",
    "sapsuckers", "sarcophagi", "satellited", "satellites",
    "satinwoods", "satisfying", "saturating", "saturation",
    "sauerkraut", "sauntering", "savageness", "savageries",
    "sawdusting", "saxophones", "scalloping", "scallywags",
    "scampering", "scandalous", "scantiness", "scapegoats",
    "scarceness", "scarcities", "scarecrows", "scarifying",
    "scarlatina", "scarleting", "scarpering", "scathingly",
    "scattering", "scavengers", "scavenging", "scenically",
    "schedulers", "scheduling", "schematics", "schismatic",
    "schlemiels", "schlepping", "schlockier", "schmoozers",
    "schmoozing", "schnauzers", "schnitzels", "scholastic",
    "schoolbags", "schoolbook", "schoolboys", "schooldays",
    "schoolgirl", "schoolkids", "schoolmarm", "schoolmate",
    "schoolroom", "schoolwork", "schoolyard", "scientific",
    "scientists", "scintillas", "sclerotics", "scoreboard",
    "scorecards", "scorelines", "scornfully", "scoundrels",
    "scrabbling", "scraggiest", "scragglier", "scramblers",
    "scrambling", "scrapbooks", "scrapheaps", "scrappiest",
    "scrapyards", "scratchier", "scratching", "scratchpad",
    "scrawniest", "screechier", "screeching", "screenings",
    "screenplay", "screwballs", "scribblers", "scribbling",
    "scrimmaged", "scrimmages", "scrimshaws", "scriptural",
    "scriptures", "scroungers", "scrounging", "scrubbiest",
    "scruffiest", "scrummages", "scrunchies", "scrunching",
    "scrupulous", "scrutineer", "sculleries", "sculptural",
    "sculptured", "sculptures", "scuppering", "scurrilous",
    "seamanship", "seamlessly", "seamstress", "seasonable",
    "seasonally", "seasonings", "secondhand", "secondment",
    "secretions", "sectarians", "sectionals", "sectioning",
    "secularism", "secularist", "securities", "seductions",
    "seductress", "seemliness", "seersucker", "segmenting",
    "segregated", "segregates", "seismology", "selections",
    "selflessly", "sellotaped", "sellotapes", "semaphored",
    "semaphores", "semblances", "semiannual", "semibreves",
    "semicircle", "semicolons", "semifinals", "seminarian",
    "seminaries", "semiquaver", "semivowels", "semiweekly",
    "senatorial", "senescence", "sensations", "sensiblest",
    "sensitives", "sensuality", "sensuously", "sentencing",
    "sentiments", "separately", "separating", "separation",
    "separatism", "separatist", "separators", "sepulchral",
    "sequencers", "sequencing", "sequential", "sequesters",
    "serenading", "sereneness", "serpentine", "serpenting",
    "servanting", "serviceman", "servicemen", "serviettes",
    "setsquares", "settlement", "seventeens", "seventieth",
    "severances", "sexologist", "sextuplets", "shabbiness",
    "shadowiest", "shagginess", "shakedowns", "shallowest",
    "shamefaced", "shamefully", "shampooing", "shanghaied",
    "shantytown", "shapeliest", "sharpeners", "sharpening",
    "shattering", "sheathings", "sheepfolds", "sheepishly",
    "sheepskins", "shellacked", "sheltering", "shenanigan",
    "shepherded", "shibboleth", "shiftiness", "shillelagh",
    "shimmering", "shipboards", "shipowners", "shipwrecks",
    "shipwright", "shirttails", "shirtwaist", "shockingly",
    "shockproof", "shoddiness", "shoehorned", "shoemakers",
    "shoeshines", "shoestring", "shopaholic", "shopfitter",
    "shopfronts", "shopkeeper", "shoplifted", "shoplifter",
    "shorelines", "shortbread", "shortcakes", "shortcrust",
    "shortening", "shortfalls", "shorthorns", "shortlists",
    "shortstops", "shortwaves", "shotgunned", "shouldered",
    "shovelfuls", "showboated", "showcasing", "showeriest",
    "showground", "showpieces", "showplaces", "shrewdness",
    "shrillness", "shrinkable", "shrubbiest", "shuddering",
    "shutterbug", "shuttering", "sickenings", "sicknesses",
    "sideboards", "sidelights", "sidelining", "sidesaddle",
    "sidestroke", "sideswiped", "sideswipes", "sidetracks",
    "sightseers", "signatures", "signboards", "signifying",
    "signposted", "silhouette", "silverfish", "silveriest",
    "silverware", "similarity", "simpleness", "simpletons",
    "simplicity", "simplified", "simplifies", "simplistic",
    "simulacrum", "simulating", "simulation", "simulators",
    "simulcasts", "sinfulness", "singalongs", "singleness",
    "singletons", "singsonged", "singularly", "sinusoidal",
    "sisterhood", "situations", "sixteenths", "skateboard",
    "skedaddled", "skedaddles", "sketchbook", "sketchiest",
    "sketchpads", "skillfully", "skimpiness", "skinflints",
    "skinniness", "skippering", "skirmished", "skirmisher",
    "skirmishes", "skittering", "skittishly", "skyjackers",
    "skyjacking", "skylarking", "skyrockets", "skyscraper",
    "skywriters", "skywriting", "slackening", "slanderers",
    "slandering", "slanderous", "slapdashes", "slathering",
    "slatternly", "slaughters", "sleazebags", "sleazeball",
    "sleaziness", "sleepiness", "sleepovers", "sleepwalks",
    "sleepyhead", "sleeveless", "slenderest", "slightness",
    "slingbacks", "slingshots", "slipcovers", "slipperier",
    "slipstream", "slithering", "slobbering", "sloppiness",
    "slouchiest", "slovenlier", "sluggishly", "slumbering",
    "slumberous", "smartening", "smattering", "smokehouse",
    "smokestack", "smoothness", "smothering", "smuttiness",
    "snakebites", "snapdragon", "snappiness", "snappishly",
    "sneeringly", "snickering", "sniftering", "snobbishly",
    "snookering", "snootiness", "snorkelers", "snorkeling",
    "snowballed", "snowboards", "snowdrifts", "snowfields",
    "snowflakes", "snowmobile", "snowplough", "snowplowed",
    "snowstorms", "snuffboxes", "soapboxing", "sobriquets",
    "socialists", "socialites", "sociopaths", "sojourning",
    "soldiering", "solemnness", "soliciting", "solicitors",
    "solicitous", "solicitude", "solidarity", "solidified",
    "solidifies", "solitaires", "solitaries", "solubility",
    "somebodies", "somersault", "somethings", "somewheres",
    "somnolence", "songstress", "songwriter", "sonorously",
    "soothingly", "soothsayer", "sophomores", "sophomoric",
    "soporifics", "sordidness", "sororities", "soullessly",
    "soundbites", "soundproof", "soundtrack", "sourdoughs",
    "sourpusses", "sousaphone", "southbound", "southerner",
    "southwards", "sovereigns", "spacecraft", "spaceships",
    "spacesuits", "spacewalks", "spacewoman", "spacewomen",
    "spaciously", "spanielled", "sparseness", "spattering",
    "spearheads", "specialism", "specialist", "specifiers",
    "specifying", "speciously", "spectacles", "spectating",
    "spectators", "speculated", "speculates", "speculator",
    "speechless", "speedboats", "speediness", "speedsters",
    "speleology", "spellbinds", "spellbound", "spelunkers",
    "spelunking", "spermicide", "spheroidal", "sphincters",
    "spideriest", "spiderwebs", "spillovers", "spindliest",
    "spinnakers", "spiritedly", "spiritless", "spirituals",
    "spirituous", "spitefully", "splashdown", "splashiest",
    "splattered", "splendider", "splendidly", "splintered",
    "splittings", "splotchier", "splotching", "spluttered",
    "spoilsport", "spoliation", "sponginess", "sponsoring",
    "spoonbills", "spoonerism", "sportingly", "sportscast",
    "sportswear", "spotlessly", "spotlights", "spottiness",
    "springboks", "springiest", "springtime", "sprinklers",
    "sprinkling", "spuriously", "sputtering", "spyglasses",
    "spymasters", "squabbling", "squalidest", "squandered",
    "squareness", "squashiest", "squattered", "squeakiest",
    "squeezebox", "squelching", "squigglier", "squiggling",
    "squirmiest", "squishiest", "stablemate", "stagecoach",
    "stagecraft", "stagehands", "staggering", "stagnating",
    "stagnation", "staircases", "stairwells", "stalactite",
    "stalagmite", "stalemated", "stalemates", "stalwartly",
    "stammerers", "stammering", "stampeding", "stanchions",
    "standpipes", "standpoint", "standstill", "starchiest",
    "starfishes", "stargazers", "stargazing", "starstruck",
    "starvation", "statehouse", "stateliest", "statements",
    "staterooms", "statically", "stationary", "stationers",
    "stationery", "stationing", "statistics", "statuesque",
    "statuettes", "staunchest", "staunching", "steadiness",
    "steakhouse", "stealthier", "stealthily", "steamboats",
    "steamrolls", "steamships", "steelmaker", "steelworks",
    "steepening", "stentorian", "stepfather", "stepladder",
    "stepmother", "stepparent", "stepsister", "stereotype",
    "stevedores", "stewardess", "stewarding", "stickiness",
    "stiffeners", "stiffening", "stiflingly", "stillbirth",
    "stillborns", "stimulants", "stimulated", "stimulates",
    "stinginess", "stipulated", "stipulates", "stirringly",
    "stochastic", "stockading", "stockiness", "stockpiled",
    "stockpiles", "stockrooms", "stockyards", "stodginess",
    "stomaching", "stonemason", "stonewalls", "stoplights",
    "stoppering", "storefront", "storehouse", "storerooms",
    "storminess", "storyboard", "storybooks", "stovepipes",
    "straddling", "stragglers", "stragglier", "straggling",
    "straighted", "straighten", "straighter", "straitened",
    "strangered", "stranglers", "strangling", "stratagems",
    "strategics", "strategies", "strategist", "stratified",
    "stratifies", "strawberry", "streakiest", "streamline",
    "streetcars", "streetlamp", "streetwise", "strengthen",
    "stretchers", "stretchier", "stretching", "striations",
    "strictness", "strictures", "stridently", "strikeouts",
    "strikingly", "stringency", "stringiest", "striplings",
    "striptease", "stronghold", "strongroom", "stroppiest",
    "structural", "structured", "structures", "struggling",
    "strumpeted", "strychnine", "stubbliest", "stubborned",
    "stubborner", "stubbornly", "studiously", "stuffiness",
    "stultified", "stultifies", "stunningly", "stupefying",
    "stupendous", "sturdiness", "stutterers", "stuttering",
    "stylistics", "subalterns", "subatomics", "subcompact",
    "subculture", "subdivided", "subdivides", "subeditors",
    "subheading", "subjecting", "subjection", "subjective",
    "subjoining", "subjugated", "subjugates", "subleasing",
    "subletting", "sublimated", "sublimates", "subliminal",
    "submariner", "submarines", "submerging", "submersing",
    "submersion", "submission", "submissive", "submitting",
    "suborbital", "subpoenaed", "subprogram", "subroutine",
    "subscribed", "subscriber", "subscribes", "subscripts",
    "subsection", "subsequent", "subsidence", "subsidiary",
    "subsisting", "subsoiling", "subspecies", "substances",
    "substation", "substitute", "substratum", "subsystems",
    "subtenants", "subtending", "subterfuge", "subtitling",
    "subtleties", "subtracted", "subtrahend", "subvention",
    "subversion", "subversive", "subverting", "succeeding",
    "successful", "succession", "successive", "successors",
    "succincter", "succinctly", "succulence", "succulents",
    "succumbing", "suctioning", "suddenness", "sufferance",
    "sufferings", "sufficient", "suffocated", "suffocates",
    "suffragans", "suffragist", "sugarcoats", "suggesting",
    "suggestion", "suggestive", "sullenness", "sultanates",
    "sultriness", "summations", "summeriest", "summertime",
    "summonsing", "sunbathers", "sunbathing", "sunbonnets",
    "sunburning", "sundresses", "sunflowers", "sunglasses",
    "sunscreens", "sunsetting", "suntanning", "supergrass",
    "superhuman", "supermodel", "supernovae", "supernovas",
    "superpower", "superseded", "supersedes", "supersonic",
    "superstars", "superstate", "superstore", "supervened",
    "supervenes", "supervised", "supervises", "supervisor",
    "superwoman", "superwomen", "suppertime", "supplanted",
    "supplement", "suppleness", "suppliants", "supplicant",
    "supplicate", "supporters", "supporting", "supportive",
    "supposedly", "supposings", "suppressed", "suppresses",
    "suppressor", "suppurated", "suppurates", "surceasing",
    "surcharged", "surcharges", "surefooted", "surfboards",
    "surfeiting", "surgically", "surmounted", "surpassing",
    "surplussed", "surprising", "surrealism", "surrealist",
    "surrenders", "surrogates", "surrounded", "survivable",
    "suspecting", "suspenders", "suspending", "suspension",
    "suspicions", "suspicious", "sustaining", "sustenance",
    "suzerainty", "swaggering", "swallowing", "swarthiest",
    "swattering", "swaybacked", "swearwords", "sweatbands",
    "sweatpants", "sweatshirt", "sweatshops", "sweatsuits",
    "sweetbread", "sweetbrier", "sweeteners", "sweetening",
    "sweetheart", "sweetmeats", "swellheads", "sweltering",
    "swimmingly", "switchable", "switchback", "sycophancy",
    "sycophants", "syllabuses", "syllogisms", "symbolical",
    "symmetries", "sympathies", "symphonies", "symposiums",
    "synagogues", "syncopated", "syncopates", "syndicated",
    "syndicates", "synonymous", "syntactics", "synthetics",
    "syphilises", "syphilitic", "systematic", "tabernacle",
    "tablecloth", "tablelands", "tablespoon", "tabulating",
    "tabulation", "tabulators", "tachograph", "tachometer",
    "tactically", "tacticians", "tactlessly", "tailboards",
    "tailgating", "taillights", "tailpieces", "tallyhoing",
    "tambourine", "tangential", "tangerines", "tantamount",
    "tapestries", "tarantulas", "tarmacadam", "tarmacking",
    "tarnishing", "tarpaulins", "taskmaster", "tastefully",
    "tattletale", "tattooists", "tawdriness", "taxonomies",
    "teakettles", "teargassed", "tearjerker", "technicals",
    "technician", "techniques", "technocrat", "technology",
    "telecaster", "telegraphs", "telegraphy", "telemeters",
    "telepathic", "telephoned", "telephones", "telephonic",
    "telephotos", "telescoped", "telescopes", "telescopic",
    "televising", "television", "teleworker", "temperance",
    "temperated", "temperates", "temporally", "temptation",
    "temptingly", "tenability", "tendencies", "tenderfoot",
    "tenderloin", "tenderness", "tendinitis", "tentatives",
    "termagants", "terminable", "terminally", "terminated",
    "terminates", "terminator", "terracotta", "terrariums",
    "terrifying", "terrorists", "tessellate", "testaments",
    "testicular", "testifying", "tetchiness", "thankfully",
    "theatrical", "themselves", "theocratic", "theodolite",
    "theologian", "theologies", "therapists", "thereabout",
    "thereafter", "thermionic", "thermostat", "thickeners",
    "thickening", "thighbones", "thimbleful", "thirstiest",
    "thirteenth", "thirtieths", "thorougher", "thoroughly",
    "thoughtful", "thousandth", "thrashings", "threadbare",
    "threatened", "threepence", "threescore", "threesomes",
    "threnodies", "thresholds", "thriftiest", "throatiest",
    "thromboses", "thrombosis", "throttling", "throughout",
    "throughput", "throwaways", "throwbacks", "thumbnails",
    "thumbprint", "thumbscrew", "thumbtacks", "thundering",
    "thunderous", "tiddlywink", "tidewaters", "tiebreaker",
    "tightening", "tightropes", "timberland", "timberline",
    "timekeeper", "timelessly", "timeliness", "timepieces",
    "timescales", "timeserver", "timeshares", "timetabled",
    "timetables", "timorously", "timpanists", "tincturing",
    "tirelessly", "tiresomely", "titillated", "titillates",
    "titivating", "toadstools", "tobogganed", "toiletries",
    "tolerances", "tolerantly", "tolerating", "toleration",
    "tollbooths", "tomahawked", "tombstones", "tomfoolery",
    "tonalities", "tonelessly", "toothaches", "toothbrush",
    "toothpaste", "toothpicks", "topicality", "topography",
    "torchlight", "tormenting", "tormentors", "torpedoing",
    "torrential", "tortuously", "totalities", "touchdowns",
    "touchiness", "touchingly", "touchlines", "touchpaper",
    "touchstone", "toughening", "tourmaline", "tournament",
    "tourniquet", "towelettes", "townhouses", "toxicities",
    "toxicology", "trackballs", "tracksuits", "trademarks",
    "traditions", "trafficked", "trafficker", "tragedians",
    "tragically", "tragicomic", "trailering", "traitorous",
    "trajectory", "trampoline", "tranquiler", "tranquilly",
    "transacted", "transcends", "transcribe", "transcript",
    "transducer", "transferal", "transfixed", "transfixes",
    "transforms", "transfused", "transfuses", "transgenic",
    "transgress", "transience", "transiency", "transients",
    "transistor", "transiting", "transition", "transitive",
    "transitory", "translated", "translates", "translator",
    "transmuted", "transmutes", "transpired", "transpires",
    "transplant", "transports", "transposed", "transposes",
    "transships", "transverse", "trapeziums", "trapezoids",
    "travailing", "travelogue", "traversing", "travestied",
    "travesties", "treadmills", "treasonous", "treasurers",
    "treasuries", "treasuring", "treatments", "trellising",
    "tremendous", "trenchancy", "trendiness", "trespassed",
    "trespasser", "trespasses", "triangular", "triathlete",
    "triathlons", "trickiness", "tricksters", "tricycling",
    "triennials", "triggering", "trilateral", "trillionth",
    "trimesters", "tripartite", "triplicate", "trisecting",
    "triumphant", "triumphing", "triviality", "troglodyte",
    "trolleybus", "trolloping", "trombonist", "troopships",
    "troubadour", "trousseaux", "truckloads", "truculence",
    "trumpeters", "trumpeting", "truncating", "truncation",
    "truncheons", "trustfully", "truthfully", "tubercular",
    "tumbledown", "tumbleweed", "tumescence", "tumultuous",
    "tunelessly", "turboprops", "turbulence", "turmoiling",
    "turnabouts", "turnaround", "turnrounds", "turnstiles",
    "turntables", "turpentine", "turquoises", "turtledove",
    "turtleneck", "twentieths", "twitchiest", "twittering",
    "typescript", "typesetter", "typewriter", "typewrites",
    "typography", "typologies", "tyrannical", "ubiquitous",
    "ulcerating", "ulceration", "ultimately", "ultimating",
    "ultimatums", "ultrasonic", "ultrasound", "ululations",
    "umbrellaed", "unabridged", "unaccented", "unaccepted",
    "unaffected", "unanswered", "unarguable", "unarguably",
    "unassigned", "unassisted", "unassuming", "unattached",
    "unattended", "unavailing", "unbalanced", "unbalances",
    "unbearable", "unbearably", "unbeatable", "unbecoming",
    "unbeliever", "unbleached", "unblinking", "unblocking",
    "unblushing", "unbosoming", "unbuckling", "unburdened",
    "unbuttoned", "uncanniest", "uncensored", "unchanging",
    "unclasping", "uncleanest", "unclearest", "unclothing",
    "uncommoner", "uncommonly", "unconcerns", "uncoupling",
    "uncovering", "uncritical", "unctuously", "uncultured",
    "undeceived", "undeceives", "undecideds", "undeclared",
    "undefeated", "undefended", "undeniable", "undeniably",
    "underacted", "underarmed", "underbelly", "underbrush",
    "underclass", "undercoats", "undercover", "underfeeds",
    "underfloor", "undergoing", "undergrads", "underlains",
    "underlined", "underlines", "underlings", "underlying",
    "undermined", "undermines", "underneath", "underpants",
    "underplays", "underrated", "underrates", "underscore",
    "undersells", "undershirt", "undershoot", "undersides",
    "undersigns", "undersized", "underskirt", "understand",
    "understate", "understood", "understudy", "undertaken",
    "undertaker", "undertakes", "undertones", "undervalue",
    "underwater", "underwhelm", "underworld", "underwrite",
    "underwrote", "undeserved", "undetected", "undeterred",
    "undismayed", "undisputed", "undressing", "undulating",
    "undulation", "unearthing", "uneasiness", "uneconomic",
    "unedifying", "uneducated", "unemployed", "unenviable",
    "unerringly", "unevenness", "uneventful", "unexampled",
    "unexciting", "unexpected", "unexplored", "unfairness",
    "unfaithful", "unfamiliar", "unfastened", "unfeasible",
    "unfettered", "unfinished", "unflagging", "unforeseen",
    "unfriendly", "unfrocking", "ungainlier", "ungodliest",
    "ungracious", "ungrateful", "ungrudging", "unhappiest",
    "unheralded", "unhindered", "unhitching", "unhygienic",
    "unicameral", "uniformest", "uniforming", "uniformity",
    "unilateral", "unimpaired", "uninformed", "uninspired",
    "unintended", "uninviting", "uniqueness", "universals",
    "university", "unkindlier", "unkindness", "unknowable",
    "unknowings", "unlatching", "unlawfully", "unlearning",
    "unleashing", "unleavened", "unlettered", "unlicensed",
    "unlikelier", "unluckiest", "unmanliest", "unmannerly",
    "unmerciful", "unmissable", "unmodified", "unmolested",
    "unnumbered", "unobserved", "unoccupied", "unofficial",
    "unoriginal", "unorthodox", "unplayable", "unpleasant",
    "unplugging", "unpolluted", "unprepared", "unprompted",
    "unprovoked", "unpunished", "unreadable", "unreadiest",
    "unrecorded", "unreleased", "unreliable", "unrelieved",
    "unremarked", "unrequited", "unreserved", "unresolved",
    "unrewarded", "unromantic", "unruliness", "unsaddling",
    "unsaleable", "unsanitary", "unschooled", "unscramble",
    "unscrewing", "unscripted", "unseasoned", "unseeingly",
    "unseemlier", "unsettling", "unshakable", "unsheathed",
    "unsheathes", "unskillful", "unsnapping", "unsnarling",
    "unsociable", "unsoundest", "unspecific", "unsporting",
    "unstablest", "unsteadier", "unsteadily", "unstinting",
    "unstopping", "unstressed", "unsuitable", "unsuitably",
    "unswerving", "untangling", "unthinking", "untidiness",
    "untimelier", "untiringly", "untroubled", "untruthful",
    "untwisting", "unverified", "unwariness", "unwavering",
    "unwieldier", "unworkable", "unworthier", "unwrapping",
    "unyielding", "upbraiding", "upbringing", "upchucking",
    "upholsters", "upholstery", "upliftings", "uproarious",
    "upstanding", "upstarting", "upstreamed", "urinalyses",
    "urinalysis", "urological", "urologists", "usefulness",
    "usherettes", "usurpation", "utterances", "vacationed",
    "vacationer", "vaccinated", "vaccinates", "vacillated",
    "vacillates", "vagabonded", "valentines", "validating",
    "validation", "valuations", "vanishings", "vanquished",
    "vanquishes", "vaporising", "variations", "variegated",
    "variegates", "varnishing", "vaudeville", "vegeburger",
    "vegetables", "vegetarian", "vegetating", "vegetation",
    "vegetative", "vehemently", "velocities", "velodromes",
    "velvetiest", "venerating", "veneration", "vengefully",
    "venomously", "ventilated", "ventilates", "ventilator",
    "ventricles", "verballing", "verifiable", "vermicelli",
    "vernacular", "versifying", "vertebrate", "vertically",
    "vestibules", "veterinary", "vibraphone", "vibrations",
    "victorious", "videodiscs", "videophone", "videotaped",
    "videotapes", "viewfinder", "viewpoints", "vigilantes",
    "vigilantly", "vignetting", "vigorously", "villainies",
    "villainous", "vindicated", "vindicates", "vindicator",
    "vindictive", "violations", "violinists", "virtuosity",
    "virtuously", "virulently", "viscountcy", "visibility",
    "visitation", "vitreouses", "vituperate", "viviparous",
    "vocabulary", "vocational", "vociferate", "vociferous",
    "volatility", "volleyball", "voltmeters", "volubility",
    "voluminous", "volunteers", "voluptuary", "voluptuous",
    "vouchsafed", "vouchsafes", "vulgarisms", "vulnerable",
    "vulnerably", "wainscoted", "waistbands", "waistcoats",
    "waistlines", "waitresses", "walkabouts", "wallflower",
    "wallopings", "wallpapers", "wanderings", "wanderlust",
    "wantonness", "wardresses", "warehoused", "warehouses",
    "warmongers", "warrantied", "warranties", "warranting",
    "washbasins", "washboards", "washcloths", "washstands",
    "wassailing", "wastefully", "wastelands", "wastepaper",
    "watchbands", "watchfully", "watchmaker", "watchstrap",
    "watchtower", "watchwords", "waterborne", "watercraft",
    "watercress", "waterfalls", "waterfowls", "waterfront",
    "waterholes", "waterlines", "watermarks", "watermelon",
    "watermills", "waterproof", "watersheds", "watersides",
    "waterspout", "watertight", "waterwheel", "waterworks",
    "wavelength", "wayfarings", "weakfishes", "weaknesses",
    "wealthiest", "weaponless", "weathering", "weatherman",
    "weathermen", "webmasters", "weedkiller", "weekenders",
    "weekending", "weeknights", "weightiest", "weightings",
    "weightless", "wellington", "wellspring", "werewolves",
    "westerlies", "westerners", "whatsoever", "wheelbases",
    "wheelchair", "wheelhouse", "wheeziness", "wherefores",
    "whetstones", "whimpering", "whiplashes", "whirligigs",
    "whirlpools", "whirlwinds", "whirlybird", "whispering",
    "whiteboard", "whitewalls", "whithering", "wholefoods",
    "wholegrain", "wholesaled", "wholesaler", "wholesales",
    "wholewheat", "whomsoever", "whorehouse", "wickedness",
    "wickerwork", "widespread", "wigwagging", "wildcatted",
    "wildcatter", "wildebeest", "wilderness", "wildflower",
    "willingest", "willowiest", "windbreaks", "windburned",
    "windjammer", "windlasses", "windmilled", "windowpane",
    "windowsill", "windscreen", "windshield", "windstorms",
    "windsurfed", "windsurfer", "wingspread", "wintertime",
    "wirelesses", "wiretapped", "wisecracks", "witchcraft",
    "withdrawal", "withstands", "witnessing", "witticisms",
    "woefullest", "wolfhounds", "wolverines", "womanliest",
    "womenfolks", "wonderland", "wonderment", "wondrously",
    "woodblocks", "woodchucks", "woodcutter", "woodenness",
    "woodpecker", "woolliness", "wordlessly", "wordsmiths",
    "workaholic", "workbasket", "workhorses", "workhouses",
    "workingman", "workingmen", "workplaces", "worksheets",
    "worldliest", "worryingly", "worrywarts", "worshipful",
    "worthiness", "worthwhile", "wranglings", "wraparound",
    "wrathfully", "wretcheder", "wretchedly", "wriggliest",
    "wrinkliest", "wristbands", "wristwatch", "wrongdoers",
    "wrongdoing", "wrongfully", "wunderkind", "xenophobes",
    "xenophobia", "xenophobic", "xerography", "xylophones",
    "yardsticks", "yellowness", "yesterdays", "yesteryear",
    "youngsters", "yourselves", "youthfully", "yuppifying",
    "zigzagging", "zookeepers", "zoological", "zoologists"
  };

  const char* w_11[] = {
    "abandonment", "abbreviated", "abbreviates", "abdications",
    "aberrations", "abjurations", "abnormality", "abominating",
    "abomination", "aboriginals", "abortionist", "abracadabra",
    "abrogations", "absenteeism", "absolutists", "abstentions",
    "abstractest", "abstracting", "abstraction", "absurdities",
    "abusiveness", "academician", "accelerated", "accelerates",
    "accelerator", "accentuated", "accentuates", "acceptances",
    "accessioned", "accessories", "accidentals", "acclamation",
    "acclimating", "acclimation", "acclimatise", "acclimatize",
    "accommodate", "accompanied", "accompanies", "accompanist",
    "accomplices", "accordingly", "accountable", "accountancy",
    "accountants", "accrediting", "accumulated", "accumulates",
    "accumulator", "accusations", "accusatives", "accustoming",
    "achievement", "acknowledge", "acquainting", "acquiescent",
    "acquiescing", "acquirement", "acquisition", "acquisitive",
    "acrimonious", "actualities", "acupressure", "acupuncture",
    "adaptations", "addressable", "adjournment", "adjudicated",
    "adjudicates", "adjudicator", "adjurations", "adjustments",
    "administers", "admonishing", "admonitions", "adolescence",
    "adolescents", "adulterants", "adulterated", "adulterates",
    "adumbrating", "adumbration", "advancement", "advantaging",
    "adventurers", "adventuress", "adventuring", "adventurism",
    "adventurist", "adventurous", "adversarial", "adversaries",
    "adversities", "advertisers", "advertising", "advertorial",
    "aerodynamic", "aerogrammes", "aeronautics", "affectation",
    "affectioned", "affiliating", "affiliation", "affirmation",
    "affirmative", "afflictions", "afforesting", "aficionados",
    "afterbirths", "afterburner", "aftereffect", "aftershaves",
    "aftershocks", "aftertastes", "agglomerate", "agglutinate",
    "aggravating", "aggravation", "aggregating", "aggregation",
    "agnosticism", "agoraphobia", "agoraphobic", "agriculture",
    "agronomists", "aimlessness", "airbrushing", "aircraftman",
    "aircraftmen", "airdropping", "airsickness", "airworthier",
    "albatrosses", "algorithmic", "allegations", "allegiances",
    "allegorical", "alleviating", "alleviation", "allocations",
    "alphabeting", "altarpieces", "alterations", "altercation",
    "alternately", "alternating", "alternation", "alternative",
    "alternators", "amalgamated", "amalgamates", "amaryllises",
    "ambassadors", "ambiguities", "ambiguously", "ambitiously",
    "ambivalence", "ameliorated", "ameliorates", "amicability",
    "amorousness", "amorphously", "amphetamine", "amputations",
    "anachronism", "analogously", "anarchistic", "ancestoring",
    "anchorwoman", "anchorwomen", "ancillaries", "androgynous",
    "anemometers", "angelically", "angioplasty", "angiosperms",
    "anglophiles", "anglophones", "animosities", "annexations",
    "annihilated", "annihilates", "annihilator", "anniversary",
    "annotations", "anomalously", "anonymously", "answerphone",
    "antagonisms", "antagonists", "antecedents", "antechamber",
    "anthologies", "anthologist", "anthropoids", "antibiotics",
    "anticipated", "anticipates", "anticyclone", "antipathies",
    "antiphonals", "antiquarian", "antiquaries", "antiquating",
    "antiquities", "antirrhinum", "antiseptics", "antislavery",
    "aphrodisiac", "apocalypses", "apocalyptic", "apologetics",
    "apostrophes", "appallingly", "apparatchik", "apparatuses",
    "apparitions", "appealingly", "appearances", "appeasement",
    "appellation", "appertained", "application", "applicators",
    "appointment", "apportioned", "appositives", "appreciable",
    "appreciably", "appreciated", "appreciates", "apprehended",
    "apprenticed", "apprentices", "approaching", "approbation",
    "appropriate", "approvingly", "approximate", "aquaculture",
    "aquamarines", "aquaplaning", "aquatically", "arbitragers",
    "arbitrageur", "arbitrarily", "arbitrating", "arbitration",
    "arbitrators", "arborvitaes", "archaically", "archbishops",
    "archdeacons", "archdiocese", "archduchess", "archenemies",
    "archipelago", "arduousness", "aristocracy", "aristocrats",
    "arraignment", "arrangement", "articulated", "articulates",
    "artlessness", "ascertained", "ascetically", "asphyxiated",
    "asphyxiates", "aspidistras", "aspirations", "assassinate",
    "assemblages", "assemblyman", "assemblymen", "assertively",
    "assessments", "asseverated", "asseverates", "assiduously",
    "assignation", "assignments", "assimilated", "assimilates",
    "associating", "association", "associative", "assortments",
    "assumptions", "asterisking", "astigmatism", "astonishing",
    "astringency", "astringents", "astrologers", "astronomers",
    "asymmetries", "athleticism", "atmospheres", "atmospheric",
    "atrociously", "attachments", "attainments", "attendances",
    "attentively", "attenuating", "attenuation", "attestation",
    "attitudinal", "attractions", "attributing", "attribution",
    "attributive", "auctioneers", "audaciously", "audiophiles",
    "audiovisual", "auditioning", "auditoriums", "austerities",
    "authoresses", "authorities", "autocracies", "autographed",
    "automobiled", "automobiles", "autoworkers", "auxiliaries",
    "avoirdupois", "avuncularly", "awkwardness", "babysitters",
    "babysitting", "backbencher", "backbenches", "backbitings",
    "backcombing", "backgrounds", "backhanders", "backhanding",
    "backlogging", "backpackers", "backpacking", "backslapper",
    "backslashes", "backsliders", "backsliding", "backspacing",
    "backstopped", "backstreets", "backstretch", "backstroked",
    "backstrokes", "backtracked", "badmouthing", "balefullest",
    "balloonists", "ballplayers", "ballyhooing", "balustrades",
    "bamboozling", "bandleaders", "bandmasters", "banefullest",
    "bankrolling", "bankrupting", "barbarities", "barbarously",
    "barbershops", "barbiturate", "barnstormed", "baronetcies",
    "barricading", "bashfulness", "basketballs", "bassoonists",
    "battledress", "battlefield", "battlements", "battleships",
    "beachcomber", "beansprouts", "beastliness", "beauteously",
    "beauticians", "beautifiers", "beautifuler", "beautifully",
    "beautifying", "bedchambers", "bedevilment", "bedraggling",
    "beefburgers", "befriending", "beguilingly", "beleaguered",
    "bellicosity", "belligerent", "bellwethers", "bellyaching",
    "bellybutton", "benedictine", "benediction", "benefaction",
    "benefactors", "beneficence", "beneficiary", "benevolence",
    "bequeathing", "bereavement", "besmirching", "bestsellers",
    "bestselling", "bewildering", "bibliophile", "bicarbonate",
    "bicentenary", "bifurcating", "bifurcation", "bilaterally",
    "billionaire", "bimonthlies", "biochemical", "biochemists",
    "biodegraded", "biodegrades", "biofeedback", "biographers",
    "biographies", "birdbrained", "birdwatcher", "birthplaces",
    "birthrights", "birthstones", "bisexuality", "bittersweet",
    "bivouacking", "blackballed", "blackboards", "blackguards",
    "blackjacked", "blacklisted", "blackmailed", "blackmailer",
    "blacksmiths", "blackthorns", "blacktopped", "blamelessly",
    "blameworthy", "blancmanges", "blasphemers", "blasphemies",
    "blaspheming", "blasphemous", "blessedness", "blindfolded",
    "blindsiding", "blitzkriegs", "blockbuster", "blockhouses",
    "bloodhounds", "bloodlessly", "bloodmobile", "bloodstains",
    "bloodstream", "bloodsucker", "blowtorches", "bludgeoning",
    "blueberries", "bluebottles", "bluejackets", "blueprinted",
    "blunderbuss", "bobsledding", "boilerplate", "bollockings",
    "bombardiers", "bombardment", "bondholders", "boneshakers",
    "bookbinders", "bookbinding", "bookkeepers", "bookkeeping",
    "bookmarking", "bookmobiles", "booksellers", "bookshelves",
    "boomeranged", "boondoggled", "boondoggles", "bootleggers",
    "bootlegging", "borderlands", "borderlines", "botheration",
    "bottlenecks", "bountifully", "bourgeoisie", "boysenberry",
    "brainstorms", "brainteaser", "brainwashed", "brainwashes",
    "brandishing", "breadbasket", "breadboards", "breadcrumbs",
    "breadfruits", "breadwinner", "breakfasted", "breakpoints",
    "breakwaters", "breastbones", "breastfeeds", "breastplate",
    "breastworks", "bricklayers", "bricklaying", "bridegrooms",
    "bridesmaids", "bridgeheads", "brigantines", "brightening",
    "brilliantly", "brittleness", "broadcaster", "broadminded",
    "broadsheets", "broadsiding", "broadswords", "brontosaurs",
    "broomsticks", "brotherhood", "browbeating", "brownstones",
    "brushstroke", "brusqueness", "brutalities", "brutishness",
    "buccaneered", "bucktoothed", "budgerigars", "bulldogging",
    "bulletining", "bulletproof", "bullfighter", "bullfinches",
    "bullshitted", "bullshitter", "bureaucracy", "bureaucrats",
    "burlesquing", "bushwhacked", "bushwhacker", "businessman",
    "businessmen", "butterflied", "butterflies", "buttonholed",
    "buttonholes", "buttressing", "cacophonies", "cacophonous",
    "calculating", "calculation", "calculators", "calendaring",
    "calibrating", "calibration", "calibrators", "calisthenic",
    "calligraphy", "callousness", "calumniated", "calumniates",
    "camaraderie", "camerawoman", "camerawomen", "camouflaged",
    "camouflages", "campaigners", "campaigning", "campanology",
    "campgrounds", "candelabras", "candelabrum", "candidacies",
    "candidature", "candlelight", "candlestick", "canistering",
    "cannibalism", "cannonading", "cannonballs", "cantaloupes",
    "cantilevers", "cantonments", "canvasbacks", "capaciously",
    "capacitance", "caparisoned", "capillaries", "capitalists",
    "capitations", "capitulated", "capitulates", "cappuccinos",
    "captaincies", "captivating", "captivation", "captivities",
    "carbonating", "carbonation", "carburetors", "carburettor",
    "carcinogens", "cardholders", "cardiograms", "carefullest",
    "carefulness", "caricatured", "caricatures", "carillonned",
    "carjackings", "carnivorous", "carpentered", "carriageway",
    "carsickness", "cartography", "cartoonists", "cartwheeled",
    "caseworkers", "casseroling", "castellated", "castigating",
    "castigation", "castigators", "castrations", "cataclysmic",
    "catafalques", "cataleptics", "catapulting", "catastrophe",
    "catchphrase", "categorical", "caterpillar", "caterwauled",
    "catholicity", "cauliflower", "causalities", "caustically",
    "ceaselessly", "celebrating", "celebration", "celebratory",
    "celebrities", "centenarian", "centenaries", "centennials",
    "centrifugal", "centrifuged", "centrifuges", "centripetal",
    "cerebellums", "cerebration", "ceremonials", "ceremonious",
    "certainties", "certifiable", "certificate", "chaffinches",
    "chainsawing", "chairperson", "chalkboards", "challengers",
    "challenging", "chamberlain", "chambermaid", "championing",
    "chancellery", "chancellors", "chandeliers", "changelings",
    "changeovers", "chanticleer", "chaotically", "chaperoning",
    "charbroiled", "charioteers", "charismatic", "charmingest",
    "chauffeured", "chauvinists", "cheapskates", "checkmating",
    "checkpoints", "cheerfuller", "cheerleader", "cheerlessly",
    "cheeseboard", "cheesecakes", "cheesecloth", "chessboards",
    "chiaroscuro", "chicaneries", "chickenfeed", "chickenshit",
    "childbirths", "childminder", "childproofs", "chimpanzees",
    "chinchillas", "chiropodist", "chitchatted", "chlorinated",
    "chlorinates", "chloroforms", "chlorophyll", "chocoholics",
    "choirmaster", "cholesterol", "choreograph", "christening",
    "chromosomal", "chromosomes", "chronically", "chroniclers",
    "chronicling", "chronograph", "chronometer", "chrysalises",
    "churchgoers", "churchgoing", "churchwoman", "churchwomen",
    "churchyards", "circularity", "circulating", "circulation",
    "circulatory", "circumcised", "circumcises", "circumspect",
    "circumvents", "citizenship", "clairvoyant", "clandestine",
    "clapboarded", "clarinetist", "classically", "classicists",
    "classifieds", "classifying", "clavichords", "cleanliness",
    "clementines", "clergywoman", "clergywomen", "cliffhanger",
    "climatology", "clodhoppers", "cloistering", "closefisted",
    "clothesline", "clothespins", "cloudbursts", "cloverleafs",
    "coagulating", "coagulation", "coalescence", "coastguards",
    "coauthoring", "cobblestone", "cockchafers", "cockleshell",
    "cockroaches", "cocksuckers", "codependent", "coeducation",
    "coefficient", "coexistence", "coffeecakes", "coffeehouse",
    "cogitations", "cognoscente", "cognoscenti", "coincidence",
    "collaborate", "collapsible", "collarbones", "colleaguing",
    "collectible", "collections", "collectives", "collocating",
    "collocation", "colloquials", "colloquiums", "colonialism",
    "colonialist", "combination", "combustible", "comediennes",
    "comestibles", "comeuppance", "comfortable", "comfortably",
    "comfortless", "commandants", "commandeers", "commandment",
    "commemorate", "commendable", "commendably", "commentated",
    "commentates", "commentator", "commercials", "commingling",
    "commiserate", "commissions", "commitments", "commodities",
    "commonality", "commonplace", "communicant", "communicate",
    "communiques", "communistic", "communities", "commutation",
    "commutative", "compactness", "comparative", "comparisons",
    "compartment", "compatibles", "compatriots", "compendiums",
    "compensated", "compensates", "competences", "competently",
    "competition", "competitive", "competitors", "compilation",
    "complacence", "complacency", "complainant", "complainers",
    "complaining", "complaisant", "complements", "completions",
    "complexions", "complicated", "complicates", "compliments",
    "comportment", "composition", "compositors", "compounding",
    "comprehends", "compressing", "compression", "compressors",
    "compromised", "compromises", "comptroller", "compulsions",
    "compunction", "computation", "computerate", "comradeship",
    "concatenate", "concavities", "concealment", "conceitedly",
    "conceivable", "conceivably", "concentrate", "conceptions",
    "concernedly", "concertgoer", "concertinas", "concessions",
    "conciliated", "conciliates", "conciliator", "conciseness",
    "conclusions", "concoctions", "concomitant", "concordance",
    "concurrence", "concurrency", "concussions", "condescends",
    "conditional", "conditioned", "conditioner", "condolences",
    "condominium", "conductress", "confections", "confederacy",
    "confederate", "conferences", "conferments", "confessedly",
    "confessions", "confidantes", "confidences", "confidently",
    "confidingly", "configuring", "confinement", "confiscated",
    "confiscates", "conflations", "conflicting", "confluences",
    "conformance", "conformists", "confounding", "confronting",
    "confusingly", "congenially", "congregants", "congregated",
    "congregates", "congressman", "congressmen", "congruities",
    "conjectural", "conjectured", "conjectures", "conjugating",
    "conjugation", "conjunction", "conjunctive", "conjuncture",
    "connections", "connectives", "connoisseur", "connotation",
    "connotative", "consciences", "consciouses", "consciously",
    "conscripted", "consecrated", "consecrates", "consecutive",
    "consensuses", "consequence", "conservancy", "conservator",
    "considerate", "considering", "consignment", "consistency",
    "consolation", "consolatory", "consolidate", "consonances",
    "conspicuous", "conspirator", "constipated", "constipates",
    "constituent", "constituted", "constitutes", "constrained",
    "constraints", "constricted", "constrictor", "constructed",
    "constructor", "consultancy", "consultants", "consumables",
    "consumerism", "consumerist", "consummated", "consummates",
    "consumption", "consumptive", "contactable", "containment",
    "contaminant", "contaminate", "contemplate", "contentedly",
    "contentions", "contentious", "contentment", "contestants",
    "continental", "contingency", "contingents", "continually",
    "continuance", "contortions", "contractile", "contracting",
    "contraction", "contractors", "contractual", "contradicts",
    "contraflows", "contraption", "contrasting", "contravened",
    "contravenes", "contretemps", "contributed", "contributes",
    "contributor", "contrivance", "controllers", "controlling",
    "controversy", "controverts", "contumelies", "conurbation",
    "convalesced", "convalesces", "convenience", "conventions",
    "convergence", "conversions", "convertible", "conveyances",
    "convictions", "convivially", "convocation", "convolution",
    "convulsions", "cooperating", "cooperation", "cooperative",
    "coordinated", "coordinates", "coordinator", "copperheads",
    "copperplate", "copycatting", "copyrighted", "copywriters",
    "corkscrewed", "cornerstone", "cornflowers", "cornucopias",
    "corollaries", "coronations", "corporation", "corporatism",
    "correctable", "corrections", "correctives", "correctness",
    "correlating", "correlation", "correlative", "corresponds",
    "corroborate", "corrugating", "corrugation", "corruptible",
    "corruptions", "corruptness", "coruscating", "cosignatory",
    "cosmetology", "cosmogonies", "cosmologies", "cosmologist",
    "cosponsored", "coterminous", "cottonmouth", "cottonseeds",
    "cottontails", "cottonwoods", "counselings", "countenance",
    "counteracts", "counterfeit", "counterfoil", "countermand",
    "counterpane", "counterpart", "countersign", "countersink",
    "countersunk", "countervail", "countrified", "countryside",
    "countrywide", "coursebooks", "courteously", "courthouses",
    "courtliness", "covenanting", "cowcatchers", "cowpunchers",
    "coxswaining", "crackerjack", "craftswoman", "craftswomen",
    "cranberries", "crankshafts", "crawlspaces", "creationism",
    "creationist", "credentials", "credibility", "credulously",
    "crematories", "crematorium", "crepuscular", "crestfallen",
    "criminality", "criminology", "cripplingly", "crispbreads",
    "crookedness", "crossbarred", "crossbreeds", "crosschecks",
    "crosspieces", "crucifixion", "crustaceans", "cryptically",
    "cryptograms", "crystalline", "culminating", "culmination",
    "culpability", "cultivating", "cultivation", "cultivators",
    "cummerbunds", "cunnilingus", "curiosities", "curmudgeons",
    "currycombed", "curtailment", "customarily", "cybernetics",
    "cylindrical", "dangerously", "dauntlessly", "daydreamers",
    "daydreaming", "deaconesses", "deactivated", "deactivates",
    "deadheading", "deadlocking", "deadpanning", "dealerships",
    "debarkation", "debasements", "debilitated", "debilitates",
    "debriefings", "decapitated", "decapitates", "decathletes",
    "deceitfully", "decelerated", "decelerates", "deceptively",
    "deciphering", "declamation", "declamatory", "declaration",
    "declarative", "declensions", "declination", "declivities",
    "decomposing", "deconstruct", "decorations", "decremented",
    "decrepitude", "decrescendo", "dedications", "deductibles",
    "deerstalker", "deescalated", "deescalates", "defectively",
    "defensively", "deferential", "definitions", "deflections",
    "deflowering", "defoliating", "defoliation", "deforesting",
    "deformation", "deformities", "degenerated", "degenerates",
    "degradation", "dehydrating", "dehydration", "deification",
    "delectation", "delegations", "deleterious", "deliberated",
    "deliberates", "deliciously", "delightedly", "delineating",
    "delineation", "delinquency", "delinquents", "deliriously",
    "deliverable", "deliverance", "deliveryman", "deliverymen",
    "delphiniums", "demagoguery", "demarcating", "demarcation",
    "demigoddess", "democracies", "demographer", "demographic",
    "demolishing", "demolitions", "demonically", "demonstrate",
    "demotivated", "demotivates", "demystified", "demystifies",
    "denigrating", "denigration", "denominated", "denominates",
    "denominator", "denotations", "denouements", "dentifrices",
    "departments", "deployments", "depopulated", "depopulates",
    "deportation", "depositions", "depravities", "deprecating",
    "deprecation", "deprecatory", "depreciated", "depreciates",
    "depredation", "depressants", "depressions", "depressives",
    "deprivation", "deputations", "derailments", "derangement",
    "deregulated", "deregulates", "dereliction", "derivations",
    "derivatives", "dermatology", "desalinated", "desalinates",
    "descendants", "describable", "description", "descriptive",
    "descriptors", "desecrating", "desecration", "desegregate",
    "deselecting", "deselection", "desiccating", "desiccation",
    "desideratum", "designating", "designation", "desperadoes",
    "desperately", "desperation", "despondency", "destination",
    "destitution", "destructing", "destruction", "destructive",
    "desultorily", "detachments", "deteriorate", "determinant",
    "determinate", "determiners", "determining", "determinism",
    "detestation", "detonations", "detoxifying", "detrimental",
    "devaluation", "devastating", "devastation", "development",
    "deviousness", "devotionals", "dexterously", "diacritical",
    "diagnostics", "diagramming", "dialectical", "diametrical",
    "dichotomies", "dictatorial", "diddlysquat", "didgeridoos",
    "differences", "differently", "diffidently", "diffracting",
    "diffraction", "diffuseness", "dignitaries", "digressions",
    "dilapidated", "dilettantes", "dimensional", "diminishing",
    "diminuendos", "diminutions", "diminutives", "diplomatics",
    "diplomatist", "dipsomaniac", "directional", "directorate",
    "directorial", "directories", "disablement", "disaffected",
    "disafforest", "disagreeing", "disallowing", "disappeared",
    "disappoints", "disapproval", "disapproved", "disapproves",
    "disarmament", "disarmingly", "disarranged", "disarranges",
    "disarraying", "disassemble", "disbelieved", "disbelieves",
    "discernible", "discernibly", "discernment", "discharging",
    "disciplined", "disciplines", "disclaimers", "disclaiming",
    "disclosures", "discography", "discomfited", "discomforts",
    "discommoded", "discommodes", "discomposed", "discomposes",
    "disconcerts", "disconnects", "discontents", "discontinue",
    "discotheque", "discounters", "discounting", "discouraged",
    "discourages", "discoursing", "discourtesy", "discoverers",
    "discoveries", "discovering", "discredited", "discreetest",
    "discrepancy", "discussants", "discussions", "disembarked",
    "disembodied", "disembodies", "disembowels", "disenchants",
    "disencumber", "disengaging", "disentangle", "disfiguring",
    "disgraceful", "disgruntled", "disgruntles", "disgustedly",
    "disheartens", "dishonestly", "dishwashers", "disillusion",
    "disinclined", "disinclines", "disinfected", "disinherits",
    "disinterest", "disinterred", "disjointing", "disjuncture",
    "dislocating", "dislocation", "dismantling", "dismembered",
    "dismounting", "disobedient", "disobliging", "disordering",
    "disoriented", "disparaging", "disparities", "dispatchers",
    "dispatching", "dispensable", "dispiriting", "displayable",
    "displeasing", "displeasure", "disposables", "disposition",
    "disputation", "disquieting", "disregarded", "disrespects",
    "disruptions", "dissections", "dissembling", "disseminate",
    "dissensions", "disservices", "dissimilars", "dissimulate",
    "dissipating", "dissipation", "dissociated", "dissociates",
    "dissolutely", "dissolution", "dissonances", "distasteful",
    "distensions", "distentions", "distillates", "distinctest",
    "distinction", "distinctive", "distinguish", "distortions",
    "distracting", "distraction", "distressful", "distressing",
    "distributed", "distributes", "distributor", "distrustful",
    "distrusting", "disturbance", "divergences", "diversified",
    "diversifies", "diversities", "divestiture", "dockworkers",
    "doctrinaire", "documentary", "documenting", "dogcatchers",
    "dogfighting", "dogtrotting", "dolefullest", "domesticate",
    "domesticity", "domiciliary", "domineering", "doorkeepers",
    "doorknocker", "doorstepped", "dormitories", "doublespeak",
    "doubtlessly", "dovetailing", "downgrading", "downhearted",
    "downloading", "downplaying", "downscaling", "downshifted",
    "downtrodden", "draftswoman", "draftswomen", "dragonflies",
    "drainboards", "drastically", "drawbridges", "drawstrings",
    "dreadnought", "dressmakers", "dressmaking", "dromedaries",
    "drunkenness", "dubiousness", "dumbfounded", "dumbwaiters",
    "dunderheads", "duplicating", "duplication", "duplicators",
    "duplicitous", "dynamically", "dysfunction", "earnestness",
    "earthenware", "earthquaked", "earthquakes", "easternmost",
    "eclecticism", "econometric", "edification", "editorially",
    "educational", "edutainment", "effectively", "effectually",
    "effectuated", "effectuates", "effervesced", "effervesces",
    "efficacious", "efficiently", "egalitarian", "egocentrics",
    "egotistical", "egregiously", "eigenvalues", "eighteenths",
    "eisteddfods", "ejaculating", "ejaculation", "elaborately",
    "elaborating", "elaboration", "elasticated", "electioneer",
    "electorally", "electorates", "electrician", "electricity",
    "electrified", "electrifies", "electrocute", "electrolyte",
    "electronics", "elephantine", "eligibility", "eliminating",
    "elimination", "eliminators", "elongations", "elucidating",
    "elucidation", "elusiveness", "emancipated", "emancipates",
    "emancipator", "emasculated", "emasculates", "embankments",
    "embarkation", "embarrassed", "embarrasses", "embellished",
    "embellishes", "embittering", "emblazoning", "emboldening",
    "embrocation", "embroidered", "emendations", "emergencies",
    "emigrations", "emotionally", "emotionless", "empirically",
    "empiricists", "emplacement", "employables", "employments",
    "empowerment", "emulsifiers", "emulsifying", "encampments",
    "encapsulate", "enchantment", "enchantress", "encompassed",
    "encompasses", "encountered", "encouraging", "encroaching",
    "encumbering", "encumbrance", "encyclicals", "endangering",
    "endearingly", "endearments", "endlessness", "endorsement",
    "enforceable", "enforcement", "enfranchise", "engagements",
    "engendering", "engineering", "engorgement", "enhancement",
    "enlargement", "enlightened", "enlistments", "ennoblement",
    "enquiringly", "enrapturing", "enshrouding", "enslavement",
    "enterprises", "entertained", "entertainer", "enthralling",
    "enthusiasms", "enthusiasts", "enticements", "entitlement",
    "entrenching", "entryphones", "enumerating", "enumeration",
    "enunciating", "enunciation", "envelopment", "enviousness",
    "environment", "envisioning", "epidermises", "equestrians",
    "equidistant", "equilateral", "equilibrium", "equinoctial",
    "equivalence", "equivalents", "equivocally", "equivocated",
    "equivocates", "eradicating", "eradication", "erratically",
    "erroneously", "erythrocyte", "escalations", "escarpments",
    "eschatology", "escutcheons", "espadrilles", "essentially",
    "established", "establishes", "estimations", "ethnography",
    "ethnologist", "etymologies", "etymologist", "euphemistic",
    "evacuations", "evaluations", "evangelical", "evangelists",
    "evaporating", "evaporation", "evasiveness", "eventuality",
    "eventuating", "everlasting", "eviscerated", "eviscerates",
    "evocatively", "exacerbated", "exacerbates", "exaggerated",
    "exaggerates", "examination", "exasperated", "exasperates",
    "excavations", "exceedingly", "excellently", "exceptional",
    "excessively", "excitements", "exclamation", "exclamatory",
    "exclusively", "exclusivity", "excoriating", "excoriation",
    "excrescence", "excretories", "exculpating", "exculpation",
    "exculpatory", "executioner", "executrices", "exemplified",
    "exemplifies", "exfoliating", "exfoliation", "exhalations",
    "exhaustible", "exhibitions", "exhilarated", "exhilarates",
    "exhortation", "exhumations", "existential", "exonerating",
    "exoneration", "exorbitance", "expansively", "expatiating",
    "expatriated", "expatriates", "expectantly", "expectation",
    "expectorant", "expectorate", "expediences", "expediently",
    "expeditions", "expeditious", "expendables", "expenditure",
    "expensively", "experienced", "experiences", "experiments",
    "explanation", "explanatory", "explicating", "explication",
    "exploitable", "exploration", "exploratory", "explosively",
    "exponential", "exportation", "expositions", "expostulate",
    "expressible", "expressions", "expressways", "expropriate",
    "expurgating", "expurgation", "exquisitely", "extensional",
    "extensively", "extenuating", "extenuation", "exterminate",
    "extinctions", "extirpating", "extirpation", "extortioner",
    "extractions", "extraditing", "extradition", "extrapolate",
    "extravagant", "extremities", "extricating", "extrication",
    "extroverted", "exuberantly", "fabricating", "fabrication",
    "facetiously", "facilitated", "facilitates", "facilitator",
    "faddishness", "fairgrounds", "faithlessly", "fallibility",
    "falsifiable", "falteringly", "familiarity", "fanatically",
    "fantastical", "farinaceous", "fascinating", "fascination",
    "fashionable", "fashionably", "fatherlands", "fatuousness",
    "faultlessly", "fearfullest", "fearfulness", "feasibility",
    "featheriest", "featureless", "federalists", "federations",
    "fellowships", "ferociously", "festivities", "fetishistic",
    "feudalistic", "fiduciaries", "fieldworker", "figureheads",
    "filamentous", "filibusters", "filigreeing", "financially",
    "fingerboard", "fingermarks", "fingernails", "fingerprint",
    "firebombing", "firecracker", "firefighter", "firelighter",
    "fireproofed", "firescreens", "firewalling", "fishmongers",
    "fishtailing", "flabbergast", "flagellants", "flagellated",
    "flagellates", "flamboyance", "flashlights", "flatfooting",
    "fledgelings", "flexibility", "flightiness", "flimflammed",
    "flirtations", "flirtatious", "floodlights", "floorboards",
    "floundering", "flourishing", "floweriness", "fluctuating",
    "fluctuation", "fluorescent", "fluorescing", "fluoridated",
    "fluoridates", "fluoroscope", "flycatchers", "flyspecking",
    "flyswatters", "fomentation", "foolhardier", "foolishness",
    "footballers", "footballing", "footbridges", "footlockers",
    "forbearance", "forbiddings", "forebodings", "forecasters",
    "forecasting", "forecastles", "foreclosing", "foreclosure",
    "foredooming", "forefathers", "forefingers", "foregrounds",
    "foreordains", "forerunners", "foreseeable", "foreshadows",
    "foreshorten", "forestalled", "forestation", "foretasting",
    "foretelling", "forethought", "forevermore", "forewarning",
    "forfeitures", "forgathered", "forgetfully", "forgettable",
    "forgiveness", "formalities", "formulating", "formulation",
    "fornicating", "fornication", "fornicators", "forswearing",
    "forthcoming", "fortnightly", "fortressing", "fortunately",
    "forwardness", "foundations", "fountaining", "fourteenths",
    "foxtrotting", "fractiously", "fragmentary", "fragmenting",
    "franchisees", "franchisers", "franchising", "francophone",
    "frankfurter", "frantically", "fraternally", "fratricidal",
    "fratricides", "fraudulence", "freebooters", "freeholders",
    "freelancers", "freelancing", "freeloaders", "freeloading",
    "freemasonry", "freethinker", "freewheeled", "frequencies",
    "frequentest", "frequenting", "fretfulness", "friendliest",
    "friendships", "frightening", "frightfully", "frivolities",
    "frivolously", "frogmarched", "frogmarches", "frostbiting",
    "frostbitten", "fructifying", "fruitfuller", "fruitlessly",
    "frustrating", "frustration", "fulminating", "fulmination",
    "fulsomeness", "functionary", "functioning", "fundamental",
    "furloughing", "furnishings", "furtherance", "furthermore",
    "furthermost", "furtiveness", "fussbudgets", "futuristics",
    "gallbladder", "gallivanted", "gamekeepers", "garrisoning",
    "garrulously", "gastronomes", "gastronomic", "gatecrashed",
    "gatecrasher", "gatecrashes", "gatekeepers", "gazetteered",
    "genealogies", "genealogist", "generalists", "generations",
    "generically", "genetically", "geneticists", "gentlemanly",
    "gentlewoman", "gentlewomen", "gentrifying", "genuflected",
    "genuineness", "geographers", "geographies", "geometrical",
    "geophysical", "geopolitics", "germinating", "germination",
    "gerontology", "gerrymander", "gesticulate", "ghastliness",
    "ghostliness", "ghostwriter", "ghostwrites", "gingerbread",
    "gingersnaps", "girlfriends", "glamorously", "glasshouses",
    "glimmerings", "glitterings", "goalkeepers", "goalscorers",
    "goaltenders", "gobstoppers", "godchildren", "goddaughter",
    "godforsaken", "godlessness", "goldbricked", "goldfinches",
    "governesses", "governments", "gracefuller", "gracelessly",
    "graduations", "grammarians", "grammatical", "gramophones",
    "grandaddies", "grandfather", "grandmother", "grandparent",
    "grandstands", "granularity", "granulating", "granulation",
    "grapefruits", "graphically", "grasshopper", "gratefuller",
    "gravedigger", "gravestones", "gravitating", "gravitation",
    "greasepaint", "greengrocer", "greenhouses", "griddlecake",
    "gridlocking", "grindstones", "grotesquely", "grouchiness",
    "groundcloth", "groundsheet", "groundswell", "groundwater",
    "guarantying", "guardhouses", "guesstimate", "guesthouses",
    "guilelessly", "guillotined", "guillotines", "gullibility",
    "gunfighters", "gunfighting", "gunslingers", "guttersnipe",
    "gymnosperms", "haberdasher", "habitations", "habituating",
    "habituation", "hagiography", "hairbreadth", "hairbrushes",
    "haircutting", "hairdresser", "hairsprings", "hairstylist",
    "halfhearted", "halfpennies", "hallelujahs", "hallmarking",
    "hallucinate", "halternecks", "hammerheads", "handbagging",
    "handcrafted", "handcuffing", "handicapped", "handicapper",
    "handicrafts", "handmaidens", "handpicking", "handshaking",
    "handsprings", "handwriting", "handwritten", "haphazardly",
    "hardhearted", "harebrained", "harmfulness", "harpsichord",
    "harrumphing", "hatefulness", "haughtiness", "hawkishness",
    "headbangers", "headbanging", "headbutting", "headdresses",
    "headhunters", "headhunting", "headmasters", "headquarter",
    "headscarves", "headteacher", "headwaiters", "healthfully",
    "healthiness", "heartbreaks", "heartbroken", "heartlessly",
    "heartthrobs", "heavenliest", "heavenwards", "heavyweight",
    "heightening", "heinousness", "helicopters", "heliotropes",
    "helpfulness", "hemispheres", "hemispheric", "hemorrhaged",
    "hemorrhages", "hemorrhoids", "hemstitched", "hemstitches",
    "heptathlons", "herbivorous", "hereinafter", "herringbone",
    "hesitations", "hexadecimal", "hibernating", "hibernation",
    "hideousness", "hierarchies", "hieroglyphs", "highfalutin",
    "highlanders", "highlighted", "highlighter", "hightailing",
    "hilariously", "hillbillies", "hindquarter", "hinterlands",
    "histrionics", "hitchhikers", "hitchhiking", "hobbyhorses",
    "hodgepodges", "holographic", "homecomings", "homesteaded",
    "homesteader", "homestretch", "homeworkers", "homeworking",
    "homogeneity", "homogeneous", "homosexuals", "honeycombed",
    "honeymooned", "honeymooner", "honeysuckle", "honorariums",
    "hoodwinking", "hooliganism", "hopefulness", "hopscotched",
    "hopscotches", "horizontals", "horseradish", "hospitality",
    "hostilities", "hotheadedly", "hourglasses", "housebreaks",
    "housebroken", "housecleans", "householder", "housekeeper",
    "housemaster", "housemother", "houseplants", "housewifely",
    "hovercrafts", "huckleberry", "huckstering", "hullabaloos",
    "humidifiers", "humidifying", "humiliating", "humiliation",
    "hummingbird", "hunchbacked", "hundredfold", "hurtfulness",
    "hydrocarbon", "hydrogenate", "hydrometers", "hydrophobia",
    "hydroplaned", "hydroplanes", "hydroponics", "hydrosphere",
    "hygrometers", "hyperactive", "hypermarket", "hyphenating",
    "hyphenation", "hypocrisies", "hypodermics", "hypotenuses",
    "hypothalami", "hypothermia", "icebreakers", "iconoclasts",
    "iconography", "identically", "identifiers", "identifying",
    "ideological", "ideologists", "idiotically", "idyllically",
    "ignominious", "ignoramuses", "illicitness", "illiterates",
    "illogically", "illuminated", "illuminates", "illusionist",
    "illustrated", "illustrates", "illustrator", "illustrious",
    "imagination", "imaginative", "immediately", "immensities",
    "immigrating", "immigration", "immortality", "impairments",
    "impartially", "impassioned", "impassively", "impassivity",
    "impatiences", "impatiently", "impeachable", "impeachment",
    "impeccables", "impecunious", "impedimenta", "impediments",
    "impenitence", "impenitents", "imperatives", "imperfectly",
    "imperialism", "imperialist", "imperiously", "impermanent",
    "impermeable", "impersonate", "impertinent", "impetuosity",
    "impetuously", "impingement", "impiousness", "implausible",
    "implausibly", "implemented", "implementer", "implicating",
    "implication", "imploringly", "importantly", "importation",
    "importunate", "importuning", "importunity", "impositions",
    "impossibles", "impractical", "imprecation", "imprecisely",
    "imprecision", "impregnable", "impregnably", "impregnated",
    "impregnates", "impresarios", "impressions", "imprimaturs",
    "imprisoning", "impropriety", "improvement", "improvident",
    "improvising", "imprudently", "impulsively", "imputations",
    "inabilities", "inadequates", "inadvertent", "inadvisable",
    "inalienable", "inattention", "inattentive", "inaugurated",
    "inaugurates", "incantation", "incarcerate", "incarnating",
    "incarnation", "incessantly", "incidentals", "incinerated",
    "incinerates", "incinerator", "incitements", "inclination",
    "inclusively", "incoherence", "incompetent", "incongruity",
    "incongruous", "inconstancy", "incontinent", "incorporate",
    "incorporeal", "incorrectly", "increasings", "incredulity",
    "incredulous", "incremental", "incremented", "incriminate",
    "inculcating", "inculcation", "inculpating", "indecencies",
    "indecentest", "indefinable", "indefinably", "indefinites",
    "indemnified", "indemnifies", "indemnities", "indentation",
    "indenturing", "independent", "indexations", "indications",
    "indicatives", "indictments", "indifferent", "indigestion",
    "indignantly", "indignation", "indignities", "indirection",
    "individuals", "indivisible", "indivisibly", "indomitable",
    "indomitably", "indubitable", "indubitably", "inducements",
    "inductively", "indulgences", "indulgently", "industrious",
    "inebriating", "inebriation", "ineffective", "ineffectual",
    "inefficient", "inelegantly", "ineligibles", "ineluctable",
    "ineluctably", "inequitable", "inescapable", "inescapably",
    "inessential", "inestimable", "inestimably", "inexcusable",
    "inexcusably", "inexpedient", "inexpensive", "infanticide",
    "infantryman", "infantrymen", "infatuating", "infatuation",
    "inferential", "inferiority", "infertility", "infestation",
    "infiltrated", "infiltrates", "infiltrator", "infinitives",
    "infirmaries", "infirmities", "inflammable", "inflatables",
    "inflections", "influencing", "influential", "infomercial",
    "informality", "information", "informative", "infractions",
    "infrequency", "infuriating", "ingeniously", "ingenuously",
    "ingratiated", "ingratiates", "ingratitude", "ingredients",
    "inhabitable", "inhabitants", "inhalations", "inheritance",
    "inhibitions", "initiations", "initiatives", "injudicious",
    "injunctions", "innocentest", "innocuously", "innovations",
    "innuendoing", "innumerable", "inoculating", "inoculation",
    "inoffensive", "inoperative", "inopportune", "inquiringly",
    "inquisition", "inquisitive", "inquisitors", "inscription",
    "inscrutable", "inscrutably", "insecticide", "insectivore",
    "inseminated", "inseminates", "insensitive", "insentience",
    "inseparable", "inseparably", "insidiously", "insincerely",
    "insincerity", "insinuating", "insinuation", "insipidness",
    "insistently", "insouciance", "inspections", "inspiration",
    "instability", "instigating", "instigation", "instigators",
    "instinctive", "instinctual", "instituting", "institution",
    "instructing", "instruction", "instructive", "instructors",
    "instruments", "insultingly", "insuperable", "insuperably",
    "insurgences", "intangibles", "integrating", "integration",
    "integuments", "intelligent", "intemperate", "intensified",
    "intensifier", "intensifies", "intensities", "intensively",
    "intentional", "interacting", "interaction", "interactive",
    "interbreeds", "interceding", "intercepted", "interceptor",
    "intercessor", "interchange", "intercourse", "interdicted",
    "interesting", "interfacing", "interfering", "interjected",
    "interlacing", "interlarded", "interleaved", "interleaves",
    "interleukin", "interlinked", "interlocked", "interlopers",
    "interluding", "intermezzos", "intermingle", "internecine",
    "internships", "interoffice", "interpolate", "interposing",
    "interpreted", "interpreter", "interracial", "interregnum",
    "interrelate", "interrogate", "interrupted", "intersected",
    "intersperse", "interstates", "interstices", "intertwined",
    "intertwines", "intervening", "interviewed", "interviewee",
    "interviewer", "interweaves", "intimations", "intimidated",
    "intimidates", "intolerable", "intolerably", "intolerance",
    "intonations", "intoxicants", "intoxicated", "intoxicates",
    "intractable", "intractably", "intravenous", "intricacies",
    "intricately", "introducing", "introverted", "intuitively",
    "inundations", "invalidated", "invalidates", "invariables",
    "inventively", "inventoried", "inventories", "investigate",
    "investiture", "investments", "invidiously", "invigilated",
    "invigilates", "invigilator", "invigorated", "invigorates",
    "invitations", "invocations", "involuntary", "involvement",
    "ionospheres", "iridescence", "ironmongers", "ironmongery",
    "irradiating", "irradiation", "irrationals", "irreducible",
    "irreducibly", "irrefutable", "irrefutably", "irregularly",
    "irrelevance", "irrelevancy", "irreligious", "irreparable",
    "irreparably", "irreverence", "irrevocable", "irrevocably",
    "irritations", "itineraries", "jackhammers", "jackknifing",
    "jackrabbits", "jawbreakers", "jellyfishes", "jettisoning",
    "jinrikishas", "joblessness", "journalists", "joylessness",
    "judiciaries", "judiciously", "juggernauts", "justifiable",
    "justifiably", "juxtaposing", "kangarooing", "keelhauling",
    "kerchiefing", "kettledrums", "keyboarders", "keyboarding",
    "keyboardist", "keypunching", "keystroking", "kidnappings",
    "kindhearted", "kingfishers", "kitchenette", "kitchenware",
    "kleptomania", "knackwursts", "kneecapping", "knickknacks",
    "knighthoods", "knucklehead", "kookaburras", "laboriously",
    "lacerations", "laconically", "laddishness", "ladyfingers",
    "lamentation", "landholders", "landholding", "landlubbers",
    "landscapers", "landscaping", "landsliding", "languishing",
    "latitudinal", "latticework", "launderette", "laundresses",
    "laundrettes", "laundromats", "lavendering", "lawbreakers",
    "lawlessness", "leaderships", "leapfrogged", "leaseholder",
    "leatherette", "leatherneck", "lecherously", "lectureship",
    "legerdemain", "legionaries", "legionnaire", "legislating",
    "legislation", "legislative", "legislators", "legislature",
    "legitimated", "legitimates", "leisurewear", "lengthening",
    "leprechauns", "letterboxes", "letterheads", "leucotomies",
    "levelheaded", "liabilities", "libertarian", "librettists",
    "licentiates", "lieutenancy", "lieutenants", "lightheaded",
    "lighthouses", "lightninged", "lightweight", "likableness",
    "likelihoods", "lilliputian", "limelighted", "limitations",
    "linebackers", "lingeringly", "linguistics", "lionhearted",
    "liposuction", "lipsticking", "liquidating", "liquidation",
    "liquidators", "literalness", "lithographs", "lithography",
    "lithosphere", "livelihoods", "locomotives", "logarithmic",
    "loggerheads", "loudhailers", "loudmouthed", "loudspeaker",
    "loutishness", "lubricating", "lubrication", "lubricators",
    "lucratively", "ludicrously", "lumberjacks", "lumberyards",
    "luminescent", "luncheoning", "luxuriantly", "luxuriating",
    "luxuriously", "machination", "macrobiotic", "macroscopic",
    "maddeningly", "magisterial", "magistrates", "magnanimity",
    "magnanimous", "magnificent", "maidenheads", "maidservant",
    "mainsprings", "mainstreams", "maintainers", "maintaining",
    "maintenance", "maisonettes", "makeweights", "maladjusted",
    "maladroitly", "malapropism", "malcontents", "malediction",
    "malefactors", "malevolence", "malfeasance", "malfunction",
    "maliciously", "malignantly", "malingerers", "malingering",
    "malpractice", "maltreating", "mammography", "managements",
    "manhandling", "manicurists", "manifesting", "manifestoed",
    "manifolding", "manipulated", "manipulates", "manipulator",
    "mannishness", "mantelpiece", "mantelshelf", "manufacture",
    "manumitting", "manuscripts", "marathoners", "marchioness",
    "marionettes", "marketplace", "marshmallow", "masculinity",
    "masochistic", "masqueraded", "masquerader", "masquerades",
    "massiveness", "masterclass", "masterfully", "masterminds",
    "masterpiece", "masterworks", "masticating", "mastication",
    "masturbated", "masturbates", "matchmakers", "matchmaking",
    "matchsticks", "materialism", "materialist", "mathematics",
    "matriarchal", "matriculate", "matrimonial", "mavericking",
    "mawkishness", "meadowlarks", "meanderings", "meaningless",
    "measureless", "measurement", "mechanistic", "medications",
    "medicinally", "meditations", "megalomania", "megalopolis",
    "megaphoning", "melancholia", "melancholic", "mellifluous",
    "melodically", "melodiously", "memberships", "memorabilia",
    "memorandums", "menservants", "menstruated", "menstruates",
    "mentalities", "mentholated", "mercenaries", "merchandise",
    "merchanting", "merchantman", "merchantmen", "mercilessly",
    "meritocracy", "meritorious", "merrymakers", "merrymaking",
    "metabolisms", "metacarpals", "metamorphic", "metaphysics",
    "metatarsals", "meteorology", "methodology", "metrication",
    "microfilmed", "microlights", "microphones", "microscopes",
    "microscopic", "microsecond", "microwaving", "middlebrows",
    "midfielders", "midsections", "midwiferies", "mileometers",
    "militarists", "millenniums", "millionaire", "millisecond",
    "milquetoast", "mimeographs", "mindfulness", "minesweeper",
    "miniaturing", "miniaturist", "minimalists", "ministerial",
    "ministering", "ministrants", "mirthlessly", "misalliance",
    "misanthrope", "misanthropy", "misapplying", "misbegotten",
    "misbehaving", "miscarriage", "miscarrying", "mischancing",
    "mischiefing", "mischievous", "misconceive", "misconducts",
    "misconstrue", "miscounting", "misdiagnose", "misdirected",
    "miserliness", "misfeasance", "misfortunes", "misgoverned",
    "misguidedly", "mishandling", "misidentify", "misinformed",
    "mismanaging", "mismatching", "misnomering", "misogynists",
    "misprinting", "misreadings", "misreported", "misspelling",
    "misspending", "misstepping", "mistreating", "mistrustful",
    "mistrusting", "mizzenmasts", "mockingbird", "modernistic",
    "modulations", "molestation", "mollycoddle", "momentarily",
    "monarchical", "monarchists", "monasteries", "monasticism",
    "monetarists", "moneylender", "moneymakers", "moneymaking",
    "monkeyshine", "monochromes", "monogrammed", "monolingual",
    "monologuing", "monomaniacs", "monopolists", "monotheists",
    "monstrances", "monstrosity", "monstrously", "moonlighted",
    "moonlighter", "moratoriums", "mortarboard", "mothballing",
    "motherboard", "motherlands", "motivations", "motocrosses",
    "motorbiking", "motorcycled", "motorcycles", "motormouths",
    "mountaineer", "mountainous", "mountaintop", "mountebanks",
    "mournfuller", "mouthpieces", "mouthwashes", "mudslingers",
    "mudslinging", "multiplexed", "multiplexer", "multiplexes",
    "multipliers", "multiplying", "multiracial", "municipally",
    "munificence", "murderesses", "murderously", "muscularity",
    "musculature", "mushrooming", "muskellunge", "mustachioed",
    "mutilations", "mutineering", "mythologies", "mythologist",
    "myxomatosis", "nailbrushes", "nanoseconds", "naphthalene",
    "narcissists", "narcoleptic", "nasturtiums", "nationalism",
    "nationalist", "nationality", "naturalists", "naturalness",
    "naughtiness", "neanderthal", "nearsighted", "necessaries",
    "necessarily", "necessitate", "necessities", "neckerchief",
    "necklacings", "necromancer", "necrophilia", "needlepoint",
    "needlewoman", "needlewomen", "nefariously", "negligently",
    "negotiating", "negotiation", "negotiators", "nervelessly",
    "nervousness", "netherworld", "neurologist", "neutralists",
    "newscasters", "newscasting", "newsflashes", "newsletters",
    "newspapered", "newsreaders", "nickelodeon", "nightingale",
    "nightlights", "nightmarish", "nightshades", "nightshirts",
    "nightstands", "nightsticks", "nincompoops", "nineteenths",
    "nitrogenous", "nocturnally", "noiselessly", "noisemakers",
    "nominations", "nominatives", "nonabrasive", "nonbeliever",
    "nonchalance", "nondescript", "nondrinkers", "nonentities",
    "nonetheless", "nonexistent", "nonpartisan", "nonpayments",
    "nonphysical", "nonplussing", "nonresident", "nonseasonal",
    "nonsensical", "nonspecific", "nonstandard", "nonstarters",
    "nonviolence", "northeaster", "northerlies", "northerners",
    "nothingness", "noticeboard", "notoriously", "nourishment",
    "numerations", "numerically", "numismatics", "numismatist",
    "nutcrackers", "nutritional", "nymphomania", "obfuscating",
    "obfuscation", "objectively", "objectivity", "obligations",
    "obliqueness", "obliterated", "obliterates", "obliviously",
    "obnoxiously", "obscenities", "obscurities", "observances",
    "observantly", "observation", "observatory", "obsessional",
    "obsessively", "obsolescent", "obstetrical", "obstinately",
    "obstructing", "obstruction", "obstructive", "obtrusively",
    "obviousness", "occasioning", "occidentals", "occupations",
    "occurrences", "odoriferous", "offensively", "offertories",
    "offhandedly", "officialdom", "officialese", "officiating",
    "officiously", "oligarchies", "omnipotence", "omnipresent",
    "omniscience", "oncologists", "onerousness", "ontological",
    "opalescence", "operational", "opinionated", "opportunely",
    "opportunism", "opportunist", "opportunity", "oppositions",
    "opprobrious", "optometrist", "orchestrate", "orderliness",
    "ordinariest", "ordinations", "organically", "orientalist",
    "orientating", "orientation", "originality", "originating",
    "origination", "originators", "ornamenting", "ornithology",
    "orthodontia", "orthodontic", "orthodoxies", "orthography",
    "oscillating", "oscillation", "oscillators", "ostentation",
    "outbalanced", "outbalances", "outbreaking", "outbuilding",
    "outbursting", "outclassing", "outcropping", "outdistance",
    "outfielders", "outflanking", "outguessing", "outnumbered",
    "outpatients", "outperforms", "outpointing", "outpourings",
    "outreaching", "outsmarting", "outsourcing", "outspokenly",
    "outstanding", "outstations", "outstripped", "outweighing",
    "overachieve", "overanxious", "overarching", "overbalance",
    "overbearing", "overbidding", "overbooking", "overburdens",
    "overcasting", "overcharged", "overcharges", "overcooking",
    "overcrowded", "overdevelop", "overdrawing", "overdressed",
    "overdresses", "overexcited", "overexcites", "overexposed",
    "overexposes", "overextends", "overflights", "overflowing",
    "overgrowing", "overhanging", "overhauling", "overhearing",
    "overheating", "overindulge", "overkilling", "overlapping",
    "overloading", "overlooking", "overmanning", "overplaying",
    "overpowered", "overpricing", "overprinted", "overproduce",
    "overreached", "overreaches", "overreacted", "overrunning",
    "overselling", "overshadows", "overspreads", "overstaffed",
    "overstating", "overstaying", "overstepped", "overstocked",
    "overstretch", "overstuffed", "overturning", "overvaluing",
    "overweening", "overwhelmed", "overwinters", "overworking",
    "overwriting", "overwritten", "overwrought", "overzealous",
    "oxygenating", "oxygenation", "pacesetters", "pacifically",
    "paediatrics", "painfullest", "painkillers", "painkilling",
    "painstaking", "paleolithic", "palimpsests", "palindromes",
    "palindromic", "pallbearers", "palliatives", "palpitating",
    "palpitation", "pamphleteer", "pandemonium", "panhandlers",
    "panhandling", "pantheistic", "pantomiming", "paperbacked",
    "paperhanger", "paperweight", "paracetamol", "parachuting",
    "parachutist", "paradoxical", "paragliding", "paragraphed",
    "parallelism", "paramedical", "paramountcy", "paraphrased",
    "paraphrases", "paraplegics", "parasitical", "paratrooper",
    "parentheses", "parenthesis", "parenthetic", "parishioner",
    "parliaments", "parochially", "participant", "participate",
    "participial", "participles", "particulars", "particulate",
    "partitioned", "partnership", "parturition", "passageways",
    "passionated", "passionates", "passionless", "passivising",
    "passivizing", "pastureland", "paternalism", "paternalist",
    "pathfinders", "pathologist", "patisseries", "patriarchal",
    "patrimonial", "patrimonies", "patrolwoman", "patrolwomen",
    "patronesses", "patronymics", "pavementing", "pawnbrokers",
    "peacefuller", "peacekeeper", "peacemakers", "peashooters",
    "peculiarity", "pedagogical", "pedagoguing", "pedestrians",
    "peevishness", "pejoratives", "penetrating", "penetration",
    "penetrative", "penitential", "pennyweight", "penologists",
    "pensionable", "pensiveness", "pentagonals", "pentameters",
    "pentathlons", "penthousing", "penultimate", "peppercorns",
    "peppermints", "perambulate", "perceivable", "percentages",
    "percentiles", "perceptible", "perceptibly", "perceptions",
    "percolating", "percolation", "percolators", "perennially",
    "perestroika", "perfectible", "perfections", "perforating",
    "perforation", "performance", "perfumeries", "perfunctory",
    "pericardium", "periodicals", "periodicity", "periodontal",
    "peripatetic", "peripherals", "peripheries", "periphrases",
    "periphrasis", "periscoping", "perishables", "peritoneums",
    "peritonitis", "periwigging", "periwinkles", "permanently",
    "permissible", "permissibly", "permissions", "permutation",
    "perorations", "perpetrated", "perpetrates", "perpetrator",
    "perpetually", "perpetuated", "perpetuates", "perplexedly",
    "perquisites", "persecuting", "persecution", "persecutors",
    "persevering", "persistence", "persnickety", "personality",
    "personified", "personifies", "perspective", "perspicuity",
    "perspicuous", "persuasions", "pertinacity", "pertinently",
    "pervasively", "perversions", "pessimistic", "pestilences",
    "petitioners", "petitioning", "petrodollar", "pettifogged",
    "pettifogger", "pharmacists", "phenomenons", "philandered",
    "philanderer", "philatelist", "philistines", "philologist",
    "philosopher", "philosophic", "phonetician", "phonographs",
    "phonologist", "photocopied", "photocopier", "photocopies",
    "photographs", "photography", "phrasebooks", "phraseology",
    "physicality", "physiognomy", "pianissimos", "pianofortes",
    "picaresques", "pickpockets", "pictographs", "pictorially",
    "picturesque", "pigeonholed", "pigeonholes", "piggishness",
    "piggybacked", "pigheadedly", "pilgrimages", "pillowcases",
    "pillowslips", "pilothouses", "pincushions", "pinfeathers",
    "pinpointing", "pinpricking", "pinwheeling", "pirouetting",
    "piscatorial", "pitchblende", "pitchforked", "pitifullest",
    "pituitaries", "placeholder", "plagiarisms", "plagiarists",
    "plainspoken", "plaintively", "planetarium", "plantations",
    "platforming", "playfulness", "playgrounds", "playschools",
    "playwrights", "pleasantest", "pleasurable", "pleasurably",
    "plebiscites", "plentifully", "pluperfects", "pluralistic",
    "pluralities", "plutocratic", "pocketbooks", "pocketknife",
    "pockmarking", "podiatrists", "poinsettias", "pointillism",
    "pointillist", "pointlessly", "poisonously", "polemicists",
    "policewoman", "policewomen", "policymaker", "politically",
    "politicians", "politicking", "pollinating", "pollination",
    "poltergeist", "polyandrous", "polygamists", "polygraphed",
    "polyhedrons", "polymorphic", "polynomials", "polystyrene",
    "polytechnic", "polytheists", "pomegranate", "pompadoured",
    "pompousness", "ponderously", "pontificate", "populations",
    "pornography", "portability", "porterhouse", "portmanteau",
    "portraitist", "portraiture", "positioning", "positivists",
    "possessions", "possessives", "possibility", "postmarking",
    "postmasters", "postmortems", "postscripts", "postulating",
    "potentially", "powerhouses", "powerlessly", "practicable",
    "practicably", "practically", "pragmatists", "prearranged",
    "prearranges", "precautions", "precipitant", "precipitate",
    "precipitous", "preciseness", "preconceive", "predeceased",
    "predeceases", "predecessor", "predestined", "predestines",
    "predicament", "predicating", "predication", "predicative",
    "predictable", "predictably", "predictions", "predigested",
    "predisposed", "predisposes", "predominant", "predominate",
    "preeminence", "preexisting", "prefectures", "preferences",
    "prefiguring", "pregnancies", "prehistoric", "prejudicial",
    "prejudicing", "preliminary", "preliterate", "prematurely",
    "premeditate", "premiership", "premonition", "premonitory",
    "preoccupied", "preoccupies", "preordained", "prepackaged",
    "prepackages", "preparation", "preparatory", "prepayments",
    "preposition", "prerecorded", "preregister", "prerogative",
    "preschooler", "prescribing", "presentable", "prestigious",
    "presumption", "presumptive", "presupposed", "presupposes",
    "pretentious", "prettifying", "prevaricate", "preventable",
    "preventives", "priestesses", "priesthoods", "priestliest",
    "primitively", "primordials", "princeliest", "principally",
    "principling", "printmaking", "privileging", "prizefights",
    "proactively", "probability", "probationer", "problematic",
    "proboscises", "proceedings", "processions", "proclaiming",
    "procreating", "procreation", "procreative", "procurators",
    "procurement", "prodigality", "productions", "profanation",
    "profanities", "professions", "proficiency", "proficients",
    "profiteered", "profiterole", "profligates", "profoundest",
    "progenitors", "prognostics", "programmers", "progressing",
    "progression", "progressive", "prohibiting", "prohibition",
    "prohibitive", "prohibitory", "projectiles", "projections",
    "proletarian", "proletariat", "proliferate", "promenading",
    "prominently", "promiscuity", "promiscuous", "promisingly",
    "promotional", "promulgated", "promulgates", "pronouncing",
    "proofreader", "propagating", "propagation", "propagators",
    "propellants", "prophesying", "prophylaxis", "propinquity",
    "propitiated", "propitiates", "proportions", "proposition",
    "propounding", "proprietary", "proprieties", "proprietors",
    "prosaically", "prosceniums", "proscribing", "prosecuting",
    "prosecution", "prosecutors", "proselyting", "prospecting",
    "prospective", "prospectors", "prosthetics", "prostituted",
    "prostitutes", "prostrating", "prostration", "protagonist",
    "protections", "protectives", "protestants", "prototyping",
    "protracting", "protraction", "protractors", "protrusions",
    "protuberant", "provenances", "provendered", "providently",
    "provincials", "provisional", "provisioned", "provocateur",
    "provocation", "provocative", "prudentials", "prudishness",
    "psychedelia", "psychedelic", "psychiatric", "psychically",
    "psychodrama", "psychogenic", "psychopaths", "pterodactyl",
    "publication", "publishable", "pulchritude", "punctilious",
    "punctuality", "punctuating", "punctuation", "punishingly",
    "punishments", "purchasable", "purgatorial", "purgatories",
    "puritanical", "purportedly", "purposeless", "pussyfooted",
    "putrescence", "pyromaniacs", "pyrotechnic", "quadrangles",
    "quadrennial", "quadrilling", "quadruplets", "quadrupling",
    "qualitative", "quantifiers", "quantifying", "quarantined",
    "quarantines", "quarrelsome", "quarterback", "quarterdeck",
    "quarterlies", "querulously", "questioners", "questioning",
    "quicksilver", "quintuplets", "quintupling", "quizzically",
    "racecourses", "racketeered", "racquetball", "radioactive",
    "radiocarbon", "radiography", "radiologist", "raffishness",
    "ragamuffins", "railroading", "rancorously", "rangefinder",
    "rapaciously", "rapporteurs", "rapscallion", "rapturously",
    "raspberries", "ratatouille", "rathskeller", "rationalism",
    "rationalist", "rationality", "rattlesnake", "rattletraps",
    "raucousness", "raunchiness", "ravishingly", "reactionary",
    "reactivated", "reactivates", "readability", "readdressed",
    "readdresses", "readerships", "readjusting", "readmitting",
    "reaffirming", "realignment", "reallocated", "reallocates",
    "realpolitik", "reanimating", "reappearing", "reappointed",
    "reapportion", "reappraisal", "reappraised", "reappraises",
    "rearranging", "reassembled", "reassembles", "reasserting",
    "reassessing", "reassigning", "reassurance", "reawakening",
    "rebroadcast", "recantation", "recapturing", "receivables",
    "receptacles", "receptively", "receptivity", "recessional",
    "recidivists", "reciprocals", "reciprocate", "reciprocity",
    "recitations", "recitatives", "reclamation", "recognition",
    "recollected", "recombining", "recommenced", "recommences",
    "recommended", "recompensed", "recompenses", "recompiling",
    "reconciling", "recondition", "reconfigure", "reconnected",
    "reconquered", "reconsiders", "reconstruct", "reconvening",
    "recoverable", "recreations", "recriminate", "recruitment",
    "rectangular", "rectifiable", "rectilinear", "recuperated",
    "recuperates", "recurrences", "recursively", "recyclables",
    "redcurrants", "redecorated", "redecorates", "rededicated",
    "rededicates", "redeploying", "redesigning", "redeveloped",
    "redirecting", "redirection", "rediscovers", "rediscovery",
    "redistricts", "redoubtable", "redundantly", "reeducating",
    "reeducation", "reelections", "reenactment", "reenlisting",
    "reestablish", "reevaluated", "reevaluates", "reexamining",
    "refashioned", "refectories", "referencing", "referendums",
    "referential", "refinancing", "refinements", "refinishing",
    "reflections", "reflexively", "reflexology", "reforesting",
    "reformation", "reformatory", "reformatted", "reformulate",
    "refreshment", "refrigerant", "refrigerate", "refurbished",
    "refurbishes", "refurnished", "refurnishes", "refutations",
    "regenerated", "regenerates", "regimentals", "regimenting",
    "regionalism", "registering", "registrants", "regressions",
    "regretfully", "regrettable", "regrettably", "regulations",
    "regurgitate", "reimbursing", "reincarnate", "reinforcing",
    "reinserting", "reinstating", "reinsurance", "reinterpret",
    "reinventing", "reinvesting", "reiterating", "reiteration",
    "rejiggering", "rejuvenated", "rejuvenates", "relatedness",
    "relativists", "relaunching", "relaxations", "reliability",
    "religiosity", "religiously", "reliquaries", "relocatable",
    "reluctantly", "remaindered", "remarriages", "remastering",
    "remembering", "remembrance", "reminiscent", "reminiscing",
    "remittances", "remonstrate", "remorseless", "remortgaged",
    "remortgages", "remunerated", "remunerates", "renaissance",
    "renascences", "renditioned", "renegotiate", "renovations",
    "renumbering", "reoccupying", "reoccurring", "repackaging",
    "reparations", "reparteeing", "repatriated", "repatriates",
    "repertoires", "repertories", "repetitions", "repetitious",
    "replaceable", "replacement", "replenished", "replenishes",
    "replicating", "replication", "repossessed", "repossesses",
    "reprehended", "represented", "repressions", "reprimanded",
    "reproachful", "reproaching", "reprocessed", "reprocesses",
    "reproducing", "reprovingly", "republicans", "republished",
    "republishes", "repudiating", "repudiation", "repulsively",
    "reputations", "requirement", "requisition", "rescheduled",
    "reschedules", "researchers", "researching", "resemblance",
    "resentfully", "resentments", "reservation", "reshuffling",
    "residencies", "residential", "resignation", "resiliently",
    "resistances", "resolutions", "resourceful", "respectable",
    "respectably", "respiration", "respirators", "respiratory",
    "resplendent", "respondents", "responsible", "responsibly",
    "restatement", "restaurants", "restfullest", "restfulness",
    "restitution", "restiveness", "restoration", "restorative",
    "restraining", "restricting", "restriction", "restrictive",
    "restructure", "resubmitted", "resumptions", "resupplying",
    "resurfacing", "resurgences", "resurrected", "resuscitate",
    "retaliating", "retaliation", "retaliatory", "retardation",
    "reticulated", "retirements", "retractable", "retractions",
    "retrenching", "retribution", "retributive", "retrievable",
    "retroactive", "retrofitted", "retrograded", "retrogrades",
    "retrorocket", "retrospects", "returnables", "reupholster",
    "revaluation", "revealingly", "revelations", "reverberate",
    "reverencing", "reverential", "revisionism", "revisionist",
    "revivalists", "revivifying", "revocations", "revoltingly",
    "revolutions", "rhetorician", "rhinestones", "ricocheting",
    "righteously", "ringleaders", "ringmasters", "riotousness",
    "ritualistic", "riverfronts", "roadblocked", "roadrunners",
    "roguishness", "romanticism", "romanticist", "rotisseries",
    "rotogravure", "rottweilers", "roughhoused", "roughhouses",
    "roughnecked", "roundabouts", "roundhouses", "roustabouts",
    "rubbernecks", "rudimentary", "rumbustious", "ruminations",
    "rustproofed", "sabbaticals", "sacramental", "sacramented",
    "sacrificial", "sacrificing", "safeguarded", "safekeeping",
    "sagaciously", "sailboarded", "saintliness", "salaciously",
    "salamanders", "salesclerks", "salespeople", "salesperson",
    "salmonellae", "saltcellars", "saltshakers", "salutations",
    "salvageable", "sanatoriums", "sanctifying", "sanctioning",
    "sanctuaries", "sandbagging", "sandblasted", "sandblaster",
    "sandcastles", "sandpapered", "sandwiching", "sanitariums",
    "saprophytes", "sarcophagus", "sartorially", "sassafrases",
    "satanically", "satelliting", "satirically", "saxophonist",
    "scaffolding", "scapegoated", "scaremonger", "scatterings",
    "sceptically", "schismatics", "schlockiest", "schmaltzier",
    "scholarship", "schoolbooks", "schoolchild", "schoolgirls",
    "schoolhouse", "schoolmarms", "schoolmates", "schoolrooms",
    "schoolyards", "scintillate", "scoreboards", "scorekeeper",
    "scoutmaster", "scraggliest", "scratchcard", "scratchiest",
    "scratchpads", "screamingly", "screechiest", "screenplays",
    "screwdriver", "scrimmaging", "scrimshawed", "scruffiness",
    "scrumhalves", "scrumptious", "scrutineers", "sculpturing",
    "scuttlebutt", "searchingly", "searchlight", "seasickness",
    "seasonality", "seaworthier", "secondaries", "secondarily",
    "secondments", "secretarial", "secretariat", "secretaries",
    "secretively", "secularists", "sedimentary", "seductively",
    "segregating", "segregation", "seismically", "seismograph",
    "selectively", "selectivity", "selfishness", "sellotaping",
    "semaphoring", "semicircles", "semimonthly", "seminarians",
    "semiprivate", "semiquavers", "semiskilled", "semitrailer",
    "sensational", "senselessly", "sensibility", "sensitively",
    "sensitivity", "sententious", "sentimental", "separations",
    "separatists", "sequestered", "sequestrate", "serendipity",
    "seriousness", "serviceable", "settlements", "seventeenth",
    "seventieths", "sexologists", "shadowboxed", "shadowboxes",
    "shallowness", "shamanistic", "shamelessly", "shanghaiing",
    "shantytowns", "shapelessly", "shapeliness", "shareholder",
    "shellacking", "shellfishes", "shenanigans", "shepherdess",
    "shepherding", "shibboleths", "shillelaghs", "shipbuilder",
    "shipwrecked", "shipwrights", "shirtsleeve", "shirtwaists",
    "shoehorning", "shoestrings", "shopaholics", "shopfitters",
    "shopfitting", "shopkeepers", "shoplifters", "shoplifting",
    "shortchange", "shortcoming", "shortenings", "shorthanded",
    "shortlisted", "shotgunning", "shouldering", "showboating",
    "showerproof", "showgrounds", "showjumping", "showmanship",
    "showstopper", "shrubberies", "shutterbugs", "shuttlecock",
    "sickeningly", "sidesaddles", "sidestepped", "sidestroked",
    "sidestrokes", "sideswiping", "sidetracked", "sightseeing",
    "signatories", "significant", "signposting", "silhouetted",
    "silhouettes", "silversmith", "simperingly", "simplifying",
    "simulacrums", "simulations", "simulcasted", "singsonging",
    "singularity", "sisterhoods", "skateboards", "skedaddling",
    "skeptically", "sketchbooks", "skirmishers", "skirmishing",
    "skulduggery", "skyrocketed", "skyscrapers", "slaphappier",
    "slaughtered", "slaughterer", "sleazeballs", "sleeplessly",
    "sleepwalked", "sleepwalker", "sleepyheads", "slenderness",
    "slipperiest", "slipstreams", "slovenliest", "slowcoaches",
    "smallholder", "smatterings", "smithereens", "smokehouses",
    "smokescreen", "smokestacks", "snapdragons", "snowballing",
    "snowboarded", "snowboarder", "snowmobiled", "snowmobiles",
    "snowploughs", "snowplowing", "snowshoeing", "sociability",
    "socialistic", "sociologist", "softhearted", "solemnities",
    "solidifying", "soliloquies", "solipsistic", "somersaults",
    "songwriters", "songwriting", "soothsayers", "sophistries",
    "sorceresses", "sorrowfully", "soulfulness", "soundlessly",
    "soundproofs", "soundtracks", "sousaphones", "southerlies",
    "southerners", "southwester", "sovereignty", "spacecrafts",
    "spaceflight", "spacewalked", "spanielling", "sparrowhawk",
    "speakeasies", "spearheaded", "specialisms", "specialists",
    "specifiable", "specificity", "spectacular", "speculating",
    "speculation", "speculative", "speculators", "speechified",
    "speechifies", "speedometer", "spellbinder", "spendthrift",
    "spermatozoa", "spermicidal", "spermicides", "spinelessly",
    "spiritually", "spitefuller", "splashdowns", "splattering",
    "splendidest", "splintering", "splotchiest", "spluttering",
    "spoilsports", "spokeswoman", "spokeswomen", "sponsorship",
    "spontaneity", "spontaneous", "spoonerisms", "sportscasts",
    "sportswoman", "sportswomen", "spotlighted", "spreadsheet",
    "sprightlier", "springboard", "springiness", "sprinklings",
    "squandering", "squattering", "squeamishly", "squeegeeing",
    "squiggliest", "stablemates", "stagestruck", "stagflation",
    "staggerings", "stakeholder", "stalactites", "stalagmites",
    "stalemating", "stallholder", "standoffish", "standpoints",
    "standstills", "startlingly", "statehouses", "stateliness",
    "statemented", "stateswoman", "stateswomen", "statistical",
    "statutorily", "staunchness", "steadfastly", "steakhouses",
    "stealthiest", "steamrolled", "steamroller", "steelmakers",
    "steelworker", "steeplejack", "stenography", "stepbrother",
    "stepfathers", "stepladders", "stepmothers", "stepparents",
    "stepsisters", "stereoscope", "stereotyped", "stereotypes",
    "stethoscope", "stewardship", "stickleback", "stillbirths",
    "stimulating", "stimulation", "stimulative", "stipendiary",
    "stipulating", "stipulation", "stockbroker", "stockholder",
    "stockpiling", "stocktaking", "stomachache", "stonemasons",
    "stonewalled", "stonewashed", "stopwatches", "storefronts",
    "storehouses", "storekeeper", "storyboards", "storyteller",
    "straggliest", "straightens", "straightest", "straighting",
    "straitening", "straitlaced", "strangeness", "strangering",
    "strangulate", "straplesses", "strategical", "strategists",
    "stratifying", "streamlined", "streamlines", "streetlamps",
    "streetlight", "strengthens", "strenuously", "stretchered",
    "stretchiest", "strikebound", "stringently", "stripteased",
    "stripteases", "strongboxes", "strongholds", "strongrooms",
    "stroppiness", "structuring", "strumpeting", "stubbornest",
    "stubborning", "studentship", "stultifying", "stupidities",
    "stylishness", "subbasement", "subcompacts", "subcontract",
    "subcultures", "subdividing", "subdivision", "subheadings",
    "subjectives", "subjugating", "subjugation", "subjunctive",
    "sublimating", "sublimation", "submariners", "submergence",
    "submersible", "submissions", "subordinate", "subornation",
    "subpoenaing", "subprograms", "subroutines", "subscribers",
    "subscribing", "subsections", "subsequents", "subservient",
    "subsistence", "substandard", "substantial", "substantive",
    "substations", "substituted", "substitutes", "subterfuges",
    "subtracting", "subtraction", "subtrahends", "subtropical",
    "suburbanite", "subventions", "subversives", "successions",
    "succinctest", "sufficiency", "suffocating", "suffocation",
    "suffragette", "suffragists", "sugarcoated", "suggestible",
    "suggestions", "suitability", "summerhouse", "sumptuously",
    "supercharge", "superficial", "superfluity", "superfluous",
    "superheroes", "superimpose", "superintend", "superiority",
    "superlative", "supermarket", "supermodels", "superpowers",
    "superscript", "superseding", "supersonics", "superstates",
    "superstores", "supertanker", "supervening", "supervising",
    "supervision", "supervisors", "supervisory", "supplanting",
    "supplements", "supplicants", "supplicated", "supplicates",
    "supportable", "supposition", "suppository", "suppressant",
    "suppressing", "suppression", "suppressors", "suppurating",
    "suppuration", "supremacist", "surcharging", "surfboarded",
    "surmounting", "surplussing", "surprisings", "surrealists",
    "surrendered", "surrounding", "susceptible", "suspenseful",
    "suspensions", "sustainable", "swallowtail", "sweatshirts",
    "sweepstakes", "sweetbreads", "sweetbriers", "sweethearts",
    "swellheaded", "swelterings", "switchbacks", "switchblade",
    "switchboard", "swordfishes", "sycophantic", "syllabified",
    "syllabifies", "syllogistic", "symmetrical", "sympathetic",
    "symptomatic", "synchronous", "syncopating", "syncopation",
    "syndicalism", "syndicalist", "syndicating", "syndication",
    "synergistic", "syntactical", "syphilitics", "systematics",
    "tabernacles", "tablecloths", "tablespoons", "tabulations",
    "tachographs", "tachometers", "taciturnity", "tagliatelle",
    "tambourines", "tangibility", "taskmasters", "tastelessly",
    "tattletales", "tautologies", "taxidermist", "teargassing",
    "tearjerkers", "teaspoonful", "technically", "technicians",
    "technocracy", "technocrats", "technophobe", "tediousness",
    "teenybopper", "teetotalism", "telecasters", "telecasting",
    "telecommute", "telegraphed", "telegrapher", "telegraphic",
    "telekinesis", "telemetries", "telephoning", "telephonist",
    "teleprinter", "telescoping", "televisions", "teleworkers",
    "teleworking", "temperament", "temperating", "temperature",
    "tempestuous", "temporaries", "temporarily", "temptations",
    "temptresses", "tenaciously", "tendentious", "tenderfoots",
    "tenderloins", "tentatively", "tenuousness", "terminating",
    "termination", "terminators", "terminology", "terrestrial",
    "territorial", "territories", "tessellated", "tessellates",
    "testimonial", "testimonies", "tetrahedron", "thalidomide",
    "thankfuller", "thanklessly", "theatricals", "thenceforth",
    "theocracies", "theodolites", "theologians", "theological",
    "theoretical", "therapeutic", "thereabouts", "thermometer",
    "thermostats", "thesauruses", "thickenings", "thicknesses",
    "thimblefuls", "thingamabob", "thingamajig", "thingumabob",
    "thingummies", "thirteenths", "thistledown", "thoroughest",
    "thoughtless", "thousandths", "threatening", "threescores",
    "thriftiness", "thrillingly", "throatiness", "thumbprints",
    "thumbscrews", "thunderbolt", "thunderclap", "thunderhead",
    "tiddlywinks", "tiebreakers", "tightfisted", "timberlines",
    "timekeepers", "timekeeping", "timeservers", "timeserving",
    "timetabling", "tinderboxes", "titillating", "titillation",
    "toastmaster", "tobacconist", "tobogganing", "tomahawking",
    "tonsillitis", "toothpastes", "topographer", "topographic",
    "topological", "touchpapers", "touchstones", "tournaments",
    "tourniquets", "townspeople", "tracheotomy", "trademarked",
    "traditional", "traffickers", "trafficking", "tragicomedy",
    "trailblazer", "trampolined", "trampolines", "tranquilest",
    "transacting", "transaction", "transceiver", "transcended",
    "transcribed", "transcribes", "transcripts", "transducers",
    "transferals", "transferred", "transfigure", "transfinite",
    "transfixing", "transformed", "transformer", "transfusing",
    "transfusion", "transistors", "transitions", "transitives",
    "translating", "translation", "translators", "translucent",
    "transmittal", "transmitted", "transmitter", "transmuting",
    "transparent", "transpiring", "transplants", "transponder",
    "transported", "transporter", "transposing", "transsexual",
    "transversed", "transverses", "trapezoidal", "travelogues",
    "travestying", "treacheries", "treacherous", "treasonable",
    "tremulously", "trenchantly", "trendsetter", "trepidation",
    "trespassers", "trespassing", "triathletes", "tribeswoman",
    "tribeswomen", "tribulation", "tributaries", "triceratops",
    "trilaterals", "trillionths", "triplicated", "triplicates",
    "triumvirate", "troglodytes", "trombonists", "troposphere",
    "troubadours", "troubleshot", "troublesome", "truculently",
    "trusteeship", "trustworthy", "tuberculous", "tumbleweeds",
    "tunefulness", "turbocharge", "turbulently", "turnarounds",
    "turtledoves", "turtlenecks", "typecasting", "typescripts",
    "typesetters", "typesetting", "typewriters", "typewriting",
    "typewritten", "typographer", "typographic", "tyrannosaur",
    "ultramarine", "ultrasonics", "ultrasounds", "ultraviolet",
    "umbrellaing", "unabridgeds", "unalterable", "unalterably",
    "unambiguous", "unambitious", "unanimously", "unannounced",
    "unappealing", "unashamedly", "unavailable", "unavoidable",
    "unavoidably", "unawareness", "unbalancing", "unbelievers",
    "unbelieving", "unblemished", "unbreakable", "unburdening",
    "unbuttoning", "unceasingly", "uncertainly", "uncertainty",
    "unchristian", "uncleanlier", "uncleanness", "uncluttered",
    "uncollected", "uncommitted", "uncommonest", "uncompleted",
    "unconcerned", "unconfirmed", "uncongenial", "unconnected",
    "unconscious", "uncontested", "unconvinced", "uncountable",
    "uncrushable", "undeceiving", "undecidable", "undefinable",
    "undelivered", "undemanding", "underacting", "underarming",
    "undercharge", "undercoated", "underexpose", "underfunded",
    "underground", "undergrowth", "underhanded", "underlining",
    "undermanned", "undermining", "underneaths", "underpasses",
    "underpaying", "underpinned", "underplayed", "underrating",
    "underscored", "underscores", "undershirts", "undershoots",
    "undershorts", "undersigned", "underskirts", "understands",
    "understated", "understates", "undertakers", "undertaking",
    "undervalued", "undervalues", "underweight", "underwhelms",
    "underworlds", "underwriter", "underwrites", "undeserving",
    "undesirable", "undeveloped", "undignified", "undisclosed",
    "undisguised", "undisturbed", "undoubtedly", "undulations",
    "unemotional", "unendurable", "unequivocal", "unethically",
    "unexplained", "unfailingly", "unfaltering", "unfastening",
    "unfeelingly", "unfettering", "unflappable", "unflinching",
    "unforgiving", "unfortunate", "unfulfilled", "unfurnished",
    "ungainliest", "unhappiness", "unhealthful", "unhealthier",
    "unhealthily", "unhelpfully", "unhurriedly", "unification",
    "unimportant", "unimpressed", "uninhabited", "uninhibited",
    "uninitiated", "uninspiring", "universally", "unjustified",
    "unkindliest", "unknowingly", "unlikeliest", "unmemorable",
    "unmitigated", "unnaturally", "unnecessary", "unnervingly",
    "unobservant", "unobtrusive", "unoffensive", "unpalatable",
    "unpatriotic", "unperturbed", "unprintable", "unpromising",
    "unprotected", "unpublished", "unqualified", "unreachable",
    "unrealistic", "unreasoning", "unregulated", "unrehearsed",
    "unrelenting", "unremitting", "unrepentant", "unrewarding",
    "unsatisfied", "unsaturated", "unscheduled", "unscrambled",
    "unscrambles", "unseemliest", "unselfishly", "unsheathing",
    "unsightlier", "unsolicited", "unspeakable", "unspeakably",
    "unspecified", "unsteadiest", "unstoppable", "unsupported",
    "unsurpassed", "unsuspected", "unsweetened", "unthinkable",
    "untimeliest", "untouchable", "untypically", "unutterable",
    "unutterably", "unvarnished", "unwarranted", "unwelcoming",
    "unwholesome", "unwieldiest", "unwillingly", "unwittingly",
    "unworthiest", "upbringings", "upholstered", "upholsterer",
    "uprightness", "upstreaming", "uselessness", "utilitarian",
    "vacationers", "vacationing", "vaccinating", "vaccination",
    "vacillating", "vacillation", "vacuousness", "vagabonding",
    "valedictory", "validations", "vanquishing", "variability",
    "variegating", "variegation", "vasectomies", "vegeburgers",
    "vegetarians", "ventilating", "ventilation", "ventilators",
    "ventricular", "venturesome", "verdigrised", "verdigrises",
    "vernaculars", "versatility", "vertebrates", "vertiginous",
    "vestigially", "vexatiously", "vibraphones", "vicariously",
    "vichyssoise", "viciousness", "vicissitude", "videophones",
    "videotaping", "viewfinders", "vigilantism", "vinaigrette",
    "vindicating", "vindication", "vindicators", "violincello",
    "violoncello", "viscountess", "visionaries", "visitations",
    "viticulture", "vituperated", "vituperates", "vivaciously",
    "vivisection", "vociferated", "vociferates", "volleyballs",
    "voluntaries", "voluntarily", "volunteered", "voraciously",
    "vouchsafing", "voyeuristic", "vulgarities", "wainscoting",
    "waistcoated", "wakefulness", "wallflowers", "wallpapered",
    "wanderlusts", "warehousing", "warmhearted", "warrantying",
    "washerwoman", "washerwomen", "wastebasket", "watchmakers",
    "watchstraps", "watchtowers", "watercourse", "waterfronts",
    "waterlogged", "watermarked", "watermelons", "waterproofs",
    "waterspouts", "waterwheels", "wavelengths", "waywardness",
    "wealthiness", "weathercock", "weedkillers", "weighbridge",
    "weightiness", "wellingtons", "wellsprings", "westernmost",
    "wheelbarrow", "wheelchairs", "wheelhouses", "wheelwright",
    "whereabouts", "wheresoever", "wherewithal", "whimsically",
    "whirlybirds", "whiteboards", "whitefishes", "whitewashed",
    "whitewashes", "wholesalers", "wholesaling", "whorehouses",
    "wildcatters", "wildcatting", "wildebeests", "wildflowers",
    "willfulness", "willingness", "windbreaker", "windburning",
    "windcheater", "windjammers", "windmilling", "windowpanes",
    "windowsills", "windscreens", "windshields", "windsurfers",
    "windsurfing", "wineglasses", "wingspreads", "wintergreen",
    "wiretapping", "wisecracked", "wistfulness", "withdrawals",
    "withdrawing", "witheringly", "withholding", "womanliness",
    "wonderfully", "wonderingly", "wonderlands", "woodcarving",
    "woodcutters", "woodcutting", "woodpeckers", "woodworking",
    "workaholics", "workbaskets", "workbenches", "workmanlike",
    "workmanship", "workstation", "worldliness", "wraparounds",
    "wretchedest", "wrongdoings", "wrongheaded", "wunderkinds",
    "xerographic", "xylophonist", "yachtswoman", "yachtswomen",
    "zealousness"
  };

  const char* w_12[] = {
    "abbreviating", "abbreviation", "abolitionist", "abominations",
    "abortionists", "abrasiveness", "abstractedly", "abstractions",
    "abstractness", "abstruseness", "academically", "academicians",
    "accelerating", "acceleration", "accelerators", "accentuating",
    "accentuation", "accessioning", "accidentally", "acclimatised",
    "acclimatises", "acclimatized", "acclimatizes", "accommodated",
    "accommodates", "accompanists", "accompanying", "accomplished",
    "accomplishes", "accumulating", "accumulation", "accumulative",
    "accumulators", "accurateness", "achievements", "acknowledged",
    "acknowledges", "acoustically", "acquaintance", "acquiescence",
    "acquisitions", "adaptability", "additionally", "adjectivally",
    "adjournments", "adjudicating", "adjudication", "adjudicators",
    "administered", "administrate", "admonishment", "adolescences",
    "adulterating", "adulteration", "adulteresses", "advancements",
    "advantageous", "adventitious", "adventurists", "advertorials",
    "advisability", "aerodynamics", "aeronautical", "affectations",
    "affectionate", "affectioning", "affiliations", "affirmations",
    "affirmatives", "aforethought", "afterburners", "aftereffects",
    "afterthought", "agglomerated", "agglomerates", "agglutinated",
    "agglutinates", "aggravations", "aggregations", "aggressively",
    "agoraphobics", "agribusiness", "agricultural", "airworthiest",
    "alliteration", "alliterative", "alphabetical", "alphanumeric",
    "altercations", "alternations", "alternatives", "amalgamating",
    "amalgamation", "amateurishly", "ambidextrous", "ambivalently",
    "ambulanceman", "ambulancemen", "ambulatories", "ameliorating",
    "amelioration", "amphetamines", "anachronisms", "analytically",
    "anarchically", "anatomically", "ancestresses", "anchorpeople",
    "anchorperson", "angularities", "annihilating", "annihilation",
    "annihilators", "announcement", "answerphones", "antagonistic",
    "antechambers", "antediluvian", "anthologists", "anthropology",
    "antiabortion", "antiaircraft", "anticipating", "anticipation",
    "anticipatory", "anticlimaxes", "anticyclones", "antimacassar",
    "antiparticle", "antipathetic", "antiquarians", "antirrhinums",
    "antithetical", "aphrodisiacs", "apothecaries", "apparatchiks",
    "appeasements", "appellations", "appendectomy", "appendicitis",
    "appertaining", "applications", "appointments", "apportioning",
    "appositeness", "appreciating", "appreciation", "appreciative",
    "apprehending", "apprehension", "apprehensive", "apprenticing",
    "approachable", "approbations", "appropriated", "appropriates",
    "approximated", "approximates", "appurtenance", "arbitrageurs",
    "archdioceses", "archipelagos", "architecture", "aristocratic",
    "arithmetical", "aromatherapy", "arraignments", "arrangements",
    "articulately", "articulating", "articulation", "artificially",
    "artistically", "ascertaining", "asphyxiating", "asphyxiation",
    "assassinated", "assassinates", "asseverating", "assignations",
    "assimilating", "assimilation", "associations", "astigmatisms",
    "astonishment", "astoundingly", "astrological", "astronautics",
    "astronomical", "astrophysics", "asymmetrical", "asymptomatic",
    "asynchronous", "athletically", "atmospherics", "attestations",
    "attractively", "attributable", "attributions", "attributives",
    "augmentation", "auspiciously", "authenticate", "authenticity",
    "autographing", "automobiling", "autonomously", "availability",
    "avariciously", "bacchanalian", "backbenchers", "backbreaking",
    "backslappers", "backslapping", "backstabbing", "backstopping",
    "backstroking", "backtracking", "backwardness", "backwoodsman",
    "backwoodsmen", "bacteriology", "bankruptcies", "bantamweight",
    "baptisteries", "barbiturates", "barnstorming", "battlefields",
    "battleground", "beachcombers", "beatifically", "beautifulest",
    "begrudgingly", "beleaguering", "belligerence", "belligerency",
    "belligerents", "bellybuttons", "benedictions", "benefactions",
    "benefactress", "beneficently", "beneficially", "benevolences",
    "benevolently", "bereavements", "beseechingly", "bespectacled",
    "bewilderment", "bibliography", "bibliophiles", "bicentennial",
    "bifurcations", "billionaires", "biochemicals", "biochemistry",
    "biodegrading", "biodiversity", "biographical", "biologically",
    "biophysicist", "birdwatchers", "bittersweets", "blabbermouth",
    "blackballing", "blackberries", "blackcurrant", "blackjacking",
    "blacklisting", "blackmailers", "blackmailing", "blacktopping",
    "blandishment", "blindfolding", "blissfulness", "blockbusters",
    "blockbusting", "bloodletting", "bloodmobiles", "bloodstained",
    "bloodstreams", "bloodsuckers", "bloodthirsty", "blueprinting",
    "bluestocking", "boastfulness", "bodybuilding", "boisterously",
    "bombardments", "boomeranging", "boondoggling", "brainstormed",
    "brainteasers", "brainwashing", "breadbaskets", "breadwinners",
    "breakfasting", "breakthrough", "breastplates", "breaststroke",
    "breathalyser", "breathalyzer", "breathlessly", "breathtaking",
    "brilliantine", "brinkmanship", "broadcasters", "broadcasting",
    "brontosaurus", "brotherhoods", "brushstrokes", "buccaneering",
    "bulletproofs", "bullfighters", "bullfighting", "bullshitters",
    "bullshitting", "bureaucratic", "bushwhackers", "bushwhacking",
    "businesslike", "butterflying", "butterscotch", "buttonholing",
    "cabinetmaker", "cablecasting", "calamitously", "calculations",
    "calibrations", "calisthenics", "calligrapher", "calumniating",
    "camiknickers", "camouflaging", "cancellation", "candidatures",
    "candlesticks", "cannonballed", "cantankerous", "cantilevered",
    "capabilities", "caparisoning", "capitalistic", "capitulating",
    "capitulation", "capriciously", "carbohydrate", "carburettors",
    "carcinogenic", "cardiologist", "carelessness", "caricaturing",
    "caricaturist", "carillonning", "carpentering", "carpetbagged",
    "carpetbagger", "carriageways", "cartographer", "cartwheeling",
    "catastrophes", "catastrophic", "catchphrases", "caterpillars",
    "caterwauling", "cauliflowers", "cautiousness", "celebrations",
    "censoriously", "centenarians", "centrifuging", "ceremonially",
    "certificated", "certificates", "chairmanship", "chairpersons",
    "chamberlains", "chambermaids", "championship", "chanticleers",
    "chaplaincies", "characterful", "charbroiling", "charioteered",
    "charismatics", "chastisement", "chatterboxes", "chauffeuring",
    "chauvinistic", "cheerfullest", "cheerfulness", "cheerleaders",
    "cheeseboards", "cheeseburger", "cheeseparing", "chemotherapy",
    "chickenshits", "childbearing", "childishness", "childminders",
    "childminding", "childproofed", "chiropodists", "chiropractic",
    "chiropractor", "chitchatting", "chitterlings", "chivalrously",
    "chlorinating", "chlorination", "chloroformed", "choirmasters",
    "choreographs", "choreography", "christenings", "chronographs",
    "chronologies", "chronometers", "churchwarden", "churlishness",
    "circuitously", "circulations", "circumcising", "circumcision",
    "circumflexes", "circumscribe", "circumstance", "circumvented",
    "clairvoyance", "clairvoyants", "clapboarding", "clapperboard",
    "clarinetists", "classifiable", "clerestories", "cliffhangers",
    "cliffhanging", "closemouthed", "clotheslined", "clotheslines",
    "clownishness", "cobblestones", "cockfighting", "cockleshells",
    "codependency", "codependents", "codification", "coefficients",
    "coffeehouses", "cohabitation", "cohesiveness", "coincidences",
    "coincidental", "collaborated", "collaborates", "collaborator",
    "collectibles", "collectively", "collectivism", "collectivist",
    "collocations", "colloquially", "colonialists", "combinations",
    "combustibles", "comeuppances", "comfortingly", "commandeered",
    "commandments", "commemorated", "commemorates", "commencement",
    "commendation", "commensurate", "commentaries", "commentating",
    "commentators", "commercially", "commiserated", "commiserates",
    "commissariat", "commissaries", "commissioned", "commissioner",
    "commonplaces", "commonwealth", "communicable", "communicants",
    "communicated", "communicates", "communicator", "commutations",
    "companionway", "comparatives", "compartments", "compellingly",
    "compensating", "compensation", "compensatory", "competencies",
    "competitions", "compilations", "complacently", "complainants",
    "complaisance", "complemented", "completeness", "complexioned",
    "complexities", "complicating", "complication", "complimented",
    "compositions", "comprehended", "compressible", "compromising",
    "comptrollers", "compulsively", "compulsories", "compulsorily",
    "compunctions", "computations", "concatenated", "concatenates",
    "concentrated", "concentrates", "conceptually", "concertgoers",
    "concertinaed", "conciliating", "conciliation", "conciliators",
    "conciliatory", "conclusively", "concomitants", "concordances",
    "concurrences", "concurrently", "condemnation", "condemnatory",
    "condensation", "condescended", "conditionals", "conditioners",
    "conditioning", "condominiums", "conductivity", "confectioner",
    "confederated", "confederates", "conferencing", "confessional",
    "confidential", "configurable", "confinements", "confirmation",
    "confirmatory", "confiscating", "confiscation", "conformation",
    "congeniality", "congenitally", "conglomerate", "congratulate",
    "congregating", "congregation", "conjecturing", "conjugations",
    "conjunctions", "conjunctives", "conjunctures", "connectivity",
    "connoisseurs", "connotations", "conquistador", "conscripting",
    "conscription", "consecrating", "consecration", "consequences",
    "consequently", "conservation", "conservatism", "conservative",
    "conservators", "conservatory", "considerable", "considerably",
    "considerings", "consignments", "consistently", "consolations",
    "consolidated", "consolidates", "conspiracies", "conspirators",
    "constabulary", "constipating", "constipation", "constituency",
    "constituents", "constituting", "constitution", "constraining",
    "constricting", "constriction", "constrictive", "constrictors",
    "constructing", "construction", "constructive", "constructors",
    "consultation", "consultative", "consummately", "consummating",
    "consummation", "consumptives", "contagiously", "contaminants",
    "contaminated", "contaminates", "contemplated", "contemplates",
    "contemporary", "contemptible", "contemptibly", "contemptuous",
    "contextually", "continentals", "contingently", "continuances",
    "continuation", "continuities", "continuously", "contractions",
    "contradicted", "contraptions", "contrapuntal", "contrariness",
    "contrariwise", "contravening", "contributing", "contribution",
    "contributors", "contributory", "contrivances", "controllable",
    "controverted", "contumacious", "conurbations", "convalescent",
    "convalescing", "conveniences", "conveniently", "conventional",
    "convergences", "conversation", "convertibles", "conveyancing",
    "convincingly", "conviviality", "convocations", "convolutions",
    "convulsively", "cooperatives", "coordinating", "coordination",
    "coordinators", "copyrighting", "coquettishly", "corespondent",
    "corkscrewing", "cornerstones", "corporations", "correctional",
    "correlations", "correlatives", "corresponded", "corroborated",
    "corroborates", "corrugations", "cosmetically", "cosmological",
    "cosmologists", "cosmopolitan", "cosponsoring", "cottonmouths",
    "councilwoman", "councilwomen", "countenanced", "countenances",
    "counteracted", "counterblast", "counterclaim", "counterfeits",
    "counterfoils", "countermands", "counteroffer", "counterpanes",
    "counterparts", "counterpoint", "countersigns", "countersinks",
    "countertenor", "countervails", "countrysides", "countrywoman",
    "countrywomen", "courageously", "covetousness", "cowardliness",
    "crackerjacks", "craftspeople", "creationists", "creativeness",
    "credentialed", "creditworthy", "crematoriums", "crisscrossed",
    "crisscrosses", "crossbarring", "crosschecked", "crosscurrent",
    "crosspatches", "crucifixions", "cryptography", "crystallines",
    "culminations", "cumulatively", "curmudgeonly", "currycombing",
    "curtailments", "cuttlefishes", "deactivating", "debaucheries",
    "debilitating", "debilitation", "decaffeinate", "decapitating",
    "decapitation", "decelerating", "deceleration", "decipherable",
    "decisiveness", "declamations", "declarations", "declassified",
    "declassifies", "decommission", "decompressed", "decompresses",
    "decongestant", "deconstructs", "decontrolled", "decoratively",
    "decrescendos", "deerstalkers", "deescalating", "deficiencies",
    "definiteness", "definitively", "deflationary", "deformations",
    "degenerating", "degeneration", "degenerative", "dehumidified",
    "dehumidifier", "dehumidifies", "deliberately", "deliberating",
    "deliberation", "deliberative", "delicatessen", "delightfully",
    "delineations", "delinquently", "deliquescent", "demarcations",
    "demographers", "demographics", "demoniacally", "demonstrable",
    "demonstrably", "demonstrated", "demonstrates", "demonstrator",
    "demotivating", "demystifying", "denominating", "denomination",
    "denominators", "denouncement", "denunciation", "departmental",
    "dependencies", "depilatories", "depopulating", "depopulation",
    "deportations", "depositories", "depreciating", "depreciation",
    "depredations", "depressingly", "deprivations", "deprogrammed",
    "deregulating", "deregulation", "desalinating", "desalination",
    "descriptions", "desegregated", "desegregates", "designations",
    "desirability", "desolateness", "despairingly", "despondently",
    "despotically", "dessertspoon", "destinations", "destructible",
    "deteriorated", "deteriorates", "determinable", "determinants",
    "determinedly", "dethronement", "devaluations", "developments",
    "diabolically", "diagrammatic", "dictatorship", "dictionaries",
    "didactically", "differential", "difficulties", "dilapidation",
    "dilettantism", "dillydallied", "dillydallies", "diplomatists",
    "dipsomaniacs", "directionals", "directorates", "directorship",
    "disabilities", "disadvantage", "disaffecting", "disaffection",
    "disafforests", "disagreeable", "disagreeably", "disagreement",
    "disambiguate", "disappearing", "disappointed", "disapproving",
    "disarranging", "disassembled", "disassembles", "disassociate",
    "disastrously", "disbelieving", "disbursement", "disciplinary",
    "disciplining", "discomfiting", "discomfiture", "discomforted",
    "discommoding", "discomposing", "discomposure", "disconcerted",
    "disconnected", "disconsolate", "discontented", "discontinued",
    "discontinues", "discotheques", "discouraging", "discourteous",
    "discrediting", "discreteness", "discriminant", "discriminate",
    "disdainfully", "disembarking", "disembodying", "disemboweled",
    "disenchanted", "disencumbers", "disentangled", "disentangles",
    "disestablish", "disfranchise", "disgruntling", "disgustingly",
    "disheartened", "disillusions", "disincentive", "disinclining",
    "disinfectant", "disinfecting", "disingenuous", "disinherited",
    "disintegrate", "disinterests", "disinterment", "disinterring",
    "disjointedly", "dislocations", "dismembering", "dismissively",
    "disobedience", "disorientate", "disorienting", "dispensaries",
    "dispensation", "displacement", "dispositions", "dispossessed",
    "dispossesses", "disputations", "disputatious", "disqualified",
    "disqualifies", "disquisition", "disregarding", "disreputable",
    "disreputably", "disrespected", "disruptively", "dissatisfied",
    "dissatisfies", "disseminated", "disseminates", "dissertation",
    "dissimulated", "dissimulates", "dissociating", "dissociation",
    "distillation", "distilleries", "distinctions", "distractedly",
    "distractions", "distributing", "distribution", "distributive",
    "distributors", "disturbances", "disturbingly", "ditransitive",
    "diversifying", "diversionary", "divisibility", "divisiveness",
    "doctrinaires", "dogmatically", "domestically", "domesticated",
    "domesticates", "dominatrices", "doorknockers", "doorstepping",
    "downshifting", "dramatically", "dreadnoughts", "dumbfounding",
    "dysfunctions", "earsplitting", "earthquaking", "earthshaking",
    "eavesdropped", "eavesdropper", "eccentricity", "ecclesiastic",
    "eclectically", "ecologically", "economically", "ecstatically",
    "ecumenically", "educationist", "effectuating", "effervescent",
    "effervescing", "effortlessly", "effusiveness", "egalitarians",
    "ejaculations", "elaborations", "elderberries", "electioneers",
    "electrically", "electricians", "electrifying", "electrocuted",
    "electrocutes", "electrolysis", "electrolytes", "electrolytic",
    "electroplate", "eliminations", "elliptically", "elocutionist",
    "elucidations", "emancipating", "emancipation", "emancipators",
    "emasculating", "emasculation", "embarkations", "embarrassing",
    "embellishing", "embezzlement", "embrocations", "embroideries",
    "embroidering", "embryologist", "emotionalism", "emphatically",
    "emplacements", "encapsulated", "encapsulates", "encephalitis",
    "enchantingly", "enchantments", "encirclement", "encompassing",
    "encountering", "encroachment", "encrustation", "encumbrances",
    "encyclopedia", "encyclopedic", "endorsements", "enfranchised",
    "enfranchises", "enhancements", "enlargements", "enlightening",
    "enormousness", "entanglement", "enterprising", "entertainers",
    "entertaining", "enthronement", "enthusiastic", "entitlements",
    "entomologist", "entrenchment", "entrepreneur", "enumerations",
    "environments", "epidemiology", "epiglottises", "epigrammatic",
    "epistemology", "epistolaries", "equestrienne", "equilaterals",
    "equivalences", "equivalently", "equivocating", "equivocation",
    "erythrocytes", "escapologist", "esoterically", "establishing",
    "esthetically", "estrangement", "ethnocentric", "ethnographer",
    "ethnographic", "ethnological", "ethnologists", "etymological",
    "etymologists", "eucalyptuses", "euphorically", "evangelicals",
    "evangelistic", "eventfulness", "everlastings", "eviscerating",
    "evisceration", "evolutionary", "exacerbating", "exacerbation",
    "exaggerating", "exaggeration", "examinations", "exasperating",
    "exasperation", "exchangeable", "excitability", "exclamations",
    "exclusionary", "excoriations", "excrescences", "excruciating",
    "executioners", "exemplifying", "exhaustively", "exhilarating",
    "exhilaration", "exhortations", "exorbitantly", "expansionary",
    "expansionism", "expansionist", "expatriating", "expatriation",
    "expectations", "expectorants", "expectorated", "expectorates",
    "expediencies", "expenditures", "experiencing", "experiential",
    "experimental", "experimented", "experimenter", "explanations",
    "explications", "explicitness", "exploitation", "exploitative",
    "explorations", "expostulated", "expostulates", "expressively",
    "expropriated", "expropriates", "expropriator", "expurgations",
    "exterminated", "exterminates", "exterminator", "extinguished",
    "extinguisher", "extinguishes", "extortionate", "extortioners",
    "extortionist", "extraditable", "extraditions", "extramarital",
    "extraneously", "extrapolated", "extrapolates", "extrasensory",
    "extravagance", "extravaganza", "extroversion", "eyewitnesses",
    "fabrications", "facilitating", "facilitation", "facilitators",
    "facsimileing", "factionalism", "fainthearted", "faithfulness",
    "fallaciously", "fascinations", "fastidiously", "faultfinding",
    "fearlessness", "fecklessness", "felicitation", "felicitously",
    "fermentation", "fiddlesticks", "fieldworkers", "figuratively",
    "filibustered", "fingerboards", "fingerprints", "firebombings",
    "firecrackers", "firefighters", "firefighting", "firelighters",
    "fireproofing", "flabbergasts", "flagellating", "flagellation",
    "flamboyantly", "flamethrower", "flammability", "flatteringly",
    "flimflamming", "floodlighted", "fluctuations", "fluorescence",
    "fluoridating", "fluoridation", "fluorocarbon", "fluoroscopes",
    "foolhardiest", "footslogging", "forbiddingly", "forcefulness",
    "foreclosures", "foregrounded", "foreordained", "foreshadowed",
    "foreshortens", "forestalling", "forgathering", "formaldehyde",
    "formlessness", "formulations", "forthrightly", "fortuitously",
    "fountainhead", "fractionally", "frankfurters", "frankincense",
    "fraternities", "fraudulently", "freakishness", "freestanding",
    "freethinkers", "freethinking", "freewheeling", "frenetically",
    "fricasseeing", "friendliness", "frogmarching", "frontbencher",
    "frontbenches", "frontiersman", "frontiersmen", "frontispiece",
    "fruitfullest", "fruitfulness", "frustrations", "fulminations",
    "functionally", "fundamentals", "gallbladders", "gallivanting",
    "galvanometer", "gamesmanship", "garnisheeing", "gatecrashers",
    "gatecrashing", "gazetteering", "genealogical", "genealogists",
    "generalities", "generational", "generosities", "genuflecting",
    "genuflection", "geographical", "geologically", "geophysicist",
    "geopolitical", "geriatrician", "gerrymanders", "gesticulated",
    "gesticulates", "ghostwriters", "ghostwriting", "ghostwritten",
    "gigantically", "gladiatorial", "globetrotter", "glockenspiel",
    "gluttonously", "gobbledygook", "goddaughters", "goldbricking",
    "gooseberries", "goosestepped", "gorgeousness", "governmental",
    "governorship", "gracefullest", "gracefulness", "graciousness",
    "granddaddies", "grandfathers", "grandmothers", "grandparents",
    "grandstanded", "graphologist", "grasshoppers", "gratefullest",
    "gratefulness", "gratifyingly", "gratuitously", "gravediggers",
    "greengrocers", "gregariously", "griddlecakes", "groundcloths",
    "groundlessly", "groundsheets", "groundswells", "guaranteeing",
    "guardianship", "guesstimated", "guesstimates", "guillotining",
    "guttersnipes", "haberdashers", "haberdashery", "habitability",
    "hairbreadths", "hairdressers", "hairdressing", "hairsbreadth",
    "hairstylists", "hallucinated", "hallucinates", "hallucinogen",
    "hamstringing", "handcrafting", "handicappers", "handicapping",
    "handkerchief", "handsomeness", "happenstance", "harbormaster",
    "hardheadedly", "hardscrabble", "harmlessness", "harmonically",
    "harmoniously", "harpsichords", "headmistress", "headquarters",
    "headteachers", "heartrending", "heartstrings", "heartwarming",
    "heavyweights", "heedlessness", "helicoptered", "helplessness",
    "hemorrhaging", "hemstitching", "henceforward", "hermetically",
    "herringboned", "herringbones", "hesitatingly", "heterosexual",
    "hierarchical", "hieroglyphic", "highlighters", "highlighting",
    "hindquarters", "hippopotamus", "historically", "holidaymaker",
    "holistically", "homelessness", "homesickness", "homesteaders",
    "homesteading", "honeycombing", "honeymooners", "honeymooning",
    "honeysuckles", "hopelessness", "hopscotching", "horizontally",
    "horrendously", "horrifically", "horrifyingly", "horsemanship",
    "horseshoeing", "horsetrading", "horsewhipped", "horticulture",
    "housebreaker", "housecleaned", "householders", "househusband",
    "housekeepers", "housekeeping", "housemasters", "housemothers",
    "housewarming", "humanitarian", "humiliations", "hummingbirds",
    "hundredfolds", "hydraulicked", "hydrocarbons", "hydrogenated",
    "hydrogenates", "hydroplaning", "hydrotherapy", "hygienically",
    "hyperactives", "hypermarkets", "hypertension", "hyphenations",
    "hypnotherapy", "hypnotically", "hypochondria", "hypocritical",
    "hypoglycemia", "hypoglycemic", "hypothalamus", "hypothetical",
    "hysterectomy", "hysterically", "iconoclastic", "identifiable",
    "idiosyncrasy", "illegalities", "illegibility", "illegitimacy",
    "illegitimate", "illogicality", "illuminating", "illumination",
    "illusionists", "illustrating", "illustration", "illustrative",
    "illustrators", "imaginations", "imbecilities", "immaculately",
    "immeasurable", "immeasurably", "immobilisers", "immobilizers",
    "immoderately", "immoralities", "immutability", "impartiality",
    "impeachments", "impenetrable", "impenetrably", "imperatively",
    "imperfection", "imperialists", "imperishable", "impermanence",
    "impersonally", "impersonated", "impersonates", "impersonator",
    "impertinence", "impertinents", "implantation", "implementing",
    "implications", "impoliteness", "imponderable", "importations",
    "importunated", "importunates", "impoverished", "impoverishes",
    "imprecations", "impregnating", "impregnation", "impressively",
    "imprisonment", "improvements", "improvidence", "inaccessible",
    "inaccuracies", "inaccurately", "inadequacies", "inadequately",
    "inadmissible", "inadvertence", "inapplicable", "inarticulacy",
    "inarticulate", "inaudibility", "inaugurating", "inauguration",
    "inauspicious", "incalculable", "incalculably", "incandescent",
    "incantations", "incapability", "incapacitate", "incarcerated",
    "incarcerates", "incarnations", "incautiously", "incendiaries",
    "incestuously", "incidentally", "incinerating", "incineration",
    "incinerators", "incisiveness", "incivilities", "inclinations",
    "incoherently", "incomparable", "incomparably", "incompatible",
    "incompatibly", "incompetence", "incompetents", "incompletely",
    "inconclusive", "inconsistent", "inconsolable", "inconsolably",
    "incontinence", "inconvenient", "incorporated", "incorporates",
    "incorrigible", "incorrigibly", "increasingly", "incrementing",
    "incriminated", "incriminates", "incrustation", "incumbencies",
    "indebtedness", "indecisively", "indecorously", "indefensible",
    "indefensibly", "indefinitely", "indelicacies", "indelicately",
    "indemnifying", "indentations", "independence", "independents",
    "indifference", "indigestible", "indirectness", "indiscipline",
    "indiscreetly", "indiscretion", "indisputable", "indisputably",
    "indissoluble", "indissolubly", "indistinctly", "individually",
    "indoctrinate", "industrially", "inefficiency", "inefficients",
    "inequalities", "ineradicable", "inessentials", "inexperience",
    "inexplicable", "inexplicably", "inexpressive", "inextricable",
    "inextricably", "infanticides", "infatuations", "infectiously",
    "infelicities", "infelicitous", "infestations", "infidelities",
    "infiltrating", "infiltration", "infiltrators", "inflammation",
    "inflammatory", "inflationary", "inflectional", "infomercials",
    "infotainment", "infrequently", "infringement", "ingloriously",
    "ingratiating", "inheritances", "inhospitable", "inhumanities",
    "inoculations", "inordinately", "inquisitions", "insalubrious",
    "inscriptions", "insecticidal", "insecticides", "insectivores",
    "insecurities", "inseminating", "insemination", "inseparables",
    "insinuations", "insolubility", "insolvencies", "inspectorate",
    "inspirations", "installation", "institutions", "instructions",
    "instrumental", "instrumented", "insufferable", "insufferably",
    "insufficient", "insurgencies", "insurrection", "intellectual",
    "intelligence", "intelligible", "intelligibly", "intemperance",
    "intensifiers", "intensifying", "interactions", "intercepting",
    "interception", "interceptors", "intercession", "intercessors",
    "interchanged", "interchanges", "interconnect", "interdicting",
    "interdiction", "interference", "interjecting", "interjection",
    "interlarding", "interleaving", "interlinking", "interlocking",
    "interlocutor", "intermarried", "intermarries", "intermediary",
    "intermediate", "interminable", "interminably", "intermingled",
    "intermingles", "intermission", "intermittent", "interpolated",
    "interpolates", "interpreters", "interpreting", "interpretive",
    "interregnums", "interrelated", "interrelates", "interrogated",
    "interrogates", "interrogator", "interrupting", "interruption",
    "intersecting", "intersection", "interspersed", "intersperses",
    "interstellar", "intertwining", "intervention", "interviewees",
    "interviewers", "interviewing", "interweaving", "intimidating",
    "intimidation", "intolerantly", "intoxicating", "intoxication",
    "intransigent", "intransitive", "intrauterine", "intriguingly",
    "introduction", "introductory", "introversion", "invalidating",
    "invalidation", "inventorying", "invertebrate", "investigated",
    "investigates", "investigator", "investitures", "invigilating",
    "invigilation", "invigilators", "invigorating", "invigoration",
    "invisibility", "invitational", "involvements", "invulnerable",
    "invulnerably", "irascibility", "irrationally", "irredeemable",
    "irredeemably", "irregardless", "irregularity", "irrelevances",
    "irrelevantly", "irremediable", "irremediably", "irresistible",
    "irresistibly", "irresolutely", "irresolution", "irrespective",
    "irreverently", "irreversible", "irreversibly", "irritability",
    "irritatingly", "isolationism", "isolationist", "jackhammered",
    "jitterbugged", "journalistic", "jurisdiction", "kaleidoscope",
    "keyboardists", "kindergarten", "kitchenettes", "kleptomaniac",
    "knuckleheads", "laboratories", "labyrinthine", "lamentations",
    "landholdings", "languorously", "lasciviously", "latticeworks",
    "launderettes", "leapfrogging", "leaseholders", "leathernecks",
    "lectureships", "legionnaires", "legislatures", "legitimately",
    "legitimating", "lexicography", "libertarians", "licentiously",
    "lighthearted", "lightweights", "limelighting", "liquefaction",
    "liquidations", "listlessness", "lithographed", "lithographer",
    "lithographic", "lithospheres", "liturgically", "loganberries",
    "logistically", "longitudinal", "longshoreman", "longshoremen",
    "lopsidedness", "loquaciously", "loudspeakers", "lubriciously",
    "lugubriously", "luminescence", "lumpectomies", "luncheonette",
    "lusciousness", "machinations", "mackintoshes", "macrobiotics",
    "mademoiselle", "magnetically", "magnificence", "maidservants",
    "mainstreamed", "maintainable", "majestically", "malapropisms",
    "maledictions", "malevolently", "malformation", "malfunctions",
    "malignancies", "malleability", "malnourished", "malnutrition",
    "malpractices", "maltreatment", "manageresses", "maneuverings",
    "manifestoing", "manipulating", "manipulation", "manipulative",
    "manipulators", "manoeuvrings", "manslaughter", "mantelpieces",
    "manufactured", "manufacturer", "manufactures", "marketplaces",
    "marksmanship", "marriageable", "marshmallows", "masqueraders",
    "masquerading", "mastectomies", "masterminded", "masterpieces",
    "masterstroke", "masturbating", "masturbation", "masturbatory",
    "materialists", "mathematical", "matriarchies", "matriculated",
    "matriculates", "meaningfully", "measurements", "mechanically",
    "mediocrities", "meditatively", "meetinghouse", "megalomaniac",
    "melancholics", "melodramatic", "menstruating", "menstruation",
    "merchandised", "merchandises", "meretricious", "meritocratic",
    "metalanguage", "metallurgist", "metamorphism", "metamorphose",
    "metaphorical", "metaphysical", "methodically", "meticulously",
    "metropolises", "metropolitan", "microbiology", "microfilming",
    "microseconds", "microsurgery", "microwavable", "middleweight",
    "militaristic", "millionaires", "milliseconds", "milquetoasts",
    "mimeographed", "mindlessness", "mineralogist", "minesweepers",
    "miniaturists", "minicomputer", "ministration", "miraculously",
    "misadventure", "misalignment", "misalliances", "misanthropes",
    "misanthropic", "misapprehend", "miscalculate", "miscarriages",
    "miscellanies", "misconceived", "misconceives", "misconducted",
    "misconstrued", "misconstrues", "misdiagnosed", "misdiagnoses",
    "misdiagnosis", "misdirecting", "misdirection", "misgoverning",
    "misinforming", "misinterpret", "misleadingly", "misogynistic",
    "mispronounce", "misquotation", "misreporting", "misrepresent",
    "missionaries", "misspellings", "misstatement", "mistreatment",
    "mockingbirds", "modification", "mollycoddled", "mollycoddles",
    "moneylenders", "monkeyshines", "monogramming", "monolinguals",
    "monopolistic", "monosyllabic", "monosyllable", "monotheistic",
    "monotonously", "monumentally", "moonlighters", "moonlighting",
    "mortarboards", "motherboards", "motherfucker", "motherliness",
    "motivational", "motorcycling", "motorcyclist", "mountaineers",
    "mountainside", "mountaintops", "mournfullest", "mournfulness",
    "mousetrapped", "mulligatawny", "multifaceted", "multifarious",
    "multilateral", "multilingual", "multiplexers", "multiplexing",
    "multiplicand", "multiplicity", "multipurpose", "multitasking",
    "multivariate", "multivitamin", "municipality", "musicianship",
    "musicologist", "muskellunges", "mysteriously", "mythological",
    "mythologists", "narcissistic", "nationalists", "naturalistic",
    "nauseatingly", "nauseousness", "navigability", "navigational",
    "neanderthals", "nebulousness", "necessitated", "necessitates",
    "neckerchiefs", "necromancers", "necrophiliac", "necropolises",
    "neglectfully", "negotiations", "neoclassical", "neurological",
    "neurologists", "neurosurgery", "neurotically", "nevertheless",
    "newspapering", "newspaperman", "newspapermen", "newsworthier",
    "nickelodeons", "nightclothes", "nightclubbed", "nightdresses",
    "nightingales", "nomenclature", "nonabsorbent", "nonagenarian",
    "nonalcoholic", "nonbelievers", "nonbreakable", "nonchalantly",
    "noncombatant", "noncommittal", "nonconductor", "nonessential",
    "nonexistence", "nonflammable", "nonhazardous", "nonmalignant",
    "nonobjective", "nonpartisans", "nonpoisonous", "nonpolitical",
    "nonpolluting", "nonrenewable", "nonresidents", "nonscheduled",
    "nonsectarian", "nontechnical", "northeastern", "northeasters",
    "northernmost", "northwestern", "noticeboards", "notification",
    "numismatists", "nutritionist", "nymphomaniac", "obfuscations",
    "obliterating", "obliteration", "obscurantism", "obscurantist",
    "obsequiously", "observations", "obsolescence", "obstetrician",
    "obstreperous", "obstructions", "obstructives", "occasionally",
    "occupational", "oceanography", "octogenarian", "officeholder",
    "omnipresence", "onomatopoeia", "onomatopoeic", "operatically",
    "opportunists", "oppressively", "optometrists", "orchestrated",
    "orchestrates", "ordinariness", "orientalists", "orientations",
    "orienteering", "orthodontics", "orthodontist", "orthographic",
    "oscillations", "oscilloscope", "ossification", "ostentatious",
    "osteoporosis", "otherworldly", "outbalancing", "outbuildings",
    "outcroppings", "outdistanced", "outdistances", "outlandishly",
    "outnumbering", "outperformed", "outplacement", "outrageously",
    "outspreading", "outstretched", "outstretches", "outstripping",
    "overabundant", "overachieved", "overachiever", "overachieves",
    "overbalanced", "overbalances", "overburdened", "overcautious",
    "overcharging", "overcrowding", "overdevelops", "overdressing",
    "overemphasis", "overestimate", "overexciting", "overexposing",
    "overexposure", "overextended", "overgenerous", "overindulged",
    "overindulges", "overpopulate", "overpowering", "overprinting",
    "overproduced", "overproduces", "overreaching", "overreacting",
    "overreaction", "oversampling", "overshadowed", "overshooting",
    "oversimplify", "oversleeping", "overspending", "overstepping",
    "overstocking", "oversupplied", "oversupplies", "overthrowing",
    "overwhelming", "overwintered", "oxyacetylene", "pacification",
    "paintbrushes", "palaeolithic", "paleontology", "palpitations",
    "pamphleteers", "panchromatic", "pantechnicon", "paperbacking",
    "paperhangers", "paperweights", "paracetamols", "parachutists",
    "paradigmatic", "paragraphing", "parallelisms", "paramedicals",
    "paramilitary", "paraphrasing", "parascending", "paratroopers",
    "parishioners", "parochialism", "parsimonious", "participants",
    "participated", "participates", "participator", "particularly",
    "particulates", "partisanship", "partitioning", "partnerships",
    "passionately", "passionating", "paternalists", "pathetically",
    "pathological", "pathologists", "patriarchies", "peacefullest",
    "peacefulness", "peacekeepers", "peacekeeping", "peccadilloes",
    "pedantically", "pejoratively", "penetrations", "penitentiary",
    "pennyweights", "penultimates", "perambulated", "perambulates",
    "perambulator", "perceptively", "peremptorily", "perforations",
    "performances", "periodically", "peripatetics", "peripherally",
    "permeability", "permissively", "permutations", "perniciously",
    "perpetrating", "perpetration", "perpetrators", "perpetuating",
    "perpetuation", "perplexities", "persecutions", "perseverance",
    "persistently", "personifying", "perspectives", "perspicacity",
    "perspiration", "persuasively", "pertinacious", "perturbation",
    "perverseness", "pestilential", "petrifaction", "petrodollars",
    "pettifoggers", "pettifogging", "pharmacology", "phenomenally",
    "philanderers", "philandering", "philanthropy", "philatelists",
    "philharmonic", "philistinism", "philodendron", "philological",
    "philologists", "philosophers", "philosophies", "phonetically",
    "phoneticians", "phonological", "phonologists", "photocopiers",
    "photocopying", "photographed", "photographer", "photographic",
    "photostatted", "phrenologist", "physiologist", "pigeonholing",
    "piggybacking", "pigmentation", "pitchforking", "pitilessness",
    "plainclothes", "planetariums", "plasterboard", "plausibility",
    "pleasantness", "pleasantries", "plutocracies", "pocketknives",
    "pointillists", "policyholder", "policymakers", "poltergeists",
    "polyethylene", "polygraphing", "polymorphous", "polysyllabic",
    "polysyllable", "polytechnics", "polytheistic", "polyurethane",
    "pomegranates", "pontificated", "pontificates", "pornographer",
    "pornographic", "portcullises", "portentously", "porterhouses",
    "portmanteaus", "portraitists", "positiveness", "possessively",
    "postdoctoral", "postgraduate", "posthumously", "postmistress",
    "postponement", "postprandial", "potentiality", "practicality",
    "practitioner", "praiseworthy", "prearranging", "precariously",
    "preciousness", "precipitants", "precipitated", "precipitates",
    "precociously", "precognition", "preconceived", "preconceives",
    "precondition", "predeceasing", "predecessors", "predestining",
    "predetermine", "predicaments", "predigesting", "predilection",
    "predisposing", "predominance", "predominated", "predominates",
    "preeminently", "prefabricate", "preferential", "premeditated",
    "premeditates", "premenstrual", "premonitions", "preoccupying",
    "preordaining", "prepackaging", "preparations", "preparedness",
    "preponderant", "preponderate", "prepositions", "prepossessed",
    "prepossesses", "preposterous", "prepubescent", "prerecording",
    "preregisters", "prerequisite", "prerogatives", "presbyteries",
    "preschoolers", "prescription", "prescriptive", "presentation",
    "presentiment", "preservation", "preservative", "preshrinking",
    "presidencies", "presidential", "presumptions", "presumptuous",
    "presupposing", "prevaricated", "prevaricates", "prevaricator",
    "preventative", "priggishness", "principality", "prizefighter",
    "prizewinning", "probationary", "probationers", "problematics",
    "processional", "processioned", "proclamation", "proclivities",
    "prodigiously", "productively", "productivity", "profanations",
    "professional", "professorial", "proficiently", "profiteering",
    "profiteroles", "profundities", "progesterone", "programmable",
    "programmatic", "progressions", "progressives", "prohibitions",
    "proletarians", "proliferated", "proliferates", "prolifically",
    "prolongation", "promontories", "promulgating", "promulgation",
    "proofreaders", "proofreading", "propagandist", "propensities",
    "prophetesses", "prophylactic", "propitiating", "propitiation",
    "propitiatory", "propitiously", "proportional", "proportioned",
    "propositions", "proprietress", "proscription", "prosecutions",
    "prospectives", "prospectuses", "prosperously", "prostituting",
    "prostitution", "prostrations", "protagonists", "protectively",
    "protectorate", "protestation", "protoplasmic", "prototypical",
    "protuberance", "provendering", "proverbially", "providential",
    "provincially", "provisioning", "provocateurs", "provocations",
    "psephologist", "pseudonymous", "psychedelics", "psychiatrist",
    "psychoactive", "psychobabble", "psychodramas", "psychologies",
    "psychologist", "psychometric", "psychopathic", "psychotropic",
    "pterodactyls", "publications", "pugnaciously", "pumpernickel",
    "purification", "purposefully", "pussyfooting", "putrefaction",
    "pyrotechnics", "quadrangular", "quadraphonic", "quadricepses",
    "quadriplegia", "quadriplegic", "quantifiable", "quantitative",
    "quarantining", "quarterbacks", "quarterdecks", "quarterfinal",
    "questionable", "questionably", "quintessence", "racketeering",
    "racquetballs", "radiographer", "radioisotope", "radiologists",
    "radiotherapy", "rambunctious", "ramification", "rangefinders",
    "rapscallions", "rathskellers", "ratification", "rationalists",
    "rattlesnakes", "reactivating", "reactivation", "readdressing",
    "readjustment", "realignments", "reallocating", "reallocation",
    "reappearance", "reappointing", "reapportions", "reappraisals",
    "reappraising", "reassembling", "reassessment", "reassurances",
    "reassuringly", "rebelliously", "rebroadcasts", "recalcitrant",
    "recantations", "recapitulate", "receivership", "receptionist",
    "recessionals", "recessionary", "rechargeable", "reciprocally",
    "reciprocated", "reciprocates", "recklessness", "reclassified",
    "reclassifies", "recollecting", "recollection", "recommencing",
    "recommending", "recompensing", "reconcilable", "reconditions",
    "reconfigured", "reconnecting", "reconquering", "reconsidered",
    "reconstitute", "reconstructs", "recreational", "recriminated",
    "recriminates", "recuperating", "recuperation", "recuperative",
    "redecorating", "redecoration", "rededicating", "redefinition",
    "redeployment", "redeveloping", "rediscovered", "redistribute",
    "redistricted", "reductionist", "redundancies", "reenactments",
    "reevaluating", "refashioning", "reflationary", "reflectively",
    "reformations", "reformatting", "reformulated", "reformulates",
    "refractories", "refreshingly", "refreshments", "refrigerants",
    "refrigerated", "refrigerates", "refrigerator", "refurbishing",
    "refurnishing", "regenerating", "regeneration", "regenerative",
    "regionalisms", "registration", "regularities", "regurgitated",
    "regurgitates", "rehabilitate", "reincarnated", "reincarnates",
    "reinterprets", "reiterations", "rejuvenating", "rejuvenation",
    "relationship", "relativistic", "relentlessly", "relinquished",
    "relinquishes", "remaindering", "remembrances", "reminiscence",
    "remonstrance", "remonstrated", "remonstrates", "remorsefully",
    "remortgaging", "remunerating", "remuneration", "remunerative",
    "renaissances", "rendezvoused", "rendezvouses", "renditioning",
    "renegotiated", "renegotiates", "renunciation", "repatriating",
    "repatriation", "repercussion", "repetitively", "replacements",
    "replenishing", "replications", "repositories", "repossessing",
    "repossession", "reprehending", "representing", "repressively",
    "reprimanding", "reprocessing", "reproducible", "reproduction",
    "reproductive", "reprogrammed", "republishing", "repudiations",
    "requirements", "requisitions", "rescheduling", "resemblances",
    "reservations", "resettlement", "resignations", "resoluteness",
    "resoundingly", "respectables", "respectfully", "respectively",
    "resplendence", "responsively", "restatements", "restaurateur",
    "restlessness", "restorations", "restoratives", "restrictions",
    "restrictives", "restructured", "restructures", "resubmitting",
    "resurrecting", "resurrection", "resuscitated", "resuscitates",
    "resuscitator", "retaliations", "reticulation", "retrenchment",
    "retributions", "retrofitting", "retrograding", "retrogressed",
    "retrogresses", "retrorockets", "retrospected", "reupholsters",
    "revaluations", "reverberated", "reverberates", "revisionists",
    "rhetorically", "rhetoricians", "rhinoceroses", "rhododendron",
    "rhythmically", "ridiculously", "rightfulness", "roadblocking",
    "romantically", "romanticists", "rootlessness", "rotogravures",
    "roughhousing", "roughnecking", "rubbernecked", "rubbernecker",
    "ruminatively", "rustproofing", "ruthlessness", "sacramenting",
    "sacrilegious", "sadistically", "safeguarding", "safekeepings",
    "sailboarding", "salesmanship", "sandblasters", "sandblasting",
    "sandpapering", "sardonically", "sarsaparilla", "satisfaction",
    "satisfactory", "satisfyingly", "saxophonists", "scandalously",
    "scapegoating", "scaremongers", "scatological", "scatterbrain",
    "schmaltziest", "scholarships", "schoolhouses", "schoolmaster",
    "scintillated", "scintillates", "scorekeepers", "scoutmasters",
    "scratchcards", "scratchiness", "screenwriter", "screwdrivers",
    "scrimshawing", "scriptwriter", "scrupulously", "scurrilously",
    "seamstresses", "searchlights", "seaworthiest", "secessionist",
    "secretariats", "sectarianism", "sectionalism", "seductresses",
    "segmentation", "seismographs", "seismologist", "selflessness",
    "semantically", "semicircular", "semifinalist", "semiprecious",
    "semitrailers", "semitropical", "semiweeklies", "sensuousness",
    "separability", "sequentially", "sequestering", "sequestrated",
    "sequestrates", "servicewoman", "servicewomen", "seventeenths",
    "sexagenarian", "shadowboxing", "shamefacedly", "shamefulness",
    "sharecropper", "shareholders", "shareholding", "sharpshooter",
    "shatterproof", "sheepishness", "shipbuilders", "shipbuilding",
    "shipwrecking", "shirtsleeves", "shortchanged", "shortchanges",
    "shortcomings", "shortcutting", "shortlisting", "shortsighted",
    "showstoppers", "showstopping", "shuffleboard", "shuttlecocks",
    "sidestepping", "sidestroking", "sidetracking", "significance",
    "silhouetting", "silverfishes", "silversmiths", "similarities",
    "simulcasting", "simultaneity", "simultaneous", "skateboarded",
    "skateboarder", "skittishness", "skyrocketing", "slaphappiest",
    "slaughterers", "slaughtering", "sledgehammer", "sleepwalkers",
    "sleepwalking", "slipperiness", "sloganeering", "slothfulness",
    "slovenliness", "sluggishness", "smallholders", "smallholding",
    "smokescreens", "snobbishness", "snowboarders", "snowboarding",
    "snowmobiling", "sociological", "sociologists", "solicitation",
    "solicitously", "solitariness", "somersaulted", "somnambulism",
    "somnambulist", "songstresses", "sophisticate", "soullessness",
    "soundproofed", "southeastern", "southernmost", "southwestern",
    "southwesters", "spaceflights", "spacewalking", "spaciousness",
    "sparrowhawks", "speakerphone", "spearheading", "specifically",
    "speciousness", "spectaculars", "spectroscope", "spectroscopy",
    "speculations", "speechifying", "speechlessly", "speechwriter",
    "speedometers", "speleologist", "spellbinders", "spellbinding",
    "spellchecker", "spendthrifts", "spermatozoon", "spinsterhood",
    "spiritualism", "spiritualist", "spirituality", "spitefullest",
    "spitefulness", "spokespeople", "spokesperson", "sporadically",
    "sportscaster", "sportspeople", "sportsperson", "spotlessness",
    "spotlighting", "spreadeagled", "spreadsheets", "sprightliest",
    "springboards", "spuriousness", "squeezeboxes", "stagecoaches",
    "staggeringly", "stakeholders", "stallholders", "stammeringly",
    "statementing", "statistician", "steamrollers", "steamrolling",
    "steelworkers", "steeplechase", "steeplejacks", "stenographer",
    "stenographic", "stepbrothers", "stepchildren", "stepdaughter",
    "stereophonic", "stereoscopes", "stereoscopic", "stereotyping",
    "stethoscopes", "stewardesses", "sticklebacks", "stipulations",
    "stockbrokers", "stockbroking", "stockholders", "stomachaches",
    "stonewalling", "storekeepers", "storytellers", "storytelling",
    "stouthearted", "straightaway", "straightedge", "straightened",
    "straightness", "straitjacket", "stranglehold", "strangulated",
    "strangulates", "stratosphere", "strawberries", "streamlining",
    "streetlights", "streetwalker", "strengthened", "streptococci",
    "streptomycin", "stretchering", "stretchmarks", "stripteasing",
    "structurally", "stubbornness", "studentships", "studiousness",
    "stupefaction", "stupendously", "subbasements", "subcommittee",
    "subconscious", "subcontinent", "subcontracts", "subcutaneous",
    "subdivisions", "subjectively", "subjectivity", "subjunctives",
    "subliminally", "submersibles", "submissively", "subordinated",
    "subordinates", "subscription", "subsequently", "subservience",
    "subservients", "subsidiaries", "subsidiarity", "substantiate",
    "substantives", "substituting", "substitution", "substructure",
    "subterranean", "subtractions", "suburbanites", "subversively",
    "successfully", "successively", "succinctness", "sufficiently",
    "suffocatings", "suffragettes", "sugarcoating", "suggestively",
    "summerhouses", "superannuate", "supercharged", "supercharger",
    "supercharges", "supercilious", "superficials", "supergrasses",
    "superhighway", "superimposed", "superimposes", "superintends",
    "superlatives", "supermarkets", "supernatural", "superscripts",
    "superstition", "supertankers", "supervisions", "supplemental",
    "supplemented", "supplicating", "supplication", "suppositions",
    "suppressants", "supremacists", "surfboarding", "surmountable",
    "surprisingly", "surrealistic", "surrendering", "surroundings",
    "surveillance", "suspiciously", "swallowtails", "swashbuckler",
    "switchblades", "switchboards", "syllabifying", "symbolically",
    "sympathetics", "syndicalists", "systemically", "tactlessness",
    "taramasalata", "tautological", "taxidermists", "teaspoonfuls",
    "technicality", "technocratic", "technologies", "technologist",
    "technophobes", "teenyboppers", "telecommuted", "telecommuter",
    "telecommutes", "telegraphers", "telegraphese", "telegraphing",
    "teleological", "telephonists", "teleprinters", "temperaments",
    "temperatures", "tercentenary", "terminations", "terrestrials",
    "terrifically", "terrifyingly", "territorials", "tessellating",
    "tessellation", "testamentary", "testimonials", "testosterone",
    "tetrahedrons", "thankfullest", "thankfulness", "thanksgiving",
    "theatrically", "thematically", "theoretician", "therapeutics",
    "thermometers", "thermostatic", "thingamabobs", "thingamajigs",
    "thingumabobs", "thoroughbred", "thoroughfare", "thoroughness",
    "thoughtfully", "threatenings", "thunderbolts", "thunderclaps",
    "thundercloud", "thunderheads", "thunderously", "thunderstorm",
    "timelessness", "timorousness", "tirelessness", "tiresomeness",
    "toastmasters", "tobacconists", "togetherness", "tomfooleries",
    "toothbrushes", "topographers", "topographies", "tortuousness",
    "totalitarian", "toxicologist", "tractability", "trademarking",
    "tradespeople", "trailblazers", "trainspotter", "traitorously",
    "trajectories", "trampolining", "transactions", "transceivers",
    "transcendent", "transcending", "transcribing", "transferable",
    "transference", "transferring", "transfigured", "transfigures",
    "transformers", "transforming", "transfusions", "transgressed",
    "transgresses", "transgressor", "transitional", "transitioned",
    "transitively", "transitivity", "translations", "translucence",
    "transmigrate", "transmission", "transmitters", "transmitting",
    "transmogrify", "transoceanic", "transparency", "transplanted",
    "transponders", "transporters", "transporting", "transsexuals",
    "transshipped", "transversely", "transversing", "transvestism",
    "transvestite", "trapshooting", "tremendously", "trendsetters",
    "trendsetting", "tribulations", "triglyceride", "trigonometry",
    "triplicating", "triumphalism", "triumphalist", "triumphantly",
    "triumvirates", "trivialities", "trolleybuses", "tropospheres",
    "troublemaker", "troubleshoot", "trusteeships", "trustfulness",
    "truthfulness", "tuberculosis", "tumultuously", "turbocharged",
    "turbocharger", "turbocharges", "typographers", "tyrannically",
    "tyrannosaurs", "ubiquitously", "unacceptable", "unacceptably",
    "unaccustomed", "unacquainted", "unaffectedly", "unanswerable",
    "unapologetic", "unassailable", "unattainable", "unattractive",
    "unattributed", "unbelievable", "unbelievably", "unblinkingly",
    "unbridgeable", "uncatalogued", "unchallenged", "unchangeable",
    "uncharitable", "uncharitably", "unclassified", "uncleanliest",
    "uncompressed", "unconcerning", "unconsidered", "uncontrolled",
    "unconvincing", "uncorrelated", "uncritically", "unctuousness",
    "uncultivated", "undemocratic", "undependable", "underachieve",
    "underbellies", "underbidding", "underbrushed", "underbrushes",
    "undercharged", "undercharges", "underclasses", "underclothes",
    "undercoating", "undercurrent", "undercutting", "underexposed",
    "underexposes", "underfeeding", "undergarment", "undergrounds",
    "underpinning", "underplaying", "underscoring", "underselling",
    "undersigning", "understaffed", "understating", "understudied",
    "understudies", "undertakings", "undervaluing", "underwhelmed",
    "underwriters", "underwriting", "underwritten", "undeservedly",
    "undesirables", "undetectable", "undetermined", "undiminished",
    "undischarged", "undiscovered", "undocumented", "uneconomical",
    "unemployable", "unemployment", "uneventfully", "unexpectedly",
    "unexpurgated", "unfaithfully", "unfathomable", "unfathomably",
    "unflattering", "unforgivable", "unforgivably", "unfortunates",
    "unfrequented", "unfriendlier", "ungainliness", "ungovernable",
    "ungraciously", "ungratefully", "unhealthiest", "unhesitating",
    "unidentified", "unilaterally", "unimaginable", "unimaginably",
    "unimpressive", "uninterested", "universality", "universities",
    "unlikelihood", "unmanageable", "unmercifully", "unmistakable",
    "unmistakably", "unnoticeable", "unobstructed", "unobtainable",
    "unofficially", "unpardonable", "unpleasantly", "unpopularity",
    "unprejudiced", "unprincipled", "unprivileged", "unproductive",
    "unprofitable", "unquenchable", "unquestioned", "unreasonable",
    "unreasonably", "unregenerate", "unregistered", "unrelievedly",
    "unremarkable", "unrepeatable", "unreservedly", "unresponsive",
    "unrestrained", "unrestricted", "unsanctioned", "unsatisfying",
    "unscientific", "unscrambling", "unscrupulous", "unseasonable",
    "unseasonably", "unseemliness", "unsightliest", "unsteadiness",
    "unstintingly", "unstructured", "unsuccessful", "unsupervised",
    "unsurprising", "unsuspecting", "unthinkingly", "untimeliness",
    "untouchables", "untruthfully", "unwieldiness", "unworthiness",
    "upholsterers", "upholstering", "uppercutting", "uproariously",
    "utilitarians", "vaccinations", "vacillations", "vainglorious",
    "vaporisation", "veggieburger", "verdigrising", "verification",
    "veterinarian", "veterinaries", "vicissitudes", "victoriously",
    "vilification", "vindications", "vindictively", "violincellos",
    "violoncellos", "virtuousness", "viscountcies", "vituperating",
    "vituperation", "vituperative", "vocabularies", "vocationally",
    "vociferating", "vociferation", "vociferously", "voluminously",
    "volunteering", "voluptuaries", "voluptuously", "wainscotings",
    "waistcoating", "wallpapering", "warmongering", "wastebaskets",
    "wastefulness", "watchfulness", "watercourses", "watermarking",
    "waterproofed", "weatherboard", "weathercocks", "weatherproof",
    "weighbridges", "weightlessly", "weightlifter", "welterweight",
    "whatshername", "whatshisname", "wheelbarrows", "wheelwrights",
    "whimsicality", "whippoorwill", "whitewashing", "wholehearted",
    "wildernesses", "windbreakers", "windcheaters", "wisecracking",
    "withstanding", "woodcarvings", "workstations", "wretchedness",
    "wristwatches", "wrongfulness", "xylophonists", "yellowhammer",
    "youthfulness"
  };

  const char* w_13[] = {
    "abbreviations", "abnormalities", "abolitionists", "accelerations",
    "acceptability", "accessibility", "acclimatising", "acclimatizing",
    "accommodating", "accommodation", "accompaniment", "accomplishing",
    "accouterments", "accreditation", "acculturation", "accumulations",
    "acetaminophen", "acknowledging", "acquaintances", "acrimoniously",
    "acupuncturist", "adjudications", "administering", "administrated",
    "administrates", "administrator", "admissibility", "admonishments",
    "adventuresome", "adventuresses", "adventurously", "advertisement",
    "aesthetically", "affirmatively", "affordability", "afforestation",
    "afterthoughts", "agglomerating", "agglomeration", "agglutinating",
    "agglutination", "airworthiness", "algebraically", "allegorically",
    "alliterations", "alphanumerics", "alternatively", "amalgamations",
    "ambassadorial", "ambitiousness", "amniocenteses", "amniocentesis",
    "amorphousness", "amplification", "anachronistic", "angioplasties",
    "anniversaries", "announcements", "antibacterial", "anticipations",
    "anticlimactic", "anticlockwise", "anticoagulant", "antihistamine",
    "antimacassars", "antiparticles", "antipersonnel", "apathetically",
    "applicability", "apportionment", "appreciations", "apprehensions",
    "appropriately", "appropriating", "appropriation", "approximately",
    "approximating", "approximation", "appurtenances", "arachnophobia",
    "arbitrariness", "archaeologist", "archbishopric", "archduchesses",
    "architectural", "architectures", "argumentation", "argumentative",
    "aristocracies", "articulations", "artificiality", "ascertainable",
    "asphyxiations", "assassinating", "assassination", "assemblywoman",
    "assemblywomen", "assertiveness", "assiduousness", "asthmatically",
    "astonishingly", "astrophysical", "atrociousness", "attentiveness",
    "attributively", "audaciousness", "augmentations", "authentically",
    "authenticated", "authenticates", "authoritarian", "authoritative",
    "autobiography", "automatically", "axiomatically", "baccalaureate",
    "bacchanalians", "backstretches", "bantamweights", "battlegrounds",
    "beatification", "belligerently", "beneficiaries", "bewilderingly",
    "bibliographer", "bibliographic", "bicentenaries", "bicentennials",
    "bidirectional", "biodegradable", "biophysicists", "biotechnology",
    "blabbermouths", "blackberrying", "blackcurrants", "blandishments",
    "blasphemously", "bloodcurdling", "bluestockings", "blunderbusses",
    "boardinghouse", "bougainvillea", "bouillabaisse", "boysenberries",
    "brainchildren", "brainstorming", "breakthroughs", "breastfeeding",
    "breaststrokes", "breathalysers", "breathalyzers", "brokenhearted",
    "brotherliness", "bulletproofed", "bumptiousness", "bureaucracies",
    "businesswoman", "businesswomen", "butterfingers", "cabinetmakers",
    "calligraphers", "campanologist", "cancellations", "cannibalistic",
    "cannonballing", "cantilevering", "capaciousness", "capitulations",
    "carbohydrates", "carboniferous", "cardiologists", "caricaturists",
    "carpetbaggers", "carpetbagging", "cartilaginous", "cartographers",
    "categorically", "ceremoniously", "certificating", "certification",
    "chairmanships", "championships", "chancelleries", "changeability",
    "characterless", "charioteering", "chastisements", "cheerlessness",
    "cheeseburgers", "childlessness", "childproofing", "chiropractics",
    "chiropractors", "chloroforming", "choreographed", "choreographer",
    "choreographic", "chronological", "chrysanthemum", "churchwardens",
    "circumcisions", "circumference", "circumscribed", "circumscribes",
    "circumspectly", "circumstanced", "circumstances", "circumventing",
    "circumvention", "clandestinely", "clapperboards", "clarification",
    "classlessness", "clearinghouse", "climatologist", "clotheslining",
    "codifications", "coeducational", "collaborating", "collaboration",
    "collaborative", "collaborators", "collectivists", "colloquialism",
    "combativeness", "commandeering", "commemorating", "commemoration",
    "commemorative", "commencements", "commendations", "commensurable",
    "commercialism", "commiserating", "commiseration", "commissariats",
    "commissioners", "commissioning", "commonalities", "commonwealths",
    "communicating", "communication", "communicative", "communicators",
    "companionable", "companionably", "companionship", "companionways",
    "comparability", "comparatively", "compassionate", "compatibility",
    "compensations", "competitively", "complaisantly", "complementary",
    "complementing", "complications", "complimentary", "complimenting",
    "comprehending", "comprehension", "comprehensive", "computational",
    "concatenating", "concatenation", "concentrating", "concentration",
    "concertinaing", "concertmaster", "concessionary", "concomitantly",
    "condemnations", "condensations", "condescending", "condescension",
    "conditionally", "conductresses", "confectioners", "confectionery",
    "confederacies", "confederating", "confederation", "confessionals",
    "configuration", "confirmations", "confiscations", "conflagration",
    "conformations", "confrontation", "conglomerated", "conglomerates",
    "congratulated", "congratulates", "congregations", "congressional",
    "congresswoman", "congresswomen", "conquistadors", "consanguinity",
    "conscientious", "consciousness", "consecrations", "consecutively",
    "consequential", "conservancies", "conservatives", "conservatoire",
    "considerately", "consideration", "consistencies", "consolidating",
    "consolidation", "conspicuously", "constellation", "consternation",
    "constitutions", "constrictions", "constructions", "consultancies",
    "consultations", "consummations", "contaminating", "contamination",
    "contemplating", "contemplation", "contemplative", "contentedness",
    "contentiously", "contingencies", "continuations", "contortionist",
    "contraception", "contraceptive", "contractually", "contradicting",
    "contradiction", "contradictory", "contravention", "contributions",
    "controversial", "controversies", "controverting", "convalescence",
    "convalescents", "conventioneer", "conversations", "cooperatively",
    "coreligionist", "corespondents", "correspondent", "corresponding",
    "corroborating", "corroboration", "corroborative", "cosignatories",
    "cosmetologist", "cosmopolitans", "countenancing", "counteracting",
    "counteraction", "counterattack", "counterblasts", "counterclaims",
    "counterfeited", "counterfeiter", "countermanded", "counteroffers",
    "counterpoints", "countersigned", "countertenors", "countervailed",
    "counterweight", "courteousness", "craftsmanship", "credentialing",
    "credulousness", "criminologist", "crisscrossing", "crossbreeding",
    "crosschecking", "crosscurrents", "cryptographer", "daguerreotype",
    "dauntlessness", "decaffeinated", "decaffeinates", "decapitations",
    "deceitfulness", "deceptiveness", "declassifying", "decommissions",
    "decomposition", "decompressing", "decompression", "decongestants",
    "deconstructed", "decontaminate", "decontrolling", "defectiveness",
    "defensiveness", "deferentially", "defibrillator", "deforestation",
    "dehumidifiers", "dehumidifying", "deliberations", "delicatessens",
    "deliciousness", "delinquencies", "demagogically", "demigoddesses",
    "demonstrating", "demonstration", "demonstrative", "demonstrators",
    "denominations", "denouncements", "denunciations", "dependability",
    "deprecatingly", "deprogramming", "dermatologist", "descriptively",
    "desegregating", "desegregation", "dessertspoons", "destructively",
    "deteriorating", "deterioration", "determination", "deterministic",
    "detrimentally", "devastatingly", "developmental", "diagnostician",
    "diametrically", "dictatorially", "dictatorships", "differentials",
    "differentiate", "dillydallying", "dimensionless", "directionless",
    "directorships", "disadvantaged", "disadvantages", "disafforested",
    "disagreements", "disappearance", "disappointing", "disassembling",
    "disassociated", "disassociates", "disbursements", "discographies",
    "discomforting", "disconcerting", "disconnecting", "disconnection",
    "discontenting", "discontinuing", "discontinuity", "discontinuous",
    "discourtesies", "discreditable", "discreditably", "discrepancies",
    "discretionary", "discriminated", "discriminates", "disemboweling",
    "disenchanting", "disencumbered", "disengagement", "disentangling",
    "disfigurement", "disfranchised", "disfranchises", "disgracefully",
    "disharmonious", "disheartening", "disillusioned", "disincentives",
    "disinfectants", "disinheriting", "disintegrated", "disintegrates",
    "disinterested", "disinvestment", "dismemberment", "disobediently",
    "disorientated", "disorientates", "disparagement", "disparagingly",
    "dispassionate", "dispensations", "displacements", "dispossessing",
    "dispossession", "disproportion", "disqualifying", "disquisitions",
    "disrespectful", "disrespecting", "dissatisfying", "disseminating",
    "dissemination", "dissertations", "dissimilarity", "dissimulating",
    "dissimulation", "dissoluteness", "distastefully", "distillations",
    "distinctively", "distinguished", "distinguishes", "distressingly",
    "distributions", "distrustfully", "documentaries", "documentation",
    "domesticating", "domestication", "draughtboards", "draughtswoman",
    "draughtswomen", "dysfunctional", "eavesdroppers", "eavesdropping",
    "eccentrically", "ecclesiastics", "educationally", "educationists",
    "effectiveness", "effervescence", "efficaciously", "efflorescence",
    "egocentricity", "egotistically", "elaborateness", "electioneered",
    "electrocuting", "electrocution", "electromagnet", "electroplated",
    "electroplates", "electrostatic", "elocutionists", "embarrassment",
    "embellishment", "embryological", "embryologists", "encapsulating",
    "encapsulation", "enchantresses", "encouragement", "encouragingly",
    "encroachments", "encrustations", "encyclopedias", "energetically",
    "enfranchising", "enigmatically", "enlightenment", "entanglements",
    "entertainment", "enthronements", "entomological", "entomologists",
    "entrenchments", "entrepreneurs", "environmental", "equestriennes",
    "equivocations", "ergonomically", "escapologists", "establishment",
    "estrangements", "ethnocentrism", "ethnographers", "eventualities",
    "everlastingly", "exaggeratedly", "exaggerations", "exasperatedly",
    "exceptionable", "exceptionally", "exclusiveness", "excommunicate",
    "exhibitionism", "exhibitionist", "existentially", "expansionists",
    "expansiveness", "expectorating", "expectoration", "expeditionary",
    "expeditiously", "experimenters", "experimenting", "explosiveness",
    "exponentially", "expostulating", "expostulation", "expressionism",
    "expressionist", "expropriating", "expropriation", "expropriators",
    "exquisiteness", "extensiveness", "exterminating", "extermination",
    "exterminators", "extinguishers", "extinguishing", "extortionists",
    "extrajudicial", "extraordinary", "extrapolating", "extrapolation",
    "extravagances", "extravagantly", "extravaganzas", "extrinsically",
    "facetiousness", "faithlessness", "falsification", "fantastically",
    "fascinatingly", "featherweight", "felicitations", "ferociousness",
    "filibustering", "fingerprinted", "flabbergasted", "flamethrowers",
    "flirtatiously", "floodlighting", "fluorocarbons", "foolhardiness",
    "foregrounding", "foreknowledge", "foreordaining", "foreshadowing",
    "foreshortened", "forgetfulness", "fortification", "fountainheads",
    "fractiousness", "fragmentation", "frighteningly", "frontbenchers",
    "frontispieces", "fruitlessness", "functionalism", "functionalist",
    "functionality", "functionaries", "fundamentally", "galvanometers",
    "garrulousness", "gastronomical", "generalissimo", "genuflections",
    "geometrically", "geophysicists", "geostationary", "geriatricians",
    "gerontologist", "gerrymandered", "gesticulating", "gesticulation",
    "globetrotters", "globetrotting", "glockenspiels", "glorification",
    "goosestepping", "gracelessness", "grammatically", "grandchildren",
    "granddaughter", "grandfathered", "grandiloquent", "grandstanding",
    "graphologists", "gratification", "gravitational", "groundskeeper",
    "gubernatorial", "guesstimating", "hagiographies", "hairsbreadths",
    "hairsplitting", "halfheartedly", "hallucinating", "hallucination",
    "hallucinatory", "hallucinogens", "handkerchiefs", "happenstances",
    "harbormasters", "hardheartedly", "headquartered", "healthfulness",
    "heartbreaking", "heartlessness", "helicoptering", "hemispherical",
    "hermaphrodite", "herringboning", "heterogeneity", "heterogeneous",
    "heterosexuals", "hieroglyphics", "holidaymakers", "homestretches",
    "homogeneously", "homosexuality", "horseradishes", "horsewhipping",
    "horticultural", "hotheadedness", "housebreakers", "housebreaking",
    "housecleaning", "househusbands", "housemistress", "housewarmings",
    "huckleberries", "humanitarians", "hundredweight", "hydraulically",
    "hydraulicking", "hydroelectric", "hydrogenating", "hyperactivity",
    "hypercritical", "hypochondriac", "hypoglycemics", "ideologically",
    "idiomatically", "idiosyncratic", "ignominiously", "illuminations",
    "illustrations", "imaginatively", "impeccability", "imperceptible",
    "imperceptibly", "imperfections", "imperialistic", "imperiousness",
    "imperishables", "impermissible", "impersonating", "impersonation",
    "impersonators", "impertinences", "impertinently", "imperturbable",
    "imperturbably", "impetuousness", "implacability", "implementable",
    "imponderables", "importunating", "impossibility", "impoverishing",
    "impracticable", "impracticably", "impressionism", "impressionist",
    "imprisonments", "improbability", "improprieties", "improvidently",
    "improvisation", "impulsiveness", "inadvertently", "inappropriate",
    "inarticulates", "inattentively", "inaugurations", "incandescence",
    "incandescents", "incapacitated", "incapacitates", "incarcerating",
    "incarceration", "incombustible", "incommunicado", "incompatibles",
    "incompetently", "inconceivable", "inconceivably", "incongruities",
    "incongruously", "inconsiderate", "inconsistency", "inconspicuous",
    "incontestable", "incontestably", "inconvenience", "incorporating",
    "incorporation", "incorrectness", "incorruptible", "incorruptibly",
    "incredibility", "incredulously", "incrementally", "incriminating",
    "incrimination", "incriminatory", "incrustations", "indefatigable",
    "indefatigably", "independently", "indescribable", "indescribably",
    "indeterminacy", "indeterminate", "indifferently", "indigestibles",
    "indiscernible", "indiscretions", "indispensable", "indispensably",
    "indisposition", "individualism", "individualist", "individuality",
    "indoctrinated", "indoctrinates", "industrialism", "industrialist",
    "industriously", "ineffectively", "ineffectually", "inefficiently",
    "ineligibility", "inevitability", "inexhaustible", "inexhaustibly",
    "inexorability", "inexpensively", "inexperienced", "inexpressible",
    "inexpressibly", "infallibility", "infinitesimal", "inflammations",
    "inflexibility", "inflorescence", "influentially", "informational",
    "infringements", "infuriatingly", "ingenuousness", "injudiciously",
    "innocuousness", "inoffensively", "inopportunely", "inquisitively",
    "inquisitorial", "insectivorous", "insensibility", "insensitively",
    "insensitivity", "insidiousness", "insignificant", "inspectorates",
    "inspirational", "instabilities", "installations", "instantaneous",
    "instinctively", "institutional", "instructional", "instructively",
    "instrumentals", "instrumenting", "insubordinate", "insubstantial",
    "insufficiency", "insupportable", "insurrections", "intellectuals",
    "intelligently", "intemperately", "intentionally", "interactively",
    "interactivity", "interbreeding", "interceptions", "intercessions",
    "interchanging", "interconnects", "interestingly", "intergalactic",
    "interjections", "interlocutors", "interlocutory", "intermarriage",
    "intermarrying", "intermediates", "intermingling", "intermissions",
    "international", "interpersonal", "interpolating", "interpolation",
    "interposition", "interrelating", "interrelation", "interrogating",
    "interrogation", "interrogative", "interrogators", "interrogatory",
    "interruptions", "intersections", "interspersing", "interventions",
    "intransigence", "intransigents", "intransitives", "intravenouses",
    "intravenously", "intrinsically", "introductions", "introspection",
    "introspective", "inventiveness", "invertebrates", "investigating",
    "investigation", "investigative", "investigators", "investigatory",
    "invidiousness", "invincibility", "inviolability", "invitationals",
    "involuntarily", "irrationality", "irrecoverable", "irrecoverably",
    "irredeemables", "irrelevancies", "irreplaceable", "irrepressible",
    "irrepressibly", "irresponsible", "irresponsibly", "irretrievable",
    "irretrievably", "isolationists", "jackhammering", "jitterbugging",
    "jollification", "judiciousness", "jurisdictions", "jurisprudence",
    "justification", "juxtaposition", "kaleidoscopes", "kaleidoscopic",
    "kindergartens", "kleptomaniacs", "knowledgeable", "knowledgeably",
    "knuckleduster", "laboriousness", "lackadaisical", "landownership",
    "laughingstock", "lethargically", "lexicographer", "librarianship",
    "lithographers", "lithographing", "litigiousness", "loathsomeness",
    "ludicrousness", "luncheonettes", "luxuriousness", "macroeconomic",
    "mademoiselles", "magisterially", "magnanimously", "magnetosphere",
    "magnification", "magnificently", "mainstreaming", "maladjustment",
    "maladroitness", "malformations", "malfunctioned", "manageability",
    "manifestation", "manipulations", "mantelshelves", "manufacturers",
    "manufacturing", "marchionesses", "marketability", "masterclasses",
    "masterminding", "masterstrokes", "materialistic", "mathematician",
    "matriculating", "matriculation", "meaninglessly", "meetinghouses",
    "megalomaniacs", "megalopolises", "mellifluously", "melodiousness",
    "melodramatics", "merchandising", "meritocracies", "meritoriously",
    "metalanguages", "metallurgical", "metallurgists", "metamorphosed",
    "metamorphoses", "metamorphosis", "meteorologist", "methodologies",
    "microcomputer", "microorganism", "microwaveable", "middleweights",
    "millionairess", "mimeographing", "mineralogists", "minicomputers",
    "ministrations", "misadventures", "misanthropist", "misapprehends",
    "miscalculated", "miscalculates", "miscegenation", "miscellaneous",
    "mischievously", "misconceiving", "misconception", "misconducting",
    "misconstruing", "misdiagnosing", "misidentified", "misidentifies",
    "misinterprets", "mismanagement", "mispronounced", "mispronounces",
    "misquotations", "misrepresents", "misstatements", "mistranslated",
    "mistrustfully", "misunderstand", "misunderstood", "modifications",
    "mollification", "mollycoddling", "momentousness", "monochromatic",
    "monocotyledon", "mononucleosis", "monosyllables", "monotonically",
    "monstrosities", "morphological", "mortification", "motherfuckers",
    "motherfucking", "motorcyclists", "mountaineered", "mountainsides",
    "mousetrapping", "mouthwatering", "multicultural", "multinational",
    "multiplicands", "multitudinous", "multivitamins", "mummification",
    "musicologists", "mystification", "nationalistic", "nationalities",
    "necessitating", "necrophiliacs", "nefariousness", "neoclassicism",
    "newsworthiest", "niggardliness", "nightclubbing", "nightwatchman",
    "nightwatchmen", "nitroglycerin", "noiselessness", "nomenclatures",
    "nonabsorbents", "nonagenarians", "nonalcoholics", "noncombatants",
    "noncommercial", "noncompliance", "nonconductors", "nonconformism",
    "nonconformist", "nonconformity", "noncontagious", "nondeductible",
    "nonindustrial", "nonjudgmental", "nonnegotiable", "nonproductive",
    "nonrefillable", "nonrefundable", "nonreturnable", "nonsensically",
    "northeasterly", "northeastward", "northwesterly", "northwestward",
    "nostalgically", "notifications", "nullification", "nutritionally",
    "nutritionists", "nymphomaniacs", "objectionable", "objectionably",
    "objectiveness", "obliviousness", "obnoxiousness", "observational",
    "observatories", "obsessionally", "obstetricians", "obstructively",
    "obtrusiveness", "oceanographer", "oceanographic", "octogenarians",
    "offensiveness", "offhandedness", "officeholders", "officiousness",
    "oleomargarine", "operationally", "ophthalmology", "opportunistic",
    "opportunities", "orchestrating", "orchestration", "ornamentation",
    "ornithologist", "orthodontists", "orthogonality", "orthographies",
    "oscilloscopes", "outdistancing", "outperforming", "outspokenness",
    "outstandingly", "outstretching", "overabundance", "overachievers",
    "overachieving", "overambitious", "overbalancing", "overburdening",
    "overconfident", "overdeveloped", "overestimated", "overestimates",
    "overextending", "overindulging", "overpopulated", "overpopulates",
    "overproducing", "overqualified", "overreactions", "oversensitive",
    "overshadowing", "overspreading", "overstatement", "overstretched",
    "overstretches", "oversubscribe", "oversupplying", "overvaluation",
    "overweeningly", "overwintering", "painstakingly", "palaeontology",
    "pantechnicons", "paradoxically", "parallelogram", "paraphernalia",
    "parasitically", "parenthetical", "parliamentary", "participating",
    "participation", "participators", "participatory", "particularity",
    "passionflower", "passivisation", "passivization", "paterfamilias",
    "paternalistic", "patriotically", "peculiarities", "pedagogically",
    "pediatricians", "perambulating", "perambulation", "perambulators",
    "percussionist", "peregrination", "perfectionism", "perfectionist",
    "perfunctorily", "perpendicular", "personalities", "perspicacious",
    "perturbations", "pervasiveness", "petrochemical", "pharmacopoeia",
    "phenobarbital", "phenomenology", "philanthropic", "philharmonics",
    "philodendrons", "philosophical", "photoelectric", "photographers",
    "photographing", "photostatting", "phrenologists", "physiognomies",
    "physiological", "physiologists", "physiotherapy", "picturesquely",
    "piezoelectric", "pigheadedness", "platitudinous", "pneumatically",
    "pointlessness", "policyholders", "poliomyelitis", "polypropylene",
    "polysyllables", "ponderousness", "pontificating", "pornographers",
    "possibilities", "postgraduates", "postmodernism", "postmodernist",
    "postoperative", "postponements", "powerlessness", "practitioners",
    "pragmatically", "precautionary", "precipitately", "precipitating",
    "precipitation", "precipitously", "preconceiving", "preconception",
    "preconditions", "predetermined", "predeterminer", "predetermines",
    "predicatively", "predilections", "predominantly", "predominately",
    "predominating", "prefabricated", "prefabricates", "preliminaries",
    "premeditating", "premeditation", "preoccupation", "preponderance",
    "preponderated", "preponderates", "prepositional", "prepositioned",
    "prepossessing", "preregistered", "prerequisites", "prescriptions",
    "presentations", "presentiments", "preservatives", "pretentiously",
    "preternatural", "prevaricating", "prevarication", "prevaricators",
    "preventatives", "primitiveness", "primogeniture", "prizefighters",
    "prizefighting", "probabilistic", "probabilities", "problematical",
    "processionals", "processioning", "proclamations", "procrastinate",
    "professionals", "professorship", "profitability", "prognosticate",
    "programmables", "progressively", "prohibitively", "projectionist",
    "proliferating", "proliferation", "prolongations", "promiscuously",
    "pronounceable", "pronouncement", "pronunciation", "propagandists",
    "prophetically", "prophylactics", "proportionals", "proportionate",
    "proportioning", "propositional", "propositioned", "proprietaries",
    "proprietorial", "proscriptions", "protectionism", "protectionist",
    "protectorates", "protestations", "protuberances", "provincialism",
    "provisionally", "provocatively", "psephologists", "psychiatrists",
    "psychoanalyst", "psychokinesis", "psychokinetic", "psychological",
    "psychologists", "psychopathics", "psychosomatic", "psychotherapy",
    "punctiliously", "puritanically", "purposelessly", "pusillanimity",
    "pusillanimous", "quadraphonics", "quadrilateral", "quadriplegics",
    "quadruplicate", "qualification", "qualitatively", "quarterbacked",
    "quarterfinals", "quartermaster", "questioningly", "questionnaire",
    "quintessences", "radioactivity", "radiographers", "radioisotopes",
    "ramifications", "rapaciousness", "rapprochement", "rationalistic",
    "reactionaries", "readabilities", "readjustments", "reaffirmation",
    "realistically", "reappearances", "reappointment", "reapportioned",
    "rearrangement", "reassessments", "recalcitrance", "recapitulated",
    "recapitulates", "receptionists", "receptiveness", "reciprocating",
    "reciprocation", "reclassifying", "recollections", "recombination",
    "recompilation", "reconditioned", "reconsidering", "reconstituted",
    "reconstitutes", "reconstructed", "recriminating", "recrimination",
    "recriminatory", "recrudescence", "rectification", "redevelopment",
    "rediscoveries", "rediscovering", "redistributed", "redistributes",
    "redistricting", "reestablished", "reestablishes", "reforestation",
    "reformatories", "reformulating", "refrigerating", "refrigeration",
    "refrigerators", "refurbishment", "regimentation", "registrations",
    "regurgitating", "regurgitation", "rehabilitated", "rehabilitates",
    "reimbursement", "reincarnating", "reincarnation", "reinforcement",
    "reinstatement", "reinterpreted", "relationships", "relinquishing",
    "reminiscences", "reminiscently", "remonstrances", "remonstrating",
    "remorselessly", "remunerations", "rendezvousing", "renegotiating",
    "renunciations", "repatriations", "repercussions", "replenishment",
    "repossessions", "reprehensible", "reprehensibly", "reproachfully",
    "reproducibles", "reproductions", "reprogramming", "republicanism",
    "repulsiveness", "requisitioned", "resentfulness", "resourcefully",
    "resplendently", "restaurateurs", "restrictively", "restructuring",
    "resurrections", "resuscitating", "resuscitation", "resuscitators",
    "retentiveness", "reticulations", "retrenchments", "retroactively",
    "retrogressing", "retrogression", "retrogressive", "retrospecting",
    "retrospection", "retrospective", "reunification", "reupholstered",
    "reverberating", "reverberation", "reverentially", "reversibility",
    "revolutionary", "revolutionist", "rhododendrons", "righteousness",
    "rollerblading", "rollerskating", "rubberneckers", "rubbernecking",
    "sacrificially", "sadomasochism", "sadomasochist", "salaciousness",
    "sanctimonious", "sarcastically", "sarsaparillas", "satisfactions",
    "scandalmonger", "scatterbrains", "schadenfreude", "schematically",
    "schizophrenia", "schizophrenic", "scholasticism", "schoolmarmish",
    "schoolmasters", "schoolteacher", "scintillating", "scintillation",
    "screenwriters", "screenwriting", "scriptwriters", "seaworthiness",
    "secessionists", "secretiveness", "sedimentation", "seductiveness",
    "seismographic", "seismological", "seismologists", "semiautomatic",
    "semiconductor", "semiconscious", "semifinalists", "semimonthlies",
    "semipermeable", "sensationally", "senselessness", "sensibilities",
    "sensitiveness", "sensitivities", "sententiously", "sentimentally",
    "sequestrating", "sequestration", "serendipitous", "sexagenarians",
    "shamelessness", "shapelessness", "sharecroppers", "shareholdings",
    "sharpshooters", "shepherdesses", "shiftlessness", "shortchanging",
    "shuffleboards", "shuttlecocked", "sidesplitting", "significantly",
    "signification", "singularities", "skateboarders", "skateboarding",
    "sledgehammers", "sleeplessness", "smallholdings", "socioeconomic",
    "solicitations", "somersaulting", "somnambulists", "sonsofbitches",
    "sophisticated", "sophisticates", "soporifically", "soundproofing",
    "southeasterly", "southeastward", "southwesterly", "southwestward",
    "spasmodically", "speakerphones", "specification", "spectacularly",
    "spectroscopes", "spectroscopic", "speculatively", "speechwriters",
    "speleologists", "spellcheckers", "spinelessness", "spiritualists",
    "spokespersons", "spontaneously", "sportscasters", "sportscasting",
    "sportsmanlike", "sportsmanship", "sprightliness", "squeamishness",
    "staphylococci", "statelessness", "statesmanlike", "statesmanship",
    "stationmaster", "statistically", "statisticians", "steadfastness",
    "steamrollered", "steeplechases", "stenographers", "stepdaughters",
    "steppingstone", "stereotypical", "stipendiaries", "straightaways",
    "straightedges", "straightening", "straitjackets", "strangleholds",
    "strangulating", "strangulation", "strategically", "stratospheres",
    "stratospheric", "streetwalkers", "strengthening", "strenuousness",
    "streptococcal", "streptococcus", "strikebreaker", "structuralism",
    "structuralist", "stylistically", "subcommittees", "subcontinents",
    "subcontracted", "subcontractor", "sublieutenant", "subordinating",
    "subordination", "subscriptions", "subserviently", "substantially",
    "substantiated", "substantiates", "substitutions", "substructures",
    "sumptuousness", "superabundant", "superannuated", "superannuates",
    "superchargers", "supercharging", "supercomputer", "superficially",
    "superfluously", "superhighways", "superimposing", "superintended",
    "superlatively", "supernaturals", "supernumerary", "superstitions",
    "superstitious", "supplementary", "supplementing", "supplications",
    "suppositories", "supranational", "surreptitious", "swashbucklers",
    "swashbuckling", "swordsmanship", "syllabication", "symbiotically",
    "symmetrically", "synchronicity", "synchronously", "syntactically",
    "synthetically", "tablespoonful", "talkativeness", "tastelessness",
    "technocracies", "technological", "technologists", "telecommuters",
    "telecommuting", "telemarketing", "televangelism", "televangelist",
    "temperamental", "tempestuously", "temporariness", "tendentiously",
    "tenderhearted", "tentativeness", "terminologies", "tessellations",
    "thanksgivings", "theatricality", "thenceforward", "theologically",
    "theoretically", "theoreticians", "thermodynamic", "thermonuclear",
    "thermoplastic", "thermostatics", "thoroughbreds", "thoroughfares",
    "thoroughgoing", "thoughtlessly", "threateningly", "thunderclouds",
    "thundershower", "thunderstorms", "thunderstruck", "tonsillectomy",
    "topographical", "topologically", "tortoiseshell", "totalitarians",
    "toxicological", "toxicologists", "tracheotomies", "traditionally",
    "tragicomedies", "trainspotters", "trainspotting", "transatlantic",
    "transcendence", "transcription", "transfiguring", "transgressing",
    "transgression", "transgressors", "transitioning", "transliterate",
    "transmigrated", "transmigrates", "transmissible", "transmissions",
    "transmittable", "transmutation", "transnational", "transparently",
    "transpiration", "transplanting", "transportable", "transposition",
    "transshipment", "transshipping", "transvestites", "traumatically",
    "treacherously", "triangulation", "triglycerides", "trigonometric",
    "troublemakers", "troubleshoots", "trustworthier", "turbochargers",
    "turbocharging", "typographical", "tyrannosaurus", "unaccompanied",
    "unaccountable", "unaccountably", "unadulterated", "unambiguously",
    "unanticipated", "unappreciated", "unceremonious", "uncertainties",
    "uncomfortable", "uncomfortably", "uncomplaining", "uncomplicated",
    "unconcernedly", "unconditional", "unconquerable", "unconsciously",
    "uncooperative", "uncoordinated", "underachieved", "underachiever",
    "underachieves", "underbrushing", "undercarriage", "undercharging",
    "underclassman", "underclassmen", "underclothing", "undercurrents",
    "underemployed", "underestimate", "underexposing", "undergarments",
    "undergraduate", "underhandedly", "underpinnings", "undershooting",
    "understanding", "understudying", "underwhelming", "undisciplined",
    "unembarrassed", "unemotionally", "unenforceable", "unenlightened",
    "unequivocally", "unexceptional", "unfamiliarity", "unfashionable",
    "unfashionably", "unflinchingly", "unforeseeable", "unforgettable",
    "unforgettably", "unfortunately", "unfriendliest", "ungentlemanly",
    "ungrammatical", "unilateralism", "unimaginative", "unimpeachable",
    "unimplemented", "uninformative", "uninhabitable", "unintelligent",
    "unintentional", "uninteresting", "uninterpreted", "uninterrupted",
    "unjustifiable", "unjustifiably", "unmentionable", "unnecessarily",
    "unobtrusively", "unprecedented", "unpredictable", "unpredictably",
    "unpretentious", "unpreventable", "unquestioning", "unrelentingly",
    "unreliability", "unremittingly", "unselfishness", "unsentimental",
    "unsightliness", "unspectacular", "unsubstantial", "unsupportable",
    "unsustainable", "unsympathetic", "untrustworthy", "unwillingness",
    "upperclassman", "upperclassmen", "valedictorian", "valedictories",
    "vegetarianism", "veggieburgers", "ventriloquism", "ventriloquist",
    "versification", "veterinarians", "videocassette", "viscountesses",
    "vitriolically", "vivaciousness", "voraciousness", "vulnerability",
    "waterproofing", "weatherboards", "weathercocked", "weatherproofs",
    "weightlifters", "weightlifting", "welterweights", "whippoorwills",
    "wholesomeness", "woolgathering", "worthlessness", "wrongheadedly",
    "yellowhammers"
  };

  const char* w_14[] = {
    "abstractnesses", "accommodations", "accompaniments", "accomplishment",
    "accountability", "acupuncturists", "administrating", "administration",
    "administrative", "administrators", "advantageously", "adventitiously",
    "advertisements", "affectionately", "aforementioned", "agglomerations",
    "agglutinations", "aggressiveness", "agribusinesses", "alphabetically",
    "altruistically", "amateurishness", "ambassadorship", "ambidextrously",
    "ambulancewoman", "ambulancewomen", "amplifications", "anthropologist",
    "anticoagulants", "antidepressant", "antihistamines", "antiperspirant",
    "antiseptically", "antithetically", "apologetically", "appendectomies",
    "appreciatively", "apprehensively", "apprenticeship", "appropriations",
    "approximations", "archaeological", "archaeologists", "archbishoprics",
    "arithmetically", "aromatherapist", "articulateness", "assassinations",
    "astrologically", "astronomically", "astrophysicist", "asymmetrically",
    "asymptotically", "asynchronously", "attractiveness", "auspiciousness",
    "authenticating", "authentication", "authoritarians", "autocratically",
    "autosuggestion", "baccalaureates", "backscratching", "bacteriologist",
    "beatifications", "beautification", "benefactresses", "bibliographers",
    "bibliographies", "bloodthirstier", "boardinghouses", "boisterousness",
    "bougainvilleas", "bouillabaisses", "breathlessness", "breathtakingly",
    "brontosauruses", "bulletproofing", "campanologists", "cantankerously",
    "capriciousness", "cardiovascular", "certifications", "characteristic",
    "choreographers", "choreographing", "chrysanthemums", "cinematography",
    "circumferences", "circumlocution", "circumlocutory", "circumnavigate",
    "circumscribing", "circumspection", "circumstancing", "circumstantial",
    "clarifications", "classification", "claustrophobia", "claustrophobic",
    "clearinghouses", "climatologists", "coincidentally", "collaborations",
    "collaboratives", "colloquialisms", "combustibility", "commemorations",
    "commensurately", "commiserations", "commissionaire", "communications",
    "comprehensible", "comprehensibly", "comprehensions", "comprehensives",
    "compulsiveness", "concatenations", "concentrations", "concentrically",
    "concertmasters", "concessionaire", "confederations", "confidentially",
    "configurations", "conflagrations", "confrontations", "conglomerating",
    "conglomeration", "congratulating", "congratulation", "congratulatory",
    "congregational", "conjunctivitis", "conservatively", "conservatoires",
    "conservatories", "considerations", "consolidations", "conspiratorial",
    "constabularies", "constellations", "constituencies", "constitutional",
    "constructively", "contemplatives", "contemporaries", "contemptuously",
    "contortionists", "contraceptives", "contradictions", "contraventions",
    "convalescences", "conventionally", "conventioneers", "conversational",
    "convertibility", "coreligionists", "correspondence", "correspondents",
    "corroborations", "cosmetologists", "counteractions", "counterattacks",
    "counterbalance", "counterclaimed", "counterculture", "counterexample",
    "counterfeiters", "counterfeiting", "countermanding", "countermeasure",
    "counterpointed", "countersigning", "countersinking", "countervailing",
    "counterweights", "criminologists", "cryptographers", "daguerreotyped",
    "daguerreotypes", "decaffeinating", "decommissioned", "deconstructing",
    "deconstruction", "decontaminated", "decontaminates", "defibrillators",
    "democratically", "demonstrations", "demonstratives", "denominational",
    "dermatologists", "determinations", "detoxification", "diagnosticians",
    "differentiated", "differentiates", "diplomatically", "disadvantaging",
    "disafforesting", "disambiguation", "disappearances", "disappointment",
    "disapprobation", "disapprovingly", "disarrangement", "disassociating",
    "disbelievingly", "disciplinarian", "discombobulate", "disconnectedly",
    "disconnections", "disconsolately", "discontentedly", "discontentment",
    "discontinuance", "discountenance", "discouragement", "discouragingly",
    "discourteously", "discriminating", "discrimination", "discriminatory",
    "disembarkation", "disenchantment", "disencumbering", "disenfranchise",
    "disengagements", "disequilibrium", "disestablished", "disestablishes",
    "disfigurements", "disfranchising", "disillusioning", "disinclination",
    "disinformation", "disingenuously", "disintegrating", "disintegration",
    "disorderliness", "disorientating", "disorientation", "disproportions",
    "distinguishing", "distributional", "eccentricities", "ecclesiastical",
    "educationalist", "egalitarianism", "egocentrically", "electioneering",
    "electrocutions", "electromagnets", "electronically", "electroplating",
    "embarrassingly", "embarrassments", "embellishments", "emblematically",
    "emulsification", "encapsulations", "encouragements", "entertainingly",
    "entertainments", "epidemiologist", "establishments", "ethnologically",
    "etymologically", "exasperatingly", "excommunicated", "excommunicates",
    "excruciatingly", "exhibitionists", "existentialism", "existentialist",
    "experimentally", "exponentiation", "expostulations", "expressionists",
    "expressionless", "expressiveness", "expropriations", "extemporaneous",
    "exterminations", "extinguishable", "extortionately", "extraordinaire",
    "extrapolations", "falsifications", "farsightedness", "fastidiousness",
    "fatalistically", "featherbedding", "featherbrained", "featherweights",
    "fingerprinting", "flabbergasting", "foreshortening", "forthrightness",
    "fortifications", "frontierswoman", "frontierswomen", "functionalists",
    "fundamentalism", "fundamentalist", "genealogically", "generalissimos",
    "gentrification", "geographically", "gerontological", "gerontologists",
    "gerrymandering", "gesticulations", "granddaughters", "grandfathering",
    "grandiloquence", "gratifications", "gratuitousness", "gregariousness",
    "groundbreaking", "groundskeepers", "haberdasheries", "hallucinations",
    "hallucinogenic", "hardheadedness", "harmoniousness", "headmistresses",
    "headquartering", "hermaphrodites", "hermaphroditic", "heterosexually",
    "hierarchically", "hippopotamuses", "histrionically", "horticulturist",
    "hundredweights", "hyperinflation", "hypersensitive", "hyperventilate",
    "hypnotherapist", "hypoallergenic", "hypochondriacs", "hypocritically",
    "hypothetically", "hysterectomies", "idealistically", "identification",
    "idiosyncrasies", "illegitimately", "immaculateness", "impersonations",
    "implausibility", "implementation", "impolitenesses", "impoverishment",
    "impracticality", "impregnability", "impressionable", "impressionists",
    "impressiveness", "improvisations", "inarticulately", "inauspiciously",
    "incapacitating", "incarcerations", "incestuousness", "incommensurate",
    "incompleteness", "inconclusively", "inconsiderable", "inconsistently",
    "inconvenienced", "inconveniences", "inconveniently", "incorruptibles",
    "indecipherable", "indecisiveness", "indescribables", "indestructible",
    "indestructibly", "indeterminable", "indiscriminate", "indispensables",
    "indispositions", "indistinctness", "individualists", "indivisibility",
    "indoctrinating", "indoctrination", "industrialists", "inefficiencies",
    "infectiousness", "infinitesimals", "infrastructure", "ingratiatingly",
    "inscrutability", "inseparability", "insignificance", "insufficiently",
    "insurmountable", "intellectually", "intelligentsia", "interconnected",
    "interdependent", "intermarriages", "intermediaries", "intermittently",
    "internationals", "interpenetrate", "interplanetary", "interpolations",
    "interpretation", "interpretative", "interrelations", "interrogations",
    "interrogatives", "intractability", "intransigently", "intransitively",
    "investigations", "irreconcilable", "irreconcilably", "irregularities",
    "irreproachable", "irreproachably", "jollifications", "jurisdictional",
    "justifications", "juxtapositions", "knickerbockers", "knuckledusters",
    "lasciviousness", "laughingstocks", "legalistically", "lexicographers",
    "licentiousness", "lightheartedly", "linguistically", "longitudinally",
    "lugubriousness", "macroeconomics", "magnifications", "malfunctioning",
    "manifestations", "mathematically", "mathematicians", "meaningfulness",
    "mesdemoiselles", "metamorphosing", "metaphorically", "meteorological",
    "meteorologists", "methodological", "meticulousness", "microbiologist",
    "microcomputers", "microeconomics", "microorganisms", "microprocessor",
    "mindbogglingly", "misanthropists", "misapplication", "misapprehended",
    "misappropriate", "miscalculating", "miscalculation", "misconceptions",
    "misidentifying", "misinformation", "misinterpreted", "mispronouncing",
    "misrepresented", "misunderstands", "monocotyledons", "mountaineering",
    "multinationals", "multiplication", "multiplicative", "multiplicities",
    "municipalities", "mysteriousness", "neocolonialism", "neocolonialist",
    "newspaperwoman", "newspaperwomen", "noncommercials", "noncommittally",
    "noncompetitive", "nonconformists", "noncooperation", "nonrestrictive",
    "nonreturnables", "northeastwards", "northwestwards", "obsequiousness",
    "obstructionism", "obstructionist", "occupationally", "oceanographers",
    "oppressiveness", "optimistically", "orchestrations", "ornithological",
    "ornithologists", "ostentatiously", "osteoarthritis", "outlandishness",
    "overcompensate", "overdeveloping", "overestimating", "overestimation",
    "overindulgence", "overpopulating", "overpopulation", "overpoweringly",
    "overproduction", "overprotective", "oversimplified", "oversimplifies",
    "overstatements", "overstretching", "oversubscribed", "oversubscribes",
    "overvaluations", "overwhelmingly", "paediatricians", "paleontologist",
    "parallelograms", "paramilitaries", "parapsychology", "parsimoniously",
    "passionflowers", "pathologically", "penitentiaries", "perambulations",
    "perceptiveness", "percussionists", "peregrinations", "perfectionists",
    "permissiveness", "perpendiculars", "persuasiveness", "petrochemicals",
    "phantasmagoria", "pharmaceutical", "pharmacologist", "pharmacopoeias",
    "philanthropies", "philanthropist", "phlegmatically", "phosphorescent",
    "photosensitive", "photosynthesis", "polyunsaturate", "portentousness",
    "possessiveness", "postindustrial", "postmistresses", "postmodernists",
    "potentialities", "practicability", "practicalities", "prearrangement",
    "precariousness", "precipitations", "precociousness", "preconceptions",
    "preconditioned", "predestination", "predeterminers", "predetermining",
    "predictability", "predisposition", "prefabricating", "prefabrication",
    "preferentially", "preoccupations", "preponderances", "preponderantly",
    "preponderating", "prepositioning", "preposterously", "preregistering",
    "presumptuously", "presupposition", "prevarications", "principalities",
    "probationaries", "procrastinated", "procrastinates", "procrastinator",
    "productiveness", "professionally", "professorships", "prognosticated",
    "prognosticates", "prognosticator", "prohibitionist", "projectionists",
    "pronouncements", "pronunciations", "proportionally", "propositioning",
    "proprietorship", "proprietresses", "protectionists", "protectiveness",
    "providentially", "psychoanalysis", "psychoanalysts", "psychoanalytic",
    "psychosomatics", "purposefulness", "quadrilaterals", "quadruplicated",
    "quadruplicates", "qualifications", "quantification", "quantitatively",
    "quarterbacking", "quartermasters", "questionnaires", "quintessential",
    "radiotelephone", "radiotherapist", "rapprochements", "reaffirmations",
    "reapportioning", "rearrangements", "reasonableness", "rebelliousness",
    "rebroadcasting", "recapitulating", "recapitulation", "recommendation",
    "reconciliation", "reconditioning", "reconnaissance", "reconstituting",
    "reconstitution", "reconstructing", "reconstruction", "reconstructive",
    "recriminations", "rectifications", "redevelopments", "redistributing",
    "redistribution", "reestablishing", "refurbishments", "rehabilitating",
    "rehabilitation", "reimbursements", "reincarnations", "reinforcements",
    "reinterpreting", "relentlessness", "relinquishment", "representation",
    "representative", "repressiveness", "requisitioning", "respectability",
    "responsibility", "responsiveness", "restructurings", "retrospectives",
    "reupholstering", "reverberations", "revivification", "revolutionists",
    "ridiculousness", "sacrilegiously", "sadomasochists", "sanctification",
    "satisfactorily", "scandalmongers", "scaremongering", "scatterbrained",
    "schizophrenics", "scholastically", "schoolchildren", "schoolmistress",
    "schoolteachers", "scientifically", "segregationist", "semiautomatics",
    "semiconducting", "semiconductors", "sensationalism", "sensationalist",
    "sentimentalism", "sentimentalist", "sentimentality", "septuagenarian",
    "sequestrations", "servomechanism", "shortsightedly", "shuttlecocking",
    "significations", "simplification", "simplistically", "simultaneously",
    "slaughterhouse", "sledgehammered", "sociologically", "sociopolitical",
    "solicitousness", "solidification", "sophisticating", "sophistication",
    "southeastwards", "southwestwards", "specifications", "speechlessness",
    "spiritualistic", "staphylococcus", "stationmasters", "steamrollering",
    "steppingstones", "straitjacketed", "stratification", "strikebreakers",
    "strikebreaking", "structuralists", "stultification", "subconsciously",
    "subcontracting", "subcontractors", "subcutaneously", "sublieutenants",
    "submissiveness", "substantiating", "substantiation", "subversiveness",
    "superabundance", "superannuating", "superannuation", "superciliously",
    "supercomputers", "superconductor", "superficiality", "superintendent",
    "superintending", "supernaturally", "superstructure", "susceptibility",
    "sustainability", "systematically", "tablespoonfuls", "tautologically",
    "technicalities", "teleconference", "telepathically", "teletypewriter",
    "televangelists", "tercentenaries", "terminological", "territoriality",
    "thenceforwards", "thermodynamics", "thermoplastics", "thoughtfulness",
    "thundershowers", "tortoiseshells", "traditionalism", "traditionalist",
    "transcendental", "transcriptions", "transformation", "transgressions",
    "transliterated", "transliterates", "transmigrating", "transmigration",
    "transmogrified", "transmogrifies", "transmutations", "transnationals",
    "transparencies", "transportation", "transpositions", "troubleshooted",
    "troubleshooter", "trustworthiest", "ultrasonically", "unacknowledged",
    "unappreciative", "unapproachable", "unattractively", "uncompromising",
    "unconscionable", "unconscionably", "uncontaminated", "uncontrollable",
    "uncontrollably", "unconventional", "unconvincingly", "uncorroborated",
    "undecipherable", "underachievers", "underachieving", "undercarriages",
    "underdeveloped", "underestimated", "underestimates", "undergraduates",
    "undermentioned", "undernourished", "undersecretary", "understandable",
    "understandably", "understandings", "understatement", "undesirability",
    "unenthusiastic", "unexpectedness", "unfaithfulness", "unfriendliness",
    "ungratefulness", "unhesitatingly", "unidentifiable", "unidirectional",
    "unintelligible", "unintelligibly", "unmentionables", "unpleasantness",
    "unpremeditated", "unprofessional", "unquestionable", "unquestionably",
    "unsatisfactory", "unscrupulously", "unsuccessfully", "unsurprisingly",
    "utilitarianism", "valedictorians", "ventriloquists", "verisimilitude",
    "videocassettes", "vindictiveness", "vivisectionist", "voluptuousness",
    "weathercocking", "weatherproofed", "weightlessness", "whippersnapper",
    "wholeheartedly"
  };

  const char* w_15[] = {
    "acclimatisation", "acclimatization", "accomplishments",
    "acquisitiveness", "administrations", "aerodynamically",
    "agriculturalist", "ambassadorships", "anthropocentric",
    "anthropological", "anthropologists", "anthropomorphic",
    "antidepressants", "antiperspirants", "apprenticeships",
    "appropriateness", "architecturally", "aromatherapists",
    "astrophysicists", "atherosclerosis", "atmospherically",
    "authentications", "authoritatively", "autobiographies",
    "bacteriological", "bacteriologists", "bibliographical",
    "bloodthirstiest", "cardiopulmonary", "characteristics",
    "chronologically", "cinematographer", "circumlocutions",
    "circumnavigated", "circumnavigates", "circumscription",
    "circumstantials", "classifications", "collaboratively",
    "commissionaires", "compassionately", "competitiveness",
    "comprehensively", "computationally", "concessionaires",
    "condescendingly", "confectioneries", "confidentiality",
    "confrontational", "conglomerations", "congratulations",
    "conscientiously", "consciousnesses", "consequentially",
    "conservationist", "conspicuousness", "constitutionals",
    "contemplatively", "contemporaneous", "contentiousness",
    "controversially", "conventionality", "correspondences",
    "correspondingly", "counterargument", "counterattacked",
    "counterbalanced", "counterbalances", "counterclaiming",
    "countercultures", "counterexamples", "countermeasures",
    "counterpointing", "crystallography", "daguerreotyping",
    "decommissioning", "deconstructions", "decontaminating",
    "decontamination", "demographically", "demonstrability",
    "demonstratively", "demystification", "desertification",
    "dessertspoonful", "destructiveness", "differentiating",
    "differentiation", "disadvantageous", "disappointingly",
    "disappointments", "disciplinarians", "discombobulated",
    "discombobulates", "disconcertingly", "discontinuances",
    "discontinuation", "discontinuities", "discountenanced",
    "discountenances", "discouragements", "disenfranchised",
    "disenfranchises", "disentanglement", "disestablishing",
    "disillusionment", "disinterestedly", "dispassionately",
    "disrespectfully", "dissatisfaction", "dissimilarities",
    "distastefulness", "distinctiveness", "distinguishable",
    "distributorship", "diversification", "educationalists",
    "electrification", "electrodynamics", "electromagnetic",
    "enfranchisement", "entrepreneurial", "environmentally",
    "epidemiological", "epidemiologists", "euphemistically",
    "excommunicating", "excommunication", "exemplification",
    "existentialists", "experimentation", "extracurricular",
    "extraordinaries", "extraordinarily", "flibbertigibbet",
    "flirtatiousness", "fundamentalists", "gastroenteritis",
    "gastronomically", "groundbreakings", "halfheartedness",
    "hallucinogenics", "hardheartedness", "heterosexuality",
    "horticulturists", "housemistresses", "humanitarianism",
    "hypercritically", "hyperventilated", "hyperventilates",
    "hypnotherapists", "identifications", "impecuniousness",
    "impenetrability", "implementations", "impossibilities",
    "impressionistic", "improbabilities", "inaccessibility",
    "inappropriately", "incompatibility", "incomprehension",
    "inconsequential", "inconsiderately", "inconsistencies",
    "inconspicuously", "inconveniencing", "incorrigibility",
    "indemnification", "indeterminately", "indissolubility",
    "individualistic", "industriousness", "ineffectiveness",
    "infinitesimally", "infrastructural", "infrastructures",
    "inquisitiveness", "insignificantly", "instantaneously",
    "instrumentalist", "instrumentality", "instrumentation",
    "insubordination", "insurrectionist", "intellectualism",
    "intelligibility", "intensification", "interchangeable",
    "interchangeably", "intercollegiate", "interconnecting",
    "interconnection", "interdependence", "internationally",
    "interpenetrated", "interpenetrates", "interpretations",
    "interrogatories", "interscholastic", "interventionism",
    "interventionist", "introspectively", "invulnerability",
    "lackadaisically", "levelheadedness", "maintainability",
    "meaninglessness", "mechanistically", "microbiological",
    "microbiologists", "microelectronic", "microprocessors",
    "microscopically", "millionairesses", "misapplications",
    "misapprehending", "misapprehension", "misappropriated",
    "misappropriates", "miscalculations", "mischievousness",
    "misconstruction", "misinterpreting", "misrepresenting",
    "multiplications", "multiprocessing", "nearsightedness",
    "nongovernmental", "noninterference", "nonintervention",
    "nonprescription", "nonprofessional", "nontransferable",
    "notwithstanding", "objectification", "obstructionists",
    "obstructiveness", "ophthalmologist", "overcompensated",
    "overcompensates", "oversimplifying", "oversubscribing",
    "palaeontologist", "paleontologists", "parenthetically",
    "parliamentarian", "parthenogenesis", "particularities",
    "perpendicularly", "personification", "pessimistically",
    "phantasmagorias", "pharmaceuticals", "pharmacological",
    "pharmacologists", "philanthropists", "philosophically",
    "phosphorescence", "photojournalism", "photojournalist",
    "phototypesetter", "physiologically", "physiotherapist",
    "picturesqueness", "plainclothesman", "plainclothesmen",
    "plenipotentiary", "polyunsaturated", "polyunsaturates",
    "preconditioning", "predispositions", "preregistration",
    "preservationist", "presuppositions", "pretentiousness",
    "preternaturally", "problematically", "procrastinating",
    "procrastination", "procrastinators", "professionalism",
    "prognosticating", "prognostication", "prognosticators",
    "prohibitionists", "proportionality", "proportionately",
    "proprietorially", "psychologically", "psychopathology",
    "psychotherapies", "psychotherapist", "punctiliousness",
    "purposelessness", "pusillanimously", "quadruplicating",
    "radiotelephones", "radiotherapists", "reafforestation",
    "reapportionment", "recapitulations", "recommendations",
    "reconciliations", "reconfiguration", "reconnaissances",
    "reconsideration", "reconstructions", "representations",
    "representatives", "resourcefulness", "retrospectively",
    "revolutionaries", "ritualistically", "sadomasochistic",
    "sanctimoniously", "segregationists", "sensationalists",
    "sentimentalists", "septuagenarians", "servomechanisms",
    "simplifications", "slaughterhouses", "sledgehammering",
    "straightforward", "straitjacketing", "substantiations",
    "superabundances", "superconductors", "superfluousness",
    "superintendence", "superintendency", "superintendents",
    "supernumeraries", "superstitiously", "superstructures",
    "supplementation", "surreptitiously", "syllabification",
    "sympathetically", "technologically", "teleconferenced",
    "teleconferences", "teletypewriters", "temperamentally",
    "tempestuousness", "tendentiousness", "therapeutically",
    "thoughtlessness", "tonsillectomies", "topographically",
    "totalitarianism", "traditionalists", "transfiguration",
    "transformations", "transliterating", "transliteration",
    "transmogrifying", "transplantation", "trigonometrical",
    "troubleshooters", "troubleshooting", "trustworthiness",
    "typographically", "tyrannosauruses", "unacceptability",
    "unauthenticated", "unceremoniously", "uncommunicative",
    "uncomplainingly", "uncomplimentary", "uncomprehending",
    "unconditionally", "unconsciousness", "uncontroversial",
    "undemonstrative", "underestimating", "underestimation",
    "underprivileged", "understandingly", "understatements",
    "undistinguished", "unexceptionable", "unimplementable",
    "unintentionally", "uninterruptedly", "unobjectionable",
    "unprecedentedly", "unprepossessing", "unpronounceable",
    "unquestioningly", "unrealistically", "unreconstructed",
    "unsophisticated", "unsportsmanlike", "unsubstantiated",
    "upperclasswoman", "upperclasswomen", "vivisectionists",
    "vulnerabilities", "weatherboarding", "weatherproofing",
    "whatchamacallit", "whippersnappers", "wrongheadedness"
  };

  const char* w_16[] = {
    "acquaintanceship", "administratively", "agriculturalists",
    "antagonistically", "anthropomorphism", "apprehensiveness",
    "archaeologically", "aristocratically", "arteriosclerosis",
    "authoritarianism", "autobiographical", "bloodthirstiness",
    "bureaucratically", "cantankerousness", "catastrophically",
    "chauvinistically", "cinematographers", "circumnavigating",
    "circumnavigation", "circumscriptions", "circumstantially",
    "collaborationist", "conservationists", "conspiratorially",
    "constitutionally", "contraindication", "conversationally",
    "counterarguments", "counterattacking", "counterbalancing",
    "counterclockwise", "counterespionage", "counteroffensive",
    "creditworthiness", "crystallographic", "declassification",
    "dessertspoonfuls", "diagrammatically", "discombobulating",
    "discontinuations", "discountenancing", "disenfranchising",
    "disestablishment", "disfranchisement", "disproportionate",
    "disqualification", "distributorships", "electromagnetism",
    "enthusiastically", "entrepreneurship", "environmentalism",
    "environmentalist", "ethnographically", "excommunications",
    "exemplifications", "expressionlessly", "extemporaneously",
    "extracurriculars", "extraterrestrial", "extraterritorial",
    "flibbertigibbets", "gastrointestinal", "horticulturalist",
    "hydroelectricity", "hypersensitivity", "hyperventilating",
    "hyperventilation", "immunodeficiency", "imperturbability",
    "implausibilities", "impracticability", "inarticulateness",
    "incomprehensible", "incomprehensibly", "incontrovertible",
    "incontrovertibly", "incorruptibility", "indemnifications",
    "indiscriminately", "indispensability", "inextinguishable",
    "instrumentalists", "insurrectionists", "interconnections",
    "intercontinental", "internationalism", "internationalist",
    "interpenetrating", "interpenetration", "interventionists",
    "irresponsibility", "lightheartedness", "melodramatically",
    "methodologically", "microelectronics", "misapprehensions",
    "misappropriating", "misappropriation", "misconstructions",
    "mispronunciation", "misunderstanding", "multiculturalism",
    "multidimensional", "multifariousness", "multimillionaire",
    "neurotransmitter", "nonprofessionals", "nonproliferation",
    "obstreperousness", "ophthalmologists", "orthographically",
    "overcompensating", "overcompensation", "overenthusiastic",
    "palaeontologists", "paraprofessional", "parliamentarians",
    "personifications", "phantasmagorical", "phenomenological",
    "photographically", "photojournalists", "phototypesetting",
    "physiotherapists", "praiseworthiness", "predetermination",
    "preservationists", "presumptuousness", "prognostications",
    "psychotherapists", "quintessentially", "rambunctiousness",
    "reinterpretation", "representational", "responsibilities",
    "schoolmistresses", "semiprofessional", "shortsightedness",
    "straightforwards", "superciliousness", "susceptibilities",
    "teleconferencing", "thermostatically", "tintinnabulation",
    "transcendentally", "transcontinental", "transliterations",
    "uncharacteristic", "uncompromisingly", "unconstitutional",
    "unconventionally", "underachievement", "underestimations",
    "undernourishment", "undersecretaries", "undiscriminating",
    "unpredictability", "unprofessionally", "unreasonableness",
    "unrepresentative", "unscrupulousness", "whatchamacallits"
  };

  const char* w_17[] = {
    "anachronistically", "authoritativeness", "circumnavigations",
    "comprehensibility", "comprehensiveness", "conscientiousness",
    "constitutionalism", "constitutionality", "contemporaneously",
    "contradistinction", "contraindications", "conversationalist",
    "counterinsurgency", "counteroffensives", "counterproductive",
    "counterrevolution", "deconstructionism", "deconstructionist",
    "disadvantageously", "disproportionated", "disproportionates",
    "disqualifications", "electrocardiogram", "environmentalists",
    "extraterrestrials", "horticulturalists", "inappropriateness",
    "incompatibilities", "inconsequentially", "inconsiderateness",
    "inconspicuousness", "indestructibility", "indistinguishable",
    "interdepartmental", "interdisciplinary", "intergovernmental",
    "internationalists", "interrelationship", "kaleidoscopically",
    "maladministration", "materialistically", "misappropriations",
    "misinterpretation", "mispronunciations", "misrepresentation",
    "misunderstandings", "multimillionaires", "neurotransmitters",
    "nondenominational", "opportunistically", "paraprofessionals",
    "philanthropically", "plenipotentiaries", "reinterpretations",
    "sanctimoniousness", "semiprofessionals", "socioeconomically",
    "straightforwardly", "superconductivity", "surreptitiousness",
    "telecommunication", "tintinnabulations", "transcendentalism",
    "transcendentalist", "ultraconservative", "uncomprehendingly",
    "videoconferencing"
  };

  const char* w_18[] = {
    "characteristically", "chlorofluorocarbon", "contradistinctions",
    "conversationalists", "counterrevolutions", "deconstructionists",
    "disenfranchisement", "disproportionately", "disproportionating",
    "electrocardiograms", "electrocardiograph", "hypersensitivities",
    "interchangeability", "intercommunication", "interrelationships",
    "misinterpretations", "misrepresentations", "oversimplification",
    "psychoanalytically", "telecommunications", "transcendentalists",
    "transubstantiation", "ultraconservatives", "unconstitutionally"
  };

  const char* w_19[] = {
    "chlorofluorocarbons", "counterintelligence", "electrocardiographs",
    "incomprehensibility", "individualistically", "interdenominational",
    "nonrepresentational", "oversimplifications", "straightforwardness"
  };

  const char* w_20[] = {
    "counterrevolutionary", "electroencephalogram", "uncharacteristically"
  };

  const char* w_21[] = {
    "electroencephalograms", "electroencephalograph"
  };

  const char* w_22[] = {
    "counterrevolutionaries", "electroencephalographs"
  };

  /// Maximal word length
  const unsigned int max_word_len = 22;

  /// Number of words per given length
  const int n_words[] = {
    1, 26, 66, 633, 2443, 4763, 7585, 10380, 10974, 9724, 7704, 5313, 
    3361, 1905, 849, 405, 162, 67, 24, 9, 3, 2, 2
  };

  /// Dictionary of all word lists
  const char** dict[] = {
    &w_0[0], &w_1[0], &w_2[0], &w_3[0], &w_4[0], &w_5[0], &w_6[0],
    &w_7[0], &w_8[0], &w_9[0], &w_10[0], &w_11[0], &w_12[0], &w_13[0],
    &w_14[0], &w_15[0], &w_16[0], &w_17[0], &w_18[0], &w_19[0],
    &w_20[0], &w_21[0], &w_22[0]
  };

}

// STATISTICS: example-ignore

/* 
 * The original SCOWL README:
 *
 * Spell Checking Oriented Word Lists (SCOWL)
 * Revision 6
 * August 10, 2004
 * by Kevin Atkinson
 * 
 * The SCOWL is a collection of word lists split up in various sizes, and
 * other categories, intended to be suitable for use in spell checkers.
 * However, I am sure it will have numerous other uses as well.
 * 
 * The latest version can be found at http://wordlist.sourceforge.net/
 * 
 * The directory final/ contains the actual word lists broken up into
 * various sizes and categories.  The r/ directory contains Readmes from
 * the various sources used to create this package.
 * 
 * The other directories contain the necessary information to recreate the
 * word lists from the raw data.  Unless you are interested in improving the
 * words lists you should not need to worry about what's here.  See the
 * section on recreating the words lists for more information on what's
 * there.
 * 
 * Except for the special word lists the files follow the following
 * naming convention:
 *   <spelling category>-<classification>.<size>
 * Where the spelling category is one of
 *   english, american, british, british_z, canadian, 
 *   variant_0, varaint_1, variant_2
 * Classification is one of
 *   abbreviations, contractions, proper-names, upper, words
 * And size is one of
 *   10, 20, 35 (small), 40, 50 (medium), 55, 60, 70 (large), 
 *   80 (huge), 95 (insane)
 * The special word lists follow are in the following format:
 *   special-<description>.<size>
 * Where description is one of:
 *   roman-numerals, hacker
 * 
 * When combining the words lists the "english" spelling category should
 * be used as well as one of "american", "british", "british_z" (british
 * with ize spelling), or "canadian".  Great care has been taken so that
 * that only one spelling for any particular word is included in the main
 * list.  When two variants were considered equal I randomly picked one
 * for inclusion in the main word list.  Unfortunately this means that my
 * choice in how to spell a word may not match your choice.  If this is
 * the case you can try including the "variant_0" spelling category which
 * includes most variants which are considered almost equal.  The
 * "variant_1" spelling category include variants which are also
 * generally considered acceptable, and "variant_2" contains variants
 * which are seldom used.
 * 
 * The "abbreviation" category includes abbreviations and acronyms which
 * are not also normal words. The "contractions" category should be self
 * explanatory. The "upper" category includes upper case words and proper
 * names which are common enough to appear in a typical dictionary. The
 * "proper-names" category included all the additional uppercase words.
 * Final the "words" category contains all the normal English words.
 * 
 * To give you an idea of what the words in the various sizes look like
 * here is a sample of 25 random words found only in that size:
 * 
 * 10: began both buffer cause collection content documenting easiest
 *     equally examines expecting first firstly hence inclining
 *     irrelevant justified little logs necessarily ought sadly six
 *     thing visible
 * 
 * 20: chunks commodity contempt contexts cruelty crush dictatorship
 *     disgusted dose elementary evolved frog god hordes notion overdraft
 *     overlong overlook phoning poster recordings sand skull substituted
 *     throughput
 * 
 * 35: aliasing blackouts blowout bluntness corroborated derrick
 *     dredging elopements entrancing excising fellowship flagpole
 *     germination glimpse gondola guidebook madams minimalism minnows
 *     partisans petitions shelling swarmed throng welding
 * 
 * 40: altercation blender castigation chump coffeehouse determiners
 *     doggoning exhibitor finders flophouse gazebo lumbering masochism
 *     mopeds poetically pubic refinance reggae scragglier softhearted
 *     stubbornness teargassed township underclassman whoosh
 * 
 * 50: accumulative adulterant allegorically amorousness astrophysics
 *     camphor coif dickey elusiveness enviousness fakers fetishistic
 *     flippantly headsets liefs midyears myna pacification persiflage
 *     phosphoric pinhole sappy seres unrealistically unworldly
 * 
 * 55: becquerel brickie centralist cine conveyancing courgette
 *     disarmingly garon gobstopper infilling insipidity
 *     internationalist kabuki lyrebirds obscurantism rejigged
 *     revisionist satsuma slapper sozzled sublieutenants teletext vino
 *     wellness wracking
 * 
 * 60: absorber acceptableness adventurousness antifascists arrhythmia
 *     audiology cartage cruses fontanel forelimbs granter hairlike
 *     installers jugglery lappets libbers mandrels micrometeorite
 *     mineshaft reconsecrates saccharides smellable spavined sud timbrel
 * 
 * 70: atomisms benedict carven coxa cyanite detraining diazonium
 *     dogberry dogmatics entresol fatherlessnesses firestone imprecator
 *     laterality legitimisms maxwell microfloppies nonteaching pelerine
 *     pentane pestiferousness piscator profascist tusche twirp
 * 
 * 80: cotransfers embrangled forkednesses giftwrapped globosity hatpegs
 *     hepsters hermitess interspecific inurbanities lamiae
 *     literaehumaniores literatures masulas misbegun plook prerupt
 *     quaalude rosanilin sabbatism scowder subreptive thumbstalls
 *     understrata yakows
 * 
 * 95: anatropal anientise bakshi brouzes corsie daimiote dhaw dislikened
 *     ectoretina fortuitisms guardeen hyperlithuria nonanachronistic
 *     overacceleration pamphletic parma phytolith starvedly
 *     trophoplasmic ulorrhagia undared undertide unplunderously
 *     unworkmanly vasoepididymostomy
 * 
 * And here is a rough count on the number of words in the "english"
 * spelling category for each size:
 * 
 *   Size  Words   Proper Names  Running Total 
 * 
 *    10    5,000                    5,000                
 *    20    8,700                   14,000
 *    35   34,500         200       48,000
 *    40    6,000         500       55,000
 *    50   23,200      17,200       95,000
 *    55    7,500                  103,000
 *    60   16,000      12,800      132,000
 *    70   45,100      34,300      211,000
 *    80  137,000      30,400      379,000
 *    95  198,000      51,800      628,000
 * 
 * (The "Words" column does not include the proper name count.)
 * 
 * Size 35 is the recommended small size, 50 the medium and 70 the large.
 * Sizes 70 and below contain words found in most dictionaries while the
 * 80 size contains all the strange and unusual words people like to use
 * in word games such as Scrabble (TM).  While a lot of the the words in
 * the 80 size are not used very often, they are all generally considered
 * valid words in the English language.  The 95 contains just about every
 * English word in existence and then some.  Many of the words at the 95
 * level will probally not be considered valid english words by most
 * people.  I don't recommend anyone use levels above 70 for spell
 * checking as they contain rarely used words which can hide misspellings
 * of similar more commonly used words.  For example the word "ort" can
 * hide a common typo of "or".  No one should need to use a size larger
 * than 80, the 95 size is labeled insane for a reason.
 * 
 * Accents are present on certain words such as caf in iso8859-1 format.
 * 
 * CHANGES:
 * 
 * From Revision 5 to 6 (August 10, 2004)
 * 
 *   Updated to version 4.0 of the 12dicts package.
 * 
 *   Included the 3esl, 2of4brif, and 5desk list from the new 12dicts
 *   package.  The 3esl was included in the 40 size, the 2of4brif in the
 *   55 size and the 5desk in the 70 size.
 * 
 *   Removed the Ispell word list as it was a source of too many errors.
 *   This eliminated the 65 size.
 * 
 *   Removed clause 4 from the Ispell copyright with permission of Geoff
 *   Kuenning.
 * 
 *   Updated to version 4.1 of VarCon.
 * 
 *   Added the "british_z" spelling category which it British using the
 *   "ize" spelling.
 * 
 * From Revision 4a to 5 (January 3, 2002)
 * 
 *   Added variants that were not really spelling variants (such as
 *   forwards) back into the main list.
 * 
 *   Fixed a bug which caused variants of words to incorrectly appear in
 *   the non-variant lists.
 * 
 *   Moved rarly used inflections of a word into higher number lists.
 * 
 *   Added other inflections of a words based on the following criteria
 *     If the word is in the base form: only include that word.
 *     If the word is in a plural form: include the base word and the plural
 *     If the word is a verb form (other than plural):  include all verb forms
 *     If the word is an ad* form: include all ad* forms
 *     If the word is in a possessive form: also include the non-possessive
 * 
 *   Updated to the latest version of many of the source dictionaries.
 * 
 *   Removed the DEC Word List due to the questionable licence and
 *   because removing it will not seriously decrese the quality of SCOWL
 *   (there are a few less proper names).  
 * 
 * From Revision 4 to 4a (April 4, 2001)
 * 
 *   Reran the scripts on a never version of AGID (3a) which fixes a bug
 *   which caused some common words to be improperly marked as variants.
 * 
 * From Revision 3 to 4 (January 28, 2001)
 * 
 *   Split the variant "spelling category" up into 3 different levels.
 *   
 *   Added words in the Ispell word list at the 65 level.
 * 
 *   Other changes due to using more recent versions of various sources
 *   included a more accurete version of AGID thanks to the word of
 *   Alan Beale
 * 
 * From Revision 2 to 3 (August 18, 2000)
 * 
 *   Renamed special-unix-terms to special-hacker and added a large
 *   number of communly used words within the hacker (not cracker)
 *   community.
 * 
 *   Added a couple more signature words including "newbie".
 * 
 *   Minor changes due to changes in the inflection database.
 * 
 * From Revision 1 to 2 (August 5, 2000)
 * 
 *   Moved the male and female name lists from the mwords package and the
 *   DEC name lists form the 50 level to the 60 level and moved Alan's
 *   name list from the 60 level to the 50 level.  Also added the top
 *   1000 male, female, and last names from the 1990 Census report to the
 *   50 level.  This reduced the number of names in the 50 level from
 *   17,000 to 7,000.
 * 
 *   Added a large number of Uppercase words to the 50 level.
 * 
 *   Properly accented the possessive form of some words.
 * 
 *   Minor other changes due to changes in my raw data files which have
 *   not been released yet.  Email if you are interested in these files.
 * 
 * COPYRIGHT, SOURCES, and CREDITS:
 * 
 * The collective work is Copyright 2000-2004 by Kevin Atkinson as well
 * as any of the copyrights mentioned below:
 * 
 *   Copyright 2000-2004 by Kevin Atkinson
 * 
 *   Permission to use, copy, modify, distribute and sell these word
 *   lists, the associated scripts, the output created from the scripts,
 *   and its documentation for any purpose is hereby granted without fee,
 *   provided that the above copyright notice appears in all copies and
 *   that both that copyright notice and this permission notice appear in
 *   supporting documentation. Kevin Atkinson makes no representations
 *   about the suitability of this array for any purpose. It is provided
 *   "as is" without express or implied warranty.
 * 
 * Alan Beale <biljir@pobox.com> also deserves special credit as he has,
 * in addition to providing the 12Dicts package and being a major
 * contributor to the ENABLE word list, given me an incredible amount of
 * feedback and created a number of special lists (those found in the
 * Supplement) in order to help improve the overall quality of SCOWL.
 * 
 * The 10 level includes the 1000 most common English words (according to
 * the Moby (TM) Words II [MWords] package), a subset of the 1000 most
 * common words on the Internet (again, according to Moby Words II), and
 * frequently class 16 from Brian Kelk's "UK English Wordlist
 * with Frequency Classification".
 * 
 * The MWords package was explicitly placed in the public domain:
 * 
 *     The Moby lexicon project is complete and has
 *     been place into the public domain. Use, sell,
 *     rework, excerpt and use in any way on any platform.
 * 
 *     Placing this material on internal or public servers is
 *     also encouraged. The compiler is not aware of any
 *     export restrictions so freely distribute world-wide.
 * 
 *     You can verify the public domain status by contacting
 * 
 *     Grady Ward
 *     3449 Martha Ct.
 *     Arcata, CA  95521-4884
 * 
 *     grady@netcom.com
 *     grady@northcoast.com
 * 
 * The "UK English Wordlist With Frequency Classification" is also in the
 * Public Domain:
 * 
 *   Date: Sat, 08 Jul 2000 20:27:21 +0100
 *   From: Brian Kelk <Brian.Kelk@cl.cam.ac.uk>
 * 
 *   > I was wondering what the copyright status of your "UK English
 *   > Wordlist With Frequency Classification" word list as it seems to
 *   > be lacking any copyright notice.
 * 
 *   There were many many sources in total, but any text marked
 *   "copyright" was avoided. Locally-written documentation was one
 *   source. An earlier version of the list resided in a filespace called
 *   PUBLIC on the University mainframe, because it was considered public
 *   domain.
 * 
 *   Date: Tue, 11 Jul 2000 19:31:34 +0100
 * 
 *   > So are you saying your word list is also in the public domain?
 * 
 *   That is the intention.
 * 
 * The 20 level includes frequency classes 7-15 from Brian's word list.
 * 
 * The 35 level includes frequency classes 2-6 and words appearing in at
 * least 11 of 12 dictionaries as indicated in the 12Dicts package.  All
 * words from the 12Dicts package have had likely inflections added via
 * my inflection database.
 * 
 * The 12Dicts package and Supplement is in the Public Domain.
 * 
 * The WordNet database, which was used in the creation of the
 * Inflections database, is under the following copyright:
 * 
 *   This software and database is being provided to you, the LICENSEE,
 *   by Princeton University under the following license.  By obtaining,
 *   using and/or copying this software and database, you agree that you
 *   have read, understood, and will comply with these terms and
 *   conditions.:
 * 
 *   Permission to use, copy, modify and distribute this software and
 *   database and its documentation for any purpose and without fee or
 *   royalty is hereby granted, provided that you agree to comply with
 *   the following copyright notice and statements, including the
 *   disclaimer, and that the same appear on ALL copies of the software,
 *   database and documentation, including modifications that you make
 *   for internal use or for distribution.
 * 
 *   WordNet 1.6 Copyright 1997 by Princeton University.  All rights
 *   reserved.
 * 
 *   THIS SOFTWARE AND DATABASE IS PROVIDED "AS IS" AND PRINCETON
 *   UNIVERSITY MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR
 *   IMPLIED.  BY WAY OF EXAMPLE, BUT NOT LIMITATION, PRINCETON
 *   UNIVERSITY MAKES NO REPRESENTATIONS OR WARRANTIES OF MERCHANT-
 *   ABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE
 *   LICENSED SOFTWARE, DATABASE OR DOCUMENTATION WILL NOT INFRINGE ANY
 *   THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * 
 *   The name of Princeton University or Princeton may not be used in
 *   advertising or publicity pertaining to distribution of the software
 *   and/or database.  Title to copyright in this software, database and
 *   any associated documentation shall at all times remain with
 *   Princeton University and LICENSEE agrees to preserve same.
 * 
 * The 40 level includes words from Alan's 3esl list found in version 4.0
 * of his 12dicts package.  Like his other stuff the 3esl list is also in the
 * public domain.
 * 
 * The 50 level includes Brian's frequency class 1, words words appearing
 * in at least 5 of 12 of the dictionaries as indicated in the 12Dicts
 * package, and uppercase words in at least 4 of the previous 12
 * dictionaries.  A decent number of proper names is also included: The
 * top 1000 male, female, and Last names from the 1990 Census report; a
 * list of names sent to me by Alan Beale; and a few names that I added
 * myself.  Finally a small list of abbreviations not commonly found in
 * other word lists is included.
 * 
 * The name files form the Census report is a government document which I
 * don't think can be copyrighted.
 * 
 * The file special-jargon.50 uses common.lst and word.lst from the
 * "Unofficial Jargon File Word Lists" which is derived from "The Jargon
 * File".  All of which is in the Public Domain.  This file also contain
 * a few extra UNIX terms which are found in the file "unix-terms" in the
 * special/ directory.
 * 
 * The 55 level includes words from Alan's 2of4brif list found in version
 * 4.0 of his 12dicts package.  Like his other stuff the 2of4brif is also
 * in the public domain.
 * 
 * The 60 level includes Brian's frequency class 0 and all words
 * appearing in at least 2 of the 12 dictionaries as indicated by the
 * 12Dicts package.  A large number of names are also included: The 4,946
 * female names and the 3,897 male names from the MWords package.
 * 
 * The 70 level includes the 74,550 common dictionary words and the
 * 21,986 names list from the MWords package The common dictionary words,
 * like those from the 12Dicts package, have had all likely inflections
 * added.  The 70 level also included the 5desk list from version 4.0 of
 * the 12Dics package which is the public domain
 * 
 * The 80 level includes the ENABLE word list, all the lists in the
 * ENABLE supplement package (except for ABLE), the "UK Advanced Cryptics
 * Dictionary" (UKACD), the list of signature words in from YAWL package,
 * and the 10,196 places list from the MWords package.
 * 
 * The ENABLE package, mainted by M\Cooper <thegrendel@theriver.com>,
 * is in the Public Domain:
 * 
 *   The ENABLE master word list, WORD.LST, is herewith formally released
 *   into the Public Domain. Anyone is free to use it or distribute it in
 *   any manner they see fit. No fee or registration is required for its
 *   use nor are "contributions" solicited (if you feel you absolutely
 *   must contribute something for your own peace of mind, the authors of
 *   the ENABLE list ask that you make a donation on their behalf to your
 *   favorite charity). This word list is our gift to the Scrabble
 *   community, as an alternate to "official" word lists. Game designers
 *   may feel free to incorporate the WORD.LST into their games. Please
 *   mention the source and credit us as originators of the list. Note
 *   that if you, as a game designer, use the WORD.LST in your product,
 *   you may still copyright and protect your product, but you may *not*
 *   legally copyright or in any way restrict redistribution of the
 *   WORD.LST portion of your product. This *may* under law restrict your
 *   rights to restrict your users' rights, but that is only fair.
 * 
 * UKACD, by J Ross Beresford <ross@bryson.demon.co.uk>, is under the
 * following copyright:
 * 
 *   Copyright (c) J Ross Beresford 1993-1999. All Rights Reserved.
 * 
 *   The following restriction is placed on the use of this publication:
 *   if The UK Advanced Cryptics Dictionary is used in a software package
 *   or redistributed in any form, the copyright notice must be
 *   prominently displayed and the text of this document must be included
 *   verbatim.
 * 
 *   There are no other restrictions: I would like to see the list
 *   distributed as widely as possible.
 * 
 * The 95 level includes the 354,984 single words and 256,772 compound
 * words from the MWords package, ABLE.LST from the ENABLE Supplement,
 * and some additional words found in my part-of-speech database that
 * were not found anywhere else.
 * 
 * Accent information was taken from UKACD.
 * 
 * My VARCON package was used to create the American, British, and
 * Canadian word list. 
 * 
 * Since the original word lists used used in the VARCON package came
 * from the Ispell distribution they are under the Ispell copyright:
 * 
 *   Copyright 1993, Geoff Kuenning, Granada Hills, CA
 *   All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. All modifications to the source code must be clearly marked as
 *      such.  Binary redistributions based on modified source code
 *      must be clearly marked as modified versions in the documentation
 *      and/or other materials provided with the distribution.
 *   (clause 4 removed with permission from Geoff Kuenning)
 *   5. The name of Geoff Kuenning may not be used to endorse or promote
 *      products derived from this software without specific prior
 *      written permission.
 * 
 *   THIS SOFTWARE IS PROVIDED BY GEOFF KUENNING AND CONTRIBUTORS ``AS
 *   IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *   FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL GEOFF
 *   KUENNING OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *   BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *   CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *   POSSIBILITY OF SUCH DAMAGE.
 * 
 * The variant word lists were created from a list of variants found in
 * the 12dicts supplement package as well as a list of variants I created
 * myself.
 * 
 * The Readmes for the various packages used can be found in the
 * appropriate directory under the r/ directory.
 * 
 * FUTURE PLANS:
 * 
 * There is a very nice frequency analyse of the BNC corpus done by
 * Adam Kilgarriff.  Unlike Brain's word lists the BNC lists include part
 * of speech information.  I plan on somehow using these lists as Adam
 * Kilgarriff has given me the OK to use it in SCOWL.  These lists will
 * greatly reduce the problem of inflected forms of a word appearing at
 * different levels due to the part-of-speech information.
 * 
 * I also plan on perhaps putting the data in a database and use SQL
 * queries to create the wordlists instead of tons of "sort"s, "comm"s,
 * and Perl scripts.
 * 
 * RECREATING THE WORD LISTS:
 * 
 * In order to recreate the word lists you need a modern version of
 * Perl, bash, the traditional set of shell utilities, a system that
 * supports symbolic links, and quite possibly GNU Make.  Once you
 * have downloaded all the necessary raw data in the r/ directory you
 * should be able to type "rm -r final && mkdir final && make all" and
 * the word lists in the final/ directory should be recreated.  If you
 * have any problems fell free to contact me; however, unless you are
 * interested in improving the scripts used, I will likely ignore you
 * as there should be little need for anyone not interested in
 * improving the word list to do so.
 * 
 * The src/ directory contains the numerous scripts used in the creation
 * of the final product. 
 * 
 * The r/ directory contains the raw data used to
 * create the final product.  In order for the scripts to work various
 * word lists and databases need to be created and put into this
 * directory.  See the README file in the r/ directory for more
 * information.
 * 
 * The l/ directory contains symbolic links used by the actual scripts.
 * 
 * Finally, the working/ directory is where all the intermittent files go
 * that are not specific to one source.
 * 
 */
