/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "apply_scope_settings.h"
 


void create_scope_set_entries(struct w *widgets)
{
    GtkWidget *frame1, *frame2;
    GtkWidget *table1, *table2;
    GtkTooltips *tooltips;

    tooltips = gtk_tooltips_new();
    frame1 = gtk_frame_new(_("Scope settings"));
    frame2 = gtk_frame_new(_("Client settings"));

    /* A table with 3 scope settings and 2 columns */
    table1 = gtk_table_new(3, 2, FALSE);
    /* A table with 13 client settings and 2 columns */
    table2 = gtk_table_new(13, 2, FALSE);

    /* Scope settings */
    gtk_box_pack_start(GTK_BOX(widgets->scope_set_scrolled_vbox), frame1, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame1), table1);
							     /* Max length and input 350 chars */
    widgets->scope_set_entry[0] = make_entry_with_label(GTK_TABLE(table1), _(" Network card: "),       0,1,0,1,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[0], "eth0", NULL);

    widgets->scope_set_entry[1] = make_entry_with_label(GTK_TABLE(table1), _(" Network address: "),     0,1,1,2,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[1], "192.168.0.0", NULL);

    widgets->scope_set_entry[2] = make_entry_with_label(GTK_TABLE(table1), _(" Subnet mask: "),    0,1,2,3,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[2], "255.255.255.0", NULL);


    /* Apply button */
    GtkWidget *scope_set_apply_hbox = gtk_hbox_new(TRUE, FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->scope_set_scrolled_vbox), scope_set_apply_hbox, TRUE, TRUE, 0);

    GtkWidget *scope_settings_apply_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(scope_set_apply_hbox), scope_settings_apply_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(scope_settings_apply_button), "clicked", 
                             G_CALLBACK(apply_scope_settings), widgets);


    /* Client settings */
    gtk_box_pack_start(GTK_BOX(widgets->scope_set_scrolled_vbox), frame2, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(frame2), table2);

    widgets->scope_set_entry[3] = make_entry_with_label(GTK_TABLE(table2), _(" Default lease time: "), 0,1,3,4,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[3], _("6000 (seconds)"), NULL);

    widgets->scope_set_entry[4] = make_entry_with_label(GTK_TABLE(table2), _(" Max lease time: "),     0,1,4,5,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[4], _("7200 (seconds)"), NULL);

    widgets->scope_set_entry[5] = make_entry_with_label(GTK_TABLE(table2),_(" Domain name: "),         0,1,5,6,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[5], _("some.domain.org"), NULL);

    widgets->scope_set_entry[6] = make_entry_with_label(GTK_TABLE(table2),_(" Subnet mask: "),         0,1,6,7,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[6], "255.255.255.0", NULL);

    widgets->scope_set_entry[7] = make_entry_with_label(GTK_TABLE(table2),_(" Broadcast address: "),   0,1,7,8,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[7], "192.168.0.255", NULL);

    widgets->scope_set_entry[8] = make_entry_with_label(GTK_TABLE(table2),_(" Routers: "),             0,1,8,9,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[8], "192.168.0.101 , 192.168.0.102 , 192.168.0.103", NULL);

    widgets->scope_set_entry[9] = make_entry_with_label(GTK_TABLE(table2),_(" Domain name servers: "), 0,1,9,10,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[9], _("10.0.0.1 , 10.0.0.2 , 10.0.0.3"), NULL);

    widgets->scope_set_entry[10] = make_entry_with_label(GTK_TABLE(table2),_(" NIS domain: "),         0,1,10,11,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[10], _("my.nis.domain"), NULL);

    widgets->scope_set_entry[11] = make_entry_with_label(GTK_TABLE(table2),_(" Time offset: "),        0,1,11,12,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[11], _("Specifies the offset of the client's subnet in seconds from Coordinated Universal Time (UTC).\n-18000 is eastern standard time\n-3600 is central european standard time."), NULL);

    widgets->scope_set_entry[12] = make_entry_with_label(GTK_TABLE(table2),_(" NTP servers: "),        0,1,12,13,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[12], "192.168.0.43, 192.168.0.44 , 192.168.0.45", NULL);

    widgets->scope_set_entry[13] = make_entry_with_label(GTK_TABLE(table2),_(" Netbios name servers: "), 0,1,13,14,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[13], "192.168.0.46, 192.168.0.47 , 192.168.0.48", NULL);

    widgets->scope_set_entry[14] = make_entry_with_label(GTK_TABLE(table2),_(" Netboot GRUB menu: "), 0,1,14,15,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[14], _("(nd)/tftpboot/your_OS/menu.lst"), NULL);

    widgets->scope_set_entry[15] = make_entry_with_label(GTK_TABLE(table2),_(" Netboot file: "),  0,1,15,16,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[15], _("/tftpboot/your_OS/netboot_file"), NULL);
}
