#!/usr/bin/env python
#
# Copyright (C) 2007  Kjell Braden
#
# This file is part of GDecrypt.
#
# GDecrypt is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# GDecrypt is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GDecrypt.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup
from distutils.command.install_data import install_data as _install_data
from distutils.command.clean import clean as _clean
from distutils.spawn import spawn
import glob
import sys
import os, gzip
import re

class install_data(_install_data):
	def run (self):
		spawn(("make","-C","po","update-po"), dry_run=self.dry_run)
		for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
			lang = filepath[len("po/mo/"):]
			targetpath = os.path.dirname(os.path.join("share/locale",lang))
			self.data_files.append((targetpath, [filepath]))
		_install_data.run(self)

class clean(_clean):
	def run(self):
		spawn(("make", "-C","po","clean"), dry_run=self.dry_run)
		_clean.run(self)


# look/set what version we have
changelog = "changelog"
if os.path.exists(changelog):
	head=open(changelog).readline()
	match = re.compile(".* (.*) .*").match(head)
	if match:
		version = match.group(1)

try:
	version
except NameError:
	print "Couldn't extract version information!"
	sys.exit(1)

ICONFILES = []
for filepath in glob.glob("icons/hicolor/*/apps/gdecrypt.*"):
	targetpath = os.path.dirname(os.path.join("share", filepath[:-len("gdecrypt.png")]))
	ICONFILES.append((targetpath, [filepath]))

setup(cmdclass={'install_data':install_data, 'clean':clean},
	name='gdecrypt',
	version=version,
	author="Kjell Braden",
	author_email="fnord@pentabarf.de",
	url="http://gdecrypt.pentabarf.de",
	scripts=['gdecrypt'],
	data_files=[('share/applications', ['gdecrypt.desktop']), ('share/gdecrypt', ['main.py','createui.py', 'main.glade', 'createui.glade']), ('share/pixmaps', ['gdecrypt.xpm'])] + ICONFILES)
