/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.31
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif


#include <stdlib.h>
#include <string.h>
#include <stdio.h>


/* Support for throwing C# exceptions from C/C++. There are two types: 
 * Exceptions that take a message and ArgumentExceptions that take a message and a parameter name. */
typedef enum {
  SWIG_CSharpApplicationException,
  SWIG_CSharpArithmeticException,
  SWIG_CSharpDivideByZeroException,
  SWIG_CSharpIndexOutOfRangeException,
  SWIG_CSharpInvalidCastException,
  SWIG_CSharpInvalidOperationException,
  SWIG_CSharpIOException,
  SWIG_CSharpNullReferenceException,
  SWIG_CSharpOutOfMemoryException,
  SWIG_CSharpOverflowException,
  SWIG_CSharpSystemException
} SWIG_CSharpExceptionCodes;

typedef enum {
  SWIG_CSharpArgumentException,
  SWIG_CSharpArgumentNullException,
  SWIG_CSharpArgumentOutOfRangeException
} SWIG_CSharpExceptionArgumentCodes;

typedef void (SWIGSTDCALL* SWIG_CSharpExceptionCallback_t)(const char *);
typedef void (SWIGSTDCALL* SWIG_CSharpExceptionArgumentCallback_t)(const char *, const char *);

typedef struct {
  SWIG_CSharpExceptionCodes code;
  SWIG_CSharpExceptionCallback_t callback;
} SWIG_CSharpException_t;

typedef struct {
  SWIG_CSharpExceptionArgumentCodes code;
  SWIG_CSharpExceptionArgumentCallback_t callback;
} SWIG_CSharpExceptionArgument_t;

static SWIG_CSharpException_t SWIG_csharp_exceptions[] = {
  { SWIG_CSharpApplicationException, NULL },
  { SWIG_CSharpArithmeticException, NULL },
  { SWIG_CSharpDivideByZeroException, NULL },
  { SWIG_CSharpIndexOutOfRangeException, NULL },
  { SWIG_CSharpInvalidCastException, NULL },
  { SWIG_CSharpInvalidOperationException, NULL },
  { SWIG_CSharpIOException, NULL },
  { SWIG_CSharpNullReferenceException, NULL },
  { SWIG_CSharpOutOfMemoryException, NULL },
  { SWIG_CSharpOverflowException, NULL },
  { SWIG_CSharpSystemException, NULL }
};

static SWIG_CSharpExceptionArgument_t SWIG_csharp_exceptions_argument[] = {
  { SWIG_CSharpArgumentException, NULL },
  { SWIG_CSharpArgumentNullException, NULL },
  { SWIG_CSharpArgumentOutOfRangeException, NULL },
};

static void SWIGUNUSED SWIG_CSharpSetPendingException(SWIG_CSharpExceptionCodes code, const char *msg) {
  SWIG_CSharpExceptionCallback_t callback = SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback;
  if (code >=0 && (size_t)code < sizeof(SWIG_csharp_exceptions)/sizeof(SWIG_CSharpException_t)) {
    callback = SWIG_csharp_exceptions[code].callback;
  }
  callback(msg);
}

static void SWIGUNUSED SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpExceptionArgumentCodes code, const char *msg, const char *param_name) {
  SWIG_CSharpExceptionArgumentCallback_t callback = SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback;
  if (code >=0 && (size_t)code < sizeof(SWIG_csharp_exceptions_argument)/sizeof(SWIG_CSharpExceptionArgument_t)) {
    callback = SWIG_csharp_exceptions_argument[code].callback;
  }
  callback(msg, param_name);
}


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionCallbacks_gdal(
                                                SWIG_CSharpExceptionCallback_t applicationCallback,
                                                SWIG_CSharpExceptionCallback_t arithmeticCallback,
                                                SWIG_CSharpExceptionCallback_t divideByZeroCallback, 
                                                SWIG_CSharpExceptionCallback_t indexOutOfRangeCallback, 
                                                SWIG_CSharpExceptionCallback_t invalidCastCallback,
                                                SWIG_CSharpExceptionCallback_t invalidOperationCallback,
                                                SWIG_CSharpExceptionCallback_t ioCallback,
                                                SWIG_CSharpExceptionCallback_t nullReferenceCallback,
                                                SWIG_CSharpExceptionCallback_t outOfMemoryCallback, 
                                                SWIG_CSharpExceptionCallback_t overflowCallback, 
                                                SWIG_CSharpExceptionCallback_t systemCallback) {
  SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback = applicationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpArithmeticException].callback = arithmeticCallback;
  SWIG_csharp_exceptions[SWIG_CSharpDivideByZeroException].callback = divideByZeroCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIndexOutOfRangeException].callback = indexOutOfRangeCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidCastException].callback = invalidCastCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidOperationException].callback = invalidOperationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIOException].callback = ioCallback;
  SWIG_csharp_exceptions[SWIG_CSharpNullReferenceException].callback = nullReferenceCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOutOfMemoryException].callback = outOfMemoryCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOverflowException].callback = overflowCallback;
  SWIG_csharp_exceptions[SWIG_CSharpSystemException].callback = systemCallback;
}

#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionArgumentCallbacks_gdal(
                                                SWIG_CSharpExceptionArgumentCallback_t argumentCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentNullCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentOutOfRangeCallback) {
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback = argumentCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentNullException].callback = argumentNullCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentOutOfRangeException].callback = argumentOutOfRangeCallback;
}


/* Callback for returning strings to C# without leaking memory */
typedef char * (SWIGSTDCALL* SWIG_CSharpStringHelperCallback)(const char *);
static SWIG_CSharpStringHelperCallback SWIG_csharp_string_callback = NULL;


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterStringCallback_gdal(SWIG_CSharpStringHelperCallback callback) {
  SWIG_csharp_string_callback = callback;
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, msg, ""); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




#include <iostream>
using namespace std;

#include "cpl_port.h"
#include "cpl_string.h"

#include "gdal.h"
#include "gdal_priv.h"
#include "gdal_alg.h"
#include "gdalwarper.h"

typedef void GDALMajorObjectShadow;
typedef void GDALDriverShadow;
typedef void GDALDatasetShadow;
typedef void GDALRasterBandShadow;

typedef int FALSE_IS_ERR;



void VeryQuiteErrorHandler(CPLErr eclass, int code, const char *msg ) {
  /* If the error class is CE_Fatal, we want to have a message issued
     because the CPL support code does an abort() before any exception
     can be generated */
  if (eclass == CE_Fatal ) {
    CPLDefaultErrorHandler(eclass, code, msg );
  }
}


void UseExceptions() {
  CPLSetErrorHandler( (CPLErrorHandler) VeryQuiteErrorHandler );
}

void DontUseExceptions() {
  CPLSetErrorHandler( CPLDefaultErrorHandler );
}


SWIGINTERN void SWIG_CSharpException(int code, const char *msg) {
  if (code == SWIG_ValueError) {
    SWIG_CSharpExceptionArgumentCodes exception_code = SWIG_CSharpArgumentOutOfRangeException;
    SWIG_CSharpSetPendingExceptionArgument(exception_code, msg, 0);
  } else {
    SWIG_CSharpExceptionCodes exception_code = SWIG_CSharpApplicationException;
    switch(code) {
    case SWIG_MemoryError:
      exception_code = SWIG_CSharpOutOfMemoryException;
      break;
    case SWIG_IndexError:
      exception_code = SWIG_CSharpIndexOutOfRangeException;
      break;
    case SWIG_DivisionByZero:
      exception_code = SWIG_CSharpDivideByZeroException;
      break;
    case SWIG_IOError:
      exception_code = SWIG_CSharpIOException;
      break;
    case SWIG_OverflowError:
      exception_code = SWIG_CSharpOverflowException;
      break;
    case SWIG_RuntimeError:
    case SWIG_TypeError:
    case SWIG_SyntaxError:
    case SWIG_SystemError:
    case SWIG_UnknownError:
    default:
      exception_code = SWIG_CSharpApplicationException;
      break;
    }
    SWIG_CSharpSetPendingException(exception_code, msg);
  }
}


#include <stdexcept>


GDALDataType GDALRasterBandShadow_get_DataType( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_get_XSize( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_get_YSize( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}
int GDALDatasetShadow_get_RasterXSize( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_get_RasterYSize( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_get_RasterCount( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}
char const *GDALDriverShadow_get_ShortName( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_get_LongName( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_get_HelpTopic( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}


  void Debug( const char *msg_class, const char *message ) {
    CPLDebug( msg_class, message );
  }
  void Error( CPLErr msg_class = CE_Failure, int err_code = 0, const char* msg = "error" ) {
    CPLError( msg_class, err_code, msg );
  }

  CPLErr PushErrorHandler( char const * pszCallbackName = "CPLQuietErrorHandler" ) {
    CPLErrorHandler pfnHandler = NULL;
    if( EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLPushErrorHandler( pfnHandler );

    return CE_None;
  }


SWIGINTERN CPLXMLNode *new_CPLXMLNode(char const *pszString){
        return CPLParseXMLString( pszString );     
    }
SWIGINTERN void delete_CPLXMLNode(CPLXMLNode *self){
        CPLDestroyXMLNode( self );
    }
SWIGINTERN char *CPLXMLNode_SerializeXMLTree(CPLXMLNode *self){
        return CPLSerializeXMLTree( self );
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_SearchXMLNode(CPLXMLNode *self,char const *pszElement){
        return CPLSearchXMLNode(self, pszElement);
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_GetXMLNode(CPLXMLNode *self,char const *pszPath){
        return CPLGetXMLNode( self, pszPath );
    }
SWIGINTERN char const *CPLXMLNode_GetXMLValue(CPLXMLNode *self,char const *pszPath,char const *pszDefault){
        return CPLGetXMLValue( self, pszPath, pszDefault );                    
    }
SWIGINTERN void CPLXMLNode_AddXMLChild(CPLXMLNode *self,CPLXMLNode *psChild){
        return CPLAddXMLChild( self, psChild );
    }
SWIGINTERN int CPLXMLNode_RemoveXMLChild(CPLXMLNode *self,CPLXMLNode *psChild){
        return CPLRemoveXMLChild( self, psChild );
    }
SWIGINTERN void CPLXMLNode_AddXMLSibling(CPLXMLNode *self,CPLXMLNode *psNewSibling){
        return CPLAddXMLSibling( self, psNewSibling );
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_CreateXMLElementAndValue(CPLXMLNode *self,char const *pszName,char const *pszValue){
        return CPLCreateXMLElementAndValue( self, pszName, pszValue );                                 
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_CloneXMLTree(CPLXMLNode *self,CPLXMLNode *psTree){
        return CPLCloneXMLTree( psTree );
    }
SWIGINTERN int CPLXMLNode_SetXMLValue(CPLXMLNode *self,char const *pszPath,char const *pszValue){
        return CPLSetXMLValue( self,  pszPath, pszValue );           
    }
SWIGINTERN void CPLXMLNode_StripXMLNamespace(CPLXMLNode *self,char const *pszNamespace,int bRecurse){
        CPLStripXMLNamespace( self, pszNamespace, bRecurse );                  
    }
SWIGINTERN char const *GDALMajorObjectShadow_GetDescription(GDALMajorObjectShadow *self){
    return GDALGetDescription( self );
  }
SWIGINTERN void GDALMajorObjectShadow_SetDescription(GDALMajorObjectShadow *self,char const *pszNewDesc){
    GDALSetDescription( self, pszNewDesc );
  }
SWIGINTERN char **GDALMajorObjectShadow_GetMetadata_Dict(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
SWIGINTERN char **GDALMajorObjectShadow_GetMetadata_List(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_0(GDALMajorObjectShadow *self,char **papszMetadata,char const *pszDomain=""){
    return GDALSetMetadata( self, papszMetadata, pszDomain );
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_1(GDALMajorObjectShadow *self,char *pszMetadataString,char const *pszDomain=""){
    char *tmpList[2];
    tmpList[0] = pszMetadataString;
    tmpList[1] = 0;
    return GDALSetMetadata( self, tmpList, pszDomain );
  }
SWIGINTERN GDALDatasetShadow *GDALDriverShadow_Create(GDALDriverShadow *self,char const *name,int xsize,int ysize,int bands=1,GDALDataType eType=GDT_Byte,char **options=0){
    GDALDatasetShadow* ds = (GDALDatasetShadow*) GDALCreate( self, name, xsize, ysize, bands, eType, options );
    return ds;
  }
SWIGINTERN GDALDatasetShadow *GDALDriverShadow_CreateCopy(GDALDriverShadow *self,char const *name,GDALDatasetShadow *src,int strict=1,char **options=0){
    GDALDatasetShadow *ds = (GDALDatasetShadow*) GDALCreateCopy(self, name, src, strict, options, 0, 0 );
    return ds;
  }
SWIGINTERN int GDALDriverShadow_Delete(GDALDriverShadow *self,char const *name){
    return GDALDeleteDataset( self, name );
  }
SWIGINTERN int GDALDriverShadow_Register(GDALDriverShadow *self){
    return GDALRegisterDriver( self );
  }
SWIGINTERN void GDALDriverShadow_Deregister(GDALDriverShadow *self){
    GDALDeregisterDriver( self );
  }

char const *GDALDriverShadow_ShortName_get( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_LongName_get( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_HelpTopic_get( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}

SWIGINTERN GDAL_GCP *new_GDAL_GCP(double x=0.0,double y=0.0,double z=0.0,double pixel=0.0,double line=0.0,char const *info="",char const *id=""){
    GDAL_GCP *self = (GDAL_GCP*) CPLMalloc( sizeof( GDAL_GCP ) );
    self->dfGCPX = x;
    self->dfGCPY = y;
    self->dfGCPZ = z;
    self->dfGCPPixel = pixel;
    self->dfGCPLine = line;
    self->pszInfo =  CPLStrdup( (info == 0) ? "" : info );
    self->pszId = CPLStrdup( (id==0)? "" : id );
    return self;
  }
SWIGINTERN void delete_GDAL_GCP(GDAL_GCP *self){
    if ( self->pszInfo )
      CPLFree( self->pszInfo );
    if ( self->pszId )
      CPLFree( self->pszId );
    CPLFree( self );
  }


double GDAL_GCP_GCPX_get( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_GCPX_set( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_GCPY_get( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_GCPY_set( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_GCPZ_get( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_GCPZ_set( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_GCPPixel_get( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_GCPPixel_set( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_GCPLine_get( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_GCPLine_set( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_Info_get( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_Info_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_Id_get( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_Id_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



/* Duplicate, but transposed names for C# because 
*  the C# module outputs backwards names
*/
double GDAL_GCP_get_GCPX( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_set_GCPX( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_get_GCPY( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_set_GCPY( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_get_GCPZ( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_set_GCPZ( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_get_GCPPixel( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_set_GCPPixel( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_get_GCPLine( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_set_GCPLine( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_get_Info( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_set_Info( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_get_Id( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_set_Id( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}





static
CPLErr DSReadRaster_internal( GDALDatasetShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf,
                            int band_list, int *pband_list )
{
  *buf_size = buf_xsize * buf_ysize * (GDALGetDataTypeSize( buf_type ) / 8) * band_list;
  *buf = (char*) malloc( *buf_size );

  CPLErr result = GDALDatasetRasterIO(obj, GF_Read, xoff, yoff, xsize, ysize,
                                (void*) *buf, buf_xsize, buf_ysize, buf_type,
                                band_list, pband_list, 0, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

SWIGINTERN void delete_GDALDatasetShadow(GDALDatasetShadow *self){
    if ( GDALDereferenceDataset( self ) <= 0 ) {
      GDALClose(self);
    }
  }
SWIGINTERN GDALDriverShadow *GDALDatasetShadow_GetDriver(GDALDatasetShadow *self){
    return (GDALDriverShadow*) GDALGetDatasetDriver( self );
  }
SWIGINTERN GDALRasterBandShadow *GDALDatasetShadow_GetRasterBand(GDALDatasetShadow *self,int nBand){
    return (GDALRasterBandShadow*) GDALGetRasterBand( self, nBand );
  }
SWIGINTERN char const *GDALDatasetShadow_GetProjection(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
SWIGINTERN char const *GDALDatasetShadow_GetProjectionRef(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetProjection(GDALDatasetShadow *self,char const *prj){
    return GDALSetProjection( self, prj );
  }
SWIGINTERN void GDALDatasetShadow_GetGeoTransform(GDALDatasetShadow *self,double argout[6]){
    if ( GDALGetGeoTransform( self, argout ) != 0 ) {
      argout[0] = 0.0;
      argout[1] = 1.0;
      argout[2] = 0.0;
      argout[3] = 0.0;
      argout[4] = 0.0;
      argout[5] = 1.0;
    }
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetGeoTransform(GDALDatasetShadow *self,double argin[6]){
    return GDALSetGeoTransform( self, argin );
  }
SWIGINTERN int GDALDatasetShadow_BuildOverviews(GDALDatasetShadow *self,char const *resampling="NEAREST",int overviewlist=0,int *pOverviews=0){
    return GDALBuildOverviews( self, resampling, overviewlist, pOverviews, 0, 0, 0, 0);
  }
SWIGINTERN int GDALDatasetShadow_GetGCPCount(GDALDatasetShadow *self){
    return GDALGetGCPCount( self );
  }
SWIGINTERN char const *GDALDatasetShadow_GetGCPProjection(GDALDatasetShadow *self){
    return GDALGetGCPProjection( self );
  }
SWIGINTERN void GDALDatasetShadow_GetGCPs(GDALDatasetShadow *self,int *nGCPs,GDAL_GCP const **pGCPs){
    *nGCPs = GDALGetGCPCount( self );
    *pGCPs = GDALGetGCPs( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetGCPs(GDALDatasetShadow *self,int nGCPs,GDAL_GCP const *pGCPs,char const *pszGCPProjection){
    return GDALSetGCPs( self, nGCPs, pGCPs, pszGCPProjection );
  }
SWIGINTERN void GDALDatasetShadow_FlushCache(GDALDatasetShadow *self){
    GDALFlushCache( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_AddBand(GDALDatasetShadow *self,GDALDataType datatype=GDT_Byte,char **options=0){
    return GDALAddBand( self, datatype, options );
  }
SWIGINTERN CPLErr GDALDatasetShadow_WriteRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
    return GDALDatasetRasterIO( self, GF_Write, xoff, yoff, xsize, ysize,
                                (void*) buf_string, nxsize, nysize, ntype,
                                band_list, pband_list, 0, 0, 0 );
    if ( myBandList ) {
       CPLFree( pBandList );
    }
  }
SWIGINTERN CPLErr GDALDatasetShadow_ReadRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int *buf_len,char **buf,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){

    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
                            
    return DSReadRaster_internal( self, xoff, yoff, xsize, ysize,
                                nxsize, nysize, ntype,
                                buf_len, buf, 
                                nBandCount, pBandList);
    if ( myBandList ) {
       CPLFree( pBandList );
    }

}

int GDALDatasetShadow_RasterXSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_RasterYSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_RasterCount_get( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}


static
CPLErr ReadRaster_internal( GDALRasterBandShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf )
{

  *buf_size = buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type ) / 8;
  *buf = (char*) malloc( *buf_size );
  CPLErr result =  GDALRasterIO( obj, GF_Read, xoff, yoff, xsize, ysize,
                                 (void *) *buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

static
CPLErr WriteRaster_internal( GDALRasterBandShadow *obj,
                             int xoff, int yoff, int xsize, int ysize,
                             int buf_xsize, int buf_ysize,
                             GDALDataType buf_type,
                             int buf_size, char *buffer )
{
    if ( buf_size < buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type) /8 ) {
      return CE_Failure;
    }

    return GDALRasterIO( obj, GF_Write, xoff, yoff, xsize, ysize, 
		        (void *) buffer, buf_xsize, buf_ysize, buf_type, 0, 0 );
}

SWIGINTERN void GDALRasterBandShadow_GetBlockSize(GDALRasterBandShadow *self,int *pnBlockXSize,int *pnBlockYSize){
      GDALGetBlockSize(self, pnBlockXSize, pnBlockYSize);
  }
SWIGINTERN GDALColorInterp GDALRasterBandShadow_GetRasterColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetRasterColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
SWIGINTERN void GDALRasterBandShadow_GetNoDataValue(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterNoDataValue( self, hasval );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetNoDataValue(GDALRasterBandShadow *self,double d){
    return GDALSetRasterNoDataValue( self, d );
  }
SWIGINTERN void GDALRasterBandShadow_GetMinimum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMinimum( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetMaximum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMaximum( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetOffset(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterOffset( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetScale(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterScale( self, hasval );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_GetStatistics(GDALRasterBandShadow *self,int approx_ok,int force,double *min,double *max,double *mean,double *stddev){
    return GDALGetRasterStatistics( self, approx_ok, force, 
				    min, max, mean, stddev );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetStatistics(GDALRasterBandShadow *self,double min,double max,double mean,double stddev){
    return GDALSetRasterStatistics( self, min, max, mean, stddev );
  }
SWIGINTERN int GDALRasterBandShadow_GetOverviewCount(GDALRasterBandShadow *self){
    return GDALGetOverviewCount( self );
  }
SWIGINTERN GDALRasterBandShadow *GDALRasterBandShadow_GetOverview(GDALRasterBandShadow *self,int i){
    return (GDALRasterBandShadow*) GDALGetOverview( self, i );
  }
SWIGINTERN int GDALRasterBandShadow_Checksum(GDALRasterBandShadow *self,int xoff=0,int yoff=0,int *xsize=0,int *ysize=0){
    int nxsize = (xsize!=0) ? *xsize : GDALGetRasterBandXSize( self );
    int nysize = (ysize!=0) ? *ysize : GDALGetRasterBandYSize( self );
    return GDALChecksumImage( self, xoff, yoff, nxsize, nysize );
  }
SWIGINTERN void GDALRasterBandShadow_ComputeRasterMinMax(GDALRasterBandShadow *self,double argout[2],int approx_ok=0){
    GDALComputeRasterMinMax( self, approx_ok, argout );
  }
SWIGINTERN void GDALRasterBandShadow_ComputeBandStats(GDALRasterBandShadow *self,double argout[2],int samplestep=1){
    GDALComputeBandStats( self, samplestep, argout+0, argout+1, 
                          NULL, NULL );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_Fill(GDALRasterBandShadow *self,double real_fill,double imag_fill=0.0){
    return GDALFillRaster( self, real_fill, imag_fill );
  }
SWIGINTERN void GDALRasterBandShadow_FlushCache(GDALRasterBandShadow *self){
    GDALFlushRasterCache( self );
  }
SWIGINTERN GDALColorTable *GDALRasterBandShadow_GetRasterColorTable(GDALRasterBandShadow *self){
    return (GDALColorTable*) GDALGetRasterColorTable( self );
  }
SWIGINTERN int GDALRasterBandShadow_SetRasterColorTable(GDALRasterBandShadow *self,GDALColorTable *arg){
    return GDALSetRasterColorTable( self, arg );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_ReadRaster(GDALRasterBandShadow *self,int xOff,int yOff,int xSize,int ySize,void *buffer,int buf_xSize,int buf_ySize,GDALDataType buf_type,int pixelSpace,int lineSpace){
       return GDALRasterIO( self, GF_Read, xOff, yOff, xSize, ySize, 
		        buffer, buf_xSize, buf_ySize, buf_type, pixelSpace, lineSpace );
    }
SWIGINTERN CPLErr GDALRasterBandShadow_WriteRaster(GDALRasterBandShadow *self,int xOff,int yOff,int xSize,int ySize,void *buffer,int buf_xSize,int buf_ySize,GDALDataType buf_type,int pixelSpace,int lineSpace){
       return GDALRasterIO( self, GF_Write, xOff, yOff, xSize, ySize, 
		        buffer, buf_xSize, buf_ySize, buf_type, pixelSpace, lineSpace );
    }

GDALDataType GDALRasterBandShadow_DataType_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_XSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_YSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}


int GetDriverCount() {
  return GDALGetDriverCount();
}


GDALDriverShadow* GetDriverByName( char const *name ) {
  return (GDALDriverShadow*) GDALGetDriverByName( name );
}


GDALDriverShadow* GetDriver( int i ) {
  return (GDALDriverShadow*) GDALGetDriver( i );
}


GDALDatasetShadow* Open( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  CPLErrorReset();
  GDALDatasetShadow *ds = GDALOpen( name, eAccess );
  if( ds != NULL && CPLGetLastErrorType() == CE_Failure )
  {
      if ( GDALDereferenceDataset( ds ) <= 0 )
          GDALClose(ds);
      ds = NULL;
  }
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenShared( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  CPLErrorReset();
  GDALDatasetShadow *ds = GDALOpenShared( name, eAccess );
  if( ds != NULL && CPLGetLastErrorType() == CE_Failure )
  {
      if ( GDALDereferenceDataset( ds ) <= 0 )
          GDALClose(ds);
      ds = NULL;
  }
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow *AutoCreateWarpedVRT( GDALDatasetShadow *src_ds,
                                        const char *src_wkt = 0,
                                        const char *dst_wkt = 0,
                                        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour,
                                        double maxerror = 0.0 ) {
  GDALDatasetShadow *ds = GDALAutoCreateWarpedVRT( src_ds, src_wkt,
                                                   dst_wkt,
                                                   eResampleAlg,
                                                   maxerror,
                                                   0 );
  if (ds == 0) {
    /*throw CPLGetLastErrorMsg(); causes a SWIG_exception later*/
  }
  return ds;
  
}


  char **GeneralCmdLineProcessor( char **papszArgv, int nOptions = 0 ) {
    GDALGeneralCmdLineProcessor( CSLCount(papszArgv), &papszArgv, nOptions ); 
    return papszArgv;
  }


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void SWIGSTDCALL CSharp_UseExceptions() {
  UseExceptions();
}


SWIGEXPORT void SWIGSTDCALL CSharp_DontUseExceptions() {
  DontUseExceptions();
}


SWIGEXPORT void SWIGSTDCALL CSharp_Debug(char * jarg1, char * jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    Debug((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Error(int jarg1, int jarg2, char * jarg3) {
  CPLErr arg1 = (CPLErr) CE_Failure ;
  int arg2 = (int) 0 ;
  char *arg3 = (char *) "error" ;
  
  arg1 = (CPLErr)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    Error(arg1,arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_PushErrorHandler__SWIG_0(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) "CPLQuietErrorHandler" ;
  CPLErr result;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLErr)PushErrorHandler((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PushErrorHandler__SWIG_1(void * jarg1) {
  CPLErrorHandler arg1 ;
  CPLErrorHandler *argp1 ;
  
  argp1 = (CPLErrorHandler *)jarg1; 
  if (!argp1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null CPLErrorHandler", 0);
    return ;
  }
  arg1 = *argp1; 
  {
    CPLErrorReset();
    CPLPushErrorHandler(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PopErrorHandler() {
  {
    CPLErrorReset();
    CPLPopErrorHandler();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_ErrorReset() {
  {
    CPLErrorReset();
    CPLErrorReset();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetLastErrorNo() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)CPLGetLastErrorNo();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetLastErrorType() {
  int jresult ;
  CPLErr result;
  
  {
    CPLErrorReset();
    result = (CPLErr)CPLGetLastErrorType();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetLastErrorMsg() {
  char * jresult ;
  char *result = 0 ;
  
  {
    CPLErrorReset();
    result = (char *)CPLGetLastErrorMsg();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PushFinderLocation(char * jarg1) {
  char *arg1 = (char *) 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    CPLPushFinderLocation((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PopFinderLocation() {
  {
    CPLErrorReset();
    CPLPopFinderLocation();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_FinderClean() {
  {
    CPLErrorReset();
    CPLFinderClean();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_FindFile(char * jarg1, char * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (char *)CPLFindFile((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_SetConfigOption(char * jarg1, char * jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    CPLSetConfigOption((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetConfigOption(char * jarg1, char * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (char *)CPLGetConfigOption((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_CPLBinaryToHex(int jarg1, void * jarg2) {
  char * jresult ;
  int arg1 ;
  GByte *arg2 = (GByte *) 0 ;
  char *result = 0 ;
  
  arg1 = (int)jarg1; 
  arg2 = (GByte *)jarg2; 
  {
    CPLErrorReset();
    result = (char *)CPLBinaryToHex(arg1,(GByte const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_CPLHexToBinary(char * jarg1, void * jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  int *arg2 = (int *) 0 ;
  GByte *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (int *)jarg2; 
  {
    CPLErrorReset();
    result = (GByte *)CPLHexToBinary((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_XMLNode_Type_get(void * jarg1) {
  int jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNodeType result;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (CPLXMLNodeType) ((arg1)->eType);
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_Value_get(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (char *) ((arg1)->pszValue);
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_Next_get(void * jarg1) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  _CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (_CPLXMLNode *) ((arg1)->psNext);
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_Child_get(void * jarg1) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  _CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (_CPLXMLNode *) ((arg1)->psChild);
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_XMLNode(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)new_CPLXMLNode((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_XMLNode(void * jarg1) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    delete_CPLXMLNode(arg1);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_SerializeXMLTree(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)CPLXMLNode_SerializeXMLTree(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_SearchXMLNode(void * jarg1, char * jarg2) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_SearchXMLNode(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_GetXMLNode(void * jarg1, char * jarg2) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_GetXMLNode(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_GetXMLValue(void * jarg1, char * jarg2, char * jarg3) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (char *)CPLXMLNode_GetXMLValue(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_XMLNode_AddXMLChild(void * jarg1, void * jarg2) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    CPLXMLNode_AddXMLChild(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_XMLNode_RemoveXMLChild(void * jarg1, void * jarg2) {
  int jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  int result;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    result = (int)CPLXMLNode_RemoveXMLChild(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_XMLNode_AddXMLSibling(void * jarg1, void * jarg2) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    CPLXMLNode_AddXMLSibling(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_CreateXMLElementAndValue(void * jarg1, char * jarg2, char * jarg3) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_CreateXMLElementAndValue(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_CloneXMLTree(void * jarg1, void * jarg2) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_CloneXMLTree(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_XMLNode_SetXMLValue(void * jarg1, char * jarg2, char * jarg3) {
  int jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (int)CPLXMLNode_SetXMLValue(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_XMLNode_StripXMLNamespace(void * jarg1, char * jarg2, int jarg3) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    CPLXMLNode_StripXMLNamespace(arg1,(char const *)arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_MajorObject_GetDescription(void * jarg1) {
  char * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALMajorObjectShadow_GetDescription(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_MajorObject_SetDescription(void * jarg1, char * jarg2) {
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDALMajorObjectShadow_SetDescription(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_MajorObject_GetMetadata_Dict(void * jarg1, char * jarg2) {
  void * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) "" ;
  char **result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (char **)GDALMajorObjectShadow_GetMetadata_Dict(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  {
    /* %typemap(out) char ** -> to hash */
    /*TODO*/
    jresult = 0;
  }
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_MajorObject_GetMetadata_List(void * jarg1, char * jarg2) {
  void * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) "" ;
  char **result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (char **)GDALMajorObjectShadow_GetMetadata_List(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_MajorObject_SetMetadata__SWIG_0(void * jarg1, void * jarg2, char * jarg3) {
  int jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char **arg2 = (char **) 0 ;
  char *arg3 = (char *) "" ;
  CPLErr result;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  {
    /* %typemap(in) char **dict */
    
  }
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_0(arg1,arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  {
    /* %typemap(freearg) char **dict */
    CSLDestroy( arg2 );
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_MajorObject_SetMetadata__SWIG_1(void * jarg1, char * jarg2, char * jarg3) {
  int jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) "" ;
  CPLErr result;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_1(arg1,arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Driver_ShortName_get(void * jarg1) {
  char * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDriverShadow_ShortName_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Driver_LongName_get(void * jarg1) {
  char * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDriverShadow_LongName_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Driver_HelpTopic_get(void * jarg1) {
  char * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDriverShadow_HelpTopic_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Driver_Create(void * jarg1, char * jarg2, int jarg3, int jarg4, int jarg5, int jarg6, void * jarg7) {
  void * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 = (int) 1 ;
  GDALDataType arg6 = (GDALDataType) GDT_Byte ;
  char **arg7 = (char **) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (GDALDataType)jarg6; 
  arg7 = (char **)jarg7; 
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)GDALDriverShadow_Create(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  {
    /* %typemap(freearg) char **options */
    //CSLDestroy( arg7 );
  }
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Driver_CreateCopy(void * jarg1, char * jarg2, void * jarg3, int jarg4, void * jarg5) {
  void * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  GDALDatasetShadow *arg3 = (GDALDatasetShadow *) 0 ;
  int arg4 = (int) 1 ;
  char **arg5 = (char **) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (GDALDatasetShadow *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (char **)jarg5; 
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)GDALDriverShadow_CreateCopy(arg1,(char const *)arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  {
    /* %typemap(freearg) char **options */
    //CSLDestroy( arg5 );
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Driver_Delete(void * jarg1, char * jarg2) {
  int jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALDriverShadow_Delete(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Driver_Register(void * jarg1) {
  int jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  int result;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDriverShadow_Register(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Driver_Deregister(void * jarg1) {
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALDriverShadow_Deregister(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c1_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c1 = arg2;
  
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c1_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c1);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c2_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c2 = arg2;
  
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c2_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c2);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c3_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c3 = arg2;
  
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c3_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c3);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c4_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c4 = arg2;
  
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c4_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c4);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ColorEntry() {
  void * jresult ;
  GDALColorEntry *result = 0 ;
  
  {
    CPLErrorReset();
    result = (GDALColorEntry *)new GDALColorEntry();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ColorEntry(void * jarg1) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  {
    CPLErrorReset();
    delete arg1;
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPX_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPX_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPX_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPX_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPY_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPY_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPY_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPY_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPZ_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPZ_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPZ_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPZ_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPPixel_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPPixel_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPPixel_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPPixel_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPLine_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPLine_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPLine_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPLine_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_Info_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_Info_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GCP_Info_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Info_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_Id_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_Id_set(arg1,arg2);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GCP_Id_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Id_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GCP(double jarg1, double jarg2, double jarg3, double jarg4, double jarg5, char * jarg6, char * jarg7) {
  void * jresult ;
  double arg1 = (double) 0.0 ;
  double arg2 = (double) 0.0 ;
  double arg3 = (double) 0.0 ;
  double arg4 = (double) 0.0 ;
  double arg5 = (double) 0.0 ;
  char *arg6 = (char *) "" ;
  char *arg7 = (char *) "" ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (char *)jarg6; 
  arg7 = (char *)jarg7; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)new_GDAL_GCP(arg1,arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GCP(void * jarg1) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    delete_GDAL_GCP(arg1);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPX_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPX_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPX_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPX_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPY_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPY_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPY_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPY_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPZ_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPZ_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPZ_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPZ_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPPixel_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPPixel_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPPixel_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPPixel_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPLine_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPLine_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPLine_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPLine_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_Info_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Info_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_Info_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_Info_set(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_Id_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Id_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_Id_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_Id_set(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPX(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPX(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPX(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPX(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPY(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPY(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPY(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPY(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPZ(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPZ(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPZ(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPZ(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPPixel(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPPixel(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPPixel(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPPixel(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPLine(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPLine(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPLine(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPLine(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_get_Info(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_get_Info(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_Info(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_Info(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_get_Id(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_get_Id(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_Id(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_set_Id(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GCPsToGeoTransform(int jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  int arg1 ;
  GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
  double *arg3 ;
  int arg4 = (int) 1 ;
  FALSE_IS_ERR result;
  
  arg1 = (int)jarg1; 
  arg2 = (GDAL_GCP *)jarg2; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg3 = (double *)jarg3;
  }
  arg4 = (int)jarg4; 
  {
    CPLErrorReset();
    result = GDALGCPsToGeoTransform(arg1,(GDAL_GCP const *)arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  {
    /* %typemap(out) IF_FALSE_RETURN_NONE */
    
  }
  {
    /* %typemap(ret) IF_FALSE_RETURN_NONE */
    
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RasterXSize_get(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_RasterXSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RasterYSize_get(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_RasterYSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RasterCount_get(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_RasterCount_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Dataset(void * jarg1) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALDatasetShadow(arg1);
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset_GetDriver(void * jarg1) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)GDALDatasetShadow_GetDriver(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset_GetRasterBand(void * jarg1, int jarg2) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALRasterBandShadow *)GDALDatasetShadow_GetRasterBand(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Dataset_GetProjection(void * jarg1) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDatasetShadow_GetProjection(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Dataset_GetProjectionRef(void * jarg1) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDatasetShadow_GetProjectionRef(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_SetProjection(void * jarg1, char * jarg2) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_SetProjection(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset_GetGeoTransform(void * jarg1, void * jarg2) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  double *arg2 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  {
    CPLErrorReset();
    GDALDatasetShadow_GetGeoTransform(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_SetGeoTransform(void * jarg1, void * jarg2) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  double *arg2 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    /* %typemap(in) (double argin[ANY]) */
    arg2 = (double *)jarg2;
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_SetGeoTransform(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_BuildOverviews(void * jarg1, char * jarg2, int jarg3) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) "NEAREST" ;
  int arg3 = (int) 0 ;
  int *arg4 = (int *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    /* %typemap(in,numargs=1) (int nList, int* pList)*/
    /* check if is List */
    
  }
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_BuildOverviews(arg1,(char const *)arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  {
    /* %typemap(freearg) (int nList, int* pList) */
    if (arg4) {
      free((void*) arg4);
    }
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_GetGCPCount(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_GetGCPCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Dataset_GetGCPProjection(void * jarg1) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDatasetShadow_GetGCPProjection(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset_GetGCPs(void * jarg1, void * jarg2, void * jarg3) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int *arg2 = (int *) 0 ;
  GDAL_GCP **arg3 = (GDAL_GCP **) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int *)jarg2; 
  arg3 = (GDAL_GCP **)jarg3; 
  {
    CPLErrorReset();
    GDALDatasetShadow_GetGCPs(arg1,arg2,(GDAL_GCP const **)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_SetGCPs(void * jarg1, int jarg2, void * jarg3, char * jarg4) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
  char *arg4 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDAL_GCP *)jarg3; 
  arg4 = (char *)jarg4; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_SetGCPs(arg1,arg2,(GDAL_GCP const *)arg3,(char const *)arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset_FlushCache(void * jarg1) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALDatasetShadow_FlushCache(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_AddBand(void * jarg1, int jarg2, void * jarg3) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDataType arg2 = (GDALDataType) GDT_Byte ;
  char **arg3 = (char **) 0 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDataType)jarg2; 
  arg3 = (char **)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_AddBand(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  {
    /* %typemap(freearg) char **options */
    //CSLDestroy( arg3 );
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_WriteRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, int jarg6, void * jarg8, void * jarg9, void * jarg10, int jarg11) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  char *arg7 = (char *) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  GDALDataType *arg10 = (GDALDataType *) 0 ;
  int arg11 = (int) 0 ;
  int *arg12 = (int *) 0 ;
  CPLErr result;
  int val8 ;
  int val9 ;
  int val10 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    /* %typemap(in,numinputs=1) (int nLen, char *pBuf ) */
    /*TODO*/
    arg7 = 0;
    arg6 = 0;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in,numargs=1) (int nList, int* pList)*/
    /* check if is List */
    
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  {
    /* %typemap(freearg) (int nList, int* pList) */
    if (arg12) {
      free((void*) arg12);
    }
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_ReadRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg8, void * jarg9, void * jarg10, int jarg11) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  char **arg7 = (char **) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  GDALDataType *arg10 = (GDALDataType *) 0 ;
  int arg11 = (int) 0 ;
  int *arg12 = (int *) 0 ;
  CPLErr result;
  int nLen6 ;
  char *pBuf6 ;
  int val8 ;
  int val9 ;
  int val10 ;
  
  {
    /* %typemap(in,numinputs=0) (int *nLen6, char **pBuf6 ) */
    arg6 = &nLen6;
    arg7 = &pBuf6;
  }
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in,numargs=1) (int nList, int* pList)*/
    /* check if is List */
    
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  {
    /* %typemap(argout) (int *nLen, char **pBuf ) */
    
  }
  {
    /* %typemap(freearg) (int *nLen, char **pBuf ) */
    if( arg6 ) {
      free( *arg7 );
    }
  }
  {
    /* %typemap(freearg) (int nList, int* pList) */
    if (arg12) {
      free((void*) arg12);
    }
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_XSize_get(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_XSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_YSize_get(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_YSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_DataType_get(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALDataType result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDataType)GDALRasterBandShadow_DataType_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetBlockSize(void * jarg1, int * jarg2, int * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int *arg2 = (int *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int *)jarg2; 
  arg3 = (int *)jarg3; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetBlockSize(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetRasterColorInterpretation(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorInterp)GDALRasterBandShadow_GetRasterColorInterpretation(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetRasterColorInterpretation(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALColorInterp)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetRasterColorInterpretation(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetNoDataValue(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetNoDataValue(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetNoDataValue(void * jarg1, double jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetNoDataValue(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetMinimum(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetMinimum(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetMaximum(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetMaximum(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetOffset(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetOffset(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetScale(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetScale(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetStatistics(void * jarg1, int jarg2, int jarg3, double * jarg4, double * jarg5, double * jarg6, double * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  double *arg5 = (double *) 0 ;
  double *arg6 = (double *) 0 ;
  double *arg7 = (double *) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double *)jarg4; 
  arg5 = (double *)jarg5; 
  arg6 = (double *)jarg6; 
  arg7 = (double *)jarg7; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_GetStatistics(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetStatistics(void * jarg1, double jarg2, double jarg3, double jarg4, double jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetStatistics(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetOverviewCount(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_GetOverviewCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetOverview(void * jarg1, int jarg2) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetOverview(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_Checksum(void * jarg1, int jarg2, int jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 = (int) 0 ;
  int arg3 = (int) 0 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  int result;
  int val4 ;
  int val5 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    /* %typemap(in) (int *optional_##int) */
    
  }
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_Checksum(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_ComputeRasterMinMax(void * jarg1, void * jarg2, int jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 ;
  int arg3 = (int) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_ComputeRasterMinMax(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_ComputeBandStats(void * jarg1, void * jarg2, int jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 ;
  int arg3 = (int) 1 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_ComputeBandStats(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_Fill(void * jarg1, double jarg2, double jarg3) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 = (double) 0.0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_Fill(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_FlushCache(void * jarg1) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_FlushCache(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetRasterColorTable(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTable *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTable *)GDALRasterBandShadow_GetRasterColorTable(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetRasterColorTable(void * jarg1, void * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTable *arg2 = (GDALColorTable *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALColorTable *)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_SetRasterColorTable(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_ReadRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int jarg11) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = (void *) 0 ;
  int arg7 ;
  int arg8 ;
  GDALDataType arg9 ;
  int arg10 ;
  int arg11 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (GDALDataType)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_WriteRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int jarg11) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = (void *) 0 ;
  int arg7 ;
  int arg8 ;
  GDALDataType arg9 ;
  int arg10 ;
  int arg11 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (GDALDataType)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ColorTable(int jarg1) {
  void * jresult ;
  GDALPaletteInterp arg1 = (GDALPaletteInterp) GPI_RGB ;
  GDALColorTable *result = 0 ;
  
  arg1 = (GDALPaletteInterp)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTable *)new GDALColorTable(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ColorTable(void * jarg1) {
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  
  arg1 = (GDALColorTable *)jarg1; 
  {
    CPLErrorReset();
    delete arg1;
    
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ColorTable_Clone(void * jarg1) {
  void * jresult ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  GDALColorTable *result = 0 ;
  
  arg1 = (GDALColorTable *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTable *)((GDALColorTable const *)arg1)->Clone();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ColorTable_GetPaletteInterpretation(void * jarg1) {
  int jresult ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  GDALPaletteInterp result;
  
  arg1 = (GDALColorTable *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALPaletteInterp)((GDALColorTable const *)arg1)->GetPaletteInterpretation();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ColorTable_GetCount(void * jarg1) {
  int jresult ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int result;
  
  arg1 = (GDALColorTable *)jarg1; 
  {
    CPLErrorReset();
    result = (int)((GDALColorTable const *)arg1)->GetColorEntryCount();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ColorTable_GetColorEntry(void * jarg1, int jarg2) {
  void * jresult ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int arg2 ;
  GDALColorEntry *result = 0 ;
  
  arg1 = (GDALColorTable *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALColorEntry *)(arg1)->GetColorEntry(arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ColorTable_GetColorEntryAsRGB(void * jarg1, int jarg2, void * jarg3) {
  int jresult ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  int result;
  
  arg1 = (GDALColorTable *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALColorEntry *)jarg3; 
  {
    CPLErrorReset();
    result = (int)((GDALColorTable const *)arg1)->GetColorEntryAsRGB(arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorTable_SetColorEntry(void * jarg1, int jarg2, void * jarg3) {
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  
  arg1 = (GDALColorTable *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALColorEntry *)jarg3; 
  {
    CPLErrorReset();
    (arg1)->SetColorEntry(arg2,(GDALColorEntry const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_AllRegister() {
  {
    CPLErrorReset();
    GDALAllRegister();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetCacheMax() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)GDALGetCacheMax();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_SetCacheMax(int jarg1) {
  int arg1 ;
  
  arg1 = (int)jarg1; 
  {
    CPLErrorReset();
    GDALSetCacheMax(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return ; 
      };
      
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetCacheUsed() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)GDALGetCacheUsed();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetDataTypeSize(int jarg1) {
  int jresult ;
  GDALDataType arg1 ;
  int result;
  
  arg1 = (GDALDataType)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALGetDataTypeSize(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DataTypeIsComplex(int jarg1) {
  int jresult ;
  GDALDataType arg1 ;
  int result;
  
  arg1 = (GDALDataType)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDataTypeIsComplex(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetDataTypeName(int jarg1) {
  char * jresult ;
  GDALDataType arg1 ;
  char *result = 0 ;
  
  arg1 = (GDALDataType)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALGetDataTypeName(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetDataTypeByName(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  GDALDataType result;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDataType)GDALGetDataTypeByName((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetColorInterpretationName(int jarg1) {
  char * jresult ;
  GDALColorInterp arg1 ;
  char *result = 0 ;
  
  arg1 = (GDALColorInterp)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALGetColorInterpretationName(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetPaletteInterpretationName(int jarg1) {
  char * jresult ;
  GDALPaletteInterp arg1 ;
  char *result = 0 ;
  
  arg1 = (GDALPaletteInterp)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALGetPaletteInterpretationName(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_DecToDMS(double jarg1, char * jarg2, int jarg3) {
  char * jresult ;
  double arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 = (int) 2 ;
  char *result = 0 ;
  
  arg1 = (double)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (char *)GDALDecToDMS(arg1,(char const *)arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_PackedDMSToDec(double jarg1) {
  double jresult ;
  double arg1 ;
  double result;
  
  arg1 = (double)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDALPackedDMSToDec(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DecToPackedDMS(double jarg1) {
  double jresult ;
  double arg1 ;
  double result;
  
  arg1 = (double)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDALDecToPackedDMS(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ParseXMLString(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLParseXMLString(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_SerializeXMLTree(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)CPLSerializeXMLTree(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetDriverCount() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)GetDriverCount();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GetDriverByName(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)GetDriverByName((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GetDriver(int jarg1) {
  void * jresult ;
  int arg1 ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)GetDriver(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Open(char * jarg1, int jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALAccess)jarg2; 
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)Open((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_OpenShared(char * jarg1, int jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALAccess)jarg2; 
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)OpenShared((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_AutoCreateWarpedVRT(void * jarg1, char * jarg2, char * jarg3, int jarg4, double jarg5) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  GDALResampleAlg arg4 = (GDALResampleAlg) GRA_NearestNeighbour ;
  double arg5 = (double) 0.0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  arg4 = (GDALResampleAlg)jarg4; 
  arg5 = (double)jarg5; 
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)AutoCreateWarpedVRT(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GeneralCmdLineProcessor(void * jarg1, int jarg2) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  int arg2 = (int) 0 ;
  char **result = 0 ;
  
  arg1 = (char **)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (char **)GeneralCmdLineProcessor(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg()); return 0; 
      };
      
    }
  }
  jresult = result; 
  {
    /* %typemap(freearg) char **options */
    //CSLDestroy( arg1 );
  }
  return jresult;
}


SWIGEXPORT GDALMajorObjectShadow * SWIGSTDCALL CSharp_DriverUpcast(GDALDriverShadow *objectRef) {
    return (GDALMajorObjectShadow *)objectRef;
}

SWIGEXPORT GDALMajorObjectShadow * SWIGSTDCALL CSharp_DatasetUpcast(GDALDatasetShadow *objectRef) {
    return (GDALMajorObjectShadow *)objectRef;
}

SWIGEXPORT GDALMajorObjectShadow * SWIGSTDCALL CSharp_BandUpcast(GDALRasterBandShadow *objectRef) {
    return (GDALMajorObjectShadow *)objectRef;
}

#ifdef __cplusplus
}
#endif

