/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.31
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace OSGeo.GDAL {

using System;
using System.Runtime.InteropServices;

public class Band : MajorObject {
  private HandleRef swigCPtr;

  internal Band(IntPtr cPtr, object cMemoryOwner) : base(gdalPINVOKE.BandUpcast(cPtr), cMemoryOwner) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(Band obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }
  internal static HandleRef getCPtrAndDisown(Band obj, object cMemoryOwner) {
    obj.swigCMemOwner = cMemoryOwner;
    return getCPtr(obj);
  }

  public override void Dispose() {
  lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwner == null) {
        swigCMemOwner = new object();
        throw new MethodAccessException("C++ destructor does not have public access");
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }
/*! Eight bit unsigned integer */ /*@SWIG:%rasterio_functions@*/
 public int ReadRaster(int xOff, int yOff, int xSize, int ySize, byte[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          retval = ReadRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 1, pixelSpace, lineSpace);
          Marshal.Copy(ptr, buffer, 0, buf_xSize * buf_ySize);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  public int WriteRaster(int xOff, int yOff, int xSize, int ySize, byte[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          Marshal.Copy(buffer, 0, ptr, buf_xSize * buf_ySize);
          retval = WriteRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 1, pixelSpace, lineSpace);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  
/*@SWIG@*/
/*! Sixteen bit signed integer */ /*@SWIG:%rasterio_functions@*/
 public int ReadRaster(int xOff, int yOff, int xSize, int ySize, short[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          retval = ReadRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 3, pixelSpace, lineSpace);
          Marshal.Copy(ptr, buffer, 0, buf_xSize * buf_ySize);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  public int WriteRaster(int xOff, int yOff, int xSize, int ySize, short[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          Marshal.Copy(buffer, 0, ptr, buf_xSize * buf_ySize);
          retval = WriteRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 3, pixelSpace, lineSpace);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  
/*@SWIG@*/
/*! Thirty two bit signed integer */ /*@SWIG:%rasterio_functions@*/
 public int ReadRaster(int xOff, int yOff, int xSize, int ySize, int[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          retval = ReadRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 5, pixelSpace, lineSpace);
          Marshal.Copy(ptr, buffer, 0, buf_xSize * buf_ySize);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  public int WriteRaster(int xOff, int yOff, int xSize, int ySize, int[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          Marshal.Copy(buffer, 0, ptr, buf_xSize * buf_ySize);
          retval = WriteRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 5, pixelSpace, lineSpace);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  
/*@SWIG@*/
/*! Thirty two bit floating point */ /*@SWIG:%rasterio_functions@*/
 public int ReadRaster(int xOff, int yOff, int xSize, int ySize, float[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          retval = ReadRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 6, pixelSpace, lineSpace);
          Marshal.Copy(ptr, buffer, 0, buf_xSize * buf_ySize);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  public int WriteRaster(int xOff, int yOff, int xSize, int ySize, float[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          Marshal.Copy(buffer, 0, ptr, buf_xSize * buf_ySize);
          retval = WriteRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 6, pixelSpace, lineSpace);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  
/*@SWIG@*/
/*! Sixty four bit floating point */ /*@SWIG:%rasterio_functions@*/
 public int ReadRaster(int xOff, int yOff, int xSize, int ySize, double[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          retval = ReadRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 7, pixelSpace, lineSpace);
          Marshal.Copy(ptr, buffer, 0, buf_xSize * buf_ySize);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  public int WriteRaster(int xOff, int yOff, int xSize, int ySize, double[] buffer, int buf_xSize, int buf_ySize, int pixelSpace, int lineSpace) {
      int retval;
      IntPtr ptr = Marshal.AllocHGlobal(buf_xSize * buf_ySize * Marshal.SizeOf(buffer[0]));
      try {
          Marshal.Copy(buffer, 0, ptr, buf_xSize * buf_ySize);
          retval = WriteRaster(xOff, yOff, xSize, ySize, ptr, buf_xSize, buf_ySize, 7, pixelSpace, lineSpace);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  
/*@SWIG@*/
  public int XSize {
    get {
      int ret = gdalPINVOKE.Band_XSize_get(swigCPtr);
      if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
    } 
  }

  public int YSize {
    get {
      int ret = gdalPINVOKE.Band_YSize_get(swigCPtr);
      if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
    } 
  }

  public int DataType {
    get {
      int ret = gdalPINVOKE.Band_DataType_get(swigCPtr);
      if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
      return ret;
    } 
  }

  public void GetBlockSize(out int pnBlockXSize, out int pnBlockYSize) {
    gdalPINVOKE.Band_GetBlockSize(swigCPtr, out pnBlockXSize, out pnBlockYSize);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public int GetRasterColorInterpretation() {
    int ret = gdalPINVOKE.Band_GetRasterColorInterpretation(swigCPtr);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int SetRasterColorInterpretation(int val) {
    int ret = gdalPINVOKE.Band_SetRasterColorInterpretation(swigCPtr, val);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void GetNoDataValue(out double val, out int hasval) {
    gdalPINVOKE.Band_GetNoDataValue(swigCPtr, out val, out hasval);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public int SetNoDataValue(double d) {
    int ret = gdalPINVOKE.Band_SetNoDataValue(swigCPtr, d);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void GetMinimum(out double val, out int hasval) {
    gdalPINVOKE.Band_GetMinimum(swigCPtr, out val, out hasval);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public void GetMaximum(out double val, out int hasval) {
    gdalPINVOKE.Band_GetMaximum(swigCPtr, out val, out hasval);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public void GetOffset(out double val, out int hasval) {
    gdalPINVOKE.Band_GetOffset(swigCPtr, out val, out hasval);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public void GetScale(out double val, out int hasval) {
    gdalPINVOKE.Band_GetScale(swigCPtr, out val, out hasval);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public int GetStatistics(int approx_ok, int force, out double min, out double max, out double mean, out double stddev) {
    int ret = gdalPINVOKE.Band_GetStatistics(swigCPtr, approx_ok, force, out min, out max, out mean, out stddev);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int SetStatistics(double min, double max, double mean, double stddev) {
    int ret = gdalPINVOKE.Band_SetStatistics(swigCPtr, min, max, mean, stddev);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int GetOverviewCount() {
    int ret = gdalPINVOKE.Band_GetOverviewCount(swigCPtr);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Band GetOverview(int i) {
    IntPtr cPtr = gdalPINVOKE.Band_GetOverview(swigCPtr, i);
    Band ret = (cPtr == IntPtr.Zero) ? null : new Band(cPtr, false? null : this);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int Checksum(int xoff, int yoff, SWIGTYPE_p_int xsize, SWIGTYPE_p_int ysize) {
    int ret = gdalPINVOKE.Band_Checksum(swigCPtr, xoff, yoff, SWIGTYPE_p_int.getCPtr(xsize), SWIGTYPE_p_int.getCPtr(ysize));
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void ComputeRasterMinMax(double[] argout, int approx_ok) {
    gdalPINVOKE.Band_ComputeRasterMinMax(swigCPtr, argout, approx_ok);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public void ComputeBandStats(double[] argout, int samplestep) {
    gdalPINVOKE.Band_ComputeBandStats(swigCPtr, argout, samplestep);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public int Fill(double real_fill, double imag_fill) {
    int ret = gdalPINVOKE.Band_Fill(swigCPtr, real_fill, imag_fill);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void FlushCache() {
    gdalPINVOKE.Band_FlushCache(swigCPtr);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
  }

  public ColorTable GetRasterColorTable() {
    IntPtr cPtr = gdalPINVOKE.Band_GetRasterColorTable(swigCPtr);
    ColorTable ret = (cPtr == IntPtr.Zero) ? null : new ColorTable(cPtr, false? null : this);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int SetRasterColorTable(ColorTable arg) {
    int ret = gdalPINVOKE.Band_SetRasterColorTable(swigCPtr, ColorTable.getCPtr(arg));
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int ReadRaster(int xOff, int yOff, int xSize, int ySize, IntPtr buffer, int buf_xSize, int buf_ySize, int buf_type, int pixelSpace, int lineSpace) {
    int ret = gdalPINVOKE.Band_ReadRaster(swigCPtr, xOff, yOff, xSize, ySize, buffer, buf_xSize, buf_ySize, buf_type, pixelSpace, lineSpace);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int WriteRaster(int xOff, int yOff, int xSize, int ySize, IntPtr buffer, int buf_xSize, int buf_ySize, int buf_type, int pixelSpace, int lineSpace) {
    int ret = gdalPINVOKE.Band_WriteRaster(swigCPtr, xOff, yOff, xSize, ySize, buffer, buf_xSize, buf_ySize, buf_type, pixelSpace, lineSpace);
    if (gdalPINVOKE.SWIGPendingException.Pending) throw gdalPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
