/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.interlis.ili2c.config.BoidEntry;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.generator.Gml32Generator;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.generator.iom.IomGenerator;
import ch.interlis.ili2c.generator.java.JavaGenerator;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ErrorListener;
import ch.interlis.ili2c.metamodel.Trace;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.parser.Ili2Parser;
import ch.interlis.ili2c.parser.MetaObjectParser;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class Main {
    private static String version = null;

    protected static boolean hasArg(String v1, String v2, String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(v1) || args[i].equals(v2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static void printVersion() {
        System.err.println("INTERLIS Compiler, Version " + Main.getVersion());
        System.err.println("  Distributed by the Coordination of Geographic Information");
        System.err.println("  and Geographic Information Systems Group (COSIG), CH-3084 Wabern");
        System.err.println("  Developed by Adasys AG, CH-8006 Zurich");
        System.err.println("  Maintained by Eisenhut Informatik AG, CH-3303 Jegenstorf");
        System.err.println("  See http://www.interlis.ch for information about INTERLIS");
        System.err.println("  Parts of this program have been generated by ANTLR; see http://www.antlr.org");
        System.err.println("  This product includes software developed by the");
        System.err.println("  Apache Software Foundation (http://www.apache.org/).");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Parses and compiles INTERLIS Version 2.2 data model definitions.");
        System.err.println("  Other options include conversion from INTERLIS Version 1 and back");
        System.err.println("  (option -o1) and generation of an XML-Schema, released 2001 (option -oXSD).");
    }

    protected static void printUsage(String progName) {
        System.err.println("USAGE");
        System.err.println("  " + progName + " [Options] file1.ili -m meta1.xml file2.ili ...");
    }

    protected static void printExamples(String progName) {
        System.err.println("EXAMPLES");
        System.err.println();
        System.err.println("Check whether an INTERLIS definition in \"file1.ili\" is valid:");
        System.err.println("    " + progName + " file1.ili");
        System.err.println();
        System.err.println("Check whether a definition distributed over several files is valid:");
        System.err.println("    " + progName + " file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-1 definition:");
        System.err.println("    " + progName + " -o1 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-2 definition:");
        System.err.println("    " + progName + " -o2 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate a definition of the predefined MODEL INTERLIS:");
        System.err.println("    " + progName + " -o2 --with-predefined");
        System.err.println();
        System.err.println("Generate an XML-Schema:");
        System.err.println("    " + progName + " -oXSD file1.ili file2.ili");
        System.err.println();
        System.err.println("Check whether two definitions are equivalent (e.g. de->fr):");
        System.err.println("    " + progName + " de_1.ili de_2.ili -c fr_1.ili fr_2.ili");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void main(String[] args) {
        emitPredefined = false;
        emitVersion = 0;
        emitXSD = false;
        emitFMT = false;
        emitJAVA = false;
        emitIOM = false;
        checkMetaObjs = false;
        numErrorsWhileGenerating = 0;
        progName = "ili2c";
        descriptions = new LinkedList<TransferDescription>();
        curDescription = mainDescription = new TransferDescription();
        notifyOnError = "compiler@interlis.ch";
        if (args.length == 0) {
            ch.interlis.ili2c.gui.Main.main(args);
            return;
        }
        descriptions.add(mainDescription);
        if (Main.hasArg("-u", "--usage", args)) {
            Main.printUsage(progName);
            return;
        }
        if (Main.hasArg("-h", "--help", args) || args.length == 0) {
            Main.printVersion();
            System.err.println();
            Main.printDescription();
            System.err.println();
            Main.printUsage(progName);
            System.err.println();
            System.err.println("OPTIONS");
            System.err.println();
            System.err.println("-o0                   Generate no output (default).");
            System.err.println("-o1                   Generate INTERLIS-1 output.");
            System.err.println("-o2                   Generate INTERLIS-2 output.");
            System.err.println("-oXSD                 Generate an XML-Schema.");
            System.err.println("-oFMT                 Generate an INTERLIS-1 Format.");
            System.err.println("-oJAVA                Generate JAVA classes.");
            System.err.println("-oIOM                 Generate Model as INTERLIS-Transfer (XTF).");
            System.err.println("-c|--compare-with     Compare two or more model definitions.");
            System.err.println("--check-metaobj       Check if referenced metaobjects exist.");
            System.err.println("-boid Model.Basket=BOID  Define a mapping from a qualified basket");
            System.err.println("                      name to a BOID of a metadata container.");
            System.err.println("--with-predefined     Include the predefined MODEL INTERLIS in");
            System.err.println("                      the output. Usually, this is omitted.");
            System.err.println("--without-warnings    Report only errors, no warnings. Usually,");
            System.err.println("                      warnings are generated as well.");
            System.err.println("-h|--help             Display this help text.");
            System.err.println("-u|--usage            Display short information about usage.");
            System.err.println("-v|--version          Display the version of " + progName + ".");
            System.err.println();
            Main.printExamples(progName);
            return;
        }
        if (Main.hasArg("-v", "--version", args)) {
            Main.printVersion();
            return;
        }
        try {
            el = new MyErrorListener();
            i = 0;
            while (i < args.length) {
                block46: {
                    block55: {
                        block54: {
                            block53: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block48: {
                                                    block47: {
                                                        block45: {
                                                            if (!args[i].equals("--with-predefined")) break block45;
                                                            emitPredefined = true;
                                                            break block46;
                                                        }
                                                        if (!args[i].equals("--check-metaobj")) break block47;
                                                        checkMetaObjs = true;
                                                        break block46;
                                                    }
                                                    if (!args[i].equals("-o0")) break block48;
                                                    emitVersion = 0;
                                                    emitXSD = false;
                                                    emitFMT = false;
                                                    emitJAVA = false;
                                                    emitIOM = false;
                                                    break block46;
                                                }
                                                if (!args[i].equals("-o1")) break block49;
                                                emitVersion = 1;
                                                emitXSD = false;
                                                emitFMT = false;
                                                emitJAVA = false;
                                                emitIOM = false;
                                                break block46;
                                            }
                                            if (!args[i].equals("-o2")) break block50;
                                            emitVersion = 2;
                                            emitXSD = false;
                                            emitFMT = false;
                                            emitJAVA = false;
                                            emitIOM = false;
                                            break block46;
                                        }
                                        if (!args[i].equals("-oXSD")) break block51;
                                        emitVersion = 0;
                                        emitXSD = true;
                                        emitFMT = false;
                                        emitJAVA = false;
                                        emitIOM = false;
                                        break block46;
                                    }
                                    if (!args[i].equals("-oFMT")) break block52;
                                    emitVersion = 0;
                                    emitXSD = false;
                                    emitFMT = true;
                                    emitJAVA = false;
                                    emitIOM = false;
                                    break block46;
                                }
                                if (!args[i].equals("-oJAVA")) break block53;
                                emitVersion = 0;
                                emitXSD = false;
                                emitFMT = false;
                                emitJAVA = true;
                                emitIOM = false;
                                break block46;
                            }
                            if (!args[i].equals("-oIOM")) break block54;
                            emitVersion = 0;
                            emitXSD = false;
                            emitFMT = false;
                            emitJAVA = false;
                            emitIOM = true;
                            break block46;
                        }
                        if (!args[i].equals("-")) break block55;
                        stream /* !! */  = new DataInputStream(System.in);
                        streamName = null;
                        ** GOTO lbl173
                    }
                    if (args[i].equals("--compare-with") || args[i].equals("-c")) {
                        curDescription = new TransferDescription();
                        descriptions.add(curDescription);
                    } else if (args[i].equals("--without-warnings")) {
                        el.setSeverityLevel(5);
                    } else if (args[i].equals("--with-warnings")) {
                        el.setSeverityLevel(0);
                    } else if (args[i].equals("-m")) {
                        if (i + 1 >= args.length) {
                            System.err.println(String.valueOf(progName) + ":after -m is an argument (file.xml) required");
                        } else {
                            if (checkMetaObjs && !MetaObjectParser.parse(curDescription, args[i + 1], el)) {
                                return;
                            }
                            ++i;
                        }
                    } else if (args[i].equals("-boid")) {
                        if (i + 1 >= args.length) {
                            System.err.println(String.valueOf(progName) + ":after -boid is an argument of the form basketName=boid required");
                        } else {
                            eqpos = args[i + 1].indexOf(61);
                            if (eqpos == -1) {
                                System.err.println(String.valueOf(progName) + ":after -boid is an argument of the form basketName=boid required; but found " + args[i]);
                                ++i;
                            } else {
                                qualifiedBasketName = args[i + 1].substring(0, eqpos);
                                boid = args[i + 1].substring(eqpos + 1);
                                curDescription.addMetadataMapping(qualifiedBasketName, boid);
                                ++i;
                            }
                        }
                    } else if (args[i].charAt(0) == '-') {
                        System.err.println(String.valueOf(progName) + ":Unknown option: " + args[i]);
                    } else {
                        streamName = args[i];
                        stream /* !! */  = null;
                        try {
                            stream /* !! */  = new FileInputStream(args[i]);
                        }
                        catch (FileNotFoundException fnfex) {
                            System.err.println(String.valueOf(args[i]) + ":" + "There is no such file.");
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
lbl173:
                        // 3 sources

                        if (stream /* !! */  != null) {
                            if (!Ili2Parser.parseIliFile(curDescription, streamName, stream /* !! */ , el, checkMetaObjs)) {
                                stream /* !! */ .close();
                                return;
                            }
                            stream /* !! */ .close();
                        }
                    }
                }
                ++i;
            }
            switch (emitVersion) {
                case 1: {
                    numErrorsWhileGenerating = Interlis1Generator.generate(new PrintWriter(System.out), mainDescription);
                    break;
                }
                case 2: {
                    numErrorsWhileGenerating = Interlis2Generator.generate(new PrintWriter(System.out), mainDescription, emitPredefined);
                    break;
                }
                default: {
                    out = new PrintWriter(System.out);
                    if (emitXSD) {
                        numErrorsWhileGenerating = XSDGenerator.generate(out, mainDescription);
                    } else if (emitFMT) {
                        numErrorsWhileGenerating = Interlis1Generator.generateFmt(out, mainDescription);
                    } else if (emitJAVA) {
                        numErrorsWhileGenerating = JavaGenerator.generate(mainDescription, "", "");
                    } else if (emitIOM) {
                        numErrorsWhileGenerating = IomGenerator.generate(out, mainDescription, el);
                    }
                    out.close();
                }
            }
            if (numErrorsWhileGenerating > 0) {
                System.err.println(String.valueOf(progName) + ":While generating output, errors have occured.");
                System.err.println(String.valueOf(progName) + ":Those places, " + Integer.toString(numErrorsWhileGenerating) + " in number, have been marked with " + Element.makeErrorName(null) + ".");
            }
            if (descriptions.size() > 1) {
                iter = descriptions.iterator();
                mainDesc = (TransferDescription)iter.next();
                while (iter.hasNext()) {
                    curDesc = (TransferDescription)iter.next();
                    if (curDesc == null || curDesc.checkStructuralEquivalence(mainDesc, el)) continue;
                    System.err.println("Structural mismatches have been detected.");
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(progName) + ":An internal error has occured. Please notify " + notifyOnError);
            System.err.println();
            e.printStackTrace();
        }
    }

    public static TransferDescription runCompiler(Configuration config, ErrorListener el) {
        TransferDescription desc = new TransferDescription();
        boolean emitPredefined = config.isIncPredefModel();
        boolean checkMetaObjs = config.isCheckMetaObjs();
        Iterator boidi = config.iteratorBoidEntry();
        while (boidi.hasNext()) {
            BoidEntry e = (BoidEntry)boidi.next();
            desc.addMetadataMapping(e.getMetaDataUseDef(), e.getBoid());
        }
        Iterator filei = config.iteratorFileEntry();
        while (filei.hasNext()) {
            FileEntry e = (FileEntry)filei.next();
            if (e.getKind() == 2) {
                if (!checkMetaObjs || MetaObjectParser.parse(desc, e.getFilename(), el)) continue;
                return null;
            }
            String streamName = e.getFilename();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(streamName);
            }
            catch (FileNotFoundException ex) {
                el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                return null;
            }
            catch (Exception ex) {
                el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                return null;
            }
            if (!Ili2Parser.parseIliFile(desc, streamName, stream, el, checkMetaObjs)) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                }
                return null;
            }
            try {
                stream.close();
            }
            catch (IOException ex) {
                el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
            }
        }
        BufferedWriter out = null;
        switch (config.getOutputKind()) {
            case 1: {
                break;
            }
            case 2: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                        return desc;
                    }
                }
                Interlis1Generator.generate(out, desc);
                break;
            }
            case 3: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                        return desc;
                    }
                }
                Interlis2Generator.generate(out, desc, emitPredefined);
                break;
            }
            case 4: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                        return desc;
                    }
                }
                XSDGenerator.generate(out, desc);
                break;
            }
            case 5: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                        return desc;
                    }
                }
                Interlis1Generator.generateFmt(out, desc);
                break;
            }
            case 6: {
                JavaGenerator.generate(desc, config.getOutputFile(), "");
                break;
            }
            case 7: {
                Gml32Generator.generate(desc, config.getOutputFile(), el);
                break;
            }
            case 8: {
                if ("-".equals(config.getOutputFile())) {
                    out = new BufferedWriter(new OutputStreamWriter(System.out));
                } else {
                    try {
                        out = new BufferedWriter(new FileWriter(config.getOutputFile()));
                    }
                    catch (IOException ex) {
                        el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                        return desc;
                    }
                }
                IomGenerator.generate(out, desc, el);
                break;
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ex) {
                el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
            }
        }
        return desc;
    }

    public static boolean editConfig(Configuration config) {
        ch.interlis.ili2c.gui.Main dialog = new ch.interlis.ili2c.gui.Main();
        return dialog.showDialog();
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch/interlis/ili2c/Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("versionMajor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMinor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMicro"));
            ret.append('-');
            ret.append(resVersion.getString("versionDate"));
            version = ret.toString();
        }
        return version;
    }

    private static class MyErrorListener
    implements ErrorListener {
        int numSupressed = 0;
        int severityLevel = 0;

        MyErrorListener() {
        }

        public void setSeverityLevel(int level) {
            this.severityLevel = level;
        }

        public void error(ErrorListener.ErrorEvent evt) {
            if (evt.getSeverity() < this.severityLevel) {
                ++this.numSupressed;
            } else {
                System.err.println(evt.toString());
                if (evt.getException() != null) {
                    evt.getException().printStackTrace(Trace.getTraceStream());
                }
            }
        }
    }
}

