package GCImport::GCImportCSV;

###################################################
#
#  Copyright 2005-2009 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCImport::GCImportBase;

{
    package GCImport::GCImporterCSV;

    use base qw(GCImport::GCImportBaseClass);
    use Encode;

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        
        bless ($self, $class);
        return $self;
    }

    sub wantsFieldsSelection
    {
        return 1;
    }

    sub wantsIgnoreField
    {
        return 1;
    }

    sub wantsFileSelection
    {
        return 1;
    }
    
    sub getName
    {
        my $self = shift;
        
        return "CSV";
    }
    
    sub getFilePatterns
    {
       return (['CSV (*.csv)', '*.csv']);
    }
    
    sub getOptions
    {
        my $self = shift;

        my $charsets = '';
        my @charsetList = Encode->encodings(':all');
        foreach (@charsetList)
        {
            $charsets .= $_.',';
        }

        return [
            {
                name => 'sep',
                type => 'short text',
                label => 'Separator',
                default => ';'
            },

            {
                name => 'charset',
                type => 'options',
                label => 'Charset',
                valuesList => $charsets,
                default => 'utf8',
            },

            {
                name => 'withHeader',
                type => 'yesno',
                label => 'Header',
                default => '1'
            },

        ];
    }
      
    sub getModelName
    {
        my $self = shift;
        return $self->{model}->getName;
    }

    sub getItemsArray
    {
        my ($self, $file) = @_;
        my @result;

        open ITEMS, $file;
        binmode(ITEMS, ':utf8')
            if $self->{options}->{charset} eq 'utf8';;

        my $i = 0;
        my $sep = $self->{options}->{sep};
        my $ignoreFirstLine = $self->{options}->{withHeader};

        while (<ITEMS>)
        {
            if ($ignoreFirstLine)
            {
                $ignoreFirstLine = 0;
                next;
            }
        
            chomp;
            # Special characters are escaped
            my @values =  split m/\Q$sep\E/;

            $result[$i] = {};
            my $j = 0;
            foreach (@{$self->{options}->{fields}})
            {
                $values[$j] = decode($self->{options}->{charset}, $values[$j])
                    if $self->{options}->{charset} ne 'utf8';
                $result[$i]->{$_} = $values[$j];
                $j++;
            }
	    
            $i++;
        }
        close ITEMS;


        return \@result;
    }
    
    
    sub getEndInfo
    {
        my $self = shift;
        my $message;
                
        return $message;
    }
}

1;
