package GCPlugins::GCbooks::GCFnac;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCbooks::GCbooksCommon;

{
    package GCPlugins::GCbooks::GCPluginFnac;

    use base qw(GCPlugins::GCbooks::GCbooksPluginsBase);
    use URI::Escape;

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            return if $self->{isFound};
            if (($tagname eq 'h3') && ($attr->{class} eq 'hStyle1'))
            {
                $self->{isFound} = 1 ;
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = $self->{loadedUrl};
                return;
            }
            elsif ($tagname eq 'td')
            {
                if (($attr->{width} eq '254') && (!exists $attr->{bgcolor}))
                {
                    $self->{isBook} = 1 ;
                    $self->{isUrl} = 1 ;
                }
            }
            elsif ($tagname eq 'a')
            {
                if ($attr->{href} =~ m|/advanced/book.do\?category=book|i)
                {
                    $self->{isBook} = 0 ;
                    $self->{isUrl} = 0 ;
                }
                elsif (($attr->{href} =~ m|Shelf/article.aspx|i) && ($self->{isUrl}))
                {
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
                    $self->{isTitle} = 1 ;
                    $self->{isUrl} = 0 ;
                }
                elsif (($attr->{href} =~ m|/item/author\.do|) && ($self->{isBook}))
                {
                    $self->{isAuthor} = 1 ;
                }
            }
        }
        else
        {
            if (($tagname eq 'mytpf') && ($attr->{id} eq 'TPFENDCOMMENTTPF'))
            {
                $self->{isDescription} = 0 ;
            }
            elsif ($self->{isISBN} eq 1)
            {
                $self->{isISBN} = 2 ;
            }
            elsif ($self->{isPublisher} eq 1)
            {
                $self->{isPublisher} = 2 ;
            }
            elsif ($self->{isFormat} eq 1)
            {
                $self->{isFormat} = 2 ;
            }
            elsif ($self->{isSerie} eq 1)
            {
                $self->{isSerie} = 2 ;
            }
            elsif ($self->{isPublication} eq 1)
            {
                $self->{isPublication} = 2 ;
            }
            elsif ($self->{isPage} eq 1)
            {
                $self->{isPage} = 2 ;
            }
            elsif (($tagname eq 'h3') && ($attr->{class} eq 'hStyle1'))
            {
                $self->{isTitle} = 1 ;
                $self->{isAuthor} = 0 ;
            }
            elsif (($tagname eq 'strong') && ($self->{isTitle}))
            {
                $self->{isTitle} = 2 ;
            }
            elsif (($tagname eq 'li') && ($attr->{class} eq 'hStyle1'))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"author.do") >= 0) && ($self->{curInfo}->{title} ne '') && ($self->{isAuthor} ne '2'))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif (($tagname eq 'div') && ($self->{curInfo}->{authors} ne ''))
            {
                $self->{isAuthor} = 2 ;
            }
            elsif (($tagname eq 'th') && ($attr->{scope} eq 'row'))
            {
                $self->{isAnalyse} = 1 ;
            }
            elsif (($tagname eq 'mytpf') && ($attr->{id} eq 'TPFSTARTCOMMENTTPF'))
            {
                $self->{isDescription} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'activeimg'))
            {
                $self->{isCover} = 1 ;
            }
            elsif (($tagname eq 'img') && ($self->{isCover}))
            {
                if ($origtext !~ m/noscan_/i)
                {
                   $self->{curInfo}->{cover} = $attr->{src};
                }
                $self->{isCover} = 0 ;
            }
            elsif (($tagname eq 'a') && ($attr->{class} eq 'expandimg'))
            {
                $self->{curInfo}->{cover} = "http://multimedia.fnac.com/multimedia" .$attr->{href} ;
            }
        }
    }

    sub end
    {
        my ($self, $tagname) = @_;

        $self->{isFound} = 0 ;
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isTitle})
            {
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isAuthor} eq 1)
            {
                # Enleve les retours chariots
                $origtext =~ s/\n//g;
                $origtext =~ s/\r//g;
                if (($self->{itemsList}[$self->{itemIdx}]->{authors} eq '') && ($origtext ne ''))
                {
                   $self->{itemsList}[$self->{itemIdx}]->{authors} = $origtext;
                }
                elsif ($origtext ne '')
                {
                   $self->{itemsList}[$self->{itemIdx}]->{authors} .= ', ';
                   $self->{itemsList}[$self->{itemIdx}]->{authors} .= $origtext;
                }
                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{inside}->{publication})
            {
                $self->{itemsList}[$self->{itemIdx}]->{publication} = $origtext;
            }
        }
       	else
        {
            # Enleve les blancs en debut de chaine
            $origtext =~ s/^\s+//;
            # Enleve les blancs en fin de chaine
            $origtext =~ s/\s+$//g;
            if ($self->{isTitle} eq '2')
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{curInfo}->{language} = 'Fran�ais';
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isAuthor} eq 1)
            {
                if ($origtext ne '')
                {
                   $self->{curInfo}->{authors} .= $origtext;
                   $self->{curInfo}->{authors} .= ",";
                }
                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{isAnalyse})
            {
                $self->{isISBN} = 1 if ($origtext =~ m/ISBN/i);
                $self->{isPublisher} = 1 if ($origtext =~ m/Editeur/i);
                $self->{isFormat} = 1 if ($origtext =~ m/Format/i);
                $self->{isSerie} = 1 if ($origtext =~ m/Collection/i);
                $self->{isPublication} = 1 if ($origtext =~ m/Date de parution/i);
                $self->{isPage} = 1 if ($origtext =~ m/pages/i);

                $self->{isAnalyse} = 0 ;
            }
            elsif ($self->{isISBN} eq 2)
            {
                $self->{curInfo}->{isbn} = $origtext;
                $self->{isISBN} = 0 ;
            }
            elsif ($self->{isPublisher} eq 2)
            {
                $self->{curInfo}->{publisher} = $origtext;
                $self->{isPublisher} = 0 ;
            }
            elsif ($self->{isFormat} eq 2)
            {
                $self->{curInfo}->{format} = $origtext;
                $self->{isFormat} = 0 ;
            }
            elsif ($self->{isSerie} eq 2)
            {
                $self->{curInfo}->{serie} = $origtext;
                $self->{isSerie} = 0 ;
            }
            elsif ($self->{isPublication} eq 2)
            {
                $self->{curInfo}->{publication} = $origtext;
                $self->{isPublication} = 0 ;
            }
            elsif (($self->{isPage} eq 2))
            {
                $self->{curInfo}->{pages} = $origtext;
                $self->{isPage} = 0 ;
            }
            elsif ($self->{isDescription})
            {
                $self->{curInfo}->{description} .= $origtext;
            }

        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            authors => 1,
            publication => 1,
        };

        $self->{isFound} = 0;
        $self->{isBook} = 0;
        $self->{isUrl} = 0;
        $self->{isTitle} = 0;
        $self->{isAuthor} = 0;
        $self->{isPublisher} = 0;
        $self->{isISBN} = 0;
        $self->{isPublication} = 0;
        $self->{isFormat} = 0;
        $self->{isSerie} = 0;
        $self->{isPage} = 0;
        $self->{isDescription} = 0;
        $self->{isCover} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $html =~ s|<FONT\s+CLASS="subTitre"\s*>[^<]*<BR>([^<]*)</FONT>|<publication>$1</publication>|gmi;
            $html =~ s/<B>//gi;
            $html =~ s/<\/B>//gi;
            $html =~ s/<\/FONT>//gi;
        }
        else
        {
            # Le descriptif pouvant contenir des balises html je le repere maintenant
            my $found = index($html,"<strong>Mot de l'�diteur</strong>");
            if ( $found >= 0 )
            {
               my $html2 = substr($html, $found +length('<strong>Mot de l\'.diteur</strong>'),length($html)- $found -length('<strong>Mot de l\'.diteur</strong>'));
               my $found2 = index($html2,"<h4 ");
               my $html3 = $html2;
               if ( $found2 >= 0 )
               {
                  $html3 = substr($html2, $found2 +length('<h4 '),length($html2)- $found2 -length('<h4 '));
                  $html2 = substr($html2, 0, $found2);
               }

               $html2 =~ s|<li>|\n* |gi;
               $html2 =~ s|<br>|\n|gi;
               $html2 =~ s|<br />|\n|gi;
               $html2 =~ s|<b>||gi;
               $html2 =~ s|</b>||gi;
               $html2 =~ s|<i>||gi;
               $html2 =~ s|</i>||gi;
               $html2 =~ s|<p>|\n|gi;
               $html2 =~ s|</p>||gi;
               $html2 =~ s|</h4>||gi;
               $html2 =~ s|\x{92}|'|g;
               $html2 =~ s|&#146;|'|gi;
               $html2 =~ s|&#149;|*|gi;

               $html = substr($html, 0, $found) . "<mytpf id=\"TPFSTARTCOMMENTTPF\">" . $html2 ."</mytpf><mytpf id=\"TPFENDCOMMENTTPF\"></mytpf></h4>" .$html3;
            }

        }
        
        return $html;
    }
    
    sub getSearchUrl
    {
        my ($self, $word) = @_;
	
        return "http://www3.fnac.com/search/quick.do?filter=-3&text=". $word ."&category=book";
    }
    
    sub getItemUrl
    {
        my ($self, $url) = @_;
		
        return $url if $url;
        return 'http://www.fnac.com/';
    }

    sub getName
    {
        return "Fnac (FR)";
    }
    
    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'FR';
    }

    sub getSearchFieldsArray
    {
        return ['isbn', 'title'];
    }
}

1;
