/* Gnome BibTeX gui.C
 *    Copyright 1999 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

#include <iostream.h>
#include <vector>
#include "gbib.h"

typedef vector<GtkWidget*> EntryList;

struct BibentryDlgData {
    BibentryDlgData() {
	freq = fopt = fext = 0;
    }
    GtkWidget *w;    
    GtkWidget *freq, *fopt, *fext;
    BibEntry b;
    bool newentry, changed;
    EntryList entry;
};


extern BibentryTable etable;

void entry_dlg(char *et, BibEntry *bib);
void update_entries(BibEntry *bib);


void entrydlg_cb(GnomeDialog * dialog, gint button_number, 
		 gpointer data)
{
  BibentryDlgData *dlg = (BibentryDlgData*)data;

  switch (button_number) {
  case 0: // OK
    {  
	string key = gtk_entry_get_text(GTK_ENTRY(dlg->entry[0]));
	if (key.empty()) {
	    gnome_warning_dialog(_("Please type a key for this entry"));
	    break;
	}
	dlg->b.setKey(gtk_entry_get_text(GTK_ENTRY(dlg->entry[0])));
	int  i = etable.search_key(dlg->b.getKey());
	if (i >= 0 &&  etable.selected_entry != i) {
	    gnome_warning_dialog(_("The key is already used by another entry"));
	    break;
	}
	
	for (int i=1; dlg->entry[i]; i++) {
	    char *s = gtk_entry_get_text(GTK_ENTRY(dlg->entry[i]));
	    dlg->b.setField(i-1, s);
	}
	if (dlg->newentry) {
	    if (etable.selected_entry>=0)
	      etable.insert_entry(dlg->b, etable.selected_entry);
	    else {
		etable.new_entry(dlg->b);
		etable.selected_entry = etable.size()-1;
	    }
	    
	    
	} else
	  dlg->newentry = etable.replace_entry(dlg->b, etable.selected_entry);
	gnome_dialog_close(dialog);      
	update_entry(dlg->newentry);
	delete dlg;
	break;
    }
  case 1: // CANCEL
    gnome_dialog_close(dialog);
    delete dlg;
    break;
  };
}


BibentryDlgData *ldlg = 0;

void combo_cb(GtkWidget *widget, gpointer data)
{
    char *s = (char*)data;

    if (strcmp(s, ldlg->b.getEntryType())!=0) {
	for (int i=1; ldlg->entry[i]; i++) {
	    ldlg->b.setField(i-1, gtk_entry_get_text(GTK_ENTRY(ldlg->entry[i])));
	}
	ldlg->b.setEntryType(s);
	update_entries(&ldlg->b);
	gtk_window_set_policy(GTK_WINDOW(ldlg->w), FALSE, FALSE, TRUE);
    }
}


GtkWidget *new_entrytype_combox(char *entrytype)
{
    char *s;
    GtkWidget *item;
    GtkWidget *menu;
    GtkWidget *optmenu; 

    menu = gtk_menu_new();
    int themenu=0, i=0;
    while ((s = get_entrytype_name(i++))) {
	item = gtk_menu_item_new_with_label (s);
	gtk_menu_append (GTK_MENU (menu), item);
	gtk_signal_connect(GTK_OBJECT (item), "activate",
			   GTK_SIGNAL_FUNC (combo_cb), 
			   (void *)s);
	gtk_widget_show (item);
	if (strcmp(entrytype,s)==0) 
	  themenu = i-1;
	
    }    
    gtk_menu_set_title(GTK_MENU (menu), entrytype);
    gtk_widget_show(menu);
    
    optmenu = gtk_option_menu_new();
    gtk_option_menu_set_menu (GTK_OPTION_MENU (optmenu), menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU (optmenu), themenu);
    gtk_widget_show(optmenu);

    return optmenu;
}


void update_entries(BibEntry *bib)
{
    GtkWidget * table;
    GtkWidget *label;
    GtkWidget *entry;
    GtkWidget *frame;
    int nr, no, ne;
    
    nr = bib->getNoReqFields();
    no = bib->getNoOptFields();
    ne = bib->getNoExtraFields();
    
    if (ldlg->freq) {
	gtk_container_clear_resize_widgets (GTK_CONTAINER(ldlg->freq));

	gtk_container_foreach (GTK_CONTAINER(ldlg->freq),
			       (GtkCallback) gtk_widget_destroy, 
			       NULL);
	gtk_widget_hide(ldlg->freq);
    }
    
    if (ldlg->fopt) {
	gtk_container_clear_resize_widgets (GTK_CONTAINER(ldlg->fopt));

	gtk_container_foreach (GTK_CONTAINER(ldlg->fopt),
			       (GtkCallback)gtk_widget_destroy, 
			       NULL);
	gtk_widget_hide(ldlg->fopt);
    }
    
    
    if (ldlg->fext) {
	gtk_container_clear_resize_widgets (GTK_CONTAINER(ldlg->fext));

	gtk_container_foreach (GTK_CONTAINER(ldlg->fext),
			       (GtkCallback) gtk_widget_destroy, 
			       NULL);
	gtk_widget_hide(ldlg->fext);
    }
    entry = ldlg->entry[0];
    ldlg->entry.clear();
    ldlg->entry.push_back(entry);
    for (int i=0; i < bib->getNoFields(); i++) {
	if (i==0 || i==nr || i==nr+no) {
	    table = gtk_table_new( 2, nr, 0);
	    gtk_container_border_width (GTK_CONTAINER (table), 10);
	    if (i==0 && nr > 0) {
		frame = ldlg->freq;
	    } else if (i==nr) {
		frame = ldlg->fopt;
	    } else if (i==nr+no) {
		frame = ldlg->fext;
	    }
	    gtk_container_border_width (GTK_CONTAINER (frame), 5);
	    gtk_container_add (GTK_CONTAINER(frame), table);
	    gtk_widget_show(frame);
	    gtk_widget_show(table);
	}
	label = gtk_label_new(bib->getFieldName(i));
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);	
	entry = gtk_entry_new();
	ldlg->entry.push_back(entry);
	gtk_widget_set_usize (entry, 300, 25);
	
	gtk_entry_set_text(GTK_ENTRY(entry), bib->getField(i));
	
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, i, i+1,
			 GtkAttachOptions(GTK_EXPAND | GTK_FILL),
			 GtkAttachOptions(GTK_EXPAND | GTK_FILL),
			 0, 
			 0);
	gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, i, i+1);
	gtk_widget_show(label);
	gtk_widget_show(entry);
    }
    ldlg->entry.push_back(0);
}


void entry_dlg(char *et, BibEntry *bib)
{
    GtkWidget * dialog;
    GtkWidget *label;
    GtkWidget *entry;
    GtkWidget *combo;
    GtkWidget *box;
    BibentryDlgData *dlg = new BibentryDlgData;
    ldlg = dlg;
    
    int nr, no, ne;
        
    if (!bib) {
	dlg->newentry = true;
	bib = &dlg->b;
	bib->setEntryType(et);
    } else {
	dlg->newentry = false;	
	dlg->b = *bib;
    }

    nr = bib->getNoReqFields();
    no = bib->getNoOptFields();
    ne = bib->getNoExtraFields();
    
    dialog = gnome_dialog_new(bib->getKey(), 
			      GNOME_STOCK_BUTTON_OK,
			      GNOME_STOCK_BUTTON_CANCEL,
			      0);
    gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);

    gtk_signal_connect(GTK_OBJECT (dialog),
		       "clicked", GTK_SIGNAL_FUNC(entrydlg_cb), 
		       dlg);

    
    box = gtk_hbox_new(0, 0);
    gtk_widget_show(box);

    // Entry type level
    combo = new_entrytype_combox(et);

    label = gtk_label_new(_("                    Key: "));
//    gtk_widget_set_usize (label, 120, 25);   
//    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
    gtk_widget_show(label);

    entry = gtk_entry_new();
    dlg->entry.push_back(entry);
    gtk_widget_set_usize (entry, 100, 25);
    gtk_entry_set_text(GTK_ENTRY(entry), bib->getKey());
    gtk_widget_show(entry);

    gtk_box_pack_start (GTK_BOX (box), combo,
			FALSE, FALSE, 0);
    
    gtk_box_pack_start (GTK_BOX (box), label,
			FALSE, FALSE, 0);

    gtk_box_pack_start (GTK_BOX (box), entry,
			FALSE, FALSE, 0);
    
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), box,
                        FALSE, FALSE, 0);
    
    dlg->freq = gtk_frame_new(_("Required fields"));
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), 
			dlg->freq, FALSE, FALSE, 0);
    dlg->fopt = gtk_frame_new(_("Optional fields"));
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), 
			dlg->fopt, FALSE, FALSE, 0);
    dlg->fext = gtk_frame_new(_("Extra fields"));
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), 
			dlg->fext, FALSE, FALSE, 0);
    update_entries(bib);
    
    dlg->w = dialog;
    
    GTK_WINDOW (dialog)->type = GTK_WINDOW_TOPLEVEL;
    gtk_widget_show(dialog);
}
