/* Gnome BibTeX bibfiles.C
 *    Copyright 1998 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

// File operations
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <gnome.h>
#include "gbib.h"

enum {
  BIBRC_BIBSTYLES,
  BIBRC_NEW_BIBENTRY,
  BIBRC_COMMANDS
};

extern int gmain(int argc, char *argv[]);

// Read everything inside delimiters
static
char *read_field(FILE *inf)
{
  int i = 0;
  char delimlf = '"', delimrg = '"';
  char c;
  static char buf[2000];

  buf[0] = '\0';
  
  do c = getc(inf); while (c!=delimlf && !feof(inf));
  do {
    c = getc(inf);
    if (c >= ' ' && c != delimrg) 
      buf[i++] = c;
  } while (c != delimrg && !feof(inf));
   buf[i] = '\0';
  
  return &buf[0];
}


// Read the whole entry
static
int read_entry(FILE *inf)
{
    int i = 0, token=-1;
    char delimlf = '(';
    char c, name[100], *s, e[255], r[250], o[250];

    if (feof(inf))
	return 0;

    // Eat everything before the delimiter
    do c = getc(inf); while (c!=delimlf && !feof(inf));
    
    // read the entry type name
    c = getc(inf);
    while (isalpha(c) && !feof(inf))
    {
	name[i++] = c;
	c = getc(inf);
    }
    
    name[i] = '\0';

    if (strcmp(name, "bibstyles")==0) 
      token = BIBRC_BIBSTYLES;
    else if (strcmp(name, "newbibentry")==0)
      token = BIBRC_NEW_BIBENTRY;
    else if (strcmp(name, "commands")==0)
      token = BIBRC_COMMANDS;

    switch (token) {
    case BIBRC_BIBSTYLES:
      s = read_field(inf);
      new_bibstyles(s);
      break;
    case BIBRC_NEW_BIBENTRY:
      s = read_field(inf);
      strcpy(e, s);
      s = read_field(inf);
      strcpy(r, s);
      s = read_field(inf);
      strcpy(o, s);
      new_entrydef(e, r, o);
      break;
     case BIBRC_COMMANDS:
      s = read_field(inf);
      new_commands(s);
      break;
    }

    return (feof(inf)) ? 0: 1;
}


void readBibrc(const char *name)
{
  FILE *inf = fopen(name, "r");
    
  while (read_entry(inf));
    
  fclose(inf);
}


int main (int argc, char *argv[]) 
{
    string deffile = "gbib.rc";
    string libdir = LIBDIR;

    libdir += "/";
    libdir += deffile;

    // search first for a local definitions file
    if (g_file_exists (deffile.c_str())) {
	readBibrc(const_cast<char*>(deffile.c_str()));
    } else
      if (g_file_exists (libdir.c_str())) {
	 readBibrc(const_cast<char*>(libdir.c_str()));
      }
    else {
	    cerr << _("I couldn't found the file ") << deffile << "\n";
        exit(1);
    }

    gmain(argc, argv);
    return 0;
}
