#include <inttypes.h>
#include "colorspace_tables.h"
uint8_t gavl_yj_8_to_y_8[256] = 
{
  0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x15, 0x16, 
  0x17, 0x18, 0x19, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 
  0x1e, 0x1f, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 
  0x25, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 
  0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x31, 
  0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x38, 
  0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3e, 0x3f, 
  0x40, 0x41, 0x42, 0x43, 0x44, 0x44, 0x45, 0x46, 
  0x47, 0x48, 0x49, 0x4a, 0x4a, 0x4b, 0x4c, 0x4d, 
  0x4e, 0x4f, 0x50, 0x50, 0x51, 0x52, 0x53, 0x54, 
  0x55, 0x56, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 
  0x5c, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 
  0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x68, 
  0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6e, 0x6f, 
  0x70, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x76, 
  0x77, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c, 0x7d, 
  0x7e, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x83, 0x84, 
  0x85, 0x86, 0x87, 0x87, 0x88, 0x89, 0x8a, 0x8b, 
  0x8c, 0x8d, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 
  0x93, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 
  0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 0x9f, 
  0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa5, 0xa6, 
  0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xab, 0xac, 0xad, 
  0xae, 0xaf, 0xb0, 0xb1, 0xb1, 0xb2, 0xb3, 0xb4, 
  0xb5, 0xb6, 0xb7, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 
  0xbc, 0xbd, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 
  0xc3, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 
  0xca, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0xd0, 
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd6, 
  0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdc, 0xdd, 
  0xde, 0xdf, 0xe0, 0xe1, 0xe2, 0xe2, 0xe3, 0xe4, 
  0xe5, 0xe6, 0xe7, 0xe8, 0xe8, 0xe9, 0xea, 0xeb, 
};

uint8_t gavl_uvj_8_to_uv_8[256] = 
{
  0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 
  0x17, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 
  0x1e, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 
  0x25, 0x26, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 
  0x2c, 0x2d, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 
  0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
  0x3a, 0x3b, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 
  0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x46, 0x47, 
  0x48, 0x49, 0x4a, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 
  0x4f, 0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x55, 
  0x56, 0x57, 0x58, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 
  0x5d, 0x5e, 0x5f, 0x5f, 0x60, 0x61, 0x62, 0x63, 
  0x64, 0x65, 0x66, 0x67, 0x67, 0x68, 0x69, 0x6a, 
  0x6b, 0x6c, 0x6d, 0x6e, 0x6e, 0x6f, 0x70, 0x71, 
  0x72, 0x73, 0x74, 0x75, 0x75, 0x76, 0x77, 0x78, 
  0x79, 0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x7e, 0x7f, 
  0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 
  0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8b, 0x8c, 0x8d, 
  0x8e, 0x8f, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 
  0x95, 0x96, 0x97, 0x98, 0x99, 0x99, 0x9a, 0x9b, 
  0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa1, 0xa2, 
  0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa8, 0xa9, 
  0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xaf, 0xb0, 
  0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb6, 0xb7, 
  0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbd, 0xbe, 
  0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc5, 
  0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcc, 
  0xcd, 0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd3, 
  0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xda, 
  0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0xe0, 0xe1, 0xe2, 
  0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 
  0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 
};

uint16_t gavl_yj_8_to_y_16[256] = 
{
  0x1000, 0x10dc, 0x11b8, 0x1294, 0x136f, 0x144b, 0x1527, 0x1603, 
  0x16df, 0x17bb, 0x1897, 0x1972, 0x1a4e, 0x1b2a, 0x1c06, 0x1ce2, 
  0x1dbe, 0x1e9a, 0x1f75, 0x2051, 0x212d, 0x2209, 0x22e5, 0x23c1, 
  0x249d, 0x2578, 0x2654, 0x2730, 0x280c, 0x28e8, 0x29c4, 0x2aa0, 
  0x2b7b, 0x2c57, 0x2d33, 0x2e0f, 0x2eeb, 0x2fc7, 0x30a3, 0x317e, 
  0x325a, 0x3336, 0x3412, 0x34ee, 0x35ca, 0x36a6, 0x3782, 0x385d, 
  0x3939, 0x3a15, 0x3af1, 0x3bcd, 0x3ca9, 0x3d85, 0x3e60, 0x3f3c, 
  0x4018, 0x40f4, 0x41d0, 0x42ac, 0x4388, 0x4463, 0x453f, 0x461b, 
  0x46f7, 0x47d3, 0x48af, 0x498b, 0x4a66, 0x4b42, 0x4c1e, 0x4cfa, 
  0x4dd6, 0x4eb2, 0x4f8e, 0x5069, 0x5145, 0x5221, 0x52fd, 0x53d9, 
  0x54b5, 0x5591, 0x566c, 0x5748, 0x5824, 0x5900, 0x59dc, 0x5ab8, 
  0x5b94, 0x5c6f, 0x5d4b, 0x5e27, 0x5f03, 0x5fdf, 0x60bb, 0x6197, 
  0x6272, 0x634e, 0x642a, 0x6506, 0x65e2, 0x66be, 0x679a, 0x6875, 
  0x6951, 0x6a2d, 0x6b09, 0x6be5, 0x6cc1, 0x6d9d, 0x6e78, 0x6f54, 
  0x7030, 0x710c, 0x71e8, 0x72c4, 0x73a0, 0x747b, 0x7557, 0x7633, 
  0x770f, 0x77eb, 0x78c7, 0x79a3, 0x7a7e, 0x7b5a, 0x7c36, 0x7d12, 
  0x7dee, 0x7eca, 0x7fa6, 0x8082, 0x815d, 0x8239, 0x8315, 0x83f1, 
  0x84cd, 0x85a9, 0x8685, 0x8760, 0x883c, 0x8918, 0x89f4, 0x8ad0, 
  0x8bac, 0x8c88, 0x8d63, 0x8e3f, 0x8f1b, 0x8ff7, 0x90d3, 0x91af, 
  0x928b, 0x9366, 0x9442, 0x951e, 0x95fa, 0x96d6, 0x97b2, 0x988e, 
  0x9969, 0x9a45, 0x9b21, 0x9bfd, 0x9cd9, 0x9db5, 0x9e91, 0x9f6c, 
  0xa048, 0xa124, 0xa200, 0xa2dc, 0xa3b8, 0xa494, 0xa56f, 0xa64b, 
  0xa727, 0xa803, 0xa8df, 0xa9bb, 0xaa97, 0xab72, 0xac4e, 0xad2a, 
  0xae06, 0xaee2, 0xafbe, 0xb09a, 0xb175, 0xb251, 0xb32d, 0xb409, 
  0xb4e5, 0xb5c1, 0xb69d, 0xb778, 0xb854, 0xb930, 0xba0c, 0xbae8, 
  0xbbc4, 0xbca0, 0xbd7b, 0xbe57, 0xbf33, 0xc00f, 0xc0eb, 0xc1c7, 
  0xc2a3, 0xc37e, 0xc45a, 0xc536, 0xc612, 0xc6ee, 0xc7ca, 0xc8a6, 
  0xc982, 0xca5d, 0xcb39, 0xcc15, 0xccf1, 0xcdcd, 0xcea9, 0xcf85, 
  0xd060, 0xd13c, 0xd218, 0xd2f4, 0xd3d0, 0xd4ac, 0xd588, 0xd663, 
  0xd73f, 0xd81b, 0xd8f7, 0xd9d3, 0xdaaf, 0xdb8b, 0xdc66, 0xdd42, 
  0xde1e, 0xdefa, 0xdfd6, 0xe0b2, 0xe18e, 0xe269, 0xe345, 0xe421, 
  0xe4fd, 0xe5d9, 0xe6b5, 0xe791, 0xe86c, 0xe948, 0xea24, 0xeb00, 
};

uint16_t gavl_uvj_8_to_uv_16[256] = 
{
  0x0f90, 0x1070, 0x1151, 0x1232, 0x1313, 0x13f4, 0x14d5, 0x15b6, 
  0x1697, 0x1777, 0x1858, 0x1939, 0x1a1a, 0x1afb, 0x1bdc, 0x1cbd, 
  0x1d9e, 0x1e7e, 0x1f5f, 0x2040, 0x2121, 0x2202, 0x22e3, 0x23c4, 
  0x24a5, 0x2586, 0x2666, 0x2747, 0x2828, 0x2909, 0x29ea, 0x2acb, 
  0x2bac, 0x2c8d, 0x2d6d, 0x2e4e, 0x2f2f, 0x3010, 0x30f1, 0x31d2, 
  0x32b3, 0x3394, 0x3474, 0x3555, 0x3636, 0x3717, 0x37f8, 0x38d9, 
  0x39ba, 0x3a9b, 0x3b7b, 0x3c5c, 0x3d3d, 0x3e1e, 0x3eff, 0x3fe0, 
  0x40c1, 0x41a2, 0x4283, 0x4363, 0x4444, 0x4525, 0x4606, 0x46e7, 
  0x47c8, 0x48a9, 0x498a, 0x4a6a, 0x4b4b, 0x4c2c, 0x4d0d, 0x4dee, 
  0x4ecf, 0x4fb0, 0x5091, 0x5171, 0x5252, 0x5333, 0x5414, 0x54f5, 
  0x55d6, 0x56b7, 0x5798, 0x5878, 0x5959, 0x5a3a, 0x5b1b, 0x5bfc, 
  0x5cdd, 0x5dbe, 0x5e9f, 0x5f7f, 0x6060, 0x6141, 0x6222, 0x6303, 
  0x63e4, 0x64c5, 0x65a6, 0x6687, 0x6767, 0x6848, 0x6929, 0x6a0a, 
  0x6aeb, 0x6bcc, 0x6cad, 0x6d8e, 0x6e6e, 0x6f4f, 0x7030, 0x7111, 
  0x71f2, 0x72d3, 0x73b4, 0x7495, 0x7575, 0x7656, 0x7737, 0x7818, 
  0x78f9, 0x79da, 0x7abb, 0x7b9c, 0x7c7c, 0x7d5d, 0x7e3e, 0x7f1f, 
  0x8000, 0x80e1, 0x81c2, 0x82a3, 0x8384, 0x8464, 0x8545, 0x8626, 
  0x8707, 0x87e8, 0x88c9, 0x89aa, 0x8a8b, 0x8b6b, 0x8c4c, 0x8d2d, 
  0x8e0e, 0x8eef, 0x8fd0, 0x90b1, 0x9192, 0x9272, 0x9353, 0x9434, 
  0x9515, 0x95f6, 0x96d7, 0x97b8, 0x9899, 0x9979, 0x9a5a, 0x9b3b, 
  0x9c1c, 0x9cfd, 0x9dde, 0x9ebf, 0x9fa0, 0xa081, 0xa161, 0xa242, 
  0xa323, 0xa404, 0xa4e5, 0xa5c6, 0xa6a7, 0xa788, 0xa868, 0xa949, 
  0xaa2a, 0xab0b, 0xabec, 0xaccd, 0xadae, 0xae8f, 0xaf6f, 0xb050, 
  0xb131, 0xb212, 0xb2f3, 0xb3d4, 0xb4b5, 0xb596, 0xb676, 0xb757, 
  0xb838, 0xb919, 0xb9fa, 0xbadb, 0xbbbc, 0xbc9d, 0xbd7d, 0xbe5e, 
  0xbf3f, 0xc020, 0xc101, 0xc1e2, 0xc2c3, 0xc3a4, 0xc485, 0xc565, 
  0xc646, 0xc727, 0xc808, 0xc8e9, 0xc9ca, 0xcaab, 0xcb8c, 0xcc6c, 
  0xcd4d, 0xce2e, 0xcf0f, 0xcff0, 0xd0d1, 0xd1b2, 0xd293, 0xd373, 
  0xd454, 0xd535, 0xd616, 0xd6f7, 0xd7d8, 0xd8b9, 0xd99a, 0xda7a, 
  0xdb5b, 0xdc3c, 0xdd1d, 0xddfe, 0xdedf, 0xdfc0, 0xe0a1, 0xe182, 
  0xe262, 0xe343, 0xe424, 0xe505, 0xe5e6, 0xe6c7, 0xe7a8, 0xe889, 
  0xe969, 0xea4a, 0xeb2b, 0xec0c, 0xeced, 0xedce, 0xeeaf, 0xef90, 
};

uint8_t gavl_y_8_to_yj_8[256] = 
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x01, 0x02, 0x03, 0x05, 0x06, 0x07, 0x08, 
  0x09, 0x0a, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 
  0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x1a, 0x1b, 
  0x1c, 0x1d, 0x1e, 0x1f, 0x21, 0x22, 0x23, 0x24, 
  0x25, 0x26, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 
  0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x36, 0x37, 
  0x38, 0x39, 0x3a, 0x3b, 0x3d, 0x3e, 0x3f, 0x40, 
  0x41, 0x42, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 
  0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x52, 0x53, 
  0x54, 0x55, 0x56, 0x57, 0x58, 0x5a, 0x5b, 0x5c, 
  0x5d, 0x5e, 0x5f, 0x61, 0x62, 0x63, 0x64, 0x65, 
  0x66, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6f, 
  0x70, 0x71, 0x72, 0x73, 0x74, 0x76, 0x77, 0x78, 
  0x79, 0x7a, 0x7b, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 
  0x82, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8b, 
  0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x92, 0x93, 0x94, 
  0x95, 0x96, 0x97, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 
  0x9e, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa7, 
  0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xaf, 0xb0, 
  0xb1, 0xb2, 0xb3, 0xb4, 0xb6, 0xb7, 0xb8, 0xb9, 
  0xba, 0xbb, 0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 
  0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xcb, 0xcc, 
  0xcd, 0xce, 0xcf, 0xd0, 0xd2, 0xd3, 0xd4, 0xd5, 
  0xd6, 0xd7, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe7, 0xe8, 
  0xe9, 0xea, 0xeb, 0xec, 0xee, 0xef, 0xf0, 0xf1, 
  0xf2, 0xf3, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 
  0xfc, 0xfd, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};

uint8_t gavl_uv_8_to_uvj_8[256] = 
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
  0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x12, 
  0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x1a, 0x1b, 
  0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x22, 0x23, 0x24, 
  0x25, 0x26, 0x27, 0x28, 0x29, 0x2b, 0x2c, 0x2d, 
  0x2e, 0x2f, 0x30, 0x31, 0x33, 0x34, 0x35, 0x36, 
  0x37, 0x38, 0x39, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
  0x40, 0x41, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 
  0x49, 0x4a, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 
  0x52, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 
  0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x64, 
  0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6c, 0x6d, 
  0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x75, 0x76, 
  0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7d, 0x7e, 0x7f, 
  0x80, 0x81, 0x82, 0x83, 0x85, 0x86, 0x87, 0x88, 
  0x89, 0x8a, 0x8b, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 
  0x92, 0x93, 0x94, 0x96, 0x97, 0x98, 0x99, 0x9a, 
  0x9b, 0x9c, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 
  0xa4, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 
  0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb6, 
  0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbf, 
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc7, 0xc8, 
  0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xcf, 0xd0, 0xd1, 
  0xd2, 0xd3, 0xd4, 0xd5, 0xd7, 0xd8, 0xd9, 0xda, 
  0xdb, 0xdc, 0xdd, 0xde, 0xe0, 0xe1, 0xe2, 0xe3, 
  0xe4, 0xe5, 0xe6, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 
  0xed, 0xee, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 
  0xf6, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};

uint8_t gavl_rgb_5_to_8[32] = 
{
  0x00, 0x08, 0x10, 0x19, 0x21, 0x29, 0x31, 0x3a, 
  0x42, 0x4a, 0x52, 0x5a, 0x63, 0x6b, 0x73, 0x7b, 
  0x84, 0x8c, 0x94, 0x9c, 0xa5, 0xad, 0xb5, 0xbd, 
  0xc5, 0xce, 0xd6, 0xde, 0xe6, 0xef, 0xf7, 0xff, 
};

uint8_t gavl_rgb_6_to_8[64] = 
{
  0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 
  0x20, 0x24, 0x28, 0x2d, 0x31, 0x35, 0x39, 0x3d, 
  0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59, 0x5d, 
  0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 
  0x82, 0x86, 0x8a, 0x8e, 0x92, 0x96, 0x9a, 0x9e, 
  0xa2, 0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0xba, 0xbe, 
  0xc2, 0xc6, 0xca, 0xce, 0xd2, 0xd7, 0xdb, 0xdf, 
  0xe3, 0xe7, 0xeb, 0xef, 0xf3, 0xf7, 0xfb, 0xff, 
};

uint16_t gavl_rgb_5_to_16[32] = 
{
  0x0000, 0x0842, 0x1084, 0x18c6, 0x2108, 0x294a, 0x318c, 0x39ce, 
  0x4210, 0x4a52, 0x5294, 0x5ad6, 0x6318, 0x6b5a, 0x739c, 0x7bde, 
  0x8421, 0x8c63, 0x94a5, 0x9ce7, 0xa529, 0xad6b, 0xb5ad, 0xbdef, 
  0xc631, 0xce73, 0xd6b5, 0xdef7, 0xe739, 0xef7b, 0xf7bd, 0xffff, 
};

uint16_t gavl_rgb_6_to_16[64] = 
{
  0x0000, 0x0410, 0x0820, 0x0c31, 0x1041, 0x1451, 0x1861, 0x1c72, 
  0x2082, 0x2492, 0x28a2, 0x2cb3, 0x30c3, 0x34d3, 0x38e3, 0x3cf4, 
  0x4104, 0x4514, 0x4924, 0x4d35, 0x5145, 0x5555, 0x5965, 0x5d75, 
  0x6186, 0x6596, 0x69a6, 0x6db6, 0x71c7, 0x75d7, 0x79e7, 0x7df7, 
  0x8208, 0x8618, 0x8a28, 0x8e38, 0x9249, 0x9659, 0x9a69, 0x9e79, 
  0xa28a, 0xa69a, 0xaaaa, 0xaeba, 0xb2ca, 0xb6db, 0xbaeb, 0xbefb, 
  0xc30b, 0xc71c, 0xcb2c, 0xcf3c, 0xd34c, 0xd75d, 0xdb6d, 0xdf7d, 
  0xe38d, 0xe79e, 0xebae, 0xefbe, 0xf3ce, 0xf7df, 0xfbef, 0xffff, 
};

float gavl_rgb_5_to_float[32] = 
{
  0.000000, 0.032258, 0.064516, 0.096774, 0.129032, 0.161290, 0.193548, 0.225806, 
  0.258065, 0.290323, 0.322581, 0.354839, 0.387097, 0.419355, 0.451613, 0.483871, 
  0.516129, 0.548387, 0.580645, 0.612903, 0.645161, 0.677419, 0.709677, 0.741935, 
  0.774194, 0.806452, 0.838710, 0.870968, 0.903226, 0.935484, 0.967742, 1.000000, 
};

float gavl_rgb_6_to_float[64] = 
{
  0.000000, 0.015873, 0.031746, 0.047619, 0.063492, 0.079365, 0.095238, 0.111111, 
  0.126984, 0.142857, 0.158730, 0.174603, 0.190476, 0.206349, 0.222222, 0.238095, 
  0.253968, 0.269841, 0.285714, 0.301587, 0.317460, 0.333333, 0.349206, 0.365079, 
  0.380952, 0.396825, 0.412698, 0.428571, 0.444444, 0.460317, 0.476190, 0.492063, 
  0.507937, 0.523810, 0.539683, 0.555556, 0.571429, 0.587302, 0.603175, 0.619048, 
  0.634921, 0.650794, 0.666667, 0.682540, 0.698413, 0.714286, 0.730159, 0.746032, 
  0.761905, 0.777778, 0.793651, 0.809524, 0.825397, 0.841270, 0.857143, 0.873016, 
  0.888889, 0.904762, 0.920635, 0.936508, 0.952381, 0.968254, 0.984127, 1.000000, 
};

/* RGB -> YUV conversions */
int gavl_r_to_y[256] = 
{
  1048576, 1065404, 1082233, 1099062, 1115891, 1132720, 1149549, 1166378, 
  1183206, 1200035, 1216864, 1233693, 1250522, 1267351, 1284180, 1301009, 
  1317837, 1334666, 1351495, 1368324, 1385153, 1401982, 1418811, 1435640, 
  1452468, 1469297, 1486126, 1502955, 1519784, 1536613, 1553442, 1570271, 
  1587099, 1603928, 1620757, 1637586, 1654415, 1671244, 1688073, 1704902, 
  1721730, 1738559, 1755388, 1772217, 1789046, 1805875, 1822704, 1839533, 
  1856361, 1873190, 1890019, 1906848, 1923677, 1940506, 1957335, 1974164, 
  1990992, 2007821, 2024650, 2041479, 2058308, 2075137, 2091966, 2108795, 
  2125623, 2142452, 2159281, 2176110, 2192939, 2209768, 2226597, 2243426, 
  2260254, 2277083, 2293912, 2310741, 2327570, 2344399, 2361228, 2378057, 
  2394885, 2411714, 2428543, 2445372, 2462201, 2479030, 2495859, 2512688, 
  2529516, 2546345, 2563174, 2580003, 2596832, 2613661, 2630490, 2647319, 
  2664147, 2680976, 2697805, 2714634, 2731463, 2748292, 2765121, 2781950, 
  2798778, 2815607, 2832436, 2849265, 2866094, 2882923, 2899752, 2916580, 
  2933409, 2950238, 2967067, 2983896, 3000725, 3017554, 3034383, 3051211, 
  3068040, 3084869, 3101698, 3118527, 3135356, 3152185, 3169014, 3185842, 
  3202671, 3219500, 3236329, 3253158, 3269987, 3286816, 3303645, 3320473, 
  3337302, 3354131, 3370960, 3387789, 3404618, 3421447, 3438276, 3455104, 
  3471933, 3488762, 3505591, 3522420, 3539249, 3556078, 3572907, 3589735, 
  3606564, 3623393, 3640222, 3657051, 3673880, 3690709, 3707538, 3724366, 
  3741195, 3758024, 3774853, 3791682, 3808511, 3825340, 3842169, 3858997, 
  3875826, 3892655, 3909484, 3926313, 3943142, 3959971, 3976800, 3993628, 
  4010457, 4027286, 4044115, 4060944, 4077773, 4094602, 4111431, 4128259, 
  4145088, 4161917, 4178746, 4195575, 4212404, 4229233, 4246062, 4262890, 
  4279719, 4296548, 4313377, 4330206, 4347035, 4363864, 4380693, 4397521, 
  4414350, 4431179, 4448008, 4464837, 4481666, 4498495, 4515324, 4532152, 
  4548981, 4565810, 4582639, 4599468, 4616297, 4633126, 4649954, 4666783, 
  4683612, 4700441, 4717270, 4734099, 4750928, 4767757, 4784585, 4801414, 
  4818243, 4835072, 4851901, 4868730, 4885559, 4902388, 4919216, 4936045, 
  4952874, 4969703, 4986532, 5003361, 5020190, 5037019, 5053847, 5070676, 
  5087505, 5104334, 5121163, 5137992, 5154821, 5171650, 5188478, 5205307, 
  5222136, 5238965, 5255794, 5272623, 5289452, 5306281, 5323109, 5339938, 
};

int gavl_g_to_y[256] = 
{
  0, 33038, 66077, 99115, 132154, 165193, 198231, 231270, 
  264309, 297347, 330386, 363424, 396463, 429502, 462540, 495579, 
  528618, 561656, 594695, 627733, 660772, 693811, 726849, 759888, 
  792927, 825965, 859004, 892042, 925081, 958120, 991158, 1024197, 
  1057236, 1090274, 1123313, 1156351, 1189390, 1222429, 1255467, 1288506, 
  1321545, 1354583, 1387622, 1420660, 1453699, 1486738, 1519776, 1552815, 
  1585854, 1618892, 1651931, 1684969, 1718008, 1751047, 1784085, 1817124, 
  1850163, 1883201, 1916240, 1949278, 1982317, 2015356, 2048394, 2081433, 
  2114472, 2147510, 2180549, 2213587, 2246626, 2279665, 2312703, 2345742, 
  2378781, 2411819, 2444858, 2477896, 2510935, 2543974, 2577012, 2610051, 
  2643090, 2676128, 2709167, 2742205, 2775244, 2808283, 2841321, 2874360, 
  2907399, 2940437, 2973476, 3006514, 3039553, 3072592, 3105630, 3138669, 
  3171708, 3204746, 3237785, 3270823, 3303862, 3336901, 3369939, 3402978, 
  3436017, 3469055, 3502094, 3535132, 3568171, 3601210, 3634248, 3667287, 
  3700326, 3733364, 3766403, 3799441, 3832480, 3865519, 3898557, 3931596, 
  3964635, 3997673, 4030712, 4063750, 4096789, 4129828, 4162866, 4195905, 
  4228944, 4261982, 4295021, 4328059, 4361098, 4394137, 4427175, 4460214, 
  4493253, 4526291, 4559330, 4592368, 4625407, 4658446, 4691484, 4724523, 
  4757562, 4790600, 4823639, 4856677, 4889716, 4922755, 4955793, 4988832, 
  5021871, 5054909, 5087948, 5120986, 5154025, 5187064, 5220102, 5253141, 
  5286180, 5319218, 5352257, 5385295, 5418334, 5451373, 5484411, 5517450, 
  5550489, 5583527, 5616566, 5649604, 5682643, 5715682, 5748720, 5781759, 
  5814798, 5847836, 5880875, 5913913, 5946952, 5979991, 6013029, 6046068, 
  6079107, 6112145, 6145184, 6178222, 6211261, 6244300, 6277338, 6310377, 
  6343416, 6376454, 6409493, 6442531, 6475570, 6508609, 6541647, 6574686, 
  6607725, 6640763, 6673802, 6706840, 6739879, 6772918, 6805956, 6838995, 
  6872034, 6905072, 6938111, 6971149, 7004188, 7037227, 7070265, 7103304, 
  7136343, 7169381, 7202420, 7235458, 7268497, 7301536, 7334574, 7367613, 
  7400652, 7433690, 7466729, 7499767, 7532806, 7565845, 7598883, 7631922, 
  7664961, 7697999, 7731038, 7764076, 7797115, 7830154, 7863192, 7896231, 
  7929270, 7962308, 7995347, 8028385, 8061424, 8094463, 8127501, 8160540, 
  8193579, 8226617, 8259656, 8292694, 8325733, 8358772, 8391810, 8424849, 
};

int gavl_b_to_y[256] = 
{
  0, 6416, 12832, 19249, 25665, 32081, 38498, 44914, 
  51330, 57747, 64163, 70579, 76996, 83412, 89829, 96245, 
  102661, 109078, 115494, 121910, 128327, 134743, 141159, 147576, 
  153992, 160408, 166825, 173241, 179658, 186074, 192490, 198907, 
  205323, 211739, 218156, 224572, 230988, 237405, 243821, 250238, 
  256654, 263070, 269487, 275903, 282319, 288736, 295152, 301568, 
  307985, 314401, 320817, 327234, 333650, 340067, 346483, 352899, 
  359316, 365732, 372148, 378565, 384981, 391397, 397814, 404230, 
  410647, 417063, 423479, 429896, 436312, 442728, 449145, 455561, 
  461977, 468394, 474810, 481226, 487643, 494059, 500476, 506892, 
  513308, 519725, 526141, 532557, 538974, 545390, 551806, 558223, 
  564639, 571056, 577472, 583888, 590305, 596721, 603137, 609554, 
  615970, 622386, 628803, 635219, 641635, 648052, 654468, 660885, 
  667301, 673717, 680134, 686550, 692966, 699383, 705799, 712215, 
  718632, 725048, 731465, 737881, 744297, 750714, 757130, 763546, 
  769963, 776379, 782795, 789212, 795628, 802044, 808461, 814877, 
  821294, 827710, 834126, 840543, 846959, 853375, 859792, 866208, 
  872624, 879041, 885457, 891874, 898290, 904706, 911123, 917539, 
  923955, 930372, 936788, 943204, 949621, 956037, 962453, 968870, 
  975286, 981703, 988119, 994535, 1000952, 1007368, 1013784, 1020201, 
  1026617, 1033033, 1039450, 1045866, 1052283, 1058699, 1065115, 1071532, 
  1077948, 1084364, 1090781, 1097197, 1103613, 1110030, 1116446, 1122862, 
  1129279, 1135695, 1142112, 1148528, 1154944, 1161361, 1167777, 1174193, 
  1180610, 1187026, 1193442, 1199859, 1206275, 1212692, 1219108, 1225524, 
  1231941, 1238357, 1244773, 1251190, 1257606, 1264022, 1270439, 1276855, 
  1283271, 1289688, 1296104, 1302521, 1308937, 1315353, 1321770, 1328186, 
  1334602, 1341019, 1347435, 1353851, 1360268, 1366684, 1373101, 1379517, 
  1385933, 1392350, 1398766, 1405182, 1411599, 1418015, 1424431, 1430848, 
  1437264, 1443680, 1450097, 1456513, 1462930, 1469346, 1475762, 1482179, 
  1488595, 1495011, 1501428, 1507844, 1514260, 1520677, 1527093, 1533510, 
  1539926, 1546342, 1552759, 1559175, 1565591, 1572008, 1578424, 1584840, 
  1591257, 1597673, 1604089, 1610506, 1616922, 1623339, 1629755, 1636171, 
};

int gavl_r_to_u[256] = 
{
  0, -9714, -19428, -29142, -38856, -48570, -58285, -67999, 
  -77713, -87427, -97141, -106855, -116570, -126284, -135998, -145712, 
  -155426, -165140, -174855, -184569, -194283, -203997, -213711, -223425, 
  -233140, -242854, -252568, -262282, -271996, -281711, -291425, -301139, 
  -310853, -320567, -330281, -339996, -349710, -359424, -369138, -378852, 
  -388566, -398281, -407995, -417709, -427423, -437137, -446851, -456566, 
  -466280, -475994, -485708, -495422, -505136, -514851, -524565, -534279, 
  -543993, -553707, -563422, -573136, -582850, -592564, -602278, -611992, 
  -621707, -631421, -641135, -650849, -660563, -670277, -679992, -689706, 
  -699420, -709134, -718848, -728562, -738277, -747991, -757705, -767419, 
  -777133, -786847, -796562, -806276, -815990, -825704, -835418, -845133, 
  -854847, -864561, -874275, -883989, -893703, -903418, -913132, -922846, 
  -932560, -942274, -951988, -961703, -971417, -981131, -990845, -1000559, 
  -1010273, -1019988, -1029702, -1039416, -1049130, -1058844, -1068558, -1078273, 
  -1087987, -1097701, -1107415, -1117129, -1126844, -1136558, -1146272, -1155986, 
  -1165700, -1175414, -1185129, -1194843, -1204557, -1214271, -1223985, -1233699, 
  -1243414, -1253128, -1262842, -1272556, -1282270, -1291984, -1301699, -1311413, 
  -1321127, -1330841, -1340555, -1350269, -1359984, -1369698, -1379412, -1389126, 
  -1398840, -1408555, -1418269, -1427983, -1437697, -1447411, -1457125, -1466840, 
  -1476554, -1486268, -1495982, -1505696, -1515410, -1525125, -1534839, -1544553, 
  -1554267, -1563981, -1573695, -1583410, -1593124, -1602838, -1612552, -1622266, 
  -1631980, -1641695, -1651409, -1661123, -1670837, -1680551, -1690266, -1699980, 
  -1709694, -1719408, -1729122, -1738836, -1748551, -1758265, -1767979, -1777693, 
  -1787407, -1797121, -1806836, -1816550, -1826264, -1835978, -1845692, -1855406, 
  -1865121, -1874835, -1884549, -1894263, -1903977, -1913691, -1923406, -1933120, 
  -1942834, -1952548, -1962262, -1971977, -1981691, -1991405, -2001119, -2010833, 
  -2020547, -2030262, -2039976, -2049690, -2059404, -2069118, -2078832, -2088547, 
  -2098261, -2107975, -2117689, -2127403, -2137117, -2146832, -2156546, -2166260, 
  -2175974, -2185688, -2195402, -2205117, -2214831, -2224545, -2234259, -2243973, 
  -2253688, -2263402, -2273116, -2282830, -2292544, -2302258, -2311973, -2321687, 
  -2331401, -2341115, -2350829, -2360543, -2370258, -2379972, -2389686, -2399400, 
  -2409114, -2418828, -2428543, -2438257, -2447971, -2457685, -2467399, -2477113, 
};

int gavl_g_to_u[256] = 
{
  0, -19070, -38140, -57210, -76281, -95351, -114421, -133491, 
  -152562, -171632, -190702, -209772, -228843, -247913, -266983, -286054, 
  -305124, -324194, -343264, -362335, -381405, -400475, -419545, -438616, 
  -457686, -476756, -495826, -514897, -533967, -553037, -572108, -591178, 
  -610248, -629318, -648389, -667459, -686529, -705599, -724670, -743740, 
  -762810, -781880, -800951, -820021, -839091, -858162, -877232, -896302, 
  -915372, -934443, -953513, -972583, -991653, -1010724, -1029794, -1048864, 
  -1067934, -1087005, -1106075, -1125145, -1144216, -1163286, -1182356, -1201426, 
  -1220497, -1239567, -1258637, -1277707, -1296778, -1315848, -1334918, -1353988, 
  -1373059, -1392129, -1411199, -1430270, -1449340, -1468410, -1487480, -1506551, 
  -1525621, -1544691, -1563761, -1582832, -1601902, -1620972, -1640042, -1659113, 
  -1678183, -1697253, -1716324, -1735394, -1754464, -1773534, -1792605, -1811675, 
  -1830745, -1849815, -1868886, -1887956, -1907026, -1926096, -1945167, -1964237, 
  -1983307, -2002378, -2021448, -2040518, -2059588, -2078659, -2097729, -2116799, 
  -2135869, -2154940, -2174010, -2193080, -2212150, -2231221, -2250291, -2269361, 
  -2288432, -2307502, -2326572, -2345642, -2364713, -2383783, -2402853, -2421923, 
  -2440994, -2460064, -2479134, -2498204, -2517275, -2536345, -2555415, -2574486, 
  -2593556, -2612626, -2631696, -2650767, -2669837, -2688907, -2707977, -2727048, 
  -2746118, -2765188, -2784258, -2803329, -2822399, -2841469, -2860540, -2879610, 
  -2898680, -2917750, -2936821, -2955891, -2974961, -2994031, -3013102, -3032172, 
  -3051242, -3070312, -3089383, -3108453, -3127523, -3146594, -3165664, -3184734, 
  -3203804, -3222875, -3241945, -3261015, -3280085, -3299156, -3318226, -3337296, 
  -3356366, -3375437, -3394507, -3413577, -3432648, -3451718, -3470788, -3489858, 
  -3508929, -3527999, -3547069, -3566139, -3585210, -3604280, -3623350, -3642420, 
  -3661491, -3680561, -3699631, -3718702, -3737772, -3756842, -3775912, -3794983, 
  -3814053, -3833123, -3852193, -3871264, -3890334, -3909404, -3928474, -3947545, 
  -3966615, -3985685, -4004756, -4023826, -4042896, -4061966, -4081037, -4100107, 
  -4119177, -4138247, -4157318, -4176388, -4195458, -4214528, -4233599, -4252669, 
  -4271739, -4290810, -4309880, -4328950, -4348020, -4367091, -4386161, -4405231, 
  -4424301, -4443372, -4462442, -4481512, -4500582, -4519653, -4538723, -4557793, 
  -4576864, -4595934, -4615004, -4634074, -4653145, -4672215, -4691285, -4710355, 
  -4729426, -4748496, -4767566, -4786636, -4805707, -4824777, -4843847, -4862918, 
};

int gavl_b_to_u[256] = 
{
  8388608, 8417392, 8446176, 8474961, 8503745, 8532530, 8561314, 8590099, 
  8618883, 8647667, 8676452, 8705236, 8734021, 8762805, 8791590, 8820374, 
  8849159, 8877943, 8906727, 8935512, 8964296, 8993081, 9021865, 9050650, 
  9079434, 9108218, 9137003, 9165787, 9194572, 9223356, 9252141, 9280925, 
  9309710, 9338494, 9367278, 9396063, 9424847, 9453632, 9482416, 9511201, 
  9539985, 9568770, 9597554, 9626338, 9655123, 9683907, 9712692, 9741476, 
  9770261, 9799045, 9827829, 9856614, 9885398, 9914183, 9942967, 9971752, 
  10000536, 10029321, 10058105, 10086889, 10115674, 10144458, 10173243, 10202027, 
  10230812, 10259596, 10288380, 10317165, 10345949, 10374734, 10403518, 10432303, 
  10461087, 10489872, 10518656, 10547440, 10576225, 10605009, 10633794, 10662578, 
  10691363, 10720147, 10748932, 10777716, 10806500, 10835285, 10864069, 10892854, 
  10921638, 10950423, 10979207, 11007991, 11036776, 11065560, 11094345, 11123129, 
  11151914, 11180698, 11209483, 11238267, 11267051, 11295836, 11324620, 11353405, 
  11382189, 11410974, 11439758, 11468542, 11497327, 11526111, 11554896, 11583680, 
  11612465, 11641249, 11670034, 11698818, 11727602, 11756387, 11785171, 11813956, 
  11842740, 11871525, 11900309, 11929094, 11957878, 11986662, 12015447, 12044231, 
  12073016, 12101800, 12130585, 12159369, 12188153, 12216938, 12245722, 12274507, 
  12303291, 12332076, 12360860, 12389645, 12418429, 12447213, 12475998, 12504782, 
  12533567, 12562351, 12591136, 12619920, 12648705, 12677489, 12706273, 12735058, 
  12763842, 12792627, 12821411, 12850196, 12878980, 12907764, 12936549, 12965333, 
  12994118, 13022902, 13051687, 13080471, 13109256, 13138040, 13166824, 13195609, 
  13224393, 13253178, 13281962, 13310747, 13339531, 13368315, 13397100, 13425884, 
  13454669, 13483453, 13512238, 13541022, 13569807, 13598591, 13627375, 13656160, 
  13684944, 13713729, 13742513, 13771298, 13800082, 13828867, 13857651, 13886435, 
  13915220, 13944004, 13972789, 14001573, 14030358, 14059142, 14087926, 14116711, 
  14145495, 14174280, 14203064, 14231849, 14260633, 14289418, 14318202, 14346986, 
  14375771, 14404555, 14433340, 14462124, 14490909, 14519693, 14548477, 14577262, 
  14606046, 14634831, 14663615, 14692400, 14721184, 14749969, 14778753, 14807537, 
  14836322, 14865106, 14893891, 14922675, 14951460, 14980244, 15009029, 15037813, 
  15066597, 15095382, 15124166, 15152951, 15181735, 15210520, 15239304, 15268088, 
  15296873, 15325657, 15354442, 15383226, 15412011, 15440795, 15469580, 15498364, 
  15527148, 15555933, 15584717, 15613502, 15642286, 15671071, 15699855, 15728639, 
};

int gavl_r_to_v[256] = 
{
  0, 28784, 57568, 86353, 115137, 143922, 172706, 201491, 
  230275, 259059, 287844, 316628, 345413, 374197, 402982, 431766, 
  460551, 489335, 518119, 546904, 575688, 604473, 633257, 662042, 
  690826, 719610, 748395, 777179, 805964, 834748, 863533, 892317, 
  921102, 949886, 978670, 1007455, 1036239, 1065024, 1093808, 1122593, 
  1151377, 1180162, 1208946, 1237730, 1266515, 1295299, 1324084, 1352868, 
  1381653, 1410437, 1439221, 1468006, 1496790, 1525575, 1554359, 1583144, 
  1611928, 1640713, 1669497, 1698281, 1727066, 1755850, 1784635, 1813419, 
  1842204, 1870988, 1899772, 1928557, 1957341, 1986126, 2014910, 2043695, 
  2072479, 2101264, 2130048, 2158832, 2187617, 2216401, 2245186, 2273970, 
  2302755, 2331539, 2360324, 2389108, 2417892, 2446677, 2475461, 2504246, 
  2533030, 2561815, 2590599, 2619383, 2648168, 2676952, 2705737, 2734521, 
  2763306, 2792090, 2820875, 2849659, 2878443, 2907228, 2936012, 2964797, 
  2993581, 3022366, 3051150, 3079934, 3108719, 3137503, 3166288, 3195072, 
  3223857, 3252641, 3281426, 3310210, 3338994, 3367779, 3396563, 3425348, 
  3454132, 3482917, 3511701, 3540486, 3569270, 3598054, 3626839, 3655623, 
  3684408, 3713192, 3741977, 3770761, 3799545, 3828330, 3857114, 3885899, 
  3914683, 3943468, 3972252, 4001037, 4029821, 4058605, 4087390, 4116174, 
  4144959, 4173743, 4202528, 4231312, 4260097, 4288881, 4317665, 4346450, 
  4375234, 4404019, 4432803, 4461588, 4490372, 4519156, 4547941, 4576725, 
  4605510, 4634294, 4663079, 4691863, 4720648, 4749432, 4778216, 4807001, 
  4835785, 4864570, 4893354, 4922139, 4950923, 4979707, 5008492, 5037276, 
  5066061, 5094845, 5123630, 5152414, 5181199, 5209983, 5238767, 5267552, 
  5296336, 5325121, 5353905, 5382690, 5411474, 5440259, 5469043, 5497827, 
  5526612, 5555396, 5584181, 5612965, 5641750, 5670534, 5699318, 5728103, 
  5756887, 5785672, 5814456, 5843241, 5872025, 5900810, 5929594, 5958378, 
  5987163, 6015947, 6044732, 6073516, 6102301, 6131085, 6159869, 6188654, 
  6217438, 6246223, 6275007, 6303792, 6332576, 6361361, 6390145, 6418929, 
  6447714, 6476498, 6505283, 6534067, 6562852, 6591636, 6620421, 6649205, 
  6677989, 6706774, 6735558, 6764343, 6793127, 6821912, 6850696, 6879480, 
  6908265, 6937049, 6965834, 6994618, 7023403, 7052187, 7080972, 7109756, 
  7138540, 7167325, 7196109, 7224894, 7253678, 7282463, 7311247, 7340031, 
};

int gavl_g_to_v[256] = 
{
  0, -24103, -48207, -72310, -96414, -120517, -144621, -168724, 
  -192828, -216931, -241035, -265138, -289242, -313345, -337449, -361552, 
  -385656, -409759, -433863, -457966, -482070, -506173, -530277, -554380, 
  -578484, -602587, -626691, -650794, -674898, -699001, -723105, -747208, 
  -771312, -795415, -819519, -843622, -867726, -891830, -915933, -940037, 
  -964140, -988244, -1012347, -1036451, -1060554, -1084658, -1108761, -1132865, 
  -1156968, -1181072, -1205175, -1229279, -1253382, -1277486, -1301589, -1325693, 
  -1349796, -1373900, -1398003, -1422107, -1446210, -1470314, -1494417, -1518521, 
  -1542624, -1566728, -1590831, -1614935, -1639038, -1663142, -1687245, -1711349, 
  -1735452, -1759556, -1783660, -1807763, -1831867, -1855970, -1880074, -1904177, 
  -1928281, -1952384, -1976488, -2000591, -2024695, -2048798, -2072902, -2097005, 
  -2121109, -2145212, -2169316, -2193419, -2217523, -2241626, -2265730, -2289833, 
  -2313937, -2338040, -2362144, -2386247, -2410351, -2434454, -2458558, -2482661, 
  -2506765, -2530868, -2554972, -2579075, -2603179, -2627282, -2651386, -2675490, 
  -2699593, -2723697, -2747800, -2771904, -2796007, -2820111, -2844214, -2868318, 
  -2892421, -2916525, -2940628, -2964732, -2988835, -3012939, -3037042, -3061146, 
  -3085249, -3109353, -3133456, -3157560, -3181663, -3205767, -3229870, -3253974, 
  -3278077, -3302181, -3326284, -3350388, -3374491, -3398595, -3422698, -3446802, 
  -3470905, -3495009, -3519113, -3543216, -3567320, -3591423, -3615527, -3639630, 
  -3663734, -3687837, -3711941, -3736044, -3760148, -3784251, -3808355, -3832458, 
  -3856562, -3880665, -3904769, -3928872, -3952976, -3977079, -4001183, -4025286, 
  -4049390, -4073493, -4097597, -4121700, -4145804, -4169907, -4194011, -4218114, 
  -4242218, -4266321, -4290425, -4314528, -4338632, -4362735, -4386839, -4410943, 
  -4435046, -4459150, -4483253, -4507357, -4531460, -4555564, -4579667, -4603771, 
  -4627874, -4651978, -4676081, -4700185, -4724288, -4748392, -4772495, -4796599, 
  -4820702, -4844806, -4868909, -4893013, -4917116, -4941220, -4965323, -4989427, 
  -5013530, -5037634, -5061737, -5085841, -5109944, -5134048, -5158151, -5182255, 
  -5206358, -5230462, -5254565, -5278669, -5302773, -5326876, -5350980, -5375083, 
  -5399187, -5423290, -5447394, -5471497, -5495601, -5519704, -5543808, -5567911, 
  -5592015, -5616118, -5640222, -5664325, -5688429, -5712532, -5736636, -5760739, 
  -5784843, -5808946, -5833050, -5857153, -5881257, -5905360, -5929464, -5953567, 
  -5977671, -6001774, -6025878, -6049981, -6074085, -6098188, -6122292, -6146395, 
};

int gavl_b_to_v[256] = 
{
  8388608, 8383927, 8379246, 8374565, 8369884, 8365203, 8360522, 8355841, 
  8351160, 8346479, 8341798, 8337117, 8332436, 8327755, 8323075, 8318394, 
  8313713, 8309032, 8304351, 8299670, 8294989, 8290308, 8285627, 8280946, 
  8276265, 8271584, 8266903, 8262223, 8257542, 8252861, 8248180, 8243499, 
  8238818, 8234137, 8229456, 8224775, 8220094, 8215413, 8210732, 8206051, 
  8201370, 8196690, 8192009, 8187328, 8182647, 8177966, 8173285, 8168604, 
  8163923, 8159242, 8154561, 8149880, 8145199, 8140518, 8135838, 8131157, 
  8126476, 8121795, 8117114, 8112433, 8107752, 8103071, 8098390, 8093709, 
  8089028, 8084347, 8079666, 8074985, 8070305, 8065624, 8060943, 8056262, 
  8051581, 8046900, 8042219, 8037538, 8032857, 8028176, 8023495, 8018814, 
  8014133, 8009453, 8004772, 8000091, 7995410, 7990729, 7986048, 7981367, 
  7976686, 7972005, 7967324, 7962643, 7957962, 7953281, 7948601, 7943920, 
  7939239, 7934558, 7929877, 7925196, 7920515, 7915834, 7911153, 7906472, 
  7901791, 7897110, 7892429, 7887748, 7883068, 7878387, 7873706, 7869025, 
  7864344, 7859663, 7854982, 7850301, 7845620, 7840939, 7836258, 7831577, 
  7826896, 7822216, 7817535, 7812854, 7808173, 7803492, 7798811, 7794130, 
  7789449, 7784768, 7780087, 7775406, 7770725, 7766044, 7761363, 7756683, 
  7752002, 7747321, 7742640, 7737959, 7733278, 7728597, 7723916, 7719235, 
  7714554, 7709873, 7705192, 7700511, 7695831, 7691150, 7686469, 7681788, 
  7677107, 7672426, 7667745, 7663064, 7658383, 7653702, 7649021, 7644340, 
  7639659, 7634978, 7630298, 7625617, 7620936, 7616255, 7611574, 7606893, 
  7602212, 7597531, 7592850, 7588169, 7583488, 7578807, 7574126, 7569446, 
  7564765, 7560084, 7555403, 7550722, 7546041, 7541360, 7536679, 7531998, 
  7527317, 7522636, 7517955, 7513274, 7508594, 7503913, 7499232, 7494551, 
  7489870, 7485189, 7480508, 7475827, 7471146, 7466465, 7461784, 7457103, 
  7452422, 7447741, 7443061, 7438380, 7433699, 7429018, 7424337, 7419656, 
  7414975, 7410294, 7405613, 7400932, 7396251, 7391570, 7386889, 7382209, 
  7377528, 7372847, 7368166, 7363485, 7358804, 7354123, 7349442, 7344761, 
  7340080, 7335399, 7330718, 7326037, 7321356, 7316676, 7311995, 7307314, 
  7302633, 7297952, 7293271, 7288590, 7283909, 7279228, 7274547, 7269866, 
  7265185, 7260504, 7255824, 7251143, 7246462, 7241781, 7237100, 7232419, 
  7227738, 7223057, 7218376, 7213695, 7209014, 7204333, 7199652, 7194971, 
};

int gavl_r_to_yj[256] = 
{
  0, 19595, 39190, 58785, 78381, 97976, 117571, 137166, 
  156762, 176357, 195952, 215547, 235143, 254738, 274333, 293928, 
  313524, 333119, 352714, 372310, 391905, 411500, 431095, 450691, 
  470286, 489881, 509476, 529072, 548667, 568262, 587857, 607453, 
  627048, 646643, 666238, 685834, 705429, 725024, 744620, 764215, 
  783810, 803405, 823001, 842596, 862191, 881786, 901382, 920977, 
  940572, 960167, 979763, 999358, 1018953, 1038548, 1058144, 1077739, 
  1097334, 1116930, 1136525, 1156120, 1175715, 1195311, 1214906, 1234501, 
  1254096, 1273692, 1293287, 1312882, 1332477, 1352073, 1371668, 1391263, 
  1410859, 1430454, 1450049, 1469644, 1489240, 1508835, 1528430, 1548025, 
  1567621, 1587216, 1606811, 1626406, 1646002, 1665597, 1685192, 1704787, 
  1724383, 1743978, 1763573, 1783169, 1802764, 1822359, 1841954, 1861550, 
  1881145, 1900740, 1920335, 1939931, 1959526, 1979121, 1998716, 2018312, 
  2037907, 2057502, 2077097, 2096693, 2116288, 2135883, 2155479, 2175074, 
  2194669, 2214264, 2233860, 2253455, 2273050, 2292645, 2312241, 2331836, 
  2351431, 2371026, 2390622, 2410217, 2429812, 2449407, 2469003, 2488598, 
  2508193, 2527789, 2547384, 2566979, 2586574, 2606170, 2625765, 2645360, 
  2664955, 2684551, 2704146, 2723741, 2743336, 2762932, 2782527, 2802122, 
  2821718, 2841313, 2860908, 2880503, 2900099, 2919694, 2939289, 2958884, 
  2978480, 2998075, 3017670, 3037265, 3056861, 3076456, 3096051, 3115646, 
  3135242, 3154837, 3174432, 3194028, 3213623, 3233218, 3252813, 3272409, 
  3292004, 3311599, 3331194, 3350790, 3370385, 3389980, 3409575, 3429171, 
  3448766, 3468361, 3487956, 3507552, 3527147, 3546742, 3566338, 3585933, 
  3605528, 3625123, 3644719, 3664314, 3683909, 3703504, 3723100, 3742695, 
  3762290, 3781885, 3801481, 3821076, 3840671, 3860267, 3879862, 3899457, 
  3919052, 3938648, 3958243, 3977838, 3997433, 4017029, 4036624, 4056219, 
  4075814, 4095410, 4115005, 4134600, 4154195, 4173791, 4193386, 4212981, 
  4232577, 4252172, 4271767, 4291362, 4310958, 4330553, 4350148, 4369743, 
  4389339, 4408934, 4428529, 4448124, 4467720, 4487315, 4506910, 4526505, 
  4546101, 4565696, 4585291, 4604887, 4624482, 4644077, 4663672, 4683268, 
  4702863, 4722458, 4742053, 4761649, 4781244, 4800839, 4820434, 4840030, 
  4859625, 4879220, 4898815, 4918411, 4938006, 4957601, 4977197, 4996792, 
};

int gavl_g_to_yj[256] = 
{
  0, 38469, 76939, 115408, 153878, 192348, 230817, 269287, 
  307757, 346226, 384696, 423165, 461635, 500105, 538574, 577044, 
  615514, 653983, 692453, 730923, 769392, 807862, 846331, 884801, 
  923271, 961740, 1000210, 1038680, 1077149, 1115619, 1154088, 1192558, 
  1231028, 1269497, 1307967, 1346437, 1384906, 1423376, 1461846, 1500315, 
  1538785, 1577254, 1615724, 1654194, 1692663, 1731133, 1769603, 1808072, 
  1846542, 1885011, 1923481, 1961951, 2000420, 2038890, 2077360, 2115829, 
  2154299, 2192769, 2231238, 2269708, 2308177, 2346647, 2385117, 2423586, 
  2462056, 2500526, 2538995, 2577465, 2615934, 2654404, 2692874, 2731343, 
  2769813, 2808283, 2846752, 2885222, 2923692, 2962161, 3000631, 3039100, 
  3077570, 3116040, 3154509, 3192979, 3231449, 3269918, 3308388, 3346857, 
  3385327, 3423797, 3462266, 3500736, 3539206, 3577675, 3616145, 3654615, 
  3693084, 3731554, 3770023, 3808493, 3846963, 3885432, 3923902, 3962372, 
  4000841, 4039311, 4077780, 4116250, 4154720, 4193189, 4231659, 4270129, 
  4308598, 4347068, 4385538, 4424007, 4462477, 4500946, 4539416, 4577886, 
  4616355, 4654825, 4693295, 4731764, 4770234, 4808703, 4847173, 4885643, 
  4924112, 4962582, 5001052, 5039521, 5077991, 5116461, 5154930, 5193400, 
  5231869, 5270339, 5308809, 5347278, 5385748, 5424218, 5462687, 5501157, 
  5539627, 5578096, 5616566, 5655035, 5693505, 5731975, 5770444, 5808914, 
  5847384, 5885853, 5924323, 5962792, 6001262, 6039732, 6078201, 6116671, 
  6155141, 6193610, 6232080, 6270550, 6309019, 6347489, 6385958, 6424428, 
  6462898, 6501367, 6539837, 6578307, 6616776, 6655246, 6693715, 6732185, 
  6770655, 6809124, 6847594, 6886064, 6924533, 6963003, 7001473, 7039942, 
  7078412, 7116881, 7155351, 7193821, 7232290, 7270760, 7309230, 7347699, 
  7386169, 7424638, 7463108, 7501578, 7540047, 7578517, 7616987, 7655456, 
  7693926, 7732396, 7770865, 7809335, 7847804, 7886274, 7924744, 7963213, 
  8001683, 8040153, 8078622, 8117092, 8155561, 8194031, 8232501, 8270970, 
  8309440, 8347910, 8386379, 8424849, 8463319, 8501788, 8540258, 8578727, 
  8617197, 8655667, 8694136, 8732606, 8771076, 8809545, 8848015, 8886484, 
  8924954, 8963424, 9001893, 9040363, 9078833, 9117302, 9155772, 9194242, 
  9232711, 9271181, 9309650, 9348120, 9386590, 9425059, 9463529, 9501999, 
  9540468, 9578938, 9617407, 9655877, 9694347, 9732816, 9771286, 9809756, 
};

int gavl_b_to_yj[256] = 
{
  0, 7471, 14942, 22413, 29884, 37355, 44826, 52297, 
  59768, 67239, 74711, 82182, 89653, 97124, 104595, 112066, 
  119537, 127008, 134479, 141950, 149422, 156893, 164364, 171835, 
  179306, 186777, 194248, 201719, 209190, 216662, 224133, 231604, 
  239075, 246546, 254017, 261488, 268959, 276430, 283901, 291373, 
  298844, 306315, 313786, 321257, 328728, 336199, 343670, 351141, 
  358612, 366084, 373555, 381026, 388497, 395968, 403439, 410910, 
  418381, 425852, 433324, 440795, 448266, 455737, 463208, 470679, 
  478150, 485621, 493092, 500563, 508035, 515506, 522977, 530448, 
  537919, 545390, 552861, 560332, 567803, 575275, 582746, 590217, 
  597688, 605159, 612630, 620101, 627572, 635043, 642514, 649986, 
  657457, 664928, 672399, 679870, 687341, 694812, 702283, 709754, 
  717225, 724697, 732168, 739639, 747110, 754581, 762052, 769523, 
  776994, 784465, 791937, 799408, 806879, 814350, 821821, 829292, 
  836763, 844234, 851705, 859176, 866648, 874119, 881590, 889061, 
  896532, 904003, 911474, 918945, 926416, 933888, 941359, 948830, 
  956301, 963772, 971243, 978714, 986185, 993656, 1001127, 1008599, 
  1016070, 1023541, 1031012, 1038483, 1045954, 1053425, 1060896, 1068367, 
  1075838, 1083310, 1090781, 1098252, 1105723, 1113194, 1120665, 1128136, 
  1135607, 1143078, 1150550, 1158021, 1165492, 1172963, 1180434, 1187905, 
  1195376, 1202847, 1210318, 1217789, 1225261, 1232732, 1240203, 1247674, 
  1255145, 1262616, 1270087, 1277558, 1285029, 1292500, 1299972, 1307443, 
  1314914, 1322385, 1329856, 1337327, 1344798, 1352269, 1359740, 1367212, 
  1374683, 1382154, 1389625, 1397096, 1404567, 1412038, 1419509, 1426980, 
  1434451, 1441923, 1449394, 1456865, 1464336, 1471807, 1479278, 1486749, 
  1494220, 1501691, 1509163, 1516634, 1524105, 1531576, 1539047, 1546518, 
  1553989, 1561460, 1568931, 1576402, 1583874, 1591345, 1598816, 1606287, 
  1613758, 1621229, 1628700, 1636171, 1643642, 1651113, 1658585, 1666056, 
  1673527, 1680998, 1688469, 1695940, 1703411, 1710882, 1718353, 1725825, 
  1733296, 1740767, 1748238, 1755709, 1763180, 1770651, 1778122, 1785593, 
  1793064, 1800536, 1808007, 1815478, 1822949, 1830420, 1837891, 1845362, 
  1852833, 1860304, 1867776, 1875247, 1882718, 1890189, 1897660, 1905131, 
};

int gavl_r_to_uj[256] = 
{
  0, -11058, -22117, -33175, -44234, -55292, -66351, -77409, 
  -88468, -99526, -110585, -121643, -132702, -143761, -154819, -165878, 
  -176936, -187995, -199053, -210112, -221170, -232229, -243287, -254346, 
  -265405, -276463, -287522, -298580, -309639, -320697, -331756, -342814, 
  -353873, -364931, -375990, -387049, -398107, -409166, -420224, -431283, 
  -442341, -453400, -464458, -475517, -486575, -497634, -508693, -519751, 
  -530810, -541868, -552927, -563985, -575044, -586102, -597161, -608219, 
  -619278, -630337, -641395, -652454, -663512, -674571, -685629, -696688, 
  -707746, -718805, -729863, -740922, -751981, -763039, -774098, -785156, 
  -796215, -807273, -818332, -829390, -840449, -851507, -862566, -873625, 
  -884683, -895742, -906800, -917859, -928917, -939976, -951034, -962093, 
  -973151, -984210, -995269, -1006327, -1017386, -1028444, -1039503, -1050561, 
  -1061620, -1072678, -1083737, -1094795, -1105854, -1116913, -1127971, -1139030, 
  -1150088, -1161147, -1172205, -1183264, -1194322, -1205381, -1216439, -1227498, 
  -1238556, -1249615, -1260674, -1271732, -1282791, -1293849, -1304908, -1315966, 
  -1327025, -1338083, -1349142, -1360200, -1371259, -1382318, -1393376, -1404435, 
  -1415493, -1426552, -1437610, -1448669, -1459727, -1470786, -1481844, -1492903, 
  -1503962, -1515020, -1526079, -1537137, -1548196, -1559254, -1570313, -1581371, 
  -1592430, -1603488, -1614547, -1625606, -1636664, -1647723, -1658781, -1669840, 
  -1680898, -1691957, -1703015, -1714074, -1725132, -1736191, -1747250, -1758308, 
  -1769367, -1780425, -1791484, -1802542, -1813601, -1824659, -1835718, -1846776, 
  -1857835, -1868894, -1879952, -1891011, -1902069, -1913128, -1924186, -1935245, 
  -1946303, -1957362, -1968420, -1979479, -1990538, -2001596, -2012655, -2023713, 
  -2034772, -2045830, -2056889, -2067947, -2079006, -2090064, -2101123, -2112182, 
  -2123240, -2134299, -2145357, -2156416, -2167474, -2178533, -2189591, -2200650, 
  -2211708, -2222767, -2233826, -2244884, -2255943, -2267001, -2278060, -2289118, 
  -2300177, -2311235, -2322294, -2333352, -2344411, -2355470, -2366528, -2377587, 
  -2388645, -2399704, -2410762, -2421821, -2432879, -2443938, -2454996, -2466055, 
  -2477113, -2488172, -2499231, -2510289, -2521348, -2532406, -2543465, -2554523, 
  -2565582, -2576640, -2587699, -2598757, -2609816, -2620875, -2631933, -2642992, 
  -2654050, -2665109, -2676167, -2687226, -2698284, -2709343, -2720401, -2731460, 
  -2742519, -2753577, -2764636, -2775694, -2786753, -2797811, -2808870, -2819928, 
};

int gavl_g_to_uj[256] = 
{
  0, -21709, -43418, -65128, -86837, -108547, -130256, -151966, 
  -173675, -195385, -217094, -238804, -260513, -282222, -303932, -325641, 
  -347351, -369060, -390770, -412479, -434189, -455898, -477608, -499317, 
  -521026, -542736, -564445, -586155, -607864, -629574, -651283, -672993, 
  -694702, -716412, -738121, -759830, -781540, -803249, -824959, -846668, 
  -868378, -890087, -911797, -933506, -955216, -976925, -998634, -1020344, 
  -1042053, -1063763, -1085472, -1107182, -1128891, -1150601, -1172310, -1194020, 
  -1215729, -1237438, -1259148, -1280857, -1302567, -1324276, -1345986, -1367695, 
  -1389405, -1411114, -1432824, -1454533, -1476242, -1497952, -1519661, -1541371, 
  -1563080, -1584790, -1606499, -1628209, -1649918, -1671628, -1693337, -1715046, 
  -1736756, -1758465, -1780175, -1801884, -1823594, -1845303, -1867013, -1888722, 
  -1910432, -1932141, -1953850, -1975560, -1997269, -2018979, -2040688, -2062398, 
  -2084107, -2105817, -2127526, -2149236, -2170945, -2192654, -2214364, -2236073, 
  -2257783, -2279492, -2301202, -2322911, -2344621, -2366330, -2388040, -2409749, 
  -2431459, -2453168, -2474877, -2496587, -2518296, -2540006, -2561715, -2583425, 
  -2605134, -2626844, -2648553, -2670263, -2691972, -2713681, -2735391, -2757100, 
  -2778810, -2800519, -2822229, -2843938, -2865648, -2887357, -2909067, -2930776, 
  -2952485, -2974195, -2995904, -3017614, -3039323, -3061033, -3082742, -3104452, 
  -3126161, -3147871, -3169580, -3191289, -3212999, -3234708, -3256418, -3278127, 
  -3299837, -3321546, -3343256, -3364965, -3386675, -3408384, -3430093, -3451803, 
  -3473512, -3495222, -3516931, -3538641, -3560350, -3582060, -3603769, -3625479, 
  -3647188, -3668897, -3690607, -3712316, -3734026, -3755735, -3777445, -3799154, 
  -3820864, -3842573, -3864283, -3885992, -3907701, -3929411, -3951120, -3972830, 
  -3994539, -4016249, -4037958, -4059668, -4081377, -4103087, -4124796, -4146505, 
  -4168215, -4189924, -4211634, -4233343, -4255053, -4276762, -4298472, -4320181, 
  -4341891, -4363600, -4385309, -4407019, -4428728, -4450438, -4472147, -4493857, 
  -4515566, -4537276, -4558985, -4580695, -4602404, -4624113, -4645823, -4667532, 
  -4689242, -4710951, -4732661, -4754370, -4776080, -4797789, -4819499, -4841208, 
  -4862918, -4884627, -4906336, -4928046, -4949755, -4971465, -4993174, -5014884, 
  -5036593, -5058303, -5080012, -5101722, -5123431, -5145140, -5166850, -5188559, 
  -5210269, -5231978, -5253688, -5275397, -5297107, -5318816, -5340526, -5362235, 
  -5383944, -5405654, -5427363, -5449073, -5470782, -5492492, -5514201, -5535911, 
};

int gavl_b_to_uj[256] = 
{
  8388608, 8421376, 8454144, 8486912, 8519680, 8552448, 8585216, 8617984, 
  8650752, 8683520, 8716288, 8749056, 8781824, 8814592, 8847360, 8880128, 
  8912896, 8945664, 8978432, 9011200, 9043968, 9076736, 9109504, 9142272, 
  9175040, 9207808, 9240576, 9273344, 9306112, 9338880, 9371648, 9404416, 
  9437184, 9469952, 9502720, 9535488, 9568256, 9601024, 9633792, 9666560, 
  9699328, 9732096, 9764864, 9797632, 9830400, 9863168, 9895936, 9928704, 
  9961472, 9994240, 10027008, 10059776, 10092544, 10125312, 10158080, 10190848, 
  10223616, 10256384, 10289152, 10321920, 10354688, 10387456, 10420224, 10452992, 
  10485760, 10518528, 10551296, 10584064, 10616832, 10649600, 10682368, 10715136, 
  10747904, 10780672, 10813440, 10846208, 10878976, 10911744, 10944512, 10977280, 
  11010048, 11042816, 11075584, 11108352, 11141120, 11173888, 11206656, 11239424, 
  11272192, 11304960, 11337728, 11370496, 11403264, 11436032, 11468800, 11501568, 
  11534336, 11567104, 11599872, 11632640, 11665408, 11698176, 11730944, 11763712, 
  11796480, 11829248, 11862016, 11894784, 11927552, 11960320, 11993088, 12025856, 
  12058624, 12091392, 12124160, 12156928, 12189696, 12222464, 12255232, 12288000, 
  12320768, 12353536, 12386304, 12419072, 12451840, 12484608, 12517376, 12550144, 
  12582912, 12615680, 12648448, 12681216, 12713984, 12746752, 12779520, 12812288, 
  12845056, 12877824, 12910592, 12943360, 12976128, 13008896, 13041664, 13074432, 
  13107200, 13139968, 13172736, 13205504, 13238272, 13271040, 13303808, 13336576, 
  13369344, 13402112, 13434880, 13467648, 13500416, 13533184, 13565952, 13598720, 
  13631488, 13664256, 13697024, 13729792, 13762560, 13795328, 13828096, 13860864, 
  13893632, 13926400, 13959168, 13991936, 14024704, 14057472, 14090240, 14123008, 
  14155776, 14188544, 14221312, 14254080, 14286848, 14319616, 14352384, 14385152, 
  14417920, 14450688, 14483456, 14516224, 14548992, 14581760, 14614528, 14647296, 
  14680064, 14712832, 14745600, 14778368, 14811136, 14843904, 14876672, 14909440, 
  14942208, 14974976, 15007744, 15040512, 15073280, 15106048, 15138816, 15171584, 
  15204352, 15237120, 15269888, 15302656, 15335424, 15368192, 15400960, 15433728, 
  15466496, 15499264, 15532032, 15564800, 15597568, 15630336, 15663104, 15695872, 
  15728640, 15761408, 15794176, 15826944, 15859712, 15892480, 15925248, 15958016, 
  15990784, 16023552, 16056320, 16089088, 16121856, 16154624, 16187392, 16220160, 
  16252928, 16285696, 16318464, 16351232, 16384000, 16416768, 16449536, 16482304, 
  16515072, 16547840, 16580608, 16613376, 16646144, 16678912, 16711680, 16744448, 
};

int gavl_r_to_vj[256] = 
{
  0, 32768, 65536, 98304, 131072, 163840, 196608, 229376, 
  262144, 294912, 327680, 360448, 393216, 425984, 458752, 491520, 
  524288, 557056, 589824, 622592, 655360, 688128, 720896, 753664, 
  786432, 819200, 851968, 884736, 917504, 950272, 983040, 1015808, 
  1048576, 1081344, 1114112, 1146880, 1179648, 1212416, 1245184, 1277952, 
  1310720, 1343488, 1376256, 1409024, 1441792, 1474560, 1507328, 1540096, 
  1572864, 1605632, 1638400, 1671168, 1703936, 1736704, 1769472, 1802240, 
  1835008, 1867776, 1900544, 1933312, 1966080, 1998848, 2031616, 2064384, 
  2097152, 2129920, 2162688, 2195456, 2228224, 2260992, 2293760, 2326528, 
  2359296, 2392064, 2424832, 2457600, 2490368, 2523136, 2555904, 2588672, 
  2621440, 2654208, 2686976, 2719744, 2752512, 2785280, 2818048, 2850816, 
  2883584, 2916352, 2949120, 2981888, 3014656, 3047424, 3080192, 3112960, 
  3145728, 3178496, 3211264, 3244032, 3276800, 3309568, 3342336, 3375104, 
  3407872, 3440640, 3473408, 3506176, 3538944, 3571712, 3604480, 3637248, 
  3670016, 3702784, 3735552, 3768320, 3801088, 3833856, 3866624, 3899392, 
  3932160, 3964928, 3997696, 4030464, 4063232, 4096000, 4128768, 4161536, 
  4194304, 4227072, 4259840, 4292608, 4325376, 4358144, 4390912, 4423680, 
  4456448, 4489216, 4521984, 4554752, 4587520, 4620288, 4653056, 4685824, 
  4718592, 4751360, 4784128, 4816896, 4849664, 4882432, 4915200, 4947968, 
  4980736, 5013504, 5046272, 5079040, 5111808, 5144576, 5177344, 5210112, 
  5242880, 5275648, 5308416, 5341184, 5373952, 5406720, 5439488, 5472256, 
  5505024, 5537792, 5570560, 5603328, 5636096, 5668864, 5701632, 5734400, 
  5767168, 5799936, 5832704, 5865472, 5898240, 5931008, 5963776, 5996544, 
  6029312, 6062080, 6094848, 6127616, 6160384, 6193152, 6225920, 6258688, 
  6291456, 6324224, 6356992, 6389760, 6422528, 6455296, 6488064, 6520832, 
  6553600, 6586368, 6619136, 6651904, 6684672, 6717440, 6750208, 6782976, 
  6815744, 6848512, 6881280, 6914048, 6946816, 6979584, 7012352, 7045120, 
  7077888, 7110656, 7143424, 7176192, 7208960, 7241728, 7274496, 7307264, 
  7340032, 7372800, 7405568, 7438336, 7471104, 7503872, 7536640, 7569408, 
  7602176, 7634944, 7667712, 7700480, 7733248, 7766016, 7798784, 7831552, 
  7864320, 7897088, 7929856, 7962624, 7995392, 8028160, 8060928, 8093696, 
  8126464, 8159232, 8192000, 8224768, 8257536, 8290304, 8323072, 8355840, 
};

int gavl_g_to_vj[256] = 
{
  0, -27439, -54878, -82317, -109757, -137196, -164635, -192074, 
  -219514, -246953, -274392, -301831, -329271, -356710, -384149, -411589, 
  -439028, -466467, -493906, -521346, -548785, -576224, -603663, -631103, 
  -658542, -685981, -713420, -740860, -768299, -795738, -823178, -850617, 
  -878056, -905495, -932935, -960374, -987813, -1015252, -1042692, -1070131, 
  -1097570, -1125009, -1152449, -1179888, -1207327, -1234767, -1262206, -1289645, 
  -1317084, -1344524, -1371963, -1399402, -1426841, -1454281, -1481720, -1509159, 
  -1536598, -1564038, -1591477, -1618916, -1646356, -1673795, -1701234, -1728673, 
  -1756113, -1783552, -1810991, -1838430, -1865870, -1893309, -1920748, -1948188, 
  -1975627, -2003066, -2030505, -2057945, -2085384, -2112823, -2140262, -2167702, 
  -2195141, -2222580, -2250019, -2277459, -2304898, -2332337, -2359777, -2387216, 
  -2414655, -2442094, -2469534, -2496973, -2524412, -2551851, -2579291, -2606730, 
  -2634169, -2661608, -2689048, -2716487, -2743926, -2771366, -2798805, -2826244, 
  -2853683, -2881123, -2908562, -2936001, -2963440, -2990880, -3018319, -3045758, 
  -3073197, -3100637, -3128076, -3155515, -3182955, -3210394, -3237833, -3265272, 
  -3292712, -3320151, -3347590, -3375029, -3402469, -3429908, -3457347, -3484787, 
  -3512226, -3539665, -3567104, -3594544, -3621983, -3649422, -3676861, -3704301, 
  -3731740, -3759179, -3786618, -3814058, -3841497, -3868936, -3896376, -3923815, 
  -3951254, -3978693, -4006133, -4033572, -4061011, -4088450, -4115890, -4143329, 
  -4170768, -4198207, -4225647, -4253086, -4280525, -4307965, -4335404, -4362843, 
  -4390282, -4417722, -4445161, -4472600, -4500039, -4527479, -4554918, -4582357, 
  -4609796, -4637236, -4664675, -4692114, -4719554, -4746993, -4774432, -4801871, 
  -4829311, -4856750, -4884189, -4911628, -4939068, -4966507, -4993946, -5021386, 
  -5048825, -5076264, -5103703, -5131143, -5158582, -5186021, -5213460, -5240900, 
  -5268339, -5295778, -5323217, -5350657, -5378096, -5405535, -5432975, -5460414, 
  -5487853, -5515292, -5542732, -5570171, -5597610, -5625049, -5652489, -5679928, 
  -5707367, -5734806, -5762246, -5789685, -5817124, -5844564, -5872003, -5899442, 
  -5926881, -5954321, -5981760, -6009199, -6036638, -6064078, -6091517, -6118956, 
  -6146395, -6173835, -6201274, -6228713, -6256153, -6283592, -6311031, -6338470, 
  -6365910, -6393349, -6420788, -6448227, -6475667, -6503106, -6530545, -6557985, 
  -6585424, -6612863, -6640302, -6667742, -6695181, -6722620, -6750059, -6777499, 
  -6804938, -6832377, -6859816, -6887256, -6914695, -6942134, -6969574, -6997013, 
};

int gavl_b_to_vj[256] = 
{
  8388608, 8383279, 8377950, 8372621, 8367293, 8361964, 8356635, 8351306, 
  8345978, 8340649, 8335320, 8329991, 8324663, 8319334, 8314005, 8308677, 
  8303348, 8298019, 8292690, 8287362, 8282033, 8276704, 8271375, 8266047, 
  8260718, 8255389, 8250060, 8244732, 8239403, 8234074, 8228746, 8223417, 
  8218088, 8212759, 8207431, 8202102, 8196773, 8191444, 8186116, 8180787, 
  8175458, 8170129, 8164801, 8159472, 8154143, 8148815, 8143486, 8138157, 
  8132828, 8127500, 8122171, 8116842, 8111513, 8106185, 8100856, 8095527, 
  8090198, 8084870, 8079541, 8074212, 8068884, 8063555, 8058226, 8052897, 
  8047569, 8042240, 8036911, 8031582, 8026254, 8020925, 8015596, 8010268, 
  8004939, 7999610, 7994281, 7988953, 7983624, 7978295, 7972966, 7967638, 
  7962309, 7956980, 7951651, 7946323, 7940994, 7935665, 7930337, 7925008, 
  7919679, 7914350, 7909022, 7903693, 7898364, 7893035, 7887707, 7882378, 
  7877049, 7871720, 7866392, 7861063, 7855734, 7850406, 7845077, 7839748, 
  7834419, 7829091, 7823762, 7818433, 7813104, 7807776, 7802447, 7797118, 
  7791789, 7786461, 7781132, 7775803, 7770475, 7765146, 7759817, 7754488, 
  7749160, 7743831, 7738502, 7733173, 7727845, 7722516, 7717187, 7711859, 
  7706530, 7701201, 7695872, 7690544, 7685215, 7679886, 7674557, 7669229, 
  7663900, 7658571, 7653242, 7647914, 7642585, 7637256, 7631928, 7626599, 
  7621270, 7615941, 7610613, 7605284, 7599955, 7594626, 7589298, 7583969, 
  7578640, 7573311, 7567983, 7562654, 7557325, 7551997, 7546668, 7541339, 
  7536010, 7530682, 7525353, 7520024, 7514695, 7509367, 7504038, 7498709, 
  7493380, 7488052, 7482723, 7477394, 7472066, 7466737, 7461408, 7456079, 
  7450751, 7445422, 7440093, 7434764, 7429436, 7424107, 7418778, 7413450, 
  7408121, 7402792, 7397463, 7392135, 7386806, 7381477, 7376148, 7370820, 
  7365491, 7360162, 7354833, 7349505, 7344176, 7338847, 7333519, 7328190, 
  7322861, 7317532, 7312204, 7306875, 7301546, 7296217, 7290889, 7285560, 
  7280231, 7274902, 7269574, 7264245, 7258916, 7253588, 7248259, 7242930, 
  7237601, 7232273, 7226944, 7221615, 7216286, 7210958, 7205629, 7200300, 
  7194971, 7189643, 7184314, 7178985, 7173657, 7168328, 7162999, 7157670, 
  7152342, 7147013, 7141684, 7136355, 7131027, 7125698, 7120369, 7115041, 
  7109712, 7104383, 7099054, 7093726, 7088397, 7083068, 7077739, 7072411, 
  7067082, 7061753, 7056424, 7051096, 7045767, 7040438, 7035110, 7029781, 
};

/* YUV -> RGB conversions */
int gavl_y_to_rgb[256] = 
{
  -1179648, -1114112, -1048576, -983040, -851968, -786432, -720896, -655360, 
  -589824, -524288, -393216, -327680, -262144, -196608, -131072, -65536, 
  0, 65536, 131072, 196608, 262144, 327680, 393216, 524288, 
  589824, 655360, 720896, 786432, 851968, 983040, 1048576, 1114112, 
  1179648, 1245184, 1310720, 1441792, 1507328, 1572864, 1638400, 1703936, 
  1769472, 1900544, 1966080, 2031616, 2097152, 2162688, 2228224, 2359296, 
  2424832, 2490368, 2555904, 2621440, 2686976, 2818048, 2883584, 2949120, 
  3014656, 3080192, 3145728, 3276800, 3342336, 3407872, 3473408, 3538944, 
  3604480, 3735552, 3801088, 3866624, 3932160, 3997696, 4063232, 4194304, 
  4259840, 4325376, 4390912, 4456448, 4521984, 4653056, 4718592, 4784128, 
  4849664, 4915200, 4980736, 5111808, 5177344, 5242880, 5308416, 5373952, 
  5439488, 5505024, 5636096, 5701632, 5767168, 5832704, 5898240, 5963776, 
  6094848, 6160384, 6225920, 6291456, 6356992, 6422528, 6553600, 6619136, 
  6684672, 6750208, 6815744, 6881280, 7012352, 7077888, 7143424, 7208960, 
  7274496, 7340032, 7471104, 7536640, 7602176, 7667712, 7733248, 7798784, 
  7929856, 7995392, 8060928, 8126464, 8192000, 8257536, 8388608, 8454144, 
  8519680, 8585216, 8650752, 8716288, 8847360, 8912896, 8978432, 9043968, 
  9109504, 9175040, 9306112, 9371648, 9437184, 9502720, 9568256, 9633792, 
  9764864, 9830400, 9895936, 9961472, 10027008, 10092544, 10223616, 10289152, 
  10354688, 10420224, 10485760, 10551296, 10682368, 10747904, 10813440, 10878976, 
  10944512, 11010048, 11075584, 11206656, 11272192, 11337728, 11403264, 11468800, 
  11534336, 11665408, 11730944, 11796480, 11862016, 11927552, 11993088, 12124160, 
  12189696, 12255232, 12320768, 12386304, 12451840, 12582912, 12648448, 12713984, 
  12779520, 12845056, 12910592, 13041664, 13107200, 13172736, 13238272, 13303808, 
  13369344, 13500416, 13565952, 13631488, 13697024, 13762560, 13828096, 13959168, 
  14024704, 14090240, 14155776, 14221312, 14286848, 14417920, 14483456, 14548992, 
  14614528, 14680064, 14745600, 14876672, 14942208, 15007744, 15073280, 15138816, 
  15204352, 15335424, 15400960, 15466496, 15532032, 15597568, 15663104, 15794176, 
  15859712, 15925248, 15990784, 16056320, 16121856, 16252928, 16318464, 16384000, 
  16449536, 16515072, 16580608, 16646144, 16777216, 16842752, 16908288, 16973824, 
  17039360, 17104896, 17235968, 17301504, 17367040, 17432576, 17498112, 17563648, 
  17694720, 17760256, 17825792, 17891328, 17956864, 18022400, 18153472, 18219008, 
};

int gavl_v_to_r[256] = 
{
  -13388443, -13283845, -13179248, -13074651, -12970054, -12865457, -12760859, -12656262, 
  -12551665, -12447068, -12342470, -12237873, -12133276, -12028679, -11924082, -11819484, 
  -11714887, -11610290, -11505693, -11401096, -11296498, -11191901, -11087304, -10982707, 
  -10878109, -10773512, -10668915, -10564318, -10459721, -10355123, -10250526, -10145929, 
  -10041332, -9936735, -9832137, -9727540, -9622943, -9518346, -9413749, -9309151, 
  -9204554, -9099957, -8995360, -8890762, -8786165, -8681568, -8576971, -8472374, 
  -8367776, -8263179, -8158582, -8053985, -7949388, -7844790, -7740193, -7635596, 
  -7530999, -7426402, -7321804, -7217207, -7112610, -7008013, -6903415, -6798818, 
  -6694221, -6589624, -6485027, -6380429, -6275832, -6171235, -6066638, -5962041, 
  -5857443, -5752846, -5648249, -5543652, -5439054, -5334457, -5229860, -5125263, 
  -5020666, -4916068, -4811471, -4706874, -4602277, -4497680, -4393082, -4288485, 
  -4183888, -4079291, -3974694, -3870096, -3765499, -3660902, -3556305, -3451707, 
  -3347110, -3242513, -3137916, -3033319, -2928721, -2824124, -2719527, -2614930, 
  -2510333, -2405735, -2301138, -2196541, -2091944, -1987347, -1882749, -1778152, 
  -1673555, -1568958, -1464360, -1359763, -1255166, -1150569, -1045972, -941374, 
  -836777, -732180, -627583, -522986, -418388, -313791, -209194, -104597, 
  0, 104597, 209194, 313791, 418388, 522986, 627583, 732180, 
  836777, 941374, 1045972, 1150569, 1255166, 1359763, 1464360, 1568958, 
  1673555, 1778152, 1882749, 1987347, 2091944, 2196541, 2301138, 2405735, 
  2510333, 2614930, 2719527, 2824124, 2928721, 3033319, 3137916, 3242513, 
  3347110, 3451707, 3556305, 3660902, 3765499, 3870096, 3974694, 4079291, 
  4183888, 4288485, 4393082, 4497680, 4602277, 4706874, 4811471, 4916068, 
  5020666, 5125263, 5229860, 5334457, 5439054, 5543652, 5648249, 5752846, 
  5857443, 5962041, 6066638, 6171235, 6275832, 6380429, 6485027, 6589624, 
  6694221, 6798818, 6903415, 7008013, 7112610, 7217207, 7321804, 7426402, 
  7530999, 7635596, 7740193, 7844790, 7949388, 8053985, 8158582, 8263179, 
  8367776, 8472374, 8576971, 8681568, 8786165, 8890762, 8995360, 9099957, 
  9204554, 9309151, 9413749, 9518346, 9622943, 9727540, 9832137, 9936735, 
  10041332, 10145929, 10250526, 10355123, 10459721, 10564318, 10668915, 10773512, 
  10878109, 10982707, 11087304, 11191901, 11296498, 11401096, 11505693, 11610290, 
  11714887, 11819484, 11924082, 12028679, 12133276, 12237873, 12342470, 12447068, 
  12551665, 12656262, 12760859, 12865457, 12970054, 13074651, 13179248, 13283845, 
};

int gavl_u_to_g[256] = 
{
  3286375, 3260700, 3235026, 3209351, 3183676, 3158001, 3132326, 3106652, 
  3080977, 3055302, 3029627, 3003952, 2978278, 2952603, 2926928, 2901253, 
  2875578, 2849903, 2824229, 2798554, 2772879, 2747204, 2721529, 2695855, 
  2670180, 2644505, 2618830, 2593155, 2567481, 2541806, 2516131, 2490456, 
  2464781, 2439106, 2413432, 2387757, 2362082, 2336407, 2310732, 2285058, 
  2259383, 2233708, 2208033, 2182358, 2156684, 2131009, 2105334, 2079659, 
  2053984, 2028310, 2002635, 1976960, 1951285, 1925610, 1899935, 1874261, 
  1848586, 1822911, 1797236, 1771561, 1745887, 1720212, 1694537, 1668862, 
  1643187, 1617513, 1591838, 1566163, 1540488, 1514813, 1489139, 1463464, 
  1437789, 1412114, 1386439, 1360764, 1335090, 1309415, 1283740, 1258065, 
  1232390, 1206716, 1181041, 1155366, 1129691, 1104016, 1078342, 1052667, 
  1026992, 1001317, 975642, 949967, 924293, 898618, 872943, 847268, 
  821593, 795919, 770244, 744569, 718894, 693219, 667545, 641870, 
  616195, 590520, 564845, 539171, 513496, 487821, 462146, 436471, 
  410796, 385122, 359447, 333772, 308097, 282422, 256748, 231073, 
  205398, 179723, 154048, 128374, 102699, 77024, 51349, 25674, 
  0, -25674, -51349, -77024, -102699, -128374, -154048, -179723, 
  -205398, -231073, -256748, -282422, -308097, -333772, -359447, -385122, 
  -410796, -436471, -462146, -487821, -513496, -539171, -564845, -590520, 
  -616195, -641870, -667545, -693219, -718894, -744569, -770244, -795919, 
  -821593, -847268, -872943, -898618, -924293, -949967, -975642, -1001317, 
  -1026992, -1052667, -1078342, -1104016, -1129691, -1155366, -1181041, -1206716, 
  -1232390, -1258065, -1283740, -1309415, -1335090, -1360764, -1386439, -1412114, 
  -1437789, -1463464, -1489139, -1514813, -1540488, -1566163, -1591838, -1617513, 
  -1643187, -1668862, -1694537, -1720212, -1745887, -1771561, -1797236, -1822911, 
  -1848586, -1874261, -1899935, -1925610, -1951285, -1976960, -2002635, -2028310, 
  -2053984, -2079659, -2105334, -2131009, -2156684, -2182358, -2208033, -2233708, 
  -2259383, -2285058, -2310732, -2336407, -2362082, -2387757, -2413432, -2439106, 
  -2464781, -2490456, -2516131, -2541806, -2567481, -2593155, -2618830, -2644505, 
  -2670180, -2695855, -2721529, -2747204, -2772879, -2798554, -2824229, -2849903, 
  -2875578, -2901253, -2926928, -2952603, -2978278, -3003952, -3029627, -3055302, 
  -3080977, -3106652, -3132326, -3158001, -3183676, -3209351, -3235026, -3260700, 
};

int gavl_v_to_g[256] = 
{
  6819702, 6766423, 6713144, 6659865, 6606586, 6553307, 6500028, 6446749, 
  6393470, 6340192, 6286913, 6233634, 6180355, 6127076, 6073797, 6020518, 
  5967239, 5913960, 5860681, 5807402, 5754123, 5700844, 5647566, 5594287, 
  5541008, 5487729, 5434450, 5381171, 5327892, 5274613, 5221334, 5168055, 
  5114776, 5061497, 5008218, 4954940, 4901661, 4848382, 4795103, 4741824, 
  4688545, 4635266, 4581987, 4528708, 4475429, 4422150, 4368871, 4315592, 
  4262313, 4209035, 4155756, 4102477, 4049198, 3995919, 3942640, 3889361, 
  3836082, 3782803, 3729524, 3676245, 3622966, 3569687, 3516409, 3463130, 
  3409851, 3356572, 3303293, 3250014, 3196735, 3143456, 3090177, 3036898, 
  2983619, 2930340, 2877061, 2823783, 2770504, 2717225, 2663946, 2610667, 
  2557388, 2504109, 2450830, 2397551, 2344272, 2290993, 2237714, 2184435, 
  2131156, 2077878, 2024599, 1971320, 1918041, 1864762, 1811483, 1758204, 
  1704925, 1651646, 1598367, 1545088, 1491809, 1438530, 1385252, 1331973, 
  1278694, 1225415, 1172136, 1118857, 1065578, 1012299, 959020, 905741, 
  852462, 799183, 745904, 692626, 639347, 586068, 532789, 479510, 
  426231, 372952, 319673, 266394, 213115, 159836, 106557, 53278, 
  0, -53278, -106557, -159836, -213115, -266394, -319673, -372952, 
  -426231, -479510, -532789, -586068, -639347, -692626, -745904, -799183, 
  -852462, -905741, -959020, -1012299, -1065578, -1118857, -1172136, -1225415, 
  -1278694, -1331973, -1385252, -1438530, -1491809, -1545088, -1598367, -1651646, 
  -1704925, -1758204, -1811483, -1864762, -1918041, -1971320, -2024599, -2077878, 
  -2131156, -2184435, -2237714, -2290993, -2344272, -2397551, -2450830, -2504109, 
  -2557388, -2610667, -2663946, -2717225, -2770504, -2823783, -2877061, -2930340, 
  -2983619, -3036898, -3090177, -3143456, -3196735, -3250014, -3303293, -3356572, 
  -3409851, -3463130, -3516409, -3569687, -3622966, -3676245, -3729524, -3782803, 
  -3836082, -3889361, -3942640, -3995919, -4049198, -4102477, -4155756, -4209035, 
  -4262313, -4315592, -4368871, -4422150, -4475429, -4528708, -4581987, -4635266, 
  -4688545, -4741824, -4795103, -4848382, -4901661, -4954940, -5008218, -5061497, 
  -5114776, -5168055, -5221334, -5274613, -5327892, -5381171, -5434450, -5487729, 
  -5541008, -5594287, -5647566, -5700844, -5754123, -5807402, -5860681, -5913960, 
  -5967239, -6020518, -6073797, -6127076, -6180355, -6233634, -6286913, -6340192, 
  -6393470, -6446749, -6500028, -6553307, -6606586, -6659865, -6713144, -6766423, 
};

int gavl_u_to_b[256] = 
{
  -16921769, -16789568, -16657367, -16525165, -16392964, -16260763, -16128561, -15996360, 
  -15864159, -15731957, -15599756, -15467555, -15335353, -15203152, -15070951, -14938749, 
  -14806548, -14674347, -14542145, -14409944, -14277743, -14145541, -14013340, -13881139, 
  -13748937, -13616736, -13484535, -13352333, -13220132, -13087931, -12955729, -12823528, 
  -12691327, -12559125, -12426924, -12294723, -12162521, -12030320, -11898119, -11765917, 
  -11633716, -11501515, -11369314, -11237112, -11104911, -10972710, -10840508, -10708307, 
  -10576106, -10443904, -10311703, -10179502, -10047300, -9915099, -9782898, -9650696, 
  -9518495, -9386294, -9254092, -9121891, -8989690, -8857488, -8725287, -8593086, 
  -8460884, -8328683, -8196482, -8064280, -7932079, -7799878, -7667676, -7535475, 
  -7403274, -7271072, -7138871, -7006670, -6874468, -6742267, -6610066, -6477864, 
  -6345663, -6213462, -6081260, -5949059, -5816858, -5684657, -5552455, -5420254, 
  -5288053, -5155851, -5023650, -4891449, -4759247, -4627046, -4494845, -4362643, 
  -4230442, -4098241, -3966039, -3833838, -3701637, -3569435, -3437234, -3305033, 
  -3172831, -3040630, -2908429, -2776227, -2644026, -2511825, -2379623, -2247422, 
  -2115221, -1983019, -1850818, -1718617, -1586415, -1454214, -1322013, -1189811, 
  -1057610, -925409, -793207, -661006, -528805, -396603, -264402, -132201, 
  0, 132201, 264402, 396603, 528805, 661006, 793207, 925409, 
  1057610, 1189811, 1322013, 1454214, 1586415, 1718617, 1850818, 1983019, 
  2115221, 2247422, 2379623, 2511825, 2644026, 2776227, 2908429, 3040630, 
  3172831, 3305033, 3437234, 3569435, 3701637, 3833838, 3966039, 4098241, 
  4230442, 4362643, 4494845, 4627046, 4759247, 4891449, 5023650, 5155851, 
  5288053, 5420254, 5552455, 5684657, 5816858, 5949059, 6081260, 6213462, 
  6345663, 6477864, 6610066, 6742267, 6874468, 7006670, 7138871, 7271072, 
  7403274, 7535475, 7667676, 7799878, 7932079, 8064280, 8196482, 8328683, 
  8460884, 8593086, 8725287, 8857488, 8989690, 9121891, 9254092, 9386294, 
  9518495, 9650696, 9782898, 9915099, 10047300, 10179502, 10311703, 10443904, 
  10576106, 10708307, 10840508, 10972710, 11104911, 11237112, 11369314, 11501515, 
  11633716, 11765917, 11898119, 12030320, 12162521, 12294723, 12426924, 12559125, 
  12691327, 12823528, 12955729, 13087931, 13220132, 13352333, 13484535, 13616736, 
  13748937, 13881139, 14013340, 14145541, 14277743, 14409944, 14542145, 14674347, 
  14806548, 14938749, 15070951, 15203152, 15335353, 15467555, 15599756, 15731957, 
  15864159, 15996360, 16128561, 16260763, 16392964, 16525165, 16657367, 16789568, 
};

int gavl_yj_to_rgb[256] = 
{
  0, 65536, 131072, 196608, 262144, 327680, 393216, 458752, 
  524288, 589824, 655360, 720896, 786432, 851968, 917504, 983040, 
  1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 
  1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 
  2097152, 2162688, 2228224, 2293760, 2359296, 2424832, 2490368, 2555904, 
  2621440, 2686976, 2752512, 2818048, 2883584, 2949120, 3014656, 3080192, 
  3145728, 3211264, 3276800, 3342336, 3407872, 3473408, 3538944, 3604480, 
  3670016, 3735552, 3801088, 3866624, 3932160, 3997696, 4063232, 4128768, 
  4194304, 4259840, 4325376, 4390912, 4456448, 4521984, 4587520, 4653056, 
  4718592, 4784128, 4849664, 4915200, 4980736, 5046272, 5111808, 5177344, 
  5242880, 5308416, 5373952, 5439488, 5505024, 5570560, 5636096, 5701632, 
  5767168, 5832704, 5898240, 5963776, 6029312, 6094848, 6160384, 6225920, 
  6291456, 6356992, 6422528, 6488064, 6553600, 6619136, 6684672, 6750208, 
  6815744, 6881280, 6946816, 7012352, 7077888, 7143424, 7208960, 7274496, 
  7340032, 7405568, 7471104, 7536640, 7602176, 7667712, 7733248, 7798784, 
  7864320, 7929856, 7995392, 8060928, 8126464, 8192000, 8257536, 8323072, 
  8388608, 8454144, 8519680, 8585216, 8650752, 8716288, 8781824, 8847360, 
  8912896, 8978432, 9043968, 9109504, 9175040, 9240576, 9306112, 9371648, 
  9437184, 9502720, 9568256, 9633792, 9699328, 9764864, 9830400, 9895936, 
  9961472, 10027008, 10092544, 10158080, 10223616, 10289152, 10354688, 10420224, 
  10485760, 10551296, 10616832, 10682368, 10747904, 10813440, 10878976, 10944512, 
  11010048, 11075584, 11141120, 11206656, 11272192, 11337728, 11403264, 11468800, 
  11534336, 11599872, 11665408, 11730944, 11796480, 11862016, 11927552, 11993088, 
  12058624, 12124160, 12189696, 12255232, 12320768, 12386304, 12451840, 12517376, 
  12582912, 12648448, 12713984, 12779520, 12845056, 12910592, 12976128, 13041664, 
  13107200, 13172736, 13238272, 13303808, 13369344, 13434880, 13500416, 13565952, 
  13631488, 13697024, 13762560, 13828096, 13893632, 13959168, 14024704, 14090240, 
  14155776, 14221312, 14286848, 14352384, 14417920, 14483456, 14548992, 14614528, 
  14680064, 14745600, 14811136, 14876672, 14942208, 15007744, 15073280, 15138816, 
  15204352, 15269888, 15335424, 15400960, 15466496, 15532032, 15597568, 15663104, 
  15728640, 15794176, 15859712, 15925248, 15990784, 16056320, 16121856, 16187392, 
  16252928, 16318464, 16384000, 16449536, 16515072, 16580608, 16646144, 16711680, 
};

int gavl_vj_to_r[256] = 
{
  -11760828, -11668946, -11577065, -11485183, -11393302, -11301421, -11209539, -11117658, 
  -11025776, -10933895, -10842013, -10750132, -10658250, -10566369, -10474487, -10382606, 
  -10290724, -10198843, -10106961, -10015080, -9923198, -9831317, -9739436, -9647554, 
  -9555673, -9463791, -9371910, -9280028, -9188147, -9096265, -9004384, -8912502, 
  -8820621, -8728739, -8636858, -8544976, -8453095, -8361213, -8269332, -8177451, 
  -8085569, -7993688, -7901806, -7809925, -7718043, -7626162, -7534280, -7442399, 
  -7350517, -7258636, -7166754, -7074873, -6982991, -6891110, -6799228, -6707347, 
  -6615465, -6523584, -6431703, -6339821, -6247940, -6156058, -6064177, -5972295, 
  -5880414, -5788532, -5696651, -5604769, -5512888, -5421006, -5329125, -5237243, 
  -5145362, -5053480, -4961599, -4869718, -4777836, -4685955, -4594073, -4502192, 
  -4410310, -4318429, -4226547, -4134666, -4042784, -3950903, -3859021, -3767140, 
  -3675258, -3583377, -3491495, -3399614, -3307732, -3215851, -3123970, -3032088, 
  -2940207, -2848325, -2756444, -2664562, -2572681, -2480799, -2388918, -2297036, 
  -2205155, -2113273, -2021392, -1929510, -1837629, -1745747, -1653866, -1561985, 
  -1470103, -1378222, -1286340, -1194459, -1102577, -1010696, -918814, -826933, 
  -735051, -643170, -551288, -459407, -367525, -275644, -183762, -91881, 
  0, 91881, 183762, 275644, 367525, 459407, 551288, 643170, 
  735051, 826933, 918814, 1010696, 1102577, 1194459, 1286340, 1378222, 
  1470103, 1561985, 1653866, 1745747, 1837629, 1929510, 2021392, 2113273, 
  2205155, 2297036, 2388918, 2480799, 2572681, 2664562, 2756444, 2848325, 
  2940207, 3032088, 3123970, 3215851, 3307732, 3399614, 3491495, 3583377, 
  3675258, 3767140, 3859021, 3950903, 4042784, 4134666, 4226547, 4318429, 
  4410310, 4502192, 4594073, 4685955, 4777836, 4869718, 4961599, 5053480, 
  5145362, 5237243, 5329125, 5421006, 5512888, 5604769, 5696651, 5788532, 
  5880414, 5972295, 6064177, 6156058, 6247940, 6339821, 6431703, 6523584, 
  6615465, 6707347, 6799228, 6891110, 6982991, 7074873, 7166754, 7258636, 
  7350517, 7442399, 7534280, 7626162, 7718043, 7809925, 7901806, 7993688, 
  8085569, 8177451, 8269332, 8361213, 8453095, 8544976, 8636858, 8728739, 
  8820621, 8912502, 9004384, 9096265, 9188147, 9280028, 9371910, 9463791, 
  9555673, 9647554, 9739436, 9831317, 9923198, 10015080, 10106961, 10198843, 
  10290724, 10382606, 10474487, 10566369, 10658250, 10750132, 10842013, 10933895, 
  11025776, 11117658, 11209539, 11301421, 11393302, 11485183, 11577065, 11668946, 
};

int gavl_uj_to_g[256] = 
{
  2886855, 2864301, 2841748, 2819194, 2796641, 2774087, 2751534, 2728980, 
  2706427, 2683873, 2661319, 2638766, 2616212, 2593659, 2571105, 2548552, 
  2525998, 2503445, 2480891, 2458337, 2435784, 2413230, 2390677, 2368123, 
  2345570, 2323016, 2300463, 2277909, 2255355, 2232802, 2210248, 2187695, 
  2165141, 2142588, 2120034, 2097480, 2074927, 2052373, 2029820, 2007266, 
  1984713, 1962159, 1939606, 1917052, 1894498, 1871945, 1849391, 1826838, 
  1804284, 1781731, 1759177, 1736624, 1714070, 1691516, 1668963, 1646409, 
  1623856, 1601302, 1578749, 1556195, 1533642, 1511088, 1488534, 1465981, 
  1443427, 1420874, 1398320, 1375767, 1353213, 1330659, 1308106, 1285552, 
  1262999, 1240445, 1217892, 1195338, 1172785, 1150231, 1127677, 1105124, 
  1082570, 1060017, 1037463, 1014910, 992356, 969803, 947249, 924695, 
  902142, 879588, 857035, 834481, 811928, 789374, 766821, 744267, 
  721713, 699160, 676606, 654053, 631499, 608946, 586392, 563838, 
  541285, 518731, 496178, 473624, 451071, 428517, 405964, 383410, 
  360856, 338303, 315749, 293196, 270642, 248089, 225535, 202982, 
  180428, 157874, 135321, 112767, 90214, 67660, 45107, 22553, 
  0, -22553, -45107, -67660, -90214, -112767, -135321, -157874, 
  -180428, -202982, -225535, -248089, -270642, -293196, -315749, -338303, 
  -360856, -383410, -405964, -428517, -451071, -473624, -496178, -518731, 
  -541285, -563838, -586392, -608946, -631499, -654053, -676606, -699160, 
  -721713, -744267, -766821, -789374, -811928, -834481, -857035, -879588, 
  -902142, -924695, -947249, -969803, -992356, -1014910, -1037463, -1060017, 
  -1082570, -1105124, -1127677, -1150231, -1172785, -1195338, -1217892, -1240445, 
  -1262999, -1285552, -1308106, -1330659, -1353213, -1375767, -1398320, -1420874, 
  -1443427, -1465981, -1488534, -1511088, -1533642, -1556195, -1578749, -1601302, 
  -1623856, -1646409, -1668963, -1691516, -1714070, -1736624, -1759177, -1781731, 
  -1804284, -1826838, -1849391, -1871945, -1894498, -1917052, -1939606, -1962159, 
  -1984713, -2007266, -2029820, -2052373, -2074927, -2097480, -2120034, -2142588, 
  -2165141, -2187695, -2210248, -2232802, -2255355, -2277909, -2300463, -2323016, 
  -2345570, -2368123, -2390677, -2413230, -2435784, -2458337, -2480891, -2503445, 
  -2525998, -2548552, -2571105, -2593659, -2616212, -2638766, -2661319, -2683873, 
  -2706427, -2728980, -2751534, -2774087, -2796641, -2819194, -2841748, -2864301, 
};

int gavl_vj_to_g[256] = 
{
  5990640, 5943838, 5897036, 5850234, 5803433, 5756631, 5709829, 5663027, 
  5616225, 5569423, 5522621, 5475819, 5429017, 5382216, 5335414, 5288612, 
  5241810, 5195008, 5148206, 5101404, 5054602, 5007801, 4960999, 4914197, 
  4867395, 4820593, 4773791, 4726989, 4680187, 4633386, 4586584, 4539782, 
  4492980, 4446178, 4399376, 4352574, 4305772, 4258970, 4212169, 4165367, 
  4118565, 4071763, 4024961, 3978159, 3931357, 3884555, 3837754, 3790952, 
  3744150, 3697348, 3650546, 3603744, 3556942, 3510140, 3463339, 3416537, 
  3369735, 3322933, 3276131, 3229329, 3182527, 3135725, 3088924, 3042122, 
  2995320, 2948518, 2901716, 2854914, 2808112, 2761310, 2714508, 2667707, 
  2620905, 2574103, 2527301, 2480499, 2433697, 2386895, 2340093, 2293292, 
  2246490, 2199688, 2152886, 2106084, 2059282, 2012480, 1965678, 1918877, 
  1872075, 1825273, 1778471, 1731669, 1684867, 1638065, 1591263, 1544462, 
  1497660, 1450858, 1404056, 1357254, 1310452, 1263650, 1216848, 1170046, 
  1123245, 1076443, 1029641, 982839, 936037, 889235, 842433, 795631, 
  748830, 702028, 655226, 608424, 561622, 514820, 468018, 421216, 
  374415, 327613, 280811, 234009, 187207, 140405, 93603, 46801, 
  0, -46801, -93603, -140405, -187207, -234009, -280811, -327613, 
  -374415, -421216, -468018, -514820, -561622, -608424, -655226, -702028, 
  -748830, -795631, -842433, -889235, -936037, -982839, -1029641, -1076443, 
  -1123245, -1170046, -1216848, -1263650, -1310452, -1357254, -1404056, -1450858, 
  -1497660, -1544462, -1591263, -1638065, -1684867, -1731669, -1778471, -1825273, 
  -1872075, -1918877, -1965678, -2012480, -2059282, -2106084, -2152886, -2199688, 
  -2246490, -2293292, -2340093, -2386895, -2433697, -2480499, -2527301, -2574103, 
  -2620905, -2667707, -2714508, -2761310, -2808112, -2854914, -2901716, -2948518, 
  -2995320, -3042122, -3088924, -3135725, -3182527, -3229329, -3276131, -3322933, 
  -3369735, -3416537, -3463339, -3510140, -3556942, -3603744, -3650546, -3697348, 
  -3744150, -3790952, -3837754, -3884555, -3931357, -3978159, -4024961, -4071763, 
  -4118565, -4165367, -4212169, -4258970, -4305772, -4352574, -4399376, -4446178, 
  -4492980, -4539782, -4586584, -4633386, -4680187, -4726989, -4773791, -4820593, 
  -4867395, -4914197, -4960999, -5007801, -5054602, -5101404, -5148206, -5195008, 
  -5241810, -5288612, -5335414, -5382216, -5429017, -5475819, -5522621, -5569423, 
  -5616225, -5663027, -5709829, -5756631, -5803433, -5850234, -5897036, -5943838, 
};

int gavl_uj_to_b[256] = 
{
  -14864613, -14748483, -14632353, -14516224, -14400094, -14283964, -14167834, -14051704, 
  -13935575, -13819445, -13703315, -13587185, -13471055, -13354926, -13238796, -13122666, 
  -13006536, -12890406, -12774277, -12658147, -12542017, -12425887, -12309757, -12193628, 
  -12077498, -11961368, -11845238, -11729108, -11612979, -11496849, -11380719, -11264589, 
  -11148460, -11032330, -10916200, -10800070, -10683940, -10567811, -10451681, -10335551, 
  -10219421, -10103291, -9987162, -9871032, -9754902, -9638772, -9522642, -9406513, 
  -9290383, -9174253, -9058123, -8941993, -8825864, -8709734, -8593604, -8477474, 
  -8361345, -8245215, -8129085, -8012955, -7896825, -7780696, -7664566, -7548436, 
  -7432306, -7316176, -7200047, -7083917, -6967787, -6851657, -6735527, -6619398, 
  -6503268, -6387138, -6271008, -6154878, -6038749, -5922619, -5806489, -5690359, 
  -5574230, -5458100, -5341970, -5225840, -5109710, -4993581, -4877451, -4761321, 
  -4645191, -4529061, -4412932, -4296802, -4180672, -4064542, -3948412, -3832283, 
  -3716153, -3600023, -3483893, -3367763, -3251634, -3135504, -3019374, -2903244, 
  -2787115, -2670985, -2554855, -2438725, -2322595, -2206466, -2090336, -1974206, 
  -1858076, -1741946, -1625817, -1509687, -1393557, -1277427, -1161297, -1045168, 
  -929038, -812908, -696778, -580648, -464519, -348389, -232259, -116129, 
  0, 116129, 232259, 348389, 464519, 580648, 696778, 812908, 
  929038, 1045168, 1161297, 1277427, 1393557, 1509687, 1625817, 1741946, 
  1858076, 1974206, 2090336, 2206466, 2322595, 2438725, 2554855, 2670985, 
  2787115, 2903244, 3019374, 3135504, 3251634, 3367763, 3483893, 3600023, 
  3716153, 3832283, 3948412, 4064542, 4180672, 4296802, 4412932, 4529061, 
  4645191, 4761321, 4877451, 4993581, 5109710, 5225840, 5341970, 5458100, 
  5574230, 5690359, 5806489, 5922619, 6038749, 6154878, 6271008, 6387138, 
  6503268, 6619398, 6735527, 6851657, 6967787, 7083917, 7200047, 7316176, 
  7432306, 7548436, 7664566, 7780696, 7896825, 8012955, 8129085, 8245215, 
  8361345, 8477474, 8593604, 8709734, 8825864, 8941993, 9058123, 9174253, 
  9290383, 9406513, 9522642, 9638772, 9754902, 9871032, 9987162, 10103291, 
  10219421, 10335551, 10451681, 10567811, 10683940, 10800070, 10916200, 11032330, 
  11148460, 11264589, 11380719, 11496849, 11612979, 11729108, 11845238, 11961368, 
  12077498, 12193628, 12309757, 12425887, 12542017, 12658147, 12774277, 12890406, 
  13006536, 13122666, 13238796, 13354926, 13471055, 13587185, 13703315, 13819445, 
  13935575, 14051704, 14167834, 14283964, 14400094, 14516224, 14632353, 14748483, 
};

float gavl_y_to_rgb_float[256] = 
{
  -0.073059, -0.068493, -0.063927, -0.059361, -0.054795, -0.050228, -0.045662, -0.041096, 
  -0.036530, -0.031963, -0.027397, -0.022831, -0.018265, -0.013699, -0.009132, -0.004566, 
  0.000000, 0.004566, 0.009132, 0.013699, 0.018265, 0.022831, 0.027397, 0.031963, 
  0.036530, 0.041096, 0.045662, 0.050228, 0.054795, 0.059361, 0.063927, 0.068493, 
  0.073059, 0.077626, 0.082192, 0.086758, 0.091324, 0.095890, 0.100457, 0.105023, 
  0.109589, 0.114155, 0.118721, 0.123288, 0.127854, 0.132420, 0.136986, 0.141553, 
  0.146119, 0.150685, 0.155251, 0.159817, 0.164384, 0.168950, 0.173516, 0.178082, 
  0.182648, 0.187215, 0.191781, 0.196347, 0.200913, 0.205479, 0.210046, 0.214612, 
  0.219178, 0.223744, 0.228311, 0.232877, 0.237443, 0.242009, 0.246575, 0.251142, 
  0.255708, 0.260274, 0.264840, 0.269406, 0.273973, 0.278539, 0.283105, 0.287671, 
  0.292237, 0.296804, 0.301370, 0.305936, 0.310502, 0.315068, 0.319635, 0.324201, 
  0.328767, 0.333333, 0.337900, 0.342466, 0.347032, 0.351598, 0.356164, 0.360731, 
  0.365297, 0.369863, 0.374429, 0.378995, 0.383562, 0.388128, 0.392694, 0.397260, 
  0.401826, 0.406393, 0.410959, 0.415525, 0.420091, 0.424658, 0.429224, 0.433790, 
  0.438356, 0.442922, 0.447489, 0.452055, 0.456621, 0.461187, 0.465753, 0.470320, 
  0.474886, 0.479452, 0.484018, 0.488584, 0.493151, 0.497717, 0.502283, 0.506849, 
  0.511416, 0.515982, 0.520548, 0.525114, 0.529680, 0.534247, 0.538813, 0.543379, 
  0.547945, 0.552511, 0.557078, 0.561644, 0.566210, 0.570776, 0.575342, 0.579909, 
  0.584475, 0.589041, 0.593607, 0.598174, 0.602740, 0.607306, 0.611872, 0.616438, 
  0.621005, 0.625571, 0.630137, 0.634703, 0.639269, 0.643836, 0.648402, 0.652968, 
  0.657534, 0.662100, 0.666667, 0.671233, 0.675799, 0.680365, 0.684932, 0.689498, 
  0.694064, 0.698630, 0.703196, 0.707763, 0.712329, 0.716895, 0.721461, 0.726027, 
  0.730594, 0.735160, 0.739726, 0.744292, 0.748858, 0.753425, 0.757991, 0.762557, 
  0.767123, 0.771689, 0.776256, 0.780822, 0.785388, 0.789954, 0.794521, 0.799087, 
  0.803653, 0.808219, 0.812785, 0.817352, 0.821918, 0.826484, 0.831050, 0.835616, 
  0.840183, 0.844749, 0.849315, 0.853881, 0.858447, 0.863014, 0.867580, 0.872146, 
  0.876712, 0.881279, 0.885845, 0.890411, 0.894977, 0.899543, 0.904110, 0.908676, 
  0.913242, 0.917808, 0.922374, 0.926941, 0.931507, 0.936073, 0.940639, 0.945205, 
  0.949772, 0.954338, 0.958904, 0.963470, 0.968037, 0.972603, 0.977169, 0.981735, 
  0.986301, 0.990868, 0.995434, 1.000000, 1.004566, 1.009132, 1.013699, 1.018265, 
  1.022831, 1.027397, 1.031963, 1.036530, 1.041096, 1.045662, 1.050228, 1.054795, 
  1.059361, 1.063927, 1.068493, 1.073059, 1.077626, 1.082192, 1.086758, 1.091324, 
};

float gavl_v_to_r_float[256] = 
{
  -0.801143, -0.794884, -0.788625, -0.782366, -0.776107, -0.769848, -0.763589, -0.757330, 
  -0.751071, -0.744812, -0.738554, -0.732295, -0.726036, -0.719777, -0.713518, -0.707259, 
  -0.701000, -0.694741, -0.688482, -0.682223, -0.675964, -0.669705, -0.663446, -0.657187, 
  -0.650929, -0.644670, -0.638411, -0.632152, -0.625893, -0.619634, -0.613375, -0.607116, 
  -0.600857, -0.594598, -0.588339, -0.582080, -0.575821, -0.569562, -0.563304, -0.557045, 
  -0.550786, -0.544527, -0.538268, -0.532009, -0.525750, -0.519491, -0.513232, -0.506973, 
  -0.500714, -0.494455, -0.488196, -0.481937, -0.475679, -0.469420, -0.463161, -0.456902, 
  -0.450643, -0.444384, -0.438125, -0.431866, -0.425607, -0.419348, -0.413089, -0.406830, 
  -0.400571, -0.394312, -0.388054, -0.381795, -0.375536, -0.369277, -0.363018, -0.356759, 
  -0.350500, -0.344241, -0.337982, -0.331723, -0.325464, -0.319205, -0.312946, -0.306687, 
  -0.300429, -0.294170, -0.287911, -0.281652, -0.275393, -0.269134, -0.262875, -0.256616, 
  -0.250357, -0.244098, -0.237839, -0.231580, -0.225321, -0.219062, -0.212804, -0.206545, 
  -0.200286, -0.194027, -0.187768, -0.181509, -0.175250, -0.168991, -0.162732, -0.156473, 
  -0.150214, -0.143955, -0.137696, -0.131437, -0.125179, -0.118920, -0.112661, -0.106402, 
  -0.100143, -0.093884, -0.087625, -0.081366, -0.075107, -0.068848, -0.062589, -0.056330, 
  -0.050071, -0.043812, -0.037554, -0.031295, -0.025036, -0.018777, -0.012518, -0.006259, 
  0.000000, 0.006259, 0.012518, 0.018777, 0.025036, 0.031295, 0.037554, 0.043812, 
  0.050071, 0.056330, 0.062589, 0.068848, 0.075107, 0.081366, 0.087625, 0.093884, 
  0.100143, 0.106402, 0.112661, 0.118920, 0.125179, 0.131437, 0.137696, 0.143955, 
  0.150214, 0.156473, 0.162732, 0.168991, 0.175250, 0.181509, 0.187768, 0.194027, 
  0.200286, 0.206545, 0.212804, 0.219062, 0.225321, 0.231580, 0.237839, 0.244098, 
  0.250357, 0.256616, 0.262875, 0.269134, 0.275393, 0.281652, 0.287911, 0.294170, 
  0.300429, 0.306687, 0.312946, 0.319205, 0.325464, 0.331723, 0.337982, 0.344241, 
  0.350500, 0.356759, 0.363018, 0.369277, 0.375536, 0.381795, 0.388054, 0.394312, 
  0.400571, 0.406830, 0.413089, 0.419348, 0.425607, 0.431866, 0.438125, 0.444384, 
  0.450643, 0.456902, 0.463161, 0.469420, 0.475679, 0.481937, 0.488196, 0.494455, 
  0.500714, 0.506973, 0.513232, 0.519491, 0.525750, 0.532009, 0.538268, 0.544527, 
  0.550786, 0.557045, 0.563304, 0.569562, 0.575821, 0.582080, 0.588339, 0.594598, 
  0.600857, 0.607116, 0.613375, 0.619634, 0.625893, 0.632152, 0.638411, 0.644670, 
  0.650929, 0.657187, 0.663446, 0.669705, 0.675964, 0.682223, 0.688482, 0.694741, 
  0.701000, 0.707259, 0.713518, 0.719777, 0.726036, 0.732295, 0.738554, 0.744812, 
  0.751071, 0.757330, 0.763589, 0.769848, 0.776107, 0.782366, 0.788625, 0.794884, 
};

float gavl_u_to_g_float[256] = 
{
  0.196651, 0.195115, 0.193579, 0.192042, 0.190506, 0.188970, 0.187433, 0.185897, 
  0.184361, 0.182824, 0.181288, 0.179752, 0.178215, 0.176679, 0.175143, 0.173606, 
  0.172070, 0.170534, 0.168997, 0.167461, 0.165925, 0.164388, 0.162852, 0.161316, 
  0.159779, 0.158243, 0.156707, 0.155170, 0.153634, 0.152098, 0.150561, 0.149025, 
  0.147489, 0.145952, 0.144416, 0.142880, 0.141343, 0.139807, 0.138271, 0.136734, 
  0.135198, 0.133662, 0.132125, 0.130589, 0.129052, 0.127516, 0.125980, 0.124443, 
  0.122907, 0.121371, 0.119834, 0.118298, 0.116762, 0.115225, 0.113689, 0.112153, 
  0.110616, 0.109080, 0.107544, 0.106007, 0.104471, 0.102935, 0.101398, 0.099862, 
  0.098326, 0.096789, 0.095253, 0.093717, 0.092180, 0.090644, 0.089108, 0.087571, 
  0.086035, 0.084499, 0.082962, 0.081426, 0.079890, 0.078353, 0.076817, 0.075281, 
  0.073744, 0.072208, 0.070672, 0.069135, 0.067599, 0.066063, 0.064526, 0.062990, 
  0.061454, 0.059917, 0.058381, 0.056845, 0.055308, 0.053772, 0.052236, 0.050699, 
  0.049163, 0.047627, 0.046090, 0.044554, 0.043018, 0.041481, 0.039945, 0.038408, 
  0.036872, 0.035336, 0.033799, 0.032263, 0.030727, 0.029190, 0.027654, 0.026118, 
  0.024581, 0.023045, 0.021509, 0.019972, 0.018436, 0.016900, 0.015363, 0.013827, 
  0.012291, 0.010754, 0.009218, 0.007682, 0.006145, 0.004609, 0.003073, 0.001536, 
  -0.000000, -0.001536, -0.003073, -0.004609, -0.006145, -0.007682, -0.009218, -0.010754, 
  -0.012291, -0.013827, -0.015363, -0.016900, -0.018436, -0.019972, -0.021509, -0.023045, 
  -0.024581, -0.026118, -0.027654, -0.029190, -0.030727, -0.032263, -0.033799, -0.035336, 
  -0.036872, -0.038408, -0.039945, -0.041481, -0.043018, -0.044554, -0.046090, -0.047627, 
  -0.049163, -0.050699, -0.052236, -0.053772, -0.055308, -0.056845, -0.058381, -0.059917, 
  -0.061454, -0.062990, -0.064526, -0.066063, -0.067599, -0.069135, -0.070672, -0.072208, 
  -0.073744, -0.075281, -0.076817, -0.078353, -0.079890, -0.081426, -0.082962, -0.084499, 
  -0.086035, -0.087571, -0.089108, -0.090644, -0.092180, -0.093717, -0.095253, -0.096789, 
  -0.098326, -0.099862, -0.101398, -0.102935, -0.104471, -0.106007, -0.107544, -0.109080, 
  -0.110616, -0.112153, -0.113689, -0.115225, -0.116762, -0.118298, -0.119834, -0.121371, 
  -0.122907, -0.124443, -0.125980, -0.127516, -0.129052, -0.130589, -0.132125, -0.133662, 
  -0.135198, -0.136734, -0.138271, -0.139807, -0.141343, -0.142880, -0.144416, -0.145952, 
  -0.147489, -0.149025, -0.150561, -0.152098, -0.153634, -0.155170, -0.156707, -0.158243, 
  -0.159779, -0.161316, -0.162852, -0.164388, -0.165925, -0.167461, -0.168997, -0.170534, 
  -0.172070, -0.173606, -0.175143, -0.176679, -0.178215, -0.179752, -0.181288, -0.182824, 
  -0.184361, -0.185897, -0.187433, -0.188970, -0.190506, -0.192042, -0.193579, -0.195115, 
};

float gavl_v_to_g_float[256] = 
{
  0.408080, 0.404892, 0.401704, 0.398516, 0.395327, 0.392139, 0.388951, 0.385763, 
  0.382575, 0.379387, 0.376199, 0.373011, 0.369822, 0.366634, 0.363446, 0.360258, 
  0.357070, 0.353882, 0.350694, 0.347506, 0.344317, 0.341129, 0.337941, 0.334753, 
  0.331565, 0.328377, 0.325189, 0.322001, 0.318812, 0.315624, 0.312436, 0.309248, 
  0.306060, 0.302872, 0.299684, 0.296496, 0.293307, 0.290119, 0.286931, 0.283743, 
  0.280555, 0.277367, 0.274179, 0.270991, 0.267802, 0.264614, 0.261426, 0.258238, 
  0.255050, 0.251862, 0.248674, 0.245486, 0.242297, 0.239109, 0.235921, 0.232733, 
  0.229545, 0.226357, 0.223169, 0.219981, 0.216792, 0.213604, 0.210416, 0.207228, 
  0.204040, 0.200852, 0.197664, 0.194476, 0.191287, 0.188099, 0.184911, 0.181723, 
  0.178535, 0.175347, 0.172159, 0.168971, 0.165782, 0.162594, 0.159406, 0.156218, 
  0.153030, 0.149842, 0.146654, 0.143466, 0.140277, 0.137089, 0.133901, 0.130713, 
  0.127525, 0.124337, 0.121149, 0.117961, 0.114772, 0.111584, 0.108396, 0.105208, 
  0.102020, 0.098832, 0.095644, 0.092456, 0.089267, 0.086079, 0.082891, 0.079703, 
  0.076515, 0.073327, 0.070139, 0.066951, 0.063762, 0.060574, 0.057386, 0.054198, 
  0.051010, 0.047822, 0.044634, 0.041446, 0.038257, 0.035069, 0.031881, 0.028693, 
  0.025505, 0.022317, 0.019129, 0.015941, 0.012752, 0.009564, 0.006376, 0.003188, 
  -0.000000, -0.003188, -0.006376, -0.009564, -0.012752, -0.015941, -0.019129, -0.022317, 
  -0.025505, -0.028693, -0.031881, -0.035069, -0.038257, -0.041446, -0.044634, -0.047822, 
  -0.051010, -0.054198, -0.057386, -0.060574, -0.063762, -0.066951, -0.070139, -0.073327, 
  -0.076515, -0.079703, -0.082891, -0.086079, -0.089267, -0.092456, -0.095644, -0.098832, 
  -0.102020, -0.105208, -0.108396, -0.111584, -0.114772, -0.117961, -0.121149, -0.124337, 
  -0.127525, -0.130713, -0.133901, -0.137089, -0.140277, -0.143466, -0.146654, -0.149842, 
  -0.153030, -0.156218, -0.159406, -0.162594, -0.165782, -0.168971, -0.172159, -0.175347, 
  -0.178535, -0.181723, -0.184911, -0.188099, -0.191287, -0.194476, -0.197664, -0.200852, 
  -0.204040, -0.207228, -0.210416, -0.213604, -0.216792, -0.219981, -0.223169, -0.226357, 
  -0.229545, -0.232733, -0.235921, -0.239109, -0.242297, -0.245486, -0.248674, -0.251862, 
  -0.255050, -0.258238, -0.261426, -0.264614, -0.267802, -0.270991, -0.274179, -0.277367, 
  -0.280555, -0.283743, -0.286931, -0.290119, -0.293307, -0.296496, -0.299684, -0.302872, 
  -0.306060, -0.309248, -0.312436, -0.315624, -0.318812, -0.322001, -0.325189, -0.328377, 
  -0.331565, -0.334753, -0.337941, -0.341129, -0.344317, -0.347506, -0.350694, -0.353882, 
  -0.357070, -0.360258, -0.363446, -0.366634, -0.369822, -0.373011, -0.376199, -0.379387, 
  -0.382575, -0.385763, -0.388951, -0.392139, -0.395327, -0.398516, -0.401704, -0.404892, 
};

float gavl_u_to_b_float[256] = 
{
  -1.012571, -1.004661, -0.996750, -0.988839, -0.980929, -0.973018, -0.965107, -0.957196, 
  -0.949286, -0.941375, -0.933464, -0.925554, -0.917643, -0.909732, -0.901821, -0.893911, 
  -0.886000, -0.878089, -0.870179, -0.862268, -0.854357, -0.846446, -0.838536, -0.830625, 
  -0.822714, -0.814804, -0.806893, -0.798982, -0.791071, -0.783161, -0.775250, -0.767339, 
  -0.759429, -0.751518, -0.743607, -0.735696, -0.727786, -0.719875, -0.711964, -0.704054, 
  -0.696143, -0.688232, -0.680321, -0.672411, -0.664500, -0.656589, -0.648679, -0.640768, 
  -0.632857, -0.624946, -0.617036, -0.609125, -0.601214, -0.593304, -0.585393, -0.577482, 
  -0.569571, -0.561661, -0.553750, -0.545839, -0.537929, -0.530018, -0.522107, -0.514196, 
  -0.506286, -0.498375, -0.490464, -0.482554, -0.474643, -0.466732, -0.458821, -0.450911, 
  -0.443000, -0.435089, -0.427179, -0.419268, -0.411357, -0.403446, -0.395536, -0.387625, 
  -0.379714, -0.371804, -0.363893, -0.355982, -0.348071, -0.340161, -0.332250, -0.324339, 
  -0.316429, -0.308518, -0.300607, -0.292696, -0.284786, -0.276875, -0.268964, -0.261054, 
  -0.253143, -0.245232, -0.237321, -0.229411, -0.221500, -0.213589, -0.205679, -0.197768, 
  -0.189857, -0.181946, -0.174036, -0.166125, -0.158214, -0.150304, -0.142393, -0.134482, 
  -0.126571, -0.118661, -0.110750, -0.102839, -0.094929, -0.087018, -0.079107, -0.071196, 
  -0.063286, -0.055375, -0.047464, -0.039554, -0.031643, -0.023732, -0.015821, -0.007911, 
  0.000000, 0.007911, 0.015821, 0.023732, 0.031643, 0.039554, 0.047464, 0.055375, 
  0.063286, 0.071196, 0.079107, 0.087018, 0.094929, 0.102839, 0.110750, 0.118661, 
  0.126571, 0.134482, 0.142393, 0.150304, 0.158214, 0.166125, 0.174036, 0.181946, 
  0.189857, 0.197768, 0.205679, 0.213589, 0.221500, 0.229411, 0.237321, 0.245232, 
  0.253143, 0.261054, 0.268964, 0.276875, 0.284786, 0.292696, 0.300607, 0.308518, 
  0.316429, 0.324339, 0.332250, 0.340161, 0.348071, 0.355982, 0.363893, 0.371804, 
  0.379714, 0.387625, 0.395536, 0.403446, 0.411357, 0.419268, 0.427179, 0.435089, 
  0.443000, 0.450911, 0.458821, 0.466732, 0.474643, 0.482554, 0.490464, 0.498375, 
  0.506286, 0.514196, 0.522107, 0.530018, 0.537929, 0.545839, 0.553750, 0.561661, 
  0.569571, 0.577482, 0.585393, 0.593304, 0.601214, 0.609125, 0.617036, 0.624946, 
  0.632857, 0.640768, 0.648679, 0.656589, 0.664500, 0.672411, 0.680321, 0.688232, 
  0.696143, 0.704054, 0.711964, 0.719875, 0.727786, 0.735696, 0.743607, 0.751518, 
  0.759429, 0.767339, 0.775250, 0.783161, 0.791071, 0.798982, 0.806893, 0.814804, 
  0.822714, 0.830625, 0.838536, 0.846446, 0.854357, 0.862268, 0.870179, 0.878089, 
  0.886000, 0.893911, 0.901821, 0.909732, 0.917643, 0.925554, 0.933464, 0.941375, 
  0.949286, 0.957196, 0.965107, 0.973018, 0.980929, 0.988839, 0.996750, 1.004661, 
};

float gavl_yj_to_rgb_float[256] = 
{
  0.000000, 0.003922, 0.007843, 0.011765, 0.015686, 0.019608, 0.023529, 0.027451, 
  0.031373, 0.035294, 0.039216, 0.043137, 0.047059, 0.050980, 0.054902, 0.058824, 
  0.062745, 0.066667, 0.070588, 0.074510, 0.078431, 0.082353, 0.086275, 0.090196, 
  0.094118, 0.098039, 0.101961, 0.105882, 0.109804, 0.113725, 0.117647, 0.121569, 
  0.125490, 0.129412, 0.133333, 0.137255, 0.141176, 0.145098, 0.149020, 0.152941, 
  0.156863, 0.160784, 0.164706, 0.168627, 0.172549, 0.176471, 0.180392, 0.184314, 
  0.188235, 0.192157, 0.196078, 0.200000, 0.203922, 0.207843, 0.211765, 0.215686, 
  0.219608, 0.223529, 0.227451, 0.231373, 0.235294, 0.239216, 0.243137, 0.247059, 
  0.250980, 0.254902, 0.258824, 0.262745, 0.266667, 0.270588, 0.274510, 0.278431, 
  0.282353, 0.286275, 0.290196, 0.294118, 0.298039, 0.301961, 0.305882, 0.309804, 
  0.313725, 0.317647, 0.321569, 0.325490, 0.329412, 0.333333, 0.337255, 0.341176, 
  0.345098, 0.349020, 0.352941, 0.356863, 0.360784, 0.364706, 0.368627, 0.372549, 
  0.376471, 0.380392, 0.384314, 0.388235, 0.392157, 0.396078, 0.400000, 0.403922, 
  0.407843, 0.411765, 0.415686, 0.419608, 0.423529, 0.427451, 0.431373, 0.435294, 
  0.439216, 0.443137, 0.447059, 0.450980, 0.454902, 0.458824, 0.462745, 0.466667, 
  0.470588, 0.474510, 0.478431, 0.482353, 0.486275, 0.490196, 0.494118, 0.498039, 
  0.501961, 0.505882, 0.509804, 0.513725, 0.517647, 0.521569, 0.525490, 0.529412, 
  0.533333, 0.537255, 0.541176, 0.545098, 0.549020, 0.552941, 0.556863, 0.560784, 
  0.564706, 0.568627, 0.572549, 0.576471, 0.580392, 0.584314, 0.588235, 0.592157, 
  0.596078, 0.600000, 0.603922, 0.607843, 0.611765, 0.615686, 0.619608, 0.623529, 
  0.627451, 0.631373, 0.635294, 0.639216, 0.643137, 0.647059, 0.650980, 0.654902, 
  0.658824, 0.662745, 0.666667, 0.670588, 0.674510, 0.678431, 0.682353, 0.686275, 
  0.690196, 0.694118, 0.698039, 0.701961, 0.705882, 0.709804, 0.713725, 0.717647, 
  0.721569, 0.725490, 0.729412, 0.733333, 0.737255, 0.741176, 0.745098, 0.749020, 
  0.752941, 0.756863, 0.760784, 0.764706, 0.768627, 0.772549, 0.776471, 0.780392, 
  0.784314, 0.788235, 0.792157, 0.796078, 0.800000, 0.803922, 0.807843, 0.811765, 
  0.815686, 0.819608, 0.823529, 0.827451, 0.831373, 0.835294, 0.839216, 0.843137, 
  0.847059, 0.850980, 0.854902, 0.858824, 0.862745, 0.866667, 0.870588, 0.874510, 
  0.878431, 0.882353, 0.886275, 0.890196, 0.894118, 0.898039, 0.901961, 0.905882, 
  0.909804, 0.913725, 0.917647, 0.921569, 0.925490, 0.929412, 0.933333, 0.937255, 
  0.941176, 0.945098, 0.949020, 0.952941, 0.956863, 0.960784, 0.964706, 0.968627, 
  0.972549, 0.976471, 0.980392, 0.984314, 0.988235, 0.992157, 0.996078, 1.000000, 
};

float gavl_vj_to_r_float[256] = 
{
  -0.703749, -0.698251, -0.692753, -0.687255, -0.681757, -0.676259, -0.670761, -0.665263, 
  -0.659765, -0.654267, -0.648769, -0.643271, -0.637773, -0.632275, -0.626776, -0.621278, 
  -0.615780, -0.610282, -0.604784, -0.599286, -0.593788, -0.588290, -0.582792, -0.577294, 
  -0.571796, -0.566298, -0.560800, -0.555302, -0.549804, -0.544306, -0.538808, -0.533310, 
  -0.527812, -0.522314, -0.516816, -0.511318, -0.505820, -0.500322, -0.494824, -0.489325, 
  -0.483827, -0.478329, -0.472831, -0.467333, -0.461835, -0.456337, -0.450839, -0.445341, 
  -0.439843, -0.434345, -0.428847, -0.423349, -0.417851, -0.412353, -0.406855, -0.401357, 
  -0.395859, -0.390361, -0.384863, -0.379365, -0.373867, -0.368369, -0.362871, -0.357373, 
  -0.351875, -0.346376, -0.340878, -0.335380, -0.329882, -0.324384, -0.318886, -0.313388, 
  -0.307890, -0.302392, -0.296894, -0.291396, -0.285898, -0.280400, -0.274902, -0.269404, 
  -0.263906, -0.258408, -0.252910, -0.247412, -0.241914, -0.236416, -0.230918, -0.225420, 
  -0.219922, -0.214424, -0.208925, -0.203427, -0.197929, -0.192431, -0.186933, -0.181435, 
  -0.175937, -0.170439, -0.164941, -0.159443, -0.153945, -0.148447, -0.142949, -0.137451, 
  -0.131953, -0.126455, -0.120957, -0.115459, -0.109961, -0.104463, -0.098965, -0.093467, 
  -0.087969, -0.082471, -0.076973, -0.071475, -0.065976, -0.060478, -0.054980, -0.049482, 
  -0.043984, -0.038486, -0.032988, -0.027490, -0.021992, -0.016494, -0.010996, -0.005498, 
  0.000000, 0.005498, 0.010996, 0.016494, 0.021992, 0.027490, 0.032988, 0.038486, 
  0.043984, 0.049482, 0.054980, 0.060478, 0.065976, 0.071475, 0.076973, 0.082471, 
  0.087969, 0.093467, 0.098965, 0.104463, 0.109961, 0.115459, 0.120957, 0.126455, 
  0.131953, 0.137451, 0.142949, 0.148447, 0.153945, 0.159443, 0.164941, 0.170439, 
  0.175937, 0.181435, 0.186933, 0.192431, 0.197929, 0.203427, 0.208925, 0.214424, 
  0.219922, 0.225420, 0.230918, 0.236416, 0.241914, 0.247412, 0.252910, 0.258408, 
  0.263906, 0.269404, 0.274902, 0.280400, 0.285898, 0.291396, 0.296894, 0.302392, 
  0.307890, 0.313388, 0.318886, 0.324384, 0.329882, 0.335380, 0.340878, 0.346376, 
  0.351875, 0.357373, 0.362871, 0.368369, 0.373867, 0.379365, 0.384863, 0.390361, 
  0.395859, 0.401357, 0.406855, 0.412353, 0.417851, 0.423349, 0.428847, 0.434345, 
  0.439843, 0.445341, 0.450839, 0.456337, 0.461835, 0.467333, 0.472831, 0.478329, 
  0.483827, 0.489325, 0.494824, 0.500322, 0.505820, 0.511318, 0.516816, 0.522314, 
  0.527812, 0.533310, 0.538808, 0.544306, 0.549804, 0.555302, 0.560800, 0.566298, 
  0.571796, 0.577294, 0.582792, 0.588290, 0.593788, 0.599286, 0.604784, 0.610282, 
  0.615780, 0.621278, 0.626776, 0.632275, 0.637773, 0.643271, 0.648769, 0.654267, 
  0.659765, 0.665263, 0.670761, 0.676259, 0.681757, 0.687255, 0.692753, 0.698251, 
};

float gavl_uj_to_g_float[256] = 
{
  0.172745, 0.171395, 0.170046, 0.168696, 0.167347, 0.165997, 0.164647, 0.163298, 
  0.161948, 0.160599, 0.159249, 0.157900, 0.156550, 0.155200, 0.153851, 0.152501, 
  0.151152, 0.149802, 0.148453, 0.147103, 0.145753, 0.144404, 0.143054, 0.141705, 
  0.140355, 0.139006, 0.137656, 0.136306, 0.134957, 0.133607, 0.132258, 0.130908, 
  0.129559, 0.128209, 0.126859, 0.125510, 0.124160, 0.122811, 0.121461, 0.120112, 
  0.118762, 0.117412, 0.116063, 0.114713, 0.113364, 0.112014, 0.110665, 0.109315, 
  0.107965, 0.106616, 0.105266, 0.103917, 0.102567, 0.101218, 0.099868, 0.098519, 
  0.097169, 0.095819, 0.094470, 0.093120, 0.091771, 0.090421, 0.089072, 0.087722, 
  0.086372, 0.085023, 0.083673, 0.082324, 0.080974, 0.079625, 0.078275, 0.076925, 
  0.075576, 0.074226, 0.072877, 0.071527, 0.070178, 0.068828, 0.067478, 0.066129, 
  0.064779, 0.063430, 0.062080, 0.060731, 0.059381, 0.058031, 0.056682, 0.055332, 
  0.053983, 0.052633, 0.051284, 0.049934, 0.048584, 0.047235, 0.045885, 0.044536, 
  0.043186, 0.041837, 0.040487, 0.039137, 0.037788, 0.036438, 0.035089, 0.033739, 
  0.032390, 0.031040, 0.029691, 0.028341, 0.026991, 0.025642, 0.024292, 0.022943, 
  0.021593, 0.020244, 0.018894, 0.017544, 0.016195, 0.014845, 0.013496, 0.012146, 
  0.010797, 0.009447, 0.008097, 0.006748, 0.005398, 0.004049, 0.002699, 0.001350, 
  -0.000000, -0.001350, -0.002699, -0.004049, -0.005398, -0.006748, -0.008097, -0.009447, 
  -0.010797, -0.012146, -0.013496, -0.014845, -0.016195, -0.017544, -0.018894, -0.020244, 
  -0.021593, -0.022943, -0.024292, -0.025642, -0.026991, -0.028341, -0.029691, -0.031040, 
  -0.032390, -0.033739, -0.035089, -0.036438, -0.037788, -0.039137, -0.040487, -0.041837, 
  -0.043186, -0.044536, -0.045885, -0.047235, -0.048584, -0.049934, -0.051284, -0.052633, 
  -0.053983, -0.055332, -0.056682, -0.058031, -0.059381, -0.060731, -0.062080, -0.063430, 
  -0.064779, -0.066129, -0.067478, -0.068828, -0.070178, -0.071527, -0.072877, -0.074226, 
  -0.075576, -0.076925, -0.078275, -0.079625, -0.080974, -0.082324, -0.083673, -0.085023, 
  -0.086372, -0.087722, -0.089072, -0.090421, -0.091771, -0.093120, -0.094470, -0.095819, 
  -0.097169, -0.098519, -0.099868, -0.101218, -0.102567, -0.103917, -0.105266, -0.106616, 
  -0.107965, -0.109315, -0.110665, -0.112014, -0.113364, -0.114713, -0.116063, -0.117412, 
  -0.118762, -0.120112, -0.121461, -0.122811, -0.124160, -0.125510, -0.126859, -0.128209, 
  -0.129559, -0.130908, -0.132258, -0.133607, -0.134957, -0.136306, -0.137656, -0.139006, 
  -0.140355, -0.141705, -0.143054, -0.144404, -0.145753, -0.147103, -0.148453, -0.149802, 
  -0.151152, -0.152501, -0.153851, -0.155200, -0.156550, -0.157900, -0.159249, -0.160599, 
  -0.161948, -0.163298, -0.164647, -0.165997, -0.167347, -0.168696, -0.170046, -0.171395, 
};

float gavl_vj_to_g_float[256] = 
{
  0.358470, 0.355670, 0.352869, 0.350069, 0.347268, 0.344468, 0.341667, 0.338866, 
  0.336066, 0.333265, 0.330465, 0.327664, 0.324864, 0.322063, 0.319263, 0.316462, 
  0.313661, 0.310861, 0.308060, 0.305260, 0.302459, 0.299659, 0.296858, 0.294058, 
  0.291257, 0.288457, 0.285656, 0.282855, 0.280055, 0.277254, 0.274454, 0.271653, 
  0.268853, 0.266052, 0.263252, 0.260451, 0.257651, 0.254850, 0.252049, 0.249249, 
  0.246448, 0.243648, 0.240847, 0.238047, 0.235246, 0.232446, 0.229645, 0.226844, 
  0.224044, 0.221243, 0.218443, 0.215642, 0.212842, 0.210041, 0.207241, 0.204440, 
  0.201640, 0.198839, 0.196038, 0.193238, 0.190437, 0.187637, 0.184836, 0.182036, 
  0.179235, 0.176435, 0.173634, 0.170833, 0.168033, 0.165232, 0.162432, 0.159631, 
  0.156831, 0.154030, 0.151230, 0.148429, 0.145629, 0.142828, 0.140027, 0.137227, 
  0.134426, 0.131626, 0.128825, 0.126025, 0.123224, 0.120424, 0.117623, 0.114823, 
  0.112022, 0.109221, 0.106421, 0.103620, 0.100820, 0.098019, 0.095219, 0.092418, 
  0.089618, 0.086817, 0.084016, 0.081216, 0.078415, 0.075615, 0.072814, 0.070014, 
  0.067213, 0.064413, 0.061612, 0.058812, 0.056011, 0.053210, 0.050410, 0.047609, 
  0.044809, 0.042008, 0.039208, 0.036407, 0.033607, 0.030806, 0.028005, 0.025205, 
  0.022404, 0.019604, 0.016803, 0.014003, 0.011202, 0.008402, 0.005601, 0.002801, 
  -0.000000, -0.002801, -0.005601, -0.008402, -0.011202, -0.014003, -0.016803, -0.019604, 
  -0.022404, -0.025205, -0.028005, -0.030806, -0.033607, -0.036407, -0.039208, -0.042008, 
  -0.044809, -0.047609, -0.050410, -0.053210, -0.056011, -0.058812, -0.061612, -0.064413, 
  -0.067213, -0.070014, -0.072814, -0.075615, -0.078415, -0.081216, -0.084016, -0.086817, 
  -0.089618, -0.092418, -0.095219, -0.098019, -0.100820, -0.103620, -0.106421, -0.109221, 
  -0.112022, -0.114823, -0.117623, -0.120424, -0.123224, -0.126025, -0.128825, -0.131626, 
  -0.134426, -0.137227, -0.140027, -0.142828, -0.145629, -0.148429, -0.151230, -0.154030, 
  -0.156831, -0.159631, -0.162432, -0.165232, -0.168033, -0.170833, -0.173634, -0.176435, 
  -0.179235, -0.182036, -0.184836, -0.187637, -0.190437, -0.193238, -0.196038, -0.198839, 
  -0.201640, -0.204440, -0.207241, -0.210041, -0.212842, -0.215642, -0.218443, -0.221243, 
  -0.224044, -0.226844, -0.229645, -0.232446, -0.235246, -0.238047, -0.240847, -0.243648, 
  -0.246448, -0.249249, -0.252049, -0.254850, -0.257651, -0.260451, -0.263252, -0.266052, 
  -0.268853, -0.271653, -0.274454, -0.277254, -0.280055, -0.282855, -0.285656, -0.288457, 
  -0.291257, -0.294058, -0.296858, -0.299659, -0.302459, -0.305260, -0.308060, -0.310861, 
  -0.313661, -0.316462, -0.319263, -0.322063, -0.324864, -0.327664, -0.330465, -0.333265, 
  -0.336066, -0.338866, -0.341667, -0.344468, -0.347268, -0.350069, -0.352869, -0.355670, 
};

float gavl_uj_to_b_float[256] = 
{
  -0.889475, -0.882525, -0.875576, -0.868627, -0.861678, -0.854729, -0.847780, -0.840831, 
  -0.833882, -0.826933, -0.819984, -0.813035, -0.806086, -0.799137, -0.792188, -0.785239, 
  -0.778290, -0.771341, -0.764392, -0.757443, -0.750494, -0.743545, -0.736596, -0.729647, 
  -0.722698, -0.715749, -0.708800, -0.701851, -0.694902, -0.687953, -0.681004, -0.674055, 
  -0.667106, -0.660157, -0.653208, -0.646259, -0.639310, -0.632361, -0.625412, -0.618463, 
  -0.611514, -0.604565, -0.597616, -0.590667, -0.583718, -0.576769, -0.569820, -0.562871, 
  -0.555922, -0.548973, -0.542024, -0.535075, -0.528125, -0.521176, -0.514227, -0.507278, 
  -0.500329, -0.493380, -0.486431, -0.479482, -0.472533, -0.465584, -0.458635, -0.451686, 
  -0.444737, -0.437788, -0.430839, -0.423890, -0.416941, -0.409992, -0.403043, -0.396094, 
  -0.389145, -0.382196, -0.375247, -0.368298, -0.361349, -0.354400, -0.347451, -0.340502, 
  -0.333553, -0.326604, -0.319655, -0.312706, -0.305757, -0.298808, -0.291859, -0.284910, 
  -0.277961, -0.271012, -0.264063, -0.257114, -0.250165, -0.243216, -0.236267, -0.229318, 
  -0.222369, -0.215420, -0.208471, -0.201522, -0.194573, -0.187624, -0.180675, -0.173725, 
  -0.166776, -0.159827, -0.152878, -0.145929, -0.138980, -0.132031, -0.125082, -0.118133, 
  -0.111184, -0.104235, -0.097286, -0.090337, -0.083388, -0.076439, -0.069490, -0.062541, 
  -0.055592, -0.048643, -0.041694, -0.034745, -0.027796, -0.020847, -0.013898, -0.006949, 
  0.000000, 0.006949, 0.013898, 0.020847, 0.027796, 0.034745, 0.041694, 0.048643, 
  0.055592, 0.062541, 0.069490, 0.076439, 0.083388, 0.090337, 0.097286, 0.104235, 
  0.111184, 0.118133, 0.125082, 0.132031, 0.138980, 0.145929, 0.152878, 0.159827, 
  0.166776, 0.173725, 0.180675, 0.187624, 0.194573, 0.201522, 0.208471, 0.215420, 
  0.222369, 0.229318, 0.236267, 0.243216, 0.250165, 0.257114, 0.264063, 0.271012, 
  0.277961, 0.284910, 0.291859, 0.298808, 0.305757, 0.312706, 0.319655, 0.326604, 
  0.333553, 0.340502, 0.347451, 0.354400, 0.361349, 0.368298, 0.375247, 0.382196, 
  0.389145, 0.396094, 0.403043, 0.409992, 0.416941, 0.423890, 0.430839, 0.437788, 
  0.444737, 0.451686, 0.458635, 0.465584, 0.472533, 0.479482, 0.486431, 0.493380, 
  0.500329, 0.507278, 0.514227, 0.521176, 0.528125, 0.535075, 0.542024, 0.548973, 
  0.555922, 0.562871, 0.569820, 0.576769, 0.583718, 0.590667, 0.597616, 0.604565, 
  0.611514, 0.618463, 0.625412, 0.632361, 0.639310, 0.646259, 0.653208, 0.660157, 
  0.667106, 0.674055, 0.681004, 0.687953, 0.694902, 0.701851, 0.708800, 0.715749, 
  0.722698, 0.729647, 0.736596, 0.743545, 0.750494, 0.757443, 0.764392, 0.771341, 
  0.778290, 0.785239, 0.792188, 0.799137, 0.806086, 0.813035, 0.819984, 0.826933, 
  0.833882, 0.840831, 0.847780, 0.854729, 0.861678, 0.868627, 0.875576, 0.882525, 
};

