/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_BT829_H
#define GATOS_BT829_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_BT829_C
#define WHERE       
#else
#define WHERE	extern
#endif

#define BTREAD(R)	i2c_readreg8(gatos.bt829.addr,(R))
#define BTWRITE(R,V)	i2c_writereg8(gatos.bt829.addr,(R),(V))
#define H(X)		( ((X)>>8) & 0xFF )
#define L(X)		( (X) & 0xFF )

/* Bt829 family chip ID's */
#define BT815	0x02
#define BT817	0x06
#define BT819	0x07
#define BT827	0x0C
#define BT829	0x0E

/* Bt829 registers */
#define STATUS		0x00	/* Device Status */
#define IFORM		0x01	/* Input Format */
#define TDEC		0x02	/* Temporal Decimation */
#define CROP		0x03	/* MSB Cropping */
#define VDELAY_LO	0x04	/* Vertical Delay */
#define VACTIVE_LO	0x05	/* Vertical Active */
#define HDELAY_LO	0x06	/* Horizontal Delay */
#define HACTIVE_LO	0x07	/* Horizontal Active */
#define HSCALE_HI	0x08	/* Horizontal Scaling */
#define HSCALE_LO	0x09	/* Horizontal Scaling */
#define BRIGHT		0x0A	/* Brightness Control */
#define CONTROL		0x0B	/* Miscellaneous Control */
#define CONTRAST_LO	0x0C	/* Luma Gain (Contrast) */
#define SAT_U_LO	0x0D	/* Chroma (U) Gain (Saturation) */
#define SAT_V_LO	0x0E	/* Chroma (V) Gain (Saturation) */
#define HUE		0x0F	/* Hue Control */
#define SCLOOP		0x10	/* SC Loop Control */
#define WC_UP		0x11	/* White Crush Up Count */
#define OFORM		0x12	/* Output Format */
#define VSCALE_HI	0x13	/* Vertical Scaling */
#define VSCALE_LO	0x14	/* Vertical Scaling */
#define TEST		0x15	/* Test Control */
#define VPOLE		0x16	/* Video Timing Polarity */
#define IDCODE		0x17	/* ID Code */
#define ADELAY		0x18	/* AGC Delay */
#define BDELAY		0x19	/* Burst Gate Delay */
#define ADC		0x1A	/* ADC Interface */
#define VTC		0x1B	/* Video Timing Control */
#define CC_STATUS	0x1C	/* Extended Data Services/Closed Capt Status */
#define CC_DATA		0x1D	/* Extended Data Services/Closed Capt Data */
#define WC_DN		0x1E	/* White Crush Down Count */
#define SRESET		0x1F	/* Software Reset */
#define P_IO		0x3F	/* Programmable I/O */

/* Bt829 function declarations */

int	bt829_init(void) ;
int	bt829_setformat(void) ;
int	bt829_setmux(void) ;
int	bt829_setbrightness(void) ;
int	bt829_setcontrast(void) ;
int	bt829_setsaturation(void) ;
int	bt829_sethue(void) ;
int	bt829_setcaptsize(void) ;
int     bt829_setCC(void) ;
int     bt829_getCCdata(struct CCdata *) ;
void	bt829_dumpregs(void) ;

#ifdef GATOS_BT829_C
static int	bt829_register(u8, int, int) ;
static int	bt829_crop(void) ;
static int	bt829_ctrl(void) ;
static int	bt829_iform(void) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
