/*
  File autogenerated by gengetopt version 2.6  
  generated with the following command:
  /usr/local/bin/gengetopt --input ./cmdline.sh 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
"Purpose:\n"
"  The Ganglia Status Client (gstat) connects with a \n"
"  Ganglia Monitoring Daemon (gmond) and output a load-balanced list \n"
"  of cluster hosts\n"
"\n"
"Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h         --help             Print help and exit\n");
  printf("   -V         --version          Print version and exit\n");
  printf("   -a         --all              List all hosts.  Not just hosts running gexec (default=off)\n");
  printf("   -d         --dead             Print only the hosts which are dead (default=off)\n");
  printf("   -m         --mpifile          Print a load-balanced mpifile (default=off)\n");
  printf("   -1         --single_line      Print host and information all on one line (default=off)\n");
  printf("   -l         --list             Print ONLY the host list (default=off)\n");
  printf("   -iSTRING   --gmond_ip=STRING  Specify the ip address of the gmond to query (default='127.0.0.1')\n");
  printf("   -pINT      --gmond_port=INT   Specify the gmond port to query (default=8649)\n");
}


/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->all_given = 0 ;
  args_info->dead_given = 0 ;
  args_info->mpifile_given = 0 ;
  args_info->single_line_given = 0 ;
  args_info->list_given = 0 ;
  args_info->gmond_ip_given = 0 ;
  args_info->gmond_port_given = 0 ;
#define clear_args() { \
  args_info->all_flag = 0;\
  args_info->dead_flag = 0;\
  args_info->mpifile_flag = 0;\
  args_info->single_line_flag = 0;\
  args_info->list_flag = 0;\
  args_info->gmond_ip_arg = strdup("127.0.0.1") ;\
  args_info->gmond_port_arg = 8649;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "all",	0, NULL, 'a' },
        { "dead",	0, NULL, 'd' },
        { "mpifile",	0, NULL, 'm' },
        { "single_line",	0, NULL, '1' },
        { "list",	0, NULL, 'l' },
        { "gmond_ip",	1, NULL, 'i' },
        { "gmond_port",	1, NULL, 'p' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVadm1li:p:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'a':	/* List all hosts.  Not just hosts running gexec.  */
          if (args_info->all_given)
            {
              fprintf (stderr, "%s: `--all' (`-a') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->all_given = 1;
          args_info->all_flag = !(args_info->all_flag);
          break;

        case 'd':	/* Print only the hosts which are dead.  */
          if (args_info->dead_given)
            {
              fprintf (stderr, "%s: `--dead' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->dead_given = 1;
          args_info->dead_flag = !(args_info->dead_flag);
          break;

        case 'm':	/* Print a load-balanced mpifile.  */
          if (args_info->mpifile_given)
            {
              fprintf (stderr, "%s: `--mpifile' (`-m') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->mpifile_given = 1;
          args_info->mpifile_flag = !(args_info->mpifile_flag);
          break;

        case '1':	/* Print host and information all on one line.  */
          if (args_info->single_line_given)
            {
              fprintf (stderr, "%s: `--single_line' (`-1') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->single_line_given = 1;
          args_info->single_line_flag = !(args_info->single_line_flag);
          break;

        case 'l':	/* Print ONLY the host list.  */
          if (args_info->list_given)
            {
              fprintf (stderr, "%s: `--list' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->list_given = 1;
          args_info->list_flag = !(args_info->list_flag);
          break;

        case 'i':	/* Specify the ip address of the gmond to query.  */
          if (args_info->gmond_ip_given)
            {
              fprintf (stderr, "%s: `--gmond_ip' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->gmond_ip_given = 1;
          args_info->gmond_ip_arg = strdup (optarg);
          break;

        case 'p':	/* Specify the gmond port to query.  */
          if (args_info->gmond_port_given)
            {
              fprintf (stderr, "%s: `--gmond_port' (`-p') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->gmond_port_given = 1;
          args_info->gmond_port_arg = atoi (optarg);
          break;

        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( missing_required_options )
    exit (EXIT_FAILURE);


  return 0;
}
