 /* Gamine - GnunuX 11/25/07
  * This program is free software. It comes without any warranty, to
  * the extent permitted by applicable law. You can redistribute it
  * and/or modify it under the terms of the Do What The Fuck You Want
  * To Public License, Version 2, as published by Sam Hocevar. See
  * http://sam.zoy.org/wtfpl/COPYING for more details. */

#include <gtk/gtk.h>
#include <cairo.h>
#include <cairo-xlib.h>
#include <gdk/gdkx.h>
#include <math.h>
#include <gst/gst.h>
#include <gdk/gdkkeysyms.h>

typedef struct {
	GstElement *elt;
	gboolean repeat;
} closure_t;


gdouble xold;
gdouble yold;

static void eos_message_received (GstBus * bus, GstMessage * message, closure_t *closure)
{
	if (closure->repeat == TRUE)
	{
		gst_element_set_state (GST_ELEMENT(closure->elt), GST_STATE_NULL);
		gst_element_set_state (GST_ELEMENT(closure->elt), GST_STATE_PLAYING);
	} else {
		gst_element_set_state (GST_ELEMENT(closure->elt), GST_STATE_NULL);
		gst_object_unref (GST_OBJECT(closure->elt));
		closure->elt = NULL;
	}
}


static gint
gst_play_background (GstBus *bus, gchar *uri, gboolean repeat)
{
	gchar *path;
	GstElement *pipeline;
	pipeline = gst_element_factory_make("playbin", "playbin");
	if (pipeline != NULL)
	{
		closure_t *closure = g_new (closure_t, 1);
		closure->elt = pipeline;
		closure->repeat = repeat;
		bus = gst_pipeline_get_bus (GST_PIPELINE (pipeline));
		gst_bus_add_signal_watch_full (bus, G_PRIORITY_HIGH);
		g_signal_connect (bus, "message::eos", (GCallback) eos_message_received, closure);
		gst_object_unref (bus);
		path = g_strdup_printf("file://%s/sounds/%s", getenv("PWD"), uri);
		g_object_set (G_OBJECT(pipeline), "uri", path, NULL);
		gst_element_set_state (GST_ELEMENT(pipeline), GST_STATE_PLAYING);
	}
	return 0;

}

static cairo_t *
begin_paint (GdkDrawable *window)
{
	Display *dpy;
	Drawable xid;
	Visual *visual;
	GdkDrawable *drawable;
	gint x_offset, y_offset;
	gint width, height;
	cairo_surface_t *surface;
	cairo_t *cr;

	if (GDK_IS_WINDOW (window))
		gdk_window_get_internal_paint_info (window, &drawable,
		&x_offset, &y_offset);
	else
		drawable = window;

	dpy = gdk_x11_drawable_get_xdisplay (drawable);
	xid = gdk_x11_drawable_get_xid (drawable);
	gdk_drawable_get_size (drawable, &width, &height);
	visual = GDK_VISUAL_XVISUAL(gdk_drawable_get_visual (drawable));
	surface = cairo_xlib_surface_create (dpy, xid, visual,
		width, height);
	cr = cairo_create (surface);
	cairo_surface_destroy (surface);

	if (GDK_IS_WINDOW (window))
		cairo_translate (cr, -x_offset, -y_offset);

	return cr;
}

static void
end_paint (cairo_t *cr)
{
	cairo_destroy (cr);
}


static void
draw_star (GtkWidget    *widget,
	gdouble      cx,
	gdouble      cy)
{
	const gint spike_count = random() % 6 + 2;
	const gint inner_radius = 15;
	const gint outer_radius = 20;
	gfloat red = random() % 10 * 0.1;
	gfloat green = random() % 10 * 0.1;
	gfloat blue = random() % 10 * 0.1;
	cairo_t *cr;
	gdouble x, y;
	int i;
	cr = begin_paint (widget->window);

	cairo_set_source_rgb (cr, red, green, blue);
	cairo_new_path (cr);
	for (i = 0; i < spike_count; i++) {
		x = cx + cos ((i * 2) * M_PI / spike_count) * inner_radius;
		y = cy + sin ((i * 2) * M_PI / spike_count) * inner_radius;

		if (i == 0)
			cairo_move_to (cr, x, y);
		else
			cairo_line_to (cr, x, y);

	        x = cx + cos ((i * 2 + 1) * M_PI / spike_count) * outer_radius;
		y = cy + sin ((i * 2 + 1) * M_PI / spike_count) * outer_radius;

		cairo_line_to (cr, x, y);
	}
	cairo_fill (cr);
	end_paint (cr);
}

static gboolean
gamine_button_press_event (GtkWidget      *widget,
	GdkEventButton *event,
	GstBus *bus)
{
	gchar *tab[] = {"bonus.wav", "crash.wav", "eat.wav", "flip.wav", "level.wav",
		"plick.ogg", "tri.ogg", "brick.wav", "darken.wav", "eraser1.wav",
		"gobble.wav", "line_end.wav", "prompt.wav", "tuxok.wav", "bleep.wav",
		"bubble.wav", "drip.wav", "eraser2.wav", "grow.wav", "paint1.wav",
		"receive.wav", "youcannot.wav"};
	gint snd = rand() % 21;
	gst_play_background (bus, tab[snd], FALSE);
	draw_star (widget, event->x, event->y);
	return TRUE;
}
static gboolean
gamine_motion_notify_event (GtkWidget      *widget,
	GdkEventButton *event,
	GstBus *bus)
{
	cairo_t *drawingline;
	if (! xold)
	{
		xold=event->x;
		yold=event->y;
	} else {
		float red = ((rand() % 128) + 127) /255.0;
		float green = ((rand() % 128) + 127) /255.0;
		float blue = ((rand() % 128) + 127) /255.0;
		drawingline = begin_paint (widget->window);
/*		printf("line from: %g - %g to: %g - %g\n", xold, yold, event->x, event->y);*/
		cairo_new_path (drawingline);
		cairo_set_source_rgba (drawingline, red, green, blue, 0.5);
		cairo_set_line_width (drawingline, 10.0);
		cairo_move_to (drawingline, xold, yold);
		cairo_line_to (drawingline, event->x, event->y);
		cairo_stroke (drawingline);
		end_paint(drawingline);
		xold=event->x;
		yold=event->y;
	}
	return TRUE;
}

static gboolean
gamine_on_key_press (GtkWidget        *       pWidget,
	GdkEventKey* pKey,
	gpointer             da)
{
        if (pKey->type == GDK_KEY_PRESS)
        {
                switch (pKey->keyval)
                {
                        case GDK_Escape :
                                gtk_main_quit ();
                        break;
			case GDK_space :
				gtk_widget_queue_draw(da);
			break;
                }
        }

        return FALSE;
}

static void
display_help (GtkWidget      *widget,
       GdkEventExpose *eev,
       gpointer        data)
{
	gint height;
	cairo_t *cr;
	height = widget->allocation.height - 5;
	cr = gdk_cairo_create (widget->window);
	cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_NORMAL,
		CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (cr, 15);
	cairo_move_to (cr, 0, height);
	cairo_set_source_rgb (cr, 0,0,0);
	cairo_show_text (cr, "Quit: esc | Clear: space");
	cairo_stroke (cr);
	cairo_destroy (cr);
}

static GtkWidget *
create_window (GstBus *bus)
{
	GtkWidget *window;
	GtkWidget *da;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), "Gamine");
	
	g_signal_connect (window, "destroy",
		G_CALLBACK (gtk_main_quit), &window);

	gtk_container_set_border_width (GTK_CONTAINER (window), 0);

/* Create the drawing area */

	da = gtk_drawing_area_new ();
	gtk_container_add (GTK_CONTAINER (window), da);

	
	g_signal_connect (G_OBJECT (da), "expose-event",
                    G_CALLBACK (display_help), NULL);

/* Event signals */
	g_signal_connect (da, "motion_notify_event",
		G_CALLBACK (gamine_motion_notify_event), bus);
	g_signal_connect (da, "button_press_event",
		G_CALLBACK (gamine_button_press_event), bus);
	g_signal_connect (window, "key-press-event",
		G_CALLBACK (gamine_on_key_press), da);
/* Ask to receive events the drawing area doesn't normally
*    * subscribe to
*    
   */
	gtk_widget_set_events (da, gtk_widget_get_events (da)
		| GDK_LEAVE_NOTIFY_MASK
		| GDK_BUTTON_PRESS_MASK
		| GDK_BUTTON_RELEASE_MASK
		| GDK_POINTER_MOTION_MASK
		| GDK_POINTER_MOTION_HINT_MASK);

	return da;
}

gint
main (gint argc, gchar *argv[])
{
	GtkWidget *drawing_area;
	GstBus *bus;
	gtk_init (&argc, &argv);
	gst_init (&argc, &argv);
	gst_play_background (bus, "BachJSBrandenburgConcertNo2inFMajorBWV1047mvmt1.ogg", TRUE);
	drawing_area = create_window (bus);
	gtk_widget_show_all (gtk_widget_get_toplevel (drawing_area));
	gtk_window_has_toplevel_focus (GTK_WINDOW(gtk_widget_get_toplevel (drawing_area)));
	gtk_window_present (GTK_WINDOW(gtk_widget_get_toplevel (drawing_area)));
	gtk_window_fullscreen (GTK_WINDOW(gtk_widget_get_toplevel (drawing_area)));
	gdk_window_raise (GDK_WINDOW(gtk_widget_get_toplevel (drawing_area)->window));
	gtk_main ();

	return 0;
}

