/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/




#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "populate_client_settings.h"
#include "apply_client_settings.h"
#include "delete_connection_clicked.h"

/* Wether or not to let the location section expand */
#define EXPAND_CONNECTION_SECTION FALSE

/* Wether or not to let the location settings section expand */
#define EXPAND_CONNECTION_SETTINGS_SECTION TRUE



void create_client_tab(struct w *widgets)
{
    GtkCellRenderer *connection_cell_renderer;
    GtkWidget *connection_treeview_hbox;
    GtkWidget *connection_scrolled_window;

    GtkWidget *settings_treeview_hbox;
    GtkWidget *frame;
    gchar *utf8=NULL;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    /* Create the connections treeview in a scrolled window */
    connection_treeview_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), connection_treeview_hbox, EXPAND_CONNECTION_SECTION, TRUE, 0);

    connection_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(connection_treeview_hbox), connection_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(connection_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(connection_scrolled_window, -1, 100);

    widgets->connection_store = gtk_list_store_new (1, G_TYPE_STRING); //, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->connection_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->connection_treeview), GTK_TREE_MODEL(widgets->connection_store));

    gtk_container_add(GTK_CONTAINER(connection_scrolled_window), widgets->connection_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->connection_treeview), TRUE);

    /* Set the column labels in the treeview */
    connection_cell_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *connection_name_col = gtk_tree_view_column_new_with_attributes(_("Connection name"), connection_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->connection_treeview), GTK_TREE_VIEW_COLUMN(connection_name_col));

    g_signal_connect((gpointer)widgets->connection_treeview, "button_press_event",
		      G_CALLBACK(connection_treeview_row_clicked), widgets);

    /* The add, delete and apply connection buttons */
    GtkWidget *connection_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), connection_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(connection_button_box), GTK_BUTTONBOX_SPREAD);

    /* The delete connection button */
    GtkWidget *delete_connection_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(connection_button_box), delete_connection_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(delete_connection_button), "clicked", 
                             G_CALLBACK(delete_connection_clicked), widgets);

    /* The add connection button */
    GtkWidget *add_connection_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(connection_button_box), add_connection_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_connection_button), "clicked", 
                             G_CALLBACK(add_connection), widgets);

    /* The apply connection button */
    GtkWidget *apply_connection_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(connection_button_box), apply_connection_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_connection_button), "clicked",
                             G_CALLBACK(apply_client_settings), widgets);



    /* Create the connection settings in a table inside a scrolled window */
    settings_treeview_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), settings_treeview_hbox, EXPAND_CONNECTION_SETTINGS_SECTION, TRUE, 0);

    widgets->connection_settings_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(settings_treeview_hbox), widgets->connection_settings_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(widgets->connection_settings_scrolled_window),
						    GTK_POLICY_NEVER,
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(widgets->connection_settings_scrolled_window, -1, 100);

    /* Add a vbox to the scrolled window */
    widgets->connection_settings_vbox = gtk_vbox_new(TRUE, 0);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(widgets->connection_settings_scrolled_window), widgets->connection_settings_vbox);


    /* Add a frame */
    frame = gtk_frame_new(""); //_("connection settings"));

    /* Add a table with for the settings with 3 columns */
    widgets->srv_set_table = gtk_table_new(NUM_SERVERTAB_ENTRIES+NUM_SERVERTAB_SPINBUTTONS+NUM_SERVERTAB_COMBOS, 3, FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->connection_settings_vbox), frame, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame), widgets->srv_set_table);


    gtk_widget_show_all(widgets->main_window);

    if( utf8 != NULL )
      g_free(utf8);
}
