
# .spec file for statically linked fwbuilder rpm for CentOS 5.2


%define name    fwbuilder
%define version 5.0.0.3568
%define release 1

%if "%_vendor" == "MandrakeSoft"
%define guigroup  System/Configuration/Networking
%define compgroup System/Configuration/Networking
%else
%define guigroup  Applications/System
%define compgroup Applications/System
%endif

Summary:        Firewall Builder
Name:           %{name}
Version:        %{version}
Release:        %{release}%{?dist}
License:        GPL2
Vendor:         NetCitadel LLC., http://sourceforge.net/project/showfiles.php?group_id=5314
Group:          %{guigroup}
Url:            http://www.fwbuilder.org/
Source:         http://prdownloads.sourceforge.net/fwbuilder/%{name}-%{version}.tar.gz
Packager:       Vadim Kurland <vadim@fwbuilder.org>

Buildroot:      %{_tmppath}/%{name}-%{version}-root

BuildRequires: libxml2-devel, libxslt-devel, openssl-devel

Obsoletes:     fwbuilder-ipt, fwbuilder-pf, fwbuilder-ipf, fwbuilder-ipfw, fwbuilder-pix, fwbuilder-iosacl, fwbuilder-cisco, libfwbuilder, libfwbuilder-devel

Docdir:         /usr/share/doc

%description
Firewall Builder consists of a GUI and set of policy compilers for
various firewall platforms. It helps users maintain a database of
objects and allows policy editing using simple drag-and-drop
operations. GUI generates firewall description in the form of XML
file, which compilers then interpret and generate platform-specific
code. Several algorithms are provided for automated network objects
discovery and bulk import of data. The GUI and policy compilers are
completely independent, this provides for a consistent abstract model
and the same GUI for different firewall platforms. 

%prep
%setup
./autogen.sh

%build
%configure --with-qtdir=/opt/qt44
make -j5 all

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make INSTALL_ROOT="${RPM_BUILD_ROOT}/" install
rm -fr $RPM_BUILD_ROOT/usr/share/doc/%{name}-%{version}

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%dir /usr/share/fwbuilder-%version
/usr/share/fwbuilder-%version
/usr/bin/fwbuilder
/usr/bin/fwbedit
/usr/bin/fwb_iosacl
/usr/bin/fwb_ipf
/usr/bin/fwb_ipfw
/usr/bin/fwb_ipt
/usr/bin/fwb_pf
/usr/bin/fwb_pix
/usr/bin/fwb_procurve_acl
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/ChangeLog
%doc doc/PatchAcceptancePolicy.txt
%doc doc/README.floppyfw
%doc doc/README.iosacl
%doc doc/README.ipf
%doc doc/README.ipfw
%doc doc/README.ipt
%doc doc/README.pf
%doc doc/README.pix
%doc doc/README.pix_routing
%doc doc/README.routing
%doc doc/README.policy_import
%doc doc/README.iosacl
%doc doc/FWBuilder-Routing-LICENSE.txt
%{_mandir}/man1/fwbuilder.1*
%{_mandir}/man1/fwbedit.1*
%{_mandir}/man1/fwb_iosacl.1*
%{_mandir}/man1/fwb_ipf.1*
%{_mandir}/man1/fwb_ipfw.1*
%{_mandir}/man1/fwb_ipt.1*
%{_mandir}/man1/fwb_pf.1*
%{_mandir}/man1/fwb_pix.1*
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/*/apps/%name.png

