/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: RuleOptionsDialog.cpp,v 1.24 2007/07/14 21:08:42 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"

#include "RuleOptionsDialog.h"
#include "ObjectManipulator.h"
#include "RuleSetView.h"
#include "FWWindow.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Rule.h"
#include "fwbuilder/FWOptions.h"
#include "fwbuilder/Resources.h"
#include "fwbuilder/Rule.h"

#include <qwidgetstack.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qregexp.h>
#include <qlabel.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

RuleOptionsDialog::RuleOptionsDialog(QWidget *parent) : RuleOptionsDialog_q(parent)
{
    init=false;
}

void RuleOptionsDialog::loadFWObject(FWObject *o)
{
    obj=o;
//    rsv=rv;

    FWObject *p=obj;
    while ( !Firewall::isA(p) ) p=p->getParent();
    platform=p->getStr("platform").c_str();

    
    Rule      *rule = dynamic_cast<Rule*>(o);
    FWOptions *ropt = rule->getOptionsObject();
    
    editorTitle->setText(QString("%1 / %2 / %3 ")
            .arg(QString::fromUtf8(p->getName().c_str()))
            .arg(rule->getTypeName().c_str())
            .arg(rule->getPosition()));

    int wid=0;
    if (platform=="iptables") wid=0;
    if (platform=="ipf")      wid=1;
    if (platform=="pf")       wid=2;
    if (platform=="ipfw")     wid=3;
    if (platform=="pix" || platform=="fwsm")      wid=4;
    if (platform=="iosacl")   wid=5;

    wStack->raiseWidget( wid );
    wStack->widget(wid)->show();

    QStringList  logLevels=getLogLevels( obj->getStr("platform").c_str() );
    ipt_logLevel->clear();
    ipt_logLevel->insertStringList(getScreenNames(logLevels));
    ipf_logLevel->clear();
    ipf_logLevel->insertStringList(getScreenNames(logLevels));
    pix_logLevel->clear();
    pix_logLevel->insertStringList(getScreenNames(logLevels));

    QStringList  logFacilities=getLogFacilities( obj->getStr("platform").c_str() );
    ipf_logFacility->clear();
    ipf_logFacility->insertStringList(getScreenNames(logFacilities));    
    QStringList limitSuffixes=getLimitSuffixes( obj->getStr("platform").c_str() );
    ipt_limitSuffix->clear();
    ipt_limitSuffix->insertStringList(getScreenNames(limitSuffixes));
    
    
    data.clear();
    
    if (platform=="iptables")
    {
        data.registerOption( ipt_logPrefix            , ropt,  "log_prefix" );
        data.registerOption( ipt_logLevel             , ropt,  "log_level", logLevels );
        data.registerOption( ipt_nlgroup              , ropt,  "ulog_nlgroup" );
        data.registerOption( ipt_limit                , ropt,  "limit_value" );
        data.registerOption( ipt_limitSuffix          , ropt,  "limit_suffix", limitSuffixes);
        data.registerOption( ipt_burst                , ropt,  "limit_burst" );

        data.registerOption( ipt_connlimit            , ropt,  "connlimit_value" );
        data.registerOption( ipt_connlimit_masklen    , ropt,  "connlimit_masklen" );

        data.registerOption( ipt_hashlimit            , ropt,  "hashlimit_value" );
        data.registerOption( ipt_hashlimit_suffix     , ropt,  "hashlimit_suffix" );
        data.registerOption( ipt_hashlimit_burst      , ropt,  "hashlimit_burst" );
        data.registerOption( ipt_hashlimit_mode       , ropt,  "hashlimit_mode" );
        data.registerOption( ipt_hashlimit_dstlimit   , ropt,  "hashlimit_dstlimit");
        data.registerOption( ipt_hashlimit_name       , ropt,  "hashlimit_name");
        data.registerOption( ipt_hashlimit_size       , ropt,  "hashlimit_size");
        data.registerOption( ipt_hashlimit_max        , ropt,  "hashlimit_max");
        data.registerOption( ipt_hashlimit_expire     , ropt,  "hashlimit_expire");
        data.registerOption( ipt_hashlimit_gcinterval , ropt,  "hashlimit_gcinterval");

        data.registerOption( ipt_assumeFwIsPartOfAny  , ropt,  "firewall_is_part_of_any_and_networks" );
        data.registerOption( ipt_stateless            , ropt,  "stateless" );
    }


    if (platform=="ipf")
    {
        data.registerOption( ipf_logFacility     , ropt,  "ipf_log_facility", logFacilities);
        data.registerOption( ipf_logLevel        , ropt,  "log_level" , logLevels);
        data.registerOption( ipf_masq_icmp       , ropt,  "ipf_return_icmp_as_dest");
        data.registerOption( ipf_stateless       , ropt,  "stateless" );
        data.registerOption( ipf_keep_frags      , ropt,  "ipf_keep_frags" );
    }

    if (platform=="pf")
    {
        data.registerOption( pf_logPrefix        , ropt,  "log_prefix" );
        data.registerOption( pf_stateless        , ropt,  "stateless" );
        data.registerOption( pf_keep_state       , ropt,  "pf_keep_state" );
        data.registerOption( pf_rule_max_state   , ropt,  "pf_rule_max_state" );
        data.registerOption( pf_source_tracking  , ropt,  "pf_source_tracking" );
        data.registerOption( pf_max_src_nodes    , ropt,  "pf_max_src_nodes" );
        data.registerOption( pf_max_src_states   , ropt,  "pf_max_src_states" );

        data.registerOption( pf_max_src_conn     , ropt,  "pf_max_src_conn" );
        data.registerOption( pf_max_src_conn_overload_table     ,
                             ropt,  "pf_max_src_conn_overload_table" );
        data.registerOption( pf_max_src_conn_flush, ropt,  "pf_max_src_conn_flush" );
        data.registerOption( pf_max_src_conn_global, ropt, "pf_max_src_conn_global" );

        data.registerOption( pf_max_src_conn_rate_num     , ropt,  "pf_max_src_conn_rate_num" );
        data.registerOption( pf_max_src_conn_rate_seconds , ropt,  "pf_max_src_conn_rate_seconds" );
        data.registerOption( pf_max_src_conn_rate_overload_table     ,
                             ropt,  "pf_max_src_conn_rate_overload_table" );
        data.registerOption( pf_max_src_conn_rate_flush, ropt,  "pf_max_src_conn_rate_flush" );
        data.registerOption( pf_max_src_conn_rate_global, ropt, "pf_max_src_conn_rate_global" );
    }

    if (platform=="ipfw")
    {
        data.registerOption( ipfw_stateless      , ropt,"stateless" );
    }

    if (platform=="pix" || platform=="fwsm")
    {
        string vers="version_"+p->getStr("version");
        if ( Resources::platform_res[platform.ascii()]->getResourceBool(
              "/FWBuilderResources/Target/options/"+vers+"/pix_rule_syslog_settings"))
        {
            pix_disable_rule_log->setEnabled(true);
            pix_logLevel->setEnabled(true);
            pix_log_interval->setEnabled(true);

            data.registerOption( pix_disable_rule_log, ropt,"disable_logging_for_this_rule" );
            data.registerOption( pix_logLevel        , ropt,"log_level" ,logLevels);
            data.registerOption( pix_log_interval    , ropt,"log_interval" );
        } else
        {
            pix_disable_rule_log->setEnabled(false);
            pix_logLevel->setEnabled(false);
            pix_log_interval->setEnabled(false);
        }

    }

    init=true;
    data.loadAll();

    pf_max_src_nodes->setEnabled( pf_source_tracking->isChecked() );
    pf_max_src_states->setEnabled( pf_source_tracking->isChecked() );

    //apply->setEnabled( false );
    init=false;
}
    
void RuleOptionsDialog::changed()
{
    //apply->setEnabled( true );

    pf_max_src_nodes->setEnabled( pf_source_tracking->isChecked() );
    pf_max_src_states->setEnabled( pf_source_tracking->isChecked() );

    pf_max_src_conn_overload_table->setEnabled( pf_max_src_conn->value()>0 );
    pf_max_src_conn_flush->setEnabled( pf_max_src_conn->value()>0 );
    pf_max_src_conn_global->setEnabled( pf_max_src_conn->value()>0 );

    pf_max_src_conn_rate_overload_table->setEnabled( pf_max_src_conn_rate_num->value()>0 && pf_max_src_conn_rate_seconds->value()>0);
    pf_max_src_conn_rate_flush->setEnabled( pf_max_src_conn_rate_num->value()>0 && pf_max_src_conn_rate_seconds->value()>0 );
    pf_max_src_conn_rate_global->setEnabled( pf_max_src_conn_rate_num->value()>0 && pf_max_src_conn_rate_seconds->value()>0 );

    emit changed_sign();
}

void RuleOptionsDialog::validate(bool *res)
{
    *res=true;
}

void RuleOptionsDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void RuleOptionsDialog::libChanged()
{
    changed();
}

void RuleOptionsDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;

    init=true;
    data.saveAll();
    init=false;

    mw->updateRuleOptions();

    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void RuleOptionsDialog::cancelChanges()
{
    //apply->setEnabled( false );
    close();
}

void RuleOptionsDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void RuleOptionsDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

