'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) labeledwidget.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS labeledwidget iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
labeledwidget \- Create and manipulate a labeled widget
.SH SYNOPSIS
\fBlabeledwidget\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- labeledwidget
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBdisabledForeground\fR
Class:	\fBDisabledForeground\fR
Command-Line Switch:	\fB-disabledforeground\fR
.fi
.IP
Specifies the foreground to be used when the state is disabled. 
.LP
.nf
Name:	\fBlabelBitmap\fR
Class:	\fBBitmap\fR
Command-Line Switch:	\fB-labelbitmap\fR
.fi
.IP
Specifies a bitmap to display in the widget, in any of the forms 
acceptable to \fBTk_GetBitmap\fR.  This option overrides the \fIlabeltext\fR
option.
.LP
.nf
Name:	\fBlabelFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-labelfont\fR
.fi
.IP
Specifies the font to be used for the label.
.LP
.nf
Name:	\fBlabelImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-labelimage\fR
.fi
.IP
Specifies a image to be used as the label. The image may be any of the
values created by the \fBimage create\fR command.  This option overrides
both the \fIlabelbitmap\fR and \fIlabeletext\fR options.
.LP
.nf
Name:	\fBlabelMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-labelmargin\fR
.fi
.IP
Specifies the distance between the childsite and label in any of the forms
acceptable to \fBTk_GetPixels\fR.  The default is 2 pixel.
.LP
.nf
Name:	\fBlabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-labelpos\fR
.fi
.IP
Specifies the position of the label along the side of the childsite: 
\fBnw\fR, \fBn\fR, \fBne\fR, \fBsw\fR, \fBs\fR, \fBse\fR, \fBen\fR, \fBe\fR, 
\fBes\fR, \fBwn\fR, \fBw\fR, or \fBws\fR.  The default is w.
.LP
.nf
Name:	\fBlabelText\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-labeltext\fR
.fi
.IP
Specifies the text of the label around the childsite.
.LP
.nf
Name:	\fBlabelVariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB-labelvariable\fR
.fi
.IP
Specifies the text variable of the label around the childsite.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB-state\fR
.fi
.IP
Specifies one of two states for the label: \fBnormal\fR or \fBdisabled\fR.
If the label is disabled then it is displayed in a disabled foreground
color.  The default is normal.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBlabeledwidget\fR command creates a labeled widget which contains 
a label and child site.  The child site is a frame 
which can filled with any widget via a derived class or though the use 
of the childsite method.  This class
was designed to be a general purpose base class for supporting the 
combination of label widget and a childsite.  The options include the
ability to position the label around the childsite widget, modify the
font and margin, and control the display of the labels.

.SH "METHODS"
.PP
The \fBlabeledwidget\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for labeledwidget widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBchildsite\fR
Return the path name of the child site.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBlabeledwidget\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBlabeledwidget\fR
command.

.SH "STATIC METHODS"
.TP
\fBLabeledwidget::alignlabels\fR \fIwidget\fR ?\fIwidget ...\fR?
The alignlabels procedure takes a list of widgets derived from
the Labeledwidget class and uses the label margin to make each widget
have the same total space for the combination of label and margin.  The
net effect is to left align the labels.  Generally, this method is only 
useful with a label position of w, which is the default.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBlabel\fR
.fi
.IP
The label component provides the label for the labeled widget.  See the 
"label" widget manual entry for details on the label component item.
.LP
.nf
Name:	\fBlwchildsite\fR
Class:	\fBframe\fR
.fi
.IP
The lwchildsite component is the user child site for the labeled widget.  See 
the "frame" widget manual entry for details on the lwchildsite component item.
.fi

.SH EXAMPLE
.IP
The labeledwidget was primarily meant to be a base class.  The
ScrolledListBox and EntryField are good examples of derived
classes of the labeledwidget class.  In order to provide equal
support for composite classes, the 'childsite' methods also exists.
The following is an example of 'childsite' method usage.
.LP
.DS
 labeledwidget .lw -labeltext "Canvas Widget" -labelpos s
 pack .lw -fill both -expand yes -padx 10 -pady 10

 set cw [canvas [.lw childsite].c -relief raised -width 200 -height 200]
 pack $cw -padx 10 -pady 10
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
labeledwidget, widget
