/*
 *
 * Copyright (c) 2003 The Regents of the University of California.  All 
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Neither the name of the University nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "fusd.h"

int do_open(struct fusd_file_info *file)
{
  char buf[128];
  int ret = 1;

  do {
    printf("Got an open or close request from pid %d.  What do we say? (must be negative or 0)\n> ",
	   file->pid);
    fflush(stdout);
    if (fgets(buf, 128, stdin))
      ret = atoi(buf);
    else
      ret = 1;
  } while ((*buf != '-' && !isdigit(*buf)) || ret > 0);

  printf("returning %d...\n\n\n\n", ret);
  return ret;
}

int do_close(struct fusd_file_info *file)
{
  printf("got a close request from pid %d.  Sending 0.\n", file->pid);
  return 0;
}


ssize_t do_read(struct fusd_file_info *file, char *buffer, size_t length,
	     loff_t *offset)
{
  char *message = "This is a great test!\n";

  printf("got read request for %d bytes, replying...\n", length);

  if (length > strlen(message)) length = strlen(message);
  memcpy(buffer, message, length);
  return length;
}

ssize_t do_write(struct fusd_file_info *file, const char *buffer,
		 size_t len, loff_t *offset)
{
  char *buf = malloc(len+1);
  memcpy(buf, buffer, len);
  buf[len] = '\0';
  printf("Got from pid %d: '%s'\n", file->pid, buf);
  return len;
}



int main(int argc, char *argv[])
{
  int fd;
  struct fusd_file_operations f = { open: do_open, close: do_close,
				    read: do_read, write: do_write };

  fd = fusd_register("/dev/open", "misc", "open", 0666, NULL, &f);

  if (fd < 0) {
    perror("trying to register /dev/open");
    return 0;
  }

  printf("registered /dev/open on fd %d\n", fd);
  fusd_run();
  return 0;
}
