#! /usr/bin/python

import fcntl

def build(direction, type, nr, size):
    dr = {"none": 0, "write": 1, "read": 2, "readwrite": 3}[direction]
    n = (((nr & 0xff) << 0) |
         ((type & 0xff) << 8) |
         ((size & 0x3fff) << 16) |
         (dr << 30))
    return n
def write(f, type, number, data):
    n = build("write", type, number, len(data))
    return fcntl.ioctl(f, n, data)
def do(f, type, number, value):
    n = build("none", type, number, 0)
    return fcntl.ioctl(f, n, value)
def read(f, type, number, len):
    n = build("read", type, number, len)
    return fcntl.ioctl(f, n, "x" * len)
def readwrite(f, type, number, data):
    n = build("readwrite", type, number, len(data))
    return fcntl.ioctl(f, n, data)
    

f = open("/dev/python", "r")

print do(f, 0x12, 0x45, 67)
print write(f, 0x12, 0x45, "some more data")
print read(f, 0x12, 0x45, 5)
print readwrite(f, 0x12, 0x45, "readwrite data")

