# This file is part of the Frescobaldi project, http://www.frescobaldi.org/
#
# Copyright (c) 2008, 2009, 2010 by Wilbert Berendsen
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# See http://www.gnu.org/licenses/ for more information.

from __future__ import unicode_literals

"""
LilyPond named colors, taken from LilyPond source files
"""

colors_predefined = (
    # name, (r, g, b)
    ('black',       (0.0, 0.0, 0.0)),
    ('white',       (1.0, 1.0, 1.0)),
    ('red',         (1.0, 0.0, 0.0)),
    ('green',       (0.0, 1.0, 0.0)),
    ('blue',        (0.0, 0.0, 1.0)),
    ('cyan',        (0.0, 1.0, 1.0)),
    ('magenta',     (1.0, 0.0, 1.0)),
    ('yellow',      (1.0, 1.0, 0.0)),
    ('grey',        (0.5, 0.5, 0.5)),
    ('darkred',     (0.5, 0.0, 0.0)),
    ('darkgreen',   (0.0, 0.5, 0.0)),
    ('darkblue',    (0.0, 0.0, 0.5)),
    ('darkcyan',    (0.0, 0.5, 0.5)),
    ('darkmagenta', (0.5, 0.0, 0.5)),
    ('darkyellow',  (0.5, 0.5, 0.0)),
)


colors_x11 = (
    # name, (r, g, b)
    ("snow",                 (1.00000000, 0.98039216, 0.98039216)),               
    ("GhostWhite",           (0.97254902, 0.97254902, 1.00000000)),               
    ("WhiteSmoke",           (0.96078431, 0.96078431, 0.96078431)),               
    ("gainsboro",            (0.86274510, 0.86274510, 0.86274510)),               
    ("FloralWhite",          (1.00000000, 0.98039216, 0.94117647)),               
    ("OldLace",              (0.99215686, 0.96078431, 0.90196078)),               
    ("linen",                (0.98039216, 0.94117647, 0.90196078)),               
    ("AntiqueWhite",         (0.98039216, 0.92156863, 0.84313725)),               
    ("PapayaWhip",           (1.00000000, 0.93725490, 0.83529412)),               
    ("BlanchedAlmond",       (1.00000000, 0.92156863, 0.80392157)),               
    ("bisque",               (1.00000000, 0.89411765, 0.76862745)),               
    ("PeachPuff",            (1.00000000, 0.85490196, 0.72549020)),               
    ("NavajoWhite",          (1.00000000, 0.87058824, 0.67843137)),               
    ("moccasin",             (1.00000000, 0.89411765, 0.70980392)),               
    ("cornsilk",             (1.00000000, 0.97254902, 0.86274510)),               
    ("ivory",                (1.00000000, 1.00000000, 0.94117647)),               
    ("LemonChiffon",         (1.00000000, 0.98039216, 0.80392157)),               
    ("seashell",             (1.00000000, 0.96078431, 0.93333333)),               
    ("honeydew",             (0.94117647, 1.00000000, 0.94117647)),               
    ("MintCream",            (0.96078431, 1.00000000, 0.98039216)),               
    ("azure",                (0.94117647, 1.00000000, 1.00000000)),               
    ("AliceBlue",            (0.94117647, 0.97254902, 1.00000000)),               
    ("lavender",             (0.90196078, 0.90196078, 0.98039216)),               
    ("LavenderBlush",        (1.00000000, 0.94117647, 0.96078431)),               
    ("MistyRose",            (1.00000000, 0.89411765, 0.88235294)),               
    ("white",                (1.00000000, 1.00000000, 1.00000000)),               
    ("black",                (0.00000000, 0.00000000, 0.00000000)),               
    ("DarkSlateGray",        (0.18431373, 0.30980392, 0.30980392)),               
    ("DarkSlateGrey",        (0.18431373, 0.30980392, 0.30980392)),               
    ("DimGray",              (0.41176471, 0.41176471, 0.41176471)),               
    ("DimGrey",              (0.41176471, 0.41176471, 0.41176471)),               
    ("SlateGray",            (0.43921569, 0.50196078, 0.56470588)),               
    ("SlateGrey",            (0.43921569, 0.50196078, 0.56470588)),               
    ("LightSlateGray",       (0.46666667, 0.53333333, 0.60000000)),               
    ("LightSlateGrey",       (0.46666667, 0.53333333, 0.60000000)),               
    ("gray",                 (0.74509804, 0.74509804, 0.74509804)),               
    ("grey",                 (0.74509804, 0.74509804, 0.74509804)),               
    ("LightGrey",            (0.82745098, 0.82745098, 0.82745098)),               
    ("LightGray",            (0.82745098, 0.82745098, 0.82745098)),               
    ("MidnightBlue",         (0.09803922, 0.09803922, 0.43921569)),               
    ("navy",                 (0.00000000, 0.00000000, 0.50196078)),               
    ("NavyBlue",             (0.00000000, 0.00000000, 0.50196078)),               
    ("CornflowerBlue",       (0.39215686, 0.58431373, 0.92941176)),               
    ("DarkSlateBlue",        (0.28235294, 0.23921569, 0.54509804)),               
    ("SlateBlue",            (0.41568627, 0.35294118, 0.80392157)),               
    ("MediumSlateBlue",      (0.48235294, 0.40784314, 0.93333333)),               
    ("LightSlateBlue",       (0.51764706, 0.43921569, 1.00000000)),               
    ("MediumBlue",           (0.00000000, 0.00000000, 0.80392157)),               
    ("RoyalBlue",            (0.25490196, 0.41176471, 0.88235294)),               
    ("blue",                 (0.00000000, 0.00000000, 1.00000000)),               
    ("DodgerBlue",           (0.11764706, 0.56470588, 1.00000000)),               
    ("DeepSkyBlue",          (0.00000000, 0.74901961, 1.00000000)),               
    ("SkyBlue",              (0.52941176, 0.80784314, 0.92156863)),               
    ("LightSkyBlue",         (0.52941176, 0.80784314, 0.98039216)),               
    ("SteelBlue",            (0.27450980, 0.50980392, 0.70588235)),               
    ("LightSteelBlue",       (0.69019608, 0.76862745, 0.87058824)),               
    ("LightBlue",            (0.67843137, 0.84705882, 0.90196078)),               
    ("PowderBlue",           (0.69019608, 0.87843137, 0.90196078)),               
    ("PaleTurquoise",        (0.68627451, 0.93333333, 0.93333333)),               
    ("DarkTurquoise",        (0.00000000, 0.80784314, 0.81960784)),               
    ("MediumTurquoise",      (0.28235294, 0.81960784, 0.80000000)),               
    ("turquoise",            (0.25098039, 0.87843137, 0.81568627)),               
    ("cyan",                 (0.00000000, 1.00000000, 1.00000000)),               
    ("LightCyan",            (0.87843137, 1.00000000, 1.00000000)),               
    ("CadetBlue",            (0.37254902, 0.61960784, 0.62745098)),               
    ("MediumAquamarine",     (0.40000000, 0.80392157, 0.66666667)),               
    ("aquamarine",           (0.49803922, 1.00000000, 0.83137255)),               
    ("DarkGreen",            (0.00000000, 0.39215686, 0.00000000)),               
    ("DarkOliveGreen",       (0.33333333, 0.41960784, 0.18431373)),               
    ("DarkSeaGreen",         (0.56078431, 0.73725490, 0.56078431)),               
    ("SeaGreen",             (0.18039216, 0.54509804, 0.34117647)),               
    ("MediumSeaGreen",       (0.23529412, 0.70196078, 0.44313725)),               
    ("LightSeaGreen",        (0.12549020, 0.69803922, 0.66666667)),               
    ("PaleGreen",            (0.59607843, 0.98431373, 0.59607843)),               
    ("SpringGreen",          (0.00000000, 1.00000000, 0.49803922)),               
    ("LawnGreen",            (0.48627451, 0.98823529, 0.00000000)),               
    ("green",                (0.00000000, 1.00000000, 0.00000000)),               
    ("chartreuse",           (0.49803922, 1.00000000, 0.00000000)),               
    ("MediumSpringGreen",    (0.00000000, 0.98039216, 0.60392157)),               
    ("GreenYellow",          (0.67843137, 1.00000000, 0.18431373)),               
    ("LimeGreen",            (0.19607843, 0.80392157, 0.19607843)),               
    ("YellowGreen",          (0.60392157, 0.80392157, 0.19607843)),               
    ("ForestGreen",          (0.13333333, 0.54509804, 0.13333333)),               
    ("OliveDrab",            (0.41960784, 0.55686275, 0.13725490)),               
    ("DarkKhaki",            (0.74117647, 0.71764706, 0.41960784)),               
    ("khaki",                (0.94117647, 0.90196078, 0.54901961)),               
    ("PaleGoldenrod",        (0.93333333, 0.90980392, 0.66666667)),               
    ("LightGoldenrodYellow", (0.98039216, 0.98039216, 0.82352941)),               
    ("LightYellow",          (1.00000000, 1.00000000, 0.87843137)),               
    ("yellow",               (1.00000000, 1.00000000, 0.00000000)),               
    ("gold",                 (1.00000000, 0.84313725, 0.00000000)),               
    ("LightGoldenrod",       (0.93333333, 0.86666667, 0.50980392)),               
    ("goldenrod",            (0.85490196, 0.64705882, 0.12549020)),               
    ("DarkGoldenrod",        (0.72156863, 0.52549020, 0.04313725)),               
    ("RosyBrown",            (0.73725490, 0.56078431, 0.56078431)),               
    ("IndianRed",            (0.80392157, 0.36078431, 0.36078431)),               
    ("SaddleBrown",          (0.54509804, 0.27058824, 0.07450980)),               
    ("sienna",               (0.62745098, 0.32156863, 0.17647059)),               
    ("peru",                 (0.80392157, 0.52156863, 0.24705882)),               
    ("burlywood",            (0.87058824, 0.72156863, 0.52941176)),               
    ("beige",                (0.96078431, 0.96078431, 0.86274510)),               
    ("wheat",                (0.96078431, 0.87058824, 0.70196078)),               
    ("SandyBrown",           (0.95686275, 0.64313725, 0.37647059)),               
    ("tan",                  (0.82352941, 0.70588235, 0.54901961)),               
    ("chocolate",            (0.82352941, 0.41176471, 0.11764706)),               
    ("firebrick",            (0.69803922, 0.13333333, 0.13333333)),               
    ("brown",                (0.64705882, 0.16470588, 0.16470588)),               
    ("DarkSalmon",           (0.91372549, 0.58823529, 0.47843137)),               
    ("salmon",               (0.98039216, 0.50196078, 0.44705882)),               
    ("LightSalmon",          (1.00000000, 0.62745098, 0.47843137)),               
    ("orange",               (1.00000000, 0.64705882, 0.00000000)),               
    ("DarkOrange",           (1.00000000, 0.54901961, 0.00000000)),               
    ("coral",                (1.00000000, 0.49803922, 0.31372549)),               
    ("LightCoral",           (0.94117647, 0.50196078, 0.50196078)),               
    ("tomato",               (1.00000000, 0.38823529, 0.27843137)),               
    ("OrangeRed",            (1.00000000, 0.27058824, 0.00000000)),               
    ("red",                  (1.00000000, 0.00000000, 0.00000000)),               
    ("HotPink",              (1.00000000, 0.41176471, 0.70588235)),               
    ("DeepPink",             (1.00000000, 0.07843137, 0.57647059)),               
    ("pink",                 (1.00000000, 0.75294118, 0.79607843)),               
    ("LightPink",            (1.00000000, 0.71372549, 0.75686275)),               
    ("PaleVioletRed",        (0.85882353, 0.43921569, 0.57647059)),               
    ("maroon",               (0.69019608, 0.18823529, 0.37647059)),               
    ("MediumVioletRed",      (0.78039216, 0.08235294, 0.52156863)),               
    ("VioletRed",            (0.81568627, 0.12549020, 0.56470588)),               
    ("magenta",              (1.00000000, 0.00000000, 1.00000000)),               
    ("violet",               (0.93333333, 0.50980392, 0.93333333)),               
    ("plum",                 (0.86666667, 0.62745098, 0.86666667)),               
    ("orchid",               (0.85490196, 0.43921569, 0.83921569)),               
    ("MediumOrchid",         (0.72941176, 0.33333333, 0.82745098)),               
    ("DarkOrchid",           (0.60000000, 0.19607843, 0.80000000)),               
    ("DarkViolet",           (0.58039216, 0.00000000, 0.82745098)),               
    ("BlueViolet",           (0.54117647, 0.16862745, 0.88627451)),               
    ("purple",               (0.62745098, 0.12549020, 0.94117647)),               
    ("MediumPurple",         (0.57647059, 0.43921569, 0.85882353)),               
    ("thistle",              (0.84705882, 0.74901961, 0.84705882)),               
    ("snow1",                (1.00000000, 0.98039216, 0.98039216)),               
    ("snow2",                (0.93333333, 0.91372549, 0.91372549)),               
    ("snow3",                (0.80392157, 0.78823529, 0.78823529)),               
    ("snow4",                (0.54509804, 0.53725490, 0.53725490)),               
    ("seashell1",            (1.00000000, 0.96078431, 0.93333333)),               
    ("seashell2",            (0.93333333, 0.89803922, 0.87058824)),               
    ("seashell3",            (0.80392157, 0.77254902, 0.74901961)),               
    ("seashell4",            (0.54509804, 0.52549020, 0.50980392)),               
    ("AntiqueWhite1",        (1.00000000, 0.93725490, 0.85882353)),               
    ("AntiqueWhite2",        (0.93333333, 0.87450980, 0.80000000)),               
    ("AntiqueWhite3",        (0.80392157, 0.75294118, 0.69019608)),               
    ("AntiqueWhite4",        (0.54509804, 0.51372549, 0.47058824)),               
    ("bisque1",              (1.00000000, 0.89411765, 0.76862745)),               
    ("bisque2",              (0.93333333, 0.83529412, 0.71764706)),               
    ("bisque3",              (0.80392157, 0.71764706, 0.61960784)),               
    ("bisque4",              (0.54509804, 0.49019608, 0.41960784)),               
    ("PeachPuff1",           (1.00000000, 0.85490196, 0.72549020)),               
    ("PeachPuff2",           (0.93333333, 0.79607843, 0.67843137)),               
    ("PeachPuff3",           (0.80392157, 0.68627451, 0.58431373)),               
    ("PeachPuff4",           (0.54509804, 0.46666667, 0.39607843)),               
    ("NavajoWhite1",         (1.00000000, 0.87058824, 0.67843137)),               
    ("NavajoWhite2",         (0.93333333, 0.81176471, 0.63137255)),               
    ("NavajoWhite3",         (0.80392157, 0.70196078, 0.54509804)),               
    ("NavajoWhite4",         (0.54509804, 0.47450980, 0.36862745)),               
    ("LemonChiffon1",        (1.00000000, 0.98039216, 0.80392157)),               
    ("LemonChiffon2",        (0.93333333, 0.91372549, 0.74901961)),               
    ("LemonChiffon3",        (0.80392157, 0.78823529, 0.64705882)),               
    ("LemonChiffon4",        (0.54509804, 0.53725490, 0.43921569)),               
    ("cornsilk1",            (1.00000000, 0.97254902, 0.86274510)),               
    ("cornsilk2",            (0.93333333, 0.90980392, 0.80392157)),               
    ("cornsilk3",            (0.80392157, 0.78431373, 0.69411765)),               
    ("cornsilk4",            (0.54509804, 0.53333333, 0.47058824)),               
    ("ivory1",               (1.00000000, 1.00000000, 0.94117647)),               
    ("ivory2",               (0.93333333, 0.93333333, 0.87843137)),               
    ("ivory3",               (0.80392157, 0.80392157, 0.75686275)),               
    ("ivory4",               (0.54509804, 0.54509804, 0.51372549)),               
    ("honeydew1",            (0.94117647, 1.00000000, 0.94117647)),               
    ("honeydew2",            (0.87843137, 0.93333333, 0.87843137)),               
    ("honeydew3",            (0.75686275, 0.80392157, 0.75686275)),               
    ("honeydew4",            (0.51372549, 0.54509804, 0.51372549)),               
    ("LavenderBlush1",       (1.00000000, 0.94117647, 0.96078431)),               
    ("LavenderBlush2",       (0.93333333, 0.87843137, 0.89803922)),               
    ("LavenderBlush3",       (0.80392157, 0.75686275, 0.77254902)),               
    ("LavenderBlush4",       (0.54509804, 0.51372549, 0.52549020)),               
    ("MistyRose1",           (1.00000000, 0.89411765, 0.88235294)),               
    ("MistyRose2",           (0.93333333, 0.83529412, 0.82352941)),               
    ("MistyRose3",           (0.80392157, 0.71764706, 0.70980392)),               
    ("MistyRose4",           (0.54509804, 0.49019608, 0.48235294)),               
    ("azure1",               (0.94117647, 1.00000000, 1.00000000)),               
    ("azure2",               (0.87843137, 0.93333333, 0.93333333)),               
    ("azure3",               (0.75686275, 0.80392157, 0.80392157)),               
    ("azure4",               (0.51372549, 0.54509804, 0.54509804)),               
    ("SlateBlue1",           (0.51372549, 0.43529412, 1.00000000)),               
    ("SlateBlue2",           (0.47843137, 0.40392157, 0.93333333)),               
    ("SlateBlue3",           (0.41176471, 0.34901961, 0.80392157)),               
    ("SlateBlue4",           (0.27843137, 0.23529412, 0.54509804)),               
    ("RoyalBlue1",           (0.28235294, 0.46274510, 1.00000000)),               
    ("RoyalBlue2",           (0.26274510, 0.43137255, 0.93333333)),               
    ("RoyalBlue3",           (0.22745098, 0.37254902, 0.80392157)),               
    ("RoyalBlue4",           (0.15294118, 0.25098039, 0.54509804)),               
    ("blue1",                (0.00000000, 0.00000000, 1.00000000)),               
    ("blue2",                (0.00000000, 0.00000000, 0.93333333)),               
    ("blue3",                (0.00000000, 0.00000000, 0.80392157)),               
    ("blue4",                (0.00000000, 0.00000000, 0.54509804)),               
    ("DodgerBlue1",          (0.11764706, 0.56470588, 1.00000000)),               
    ("DodgerBlue2",          (0.10980392, 0.52549020, 0.93333333)),               
    ("DodgerBlue3",          (0.09411765, 0.45490196, 0.80392157)),               
    ("DodgerBlue4",          (0.06274510, 0.30588235, 0.54509804)),               
    ("SteelBlue1",           (0.38823529, 0.72156863, 1.00000000)),               
    ("SteelBlue2",           (0.36078431, 0.67450980, 0.93333333)),               
    ("SteelBlue3",           (0.30980392, 0.58039216, 0.80392157)),               
    ("SteelBlue4",           (0.21176471, 0.39215686, 0.54509804)),               
    ("DeepSkyBlue1",         (0.00000000, 0.74901961, 1.00000000)),               
    ("DeepSkyBlue2",         (0.00000000, 0.69803922, 0.93333333)),               
    ("DeepSkyBlue3",         (0.00000000, 0.60392157, 0.80392157)),               
    ("DeepSkyBlue4",         (0.00000000, 0.40784314, 0.54509804)),               
    ("SkyBlue1",             (0.52941176, 0.80784314, 1.00000000)),               
    ("SkyBlue2",             (0.49411765, 0.75294118, 0.93333333)),               
    ("SkyBlue3",             (0.42352941, 0.65098039, 0.80392157)),               
    ("SkyBlue4",             (0.29019608, 0.43921569, 0.54509804)),               
    ("LightSkyBlue1",        (0.69019608, 0.88627451, 1.00000000)),               
    ("LightSkyBlue2",        (0.64313725, 0.82745098, 0.93333333)),               
    ("LightSkyBlue3",        (0.55294118, 0.71372549, 0.80392157)),               
    ("LightSkyBlue4",        (0.37647059, 0.48235294, 0.54509804)),               
    ("SlateGray1",           (0.77647059, 0.88627451, 1.00000000)),               
    ("SlateGray2",           (0.72549020, 0.82745098, 0.93333333)),               
    ("SlateGray3",           (0.62352941, 0.71372549, 0.80392157)),               
    ("SlateGray4",           (0.42352941, 0.48235294, 0.54509804)),               
    ("LightSteelBlue1",      (0.79215686, 0.88235294, 1.00000000)),               
    ("LightSteelBlue2",      (0.73725490, 0.82352941, 0.93333333)),               
    ("LightSteelBlue3",      (0.63529412, 0.70980392, 0.80392157)),               
    ("LightSteelBlue4",      (0.43137255, 0.48235294, 0.54509804)),               
    ("LightBlue1",           (0.74901961, 0.93725490, 1.00000000)),               
    ("LightBlue2",           (0.69803922, 0.87450980, 0.93333333)),               
    ("LightBlue3",           (0.60392157, 0.75294118, 0.80392157)),               
    ("LightBlue4",           (0.40784314, 0.51372549, 0.54509804)),               
    ("LightCyan1",           (0.87843137, 1.00000000, 1.00000000)),               
    ("LightCyan2",           (0.81960784, 0.93333333, 0.93333333)),               
    ("LightCyan3",           (0.70588235, 0.80392157, 0.80392157)),               
    ("LightCyan4",           (0.47843137, 0.54509804, 0.54509804)),               
    ("PaleTurquoise1",       (0.73333333, 1.00000000, 1.00000000)),               
    ("PaleTurquoise2",       (0.68235294, 0.93333333, 0.93333333)),               
    ("PaleTurquoise3",       (0.58823529, 0.80392157, 0.80392157)),               
    ("PaleTurquoise4",       (0.40000000, 0.54509804, 0.54509804)),               
    ("CadetBlue1",           (0.59607843, 0.96078431, 1.00000000)),               
    ("CadetBlue2",           (0.55686275, 0.89803922, 0.93333333)),               
    ("CadetBlue3",           (0.47843137, 0.77254902, 0.80392157)),               
    ("CadetBlue4",           (0.32549020, 0.52549020, 0.54509804)),               
    ("turquoise1",           (0.00000000, 0.96078431, 1.00000000)),               
    ("turquoise2",           (0.00000000, 0.89803922, 0.93333333)),               
    ("turquoise3",           (0.00000000, 0.77254902, 0.80392157)),               
    ("turquoise4",           (0.00000000, 0.52549020, 0.54509804)),               
    ("cyan1",                (0.00000000, 1.00000000, 1.00000000)),               
    ("cyan2",                (0.00000000, 0.93333333, 0.93333333)),               
    ("cyan3",                (0.00000000, 0.80392157, 0.80392157)),               
    ("cyan4",                (0.00000000, 0.54509804, 0.54509804)),               
    ("DarkSlateGray1",       (0.59215686, 1.00000000, 1.00000000)),               
    ("DarkSlateGray2",       (0.55294118, 0.93333333, 0.93333333)),               
    ("DarkSlateGray3",       (0.47450980, 0.80392157, 0.80392157)),               
    ("DarkSlateGray4",       (0.32156863, 0.54509804, 0.54509804)),               
    ("aquamarine1",          (0.49803922, 1.00000000, 0.83137255)),               
    ("aquamarine2",          (0.46274510, 0.93333333, 0.77647059)),               
    ("aquamarine3",          (0.40000000, 0.80392157, 0.66666667)),               
    ("aquamarine4",          (0.27058824, 0.54509804, 0.45490196)),               
    ("DarkSeaGreen1",        (0.75686275, 1.00000000, 0.75686275)),               
    ("DarkSeaGreen2",        (0.70588235, 0.93333333, 0.70588235)),               
    ("DarkSeaGreen3",        (0.60784314, 0.80392157, 0.60784314)),               
    ("DarkSeaGreen4",        (0.41176471, 0.54509804, 0.41176471)),               
    ("SeaGreen1",            (0.32941176, 1.00000000, 0.62352941)),               
    ("SeaGreen2",            (0.30588235, 0.93333333, 0.58039216)),               
    ("SeaGreen3",            (0.26274510, 0.80392157, 0.50196078)),               
    ("SeaGreen4",            (0.18039216, 0.54509804, 0.34117647)),               
    ("PaleGreen1",           (0.60392157, 1.00000000, 0.60392157)),               
    ("PaleGreen2",           (0.56470588, 0.93333333, 0.56470588)),               
    ("PaleGreen3",           (0.48627451, 0.80392157, 0.48627451)),               
    ("PaleGreen4",           (0.32941176, 0.54509804, 0.32941176)),               
    ("SpringGreen1",         (0.00000000, 1.00000000, 0.49803922)),               
    ("SpringGreen2",         (0.00000000, 0.93333333, 0.46274510)),               
    ("SpringGreen3",         (0.00000000, 0.80392157, 0.40000000)),               
    ("SpringGreen4",         (0.00000000, 0.54509804, 0.27058824)),               
    ("green1",               (0.00000000, 1.00000000, 0.00000000)),               
    ("green2",               (0.00000000, 0.93333333, 0.00000000)),               
    ("green3",               (0.00000000, 0.80392157, 0.00000000)),               
    ("green4",               (0.00000000, 0.54509804, 0.00000000)),               
    ("chartreuse1",          (0.49803922, 1.00000000, 0.00000000)),               
    ("chartreuse2",          (0.46274510, 0.93333333, 0.00000000)),               
    ("chartreuse3",          (0.40000000, 0.80392157, 0.00000000)),               
    ("chartreuse4",          (0.27058824, 0.54509804, 0.00000000)),               
    ("OliveDrab1",           (0.75294118, 1.00000000, 0.24313725)),               
    ("OliveDrab2",           (0.70196078, 0.93333333, 0.22745098)),               
    ("OliveDrab3",           (0.60392157, 0.80392157, 0.19607843)),               
    ("OliveDrab4",           (0.41176471, 0.54509804, 0.13333333)),               
    ("DarkOliveGreen1",      (0.79215686, 1.00000000, 0.43921569)),               
    ("DarkOliveGreen2",      (0.73725490, 0.93333333, 0.40784314)),               
    ("DarkOliveGreen3",      (0.63529412, 0.80392157, 0.35294118)),               
    ("DarkOliveGreen4",      (0.43137255, 0.54509804, 0.23921569)),               
    ("khaki1",               (1.00000000, 0.96470588, 0.56078431)),               
    ("khaki2",               (0.93333333, 0.90196078, 0.52156863)),               
    ("khaki3",               (0.80392157, 0.77647059, 0.45098039)),               
    ("khaki4",               (0.54509804, 0.52549020, 0.30588235)),               
    ("LightGoldenrod1",      (1.00000000, 0.92549020, 0.54509804)),               
    ("LightGoldenrod2",      (0.93333333, 0.86274510, 0.50980392)),               
    ("LightGoldenrod3",      (0.80392157, 0.74509804, 0.43921569)),               
    ("LightGoldenrod4",      (0.54509804, 0.50588235, 0.29803922)),               
    ("LightYellow1",         (1.00000000, 1.00000000, 0.87843137)),               
    ("LightYellow2",         (0.93333333, 0.93333333, 0.81960784)),               
    ("LightYellow3",         (0.80392157, 0.80392157, 0.70588235)),               
    ("LightYellow4",         (0.54509804, 0.54509804, 0.47843137)),               
    ("yellow1",              (1.00000000, 1.00000000, 0.00000000)),               
    ("yellow2",              (0.93333333, 0.93333333, 0.00000000)),               
    ("yellow3",              (0.80392157, 0.80392157, 0.00000000)),               
    ("yellow4",              (0.54509804, 0.54509804, 0.00000000)),               
    ("gold1",                (1.00000000, 0.84313725, 0.00000000)),               
    ("gold2",                (0.93333333, 0.78823529, 0.00000000)),               
    ("gold3",                (0.80392157, 0.67843137, 0.00000000)),               
    ("gold4",                (0.54509804, 0.45882353, 0.00000000)),               
    ("goldenrod1",           (1.00000000, 0.75686275, 0.14509804)),               
    ("goldenrod2",           (0.93333333, 0.70588235, 0.13333333)),               
    ("goldenrod3",           (0.80392157, 0.60784314, 0.11372549)),               
    ("goldenrod4",           (0.54509804, 0.41176471, 0.07843137)),               
    ("DarkGoldenrod1",       (1.00000000, 0.72549020, 0.05882353)),               
    ("DarkGoldenrod2",       (0.93333333, 0.67843137, 0.05490196)),               
    ("DarkGoldenrod3",       (0.80392157, 0.58431373, 0.04705882)),               
    ("DarkGoldenrod4",       (0.54509804, 0.39607843, 0.03137255)),               
    ("RosyBrown1",           (1.00000000, 0.75686275, 0.75686275)),               
    ("RosyBrown2",           (0.93333333, 0.70588235, 0.70588235)),               
    ("RosyBrown3",           (0.80392157, 0.60784314, 0.60784314)),               
    ("RosyBrown4",           (0.54509804, 0.41176471, 0.41176471)),               
    ("IndianRed1",           (1.00000000, 0.41568627, 0.41568627)),               
    ("IndianRed2",           (0.93333333, 0.38823529, 0.38823529)),               
    ("IndianRed3",           (0.80392157, 0.33333333, 0.33333333)),               
    ("IndianRed4",           (0.54509804, 0.22745098, 0.22745098)),               
    ("sienna1",              (1.00000000, 0.50980392, 0.27843137)),               
    ("sienna2",              (0.93333333, 0.47450980, 0.25882353)),               
    ("sienna3",              (0.80392157, 0.40784314, 0.22352941)),               
    ("sienna4",              (0.54509804, 0.27843137, 0.14901961)),               
    ("burlywood1",           (1.00000000, 0.82745098, 0.60784314)),               
    ("burlywood2",           (0.93333333, 0.77254902, 0.56862745)),               
    ("burlywood3",           (0.80392157, 0.66666667, 0.49019608)),               
    ("burlywood4",           (0.54509804, 0.45098039, 0.33333333)),               
    ("wheat1",               (1.00000000, 0.90588235, 0.72941176)),               
    ("wheat2",               (0.93333333, 0.84705882, 0.68235294)),               
    ("wheat3",               (0.80392157, 0.72941176, 0.58823529)),               
    ("wheat4",               (0.54509804, 0.49411765, 0.40000000)),               
    ("tan1",                 (1.00000000, 0.64705882, 0.30980392)),               
    ("tan2",                 (0.93333333, 0.60392157, 0.28627451)),               
    ("tan3",                 (0.80392157, 0.52156863, 0.24705882)),               
    ("tan4",                 (0.54509804, 0.35294118, 0.16862745)),               
    ("chocolate1",           (1.00000000, 0.49803922, 0.14117647)),               
    ("chocolate2",           (0.93333333, 0.46274510, 0.12941176)),               
    ("chocolate3",           (0.80392157, 0.40000000, 0.11372549)),               
    ("chocolate4",           (0.54509804, 0.27058824, 0.07450980)),               
    ("firebrick1",           (1.00000000, 0.18823529, 0.18823529)),               
    ("firebrick2",           (0.93333333, 0.17254902, 0.17254902)),               
    ("firebrick3",           (0.80392157, 0.14901961, 0.14901961)),               
    ("firebrick4",           (0.54509804, 0.10196078, 0.10196078)),               
    ("brown1",               (1.00000000, 0.25098039, 0.25098039)),               
    ("brown2",               (0.93333333, 0.23137255, 0.23137255)),               
    ("brown3",               (0.80392157, 0.20000000, 0.20000000)),               
    ("brown4",               (0.54509804, 0.13725490, 0.13725490)),               
    ("salmon1",              (1.00000000, 0.54901961, 0.41176471)),               
    ("salmon2",              (0.93333333, 0.50980392, 0.38431373)),               
    ("salmon3",              (0.80392157, 0.43921569, 0.32941176)),               
    ("salmon4",              (0.54509804, 0.29803922, 0.22352941)),               
    ("LightSalmon1",         (1.00000000, 0.62745098, 0.47843137)),               
    ("LightSalmon2",         (0.93333333, 0.58431373, 0.44705882)),               
    ("LightSalmon3",         (0.80392157, 0.50588235, 0.38431373)),               
    ("LightSalmon4",         (0.54509804, 0.34117647, 0.25882353)),               
    ("orange1",              (1.00000000, 0.64705882, 0.00000000)),               
    ("orange2",              (0.93333333, 0.60392157, 0.00000000)),               
    ("orange3",              (0.80392157, 0.52156863, 0.00000000)),               
    ("orange4",              (0.54509804, 0.35294118, 0.00000000)),               
    ("DarkOrange1",          (1.00000000, 0.49803922, 0.00000000)),               
    ("DarkOrange2",          (0.93333333, 0.46274510, 0.00000000)),               
    ("DarkOrange3",          (0.80392157, 0.40000000, 0.00000000)),               
    ("DarkOrange4",          (0.54509804, 0.27058824, 0.00000000)),               
    ("coral1",               (1.00000000, 0.44705882, 0.33725490)),               
    ("coral2",               (0.93333333, 0.41568627, 0.31372549)),               
    ("coral3",               (0.80392157, 0.35686275, 0.27058824)),               
    ("coral4",               (0.54509804, 0.24313725, 0.18431373)),               
    ("tomato1",              (1.00000000, 0.38823529, 0.27843137)),               
    ("tomato2",              (0.93333333, 0.36078431, 0.25882353)),               
    ("tomato3",              (0.80392157, 0.30980392, 0.22352941)),               
    ("tomato4",              (0.54509804, 0.21176471, 0.14901961)),               
    ("OrangeRed1",           (1.00000000, 0.27058824, 0.00000000)),               
    ("OrangeRed2",           (0.93333333, 0.25098039, 0.00000000)),               
    ("OrangeRed3",           (0.80392157, 0.21568627, 0.00000000)),               
    ("OrangeRed4",           (0.54509804, 0.14509804, 0.00000000)),               
    ("red1",                 (1.00000000, 0.00000000, 0.00000000)),               
    ("red2",                 (0.93333333, 0.00000000, 0.00000000)),               
    ("red3",                 (0.80392157, 0.00000000, 0.00000000)),               
    ("red4",                 (0.54509804, 0.00000000, 0.00000000)),               
    ("DeepPink1",            (1.00000000, 0.07843137, 0.57647059)),               
    ("DeepPink2",            (0.93333333, 0.07058824, 0.53725490)),               
    ("DeepPink3",            (0.80392157, 0.06274510, 0.46274510)),               
    ("DeepPink4",            (0.54509804, 0.03921569, 0.31372549)),               
    ("HotPink1",             (1.00000000, 0.43137255, 0.70588235)),               
    ("HotPink2",             (0.93333333, 0.41568627, 0.65490196)),               
    ("HotPink3",             (0.80392157, 0.37647059, 0.56470588)),               
    ("HotPink4",             (0.54509804, 0.22745098, 0.38431373)),               
    ("pink1",                (1.00000000, 0.70980392, 0.77254902)),               
    ("pink2",                (0.93333333, 0.66274510, 0.72156863)),               
    ("pink3",                (0.80392157, 0.56862745, 0.61960784)),               
    ("pink4",                (0.54509804, 0.38823529, 0.42352941)),               
    ("LightPink1",           (1.00000000, 0.68235294, 0.72549020)),               
    ("LightPink2",           (0.93333333, 0.63529412, 0.67843137)),               
    ("LightPink3",           (0.80392157, 0.54901961, 0.58431373)),               
    ("LightPink4",           (0.54509804, 0.37254902, 0.39607843)),               
    ("PaleVioletRed1",       (1.00000000, 0.50980392, 0.67058824)),               
    ("PaleVioletRed2",       (0.93333333, 0.47450980, 0.62352941)),               
    ("PaleVioletRed3",       (0.80392157, 0.40784314, 0.53725490)),               
    ("PaleVioletRed4",       (0.54509804, 0.27843137, 0.36470588)),               
    ("maroon1",              (1.00000000, 0.20392157, 0.70196078)),               
    ("maroon2",              (0.93333333, 0.18823529, 0.65490196)),               
    ("maroon3",              (0.80392157, 0.16078431, 0.56470588)),               
    ("maroon4",              (0.54509804, 0.10980392, 0.38431373)),               
    ("VioletRed1",           (1.00000000, 0.24313725, 0.58823529)),               
    ("VioletRed2",           (0.93333333, 0.22745098, 0.54901961)),               
    ("VioletRed3",           (0.80392157, 0.19607843, 0.47058824)),               
    ("VioletRed4",           (0.54509804, 0.13333333, 0.32156863)),               
    ("magenta1",             (1.00000000, 0.00000000, 1.00000000)),               
    ("magenta2",             (0.93333333, 0.00000000, 0.93333333)),               
    ("magenta3",             (0.80392157, 0.00000000, 0.80392157)),               
    ("magenta4",             (0.54509804, 0.00000000, 0.54509804)),               
    ("orchid1",              (1.00000000, 0.51372549, 0.98039216)),               
    ("orchid2",              (0.93333333, 0.47843137, 0.91372549)),               
    ("orchid3",              (0.80392157, 0.41176471, 0.78823529)),               
    ("orchid4",              (0.54509804, 0.27843137, 0.53725490)),               
    ("plum1",                (1.00000000, 0.73333333, 1.00000000)),               
    ("plum2",                (0.93333333, 0.68235294, 0.93333333)),               
    ("plum3",                (0.80392157, 0.58823529, 0.80392157)),               
    ("plum4",                (0.54509804, 0.40000000, 0.54509804)),               
    ("MediumOrchid1",        (0.87843137, 0.40000000, 1.00000000)),               
    ("MediumOrchid2",        (0.81960784, 0.37254902, 0.93333333)),               
    ("MediumOrchid3",        (0.70588235, 0.32156863, 0.80392157)),               
    ("MediumOrchid4",        (0.47843137, 0.21568627, 0.54509804)),               
    ("DarkOrchid1",          (0.74901961, 0.24313725, 1.00000000)),               
    ("DarkOrchid2",          (0.69803922, 0.22745098, 0.93333333)),               
    ("DarkOrchid3",          (0.60392157, 0.19607843, 0.80392157)),               
    ("DarkOrchid4",          (0.40784314, 0.13333333, 0.54509804)),               
    ("purple1",              (0.60784314, 0.18823529, 1.00000000)),               
    ("purple2",              (0.56862745, 0.17254902, 0.93333333)),               
    ("purple3",              (0.49019608, 0.14901961, 0.80392157)),               
    ("purple4",              (0.33333333, 0.10196078, 0.54509804)),               
    ("MediumPurple1",        (0.67058824, 0.50980392, 1.00000000)),               
    ("MediumPurple2",        (0.62352941, 0.47450980, 0.93333333)),               
    ("MediumPurple3",        (0.53725490, 0.40784314, 0.80392157)),               
    ("MediumPurple4",        (0.36470588, 0.27843137, 0.54509804)),               
    ("thistle1",             (1.00000000, 0.88235294, 1.00000000)),               
    ("thistle2",             (0.93333333, 0.82352941, 0.93333333)),               
    ("thistle3",             (0.80392157, 0.70980392, 0.80392157)),               
    ("thistle4",             (0.54509804, 0.48235294, 0.54509804)),               
    ("gray0",                (0.00000000, 0.00000000, 0.00000000)),               
    ("grey0",                (0.00000000, 0.00000000, 0.00000000)),               
    ("gray1",                (0.01176471, 0.01176471, 0.01176471)),               
    ("grey1",                (0.01176471, 0.01176471, 0.01176471)),               
    ("gray2",                (0.01960784, 0.01960784, 0.01960784)),               
    ("grey2",                (0.01960784, 0.01960784, 0.01960784)),               
    ("gray3",                (0.03137255, 0.03137255, 0.03137255)),               
    ("grey3",                (0.03137255, 0.03137255, 0.03137255)),               
    ("gray4",                (0.03921569, 0.03921569, 0.03921569)),               
    ("grey4",                (0.03921569, 0.03921569, 0.03921569)),               
    ("gray5",                (0.05098039, 0.05098039, 0.05098039)),               
    ("grey5",                (0.05098039, 0.05098039, 0.05098039)),               
    ("gray6",                (0.05882353, 0.05882353, 0.05882353)),               
    ("grey6",                (0.05882353, 0.05882353, 0.05882353)),               
    ("gray7",                (0.07058824, 0.07058824, 0.07058824)),               
    ("grey7",                (0.07058824, 0.07058824, 0.07058824)),               
    ("gray8",                (0.07843137, 0.07843137, 0.07843137)),               
    ("grey8",                (0.07843137, 0.07843137, 0.07843137)),               
    ("gray9",                (0.09019608, 0.09019608, 0.09019608)),               
    ("grey9",                (0.09019608, 0.09019608, 0.09019608)),               
    ("gray10",               (0.10196078, 0.10196078, 0.10196078)),               
    ("grey10",               (0.10196078, 0.10196078, 0.10196078)),               
    ("gray11",               (0.10980392, 0.10980392, 0.10980392)),               
    ("grey11",               (0.10980392, 0.10980392, 0.10980392)),               
    ("gray12",               (0.12156863, 0.12156863, 0.12156863)),               
    ("grey12",               (0.12156863, 0.12156863, 0.12156863)),               
    ("gray13",               (0.12941176, 0.12941176, 0.12941176)),               
    ("grey13",               (0.12941176, 0.12941176, 0.12941176)),               
    ("gray14",               (0.14117647, 0.14117647, 0.14117647)),               
    ("grey14",               (0.14117647, 0.14117647, 0.14117647)),               
    ("gray15",               (0.14901961, 0.14901961, 0.14901961)),               
    ("grey15",               (0.14901961, 0.14901961, 0.14901961)),               
    ("gray16",               (0.16078431, 0.16078431, 0.16078431)),               
    ("grey16",               (0.16078431, 0.16078431, 0.16078431)),               
    ("gray17",               (0.16862745, 0.16862745, 0.16862745)),               
    ("grey17",               (0.16862745, 0.16862745, 0.16862745)),               
    ("gray18",               (0.18039216, 0.18039216, 0.18039216)),               
    ("grey18",               (0.18039216, 0.18039216, 0.18039216)),               
    ("gray19",               (0.18823529, 0.18823529, 0.18823529)),               
    ("grey19",               (0.18823529, 0.18823529, 0.18823529)),               
    ("gray20",               (0.20000000, 0.20000000, 0.20000000)),               
    ("grey20",               (0.20000000, 0.20000000, 0.20000000)),               
    ("gray21",               (0.21176471, 0.21176471, 0.21176471)),               
    ("grey21",               (0.21176471, 0.21176471, 0.21176471)),               
    ("gray22",               (0.21960784, 0.21960784, 0.21960784)),               
    ("grey22",               (0.21960784, 0.21960784, 0.21960784)),               
    ("gray23",               (0.23137255, 0.23137255, 0.23137255)),               
    ("grey23",               (0.23137255, 0.23137255, 0.23137255)),               
    ("gray24",               (0.23921569, 0.23921569, 0.23921569)),               
    ("grey24",               (0.23921569, 0.23921569, 0.23921569)),               
    ("gray25",               (0.25098039, 0.25098039, 0.25098039)),               
    ("grey25",               (0.25098039, 0.25098039, 0.25098039)),               
    ("gray26",               (0.25882353, 0.25882353, 0.25882353)),               
    ("grey26",               (0.25882353, 0.25882353, 0.25882353)),               
    ("gray27",               (0.27058824, 0.27058824, 0.27058824)),               
    ("grey27",               (0.27058824, 0.27058824, 0.27058824)),               
    ("gray28",               (0.27843137, 0.27843137, 0.27843137)),               
    ("grey28",               (0.27843137, 0.27843137, 0.27843137)),               
    ("gray29",               (0.29019608, 0.29019608, 0.29019608)),               
    ("grey29",               (0.29019608, 0.29019608, 0.29019608)),               
    ("gray30",               (0.30196078, 0.30196078, 0.30196078)),               
    ("grey30",               (0.30196078, 0.30196078, 0.30196078)),               
    ("gray31",               (0.30980392, 0.30980392, 0.30980392)),               
    ("grey31",               (0.30980392, 0.30980392, 0.30980392)),               
    ("gray32",               (0.32156863, 0.32156863, 0.32156863)),               
    ("grey32",               (0.32156863, 0.32156863, 0.32156863)),               
    ("gray33",               (0.32941176, 0.32941176, 0.32941176)),               
    ("grey33",               (0.32941176, 0.32941176, 0.32941176)),               
    ("gray34",               (0.34117647, 0.34117647, 0.34117647)),               
    ("grey34",               (0.34117647, 0.34117647, 0.34117647)),               
    ("gray35",               (0.34901961, 0.34901961, 0.34901961)),               
    ("grey35",               (0.34901961, 0.34901961, 0.34901961)),               
    ("gray36",               (0.36078431, 0.36078431, 0.36078431)),               
    ("grey36",               (0.36078431, 0.36078431, 0.36078431)),               
    ("gray37",               (0.36862745, 0.36862745, 0.36862745)),               
    ("grey37",               (0.36862745, 0.36862745, 0.36862745)),               
    ("gray38",               (0.38039216, 0.38039216, 0.38039216)),               
    ("grey38",               (0.38039216, 0.38039216, 0.38039216)),               
    ("gray39",               (0.38823529, 0.38823529, 0.38823529)),               
    ("grey39",               (0.38823529, 0.38823529, 0.38823529)),               
    ("gray40",               (0.40000000, 0.40000000, 0.40000000)),               
    ("grey40",               (0.40000000, 0.40000000, 0.40000000)),               
    ("gray41",               (0.41176471, 0.41176471, 0.41176471)),               
    ("grey41",               (0.41176471, 0.41176471, 0.41176471)),               
    ("gray42",               (0.41960784, 0.41960784, 0.41960784)),               
    ("grey42",               (0.41960784, 0.41960784, 0.41960784)),               
    ("gray43",               (0.43137255, 0.43137255, 0.43137255)),               
    ("grey43",               (0.43137255, 0.43137255, 0.43137255)),               
    ("gray44",               (0.43921569, 0.43921569, 0.43921569)),               
    ("grey44",               (0.43921569, 0.43921569, 0.43921569)),               
    ("gray45",               (0.45098039, 0.45098039, 0.45098039)),               
    ("grey45",               (0.45098039, 0.45098039, 0.45098039)),               
    ("gray46",               (0.45882353, 0.45882353, 0.45882353)),               
    ("grey46",               (0.45882353, 0.45882353, 0.45882353)),               
    ("gray47",               (0.47058824, 0.47058824, 0.47058824)),               
    ("grey47",               (0.47058824, 0.47058824, 0.47058824)),               
    ("gray48",               (0.47843137, 0.47843137, 0.47843137)),               
    ("grey48",               (0.47843137, 0.47843137, 0.47843137)),               
    ("gray49",               (0.49019608, 0.49019608, 0.49019608)),               
    ("grey49",               (0.49019608, 0.49019608, 0.49019608)),               
    ("gray50",               (0.49803922, 0.49803922, 0.49803922)),               
    ("grey50",               (0.49803922, 0.49803922, 0.49803922)),               
    ("gray51",               (0.50980392, 0.50980392, 0.50980392)),               
    ("grey51",               (0.50980392, 0.50980392, 0.50980392)),               
    ("gray52",               (0.52156863, 0.52156863, 0.52156863)),               
    ("grey52",               (0.52156863, 0.52156863, 0.52156863)),               
    ("gray53",               (0.52941176, 0.52941176, 0.52941176)),               
    ("grey53",               (0.52941176, 0.52941176, 0.52941176)),               
    ("gray54",               (0.54117647, 0.54117647, 0.54117647)),               
    ("grey54",               (0.54117647, 0.54117647, 0.54117647)),               
    ("gray55",               (0.54901961, 0.54901961, 0.54901961)),               
    ("grey55",               (0.54901961, 0.54901961, 0.54901961)),               
    ("gray56",               (0.56078431, 0.56078431, 0.56078431)),               
    ("grey56",               (0.56078431, 0.56078431, 0.56078431)),               
    ("gray57",               (0.56862745, 0.56862745, 0.56862745)),               
    ("grey57",               (0.56862745, 0.56862745, 0.56862745)),               
    ("gray58",               (0.58039216, 0.58039216, 0.58039216)),               
    ("grey58",               (0.58039216, 0.58039216, 0.58039216)),               
    ("gray59",               (0.58823529, 0.58823529, 0.58823529)),               
    ("grey59",               (0.58823529, 0.58823529, 0.58823529)),               
    ("gray60",               (0.60000000, 0.60000000, 0.60000000)),               
    ("grey60",               (0.60000000, 0.60000000, 0.60000000)),               
    ("gray61",               (0.61176471, 0.61176471, 0.61176471)),               
    ("grey61",               (0.61176471, 0.61176471, 0.61176471)),               
    ("gray62",               (0.61960784, 0.61960784, 0.61960784)),               
    ("grey62",               (0.61960784, 0.61960784, 0.61960784)),               
    ("gray63",               (0.63137255, 0.63137255, 0.63137255)),               
    ("grey63",               (0.63137255, 0.63137255, 0.63137255)),               
    ("gray64",               (0.63921569, 0.63921569, 0.63921569)),               
    ("grey64",               (0.63921569, 0.63921569, 0.63921569)),               
    ("gray65",               (0.65098039, 0.65098039, 0.65098039)),               
    ("grey65",               (0.65098039, 0.65098039, 0.65098039)),               
    ("gray66",               (0.65882353, 0.65882353, 0.65882353)),               
    ("grey66",               (0.65882353, 0.65882353, 0.65882353)),               
    ("gray67",               (0.67058824, 0.67058824, 0.67058824)),               
    ("grey67",               (0.67058824, 0.67058824, 0.67058824)),               
    ("gray68",               (0.67843137, 0.67843137, 0.67843137)),               
    ("grey68",               (0.67843137, 0.67843137, 0.67843137)),               
    ("gray69",               (0.69019608, 0.69019608, 0.69019608)),               
    ("grey69",               (0.69019608, 0.69019608, 0.69019608)),               
    ("gray70",               (0.70196078, 0.70196078, 0.70196078)),               
    ("grey70",               (0.70196078, 0.70196078, 0.70196078)),               
    ("gray71",               (0.70980392, 0.70980392, 0.70980392)),               
    ("grey71",               (0.70980392, 0.70980392, 0.70980392)),               
    ("gray72",               (0.72156863, 0.72156863, 0.72156863)),               
    ("grey72",               (0.72156863, 0.72156863, 0.72156863)),               
    ("gray73",               (0.72941176, 0.72941176, 0.72941176)),               
    ("grey73",               (0.72941176, 0.72941176, 0.72941176)),               
    ("gray74",               (0.74117647, 0.74117647, 0.74117647)),               
    ("grey74",               (0.74117647, 0.74117647, 0.74117647)),               
    ("gray75",               (0.74901961, 0.74901961, 0.74901961)),               
    ("grey75",               (0.74901961, 0.74901961, 0.74901961)),               
    ("gray76",               (0.76078431, 0.76078431, 0.76078431)),               
    ("grey76",               (0.76078431, 0.76078431, 0.76078431)),               
    ("gray77",               (0.76862745, 0.76862745, 0.76862745)),               
    ("grey77",               (0.76862745, 0.76862745, 0.76862745)),               
    ("gray78",               (0.78039216, 0.78039216, 0.78039216)),               
    ("grey78",               (0.78039216, 0.78039216, 0.78039216)),               
    ("gray79",               (0.78823529, 0.78823529, 0.78823529)),               
    ("grey79",               (0.78823529, 0.78823529, 0.78823529)),               
    ("gray80",               (0.80000000, 0.80000000, 0.80000000)),               
    ("grey80",               (0.80000000, 0.80000000, 0.80000000)),               
    ("gray81",               (0.81176471, 0.81176471, 0.81176471)),               
    ("grey81",               (0.81176471, 0.81176471, 0.81176471)),               
    ("gray82",               (0.81960784, 0.81960784, 0.81960784)),               
    ("grey82",               (0.81960784, 0.81960784, 0.81960784)),               
    ("gray83",               (0.83137255, 0.83137255, 0.83137255)),               
    ("grey83",               (0.83137255, 0.83137255, 0.83137255)),               
    ("gray84",               (0.83921569, 0.83921569, 0.83921569)),               
    ("grey84",               (0.83921569, 0.83921569, 0.83921569)),               
    ("gray85",               (0.85098039, 0.85098039, 0.85098039)),               
    ("grey85",               (0.85098039, 0.85098039, 0.85098039)),               
    ("gray86",               (0.85882353, 0.85882353, 0.85882353)),               
    ("grey86",               (0.85882353, 0.85882353, 0.85882353)),               
    ("gray87",               (0.87058824, 0.87058824, 0.87058824)),               
    ("grey87",               (0.87058824, 0.87058824, 0.87058824)),               
    ("gray88",               (0.87843137, 0.87843137, 0.87843137)),               
    ("grey88",               (0.87843137, 0.87843137, 0.87843137)),               
    ("gray89",               (0.89019608, 0.89019608, 0.89019608)),               
    ("grey89",               (0.89019608, 0.89019608, 0.89019608)),               
    ("gray90",               (0.89803922, 0.89803922, 0.89803922)),               
    ("grey90",               (0.89803922, 0.89803922, 0.89803922)),               
    ("gray91",               (0.90980392, 0.90980392, 0.90980392)),               
    ("grey91",               (0.90980392, 0.90980392, 0.90980392)),
    ("gray92",               (0.92156863, 0.92156863, 0.92156863)),
    ("grey92",               (0.92156863, 0.92156863, 0.92156863)),
    ("gray93",               (0.92941176, 0.92941176, 0.92941176)),
    ("grey93",               (0.92941176, 0.92941176, 0.92941176)),
    ("gray94",               (0.94117647, 0.94117647, 0.94117647)),
    ("grey94",               (0.94117647, 0.94117647, 0.94117647)),
    ("gray95",               (0.94901961, 0.94901961, 0.94901961)),
    ("grey95",               (0.94901961, 0.94901961, 0.94901961)),
    ("gray96",               (0.96078431, 0.96078431, 0.96078431)),
    ("grey96",               (0.96078431, 0.96078431, 0.96078431)),
    ("gray97",               (0.96862745, 0.96862745, 0.96862745)),
    ("grey97",               (0.96862745, 0.96862745, 0.96862745)),
    ("gray98",               (0.98039216, 0.98039216, 0.98039216)),
    ("grey98",               (0.98039216, 0.98039216, 0.98039216)),
    ("gray99",               (0.98823529, 0.98823529, 0.98823529)),
    ("grey99",               (0.98823529, 0.98823529, 0.98823529)),
    ("gray100",              (1.00000000, 1.00000000, 1.00000000)),
    ("grey100",              (1.00000000, 1.00000000, 1.00000000)),
    ("DarkGrey",             (0.66274510, 0.66274510, 0.66274510)),
    ("DarkGray",             (0.66274510, 0.66274510, 0.66274510)),
    ("DarkBlue",             (0.00000000, 0.00000000, 0.54509804)),
    ("DarkCyan",             (0.00000000, 0.54509804, 0.54509804)),
    ("DarkMagenta",          (0.54509804, 0.00000000, 0.54509804)),
    ("DarkRed",              (0.54509804, 0.00000000, 0.00000000)),
    ("LightGreen",           (0.56470588, 0.93333333, 0.56470588)),
    )
