#!/usr/bin/freej -j
/*  FreeJ example scripts
 *  (c) Copyright 2005 Christoph Rudorff aka MrGoil <goil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* manage cams
*/
w = 320; h=240;
pad = 6;
edge_zoom=0.4;
//return scandir(dir).filter(new RegExp(exp));


// tv logo
logo = new TextLayer();
logo.size( 12 );
logo.font("/var/lib/defoma/fontconfig.d/F/FreeSans-Medium.ttf");
add_layer( logo );
logo.print( " beTV ");
//logo.set_blit("ADD");
logo.ne = function() { this.set_position( w-37, 2 ); }
logo.nw = function() { this.set_position( 2, 2 ); }
logo.ne();
//logo.up();

cam_pos = new Object;
cam_pos.nw = {
    get zoom() { return edge_zoom; },
    get x() { return pad },
    get y() { return pad }
};
cam_pos.ne = {
    get zoom() { return edge_zoom; },
    get x() { return w - w*edge_zoom-pad },
    get y() { return pad }
};
cam_pos.sw = {
    get zoom() { return edge_zoom; },
    get x() { return pad }, 
    get y() { return h - h*edge_zoom-pad }
};
cam_pos.se = {
    get zoom() { return edge_zoom; },
    get x() { return w - w*edge_zoom-pad },
    get y() { return h - h*edge_zoom-pad }
};
cam_pos.front = {zoom: 1, x: 0, y: 0};

cams = new Object;
cams.edge = {
    dev: "/dev/video0",
    layer: null,
    pos: cam_pos.nw
};
cams.front = {
    dev: "/dev/video1",
    layer: null,
    pos: cam_pos.front
};

function init_cams() {
    for (var i in cams) {
        var cam = cams[i];
        try {
            echo("open cam " + cam +  ": " + cam.dev);
            var cam_obj = new CamLayer(w, h, cam.dev);
        } catch (e) {
            echo("open cam " + cam + " failed: " + e);
            quit();
        }
        cam.layer = cam_obj;
        apply_paras(cam);
        add_layer(cam_obj);
    }
    cams.front.layer.down();
}

function apply_paras(cam) {
    var cam_layer = cam.layer;
    cam_layer.zoom(cam.pos.zoom, cam.pos.zoom);
    cam_layer.set_position(cam.pos.x, cam.pos.y);
}


// set up keyboard
kbd = new KeyboardController();
register_controller(kbd);

// change front cam
kbd.released_num_5 = function() {
    var tmp = cams.edge;
    cams.edge = cams.front;
    cams.edge.pos = tmp.pos;
    cams.front = tmp;
    cams.front.pos = cam_pos.front;
    apply_paras(cams.front);
    apply_paras(cams.edge);
    cams.front.layer.down();

    cams.front.layer.activate();
    if (!edge_active)
        cams.edge.layer.deactivate();
};

// put cam into the edge
kbd.released_num_7 = function() {
    logo.ne();
    cams.edge.pos = cam_pos.nw; 
    apply_paras(cams.edge);
};
kbd.released_num_9 = function() { 
    logo.nw();
    cams.edge.pos = cam_pos.ne; 
    apply_paras(cams.edge);
};
kbd.released_num_3 = function() { 
    cams.edge.pos = cam_pos.se; 
    apply_paras(cams.edge);
};
kbd.released_num_1 = function() { 
    cams.edge.pos = cam_pos.sw;
    apply_paras(cams.edge);
};

// switch edge on/off
edge_active=true;
kbd.released_num_0 = function() { 
    if (edge_active) {
        cams.edge.layer.deactivate();
        edge_active=false;
    } else {
        cams.edge.layer.activate();
        edge_active=true;
    }
};

// set zoom for edge
kbd.released_num_2 = function() { edge_zoom=Math.max(edge_zoom-0.1, 0.2); apply_paras(cams.edge);};
kbd.released_num_8 = function() { edge_zoom=Math.min(edge_zoom+0.1, 0.5); apply_paras(cams.edge);};

// finally a quit key
kbd.released_ctrl_q = function() { vc.stop_stream(); quit(); };

// ok, start all the stuff
set_resolution(w, h);
init_cams();

// stream setup
// vc = new VideoEncoder(10, 128000, 0, 24000);
// include("stream_account.js");
// init_stream(vc);

// register_encoder(vc);
// vc.start_stream();

/* stream_account.js :
function init_stream(vc) {
with (vc) {
    stream_host("on.netculture.at");
    stream_port(8000);
    stream_title("beTV");
    stream_username("<fillin>");
    stream_password("<fillin>");
    stream_mountpoint("betv.ogg");
}
*/
