/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "envelope.h"

Envelope::Envelope(QObject *parent, const char *name)
 : CustomEffect(parent, name)
{
    length=0;
    duration=0;
    samplerate=44100;
}


Envelope::~Envelope()
{
    if(outputP) zaparr(outputP);
}


void Envelope::advancePosition(long /*length*/)
{

}

void Envelope::init(long length)
{
    outputP=new float[length];
    std::memset(outputP,0,sizeof(float)*length);
}

void Envelope::process(long length)
{
    for (int i=0;i<length;i++){
        outputP[i]=inputP[i]*getEnvelopeValueAt(i);
    }
}

void Envelope::setPosition(long /*position*/)
{

}




/*!
    \fn Envelope::setInputP(float*)
 */
void Envelope::setInputP(float* _inputP)
{
    inputP=_inputP;
}


/*!
    \fn Envelope::getOutputP()
 */
float* Envelope::getOutputP()
{
    return outputP;
}


/*!
    \fn Envelope::setEnvLengthAndBitrate(long _length, int _bitrate)
 */
void Envelope::setEnvDurationAndSamplerate(long _duration, int _samplerate)
{
    duration=_duration;
    samplerate=_samplerate;
    length=(duration*samplerate)/1000;
}

QString Envelope::getName(){
    return "Envelope";
}


/*!
    \fn Envelope::getEnvelopeValueAt(long i)
 */
float Envelope::getEnvelopeValueAt(long i)
{
    return float(i)/float(length);
}
