/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "drawingline.h"

DrawingLine::DrawingLine(QCanvas* canvas)
 : QCanvasPolygon(canvas)
{

    QPointArray tempPoints(4);
    tempPoints.putPoints(0,4,0,0,0,0,0,0,0,0);
    setPoints(tempPoints);
    /*
    QColor colorClear(230,230,130);
    QColor colorDark(10,10,10);
    QBrush brush(colorClear,SolidPattern);
    setPen(colorDark);
    setBrush(brush);
    */
    QCanvasPolygon::setZ(10);
    start_sample=0;
    end_sample=0;
}


DrawingLine::~DrawingLine()
{
}




/*!
    \fn DrawingLine::setStartPoint(int,int)
 */
void DrawingLine::setStartPoint(int x,int y)
{
    QPointArray tempPoints(points());
    tempPoints.setPoint(0,QPoint(x,canvas()->height()));
    tempPoints.setPoint(1,QPoint(x,y));
    setPoints(tempPoints);
}


/*!
    \fn DrawingLine::setEndPoint(int,int)
 */
void DrawingLine::setEndPoint(int x,int y)
{
    QPointArray tempPoints(points());
    tempPoints.setPoint(2,QPoint(x,y));
    tempPoints.setPoint(3,QPoint(x,canvas()->height()));
    setPoints(tempPoints);
}


/*!
    \fn DrawingLine::getStartPoint()
 */
QPoint DrawingLine::getStartPoint()
{
    return points().point(1);
}


/*!
    \fn DrawingLine::getEndPoint()
 */
QPoint DrawingLine::getEndPoint()
{
    return points().point(2);
}

QPointArray DrawingLine::areaPoints () const{
    return QCanvasPolygon::areaPoints();
}

void DrawingLine::drawShape ( QPainter & p ){
    RasterOp oldROP=p.rasterOp();
    p.setRasterOp(AndROP);
    QColor colorClear(230,230,130);
    QColor colorDark(10,10,10);
    QBrush brush(colorClear,SolidPattern);
    p.setPen(QPen(colorDark,1));
    p.setBrush(brush);
    p.drawPolygon(points());
    //QCanvasPolygon::drawShape(p);
    p.setRasterOp(oldROP);
}

QRect DrawingLine::boundingRect(){
    return points().boundingRect();
}


/*!
    \fn DrawingLine::rtti() const
 */
int DrawingLine::rtti() const
{
    return RTTI_DRAWINGLINE;
}


/*!
    \fn DrawingLine::getYAtX(int)
 */
int DrawingLine::getYAtX(int x)
{
    int x1=getStartPoint().x();
    int y1=getStartPoint().y();
    int x2=getEndPoint().x();
    int y2=getEndPoint().y();
    float a=float((y2-y1))/float((x2-x1));
    float b=y1-(a*float(x1));
    return int(a*x+b);
}




/*!
    \fn DrawingLine::setEndSample(long e)
 */
void DrawingLine::setEndSample(long e)
{
    end_sample=e;
}


/*!
    \fn DrawingLine::setStartSample(long s)
 */
void DrawingLine::setStartSample(long s)
{
    start_sample=s;
}


/*!
    \fn DrawingLine::getValueAtSample(long sample)
 */
float DrawingLine::getValueAtSample(long sample)
{
    long x1=start_sample;
    float y1=startValue;
    long x2=end_sample;
    float y2=endValue;
    float a=float((y2-y1))/float((x2-x1));
    float b=y1-(a*float(x1));
    return a*float(sample)+b;
}




/*!
    \fn DrawingLine::setEndValue(float ev)
 */
void DrawingLine::setEndValue(float ev)
{
    endValue=ev;
}


/*!
    \fn DrawingLine::setStartValue(float sv)
 */
void DrawingLine::setStartValue(float sv)
{
    startValue=sv;
}
