/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOUNDFILEPREVIEW_H
#define SOUNDFILEPREVIEW_H

#include <qwidget.h>
#include <qfiledialog.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <iostream>
#include "soundplayer.h"
#include "soundmanager.h"
#include "filemanager.h"
#include "pics/icons.h"
#include "previewwavedisplay.h"
#include "qslider.h"
#include "qscrollbar.h"
#include "qfileinfo.h"

/**
@author Predrag Viceic
*/
class SoundFilePreview : public QWidget, public QFilePreview
{
Q_OBJECT
public:
    SoundFilePreview(SoundManager* sm,SoundPlayer* pl, FileManager* fm,
                                QWidget *parent = 0, const char *name = 0);

    ~SoundFilePreview();
    void previewUrl(const QUrl & url);
    bool getPlaying();
    void init();
    QSize minimumSizeHint() const;
    bool getIsFileOk();



protected:
    SoundPlayer* soundPlayer;
    SoundManager* soundManager;
    FileManager* fileManager;
    QPushButton* playButton;
    QPushButton* pauseButton;
    QPushButton* stopButton;
    QVBox* vbox;
    QHBox* hbox;
    QString path;
    bool playing;
    PreviewWaveDisplay* waveDisplay;
    QSlider* zoomSlider;
    QScrollBar* positionScrollBar;
    QVBox* mainFrame;
    QHBox* audioPreviewFrame;
    void closeEvent( QCloseEvent* ce );
    void resizeEvent ( QResizeEvent * ) ;
    void enableButtons(bool tf);
public slots:
    void play();
    void stop();
    void stopButtonOnly();
    void pause();
    void maxStartDisplayPositionChanged(int);
    void startPositionChanged(int sp);
    void setPlayPosition(long);
};

#endif
