//
// C++ Implementation: scenebutton
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "scenebutton.h"
#include "pics/icons.h"

SceneButton::SceneButton(int n, QColor c, QWidget *parent, const char *name)
 : QFrame(parent, name)
{
    color=c;
    number=n;
    setFixedSize(qembed_findImage("scene_control").size());
    setMargin(0);
    clicked=FALSE;
    smallClicked=FALSE;
    smallCircle=new QRect(contentsRect().bottomRight()-QPoint(15,15),
                          contentsRect().bottomRight()-QPoint(5,5));
}


SceneButton::~SceneButton()
{
}




/*!
    \fn SceneButton::drawContents ( QPainter * p ) 
 */
void SceneButton::drawContents ( QPainter * p ) 
{
    if(clicked){
        p->setBrush(QBrush(red));
    }else{
        p->setBrush(QBrush(color));
    }
    p->drawEllipse(contentsRect());
    
    if(smallClicked){
        p->setBrush(QBrush(QColor(red)));
    }else{
        p->setBrush(QBrush(QColor(255,255,255)));
    }
    p->drawEllipse(*smallCircle);
    
    p->drawPixmap(0,0,QPixmap(qembed_findImage("scene_control")));
    
    
    QRect textRect=contentsRect();
    textRect.addCoords(0,0,-10,-10);
    QFont font=p->font();
    font.setPixelSize(15);
    p->setFont(font);
    p->drawText(textRect,Qt::AlignCenter,QString::number(number));
}


void SceneButton::setClicked(bool theValue) {
    clicked = theValue;
}


void SceneButton::setSmallClicked(bool theValue) {
    smallClicked = theValue;
}


/*!
    \fn SceneButton::mousePressEvent ( QMouseEvent * e ) 
 */
void SceneButton::mousePressEvent ( QMouseEvent * e ) 
{
    if(smallCircle->contains(e->pos())){
        smallClicked=TRUE;
        repaint();
    }
    else{
        clicked=TRUE;
        repaint();
        emit(sceneSwitchedS(number));
    }
    
}


/*!
    \fn SceneButton::mouseReleaseEvent ( QMouseEvent * e )
 */
void SceneButton::mouseReleaseEvent ( QMouseEvent * e )
{
    clicked=FALSE;
    smallClicked=FALSE;
    update();
    if(smallCircle->contains(e->pos())) emit(assignToSceneS(number));
}
