/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONTROLLERCANVAS_H
#define CONTROLLERCANVAS_H

#include <qcanvas.h>
#include <qpainter.h>
#include <qpen.h>
#include <qfont.h>
#include <qpixmap.h>
#include "defs.h"

/**
@author Predrag Viceic
*/
class ControllerCanvas : public QCanvas
{
public:
    ControllerCanvas(QWidget* parent=0,const char * name = 0);
    ~ControllerCanvas();
    void setVisibleWidth(int w);
    void setStartX(int x);
    void setMaxValue(float v);
    void setMinValue(float v);
    int getStartX();
    int getVisibleWidth();

protected:
    void drawBackground ( QPainter & painter, const QRect & clip );
    void drawCoords(QPainter& p, const QRect & clip);
    

protected:
    int visibleWidth;
    int startX;
    float minValue;
    float maxValue;
};

#endif
