/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "controllercanvas.h"

ControllerCanvas::ControllerCanvas(QWidget* parent,const char * name)
    : QCanvas(parent,name)
{
    minValue=0;
    maxValue=1;
    setDoubleBuffering(true);
}


ControllerCanvas::~ControllerCanvas()
{

}


void ControllerCanvas::drawBackground ( QPainter & painter, const QRect & clip ){
    //QCanvas::drawBackground(painter,clip);
    drawCoords(painter,clip);
}

/*!
    \fn ControllerCanvas::drawCoords()
 */

void ControllerCanvas::drawCoords(QPainter& painter, const QRect & /*clip*/)
{

    static QPixmap pixmap;
    pixmap.resize(visibleWidth,height());
    pixmap.fill(backgroundColor());
    QPainter p(&pixmap);
    QString min=QString::number(minValue);
    QString max=QString::number(maxValue);
    QString mid=QString::number((minValue+maxValue)/2);
    QFont font=p.font();
    font.setPixelSize(10);
    p.setFont(font);

    QPen pen=p.pen();
    //p.setPen(QPen(QColor(gray),1,Qt::DashLine));
    //p.drawLine(0,height()/2,0+visibleWidth,height()/2);
    p.setPen(QPen(QColor(black),1));
    p.drawText(0+10,height()/2,mid);
    p.drawText(0+10,10,max);
    p.drawText(0+10,height(),min);

    p.drawText(0+visibleWidth/2,height()/2,mid);
    p.drawText(0+visibleWidth/2,10,max);
    p.drawText(0+visibleWidth/2,height(),min);

    p.drawText(0+visibleWidth-10,height()/2,mid);
    p.drawText(0+visibleWidth-10,10,max);
    p.drawText(0+visibleWidth-10,height(),min);
    p.setPen(pen);
    painter.drawPixmap(startX,0,pixmap);
}




/*!
    \fn ControllerCanvas::setVisibleWidth(int w)
 */
void ControllerCanvas::setVisibleWidth(int w)
{
    visibleWidth=w;
}


/*!
    \fn ControllerCanvas::setStartX(int x)
 */
void ControllerCanvas::setStartX(int x)
{
    startX=x;
}


/*!
    \fn ControllerCanvas::setMaxValue(float v)
 */
void ControllerCanvas::setMaxValue(float v)
{
    maxValue=v;
}


/*!
    \fn ControllerCanvas::setMinValue(float v)
 */
void ControllerCanvas::setMinValue(float v)
{
    minValue=v;
}


/*!
    \fn ControllerCanvas::getVisibleWidth()
 */
int ControllerCanvas::getVisibleWidth()
{
    return visibleWidth;
}


/*!
    \fn ControllerCanvas::getStartX()
 */
int ControllerCanvas::getStartX()
{
    return startX;
}
