/***************************************************************************
 *   Copyright (c) 2004 Jrgen Riegel <juergen.riegel@web.de>              *
 *                                                                         *
 *   This file is Drawing of the FreeCAD CAx development system.              *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2 of the License, or (at your option) any later version.      *
 *                                                                         *
 *   This library  is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A DrawingICULAR PURPOSE.  See the         *
 *   GNU Library General Public License for more details.                  *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this library; see the file COPYING.LIB. If not,    *
 *   write to the Free Software Foundation, Inc., 59 Temple Place,         *
 *   Suite 330, Boston, MA  02111-1307, USA                                *
 *                                                                         *
 ***************************************************************************/


#include "PreCompiled.h"

#ifndef _PreComp_
# ifdef FC_OS_WIN32
#  include <windows.h>
# endif
#endif

/// Here the FreeCAD includes sorted by Base,App,Gui......
#include <Base/Console.h>
#include <Base/Parameter.h>
#include <Base/Exception.h>
#include <Base/Sequencer.h>
#include <App/Application.h>
#include <App/Document.h>
#include <App/DocumentObject.h>
#include <App/Feature.h>
#include <Gui/SoFCSelection.h>
#include <Gui/Selection.h>


#include "ViewProviderView.h"

//#include <Mod/Drawing/App/DrawingFeature.h>


//#include "Tree.h"



using namespace DrawingGui;

PROPERTY_SOURCE(DrawingGui::ViewProviderDrawingView, Gui::ViewProviderDocumentObject)


//**************************************************************************
// Construction/Destruction

       
ViewProviderDrawingView::ViewProviderDrawingView()
{


  sPixmap = "Page";

}

ViewProviderDrawingView::~ViewProviderDrawingView()
{
}


void ViewProviderDrawingView::attach(App::DocumentObject *pcFeat)
{
  // call parent attach method
  ViewProviderDocumentObject::attach(pcFeat);

 
}

void ViewProviderDrawingView::setDisplayMode(const char* ModeName)
{
 
  ViewProviderDocumentObject::setDisplayMode( ModeName );
}

std::vector<std::string> ViewProviderDrawingView::getDisplayModes(void) const
{
  // get the modes of the father
  std::vector<std::string> StrList = ViewProviderDocumentObject::getDisplayModes();

 
  return StrList;
}

void ViewProviderDrawingView::updateData(const App::Property*)
{


}


