type token =
  | IDENTIFIER of (string)
  | TYPENAME of (string)
  | STRING_LITERAL of (bool*string)
  | CONSTANT of (Logic_ptree.constant)
  | LPAR
  | RPAR
  | IF
  | ELSE
  | COLON
  | COLON2
  | COLONCOLON
  | DOT
  | DOTDOT
  | DOTDOTDOT
  | INT
  | INTEGER
  | REAL
  | FLOAT
  | LT
  | GT
  | LE
  | GE
  | EQ
  | NE
  | COMMA
  | ARROW
  | EQUAL
  | FORALL
  | EXISTS
  | IFF
  | IMPLIES
  | AND
  | OR
  | NOT
  | SEPARATED
  | TRUE
  | FALSE
  | OLD
  | AT
  | RESULT
  | BLOCK_LENGTH
  | BASE_ADDR
  | VALID
  | VALID_INDEX
  | VALID_RANGE
  | FRESH
  | DOLLAR
  | QUESTION
  | MINUS
  | PLUS
  | STAR
  | AMP
  | SLASH
  | PERCENT
  | LSQUARE
  | RSQUARE
  | EOF
  | GLOBAL
  | INVARIANT
  | VARIANT
  | DECREASES
  | FOR
  | LABEL
  | ASSERT
  | SEMICOLON
  | NULL
  | EMPTY
  | REQUIRES
  | ENSURES
  | ASSIGNS
  | LOOP
  | NOTHING
  | SLICE
  | IMPACT
  | PRAGMA
  | FROM
  | READS
  | LOGIC
  | PREDICATE
  | INDUCTIVE
  | AXIOMATIC
  | AXIOM
  | LEMMA
  | LBRACE
  | RBRACE
  | GHOST
  | CASE
  | VOID
  | CHAR
  | SIGNED
  | UNSIGNED
  | SHORT
  | LONG
  | DOUBLE
  | STRUCT
  | ENUM
  | UNION
  | BSUNION
  | INTER
  | LTCOLON
  | COLONGT
  | TYPE
  | BEHAVIOR
  | BEHAVIORS
  | ASSUMES
  | COMPLETE
  | DISJOINT
  | TERMINATES
  | HAT
  | HATHAT
  | PIPE
  | TILDE
  | GTGT
  | LTLT
  | SIZEOF
  | LAMBDA
  | TYPEOF
  | BSTYPE

open Parsing;;
# 27 "cil/src/logic/logic_parser.mly"

  open Cil
  open Cil_types
  open Logic_ptree
  open Logic_const
  open Logic_utils

  let loc () = (symbol_start_pos (), symbol_end_pos ())
  let loc_i i = (rhs_start i, rhs_end i)
  let info x = { lexpr_node = x; lexpr_loc = loc () }
  let loc_info loc x = { lexpr_node = x; lexpr_loc = loc }
  let loc_start x = fst x.lexpr_loc
  let loc_end x = snd x.lexpr_loc

  type sense_of_relation = Unknown | Equal | Disequal | Less | Greater

  let relation_sense rel sense =
    match rel, sense with
        Eq, _ -> sense, true
      | Neq, Unknown -> Disequal, true (* No chain of disequality for now*)
      | (Gt|Ge), (Unknown|Equal|Greater) -> Greater, true
      | (Lt|Le), (Unknown|Equal|Less) -> Less, true
      | _ -> sense, false

  let type_variables_stack = Stack.create ()

  let enter_type_variables_scope l =
    List.iter Logic_env.add_typename l;
    Stack.push l type_variables_stack

  let exit_type_variables_scope () =
    let l = Stack.pop type_variables_stack in
    List.iter Logic_env.remove_typename l

  let rt_type = ref false

  let set_rt_type () = rt_type:= true

  let reset_rt_type () = rt_type:=false

  let is_rt_type () = !rt_type

# 166 "cil/src/logic/logic_parser.ml"
let yytransl_const = [|
  261 (* LPAR *);
  262 (* RPAR *);
  263 (* IF *);
  264 (* ELSE *);
  265 (* COLON *);
  266 (* COLON2 *);
  267 (* COLONCOLON *);
  268 (* DOT *);
  269 (* DOTDOT *);
  270 (* DOTDOTDOT *);
  271 (* INT *);
  272 (* INTEGER *);
  273 (* REAL *);
  274 (* FLOAT *);
  275 (* LT *);
  276 (* GT *);
  277 (* LE *);
  278 (* GE *);
  279 (* EQ *);
  280 (* NE *);
  281 (* COMMA *);
  282 (* ARROW *);
  283 (* EQUAL *);
  284 (* FORALL *);
  285 (* EXISTS *);
  286 (* IFF *);
  287 (* IMPLIES *);
  288 (* AND *);
  289 (* OR *);
  290 (* NOT *);
  291 (* SEPARATED *);
  292 (* TRUE *);
  293 (* FALSE *);
  294 (* OLD *);
  295 (* AT *);
  296 (* RESULT *);
  297 (* BLOCK_LENGTH *);
  298 (* BASE_ADDR *);
  299 (* VALID *);
  300 (* VALID_INDEX *);
  301 (* VALID_RANGE *);
  302 (* FRESH *);
  303 (* DOLLAR *);
  304 (* QUESTION *);
  305 (* MINUS *);
  306 (* PLUS *);
  307 (* STAR *);
  308 (* AMP *);
  309 (* SLASH *);
  310 (* PERCENT *);
  311 (* LSQUARE *);
  312 (* RSQUARE *);
    0 (* EOF *);
  313 (* GLOBAL *);
  314 (* INVARIANT *);
  315 (* VARIANT *);
  316 (* DECREASES *);
  317 (* FOR *);
  318 (* LABEL *);
  319 (* ASSERT *);
  320 (* SEMICOLON *);
  321 (* NULL *);
  322 (* EMPTY *);
  323 (* REQUIRES *);
  324 (* ENSURES *);
  325 (* ASSIGNS *);
  326 (* LOOP *);
  327 (* NOTHING *);
  328 (* SLICE *);
  329 (* IMPACT *);
  330 (* PRAGMA *);
  331 (* FROM *);
  332 (* READS *);
  333 (* LOGIC *);
  334 (* PREDICATE *);
  335 (* INDUCTIVE *);
  336 (* AXIOMATIC *);
  337 (* AXIOM *);
  338 (* LEMMA *);
  339 (* LBRACE *);
  340 (* RBRACE *);
  341 (* GHOST *);
  342 (* CASE *);
  343 (* VOID *);
  344 (* CHAR *);
  345 (* SIGNED *);
  346 (* UNSIGNED *);
  347 (* SHORT *);
  348 (* LONG *);
  349 (* DOUBLE *);
  350 (* STRUCT *);
  351 (* ENUM *);
  352 (* UNION *);
  353 (* BSUNION *);
  354 (* INTER *);
  355 (* LTCOLON *);
  356 (* COLONGT *);
  357 (* TYPE *);
  358 (* BEHAVIOR *);
  359 (* BEHAVIORS *);
  360 (* ASSUMES *);
  361 (* COMPLETE *);
  362 (* DISJOINT *);
  363 (* TERMINATES *);
  364 (* HAT *);
  365 (* HATHAT *);
  366 (* PIPE *);
  367 (* TILDE *);
  368 (* GTGT *);
  369 (* LTLT *);
  370 (* SIZEOF *);
  371 (* LAMBDA *);
  372 (* TYPEOF *);
  373 (* BSTYPE *);
    0|]

let yytransl_block = [|
  257 (* IDENTIFIER *);
  258 (* TYPENAME *);
  259 (* STRING_LITERAL *);
  260 (* CONSTANT *);
    0|]

let yylhs = "\255\255\
\004\000\005\000\006\000\007\000\008\000\009\000\010\000\010\000\
\011\000\011\000\012\000\012\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\015\000\015\000\023\000\023\000\023\000\023\000\023\000\023\000\
\017\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\014\000\
\014\000\024\000\024\000\022\000\025\000\025\000\025\000\026\000\
\027\000\027\000\028\000\028\000\028\000\028\000\030\000\030\000\
\030\000\031\000\031\000\032\000\034\000\035\000\035\000\033\000\
\033\000\018\000\037\000\037\000\036\000\036\000\038\000\038\000\
\038\000\038\000\038\000\038\000\040\000\040\000\029\000\029\000\
\039\000\039\000\021\000\021\000\021\000\021\000\021\000\021\000\
\021\000\021\000\021\000\021\000\021\000\021\000\021\000\021\000\
\021\000\021\000\021\000\021\000\021\000\021\000\021\000\021\000\
\021\000\021\000\021\000\021\000\021\000\021\000\021\000\021\000\
\021\000\021\000\021\000\041\000\041\000\042\000\043\000\044\000\
\045\000\046\000\047\000\048\000\049\000\050\000\050\000\052\000\
\052\000\053\000\053\000\054\000\054\000\054\000\055\000\055\000\
\056\000\056\000\058\000\057\000\059\000\059\000\060\000\060\000\
\060\000\003\000\062\000\062\000\062\000\062\000\062\000\062\000\
\062\000\063\000\064\000\064\000\064\000\064\000\064\000\066\000\
\066\000\070\000\071\000\071\000\065\000\068\000\061\000\061\000\
\072\000\072\000\072\000\072\000\072\000\075\000\069\000\076\000\
\073\000\073\000\074\000\074\000\067\000\051\000\051\000\051\000\
\077\000\078\000\078\000\079\000\080\000\080\000\081\000\082\000\
\082\000\082\000\016\000\084\000\084\000\085\000\086\000\086\000\
\086\000\086\000\087\000\087\000\087\000\087\000\087\000\087\000\
\088\000\088\000\088\000\090\000\090\000\092\000\092\000\092\000\
\092\000\092\000\093\000\093\000\091\000\091\000\091\000\091\000\
\094\000\094\000\095\000\095\000\096\000\096\000\089\000\089\000\
\020\000\020\000\083\000\083\000\019\000\002\000\098\000\098\000\
\097\000\097\000\097\000\097\000\097\000\099\000\099\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
\000\000\000\000\000\000"

let yylen = "\002\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\001\000\003\000\001\000\002\000\001\000\002\000\001\000\001\000\
\004\000\006\000\008\000\004\000\001\000\001\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\004\000\004\000\002\000\
\002\000\002\000\002\000\002\000\004\000\004\000\004\000\006\000\
\004\000\004\000\001\000\004\000\004\000\007\000\004\000\001\000\
\003\000\003\000\003\000\003\000\004\000\003\000\003\000\003\000\
\004\000\005\000\001\000\004\000\004\000\005\000\007\000\007\000\
\001\000\002\000\001\000\001\000\001\000\001\000\001\000\001\000\
\003\000\003\000\003\000\003\000\003\000\003\000\004\000\004\000\
\004\000\003\000\003\000\003\000\005\000\003\000\001\000\002\000\
\003\000\000\000\001\000\001\000\001\000\003\000\003\000\002\000\
\001\000\002\000\001\000\004\000\003\000\004\000\000\000\001\000\
\003\000\001\000\003\000\001\000\001\000\001\000\003\000\002\000\
\002\000\002\000\001\000\003\000\000\000\001\000\001\000\001\000\
\002\000\002\000\003\000\002\000\003\000\004\000\001\000\002\000\
\003\000\004\000\001\000\001\000\001\000\001\000\002\000\002\000\
\001\000\002\000\002\000\001\000\001\000\002\000\002\000\001\000\
\002\000\002\000\003\000\002\000\003\000\002\000\003\000\003\000\
\003\000\004\000\004\000\001\000\001\000\002\000\003\000\003\000\
\003\000\001\000\006\000\001\000\004\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\001\000\001\000\000\000\
\004\000\000\000\001\000\004\000\004\000\004\000\000\000\005\000\
\003\000\001\000\002\000\003\000\001\000\003\000\000\000\005\000\
\005\000\004\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\002\000\002\000\004\000\002\000\002\000\000\000\
\001\000\009\000\003\000\001\000\004\000\004\000\000\000\003\000\
\001\000\001\000\006\000\003\000\003\000\002\000\004\000\002\000\
\004\000\003\000\005\000\004\000\004\000\001\000\003\000\003\000\
\001\000\001\000\003\000\001\000\001\000\004\000\001\000\001\000\
\004\000\007\000\001\000\000\000\001\000\003\000\001\000\001\000\
\006\000\001\000\007\000\006\000\006\000\005\000\005\000\005\000\
\005\000\004\000\003\000\000\000\002\000\001\000\006\000\005\000\
\003\000\005\000\000\000\002\000\000\000\001\000\001\000\002\000\
\002\000\003\000\001\000\004\000\001\000\003\000\000\000\006\000\
\001\000\003\000\001\000\003\000\001\000\002\000\001\000\002\000\
\001\000\002\000\001\000\001\000\001\000\001\000\002\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\002\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\243\000\065\000\022\000\000\000\
\000\000\000\000\000\000\000\000\015\000\016\000\000\000\000\000\
\043\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\021\000\059\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\087\000\000\000\
\000\000\000\000\037\001\000\000\001\000\199\000\001\000\001\000\
\195\000\197\000\198\000\000\000\000\000\000\000\001\000\001\000\
\001\000\000\000\001\000\000\000\196\000\201\000\200\000\154\001\
\000\000\035\001\202\000\000\000\000\000\000\000\000\000\250\000\
\036\001\217\000\218\000\000\000\000\000\000\000\247\000\248\000\
\000\000\033\001\001\000\155\001\000\000\000\000\137\000\131\000\
\132\000\156\000\133\000\134\000\000\000\000\000\141\000\000\000\
\157\000\004\000\004\000\004\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\093\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\067\000\
\068\000\069\000\070\000\071\000\072\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\012\000\000\000\066\000\000\000\000\000\001\000\001\000\000\000\
\000\000\000\000\000\000\000\000\000\000\001\000\001\000\001\000\
\222\000\224\000\000\000\000\000\001\000\000\000\240\000\000\000\
\000\000\000\000\000\000\001\000\000\000\000\000\000\000\040\001\
\042\001\041\001\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\064\001\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\152\001\074\001\075\001\076\001\077\001\078\001\079\001\
\080\001\081\001\082\001\083\001\084\001\085\001\086\001\087\001\
\088\001\089\001\090\001\091\001\092\001\093\001\094\001\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\102\001\103\001\
\104\001\105\001\106\001\107\001\108\001\109\001\110\001\111\001\
\112\001\113\001\114\001\115\001\116\001\117\001\118\001\119\001\
\120\001\121\001\122\001\123\001\124\001\125\001\126\001\127\001\
\128\001\129\001\130\001\131\001\132\001\133\001\134\001\135\001\
\136\001\146\001\137\001\145\001\147\001\148\001\138\001\139\001\
\140\001\141\001\142\001\143\001\144\001\149\001\150\001\151\001\
\034\001\000\000\001\000\209\000\203\000\204\000\206\000\207\000\
\001\000\000\000\032\001\030\001\000\000\001\000\001\000\001\000\
\000\000\179\000\000\000\000\000\003\000\138\000\135\000\142\000\
\000\000\139\000\136\000\143\000\000\000\148\000\000\000\158\000\
\000\000\000\000\000\000\051\000\052\000\000\000\000\000\127\000\
\000\000\000\000\114\000\118\000\119\000\000\000\000\000\000\000\
\099\000\096\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\008\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\082\000\000\000\000\000\000\000\029\000\028\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\055\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\221\000\002\000\001\000\000\000\220\000\000\000\000\000\
\000\000\000\000\000\000\000\000\115\000\000\000\002\000\000\000\
\001\000\001\000\001\000\000\000\245\000\000\000\000\000\001\000\
\000\000\003\001\000\000\039\001\000\000\000\000\000\000\226\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\187\000\000\000\000\000\000\000\000\000\147\000\000\000\149\000\
\000\000\153\000\159\000\160\000\161\000\000\000\000\000\000\000\
\000\000\128\000\121\000\000\000\000\000\124\000\073\000\000\000\
\000\000\000\000\000\000\000\000\094\000\095\000\000\000\000\000\
\045\000\039\000\001\000\042\000\041\000\017\000\000\000\000\000\
\020\000\000\000\000\000\060\000\061\000\037\000\038\000\000\000\
\057\000\000\000\000\000\031\000\030\000\089\000\044\000\000\000\
\001\000\001\000\166\000\167\000\190\000\001\000\205\000\213\000\
\001\000\214\000\175\000\000\000\002\000\174\000\000\000\233\000\
\000\000\229\000\228\000\000\000\006\000\172\000\000\000\000\000\
\000\000\029\001\000\000\000\000\000\000\001\000\002\001\000\000\
\001\000\001\000\001\000\001\000\006\001\000\000\000\000\000\000\
\001\000\001\000\000\000\000\000\014\001\000\000\000\000\002\000\
\223\000\225\000\177\000\000\000\000\000\000\000\000\000\185\000\
\000\000\001\000\001\000\001\000\194\000\000\000\000\000\154\000\
\155\000\125\000\000\000\123\000\109\000\000\000\000\000\000\000\
\106\000\108\000\000\000\101\000\000\000\000\000\010\000\000\000\
\000\000\000\000\000\000\000\000\062\000\058\000\000\000\000\000\
\026\001\000\000\000\000\211\000\173\000\000\000\000\000\227\000\
\116\000\001\000\001\001\238\000\001\000\000\000\000\000\002\000\
\246\000\000\000\001\000\000\000\001\000\000\000\000\000\000\000\
\255\000\005\001\254\000\000\000\000\000\000\000\001\000\000\001\
\016\001\170\000\181\000\182\000\180\000\188\000\000\000\000\000\
\000\000\000\000\003\000\004\000\130\000\112\000\126\000\000\000\
\113\000\102\000\100\000\040\000\018\000\000\000\000\000\000\000\
\000\000\249\000\219\000\232\000\231\000\235\000\000\000\028\001\
\001\000\000\000\168\000\252\000\000\000\253\000\000\000\000\000\
\001\000\009\001\002\000\000\000\018\001\000\000\000\000\000\000\
\000\000\000\000\000\000\216\000\000\000\163\000\105\000\107\000\
\000\000\064\000\063\000\046\000\251\000\000\000\111\000\000\000\
\000\000\000\000\000\000\000\000\169\000\001\000\002\000\001\000\
\020\001\184\000\192\000\193\000\165\000\019\000\242\000\000\000\
\000\000\012\001\008\001\010\001\000\000\171\000\022\001\000\000\
\007\001\210\000\024\001"

let yydgoto = "\004\000\
\104\001\064\000\084\000\170\000\251\001\197\001\081\001\166\001\
\089\002\116\001\117\001\039\000\040\000\161\000\041\000\042\000\
\102\000\054\002\017\002\150\001\104\000\107\000\162\000\105\000\
\108\000\109\000\098\001\099\001\100\001\063\002\064\002\065\002\
\066\002\067\002\096\002\091\001\167\001\092\001\093\001\094\001\
\055\002\160\001\182\000\021\002\109\002\183\001\159\002\181\000\
\163\001\005\002\006\002\085\000\065\001\066\001\193\001\067\001\
\191\001\068\001\172\000\196\001\053\002\065\000\066\000\052\001\
\068\000\255\001\069\000\070\000\071\000\072\000\161\001\073\000\
\074\000\075\000\076\000\077\000\007\002\008\002\009\002\183\000\
\191\000\184\000\019\002\172\001\173\001\078\000\079\000\080\000\
\100\002\030\002\036\002\031\002\179\002\037\002\038\002\160\002\
\081\000\082\000\049\001\050\001"

let yysindex = "\150\001\
\213\014\177\015\243\254\000\000\000\000\000\000\000\000\100\013\
\146\006\146\006\125\015\043\255\000\000\000\000\065\255\067\255\
\000\000\073\255\087\255\091\255\175\255\177\255\179\255\125\015\
\125\015\125\015\125\015\000\000\000\000\213\014\194\255\215\255\
\125\015\040\000\146\006\049\000\053\000\242\014\000\000\210\013\
\063\255\064\255\000\000\115\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\005\255\244\255\247\255\000\000\000\000\
\000\000\077\000\000\000\026\000\000\000\000\000\000\000\000\000\
\239\012\000\000\000\000\016\255\016\255\016\255\016\255\000\000\
\000\000\000\000\000\000\086\000\089\000\216\000\000\000\000\000\
\096\001\000\000\000\000\000\000\008\000\079\000\000\000\000\000\
\000\000\000\000\000\000\000\000\020\255\170\255\000\000\079\255\
\000\000\000\000\000\000\000\000\052\255\109\000\110\000\158\255\
\106\000\054\255\063\000\104\000\000\000\067\000\095\255\082\255\
\213\014\213\014\213\014\213\014\213\014\213\014\213\014\213\014\
\213\014\095\255\095\255\095\255\095\255\138\011\213\014\213\014\
\095\255\100\013\071\000\213\014\146\006\213\014\213\014\213\014\
\213\014\213\014\213\014\213\014\213\014\213\014\077\000\000\000\
\000\000\000\000\000\000\000\000\000\000\077\000\125\015\125\015\
\125\015\125\015\125\015\213\014\125\015\203\013\125\015\125\015\
\000\000\125\015\000\000\213\014\213\014\000\000\000\000\213\014\
\084\000\077\000\130\000\147\000\098\000\000\000\000\000\000\000\
\000\000\000\000\162\000\164\000\000\000\023\255\000\000\171\000\
\171\000\096\000\158\000\000\000\150\000\116\000\157\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\239\012\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\119\000\000\000\000\000\123\000\000\000\000\000\000\000\
\081\000\000\000\102\000\100\255\000\000\000\000\000\000\000\000\
\007\255\000\000\000\000\000\000\061\255\000\000\190\000\000\000\
\077\000\077\000\077\000\000\000\000\000\125\015\158\255\000\000\
\213\014\191\255\000\000\000\000\000\000\186\255\213\014\054\255\
\000\000\000\000\195\255\038\000\213\014\097\014\213\014\179\002\
\200\000\197\255\033\004\050\001\247\001\143\004\172\005\251\006\
\166\004\077\000\100\013\203\000\000\000\204\000\215\004\205\000\
\213\014\064\005\163\000\146\255\146\255\123\255\049\255\156\255\
\000\000\161\000\160\255\183\255\000\000\000\000\185\255\185\255\
\095\255\095\255\095\255\214\001\159\000\095\255\095\255\000\000\
\022\002\022\002\210\013\214\000\242\014\137\000\198\000\218\000\
\242\014\000\000\000\000\000\000\003\000\000\000\170\000\174\000\
\173\000\045\014\175\000\176\000\000\000\146\006\000\000\171\000\
\000\000\000\000\000\000\252\255\000\000\155\000\118\000\000\000\
\236\000\000\000\133\000\000\000\235\000\213\014\181\000\000\000\
\183\000\243\254\184\000\186\000\188\000\213\014\008\000\000\000\
\000\000\152\000\153\000\206\000\146\006\000\000\249\000\000\000\
\252\000\000\000\000\000\000\000\000\000\095\255\006\001\242\014\
\215\000\000\000\000\000\186\255\090\006\000\000\000\000\008\001\
\090\006\213\014\195\255\242\014\000\000\000\000\242\014\213\014\
\000\000\000\000\000\000\000\000\000\000\000\000\213\014\213\014\
\000\000\247\000\237\254\000\000\000\000\000\000\000\000\242\014\
\000\000\013\001\213\014\000\000\000\000\000\000\000\000\017\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\242\014\000\000\000\000\207\000\000\000\
\254\000\000\000\000\000\219\000\000\000\000\000\021\000\004\001\
\009\001\000\000\213\000\090\006\025\001\000\000\000\000\217\000\
\000\000\000\000\000\000\000\000\000\000\221\000\118\000\225\000\
\000\000\000\000\038\001\237\000\000\000\133\000\016\255\000\000\
\000\000\000\000\000\000\008\000\008\000\008\000\235\011\000\000\
\035\001\000\000\000\000\000\000\000\000\021\001\030\001\000\000\
\000\000\000\000\255\000\000\000\000\000\054\255\049\001\032\001\
\000\000\000\000\054\255\000\000\054\001\007\001\000\000\056\001\
\069\005\082\007\213\014\213\014\000\000\000\000\242\014\213\014\
\000\000\001\001\002\001\000\000\000\000\129\014\213\014\000\000\
\000\000\000\000\000\000\000\000\000\000\052\001\043\001\000\000\
\000\000\005\001\000\000\245\000\000\000\171\000\067\001\024\001\
\000\000\000\000\000\000\090\006\071\001\133\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\008\000\026\001\
\027\001\028\001\000\000\000\000\000\000\000\000\000\000\042\006\
\000\000\000\000\000\000\000\000\000\000\213\014\093\014\176\014\
\083\001\000\000\000\000\000\000\000\000\000\000\029\001\000\000\
\000\000\090\006\000\000\000\000\085\001\000\000\171\000\025\000\
\000\000\000\000\000\000\069\001\000\000\146\006\072\001\093\001\
\102\000\100\255\100\255\000\000\146\006\000\000\000\000\000\000\
\100\005\000\000\000\000\000\000\000\000\080\001\000\000\213\014\
\034\000\213\014\037\001\039\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\088\014\
\040\001\000\000\000\000\000\000\041\001\000\000\000\000\217\000\
\000\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\156\000\000\000\000\000\000\000\000\000\094\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\106\002\000\000\009\012\
\029\005\137\005\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\108\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\108\002\108\002\108\002\108\002\000\000\
\000\000\000\000\000\000\000\000\000\000\110\002\000\000\000\000\
\000\000\000\000\000\000\000\000\031\000\180\004\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\175\001\000\000\032\002\
\000\000\000\000\000\000\000\000\099\001\000\000\000\000\045\007\
\000\000\000\000\000\000\239\254\000\000\000\000\223\007\137\005\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\008\100\008\166\008\232\008\000\000\110\001\110\001\
\044\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\094\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\034\255\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\249\006\000\000\006\000\000\000\044\000\
\000\000\000\000\000\000\000\000\047\000\087\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\118\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\041\015\000\000\000\000\000\000\000\000\000\000\000\000\
\068\000\000\000\037\000\009\000\000\000\000\000\000\000\000\000\
\142\002\000\000\000\000\000\000\252\002\000\000\106\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\073\001\150\007\000\000\000\000\000\000\000\000\204\255\000\000\
\000\000\000\000\168\255\000\000\000\000\000\000\000\000\038\255\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\003\001\107\001\130\012\011\000\000\000\
\000\000\093\000\207\001\090\012\000\000\000\000\254\010\064\011\
\111\009\177\009\243\009\099\001\000\000\053\010\120\010\000\000\
\131\011\197\011\049\012\000\000\109\001\000\000\019\255\000\000\
\248\254\000\000\000\000\000\000\108\002\000\000\000\000\061\001\
\000\000\000\000\000\000\041\015\000\000\000\000\000\000\044\000\
\000\000\000\000\000\000\000\000\000\000\000\000\044\001\000\000\
\000\000\000\000\045\255\000\000\000\000\000\000\000\000\000\000\
\000\000\156\000\000\000\000\000\000\000\000\000\080\000\000\000\
\000\000\000\000\000\000\127\002\000\000\000\000\216\003\000\000\
\070\004\000\000\000\000\000\000\000\000\188\010\000\000\007\000\
\000\000\000\000\000\000\242\005\124\001\000\000\000\000\000\000\
\124\001\073\001\219\255\124\002\000\000\000\000\234\002\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\059\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\091\006\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\238\255\000\000\000\000\074\001\000\000\
\252\254\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\051\001\000\000\000\000\000\000\000\000\000\000\000\000\053\001\
\000\000\000\000\000\000\000\000\000\000\000\000\044\001\000\000\
\000\000\000\000\229\255\000\000\000\000\075\001\108\002\000\000\
\000\000\000\000\000\000\031\000\031\000\031\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\116\001\000\000\000\000\
\000\000\000\000\196\006\000\000\000\000\000\000\000\000\135\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\169\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\029\000\138\001\000\000\
\000\000\000\000\000\000\000\000\000\000\028\000\000\000\087\001\
\000\000\000\000\000\000\000\000\000\000\081\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\080\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\028\000\082\001\
\000\000\000\000\000\000\000\000\000\000\000\000\142\001\000\000\
\037\000\009\000\009\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\082\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\053\001\
\000\000\000\000\000\000"

let yygindex = "\000\000\
\255\255\000\000\000\000\224\255\141\254\030\000\161\255\000\000\
\000\000\021\002\153\255\000\000\006\005\010\001\000\000\064\000\
\254\001\249\255\185\000\102\254\015\000\254\255\000\000\187\254\
\000\000\060\001\181\254\064\001\166\255\208\000\000\000\039\000\
\037\254\000\000\020\000\000\000\000\000\091\001\198\254\084\001\
\014\000\214\255\002\000\000\000\000\000\000\000\000\000\165\000\
\120\001\000\000\000\000\000\001\082\254\000\000\041\000\000\000\
\000\000\000\000\224\254\174\254\000\000\000\000\000\000\187\002\
\000\000\122\001\000\000\000\000\000\000\000\000\151\000\000\000\
\000\000\000\000\000\000\000\000\125\000\203\253\000\000\198\255\
\000\000\227\255\111\000\100\254\024\002\000\000\099\254\000\000\
\012\000\187\000\000\000\000\000\042\000\000\254\180\000\032\000\
\000\000\137\002\171\001\000\000"

let yytablesize = 4380
let yytable = "\038\000\
\103\000\190\000\169\000\082\001\083\001\173\000\101\000\110\000\
\191\000\105\001\076\000\015\002\168\000\090\001\016\002\168\000\
\048\002\029\002\181\001\209\001\216\001\198\001\180\000\106\000\
\106\000\215\001\222\001\185\000\126\000\187\000\178\000\211\001\
\131\000\142\002\070\001\214\001\183\000\113\002\025\001\252\001\
\061\001\169\001\189\000\009\000\076\002\001\000\092\000\113\000\
\171\000\106\000\168\000\014\002\002\000\083\000\005\000\002\000\
\095\002\084\001\096\001\234\000\148\001\189\000\174\000\175\000\
\077\002\163\000\092\000\186\000\164\000\114\000\234\000\115\000\
\165\000\176\000\112\000\200\001\051\001\116\000\177\000\178\000\
\136\000\134\000\135\000\136\000\137\000\052\000\164\000\112\000\
\112\000\112\000\112\000\117\000\084\000\078\001\081\002\118\000\
\112\000\189\000\199\001\138\000\139\000\009\000\025\001\139\000\
\088\001\170\001\143\000\071\001\013\001\157\002\072\001\073\001\
\106\001\107\001\108\001\109\001\110\001\111\001\112\001\113\001\
\150\000\186\000\120\001\253\001\194\002\115\002\116\002\117\002\
\119\001\029\002\122\001\159\001\124\001\125\001\126\001\127\001\
\128\001\129\001\130\001\131\001\132\001\168\000\168\000\162\001\
\155\002\085\002\166\000\123\001\070\002\156\000\144\001\168\001\
\201\001\060\002\140\001\176\000\140\000\141\000\142\000\140\000\
\141\000\142\000\087\001\149\001\166\000\243\001\153\001\151\001\
\152\001\097\001\079\001\080\001\167\000\097\000\139\000\134\000\
\135\000\136\000\137\000\119\000\114\002\120\000\095\002\121\000\
\074\001\134\000\135\000\136\000\137\000\177\001\213\001\136\000\
\097\000\157\000\158\000\087\001\143\000\139\000\127\000\217\001\
\161\002\152\002\226\001\138\000\194\001\195\001\133\001\139\000\
\088\001\090\000\150\000\139\000\089\001\134\001\112\000\112\000\
\112\000\112\000\112\000\128\000\112\000\112\000\112\000\112\000\
\098\000\112\000\134\000\135\000\136\000\137\000\140\000\097\000\
\142\000\155\001\139\000\153\000\147\002\154\000\155\000\156\000\
\089\001\210\001\126\002\098\000\138\000\089\001\174\002\129\002\
\139\000\218\001\177\002\097\000\090\001\140\000\141\000\142\000\
\125\002\075\001\075\000\090\000\076\001\077\001\236\000\140\000\
\141\000\142\000\237\000\140\000\091\000\142\000\237\000\185\001\
\076\000\120\002\121\002\187\001\076\000\189\001\022\002\076\000\
\182\001\168\000\098\000\157\000\158\000\168\000\162\001\168\000\
\237\000\241\000\140\000\076\000\019\001\241\000\005\000\181\002\
\076\000\076\000\096\001\076\000\130\000\236\000\098\000\090\002\
\140\000\141\000\142\000\022\002\171\000\132\000\244\000\241\000\
\236\000\133\000\076\000\023\002\090\002\178\000\091\000\051\001\
\179\000\254\001\076\000\198\002\191\000\237\000\244\000\076\000\
\052\000\237\000\076\000\062\001\063\001\005\000\040\002\187\002\
\188\002\237\000\019\001\188\000\091\002\076\000\057\001\208\001\
\210\001\058\001\178\000\244\000\241\000\208\001\076\000\060\001\
\183\000\069\001\084\000\220\001\178\002\223\001\084\000\244\000\
\241\000\084\000\074\000\244\000\086\000\178\002\237\000\064\001\
\235\001\132\001\085\001\086\001\106\000\084\000\095\001\240\001\
\071\002\012\002\084\000\084\000\084\000\084\000\101\001\186\000\
\102\001\106\000\103\001\168\000\178\000\032\002\121\001\178\000\
\178\000\178\000\020\002\178\000\084\000\183\000\183\000\168\000\
\203\001\204\001\205\001\154\001\084\000\112\000\001\000\002\000\
\003\000\084\000\156\001\157\001\084\000\171\000\013\002\097\001\
\004\002\158\001\164\001\097\001\165\001\097\001\176\001\084\000\
\169\001\186\000\151\001\018\002\186\000\186\000\140\000\171\001\
\084\000\234\001\175\001\178\001\035\002\178\000\184\001\179\001\
\178\000\178\000\186\001\190\001\047\002\053\001\054\001\055\001\
\056\001\049\002\025\002\026\002\057\000\058\000\027\002\059\000\
\084\000\084\000\084\000\192\001\202\001\225\001\078\000\082\002\
\236\001\237\001\239\001\083\002\139\000\242\001\245\001\176\000\
\208\001\168\000\028\002\247\001\248\001\168\000\249\001\176\000\
\176\000\104\002\250\001\062\002\018\002\073\002\074\002\062\002\
\137\002\000\002\001\002\098\002\002\002\024\002\010\002\011\002\
\033\002\079\002\034\002\039\002\041\002\168\000\042\002\044\002\
\180\000\045\002\151\001\046\002\102\002\103\002\050\002\051\002\
\108\002\176\000\084\002\176\000\176\000\176\000\176\000\056\002\
\075\000\052\002\057\002\058\002\075\000\068\002\059\002\075\000\
\044\000\075\002\078\002\168\000\061\002\080\002\087\002\092\002\
\061\002\086\002\088\002\075\000\166\002\189\000\097\002\144\000\
\107\002\093\002\062\002\035\002\055\000\056\000\057\000\058\000\
\094\002\059\000\111\002\119\002\112\002\123\002\099\002\143\002\
\105\002\124\002\075\000\171\000\171\000\089\001\127\002\228\001\
\128\002\168\000\075\000\130\002\060\000\132\002\131\002\075\000\
\138\002\139\002\075\000\146\002\148\002\149\002\145\002\151\002\
\150\002\135\002\136\002\153\002\156\002\075\000\158\002\134\000\
\135\000\136\000\137\000\061\002\004\002\004\002\075\000\154\002\
\172\002\162\002\163\002\164\002\173\002\176\002\018\002\182\002\
\184\002\138\000\185\002\191\002\195\002\139\000\196\002\201\002\
\202\002\153\001\090\000\208\000\001\000\031\001\180\002\091\000\
\074\000\239\000\086\000\007\000\074\000\038\001\086\000\074\000\
\168\000\086\000\062\002\079\000\212\000\097\001\215\000\004\001\
\090\000\103\000\097\001\074\000\169\002\086\000\027\001\164\000\
\023\001\230\000\015\001\197\002\104\000\145\000\062\002\110\000\
\017\001\011\001\151\001\021\001\118\001\168\000\183\002\158\002\
\165\002\141\001\074\000\072\002\246\001\140\000\141\000\142\000\
\062\002\221\001\074\000\219\001\086\000\175\002\168\002\074\000\
\069\002\086\000\074\000\061\002\086\000\212\001\192\002\140\000\
\004\002\207\001\189\002\140\000\140\000\074\000\188\001\086\000\
\140\000\043\002\140\000\140\000\067\000\101\002\074\000\061\002\
\086\000\140\000\140\000\140\000\140\000\140\000\140\000\140\000\
\140\000\186\002\122\002\144\002\140\000\140\000\140\000\140\000\
\174\001\061\002\141\002\203\002\078\000\110\002\059\001\199\002\
\078\000\106\002\193\002\078\000\180\001\000\000\140\000\140\000\
\140\000\140\000\140\000\140\000\140\000\140\000\140\000\078\000\
\000\000\080\000\000\000\140\000\078\000\078\000\140\000\078\000\
\000\000\000\000\000\000\134\000\135\000\136\000\137\000\000\000\
\000\000\140\000\000\000\146\000\229\001\000\000\078\000\000\000\
\000\000\000\000\140\000\000\000\000\000\138\000\078\000\000\000\
\000\000\139\000\000\000\078\000\000\000\244\001\078\000\000\000\
\000\000\140\000\140\000\000\000\134\000\135\000\136\000\137\000\
\000\000\078\000\140\000\140\000\140\000\000\000\140\000\140\000\
\144\000\143\000\078\000\000\000\144\000\144\000\138\000\000\000\
\000\000\144\000\139\000\144\000\144\000\000\000\000\000\150\000\
\000\000\000\000\144\000\144\000\144\000\144\000\144\000\144\000\
\144\000\144\000\081\000\078\000\000\000\144\000\144\000\144\000\
\144\000\140\000\141\000\142\000\000\000\000\000\151\000\152\000\
\153\000\000\000\154\000\155\000\156\000\000\000\000\000\144\000\
\144\000\144\000\144\000\144\000\144\000\144\000\144\000\144\000\
\000\000\000\000\000\000\000\000\144\000\000\000\000\000\144\000\
\000\000\000\000\140\000\141\000\142\000\000\000\000\000\000\000\
\000\000\150\000\144\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\144\000\000\000\000\000\000\000\000\000\
\157\000\158\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\079\000\144\000\144\000\000\000\079\000\000\000\000\000\
\079\000\000\000\000\000\144\000\144\000\144\000\145\000\144\000\
\144\000\000\000\145\000\145\000\079\000\000\000\000\000\145\000\
\000\000\145\000\145\000\000\000\000\000\000\000\000\000\000\000\
\145\000\145\000\145\000\145\000\145\000\145\000\145\000\145\000\
\085\000\000\000\000\000\145\000\145\000\145\000\145\000\000\000\
\000\000\000\000\000\000\079\000\000\000\000\000\000\000\000\000\
\079\000\000\000\000\000\079\000\000\000\145\000\145\000\145\000\
\145\000\145\000\145\000\145\000\145\000\145\000\079\000\000\000\
\000\000\000\000\145\000\224\001\000\000\145\000\000\000\079\000\
\134\000\135\000\136\000\137\000\000\000\000\000\000\000\151\000\
\145\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\145\000\138\000\000\000\000\000\000\000\139\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\080\000\
\145\000\145\000\000\000\080\000\000\000\000\000\080\000\000\000\
\000\000\145\000\145\000\145\000\146\000\145\000\145\000\000\000\
\146\000\146\000\080\000\000\000\000\000\146\000\000\000\146\000\
\146\000\000\000\000\000\000\000\000\000\000\000\146\000\146\000\
\146\000\146\000\146\000\146\000\146\000\146\000\000\000\000\000\
\000\000\146\000\146\000\146\000\146\000\000\000\140\000\141\000\
\142\000\080\000\000\000\000\000\000\000\000\000\080\000\000\000\
\000\000\080\000\000\000\146\000\146\000\146\000\146\000\146\000\
\146\000\146\000\146\000\146\000\080\000\000\000\000\000\000\000\
\146\000\000\000\000\000\146\000\000\000\080\000\000\000\000\000\
\081\000\000\000\000\000\000\000\081\000\152\000\146\000\081\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\146\000\
\000\000\000\000\000\000\081\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\146\000\146\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\146\000\
\146\000\146\000\150\000\146\000\146\000\000\000\150\000\150\000\
\000\000\000\000\081\000\150\000\000\000\150\000\150\000\081\000\
\000\000\000\000\081\000\000\000\150\000\150\000\150\000\150\000\
\150\000\150\000\150\000\150\000\000\000\081\000\000\000\150\000\
\150\000\150\000\150\000\000\000\000\000\000\000\081\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\150\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\150\000\000\000\000\000\000\000\000\000\150\000\000\000\
\000\000\150\000\000\000\000\000\000\000\000\000\085\000\000\000\
\000\000\000\000\085\000\162\000\150\000\085\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\150\000\000\000\000\000\
\000\000\085\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\150\000\150\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\150\000\150\000\150\000\
\151\000\150\000\150\000\000\000\151\000\151\000\000\000\000\000\
\085\000\151\000\000\000\151\000\151\000\085\000\000\000\000\000\
\085\000\000\000\151\000\151\000\151\000\151\000\151\000\151\000\
\151\000\151\000\000\000\085\000\000\000\151\000\151\000\151\000\
\151\000\000\000\000\000\000\000\085\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\151\000\
\151\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
\111\000\000\000\000\000\000\000\151\000\000\000\000\000\151\000\
\000\000\000\000\000\000\000\000\013\000\122\000\123\000\124\000\
\125\000\000\000\151\000\000\000\000\000\000\000\129\000\000\000\
\000\000\000\000\000\000\151\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\227\001\151\000\151\000\000\000\000\000\134\000\135\000\
\136\000\137\000\000\000\151\000\151\000\151\000\152\000\151\000\
\151\000\000\000\152\000\152\000\000\000\000\000\000\000\152\000\
\138\000\152\000\152\000\000\000\139\000\000\000\000\000\000\000\
\152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
\000\000\000\000\000\000\152\000\152\000\152\000\152\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\152\000\152\000\152\000\
\152\000\152\000\152\000\152\000\152\000\152\000\000\000\000\000\
\000\000\000\000\152\000\000\000\000\000\152\000\000\000\000\000\
\048\000\000\000\000\000\000\000\140\000\141\000\142\000\000\000\
\152\000\000\000\000\000\000\000\230\001\000\000\000\000\000\000\
\000\000\152\000\000\000\000\000\135\001\136\001\137\001\138\001\
\139\001\000\000\142\001\143\001\145\001\146\001\000\000\147\001\
\152\000\152\000\000\000\233\001\134\000\135\000\136\000\137\000\
\000\000\152\000\152\000\152\000\162\000\152\000\152\000\000\000\
\162\000\162\000\000\000\000\000\000\000\162\000\138\000\162\000\
\162\000\000\000\139\000\134\000\135\000\136\000\137\000\162\000\
\162\000\162\000\162\000\162\000\162\000\162\000\000\000\000\000\
\000\000\162\000\162\000\162\000\162\000\138\000\000\000\000\000\
\000\000\139\000\000\000\000\000\238\001\000\000\000\000\000\000\
\000\000\000\000\000\000\162\000\162\000\162\000\162\000\162\000\
\162\000\162\000\162\000\162\000\000\000\000\000\000\000\000\000\
\162\000\122\000\000\000\162\000\134\000\135\000\136\000\137\000\
\000\000\000\000\140\000\141\000\142\000\000\000\162\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\138\000\162\000\
\000\000\000\000\139\000\000\000\000\000\000\000\000\000\000\000\
\000\000\140\000\141\000\142\000\000\000\000\000\162\000\162\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\162\000\
\162\000\162\000\013\000\162\000\162\000\000\000\013\000\000\000\
\013\000\013\000\000\000\000\000\000\000\000\000\000\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\000\000\
\000\000\000\000\013\000\013\000\013\000\013\000\000\000\000\000\
\000\000\000\000\140\000\141\000\142\000\241\001\000\000\000\000\
\000\000\000\000\133\002\000\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\000\000\000\000\000\000\
\000\000\013\000\047\000\206\001\013\000\134\000\135\000\136\000\
\137\000\000\000\134\000\135\000\136\000\137\000\000\000\013\000\
\000\000\190\002\000\000\000\000\000\000\000\000\000\000\138\000\
\013\000\000\000\000\000\139\000\138\000\000\000\000\000\000\000\
\139\000\000\000\000\000\000\000\000\000\000\000\000\000\013\000\
\013\000\134\000\135\000\136\000\137\000\000\000\000\000\000\000\
\013\000\013\000\013\000\000\000\013\000\013\000\048\000\000\000\
\000\000\000\000\048\000\138\000\048\000\048\000\000\000\139\000\
\000\000\000\000\000\000\048\000\048\000\048\000\048\000\048\000\
\048\000\048\000\048\000\000\000\000\000\000\000\048\000\048\000\
\048\000\048\000\000\000\140\000\141\000\142\000\000\000\000\000\
\140\000\141\000\142\000\000\000\000\000\000\000\000\000\000\000\
\048\000\048\000\048\000\048\000\048\000\048\000\048\000\048\000\
\048\000\000\000\000\000\129\000\231\001\048\000\000\000\000\000\
\048\000\134\000\135\000\136\000\137\000\000\000\000\000\140\000\
\141\000\142\000\000\000\048\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\138\000\048\000\000\000\000\000\139\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\048\000\048\000\000\000\000\000\000\000\
\000\000\000\000\122\000\000\000\048\000\048\000\048\000\122\000\
\048\000\048\000\000\000\122\000\000\000\122\000\122\000\000\000\
\000\000\000\000\000\000\000\000\122\000\122\000\122\000\122\000\
\122\000\122\000\122\000\122\000\000\000\000\000\000\000\122\000\
\122\000\122\000\122\000\000\000\000\000\000\000\000\000\140\000\
\141\000\142\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\122\000\122\000\122\000\122\000\122\000\122\000\122\000\
\000\000\122\000\005\000\086\000\117\000\000\000\122\000\000\000\
\000\000\122\000\000\000\000\000\000\000\000\000\000\000\167\002\
\087\000\088\000\089\000\090\000\122\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\122\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\122\000\122\000\000\000\000\000\
\000\000\000\000\005\000\086\000\000\000\122\000\122\000\122\000\
\047\000\122\000\122\000\000\000\047\000\000\000\047\000\047\000\
\087\000\088\000\089\000\090\000\000\000\047\000\047\000\047\000\
\047\000\047\000\047\000\047\000\047\000\000\000\000\000\000\000\
\047\000\047\000\047\000\047\000\000\000\000\000\000\000\000\000\
\091\000\092\000\093\000\094\000\095\000\096\000\097\000\098\000\
\099\000\100\000\047\000\047\000\047\000\047\000\047\000\047\000\
\047\000\047\000\047\000\086\000\000\000\120\000\000\000\047\000\
\000\000\000\000\047\000\000\000\000\000\000\000\000\000\000\000\
\087\000\088\000\089\000\090\000\000\000\047\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\047\000\000\000\
\091\000\092\000\093\000\094\000\095\000\096\000\097\000\098\000\
\099\000\100\000\000\000\000\000\000\000\047\000\047\000\000\000\
\000\000\000\000\000\000\000\000\129\000\000\000\047\000\047\000\
\047\000\129\000\047\000\047\000\000\000\129\000\000\000\129\000\
\129\000\000\000\000\000\000\000\000\000\000\000\129\000\129\000\
\129\000\129\000\129\000\129\000\129\000\129\000\014\000\000\000\
\000\000\129\000\129\000\129\000\129\000\000\000\000\000\000\000\
\091\000\092\000\093\000\094\000\095\000\096\000\097\000\098\000\
\099\000\100\000\000\000\129\000\129\000\129\000\129\000\129\000\
\129\000\129\000\005\000\129\000\000\000\000\000\000\000\000\000\
\129\000\000\000\000\000\129\000\000\000\000\000\000\000\005\000\
\005\000\005\000\005\000\000\000\000\000\000\000\129\000\000\000\
\000\000\000\000\000\000\232\001\000\000\000\000\000\000\129\000\
\134\000\135\000\136\000\137\000\000\000\000\000\000\000\000\000\
\032\000\000\000\000\000\000\000\000\000\000\000\129\000\129\000\
\000\000\000\000\138\000\000\000\000\000\117\000\139\000\129\000\
\129\000\129\000\117\000\129\000\129\000\000\000\117\000\000\000\
\117\000\117\000\000\000\000\000\000\000\000\000\000\000\117\000\
\117\000\117\000\117\000\117\000\117\000\117\000\117\000\000\000\
\000\000\000\000\117\000\117\000\117\000\117\000\000\000\005\000\
\005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
\005\000\000\000\000\000\000\000\117\000\117\000\117\000\000\000\
\117\000\117\000\117\000\033\000\117\000\000\000\140\000\141\000\
\142\000\117\000\134\002\000\000\117\000\000\000\000\000\134\000\
\135\000\136\000\137\000\000\000\000\000\000\000\000\000\117\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\117\000\138\000\000\000\000\000\000\000\139\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\117\000\
\117\000\000\000\000\000\000\000\000\000\000\000\120\000\000\000\
\117\000\117\000\117\000\120\000\117\000\117\000\000\000\120\000\
\000\000\120\000\120\000\000\000\000\000\035\000\000\000\000\000\
\120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
\000\000\000\000\000\000\120\000\120\000\120\000\120\000\000\000\
\000\000\000\000\000\000\000\000\000\000\140\000\141\000\142\000\
\000\000\000\000\000\000\000\000\000\000\120\000\120\000\120\000\
\000\000\120\000\120\000\120\000\000\000\120\000\000\000\000\000\
\000\000\000\000\120\000\000\000\000\000\120\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\120\000\000\000\000\000\000\000\014\000\000\000\000\000\036\000\
\014\000\120\000\000\000\014\000\000\000\000\000\000\000\000\000\
\000\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
\120\000\120\000\000\000\000\000\014\000\014\000\014\000\014\000\
\000\000\120\000\120\000\120\000\000\000\120\000\120\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\014\000\014\000\
\014\000\014\000\014\000\014\000\014\000\000\000\014\000\000\000\
\000\000\000\000\000\000\014\000\000\000\000\000\014\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\032\000\000\000\
\000\000\014\000\032\000\034\000\000\000\032\000\000\000\000\000\
\000\000\000\000\014\000\032\000\032\000\032\000\032\000\032\000\
\032\000\032\000\000\000\000\000\000\000\000\000\032\000\032\000\
\032\000\032\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\014\000\014\000\014\000\000\000\014\000\014\000\
\032\000\032\000\032\000\032\000\032\000\032\000\032\000\000\000\
\032\000\000\000\000\000\000\000\000\000\032\000\000\000\000\000\
\032\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\000\000\000\032\000\000\000\033\000\025\000\000\000\
\033\000\000\000\000\000\000\000\032\000\000\000\033\000\033\000\
\033\000\033\000\033\000\033\000\033\000\000\000\000\000\000\000\
\000\000\033\000\033\000\033\000\033\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\032\000\032\000\032\000\000\000\
\032\000\032\000\000\000\033\000\033\000\033\000\033\000\033\000\
\033\000\033\000\000\000\033\000\000\000\000\000\000\000\000\000\
\033\000\000\000\000\000\033\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\035\000\000\000\000\000\033\000\035\000\
\026\000\000\000\035\000\000\000\000\000\000\000\000\000\033\000\
\035\000\035\000\035\000\035\000\035\000\035\000\035\000\000\000\
\000\000\000\000\000\000\035\000\035\000\035\000\035\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\000\
\033\000\033\000\000\000\033\000\033\000\035\000\035\000\035\000\
\035\000\035\000\035\000\035\000\000\000\035\000\000\000\000\000\
\000\000\000\000\035\000\000\000\000\000\035\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\036\000\000\000\000\000\
\035\000\036\000\027\000\000\000\036\000\000\000\000\000\000\000\
\000\000\035\000\036\000\036\000\036\000\036\000\036\000\036\000\
\036\000\000\000\000\000\000\000\000\000\036\000\036\000\036\000\
\036\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\035\000\035\000\035\000\000\000\035\000\035\000\036\000\
\036\000\036\000\036\000\036\000\036\000\036\000\000\000\036\000\
\000\000\000\000\000\000\000\000\036\000\000\000\000\000\036\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\034\000\036\000\000\000\054\000\034\000\000\000\000\000\
\034\000\000\000\000\000\036\000\000\000\000\000\034\000\034\000\
\034\000\034\000\034\000\034\000\034\000\000\000\000\000\000\000\
\000\000\034\000\034\000\034\000\034\000\000\000\000\000\000\000\
\000\000\000\000\000\000\036\000\036\000\036\000\000\000\036\000\
\036\000\000\000\000\000\034\000\034\000\034\000\034\000\034\000\
\034\000\034\000\000\000\034\000\000\000\000\000\000\000\000\000\
\034\000\000\000\000\000\034\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\025\000\000\000\034\000\056\000\
\025\000\000\000\000\000\025\000\000\000\000\000\000\000\034\000\
\000\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
\000\000\000\000\000\000\000\000\025\000\025\000\025\000\025\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\000\
\034\000\034\000\000\000\034\000\034\000\000\000\025\000\025\000\
\025\000\025\000\025\000\025\000\025\000\000\000\025\000\000\000\
\000\000\000\000\000\000\025\000\000\000\000\000\025\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\026\000\000\000\
\000\000\025\000\026\000\053\000\000\000\026\000\000\000\000\000\
\000\000\000\000\025\000\026\000\026\000\026\000\026\000\026\000\
\026\000\026\000\000\000\000\000\000\000\000\000\026\000\026\000\
\026\000\026\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\025\000\025\000\025\000\000\000\025\000\025\000\
\026\000\026\000\026\000\026\000\026\000\026\000\026\000\000\000\
\026\000\000\000\000\000\000\000\000\000\026\000\000\000\000\000\
\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\027\000\000\000\000\000\026\000\027\000\024\000\000\000\027\000\
\000\000\000\000\000\000\000\000\026\000\027\000\027\000\027\000\
\027\000\027\000\027\000\027\000\000\000\000\000\000\000\000\000\
\027\000\027\000\027\000\027\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\026\000\026\000\026\000\000\000\
\026\000\026\000\027\000\027\000\027\000\027\000\027\000\027\000\
\027\000\000\000\027\000\000\000\000\000\000\000\000\000\027\000\
\000\000\000\000\027\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\054\000\000\000\000\000\027\000\054\000\023\000\
\000\000\054\000\000\000\000\000\000\000\000\000\027\000\054\000\
\054\000\054\000\054\000\054\000\054\000\054\000\000\000\000\000\
\000\000\000\000\054\000\054\000\054\000\054\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\027\000\027\000\
\027\000\000\000\027\000\027\000\054\000\054\000\054\000\054\000\
\054\000\054\000\054\000\000\000\054\000\000\000\000\000\000\000\
\000\000\054\000\000\000\000\000\054\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\056\000\000\000\054\000\
\000\000\056\000\049\000\000\000\056\000\000\000\000\000\000\000\
\054\000\000\000\056\000\056\000\056\000\056\000\056\000\056\000\
\056\000\000\000\000\000\000\000\000\000\056\000\056\000\056\000\
\056\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\054\000\054\000\054\000\000\000\054\000\054\000\000\000\056\000\
\056\000\056\000\056\000\056\000\056\000\056\000\000\000\056\000\
\000\000\000\000\000\000\000\000\056\000\000\000\000\000\056\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\053\000\056\000\000\000\050\000\053\000\000\000\000\000\
\053\000\000\000\000\000\056\000\000\000\000\000\053\000\053\000\
\053\000\053\000\053\000\053\000\053\000\000\000\000\000\000\000\
\000\000\053\000\053\000\053\000\053\000\000\000\000\000\000\000\
\000\000\000\000\000\000\056\000\056\000\056\000\000\000\056\000\
\056\000\000\000\000\000\053\000\053\000\053\000\053\000\053\000\
\053\000\053\000\000\000\053\000\000\000\000\000\000\000\000\000\
\053\000\000\000\000\000\053\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\024\000\000\000\000\000\053\000\024\000\
\011\000\000\000\024\000\000\000\000\000\000\000\000\000\053\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\000\000\
\000\000\000\000\000\000\024\000\024\000\024\000\024\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\053\000\
\053\000\053\000\000\000\053\000\053\000\024\000\024\000\024\000\
\088\000\024\000\000\000\000\000\000\000\024\000\000\000\000\000\
\000\000\000\000\024\000\000\000\000\000\024\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\023\000\000\000\000\000\
\024\000\023\000\000\000\000\000\023\000\000\000\000\000\000\000\
\000\000\024\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\083\000\000\000\000\000\000\000\023\000\023\000\023\000\
\023\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\024\000\024\000\024\000\000\000\024\000\024\000\023\000\
\023\000\023\000\000\000\023\000\000\000\000\000\000\000\023\000\
\000\000\000\000\000\000\000\000\023\000\000\000\000\000\023\000\
\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\
\049\000\000\000\023\000\000\000\049\000\000\000\000\000\049\000\
\000\000\000\000\000\000\023\000\000\000\049\000\049\000\049\000\
\049\000\049\000\049\000\049\000\000\000\000\000\000\000\000\000\
\049\000\049\000\049\000\049\000\000\000\000\000\000\000\134\000\
\135\000\136\000\137\000\023\000\023\000\023\000\000\000\023\000\
\023\000\000\000\049\000\000\000\000\000\000\000\049\000\000\000\
\000\000\138\000\049\000\000\000\000\000\139\000\000\000\049\000\
\000\000\000\000\049\000\000\000\000\000\000\000\114\001\000\000\
\000\000\000\000\050\000\000\000\000\000\049\000\050\000\000\000\
\000\000\050\000\000\000\000\000\000\000\000\000\049\000\050\000\
\050\000\050\000\050\000\050\000\050\000\050\000\000\000\000\000\
\000\000\000\000\050\000\050\000\050\000\050\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\049\000\049\000\
\049\000\000\000\049\000\049\000\050\000\140\000\141\000\115\001\
\050\000\000\000\000\000\000\000\050\000\000\000\000\000\000\000\
\000\000\050\000\000\000\000\000\050\000\000\000\000\000\000\000\
\134\000\135\000\136\000\137\000\000\000\000\000\011\000\050\000\
\000\000\000\000\011\000\000\000\000\000\011\000\000\000\000\000\
\050\000\000\000\138\000\000\000\000\000\000\000\139\000\000\000\
\000\000\011\000\000\000\000\000\000\000\000\000\011\000\011\000\
\011\000\011\000\118\002\000\000\000\000\000\000\000\000\000\000\
\050\000\050\000\050\000\000\000\050\000\050\000\088\000\000\000\
\011\000\000\000\088\000\000\000\011\000\088\000\000\000\000\000\
\011\000\000\000\000\000\000\000\000\000\011\000\000\000\000\000\
\011\000\088\000\000\000\000\000\000\000\000\000\088\000\088\000\
\088\000\088\000\000\000\011\000\000\000\000\000\140\000\141\000\
\142\000\000\000\000\000\000\000\011\000\000\000\000\000\083\000\
\088\000\000\000\000\000\083\000\088\000\000\000\083\000\000\000\
\088\000\000\000\000\000\000\000\000\000\088\000\000\000\000\000\
\088\000\000\000\083\000\000\000\011\000\011\000\011\000\083\000\
\083\000\083\000\083\000\088\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\088\000\000\000\000\000\077\000\
\000\000\083\000\000\000\077\000\000\000\000\000\077\000\000\000\
\000\000\083\000\000\000\000\000\000\000\000\000\083\000\000\000\
\000\000\083\000\077\000\000\000\088\000\088\000\088\000\077\000\
\077\000\077\000\077\000\000\000\083\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\083\000\000\000\000\000\
\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\077\000\000\000\000\000\000\000\000\000\077\000\000\000\
\000\000\077\000\000\000\000\000\000\000\000\000\083\000\083\000\
\000\000\000\000\000\000\000\000\077\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\077\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\077\000\192\000\
\193\000\194\000\195\000\196\000\197\000\198\000\199\000\200\000\
\201\000\202\000\203\000\204\000\205\000\206\000\207\000\208\000\
\209\000\210\000\211\000\212\000\213\000\214\000\215\000\216\000\
\217\000\218\000\219\000\220\000\221\000\222\000\223\000\224\000\
\225\000\226\000\227\000\228\000\229\000\230\000\231\000\232\000\
\233\000\234\000\235\000\236\000\237\000\238\000\239\000\240\000\
\241\000\242\000\243\000\244\000\245\000\246\000\247\000\248\000\
\249\000\250\000\251\000\252\000\253\000\254\000\255\000\000\001\
\001\001\002\001\003\001\004\001\005\001\006\001\007\001\000\000\
\008\001\009\001\010\001\011\001\012\001\000\000\000\000\013\001\
\014\001\015\001\016\001\017\001\000\000\018\001\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\005\000\086\000\006\000\007\000\
\008\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\087\000\088\000\089\000\090\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\009\000\
\010\000\000\000\000\000\000\000\000\000\011\000\012\000\013\000\
\014\000\015\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\000\000\000\000\024\000\025\000\026\000\027\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\028\000\029\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\030\000\000\000\
\000\000\000\000\091\000\092\000\093\000\094\000\095\000\096\000\
\097\000\098\000\099\000\100\000\031\000\032\000\000\000\000\000\
\000\000\000\000\000\000\005\000\086\000\006\000\007\000\008\000\
\000\000\000\000\033\000\000\000\000\000\034\000\035\000\036\000\
\037\000\087\000\088\000\089\000\090\000\143\000\000\000\000\000\
\000\000\000\000\000\000\000\000\144\000\145\000\146\000\147\000\
\148\000\149\000\000\000\150\000\011\000\012\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\000\000\000\000\024\000\025\000\026\000\027\000\000\000\
\000\000\000\000\151\000\152\000\153\000\000\000\154\000\155\000\
\156\000\000\000\000\000\028\000\029\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\030\000\000\000\000\000\
\000\000\091\000\092\000\093\000\094\000\095\000\096\000\097\000\
\098\000\099\000\100\000\031\000\032\000\005\000\000\000\006\000\
\007\000\008\000\000\000\000\000\157\000\158\000\000\000\000\000\
\000\000\033\000\000\000\000\000\034\000\000\000\036\000\037\000\
\000\000\159\000\160\000\000\000\000\000\000\000\000\000\000\000\
\009\000\010\000\000\000\000\000\000\000\000\000\011\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\000\000\000\000\024\000\025\000\026\000\
\027\000\005\000\086\000\000\000\000\000\096\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\028\000\029\000\087\000\
\088\000\089\000\090\000\003\002\000\000\134\000\135\000\136\000\
\137\000\000\000\134\000\135\000\136\000\137\000\000\000\030\000\
\000\000\005\000\000\000\006\000\007\000\008\000\000\000\138\000\
\000\000\000\000\000\000\139\000\138\000\031\000\032\000\000\000\
\139\000\000\000\000\000\088\001\000\000\000\000\000\000\200\002\
\000\000\000\000\000\000\033\000\009\000\010\000\034\000\035\000\
\036\000\037\000\011\000\012\000\013\000\014\000\015\000\016\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\000\000\
\170\002\024\000\025\000\026\000\027\000\000\000\000\000\091\000\
\092\000\093\000\094\000\095\000\096\000\097\000\098\000\099\000\
\100\000\028\000\029\000\140\000\141\000\142\000\000\000\140\002\
\140\000\141\000\142\000\000\000\000\000\134\000\135\000\136\000\
\137\000\000\000\000\000\030\000\000\000\005\000\000\000\006\000\
\007\000\008\000\000\000\000\000\000\000\000\000\000\000\138\000\
\000\000\031\000\032\000\139\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\000\
\009\000\010\000\034\000\035\000\036\000\037\000\011\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\171\002\000\000\024\000\025\000\026\000\
\027\000\000\000\000\000\000\000\000\000\000\000\000\000\134\000\
\135\000\136\000\137\000\000\000\000\000\028\000\029\000\000\000\
\000\000\000\000\000\000\140\000\141\000\142\000\000\000\000\000\
\000\000\138\000\000\000\000\000\000\000\139\000\000\000\030\000\
\000\000\001\000\000\000\001\000\001\000\001\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\031\000\032\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\033\000\001\000\001\000\034\000\035\000\
\036\000\037\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\000\000\
\000\000\001\000\001\000\001\000\001\000\140\000\141\000\142\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\001\000\000\000\005\000\000\000\006\000\
\007\000\008\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\000\000\000\000\001\000\001\000\001\000\001\000\011\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\000\000\000\000\024\000\025\000\026\000\
\027\000\043\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\028\000\029\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\031\000\032\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\044\000\045\000\033\000\046\000\047\000\034\000\048\000\
\036\000\037\000\000\000\049\000\050\000\051\000\052\000\000\000\
\053\000\054\000\000\000\000\000\000\000\055\000\056\000\057\000\
\058\000\000\000\059\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\060\000\061\000\000\000\
\000\000\062\000\000\000\063\000"

let yycheck = "\001\000\
\008\000\060\000\045\000\099\000\100\000\048\000\008\000\010\000\
\000\000\113\000\000\000\168\001\045\000\104\000\169\001\048\000\
\191\001\175\001\051\001\089\001\096\001\015\001\055\000\009\000\
\010\000\095\001\102\001\057\000\030\000\059\000\000\000\090\001\
\035\000\087\002\015\001\094\001\000\000\038\002\020\001\155\001\
\083\000\019\001\009\001\006\001\064\001\001\001\064\001\005\001\
\047\000\035\000\083\000\167\001\061\001\067\001\001\001\064\001\
\020\002\006\001\005\001\064\001\164\000\060\000\058\001\059\001\
\084\001\003\001\084\001\000\000\005\001\005\001\075\001\005\001\
\009\001\069\001\011\000\015\001\061\001\005\001\074\001\000\000\
\032\001\030\001\031\001\032\001\033\001\070\001\005\001\024\000\
\025\000\026\000\027\000\005\001\000\000\015\001\249\001\005\001\
\033\000\064\001\092\001\048\001\052\001\064\001\084\001\052\001\
\051\001\083\001\012\001\088\001\064\001\110\002\091\001\092\001\
\114\000\115\000\116\000\117\000\118\000\119\000\120\000\121\000\
\026\001\058\000\130\000\156\001\178\002\044\002\045\002\046\002\
\130\000\031\002\132\000\174\000\134\000\135\000\136\000\137\000\
\138\000\139\000\140\000\141\000\142\000\174\000\175\000\176\000\
\108\002\005\002\083\001\133\000\218\001\055\001\158\000\181\000\
\092\001\212\001\156\000\000\000\108\001\109\001\110\001\108\001\
\109\001\110\001\005\001\165\000\083\001\010\001\168\000\166\000\
\167\000\106\000\092\001\093\001\058\001\006\001\052\001\030\001\
\031\001\032\001\033\001\005\001\040\002\005\001\146\002\005\001\
\015\001\030\001\031\001\032\001\033\001\188\000\005\001\032\001\
\025\001\099\001\100\001\005\001\012\001\052\001\005\001\005\001\
\119\002\102\002\006\001\048\001\105\001\106\001\143\000\052\001\
\051\001\006\001\026\001\052\001\055\001\150\000\151\000\152\000\
\153\000\154\000\155\000\005\001\157\000\158\000\159\000\160\000\
\006\001\162\000\030\001\031\001\032\001\033\001\108\001\064\001\
\110\001\170\000\052\001\051\001\096\002\053\001\054\001\055\001\
\055\001\051\001\062\002\025\001\048\001\055\001\145\002\067\002\
\052\001\055\001\151\002\084\001\087\001\108\001\109\001\110\001\
\059\002\088\001\000\000\056\001\091\001\092\001\025\001\108\001\
\109\001\110\001\005\001\108\001\006\001\110\001\009\001\058\001\
\006\001\050\002\051\002\062\001\010\001\064\001\027\001\013\001\
\057\001\058\001\064\001\099\001\100\001\062\001\063\001\064\001\
\027\001\005\001\108\001\025\001\064\001\009\001\001\001\155\002\
\030\001\031\001\005\001\033\001\005\001\064\001\084\001\027\001\
\108\001\109\001\110\001\027\001\051\001\005\001\027\001\027\001\
\075\001\005\001\048\001\064\001\027\001\074\001\056\001\061\001\
\074\001\063\001\056\001\183\002\060\001\064\001\027\001\061\001\
\070\001\027\001\064\001\068\001\069\001\001\001\182\001\162\002\
\163\002\076\001\110\001\058\001\064\001\075\001\001\001\089\001\
\051\001\001\001\060\001\064\001\064\001\095\001\084\001\000\000\
\060\001\019\001\006\001\101\001\076\001\103\001\010\001\076\001\
\076\001\013\001\000\000\064\001\000\000\076\001\064\001\104\001\
\115\001\115\001\006\001\006\001\102\001\025\001\013\001\121\001\
\224\001\164\001\030\001\031\001\032\001\033\001\064\001\060\001\
\025\001\115\001\064\001\164\001\102\001\176\001\064\001\105\001\
\106\001\107\001\171\001\060\001\048\001\105\001\106\001\176\001\
\081\001\082\001\083\001\064\001\056\001\086\001\001\000\002\000\
\003\000\061\001\025\001\009\001\064\001\156\001\166\001\096\001\
\162\001\064\001\001\001\100\001\001\001\102\001\009\001\075\001\
\019\001\102\001\169\001\170\001\105\001\106\001\000\000\005\001\
\084\001\114\001\083\001\064\001\179\001\102\001\064\001\027\001\
\105\001\106\001\064\001\107\001\190\001\068\000\069\000\070\000\
\071\000\192\001\077\001\078\001\079\001\080\001\081\001\082\001\
\108\001\109\001\110\001\102\001\015\001\006\001\000\000\250\001\
\006\001\006\001\006\001\254\001\052\001\051\001\056\001\060\001\
\218\001\250\001\101\001\006\001\084\001\254\001\025\001\068\001\
\069\001\028\002\009\001\213\001\227\001\231\001\232\001\217\001\
\080\002\064\001\061\001\022\002\064\001\083\001\064\001\064\001\
\005\001\243\001\110\001\009\001\064\001\022\002\064\001\064\001\
\025\002\064\001\249\001\064\001\026\002\027\002\103\001\103\001\
\033\002\102\001\001\002\104\001\105\001\106\001\107\001\015\001\
\006\001\060\001\015\001\006\001\010\001\006\001\056\001\013\001\
\057\001\027\001\006\001\052\002\213\001\005\001\025\001\020\001\
\217\001\075\001\064\001\025\001\124\002\028\002\006\001\000\000\
\064\001\025\001\020\002\034\002\077\001\078\001\079\001\080\001\
\084\001\082\001\005\001\009\001\064\001\025\001\086\001\090\002\
\084\001\020\001\048\001\050\002\051\002\055\001\006\001\006\001\
\025\001\090\002\056\001\006\001\101\001\006\001\056\001\061\001\
\064\001\064\001\064\001\025\001\064\001\099\002\019\001\101\002\
\084\001\075\002\076\002\009\001\006\001\075\001\111\002\030\001\
\031\001\032\001\033\001\020\002\086\002\087\002\084\001\064\001\
\006\001\064\001\064\001\064\001\064\001\009\001\093\002\027\001\
\025\001\048\001\006\001\020\001\064\001\052\001\064\001\064\001\
\064\001\000\000\013\001\000\000\001\001\000\000\153\002\013\001\
\006\001\027\001\006\001\006\001\010\001\000\000\010\001\013\001\
\153\002\013\001\108\002\000\000\064\001\062\002\000\000\084\001\
\056\001\006\001\067\002\025\001\134\002\025\001\084\001\020\001\
\084\001\064\001\064\001\182\002\006\001\000\000\128\002\006\001\
\064\001\064\001\145\002\006\001\128\000\182\002\158\002\184\002\
\123\002\156\000\048\001\227\001\147\001\108\001\109\001\110\001\
\146\002\102\001\056\001\100\001\056\001\146\002\128\002\061\001\
\217\001\061\001\064\001\108\002\064\001\090\001\176\002\001\001\
\178\002\087\001\165\002\005\001\006\001\075\001\063\001\075\001\
\010\001\186\001\012\001\013\001\002\000\025\002\084\001\128\002\
\084\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\161\002\052\002\093\002\030\001\031\001\032\001\033\001\
\185\000\146\002\086\002\200\002\006\001\034\002\078\000\184\002\
\010\001\031\002\177\002\013\001\050\001\255\255\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\025\001\
\255\255\000\000\255\255\061\001\030\001\031\001\064\001\033\001\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\075\001\255\255\000\000\006\001\255\255\048\001\255\255\
\255\255\255\255\084\001\255\255\255\255\048\001\056\001\255\255\
\255\255\052\001\255\255\061\001\255\255\056\001\064\001\255\255\
\255\255\099\001\100\001\255\255\030\001\031\001\032\001\033\001\
\255\255\075\001\108\001\109\001\110\001\255\255\112\001\113\001\
\001\001\012\001\084\001\255\255\005\001\006\001\048\001\255\255\
\255\255\010\001\052\001\012\001\013\001\255\255\255\255\026\001\
\255\255\255\255\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\000\000\109\001\255\255\030\001\031\001\032\001\
\033\001\108\001\109\001\110\001\255\255\255\255\049\001\050\001\
\051\001\255\255\053\001\054\001\055\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\255\255\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\255\255\108\001\109\001\110\001\255\255\255\255\255\255\
\255\255\000\000\075\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\084\001\255\255\255\255\255\255\255\255\
\099\001\100\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\006\001\099\001\100\001\255\255\010\001\255\255\255\255\
\013\001\255\255\255\255\108\001\109\001\110\001\001\001\112\001\
\113\001\255\255\005\001\006\001\025\001\255\255\255\255\010\001\
\255\255\012\001\013\001\255\255\255\255\255\255\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\000\000\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\075\001\255\255\
\255\255\255\255\061\001\025\001\255\255\064\001\255\255\084\001\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\000\000\
\075\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\084\001\048\001\255\255\255\255\255\255\052\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\006\001\
\099\001\100\001\255\255\010\001\255\255\255\255\013\001\255\255\
\255\255\108\001\109\001\110\001\001\001\112\001\113\001\255\255\
\005\001\006\001\025\001\255\255\255\255\010\001\255\255\012\001\
\013\001\255\255\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\108\001\109\001\
\110\001\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\056\001\075\001\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\084\001\255\255\255\255\
\006\001\255\255\255\255\255\255\010\001\000\000\075\001\013\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\084\001\
\255\255\255\255\255\255\025\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\099\001\100\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\001\001\112\001\113\001\255\255\005\001\006\001\
\255\255\255\255\056\001\010\001\255\255\012\001\013\001\061\001\
\255\255\255\255\064\001\255\255\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\255\255\075\001\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\255\255\084\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\255\255\255\255\255\255\255\255\006\001\255\255\
\255\255\255\255\010\001\000\000\075\001\013\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\025\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\099\001\100\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\108\001\109\001\110\001\
\001\001\112\001\113\001\255\255\005\001\006\001\255\255\255\255\
\056\001\010\001\255\255\012\001\013\001\061\001\255\255\255\255\
\064\001\255\255\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\255\255\075\001\255\255\030\001\031\001\032\001\
\033\001\255\255\255\255\255\255\084\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\011\000\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\255\255\255\255\255\255\000\000\024\000\025\000\026\000\
\027\000\255\255\075\001\255\255\255\255\255\255\033\000\255\255\
\255\255\255\255\255\255\084\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\025\001\099\001\100\001\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\108\001\109\001\110\001\001\001\112\001\
\113\001\255\255\005\001\006\001\255\255\255\255\255\255\010\001\
\048\001\012\001\013\001\255\255\052\001\255\255\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\255\255\255\255\
\255\255\255\255\061\001\255\255\255\255\064\001\255\255\255\255\
\000\000\255\255\255\255\255\255\108\001\109\001\110\001\255\255\
\075\001\255\255\255\255\255\255\006\001\255\255\255\255\255\255\
\255\255\084\001\255\255\255\255\151\000\152\000\153\000\154\000\
\155\000\255\255\157\000\158\000\159\000\160\000\255\255\162\000\
\099\001\100\001\255\255\006\001\030\001\031\001\032\001\033\001\
\255\255\108\001\109\001\110\001\001\001\112\001\113\001\255\255\
\005\001\006\001\255\255\255\255\255\255\010\001\048\001\012\001\
\013\001\255\255\052\001\030\001\031\001\032\001\033\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\048\001\255\255\255\255\
\255\255\052\001\255\255\255\255\006\001\255\255\255\255\255\255\
\255\255\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\056\001\255\255\255\255\255\255\255\255\
\061\001\000\000\255\255\064\001\030\001\031\001\032\001\033\001\
\255\255\255\255\108\001\109\001\110\001\255\255\075\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\048\001\084\001\
\255\255\255\255\052\001\255\255\255\255\255\255\255\255\255\255\
\255\255\108\001\109\001\110\001\255\255\255\255\099\001\100\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\006\001\112\001\113\001\255\255\010\001\255\255\
\012\001\013\001\255\255\255\255\255\255\255\255\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\108\001\109\001\110\001\006\001\255\255\255\255\
\255\255\255\255\006\001\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\255\255\255\255\255\255\
\255\255\061\001\000\000\086\001\064\001\030\001\031\001\032\001\
\033\001\255\255\030\001\031\001\032\001\033\001\255\255\075\001\
\255\255\006\001\255\255\255\255\255\255\255\255\255\255\048\001\
\084\001\255\255\255\255\052\001\048\001\255\255\255\255\255\255\
\052\001\255\255\255\255\255\255\255\255\255\255\255\255\099\001\
\100\001\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\112\001\113\001\006\001\255\255\
\255\255\255\255\010\001\048\001\012\001\013\001\255\255\052\001\
\255\255\255\255\255\255\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\108\001\109\001\110\001\255\255\255\255\
\108\001\109\001\110\001\255\255\255\255\255\255\255\255\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\255\255\255\255\000\000\025\001\061\001\255\255\255\255\
\064\001\030\001\031\001\032\001\033\001\255\255\255\255\108\001\
\109\001\110\001\255\255\075\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\048\001\084\001\255\255\255\255\052\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\099\001\100\001\255\255\255\255\255\255\
\255\255\255\255\001\001\255\255\108\001\109\001\110\001\006\001\
\112\001\113\001\255\255\010\001\255\255\012\001\013\001\255\255\
\255\255\255\255\255\255\255\255\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\255\255\056\001\001\001\002\001\000\000\255\255\061\001\255\255\
\255\255\064\001\255\255\255\255\255\255\255\255\255\255\014\001\
\015\001\016\001\017\001\018\001\075\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\099\001\100\001\255\255\255\255\
\255\255\255\255\001\001\002\001\255\255\108\001\109\001\110\001\
\006\001\112\001\113\001\255\255\010\001\255\255\012\001\013\001\
\015\001\016\001\017\001\018\001\255\255\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\255\255\
\087\001\088\001\089\001\090\001\091\001\092\001\093\001\094\001\
\095\001\096\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\002\001\255\255\000\000\255\255\061\001\
\255\255\255\255\064\001\255\255\255\255\255\255\255\255\255\255\
\015\001\016\001\017\001\018\001\255\255\075\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\084\001\255\255\
\087\001\088\001\089\001\090\001\091\001\092\001\093\001\094\001\
\095\001\096\001\255\255\255\255\255\255\099\001\100\001\255\255\
\255\255\255\255\255\255\255\255\001\001\255\255\108\001\109\001\
\110\001\006\001\112\001\113\001\255\255\010\001\255\255\012\001\
\013\001\255\255\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\000\000\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\087\001\088\001\089\001\090\001\091\001\092\001\093\001\094\001\
\095\001\096\001\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\002\001\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\255\255\015\001\
\016\001\017\001\018\001\255\255\255\255\255\255\075\001\255\255\
\255\255\255\255\255\255\025\001\255\255\255\255\255\255\084\001\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\255\255\
\000\000\255\255\255\255\255\255\255\255\255\255\099\001\100\001\
\255\255\255\255\048\001\255\255\255\255\001\001\052\001\108\001\
\109\001\110\001\006\001\112\001\113\001\255\255\010\001\255\255\
\012\001\013\001\255\255\255\255\255\255\255\255\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\087\001\
\088\001\089\001\090\001\091\001\092\001\093\001\094\001\095\001\
\096\001\255\255\255\255\255\255\048\001\049\001\050\001\255\255\
\052\001\053\001\054\001\000\000\056\001\255\255\108\001\109\001\
\110\001\061\001\025\001\255\255\064\001\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\255\255\255\255\075\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\084\001\048\001\255\255\255\255\255\255\052\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\099\001\
\100\001\255\255\255\255\255\255\255\255\255\255\001\001\255\255\
\108\001\109\001\110\001\006\001\112\001\113\001\255\255\010\001\
\255\255\012\001\013\001\255\255\255\255\000\000\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\255\255\255\255\108\001\109\001\110\001\
\255\255\255\255\255\255\255\255\255\255\048\001\049\001\050\001\
\255\255\052\001\053\001\054\001\255\255\056\001\255\255\255\255\
\255\255\255\255\061\001\255\255\255\255\064\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\075\001\255\255\255\255\255\255\006\001\255\255\255\255\000\000\
\010\001\084\001\255\255\013\001\255\255\255\255\255\255\255\255\
\255\255\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\099\001\100\001\255\255\255\255\030\001\031\001\032\001\033\001\
\255\255\108\001\109\001\110\001\255\255\112\001\113\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\255\255\
\255\255\255\255\255\255\061\001\255\255\255\255\064\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\006\001\255\255\
\255\255\075\001\010\001\000\000\255\255\013\001\255\255\255\255\
\255\255\255\255\084\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\108\001\109\001\110\001\255\255\112\001\113\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\006\001\255\255\075\001\255\255\010\001\000\000\255\255\
\013\001\255\255\255\255\255\255\084\001\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\255\255\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\108\001\109\001\110\001\255\255\
\112\001\113\001\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\255\255\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\006\001\255\255\255\255\075\001\010\001\
\000\000\255\255\013\001\255\255\255\255\255\255\255\255\084\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\255\255\112\001\113\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\255\255\056\001\255\255\255\255\
\255\255\255\255\061\001\255\255\255\255\064\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\006\001\255\255\255\255\
\075\001\010\001\000\000\255\255\013\001\255\255\255\255\255\255\
\255\255\084\001\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\255\255\255\255\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\108\001\109\001\110\001\255\255\112\001\113\001\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\255\255\056\001\
\255\255\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\006\001\075\001\255\255\000\000\010\001\255\255\255\255\
\013\001\255\255\255\255\084\001\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\255\255\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\255\255\255\255\255\255\108\001\109\001\110\001\255\255\112\001\
\113\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\255\255\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\006\001\255\255\075\001\000\000\
\010\001\255\255\255\255\013\001\255\255\255\255\255\255\084\001\
\255\255\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\255\255\255\255\255\255\255\255\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\255\255\112\001\113\001\255\255\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\255\255\
\255\255\255\255\255\255\061\001\255\255\255\255\064\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\006\001\255\255\
\255\255\075\001\010\001\000\000\255\255\013\001\255\255\255\255\
\255\255\255\255\084\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\108\001\109\001\110\001\255\255\112\001\113\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\006\001\255\255\255\255\075\001\010\001\000\000\255\255\013\001\
\255\255\255\255\255\255\255\255\084\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\255\255\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\108\001\109\001\110\001\255\255\
\112\001\113\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\064\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\006\001\255\255\255\255\075\001\010\001\000\000\
\255\255\013\001\255\255\255\255\255\255\255\255\084\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\255\255\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\108\001\109\001\
\110\001\255\255\112\001\113\001\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\255\255\056\001\255\255\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\006\001\255\255\075\001\
\255\255\010\001\000\000\255\255\013\001\255\255\255\255\255\255\
\084\001\255\255\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\255\255\255\255\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\112\001\113\001\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\255\255\056\001\
\255\255\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\006\001\075\001\255\255\000\000\010\001\255\255\255\255\
\013\001\255\255\255\255\084\001\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\255\255\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\255\255\255\255\255\255\108\001\109\001\110\001\255\255\112\001\
\113\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\255\255\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\006\001\255\255\255\255\075\001\010\001\
\000\000\255\255\013\001\255\255\255\255\255\255\255\255\084\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\255\255\112\001\113\001\048\001\049\001\050\001\
\000\000\052\001\255\255\255\255\255\255\056\001\255\255\255\255\
\255\255\255\255\061\001\255\255\255\255\064\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\006\001\255\255\255\255\
\075\001\010\001\255\255\255\255\013\001\255\255\255\255\255\255\
\255\255\084\001\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\000\000\255\255\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\108\001\109\001\110\001\255\255\112\001\113\001\048\001\
\049\001\050\001\255\255\052\001\255\255\255\255\255\255\056\001\
\255\255\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
\006\001\255\255\075\001\255\255\010\001\255\255\255\255\013\001\
\255\255\255\255\255\255\084\001\255\255\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\255\255\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\108\001\109\001\110\001\255\255\112\001\
\113\001\255\255\048\001\255\255\255\255\255\255\052\001\255\255\
\255\255\048\001\056\001\255\255\255\255\052\001\255\255\061\001\
\255\255\255\255\064\001\255\255\255\255\255\255\061\001\255\255\
\255\255\255\255\006\001\255\255\255\255\075\001\010\001\255\255\
\255\255\013\001\255\255\255\255\255\255\255\255\084\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\255\255\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\108\001\109\001\
\110\001\255\255\112\001\113\001\048\001\108\001\109\001\110\001\
\052\001\255\255\255\255\255\255\056\001\255\255\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\006\001\075\001\
\255\255\255\255\010\001\255\255\255\255\013\001\255\255\255\255\
\084\001\255\255\048\001\255\255\255\255\255\255\052\001\255\255\
\255\255\025\001\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\064\001\255\255\255\255\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\112\001\113\001\006\001\255\255\
\048\001\255\255\010\001\255\255\052\001\013\001\255\255\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\025\001\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\075\001\255\255\255\255\108\001\109\001\
\110\001\255\255\255\255\255\255\084\001\255\255\255\255\006\001\
\048\001\255\255\255\255\010\001\052\001\255\255\013\001\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\025\001\255\255\108\001\109\001\110\001\030\001\
\031\001\032\001\033\001\075\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\084\001\255\255\255\255\006\001\
\255\255\048\001\255\255\010\001\255\255\255\255\013\001\255\255\
\255\255\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\025\001\255\255\108\001\109\001\110\001\030\001\
\031\001\032\001\033\001\255\255\075\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\048\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\255\255\255\255\255\255\255\255\109\001\110\001\
\255\255\255\255\255\255\255\255\075\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\109\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\012\001\013\001\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\032\001\033\001\
\034\001\035\001\036\001\037\001\038\001\039\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\064\001\065\001\
\066\001\067\001\068\001\069\001\070\001\071\001\072\001\255\255\
\074\001\075\001\076\001\077\001\078\001\255\255\255\255\081\001\
\082\001\083\001\084\001\085\001\255\255\087\001\088\001\089\001\
\090\001\091\001\092\001\093\001\094\001\095\001\096\001\097\001\
\098\001\099\001\100\001\101\001\102\001\103\001\104\001\105\001\
\106\001\107\001\108\001\109\001\110\001\111\001\112\001\113\001\
\114\001\115\001\116\001\117\001\001\001\002\001\003\001\004\001\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\015\001\016\001\017\001\018\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\028\001\
\029\001\255\255\255\255\255\255\255\255\034\001\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\255\255\255\255\049\001\050\001\051\001\052\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\065\001\066\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\083\001\255\255\
\255\255\255\255\087\001\088\001\089\001\090\001\091\001\092\001\
\093\001\094\001\095\001\096\001\097\001\098\001\255\255\255\255\
\255\255\255\255\255\255\001\001\002\001\003\001\004\001\005\001\
\255\255\255\255\111\001\255\255\255\255\114\001\115\001\116\001\
\117\001\015\001\016\001\017\001\018\001\012\001\255\255\255\255\
\255\255\255\255\255\255\255\255\019\001\020\001\021\001\022\001\
\023\001\024\001\255\255\026\001\034\001\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\255\255\255\255\049\001\050\001\051\001\052\001\255\255\
\255\255\255\255\049\001\050\001\051\001\255\255\053\001\054\001\
\055\001\255\255\255\255\065\001\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\083\001\255\255\255\255\
\255\255\087\001\088\001\089\001\090\001\091\001\092\001\093\001\
\094\001\095\001\096\001\097\001\098\001\001\001\255\255\003\001\
\004\001\005\001\255\255\255\255\099\001\100\001\255\255\255\255\
\255\255\111\001\255\255\255\255\114\001\255\255\116\001\117\001\
\255\255\112\001\113\001\255\255\255\255\255\255\255\255\255\255\
\028\001\029\001\255\255\255\255\255\255\255\255\034\001\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\255\255\255\255\049\001\050\001\051\001\
\052\001\001\001\002\001\255\255\255\255\005\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\065\001\066\001\015\001\
\016\001\017\001\018\001\071\001\255\255\030\001\031\001\032\001\
\033\001\255\255\030\001\031\001\032\001\033\001\255\255\083\001\
\255\255\001\001\255\255\003\001\004\001\005\001\255\255\048\001\
\255\255\255\255\255\255\052\001\048\001\097\001\098\001\255\255\
\052\001\255\255\255\255\051\001\255\255\255\255\255\255\064\001\
\255\255\255\255\255\255\111\001\028\001\029\001\114\001\115\001\
\116\001\117\001\034\001\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\255\255\
\084\001\049\001\050\001\051\001\052\001\255\255\255\255\087\001\
\088\001\089\001\090\001\091\001\092\001\093\001\094\001\095\001\
\096\001\065\001\066\001\108\001\109\001\110\001\255\255\071\001\
\108\001\109\001\110\001\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\255\255\083\001\255\255\001\001\255\255\003\001\
\004\001\005\001\255\255\255\255\255\255\255\255\255\255\048\001\
\255\255\097\001\098\001\052\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\111\001\
\028\001\029\001\114\001\115\001\116\001\117\001\034\001\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\084\001\255\255\049\001\050\001\051\001\
\052\001\255\255\255\255\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\065\001\066\001\255\255\
\255\255\255\255\255\255\108\001\109\001\110\001\255\255\255\255\
\255\255\048\001\255\255\255\255\255\255\052\001\255\255\083\001\
\255\255\001\001\255\255\003\001\004\001\005\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\097\001\098\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\111\001\028\001\029\001\114\001\115\001\
\116\001\117\001\034\001\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\255\255\
\255\255\049\001\050\001\051\001\052\001\108\001\109\001\110\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\065\001\066\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\083\001\255\255\001\001\255\255\003\001\
\004\001\005\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\097\001\098\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\111\001\
\255\255\255\255\114\001\115\001\116\001\117\001\034\001\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\255\255\255\255\049\001\050\001\051\001\
\052\001\001\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\065\001\066\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\083\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\097\001\098\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\057\001\058\001\111\001\060\001\061\001\114\001\063\001\
\116\001\117\001\255\255\067\001\068\001\069\001\070\001\255\255\
\072\001\073\001\255\255\255\255\255\255\077\001\078\001\079\001\
\080\001\255\255\082\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\101\001\102\001\255\255\
\255\255\105\001\255\255\107\001"

let yynames_const = "\
  LPAR\000\
  RPAR\000\
  IF\000\
  ELSE\000\
  COLON\000\
  COLON2\000\
  COLONCOLON\000\
  DOT\000\
  DOTDOT\000\
  DOTDOTDOT\000\
  INT\000\
  INTEGER\000\
  REAL\000\
  FLOAT\000\
  LT\000\
  GT\000\
  LE\000\
  GE\000\
  EQ\000\
  NE\000\
  COMMA\000\
  ARROW\000\
  EQUAL\000\
  FORALL\000\
  EXISTS\000\
  IFF\000\
  IMPLIES\000\
  AND\000\
  OR\000\
  NOT\000\
  SEPARATED\000\
  TRUE\000\
  FALSE\000\
  OLD\000\
  AT\000\
  RESULT\000\
  BLOCK_LENGTH\000\
  BASE_ADDR\000\
  VALID\000\
  VALID_INDEX\000\
  VALID_RANGE\000\
  FRESH\000\
  DOLLAR\000\
  QUESTION\000\
  MINUS\000\
  PLUS\000\
  STAR\000\
  AMP\000\
  SLASH\000\
  PERCENT\000\
  LSQUARE\000\
  RSQUARE\000\
  EOF\000\
  GLOBAL\000\
  INVARIANT\000\
  VARIANT\000\
  DECREASES\000\
  FOR\000\
  LABEL\000\
  ASSERT\000\
  SEMICOLON\000\
  NULL\000\
  EMPTY\000\
  REQUIRES\000\
  ENSURES\000\
  ASSIGNS\000\
  LOOP\000\
  NOTHING\000\
  SLICE\000\
  IMPACT\000\
  PRAGMA\000\
  FROM\000\
  READS\000\
  LOGIC\000\
  PREDICATE\000\
  INDUCTIVE\000\
  AXIOMATIC\000\
  AXIOM\000\
  LEMMA\000\
  LBRACE\000\
  RBRACE\000\
  GHOST\000\
  CASE\000\
  VOID\000\
  CHAR\000\
  SIGNED\000\
  UNSIGNED\000\
  SHORT\000\
  LONG\000\
  DOUBLE\000\
  STRUCT\000\
  ENUM\000\
  UNION\000\
  BSUNION\000\
  INTER\000\
  LTCOLON\000\
  COLONGT\000\
  TYPE\000\
  BEHAVIOR\000\
  BEHAVIORS\000\
  ASSUMES\000\
  COMPLETE\000\
  DISJOINT\000\
  TERMINATES\000\
  HAT\000\
  HATHAT\000\
  PIPE\000\
  TILDE\000\
  GTGT\000\
  LTLT\000\
  SIZEOF\000\
  LAMBDA\000\
  TYPEOF\000\
  BSTYPE\000\
  "

let yynames_block = "\
  IDENTIFIER\000\
  TYPENAME\000\
  STRING_LITERAL\000\
  CONSTANT\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    Obj.repr(
# 126 "cil/src/logic/logic_parser.mly"
            ( enter_kw_c_mode () )
# 1936 "cil/src/logic/logic_parser.ml"
               : 'enter_kw_c_mode))
; (fun __caml_parser_env ->
    Obj.repr(
# 129 "cil/src/logic/logic_parser.mly"
            ( exit_kw_c_mode () )
# 1942 "cil/src/logic/logic_parser.ml"
               : 'exit_kw_c_mode))
; (fun __caml_parser_env ->
    Obj.repr(
# 132 "cil/src/logic/logic_parser.mly"
            ( if is_rt_type () then enter_rt_type_mode () )
# 1948 "cil/src/logic/logic_parser.ml"
               : 'enter_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 135 "cil/src/logic/logic_parser.mly"
            ( if is_rt_type () then exit_rt_type_mode () )
# 1954 "cil/src/logic/logic_parser.ml"
               : 'exit_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 138 "cil/src/logic/logic_parser.mly"
            ( set_rt_type () )
# 1960 "cil/src/logic/logic_parser.ml"
               : 'begin_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 141 "cil/src/logic/logic_parser.mly"
            ( reset_rt_type () )
# 1966 "cil/src/logic/logic_parser.ml"
               : 'end_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 146 "cil/src/logic/logic_parser.mly"
                ( [] )
# 1972 "cil/src/logic/logic_parser.ml"
               : 'lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_lexpr_list) in
    Obj.repr(
# 147 "cil/src/logic/logic_parser.mly"
                 ( _1 )
# 1979 "cil/src/logic/logic_parser.ml"
               : 'lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 151 "cil/src/logic/logic_parser.mly"
                           ( [_1] )
# 1986 "cil/src/logic/logic_parser.ml"
               : 'ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_lexpr_list) in
    Obj.repr(
# 152 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _3 )
# 1994 "cil/src/logic/logic_parser.ml"
               : 'ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 156 "cil/src/logic/logic_parser.mly"
                                ( _1 )
# 2001 "cil/src/logic/logic_parser.ml"
               : 'lexpr_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_inner) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'rel_list) in
    Obj.repr(
# 158 "cil/src/logic/logic_parser.mly"
      ( let rel, rhs, _, oth_rel = _2 in
        let loc = loc_start _1, loc_end rhs in
        let relation = loc_info loc (PLrel(_1,rel,rhs)) in
        match oth_rel with
            None -> relation
          | Some oth_relation -> info (PLand(relation,oth_relation))
      )
# 2015 "cil/src/logic/logic_parser.ml"
               : 'lexpr_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'string) in
    Obj.repr(
# 167 "cil/src/logic/logic_parser.mly"
           (
      let (is_wide,content) = _1 in
      let cst = if is_wide then
        WStringConstant content
      else
        StringConstant content
      in
      info (PLconstant cst)
    )
# 2030 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 176 "cil/src/logic/logic_parser.mly"
                    ( info (PLnot _2) )
# 2037 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 177 "cil/src/logic/logic_parser.mly"
         ( info PLtrue )
# 2043 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 178 "cil/src/logic/logic_parser.mly"
          ( info PLfalse )
# 2049 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 179 "cil/src/logic/logic_parser.mly"
                          ( info (PLvalid (_3)) )
# 2056 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 180 "cil/src/logic/logic_parser.mly"
                                            ( info (PLvalid_index (_3,_5)) )
# 2064 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 182 "cil/src/logic/logic_parser.mly"
      ( info (PLvalid_range (_3,_5,_7)) )
# 2073 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 183 "cil/src/logic/logic_parser.mly"
                          ( info (PLfresh (_3)) )
# 2080 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 184 "cil/src/logic/logic_parser.mly"
         ( info PLnull )
# 2086 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 185 "cil/src/logic/logic_parser.mly"
             ( info (PLconstant _1) )
# 2093 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 186 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Badd, _3)) )
# 2101 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 187 "cil/src/logic/logic_parser.mly"
                                  ( info (PLbinop (_1, Bsub, _3)) )
# 2109 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 188 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Bmul, _3)) )
# 2117 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 189 "cil/src/logic/logic_parser.mly"
                                  ( info (PLbinop (_1, Bdiv, _3)) )
# 2125 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 190 "cil/src/logic/logic_parser.mly"
                                    ( info (PLbinop (_1, Bmod, _3)) )
# 2133 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 191 "cil/src/logic/logic_parser.mly"
                                 ( info (PLarrow (_1, _3)) )
# 2141 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 192 "cil/src/logic/logic_parser.mly"
                               ( info (PLdot (_1, _3)) )
# 2149 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'range) in
    Obj.repr(
# 193 "cil/src/logic/logic_parser.mly"
                                      ( info (PLarrget (_1, _3)) )
# 2157 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 194 "cil/src/logic/logic_parser.mly"
                                      ( info (PLarrget (_1, _3)) )
# 2165 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 195 "cil/src/logic/logic_parser.mly"
                                        ( info (PLunop (Uminus, _2)) )
# 2172 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 196 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 2179 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 197 "cil/src/logic/logic_parser.mly"
                      ( info (PLunop (Ubw_not, _2)) )
# 2186 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 198 "cil/src/logic/logic_parser.mly"
                     ( info (PLunop (Ustar, _2)) )
# 2193 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 199 "cil/src/logic/logic_parser.mly"
                    ( info (PLunop (Uamp, _2)) )
# 2200 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 200 "cil/src/logic/logic_parser.mly"
                           ( info (PLsizeofE _3) )
# 2207 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    Obj.repr(
# 201 "cil/src/logic/logic_parser.mly"
                                ( info (PLsizeof _3) )
# 2214 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 202 "cil/src/logic/logic_parser.mly"
                        ( info (PLold _3) )
# 2221 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'label) in
    Obj.repr(
# 203 "cil/src/logic/logic_parser.mly"
                                   ( info (PLat (_3, _5)) )
# 2229 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 204 "cil/src/logic/logic_parser.mly"
                              ( info (PLbase_addr _3) )
# 2236 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 205 "cil/src/logic/logic_parser.mly"
                                 ( info (PLblock_length _3) )
# 2243 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 206 "cil/src/logic/logic_parser.mly"
           ( info PLresult )
# 2249 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 208 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, [], _3)) )
# 2257 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 210 "cil/src/logic/logic_parser.mly"
      ( info (PLseparated _3) )
# 2264 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'ne_tvar_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 212 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, _3, _6)) )
# 2273 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 214 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, _3, [])) )
# 2281 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 215 "cil/src/logic/logic_parser.mly"
                                ( info (PLvar _1) )
# 2288 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 216 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Brshift, _3)))
# 2296 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 217 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Blshift, _3)))
# 2304 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 218 "cil/src/logic/logic_parser.mly"
                                   ( info _2.lexpr_node )
# 2311 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'range) in
    Obj.repr(
# 219 "cil/src/logic/logic_parser.mly"
                    ( info _2.lexpr_node )
# 2318 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'logic_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 221 "cil/src/logic/logic_parser.mly"
      ( info (PLcast (_2, _4)) )
# 2326 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 223 "cil/src/logic/logic_parser.mly"
      ( info (PLsubtype (_1, _3)) )
# 2334 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type) in
    Obj.repr(
# 225 "cil/src/logic/logic_parser.mly"
      ( info (PLcoercion (_1, _3)) )
# 2342 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 227 "cil/src/logic/logic_parser.mly"
      ( info (PLcoercionE (_1, _3)) )
# 2350 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 228 "cil/src/logic/logic_parser.mly"
                           ( info (PLtypeof _3) )
# 2357 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'type_spec) in
    Obj.repr(
# 229 "cil/src/logic/logic_parser.mly"
                                    ( info (PLtype _3) )
# 2364 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 231 "cil/src/logic/logic_parser.mly"
          ( info PLempty )
# 2370 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_list) in
    Obj.repr(
# 232 "cil/src/logic/logic_parser.mly"
                                 ( info (PLunion _3) )
# 2377 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_list) in
    Obj.repr(
# 233 "cil/src/logic/logic_parser.mly"
                               ( info (PLinter _3) )
# 2384 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'binders) in
    Obj.repr(
# 235 "cil/src/logic/logic_parser.mly"
      (info (PLcomprehension (_2,_4,None)) )
# 2392 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Logic_ptree.lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'binders) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 237 "cil/src/logic/logic_parser.mly"
      ( info (PLcomprehension (_2,_4,Some _6)) )
# 2401 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Logic_ptree.lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 239 "cil/src/logic/logic_parser.mly"
                                                   ( info (PLupdate(_2,_4,_6)) )
# 2410 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 243 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 2417 "cil/src/logic/logic_parser.ml"
               : 'string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 244 "cil/src/logic/logic_parser.mly"
                          (
      let (is_wide,prefix) = _1 in
      let (is_wide2,suffix) = _2 in
      (is_wide || is_wide2, prefix ^ suffix)
    )
# 2429 "cil/src/logic/logic_parser.ml"
               : 'string))
; (fun __caml_parser_env ->
    Obj.repr(
# 251 "cil/src/logic/logic_parser.mly"
          ( Lt )
# 2435 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 252 "cil/src/logic/logic_parser.mly"
          ( Gt )
# 2441 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 253 "cil/src/logic/logic_parser.mly"
          ( Le )
# 2447 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 254 "cil/src/logic/logic_parser.mly"
          ( Ge )
# 2453 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 255 "cil/src/logic/logic_parser.mly"
          ( Eq )
# 2459 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 256 "cil/src/logic/logic_parser.mly"
          ( Neq )
# 2465 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_option) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_option) in
    Obj.repr(
# 260 "cil/src/logic/logic_parser.mly"
                                   ( info (PLrange(_1,_3)) )
# 2473 "cil/src/logic/logic_parser.ml"
               : 'range))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 264 "cil/src/logic/logic_parser.mly"
                      ( info (PLimplies (_1, _3)) )
# 2481 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 265 "cil/src/logic/logic_parser.mly"
                  ( info (PLiff (_1, _3)) )
# 2489 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 266 "cil/src/logic/logic_parser.mly"
                     ( info (PLor (_1, _3)) )
# 2497 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 267 "cil/src/logic/logic_parser.mly"
                     ( info (PLand (_1, _3)) )
# 2505 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 268 "cil/src/logic/logic_parser.mly"
                        ( info (PLxor (_1, _3)) )
# 2513 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 270 "cil/src/logic/logic_parser.mly"
      ( info (PLforall (_2, _4)) )
# 2521 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 272 "cil/src/logic/logic_parser.mly"
      ( info (PLexists (_2, _4)) )
# 2529 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 274 "cil/src/logic/logic_parser.mly"
      ( info (PLlambda (_2,_4)) )
# 2537 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 276 "cil/src/logic/logic_parser.mly"
                  ( info (PLbinop (_1, Bbw_and, _3)) )
# 2545 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 277 "cil/src/logic/logic_parser.mly"
                   ( info (PLbinop (_1, Bbw_or, _3)) )
# 2553 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 278 "cil/src/logic/logic_parser.mly"
                  ( info (PLbinop (_1, Bbw_xor, _3)) )
# 2561 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 280 "cil/src/logic/logic_parser.mly"
    ( info (PLif (_1, _3, _5)) )
# 2570 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 282 "cil/src/logic/logic_parser.mly"
                                          ( info (PLnamed (_1, _3)) )
# 2578 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_rel) in
    Obj.repr(
# 283 "cil/src/logic/logic_parser.mly"
                                ( _1 )
# 2585 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'relation) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 288 "cil/src/logic/logic_parser.mly"
  ( _1, _2, fst(relation_sense _1 Unknown), None )
# 2593 "cil/src/logic/logic_parser.ml"
               : 'rel_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relation) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'rel_list) in
    Obj.repr(
# 290 "cil/src/logic/logic_parser.mly"
  (
    let next_rel, rhs, sense, oth_rel = _3 in
    let (sense, correct) = relation_sense _1 sense
    in
    if correct then
      let loc = loc_start _2, loc_end rhs in
      let my_rel = loc_info loc (PLrel(_2,next_rel,rhs)) in
      let oth_rel = match oth_rel with
          None -> my_rel
        | Some rel ->
	    let loc = loc_start _2, loc_end rel in
	    loc_info loc (PLand(my_rel,rel))
      in
      _1,_2,sense,Some oth_rel
    else begin
      let loc = Parsing.rhs_start_pos 1, Parsing.rhs_end_pos 3 in
      raise (Not_well_formed(loc,"Inconsistent relation chain."));
    end
  )
# 2620 "cil/src/logic/logic_parser.ml"
               : 'rel_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 312 "cil/src/logic/logic_parser.mly"
                ( None )
# 2626 "cil/src/logic/logic_parser.ml"
               : 'lexpr_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 313 "cil/src/logic/logic_parser.mly"
                ( Some _1 )
# 2633 "cil/src/logic/logic_parser.ml"
               : 'lexpr_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'binders_reentrance) in
    Obj.repr(
# 318 "cil/src/logic/logic_parser.mly"
                            ( let (_lt, vars) = _1 in vars )
# 2640 "cil/src/logic/logic_parser.ml"
               : 'binders))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 321 "cil/src/logic/logic_parser.mly"
            ( let (lt, var) = _1 in (lt, [var]) )
# 2647 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 323 "cil/src/logic/logic_parser.mly"
    ( let _, vars = _1 in
      let (lt, var) = _3 in
        (lt, vars @ [ var ])
    )
# 2658 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 328 "cil/src/logic/logic_parser.mly"
    ( let last_type_spec, vars = _1 in
        (last_type_spec, vars @ [ let (modif, name) = _3 in (modif last_type_spec, name)])
    )
# 2668 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 333 "cil/src/logic/logic_parser.mly"
                     ( (_1, let (modif, name) = _2 in (modif _1, name))  )
# 2676 "cil/src/logic/logic_parser.ml"
               : 'decl_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis) in
    Obj.repr(
# 337 "cil/src/logic/logic_parser.mly"
                     ( _1 )
# 2683 "cil/src/logic/logic_parser.ml"
               : 'var_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis) in
    Obj.repr(
# 339 "cil/src/logic/logic_parser.mly"
  ( let (modif, name) = _2 in
      ((fun x -> _1 (modif x)), name) )
# 2692 "cil/src/logic/logic_parser.ml"
               : 'var_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 344 "cil/src/logic/logic_parser.mly"
                 ( ((fun x -> x), _1) )
# 2699 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_option) in
    Obj.repr(
# 346 "cil/src/logic/logic_parser.mly"
      ( (* TODO: use size information for LTarray - $3 *)
        let (modif, name) = _1 in
          ((fun x -> LTarray (modif x)), name)
      )
# 2710 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'var_spec) in
    Obj.repr(
# 350 "cil/src/logic/logic_parser.mly"
                     ( _2 )
# 2717 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 351 "cil/src/logic/logic_parser.mly"
                                             ( (* TODO *) raise Parse_error )
# 2725 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    Obj.repr(
# 355 "cil/src/logic/logic_parser.mly"
              ( [ ] )
# 2731 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param_list) in
    Obj.repr(
# 356 "cil/src/logic/logic_parser.mly"
                 ( _1 )
# 2738 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'abs_param_list) in
    Obj.repr(
# 357 "cil/src/logic/logic_parser.mly"
                                 ( (* TODO *) raise Parse_error )
# 2745 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param) in
    Obj.repr(
# 361 "cil/src/logic/logic_parser.mly"
            ( [ _1 ] )
# 2752 "cil/src/logic/logic_parser.ml"
               : 'abs_param_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'abs_param_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param) in
    Obj.repr(
# 362 "cil/src/logic/logic_parser.mly"
                                 ( _1 @ [ _3 ] )
# 2760 "cil/src/logic/logic_parser.ml"
               : 'abs_param_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter) in
    Obj.repr(
# 369 "cil/src/logic/logic_parser.mly"
            ( _1 )
# 2767 "cil/src/logic/logic_parser.ml"
               : 'abs_param))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 375 "cil/src/logic/logic_parser.mly"
             ( LTnamed(_1, []) )
# 2774 "cil/src/logic/logic_parser.ml"
               : 'id_as_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter) in
    Obj.repr(
# 379 "cil/src/logic/logic_parser.mly"
            ( [_1] )
# 2781 "cil/src/logic/logic_parser.ml"
               : 'ne_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'parameter) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_parameters) in
    Obj.repr(
# 380 "cil/src/logic/logic_parser.mly"
                                ( _1 :: _3 )
# 2789 "cil/src/logic/logic_parser.ml"
               : 'ne_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 384 "cil/src/logic/logic_parser.mly"
                     ( let (modif, name) = _2 in (modif _1, name))
# 2797 "cil/src/logic/logic_parser.ml"
               : 'parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id_as_typename) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 385 "cil/src/logic/logic_parser.mly"
                          ( let (modif, name) = _2 in (modif _1, name) )
# 2805 "cil/src/logic/logic_parser.ml"
               : 'parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_option) in
    Obj.repr(
# 392 "cil/src/logic/logic_parser.mly"
                            ( _2 _1 )
# 2813 "cil/src/logic/logic_parser.ml"
               : 'logic_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 396 "cil/src/logic/logic_parser.mly"
             ( LTnamed(_1,[]) )
# 2820 "cil/src/logic/logic_parser.ml"
               : 'logic_rt_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'begin_rt_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'end_rt_type) in
    Obj.repr(
# 397 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 2829 "cil/src/logic/logic_parser.ml"
               : 'logic_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 400 "cil/src/logic/logic_parser.mly"
                              ( fun t -> t )
# 2835 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec) in
    Obj.repr(
# 401 "cil/src/logic/logic_parser.mly"
           ( _1 )
# 2842 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 405 "cil/src/logic/logic_parser.mly"
                          ( _1 )
# 2849 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'stars) in
    Obj.repr(
# 406 "cil/src/logic/logic_parser.mly"
                                         ( _1 )
# 2856 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 407 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_1 t) )
# 2864 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_bis) in
    Obj.repr(
# 408 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_1 t) )
# 2872 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 409 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_3 (_1 t)) )
# 2881 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec_bis) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 410 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _1 (_2 t) )
# 2889 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec) in
    Obj.repr(
# 414 "cil/src/logic/logic_parser.mly"
                     ( _2 )
# 2896 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'abs_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 415 "cil/src/logic/logic_parser.mly"
                                             ( (* TODO *) raise Parse_error )
# 2904 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_bis))
; (fun __caml_parser_env ->
    Obj.repr(
# 419 "cil/src/logic/logic_parser.mly"
             ( fun t -> LTpointer t )
# 2910 "cil/src/logic/logic_parser.ml"
               : 'stars))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    Obj.repr(
# 420 "cil/src/logic/logic_parser.mly"
             ( fun t -> _1 (LTpointer t) )
# 2917 "cil/src/logic/logic_parser.ml"
               : 'stars))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_option) in
    Obj.repr(
# 425 "cil/src/logic/logic_parser.mly"
    (  (* TODO: use size information for LTarray - $2 *)
      fun t -> LTarray t
    )
# 2926 "cil/src/logic/logic_parser.ml"
               : 'tabs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_option) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 429 "cil/src/logic/logic_parser.mly"
    (  (* TODO: use size information for LTarray - $2 *)
      fun t -> LTarray (_4 t)
    )
# 2936 "cil/src/logic/logic_parser.ml"
               : 'tabs))
; (fun __caml_parser_env ->
    Obj.repr(
# 435 "cil/src/logic/logic_parser.mly"
                 ( LTinteger )
# 2942 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 436 "cil/src/logic/logic_parser.mly"
                 ( LTreal )
# 2948 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 437 "cil/src/logic/logic_parser.mly"
                 ( LTvoid )
# 2954 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 438 "cil/src/logic/logic_parser.mly"
                 ( LTint IChar )
# 2960 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 439 "cil/src/logic/logic_parser.mly"
                 ( LTint ISChar )
# 2966 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 440 "cil/src/logic/logic_parser.mly"
                 ( LTint IUChar )
# 2972 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 441 "cil/src/logic/logic_parser.mly"
                 ( LTint IInt )
# 2978 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 442 "cil/src/logic/logic_parser.mly"
                 ( LTint IInt )
# 2984 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 443 "cil/src/logic/logic_parser.mly"
                 ( LTint IUInt )
# 2990 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 444 "cil/src/logic/logic_parser.mly"
                 ( LTint IUInt )
# 2996 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 445 "cil/src/logic/logic_parser.mly"
                 ( LTint IShort )
# 3002 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 446 "cil/src/logic/logic_parser.mly"
                 ( LTint IShort )
# 3008 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 447 "cil/src/logic/logic_parser.mly"
                 ( LTint IUShort )
# 3014 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 448 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3020 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 449 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3026 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 450 "cil/src/logic/logic_parser.mly"
                 ( LTint IULong )
# 3032 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 451 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3038 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 452 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3044 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 453 "cil/src/logic/logic_parser.mly"
                    ( LTint IULong )
# 3050 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 454 "cil/src/logic/logic_parser.mly"
                 ( LTint ILongLong )
# 3056 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 456 "cil/src/logic/logic_parser.mly"
                     ( LTint ILongLong )
# 3062 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 458 "cil/src/logic/logic_parser.mly"
                     ( LTint IULongLong )
# 3068 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 460 "cil/src/logic/logic_parser.mly"
                    ( LTint ILongLong )
# 3074 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 462 "cil/src/logic/logic_parser.mly"
                        ( LTint ILongLong )
# 3080 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 464 "cil/src/logic/logic_parser.mly"
                         ( LTint IULongLong )
# 3086 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 466 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FFloat )
# 3092 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 467 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FDouble )
# 3098 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 468 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FLongDouble )
# 3104 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exit_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 469 "cil/src/logic/logic_parser.mly"
                                 ( LTstruct _3 )
# 3112 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exit_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 470 "cil/src/logic/logic_parser.mly"
                                 ( LTenum _3 )
# 3120 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exit_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 471 "cil/src/logic/logic_parser.mly"
                                  ( LTunion _3 )
# 3128 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 472 "cil/src/logic/logic_parser.mly"
                    ( LTnamed (_1,[]) )
# 3135 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'enter_rt_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'ne_logic_type_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'exit_rt_type) in
    Obj.repr(
# 474 "cil/src/logic/logic_parser.mly"
      ( LTnamed(_1,_4) )
# 3145 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type) in
    Obj.repr(
# 478 "cil/src/logic/logic_parser.mly"
                                      ( [_1] )
# 3152 "cil/src/logic/logic_parser.ml"
               : 'ne_logic_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'enter_rt_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'ne_logic_type_list) in
    Obj.repr(
# 479 "cil/src/logic/logic_parser.mly"
                                                    ( _1 :: _4 )
# 3161 "cil/src/logic/logic_parser.ml"
               : 'ne_logic_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 485 "cil/src/logic/logic_parser.mly"
                                     ( _2 )
# 3170 "cil/src/logic/logic_parser.ml"
               : 'full_lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 489 "cil/src/logic/logic_parser.mly"
                                          ( _2 )
# 3179 "cil/src/logic/logic_parser.ml"
               : 'full_identifier))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ne_parameters) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 493 "cil/src/logic/logic_parser.mly"
                                             ( _2 )
# 3188 "cil/src/logic/logic_parser.ml"
               : 'full_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'parameter) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 497 "cil/src/logic/logic_parser.mly"
                                         ( _2 )
# 3197 "cil/src/logic/logic_parser.ml"
               : 'full_parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 507 "cil/src/logic/logic_parser.mly"
                                             ( _2 )
# 3206 "cil/src/logic/logic_parser.ml"
               : 'full_ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 511 "cil/src/logic/logic_parser.mly"
                                          ( _2 )
# 3215 "cil/src/logic/logic_parser.ml"
               : 'full_logic_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 515 "cil/src/logic/logic_parser.mly"
                                               ( _2 )
# 3224 "cil/src/logic/logic_parser.ml"
               : 'full_logic_rt_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'assigns) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 518 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 3233 "cil/src/logic/logic_parser.ml"
               : 'full_assigns))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'location_dep) in
    Obj.repr(
# 522 "cil/src/logic/logic_parser.mly"
               ( _1 )
# 3240 "cil/src/logic/logic_parser.ml"
               : 'assigns))
; (fun __caml_parser_env ->
    Obj.repr(
# 523 "cil/src/logic/logic_parser.mly"
          ( [Nothing,[]] )
# 3246 "cil/src/logic/logic_parser.ml"
               : 'assigns))
; (fun __caml_parser_env ->
    Obj.repr(
# 527 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3252 "cil/src/logic/logic_parser.ml"
               : 'requires))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'requires) in
    Obj.repr(
# 528 "cil/src/logic/logic_parser.mly"
                                         ( _2::_4 )
# 3260 "cil/src/logic/logic_parser.ml"
               : 'requires))
; (fun __caml_parser_env ->
    Obj.repr(
# 533 "cil/src/logic/logic_parser.mly"
                ( [],[],[] )
# 3266 "cil/src/logic/logic_parser.ml"
               : 'behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_behavior_body) in
    Obj.repr(
# 534 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 3273 "cil/src/logic/logic_parser.ml"
               : 'behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 538 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in _2::a,b,c )
# 3281 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 540 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in a,_2::b,c )
# 3289 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_assigns) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 542 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in
      let assigns =
        match c,_2 with
            ([] | [(Nothing,_) ]), ([] | [(Nothing,_) ]) -> [(Nothing,[])]
          | [(Nothing,_) ], _ | _, [(Nothing,_)] ->
              raise (
                Not_well_formed (loc(),"Mixing \\nothing and a real location"))
          | _,_ -> _2 @ c
      in a,b,assigns
    )
# 3306 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    Obj.repr(
# 566 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3312 "cil/src/logic/logic_parser.ml"
               : 'behaviors))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'behavior_body) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'behaviors) in
    Obj.repr(
# 568 "cil/src/logic/logic_parser.mly"
      ( let (assumes,ensures,assigns) = _4 in
        Logic_utils.check_assigns ~loc:(loc()) assigns;
        {b_name=_2; b_assumes = assumes;
         b_ensures = ensures;
         b_assigns = assigns}::_5 )
# 3325 "cil/src/logic/logic_parser.ml"
               : 'behaviors))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'behavior_body) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'terminates) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 577 "cil/src/logic/logic_parser.mly"
      ( let (assumes1, ensures1, assigns1) = _1 in
        let (assumes2, ensures2,assigns2) = _3 in
        (Some _2, (assumes1 @ assumes2,
                      ensures1 @ ensures2, assigns1 @ assigns2))
      )
# 3338 "cil/src/logic/logic_parser.ml"
               : 'simple_behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 582 "cil/src/logic/logic_parser.mly"
                ( (None, _1) )
# 3345 "cil/src/logic/logic_parser.ml"
               : 'simple_behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'simple_behavior_body) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'behaviors) in
    Obj.repr(
# 587 "cil/src/logic/logic_parser.mly"
    ( let (terminates,(assumes,ensures,assigns)) = _1 in
      let behaviors =
        if (*TODO: enforce to have a default behavior true || *)
           assumes <> [] || ensures <> [] || assigns <> [] then
          { b_name = "default";b_assumes = assumes;
            b_ensures = ensures;
            b_assigns = assigns} :: _2
        else _2
      in
      terminates, behaviors
    )
# 3363 "cil/src/logic/logic_parser.ml"
               : 'behaviors_or_default))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 600 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 3370 "cil/src/logic/logic_parser.ml"
               : 'terminates))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 604 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 3377 "cil/src/logic/logic_parser.ml"
               : 'ne_full_identifier_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_full_identifier_list) in
    Obj.repr(
# 605 "cil/src/logic/logic_parser.mly"
                                                (_1 :: _3)
# 3385 "cil/src/logic/logic_parser.ml"
               : 'ne_full_identifier_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 609 "cil/src/logic/logic_parser.mly"
                ( [],[] )
# 3391 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'ne_full_identifier_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'complete_or_disjoint) in
    Obj.repr(
# 611 "cil/src/logic/logic_parser.mly"
      ( let (complete,disjoint) = _5 in (_3::complete, disjoint) )
# 3399 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'ne_full_identifier_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'complete_or_disjoint) in
    Obj.repr(
# 613 "cil/src/logic/logic_parser.mly"
      ( let (complete,disjoint) = _5 in (complete, _3::disjoint) )
# 3407 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'requires) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'behaviors_or_default) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'complete_or_disjoint) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'decreases) in
    Obj.repr(
# 617 "cil/src/logic/logic_parser.mly"
      (
        { spec_requires = _1;
          spec_behavior = snd _2;
          spec_variant = _4;
          spec_terminates = fst _2;
          spec_complete_behaviors = fst _3;
          spec_disjoint_behaviors = snd _3;
        },loc() )
# 3424 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.spec * Cabs.cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 632 "cil/src/logic/logic_parser.mly"
           ( () )
# 3430 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 633 "cil/src/logic/logic_parser.mly"
           ( () )
# 3436 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 634 "cil/src/logic/logic_parser.mly"
          ( () )
# 3442 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 635 "cil/src/logic/logic_parser.mly"
          ( () )
# 3448 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 636 "cil/src/logic/logic_parser.mly"
            ( () )
# 3454 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 637 "cil/src/logic/logic_parser.mly"
             ( () )
# 3460 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 638 "cil/src/logic/logic_parser.mly"
           ( () )
# 3466 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_stack) in
    Obj.repr(
# 644 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _1 in
      let invs = List.map (fun i -> AInvariant([],true,i)) i in
      let assigns = List.map (fun i -> AAssigns([],i)) a in
      (invs@assigns@b,v,p)
(*
      match i,a with
	| [],[] -> (b,v,p)
	| _ -> (ALoopBehavior([],i,a)::b,v,p)
*)
    )
# 3482 "cil/src/logic/logic_parser.ml"
               : 'loop_annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_invariant) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 658 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (_1::i,a,b,v,p) )
# 3490 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_effects) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 660 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (i,_1 @ a,b,v,p) )
# 3498 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'ne_full_identifier_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 662 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _4 in
      let behav = _2 in
      let invs = List.map (fun i -> AInvariant(behav,true,i)) i in
      let assigns = List.map (fun i -> AAssigns(behav,i)) a in
      ([],[],invs@assigns@b,v,p) )
# 3510 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_variant) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 668 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (i,a,b,AVariant _1::v,p) )
# 3518 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_pragma) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 670 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (i,a,b,v,APragma (Loop_pragma _1)::p) )
# 3526 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    Obj.repr(
# 675 "cil/src/logic/logic_parser.mly"
    ( ([],[],[],[],[]) )
# 3532 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_stack) in
    Obj.repr(
# 677 "cil/src/logic/logic_parser.mly"
    ( _1 )
# 3539 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_opt))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 6 : 'full_identifier) in
    let _5 = (Parsing.peek_val __caml_parser_env 4 : 'full_parameter) in
    let _8 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 686 "cil/src/logic/logic_parser.mly"
  ( let typ,name = _5 in{ inv_name = _3; this_name = name; this_type = typ; inv = _8; } )
# 3548 "cil/src/logic/logic_parser.ml"
               : 'type_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 690 "cil/src/logic/logic_parser.mly"
                                 ( (_1, Some _3) )
# 3556 "cil/src/logic/logic_parser.ml"
               : 'variant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_lexpr) in
    Obj.repr(
# 691 "cil/src/logic/logic_parser.mly"
                            ( (_1, None) )
# 3563 "cil/src/logic/logic_parser.ml"
               : 'variant))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 695 "cil/src/logic/logic_parser.mly"
                                      ( _3 )
# 3570 "cil/src/logic/logic_parser.ml"
               : 'loop_invariant))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'variant) in
    Obj.repr(
# 699 "cil/src/logic/logic_parser.mly"
                                 ( _3 )
# 3577 "cil/src/logic/logic_parser.ml"
               : 'loop_variant))
; (fun __caml_parser_env ->
    Obj.repr(
# 703 "cil/src/logic/logic_parser.mly"
                  ( None )
# 3583 "cil/src/logic/logic_parser.ml"
               : 'decreases))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'variant) in
    Obj.repr(
# 704 "cil/src/logic/logic_parser.mly"
                              ( Some _2 )
# 3590 "cil/src/logic/logic_parser.ml"
               : 'decreases))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'slice_pragma) in
    Obj.repr(
# 708 "cil/src/logic/logic_parser.mly"
                   ( APragma (Slice_pragma _1) )
# 3597 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'impact_pragma) in
    Obj.repr(
# 709 "cil/src/logic/logic_parser.mly"
                   ( APragma (Impact_pragma _1) )
# 3604 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'ne_full_identifier_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 711 "cil/src/logic/logic_parser.mly"
      ( AAssert (_2,_5,{status=Cil_types.Unknown}) )
# 3612 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 712 "cil/src/logic/logic_parser.mly"
                                 ( AAssert ([],_2,{status=Cil_types.Unknown}) )
# 3619 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 713 "cil/src/logic/logic_parser.mly"
                                 ( AInvariant ([],false,_2) )
# 3626 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    Obj.repr(
# 717 "cil/src/logic/logic_parser.mly"
              ( )
# 3632 "cil/src/logic/logic_parser.ml"
               : 'loop_pragma_tk))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'loop_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_ne_lexpr_list) in
    Obj.repr(
# 722 "cil/src/logic/logic_parser.mly"
  ( if _2 = "UNROLL_LOOP" || _2 = "UNROLL" then
      match _3 with
        | [level] -> Unroll_level level
        | _ -> raise(
            Not_well_formed(loc(),"usage: loop pragma UNROLL n;"))
    else if _2 = "WIDEN_VARIABLES" then
      Widen_variables _3
    else if _2 = "WIDEN_HINTS" then
      Widen_hints _3
    else raise (Not_well_formed (loc(),"unknown loop pragma")) )
# 3650 "cil/src/logic/logic_parser.ml"
               : 'loop_pragma))
; (fun __caml_parser_env ->
    Obj.repr(
# 734 "cil/src/logic/logic_parser.mly"
               ( )
# 3656 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma_tk))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'slice_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 739 "cil/src/logic/logic_parser.mly"
    ( if _2 = "expr" then SPexpr _3
      else raise (Not_well_formed (loc(), "unknown slice pragma")) )
# 3666 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'slice_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 742 "cil/src/logic/logic_parser.mly"
    ( if _2 = "ctrl" then SPctrl
      else if _2 = "stmt" then SPstmt
      else raise (Not_well_formed (loc(), "unknown slice pragma")) )
# 3676 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 748 "cil/src/logic/logic_parser.mly"
    ( if _3 = "expr" then IPexpr _4
      else raise (Not_well_formed (loc(), "unknown impact pragma")) )
# 3685 "cil/src/logic/logic_parser.ml"
               : 'impact_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 751 "cil/src/logic/logic_parser.mly"
    ( if _3 = "stmt" then IPstmt
      else raise (Not_well_formed (loc(), "unknown impact pragma")) )
# 3693 "cil/src/logic/logic_parser.ml"
               : 'impact_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_assigns) in
    Obj.repr(
# 755 "cil/src/logic/logic_parser.mly"
                                      ( _3 )
# 3700 "cil/src/logic/logic_parser.ml"
               : 'loop_effects))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'zones) in
    Obj.repr(
# 759 "cil/src/logic/logic_parser.mly"
        ( List.map (fun x -> (x,[])) _1 )
# 3707 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'zones) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'zones) in
    Obj.repr(
# 760 "cil/src/logic/logic_parser.mly"
                   (List.map (fun x -> (x, _3)) _1)
# 3715 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'zones) in
    Obj.repr(
# 761 "cil/src/logic/logic_parser.mly"
                      (List.map (fun x -> (x, [Nothing])) _1)
# 3722 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 763 "cil/src/logic/logic_parser.mly"
              ( List.map (fun x -> Location x) _1 )
# 3729 "cil/src/logic/logic_parser.ml"
               : 'zones))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'location) in
    Obj.repr(
# 766 "cil/src/logic/logic_parser.mly"
           ( [_1] )
# 3736 "cil/src/logic/logic_parser.ml"
               : 'tsets))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'location) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 767 "cil/src/logic/logic_parser.mly"
                       ( _1 :: _3 )
# 3744 "cil/src/logic/logic_parser.ml"
               : 'tsets))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 771 "cil/src/logic/logic_parser.mly"
        ( _1 )
# 3751 "cil/src/logic/logic_parser.ml"
               : 'location))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 776 "cil/src/logic/logic_parser.mly"
    ( enter_type_variables_scope []; (_1,[]) )
# 3758 "cil/src/logic/logic_parser.ml"
               : 'poly_id_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 778 "cil/src/logic/logic_parser.mly"
        ( enter_type_variables_scope _3; (_1,_3) )
# 3766 "cil/src/logic/logic_parser.ml"
               : 'poly_id_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'poly_id_type) in
    Obj.repr(
# 784 "cil/src/logic/logic_parser.mly"
               ( let (id,_) = _1 in Logic_env.add_typename id; _1 )
# 3773 "cil/src/logic/logic_parser.ml"
               : 'poly_id_type_add_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'poly_id_type) in
    Obj.repr(
# 787 "cil/src/logic/logic_parser.mly"
               ( let (name,ty_vars) = _1 in
                 (name,[],ty_vars)
               )
# 3782 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_label_list) in
    Obj.repr(
# 790 "cil/src/logic/logic_parser.mly"
                                              (
    enter_type_variables_scope [];
    (_1,_3,[]) )
# 3792 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'ne_label_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 793 "cil/src/logic/logic_parser.mly"
                                                                 (
    enter_type_variables_scope _6;
    _1,_3,_6
  )
# 3804 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 799 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3811 "cil/src/logic/logic_parser.ml"
               : 'identifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 803 "cil/src/logic/logic_parser.mly"
              ( [] )
# 3817 "cil/src/logic/logic_parser.ml"
               : 'opt_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameters) in
    Obj.repr(
# 804 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3824 "cil/src/logic/logic_parser.ml"
               : 'opt_parameters))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_parameters) in
    Obj.repr(
# 808 "cil/src/logic/logic_parser.mly"
                            ( _2 )
# 3831 "cil/src/logic/logic_parser.ml"
               : 'parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_def) in
    Obj.repr(
# 812 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3838 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'deprecated_logic_decl) in
    Obj.repr(
# 814 "cil/src/logic/logic_parser.mly"
    ( _1 )
# 3845 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 816 "cil/src/logic/logic_parser.mly"
    ( LDinvariant (_3, _5) )
# 3853 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_annot) in
    Obj.repr(
# 817 "cil/src/logic/logic_parser.mly"
             (LDtype_annot _1)
# 3860 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'full_logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'opt_parameters) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 823 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      exit_type_variables_scope ();
      LDlogic_def (id, labels, tvars, _2, _4, _6) )
# 3872 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'opt_parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 828 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDpredicate_def (id, labels, tvars, _3, _5) )
# 3883 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'indcases) in
    Obj.repr(
# 833 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDinductive_def(id, labels, tvars, _3, _5) )
# 3894 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 837 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDlemma (id, false, labels, tvars, _4) )
# 3904 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'logic_decls) in
    Obj.repr(
# 841 "cil/src/logic/logic_parser.mly"
    ( LDaxiomatic(_2,_4) )
# 3912 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id_type_add_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'datacons_list) in
    Obj.repr(
# 843 "cil/src/logic/logic_parser.mly"
        ( let (id,tvars) = _2 in
          exit_type_variables_scope ();
          LDtype(id,tvars,Some _4)
        )
# 3923 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 852 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      exit_type_variables_scope ();
      Format.eprintf "Warning: deprecated logic declaration '%s', should be declared inside an axiomatic block@." id;
      LDlogic_reads (id, labels, tvars, _2, _4, []) )
# 3935 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 858 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      Format.eprintf "Warning: deprecated logic declaration `%s', should be declared inside an axiomatic block@." id;
      LDpredicate_reads (id, labels, tvars, _3, []) )
# 3946 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'poly_id_type) in
    Obj.repr(
# 864 "cil/src/logic/logic_parser.mly"
    ( let (id,tvars) = _2 in
      Logic_env.add_typename id;
      exit_type_variables_scope ();
      Format.eprintf "Warning: deprecated logic type declaration `%s', should be declared inside an axiomatic block@." id;
      LDtype(id,tvars,None) )
# 3957 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    Obj.repr(
# 874 "cil/src/logic/logic_parser.mly"
    ( [] )
# 3963 "cil/src/logic/logic_parser.ml"
               : 'logic_decls))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'logic_decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'logic_decls) in
    Obj.repr(
# 876 "cil/src/logic/logic_parser.mly"
    ( _1::_2 )
# 3971 "cil/src/logic/logic_parser.ml"
               : 'logic_decls))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_def) in
    Obj.repr(
# 880 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3978 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'full_logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'opt_parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'reads_clause) in
    Obj.repr(
# 883 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      exit_type_variables_scope ();
      LDlogic_reads (id, labels, tvars, _2, _4, _5) )
# 3990 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'opt_parameters) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'reads_clause) in
    Obj.repr(
# 888 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDpredicate_reads (id, labels, tvars, _3, _4) )
# 4001 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'poly_id_type) in
    Obj.repr(
# 893 "cil/src/logic/logic_parser.mly"
    ( let (id,tvars) = _2 in
      Logic_env.add_typename id;
      exit_type_variables_scope ();
      LDtype(id,tvars,None) )
# 4011 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 899 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDlemma (id, true, labels, tvars, _4) )
# 4021 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    Obj.repr(
# 906 "cil/src/logic/logic_parser.mly"
    ( [] )
# 4027 "cil/src/logic/logic_parser.ml"
               : 'reads_clause))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 908 "cil/src/logic/logic_parser.mly"
    ( _2 )
# 4034 "cil/src/logic/logic_parser.ml"
               : 'reads_clause))
; (fun __caml_parser_env ->
    Obj.repr(
# 912 "cil/src/logic/logic_parser.mly"
                ( [] )
# 4040 "cil/src/logic/logic_parser.ml"
               : 'datacons_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_datacons_list) in
    Obj.repr(
# 913 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 4047 "cil/src/logic/logic_parser.ml"
               : 'datacons_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'datacons) in
    Obj.repr(
# 914 "cil/src/logic/logic_parser.mly"
           ( [_1] )
# 4054 "cil/src/logic/logic_parser.ml"
               : 'datacons_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'datacons) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ne_datacons_list) in
    Obj.repr(
# 915 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _2)
# 4062 "cil/src/logic/logic_parser.ml"
               : 'datacons_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'datacons) in
    Obj.repr(
# 919 "cil/src/logic/logic_parser.mly"
                ( [_2] )
# 4069 "cil/src/logic/logic_parser.ml"
               : 'ne_datacons_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'datacons) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_datacons_list) in
    Obj.repr(
# 920 "cil/src/logic/logic_parser.mly"
                                 ( _2 :: _3 )
# 4077 "cil/src/logic/logic_parser.ml"
               : 'ne_datacons_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 924 "cil/src/logic/logic_parser.mly"
                  ( (_1,[]) )
# 4084 "cil/src/logic/logic_parser.ml"
               : 'datacons))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_type_list) in
    Obj.repr(
# 925 "cil/src/logic/logic_parser.mly"
                                         ( (_1,_3) )
# 4092 "cil/src/logic/logic_parser.ml"
               : 'datacons))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_logic_type) in
    Obj.repr(
# 929 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 4099 "cil/src/logic/logic_parser.ml"
               : 'ne_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_type_list) in
    Obj.repr(
# 930 "cil/src/logic/logic_parser.mly"
                                     ( _1::_3 )
# 4107 "cil/src/logic/logic_parser.ml"
               : 'ne_type_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 934 "cil/src/logic/logic_parser.mly"
    ( [] )
# 4113 "cil/src/logic/logic_parser.ml"
               : 'indcases))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'indcases) in
    Obj.repr(
# 936 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      (id,labels,tvars,_4)::_6 )
# 4124 "cil/src/logic/logic_parser.ml"
               : 'indcases))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 943 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 4131 "cil/src/logic/logic_parser.ml"
               : 'ne_tvar_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_tvar_list) in
    Obj.repr(
# 944 "cil/src/logic/logic_parser.mly"
                                     ( _1 :: _3 )
# 4139 "cil/src/logic/logic_parser.ml"
               : 'ne_tvar_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'label) in
    Obj.repr(
# 948 "cil/src/logic/logic_parser.mly"
        ( [_1] )
# 4146 "cil/src/logic/logic_parser.ml"
               : 'ne_label_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'label) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_label_list) in
    Obj.repr(
# 949 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _3 )
# 4154 "cil/src/logic/logic_parser.ml"
               : 'ne_label_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 953 "cil/src/logic/logic_parser.mly"
                  ( _1 )
# 4161 "cil/src/logic/logic_parser.ml"
               : 'label))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'annotation) in
    Obj.repr(
# 957 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 4168 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 961 "cil/src/logic/logic_parser.mly"
       ( [(loc(), _1)] )
# 4175 "cil/src/logic/logic_parser.ml"
               : 'decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_list) in
    Obj.repr(
# 962 "cil/src/logic/logic_parser.mly"
                 ( (loc(),_1) :: _2 )
# 4183 "cil/src/logic/logic_parser.ml"
               : 'decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_list) in
    Obj.repr(
# 965 "cil/src/logic/logic_parser.mly"
                        ( Adecl (_1) )
# 4190 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'is_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'any) in
    Obj.repr(
# 966 "cil/src/logic/logic_parser.mly"
                   ( Aspec )
# 4198 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annotations) in
    Obj.repr(
# 968 "cil/src/logic/logic_parser.mly"
      ( let (b,v,p) = _1 in
	(* TODO: do better, do not lose the structure ! *)
	let l = b@v@p in
	Logic_utils.check_loop_annotation ~loc:(loc()) l;
        Aloop_annot (loc (), l) )
# 4209 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'code_annotation) in
    Obj.repr(
# 973 "cil/src/logic/logic_parser.mly"
                  ( Acode_annot (loc(),_1) )
# 4216 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 974 "cil/src/logic/logic_parser.mly"
                  ( Aattribute_annot (loc (), _1) )
# 4223 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'wildcard) in
    Obj.repr(
# 979 "cil/src/logic/logic_parser.mly"
           ( () )
# 4230 "cil/src/logic/logic_parser.ml"
               : 'any))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'wildcard) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'any) in
    Obj.repr(
# 980 "cil/src/logic/logic_parser.mly"
               ( () )
# 4238 "cil/src/logic/logic_parser.ml"
               : 'any))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 984 "cil/src/logic/logic_parser.mly"
             ( () )
# 4245 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 985 "cil/src/logic/logic_parser.mly"
                 ( () )
# 4252 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 986 "cil/src/logic/logic_parser.mly"
           ( () )
# 4259 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 987 "cil/src/logic/logic_parser.mly"
           ( () )
# 4266 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 988 "cil/src/logic/logic_parser.mly"
       ( () )
# 4272 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 989 "cil/src/logic/logic_parser.mly"
       ( () )
# 4278 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 990 "cil/src/logic/logic_parser.mly"
     ( () )
# 4284 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 991 "cil/src/logic/logic_parser.mly"
       ( () )
# 4290 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 992 "cil/src/logic/logic_parser.mly"
        ( () )
# 4296 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 993 "cil/src/logic/logic_parser.mly"
         ( () )
# 4302 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 994 "cil/src/logic/logic_parser.mly"
             ( () )
# 4308 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 995 "cil/src/logic/logic_parser.mly"
      ( () )
# 4314 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 996 "cil/src/logic/logic_parser.mly"
         ( () )
# 4320 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 997 "cil/src/logic/logic_parser.mly"
            ( () )
# 4326 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 998 "cil/src/logic/logic_parser.mly"
      ( () )
# 4332 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 999 "cil/src/logic/logic_parser.mly"
          ( () )
# 4338 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1000 "cil/src/logic/logic_parser.mly"
       ( () )
# 4344 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1001 "cil/src/logic/logic_parser.mly"
        ( () )
# 4350 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1002 "cil/src/logic/logic_parser.mly"
     ( () )
# 4356 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1003 "cil/src/logic/logic_parser.mly"
     ( () )
# 4362 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1004 "cil/src/logic/logic_parser.mly"
     ( () )
# 4368 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1005 "cil/src/logic/logic_parser.mly"
     ( () )
# 4374 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1006 "cil/src/logic/logic_parser.mly"
     ( () )
# 4380 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1007 "cil/src/logic/logic_parser.mly"
     ( () )
# 4386 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1008 "cil/src/logic/logic_parser.mly"
        ( () )
# 4392 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1009 "cil/src/logic/logic_parser.mly"
        ( () )
# 4398 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1010 "cil/src/logic/logic_parser.mly"
        ( () )
# 4404 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1011 "cil/src/logic/logic_parser.mly"
         ( () )
# 4410 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1012 "cil/src/logic/logic_parser.mly"
         ( () )
# 4416 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1013 "cil/src/logic/logic_parser.mly"
      ( () )
# 4422 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1014 "cil/src/logic/logic_parser.mly"
          ( () )
# 4428 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1015 "cil/src/logic/logic_parser.mly"
      ( () )
# 4434 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1016 "cil/src/logic/logic_parser.mly"
     ( () )
# 4440 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1017 "cil/src/logic/logic_parser.mly"
      ( () )
# 4446 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1018 "cil/src/logic/logic_parser.mly"
       ( () )
# 4452 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1019 "cil/src/logic/logic_parser.mly"
        ( () )
# 4458 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1020 "cil/src/logic/logic_parser.mly"
      ( () )
# 4464 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1021 "cil/src/logic/logic_parser.mly"
     ( () )
# 4470 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1022 "cil/src/logic/logic_parser.mly"
         ( () )
# 4476 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1023 "cil/src/logic/logic_parser.mly"
               ( () )
# 4482 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1024 "cil/src/logic/logic_parser.mly"
            ( () )
# 4488 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1025 "cil/src/logic/logic_parser.mly"
        ( () )
# 4494 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1026 "cil/src/logic/logic_parser.mly"
              ( () )
# 4500 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1027 "cil/src/logic/logic_parser.mly"
              ( () )
# 4506 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1028 "cil/src/logic/logic_parser.mly"
        ( () )
# 4512 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1029 "cil/src/logic/logic_parser.mly"
         ( () )
# 4518 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1030 "cil/src/logic/logic_parser.mly"
           ( () )
# 4524 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1031 "cil/src/logic/logic_parser.mly"
        ( () )
# 4530 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1032 "cil/src/logic/logic_parser.mly"
       ( () )
# 4536 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1033 "cil/src/logic/logic_parser.mly"
       ( () )
# 4542 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1034 "cil/src/logic/logic_parser.mly"
      ( () )
# 4548 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1035 "cil/src/logic/logic_parser.mly"
        ( () )
# 4554 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1036 "cil/src/logic/logic_parser.mly"
          ( () )
# 4560 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1037 "cil/src/logic/logic_parser.mly"
          ( () )
# 4566 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1038 "cil/src/logic/logic_parser.mly"
          ( () )
# 4572 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1039 "cil/src/logic/logic_parser.mly"
         ( () )
# 4578 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1040 "cil/src/logic/logic_parser.mly"
            ( () )
# 4584 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1041 "cil/src/logic/logic_parser.mly"
          ( () )
# 4590 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1042 "cil/src/logic/logic_parser.mly"
            ( () )
# 4596 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1043 "cil/src/logic/logic_parser.mly"
      ( () )
# 4602 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1044 "cil/src/logic/logic_parser.mly"
        ( () )
# 4608 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1045 "cil/src/logic/logic_parser.mly"
         ( () )
# 4614 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1046 "cil/src/logic/logic_parser.mly"
            ( () )
# 4620 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1047 "cil/src/logic/logic_parser.mly"
       ( () )
# 4626 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1048 "cil/src/logic/logic_parser.mly"
        ( () )
# 4632 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1049 "cil/src/logic/logic_parser.mly"
           ( () )
# 4638 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1050 "cil/src/logic/logic_parser.mly"
          ( () )
# 4644 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1051 "cil/src/logic/logic_parser.mly"
          ( () )
# 4650 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1052 "cil/src/logic/logic_parser.mly"
       ( () )
# 4656 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1053 "cil/src/logic/logic_parser.mly"
          ( () )
# 4662 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1054 "cil/src/logic/logic_parser.mly"
        ( () )
# 4668 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1055 "cil/src/logic/logic_parser.mly"
         ( () )
# 4674 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1056 "cil/src/logic/logic_parser.mly"
       ( () )
# 4680 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1057 "cil/src/logic/logic_parser.mly"
        ( () )
# 4686 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1058 "cil/src/logic/logic_parser.mly"
        ( () )
# 4692 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1059 "cil/src/logic/logic_parser.mly"
            ( () )
# 4698 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1060 "cil/src/logic/logic_parser.mly"
        ( () )
# 4704 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1061 "cil/src/logic/logic_parser.mly"
        ( () )
# 4710 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1062 "cil/src/logic/logic_parser.mly"
         ( () )
# 4716 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1063 "cil/src/logic/logic_parser.mly"
         ( () )
# 4722 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1064 "cil/src/logic/logic_parser.mly"
        ( () )
# 4728 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1065 "cil/src/logic/logic_parser.mly"
       ( () )
# 4734 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1066 "cil/src/logic/logic_parser.mly"
       ( () )
# 4740 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1067 "cil/src/logic/logic_parser.mly"
         ( () )
# 4746 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1068 "cil/src/logic/logic_parser.mly"
           ( () )
# 4752 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1069 "cil/src/logic/logic_parser.mly"
        ( () )
# 4758 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1070 "cil/src/logic/logic_parser.mly"
       ( () )
# 4764 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1071 "cil/src/logic/logic_parser.mly"
         ( () )
# 4770 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1072 "cil/src/logic/logic_parser.mly"
         ( () )
# 4776 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1073 "cil/src/logic/logic_parser.mly"
       ( () )
# 4782 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1074 "cil/src/logic/logic_parser.mly"
        ( () )
# 4788 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1075 "cil/src/logic/logic_parser.mly"
          ( () )
# 4794 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1076 "cil/src/logic/logic_parser.mly"
        ( () )
# 4800 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1077 "cil/src/logic/logic_parser.mly"
          ( () )
# 4806 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1078 "cil/src/logic/logic_parser.mly"
          ( () )
# 4812 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1079 "cil/src/logic/logic_parser.mly"
       ( () )
# 4818 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1080 "cil/src/logic/logic_parser.mly"
           ( () )
# 4824 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1081 "cil/src/logic/logic_parser.mly"
          ( () )
# 4830 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1082 "cil/src/logic/logic_parser.mly"
      ( () )
# 4836 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1083 "cil/src/logic/logic_parser.mly"
         ( () )
# 4842 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1084 "cil/src/logic/logic_parser.mly"
       ( () )
# 4848 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1085 "cil/src/logic/logic_parser.mly"
        ( () )
# 4854 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1086 "cil/src/logic/logic_parser.mly"
       ( () )
# 4860 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1087 "cil/src/logic/logic_parser.mly"
       ( () )
# 4866 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1088 "cil/src/logic/logic_parser.mly"
         ( () )
# 4872 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1089 "cil/src/logic/logic_parser.mly"
           ( () )
# 4878 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1090 "cil/src/logic/logic_parser.mly"
            ( () )
# 4884 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1091 "cil/src/logic/logic_parser.mly"
           ( () )
# 4890 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1092 "cil/src/logic/logic_parser.mly"
             ( () )
# 4896 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1093 "cil/src/logic/logic_parser.mly"
         ( () )
# 4902 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1094 "cil/src/logic/logic_parser.mly"
         ( () )
# 4908 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1095 "cil/src/logic/logic_parser.mly"
         ( () )
# 4914 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1096 "cil/src/logic/logic_parser.mly"
            ( () )
# 4920 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
(* Entry lexpr *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry annot *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry spec *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let lexpr (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Logic_ptree.lexpr)
let annot (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : Logic_ptree.annot)
let spec (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 3 lexfun lexbuf : Logic_ptree.spec * Cabs.cabsloc)
;;
# 1100 "cil/src/logic/logic_parser.mly"

(*
Local Variables:
compile-command: "make -C ../../.."
End:
*)
# 4960 "cil/src/logic/logic_parser.ml"
