/* FIGARO'S PASSWORD MANAGER 2 (FPM2)
 * Copyright (C) 2000 John Conneely
 * Copyright (C) 2008,2009 Aleš Koval
 *
 * FPM is open source / free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FPM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * fpm_clist.c
 */

#include "fpm.h"
#include "support.h"
#include <string.h>

static gint
fpm_cmp_title(fpm_data *a, fpm_data *b)
{
  return(g_utf8_collate(a->title, b->title));
}

void
fpm_create_category_list(gint edit_flag)
{
  GList *list;
  fpm_data *data;
//  GCompareFunc cmp_func;


  /* Clear cat list */
  list = g_list_first(glb_cat_string_list);
  while(list!=NULL)
  {
    g_assert(list->data!=NULL);
    g_free(list->data);
    list=g_list_next(list);
  }
  g_list_free(glb_cat_string_list);
  glb_cat_string_list = NULL;

//  cmp_func = (GCompareFunc) g_strcasecmp;
//  cmp_func = (GCompareFunc) g_utf8_collate;

  /* Step through pass list adding to cat list */
  list = g_list_first(glb_pass_list);
  while(list!=NULL)
  {
    data = list->data;
    if (
	strcmp(data->category, "") &&
	    g_list_find_custom(glb_cat_string_list, data->category, (GCompareFunc) g_utf8_collate) == NULL)
    {
      g_assert(data->category != NULL);
      glb_cat_string_list = g_list_insert_sorted(glb_cat_string_list,
		g_strdup(data->category), (GCompareFunc) g_utf8_collate);
    }
    list=g_list_next(list);
  }



  if(edit_flag)
  {
    /* Add first item entry to beginning of list */
    glb_cat_string_list = g_list_prepend(glb_cat_string_list, g_strdup(""));
  }
  else
  {
    /* Add all category and default category */
    glb_cat_string_list = g_list_prepend(glb_cat_string_list, g_strdup(FPM_NONE_CAT_MSG));
    glb_cat_string_list = g_list_prepend(glb_cat_string_list, g_strdup(FPM_DEFAULT_CAT_MSG));
    glb_cat_string_list = g_list_prepend(glb_cat_string_list, g_strdup(FPM_ALL_CAT_MSG));
  }
}

void
fpm_populate_combo_box(GtkComboBox *combo_box, gchar *active_item) {
  GList* list;
  gint i, index;
  GtkTreeModel *combo_box_model;

  fpm_create_category_list(0);
  g_assert(glb_cat_string_list!=NULL);

  combo_box_model = GTK_TREE_MODEL(gtk_list_store_new (1, G_TYPE_STRING));

  gtk_combo_box_set_model(combo_box, combo_box_model);

  list=g_list_first(glb_cat_string_list);
  i=0;
  index=0;
  while(list!=NULL)
  {
//    gtk_combo_box_append_text(combo_box, g_strdup(list->data));
    gtk_combo_box_append_text(combo_box, list->data);

    if(!strcmp(active_item, list->data))
	index=i;
    i++;
    list=g_list_next(list);
  }

  gtk_combo_box_set_active(combo_box, index);
}

void
fpm_clist_populate_cat_list()
{
	fpm_populate_combo_box(GTK_COMBO_BOX(lookup_widget(gui->main_window, "optionmenu_category")), state->category);
}

void
fpm_clist_init()
{
  GtkListStore *main_list_store;
  GtkCellRenderer* cellRenderer;
  GtkTreeViewColumn* treeViewColumn;

  main_list_store = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_STRING,
					G_TYPE_STRING, G_TYPE_POINTER);

  gtk_tree_view_set_model (gui->main_clist, GTK_TREE_MODEL (main_list_store));

  cellRenderer = gtk_cell_renderer_text_new();
  treeViewColumn = gtk_tree_view_column_new_with_attributes (_("Title"), cellRenderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(gui->main_clist),treeViewColumn);
  gtk_tree_view_column_set_resizable (treeViewColumn, 1);
  gtk_tree_view_column_set_fixed_width (treeViewColumn, ini->columns_width[0]);
  gtk_tree_view_column_set_sizing (treeViewColumn, GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_sort_column_id (treeViewColumn, 0);

  treeViewColumn = gtk_tree_view_column_new_with_attributes (_("URL"),cellRenderer,"text",1,NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(gui->main_clist),treeViewColumn);
  gtk_tree_view_column_set_resizable (treeViewColumn, 2);
  gtk_tree_view_column_set_fixed_width (treeViewColumn, ini->columns_width[1]);
  gtk_tree_view_column_set_sizing (treeViewColumn, GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_sort_column_id (treeViewColumn, 1);

  treeViewColumn = gtk_tree_view_column_new_with_attributes (_("User"),cellRenderer,"text",2,NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(gui->main_clist),treeViewColumn);
  gtk_tree_view_column_set_resizable (treeViewColumn, 3);
  gtk_tree_view_column_set_sizing (treeViewColumn, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
  gtk_tree_view_column_set_sort_column_id (treeViewColumn, 2);

}


void
fpm_clist_create_view(gchar *category)
/* Create visible CList from abstract GList */
{
  gint row;
  fpm_data *data;
  GList *list;

  GtkTreeIter iter;
  GtkTreeModel *list_store;
//  GCompareFunc cmp_list;

  glb_num_row=0;

  /* Sort the list */
  //glb_cmp = (GCompareFunc) fpm_cmp_title;
  glb_pass_list = g_list_sort(glb_pass_list, (GCompareFunc) fpm_cmp_title);

  list_store = gtk_tree_view_get_model (gui->main_clist);
  gtk_list_store_clear(GTK_LIST_STORE(list_store));

  /* Iterate over the list */
  list=g_list_first(glb_pass_list);
  while (list!=NULL)
  {

    /* Get data for this element */
    data = list->data;

    if(category == NULL ||
       !strcmp(category, FPM_ALL_CAT_MSG) ||
       !strcmp(category, data->category) ||
       (!strcmp(category, FPM_NONE_CAT_MSG) && !strlen(data->category)) ||
       (!strcmp(category, FPM_DEFAULT_CAT_MSG) && data->default_list) )
    {

    gtk_list_store_append (GTK_LIST_STORE(list_store), &iter);

    gtk_list_store_set(GTK_LIST_STORE(list_store), &iter,
	    FPM_COL_TITLE, data->title,
	    FPM_COL_URL, data->arg,
	    FPM_COL_USER, data->user,
	    FPM_COL_DATA_POINTER, data,
	    -1);

      glb_num_row++;
      row = glb_num_row - 1;

    }

    list=g_list_next(list);
  }
}

