#!/usr/bin/env python

# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA

# Stubs generated by 'fnidl'.
import testinterop

def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Read the server's stringified IOR from a file.
    stringified_ior = open('Server.ref', 'r').read()

    # Convert the stringified IOR into an active object reference.
    server = orb.string_to_object(stringified_ior)

    # Make sure that the server is not a 'nil object reference' (represented
    # in Python by the value 'None').
    if server is None:
	raise 'Nil object reference!'

    print "about to call"

    # Call the server!

    fixed = testinterop.FixedType('3.50')
    
    returned = server.testFixed(fixed)
    print returned

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
