#!/usr/bin/env python

import unittest
import datatransfer, datatransfer_skel

from orbrunner import ORBRunner

#
# The test case for "wchar" type transmission.
#
class WCharTest(unittest.TestCase):

    def __init__(self, orb_runner):
        unittest.TestCase.__init__(self)
        self.orb_runner = orb_runner;

    #
    # Create the implementation of the "wchar" type test interface and
    # register it with the ORB.
    #
    def setUp(self):
        orb = self.orb_runner.getORB()
        stringified_ior = open('wchar.ref', 'r').read()
        self.obj = orb.string_to_object(stringified_ior)

    def tearDown(self):
        # Do nothing for the time being
        pass

    #
    # Perform the "wchar" type interface tests.
    #
    def runTest(self):
        wchar = 'f'

        self.assertEqual(self.obj.wCharIn(wchar), wchar)
        
        self.assertEqual(self.obj.wCharOut(wchar), wchar)

        wchar_in = 'n'
        (wchar_ret, wchar_out) = self.obj.wCharInOut(wchar, wchar_in)

        self.assertEqual(wchar_ret, wchar_in)
        self.assertEqual(wchar_out, wchar)

#
# Create a testsuite for testing "wchar" type transmission. This is
# meant to be used by other modules wanting to incorporate these
# tests.
#
def build_test_suite(orb_runner):
    wchar_test = WCharTest(orb_runner)
    test_suite = unittest.TestSuite([wchar_test])
    return test_suite

#
# Run the tests with an ORB. This is meant to be used when this module
# is executed as a stand-alone program.
#
def run_tests():
    orb_runner = ORBRunner()

    test_suite = build_test_suite(orb_runner)

    test_runner = unittest.TextTestRunner()
    test_runner.run(test_suite)

#
# If this module was loaded as a program, then run the tests.
#
if __name__ == "__main__":
    run_tests()
