#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999, 2000
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/orb/Limits.py,v $
# Version:      @(#)$RCSfile: Limits.py,v $ $Revision: 1.2 $
#
#############################################################################
""" Limits for CORBA types. """


# octet - 8 bits
MIN_OCTET     = -pow(2L, 8)
MAX_OCTET     = +pow(2L, 8) - 1

# short/unsigned short - 16 bits
MIN_SHORT     = -pow(2L, 15)
MAX_SHORT     = +pow(2L, 15) - 1
MIN_USHORT    = 0
MAX_USHORT    = +pow(2L, 16) - 1

# long/unsigned long - 32 bits
MIN_LONG      = -pow(2L, 31)
MAX_LONG      = +pow(2L, 31) - 1
MIN_ULONG     = 0
MAX_ULONG     = +pow(2L, 32) - 1

# long long/unsigned long long - 64 bits
MIN_LONGLONG  = -pow(2L, 63)
MAX_LONGLONG  = +pow(2L, 63) - 1
MIN_ULONGLONG = 0
MAX_ULONGLONG = +pow(2L, 64) - 1


#############################################################################
