// Copyright 2007 "Gilles Degottex"

// This file is part of "fmit"

// "Music" is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// "Music" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

using namespace std;
#include <qsettings.h>
#include "AutoQSettings.h"

AutoQSettings::AutoQSettings(const QString& domain, const QString& product, const QString& setting_version)
{
	setPath(domain, product);
	beginGroup(QString("/")+product+setting_version+"/");
}

void AutoQSettings::save(QCheckBox* el)
{
	writeEntry(el->name(), el->isChecked());
}
void AutoQSettings::load(QCheckBox* el)
{
	el->setChecked(readBoolEntry(el->name(), el->isChecked()));
}

void AutoQSettings::save()
{
	beginGroup("Auto/");

	for(list<QCheckBox*>::iterator it=m_elements_checkbox.begin(); it!=m_elements_checkbox.end(); it++)
		writeEntry((*it)->name(), (*it)->isChecked());

	for(list<QSpinBox*>::iterator it=m_elements_spinbox.begin(); it!=m_elements_spinbox.end(); it++)
		writeEntry((*it)->name(), (*it)->value());

	for(list<QLineEdit*>::iterator it=m_elements_lineedit.begin(); it!=m_elements_lineedit.end(); it++)
		writeEntry((*it)->name(), (*it)->text());

	for(list<QComboBox*>::iterator it=m_elements_combobox.begin(); it!=m_elements_combobox.end(); it++)
		writeEntry((*it)->name(), (*it)->currentItem());

	for(list<QGroupBox*>::iterator it=m_elements_qgroupbox.begin(); it!=m_elements_qgroupbox.end(); it++)
		writeEntry((*it)->name(), (*it)->isChecked());

	for(list<QRadioButton*>::iterator it=m_elements_qradiobutton.begin(); it!=m_elements_qradiobutton.end(); it++)
		writeEntry((*it)->name(), (*it)->isChecked());

	endGroup();
}
void AutoQSettings::load()
{
	beginGroup("Auto/");

	for(list<QCheckBox*>::iterator it=m_elements_checkbox.begin(); it!=m_elements_checkbox.end(); it++)
		(*it)->setChecked(readBoolEntry((*it)->name(), (*it)->isChecked()));

	for(list<QSpinBox*>::iterator it=m_elements_spinbox.begin(); it!=m_elements_spinbox.end(); it++)
		(*it)->setValue(readNumEntry((*it)->name(), (*it)->value()));

	for(list<QLineEdit*>::iterator it=m_elements_lineedit.begin(); it!=m_elements_lineedit.end(); it++)
		(*it)->setText(readEntry((*it)->name(), ((*it)->text())));

	for(list<QComboBox*>::iterator it=m_elements_combobox.begin(); it!=m_elements_combobox.end(); it++)
		(*it)->setCurrentItem(readNumEntry((*it)->name(), (*it)->currentItem()));

	for(list<QGroupBox*>::iterator it=m_elements_qgroupbox.begin(); it!=m_elements_qgroupbox.end(); it++)
		(*it)->setChecked(readBoolEntry((*it)->name(), (*it)->isChecked()));

	for(list<QRadioButton*>::iterator it=m_elements_qradiobutton.begin(); it!=m_elements_qradiobutton.end(); it++)
		(*it)->setChecked(readBoolEntry((*it)->name(), (*it)->isChecked()));

	endGroup();
}
void AutoQSettings::clear()
{
	beginGroup("Auto/");

	for(list<QCheckBox*>::iterator it=m_elements_checkbox.begin(); it!=m_elements_checkbox.end(); it++)
		removeEntry((*it)->name());

	for(list<QSpinBox*>::iterator it=m_elements_spinbox.begin(); it!=m_elements_spinbox.end(); it++)
		removeEntry((*it)->name());

	for(list<QLineEdit*>::iterator it=m_elements_lineedit.begin(); it!=m_elements_lineedit.end(); it++)
		removeEntry((*it)->name());

	for(list<QComboBox*>::iterator it=m_elements_combobox.begin(); it!=m_elements_combobox.end(); it++)
		removeEntry((*it)->name());

	endGroup();
}
