/* $Header: /home/yav/catty/fkiss/RCS/kisscnf.c,v 1.25 2000/09/28 07:52:48 yav Exp $
 * KISS configration file (*.cnf) parse
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

char id_kisscnf[] = "$Id: kisscnf.c,v 1.25 2000/09/28 07:52:48 yav Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include "config.h"

#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_KISSCNF_C
#include "extern.h"

#define OBJINCSTEP 64
#define CELINCSTEP 64

#define MAXCNFCOMMENT 25

static int celcnt_alloced;
static int objcnt_alloced;

static int linecnt = 0;
static char **lineptr = NULL;
static int transparency_hint = 0;
static char *cel_comment = NULL;

void init_object_cell()
{
  int i, n;
  
  objcnt = celcnt = 0;
  n = OBJINCSTEP * sizeof(OBJECT);
  object = (OBJECT *)ks_malloc(n);
  bzero((char *)object, n);
  n = sizeof(OBJPOS)*OBJINCSTEP;
  for (i = 0; i < MAXSET; i++) {
    kset[i].obj = (OBJPOS *)ks_malloc(n);
    bzero((char *)kset[i].obj, n);
  }
  objcnt_alloced = OBJINCSTEP;
  n = CELINCSTEP * sizeof(CELL);
  cell = (CELL *)ks_malloc(n);
  bzero((char *)cell, n);
  celcnt_alloced = CELINCSTEP;
}

int change_celmax(n)
     int n;
{
  int i;
  
  if (n < 0 || n >= MAXCEL) {
    msg("W cell count %d range over (max %d).\n", n, MAXCEL);
    return 1;
  }
  if (n >= celcnt_alloced) {
    for (i = celcnt_alloced; i < n; i += CELINCSTEP)
      ;
    cell = (CELL *)ks_realloc(cell, sizeof(*cell)*i);
    bzero((char *)(cell+celcnt_alloced), sizeof(*cell)*(i-celcnt_alloced));
    celcnt_alloced = i;
  }
  return 0;
}

int change_objmax(n)
     int n;
{
  int i, j;
  
  if (n < 0 || n >= MAXOBJ) {
    msg("W object mark %d range over (max %d).\n", n, MAXOBJ);
    return 1;
  }
  if (n >= objcnt_alloced) {
    for (i = objcnt_alloced; i < n; i += OBJINCSTEP)
      ;
    object = (OBJECT *)ks_realloc(object, sizeof(OBJECT)*i);
    bzero((char *)(object+objcnt_alloced), sizeof(OBJECT)*(i-objcnt_alloced));
    for (j = 0; j < MAXSET; j++) {
      kset[j].obj = (OBJPOS *)ks_realloc(kset[j].obj, sizeof(OBJPOS)*i);
      bzero((char *)(kset[j].obj+objcnt_alloced), sizeof(OBJPOS)*(i-objcnt_alloced));
    }
    objcnt_alloced = i;
  }
  return 0;
}

void skip_space(p)
     char **p;
{
  while (**p == ' ' || **p == '\t')
    ++*p;
}

void skip_notspace(p)
     char **p;
{
  while (**p && **p != ' ' && **p != '\t')
    ++*p;
}

int cnf_cell(str, lcnt)
     char *str;
     int lcnt;			/* cnf line number */
{
  int i;
  int mark;
  char *p;
  CELL *cp;
  CELL work_cell;
  LSTR namebuf;
  
  cp = &work_cell;
  bzero((char *)cp, sizeof(CELL));
  cp->line = lcnt;
  cp->transparency = transparency_hint;
  cp->comment = cel_comment;
  cel_comment = NULL;
  /* parse mark */
  mark = strtol(str, &str, 10);
  cp->obj = mark;
  /* check fix value */
  if (*str == '.') {
    str++;
    i = strtol(str, &str, 10);
    if (i > max_fix)
      max_fix = i;
    cp->fix = i;
  }
  skip_space(&str);
  lstr_init(&namebuf);
  while (*str != '\0' && *str != '\t' && *str != ' ')
    lstr_ch(&namebuf, *str++);
  cp->filename = namebuf.buf;
  skip_space(&str);
  /* color */
  cp->colfile = 0;		/* default color 0 */
  if (*str == '*') {
    str++;			/* skip '*' */
    i = strtol(str, &str, 10);
    if (i >= colorfilecnt) {
      msgset("W color file #%d nothing! use #0.\n", i);
      i = 0;
    }
    cp->colfile = i;
    skip_space(&str);
  }
  /* set */
  for (i = 0; i < MAXSET; i++)
    cp->setflag[i] = 1;		/* default all set active */
  if (*str == ':') {
    str++;			/* skip ':' */
    for (i = 0; i < MAXSET; i++)
      cp->setflag[i] = 0;
    while((i = strtol(p = str, &str, 10)), str != p)
      cp->setflag[i] = 1;
  }
  for (i = 0; i < MAXSET; i++) {
    if (active_set[i] && cp->setflag[i]) {
      /* work_cell -> cell */
      if (objcnt <= mark) {
	if (change_objmax(mark+1))
	  return 1;
	objcnt = mark+1;
      }
      if (change_celmax(celcnt+1))
	return 1;
#if 0	/* yav told me that mio.h told him that fix values add up */
      /* when the cels which build an object have DIFFERENT fixing values,
      ** we take the highest of all values. 
      */ 
      if ( (object+mark)->fix < cp->fix )
	(object+mark)->fix = cp->fix;
#else
      if ( (object+mark)->fix + cp->fix >= MAXSHORT )
        msg("W cell fix value %d + old fix value %d >= %d, ignored.\n",
	    (object+mark)->fix, cp->fix, MAXSHORT);
      else
        (object+mark)->fix += cp->fix;	/* add up all fixing values */
#endif
      bcopy((char *)&work_cell, (char *)(cell+celcnt), sizeof(CELL));
      celcnt++;
      break;
    }
  }
  return 0;
}

int cnf_set(str)
     char *str;
{
  int i, j;
  int x, y;
  SETINFO *p;
  Bool finish;
  
  if (setcnt >= MAXSET)
    return 1;
  p = &kset[setcnt++];
  p->pal = strtol(str, &str, 10);
  finish = False;
  for (i = 0; i < objcnt; i++) {
    (p->obj+i)->x = (p->obj+i)->y = x = y = 0;
    if (objpos_first_align) {
      for (j = 0; j < setcnt-1; j++) {
	x = (kset[j].obj+i)->x;
	y = (kset[j].obj+i)->y;
	if (x||y)
	  break;
      }
    }
    if (!finish) {
      skip_space(&str);
      if (!*str)
	finish = True;
    }
    if (!finish) {
      if (*str == '*') {
	str++;
      } else {
	x = strtol(str, &str, 10);
	skip_space(&str);
	if (*str == ',')
	  str++;
	y = strtol(str, &str, 10);
      }
    }
    (p->obj+i)->x = x;
    (p->obj+i)->y = y;
  }
  return 0;
}

int cnf_color(str)
     char *str;
{
  COLOR *cp;
  LSTR buf;
  
  lstr_init(&buf);
  if (!colorfilecnt)
    kcflist = (COLOR *)ks_malloc(sizeof(COLOR));
  else
    kcflist = (COLOR *)ks_realloc(kcflist, sizeof(COLOR)*(colorfilecnt+1));
  cp = kcflist + colorfilecnt;
  while (*str != '\0' && *str != ' ' && *str != '\t')
    lstr_ch(&buf, *str++);
  cp->filename = buf.buf;
  colorfilecnt++;
  return 0;
}

int cnf_size(str)
     char *str;
{
  int w, h;
  
  w = strtol(str, &str, 10);
  skip_space(&str);
  if (*str && !is_digit(*str))
    str++;
  h = strtol(str, &str, 10);
  debug_printf("set screen size %3dx%3d.\n", w, h);
  if (w > 0)
    imgw0 = w;
  if (h > 0)
    imgh0 = h;
  if (w <= 0 || h <= 0)
    msgset("W bad screen size %dx%d.\n", w, h);
  return 0;
}

int cnf_border(str)
     char *str;
{
  int i;
  char *p;
  
  i = strtol(str, &p, 10);
  if (str != p) {
    debug_printf("set border %d.\n", i);
    border_color = i;
  }
  return 0;
}

char *cut_comment(p)
     char *p;
{
  p = index(p, ';');
  if (p != NULL) {
    *p++ = '\0';
  }
  return p;
}

void anal_comment(p)
     char *p;
{
  int i;
  char *p2;
  
  transparency_hint = 0;	/* reset transparency */
  if (cel_comment != NULL) {
    free(cel_comment);
    cel_comment = NULL;
  }
  if (p == NULL)
    return;
  while (skip_space(&p), *p) {
    switch(*p++) {
    case '@':
      skip_notspace(&p);
      break;
    case '%':
      skip_space(&p);
      switch(*p++) {
      case '\0':
	--p;
	break;
      case 't':
      case 'T':
	i = strtol(p, &p, 10);
	if (i >= 0 && i <= 256) {
	  transparency_hint = i;
	  debug_printf("set transparency hint %d\n", i);
	}
	break;
      default:
	skip_notspace(&p);
	break;
      }
      break;
    default:
      p--;			/* enable top letter */
      skip_space(&p);
      if (*p) {
	/* ToDo: must convert Shift-JIS!! */
	p2 = parse_string(&p, NULL);
	if (cel_comment == NULL) {
	  cel_comment = p2;	/* First comment is stored */
	} else {
	  free(p2);		/* Other comments are ignored */
	}
      }
      break;
    }
  }
}

void report_cnf_error(name, lptr, lcnt)
     char *name;		/* filename */
     char **lptr;		/* original config lines */
     int lcnt;			/* line number */
{
  msg("%s:%d:\n%s", name, lcnt, *(lptr+lcnt-1));
}

int parse_config(str, name, lptr, lcnt)
     char *str;
     char *name;		/* filename */
     char **lptr;		/* original config lines */
     int lcnt;			/* line number */
{
  char *p;
  
  p = str;
  if (*p)
    p++;
  skip_space(&p);
  switch(*str) {
  case '\0':			/* Comment or blank line */
    break;
  case '=':			/* Memory size */
    /* memory size hint for KISS version 1.0 */
    break;
  case '(':			/* Screen size */
    cnf_size(p);
    break;
  case '%':			/* Palette file */
    cnf_color(p);
    break;
  case '[':			/* Border color */
    cnf_border(p);
    break;
  case '#':			/* Cel file */
    cnf_cell(p, lcnt);
    break;
  case '$':			/* Set information */
    cnf_set(p);
    break;
  case '@':
    cnf_event(p, lcnt);
    break;
  default:			/* unknown function */
    msgset("W unknown function.\n");
    break;
  }
  if (msg_queued()) {
    report_cnf_error(name, lptr, lcnt);
    return 1;
  }
  return 0;
}

void fill_sets(n0, n)
     int n0;			/* set info. specified set count */
     int n;			/* need to display set count */
{
  int s, s0;
  
  s0 = n0 ? (n0-1) : 0;
  for (s = n0; s < n; s++)
    bcopy(kset+s0, kset+s, sizeof(*kset));
}

/* update
 *  setcnt, cset, active_set[], kset[]
 */
void adjust_effective_setcnt()
{
  int i, j, n;
  char buf[MAXSET];
  
  bzero(buf, sizeof(buf));
  for (i = 0; i < MAXSET; i++) {
    if (active_set[i]) {
      for (j = 0; j < celcnt; j++) {
	if ((cell+j)->setflag[i])
	  buf[i] = 1;
      }
    }
  }
  n = 0;
  for (i = 0; i < MAXSET; i++) {
    if (buf[i])
      n = i;
    else
      active_set[i] = 0;
  }
  n++;
  fill_sets(setcnt, n);
  for (i = 0; i < n; i++) {
    if (active_set[i]) {
      cset = i;
      break;
    }
  }
  setcnt = n;
}

void init_org_position()
{
  int i, j;
  OBJPOS *p;
  
  for (i = 0; i < setcnt; i++) {
    if (active_set[i]) {
      for (p = kset[i].obj, j = 0; j < objcnt; p++, j++) {
	p->ox = p->x;
	p->oy = p->y;
      }
    }
  }
}

int read_config(name)
     char *name;
{
  char *p;
  int i, r, linecount, lastlcnt;
  FILE *fp;
  Bool eof_detect, pre_comment;
  int evidn;			/* evid compare length */
  char *commentstr;
  char buf[1024];
  char setstr[256+(1+5+1+5)*MAXOBJ];
  
  debug_printf("read_config [%s]\n", name);
  fp = fopen(name, "r");
  if (fp == NULL) {
    msg("E ``%s'' open error!\n", name);
    return 1;
  }
  /* preload */
  lineptr = (char **)ks_malloc(sizeof(char *));
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    lineptr = (char **)ks_realloc(lineptr, sizeof(char *) * (linecnt + 1));
    *(lineptr+linecnt) = ks_strdup(buf);
    linecnt++;
    if (coding_type == CODING_UNKNOWN)
      coding_type = check_coding(buf);
  }
  fclose(fp);
  debug_printf("cnf file coding: %s\n", coding_name(coding_type));
  evidn = strlen(evid);
  kcflist = NULL;
  cnf_comment = (char **)ks_malloc(sizeof(char *) * MAXCNFCOMMENT);
  evn = cnf_comment_cnt = setcnt = celcnt = colorfilecnt = linecount = 0;
  setstr[0] = '\0';
  event_detect = eof_detect = False;
  pre_comment = True;
  while (!eof_detect) {
    convert_coding(buf, *(lineptr+linecount));
    p = buf;
    if ((p = index(buf, 032)) != NULL) { /* check ^Z (CP/M EOF) */
      *p = '\0';
      eof_detect = True;
    }
    if (++linecount >= linecnt)
      eof_detect = True;
    cut_crlf(buf);
    if (!buf[0])
      continue;
    if (buf[0] != ';')
      pre_comment = False;
    if (pre_comment) {
      if (cnf_comment_cnt < MAXCNFCOMMENT)
	cnf_comment[cnf_comment_cnt++] = ks_strdup(buf);
      msg("V%s\n", buf);
    }
    p = buf;
    /* check event extension */
    if (event_mode && !event_detect && (strncmp(buf, evid, evidn) == 0))
      event_detect = True;
    else if (event_detect && (strncmp(p, ";@", 2) == 0))
      p++;
    commentstr = cut_comment(p);
    if (*p != ' ') {
      if (setstr[0])
	parse_config(setstr, name, lineptr, lastlcnt);
      lastlcnt = linecount;
      setstr[0] = '\0';
    }
    strcat(setstr, p);
    anal_comment(commentstr);
  }
  if (setstr[0])
    parse_config(setstr, name, lineptr, lastlcnt);
  adjust_effective_setcnt();
  init_org_position();
  if (event_detect) {
    for (i = 0; i < evn; i++) {
      r = compile_event(i);
      /* This was more misleading than useful, because it reports
      ** the error at the last line of the event block, and that
      ** is much too late (except the error is in that last line).
      ** instead, the error is now reported from compile_event().
      */
    }
    init_hitck();
    debug_printf("event compiled.\n");
    kissevent_initialize();
  }
  /* free config lines */
  for (linecount = 0; linecount < linecnt; linecount++)
    free(*(lineptr+linecount));
  free(lineptr);
  return 0;
}

int write_set(fp, set)
     FILE *fp;
     int set;
{
  int i, len, saveobjcnt;
  char *p, *lastpos;
  char buf[1024];
  char tmpbuf[32];
  
  if (set >= MAXSET)
    return 0;
  if (set >= setcnt) {
    fputs("$0 *\n", fp);
    return 0;
  }
  /* check object position is (0,0) */
  i = objcnt;
  while (--i) {
    if ((kset[set].obj+i)->x || (kset[set].obj+i)->y)
      break;
  }
  saveobjcnt = i + 1;
  len = (oldcnf_comaptible && objcnt <= KISSGS1_MAXCEL) ? 255 : 78;
  sprintf(buf, "$%d", kset[set].pal);
  p = buf + strlen(buf);
  for (i = 0; i < saveobjcnt; i++) {
    lastpos = p;
    *p++ = ' ';
    if (!(kset[set].obj+i)->x && !(kset[set].obj+i)->y) {
      *p++ = '*';
    } else {
      sprintf(p, "%d,%d", (kset[set].obj+i)->x, (kset[set].obj+i)->y);
      p += strlen(p);
    }
    if (p >= buf+len) {
      *p = '\0';
      strcpy(tmpbuf, lastpos);	/* keep after lastpos */
      strcpy(lastpos, "\n");	/* cut after lastpos */
      fputs(buf, fp);
      strcpy(buf, tmpbuf);
      p = buf + strlen(buf);
    }
  }
  /* flush holding string */
  if (p != buf) {
    strcpy(p, "\n");
    fputs(buf, fp);
  }
  return 0;
}

/* write_config - write KISS configuration file
 * copy src file to dst file except set information.
 * current set information is written.
 */
int write_config(src, dst)
     FILE *src;			/* source cnf file */
     FILE *dst;			/* destination cnf file */
{
  int i;
  int set, lastcmd;
  Bool eof_detect;
  char *p;
  char buf[1024];
  char buf2[1024];
  
  lastcmd = set = 0;
  eof_detect = False;
  buf2[0] = '\0';
  while (!eof_detect) {
    if (fgets(buf, sizeof(buf), src) == NULL)
      break;
    p = index(buf, 032);	/* check ^Z (CP/M EOF) */
    if (p != NULL) {
      strcpy(buf2, p);		/* keep after ^Z (CP/M EOF) data */
      *p = '\0';
      eof_detect = True;
    }
    if (buf[0] == '$')
      write_set(dst, set++);	/* replace new set information */
    if (buf[0] != ' ')
      lastcmd = buf[0];
    if (lastcmd != '$')
      fputs(buf, dst);
  }
  while (set < setcnt)
    write_set(dst, set++);
  if (buf2[0] != '\0')
    fputs(buf2, dst);
  /* keep trailing garbage */
  while ((i = fread(buf, 1, sizeof(buf), src)) != 0)
    fwrite(buf, 1, i, dst);
  return ferror(src)|ferror(dst);
}

/* update set information in KISS configuration file */
int save_config(name)
     char *name;
{
  int i;
  FILE *fp;
  FILE *wfp;
  char *newfile;
  char *bakfile;
  
  debug_printf("write_config [%s]\n", name);
  fp = fopen(name, "r");
  if (fp == NULL) {
    msg("W ``%s'' open error!\n", name);
    return 1;
  }
  i = strlen(name) + 1 + 1;
  bakfile = ks_malloc(i);
  newfile = ks_malloc(i);
  sprintf(bakfile, "%s~", name);
  sprintf(newfile, "%s#", name);
  wfp = fopen(newfile, "w");
  if (wfp == NULL) {
    msg("W ``%s'' open error!\n", newfile);
    free(bakfile);
    free(newfile);
    return 1;
  }
  i = write_config(fp, wfp);
  fclose(wfp);
  fclose(fp);
  if (i) {
    msg("W ``%s'' write error!\n", newfile);
    free(bakfile);
    free(newfile);
    return 1;
  }
  if (rename(name, bakfile)) {
    msg("W rename ``%s'' -> ``%s'' failed!\n", name, bakfile);
    free(bakfile);
    free(newfile);
    return 1;
  }
  if (rename(newfile, name)) {
    msg("W rename ``%s'' -> ``%s'' failed!\n", newfile, name);
    free(bakfile);
    free(newfile);
    return 1;
  }
  infostr0[0] = '\0';
  sprintf(infostr, "Wrote ``%s''", name);
  disp_info();
  free(bakfile);
  free(newfile);
  return 0;
}

/* End of file */
