/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include <alsa/asoundlib.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <math.h>
#include <getopt.h>

#define PI 3.14159

#define CONTINUE 0
#define EXIT 1
#define PAUSE 2
#define TOGGLE_BLUR 4
#define TOGGLE_WAVEFREEZE 8
#define TOGGLE_VECTORFREEZE 16
#define TOGGLE_COLORFREEZE 32
#define TOGGLE_BEATMARK 64

#define NONE 0
#define PHASE 1
#define BEAT 2
#define LINE 4

#define WAVE_HORIZONTAL_STEREO_THIRDS 0
#define WAVE_CIRCLE_STEREO_TWIST 1
#define WAVE_ELLIPSE_STEREO_TWIST 2
#define WAVE_CIRCLE_STEREO_STEADY 3
#define WAVE_ELLIPSE_STEREO_STEADY 4

#define VECTORS_VERTICAL_CENTERSPLIT 0
#define VECTORS_HORIZONTAL_CENTERSPLIT 1
#define VECTORS_RADIAL_LINEAR 2
#define VECTORS_SCREW_RIGHT_LINEAR 3
#define VECTORS_SCREW_LEFT_LINEAR 4
#define VECTORS_SPIRAL_RIGHT_LINEAR 5
#define VECTORS_SPIRAL_LEFT_LINEAR 6

#define BEATMARK_0 0
#define BEATMARK_X 1
#define BEATMARK_A 2
#define BEATMARK_O 3
#define BEATMARK_Q 4
#define BEATMARK_D 5

void sample_alsa_pcm ( char *device, int fd, int buf_size, unsigned int rate );
int init_SDL ( short int X, short int Y, short int fullscreen );
void line ( int x1, int y1, int x2, int y2, long int color );
void blur ( int vectortype );
int check_events ( );
void wave ( char type, char *data );
void create_vectors ( );
double intensity ( char *data, int size );
int analyse ( char *data, int size );
void beatmark ( int type );
int change ( int *original, int max );
void usage ( );
char toggle ( char *original );
int parse_options ( int count, char** args );

struct {
	char vectors;
	char waveform;
	char color;
} freeze;

struct {
	int wave;
	int vectors;
	int beatmark;
} current;

struct {
	double history[200];
	double av_1;
	double av_2;
	double av_3;
} analysis_data;

pid_t ALSAChildPID;

SDL_Surface *sdl_screen;

unsigned char *blur_dest;

snd_pcm_t *capture_handle;

int XRes, YRes, samplelength, surfacepitch;
int color1;

signed char *vectors;
int vector_fieldsize;
