<?
	/**
	 * Create the images for the Firefox bookmarks dialog in the specified
	 * directory.
	 */
	function createBookmarks($dir) {
		renderBookmarks($dir.'Bookmarks-toolbar.png', 24);
	}
	
	/**
	 * Render the complete image to a given file.
	 *
	 * The columns are:
	 * New Bookmark, New Folder, New Separator, Move, Properties, Rename,
	 * Delete
	 *
	 * The rows are:
	 * Normal, Hover, Pressed, Disabled
	 */
	function renderBookmarks($filename, $size) {
		// define the icons to render
		$icons = array(
			array(ACTIONS, 'bookmark-new'),
			array(ACTIONS, 'folder-new'),
			array(ACTIONS, 'document-new'),			// TODO
			getBookmarkMoveIcon(),
			array(ACTIONS, 'document-properties'),
			array(ACTIONS, 'format-justify-left'),	// TODO
			array(ACTIONS, 'edit-delete'),
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		$pressed = renderDarkened($firstrow);
		$disabled = renderDisabled($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight, $pressed, $disabled);
		$bookmarks =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($bookmarks, $filename);
	}
	
	/**
	 * Get the icon for the bookmark move action.
	 */
	function getBookmarkMoveIcon() {
		// return custom icon (TODO)
		return array(ACTIONS, 'bookmark-move');
	}
	
?>
