#!/bin/bash -e

for THEME in {human,tangerine,gnome}
do
	ID=`cat ../src/custom/$THEME/install.rdf | grep "em:id" | head -n1 | grep -o "{[^ ]*}"`
	THEMEDIR="src/usr/lib/firefox/extensions/$ID"
	THEMEJAR="../bin/$THEME.jar"
	CHROMEFILES="icon.png install.rdf preview.png"

	mkdir -p $THEMEDIR{,/chrome}
	
	sed "s/THEME/$THEME/g" chrome.manifest.template > $THEMEDIR/chrome.manifest

	jar xvf $THEMEJAR $CHROMEFILES
	mv $CHROMEFILES $THEMEDIR

	cp $THEMEJAR $THEMEDIR/chrome
done
