function showShowcaseAllWindows(event) {
  if ((!event) || (event.type != "command")) {
      showShowcase(true, false);
  } else if (event.shiftKey) {
    if (event.ctrlKey) {
      showShowcase(false, true);
    } else {
      showShowcase(false, false);
    }
  } else {
    if (event.ctrlKey) {
      showShowcase(true, true);
    } else {
      showShowcase(true, false);
    }
  }
}

function showShowcaseThisWindow(event) {
  if ((!event) || (event.type != "command")) {
      showShowcase(false, false);
  } else if (event.shiftKey) {
    if (event.ctrlKey) {
      showShowcase(true, true);
    } else {
      showShowcase(true, false);
    }
  } else {
    if (event.ctrlKey) {
      showShowcase(false, true);
    } else {
      showShowcase(false, false);
    }
  }
}

function showShowcaseTabAllWindows(event) {
  if ((!event) || (event.type != "command")) {
      showShowcase(true, true);
  } else if (event.shiftKey) {
    if (event.ctrlKey) {
      showShowcase(false, false);
    } else {
      showShowcase(false, true);
    }
  } else {
    if (event.ctrlKey) {
      showShowcase(true, false);
    } else {
      showShowcase(true, true);
    }
  }
}

function showShowcaseTabThisWindow(event) {
  if ((!event) || (event.type != "command")) {
      showShowcase(false, true);
  } else if (event.shiftKey) {
    if (event.ctrlKey) {
      showShowcase(true, false);
    } else {
      showShowcase(true, true);
    }
  } else {
    if (event.ctrlKey) {
      showShowcase(false, false);
    } else {
      showShowcase(false, true);
    }
  }
}

function showShowcase(allWindows, embedTab) {
      var prefs = Components.classes["@mozilla.org/preferences-service;1"].
                    getService(Components.interfaces.nsIPrefService);
      prefs = prefs.getBranch("extensions.showcase.");

      // First close the window so we can keep the "last position" and "last size" values
      if (!embedTab) {
        var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
        var windowIter = wm.getEnumerator('extension:showcase');
        if (windowIter.hasMoreElements()) {
          var targetWindow = windowIter.getNext();
          if (targetWindow.wrappedJSObject) targetWindow = targetWindow.wrappedJSObject;

          if (targetWindow) {
            var shouldRefresh = false;
            if (allWindows) {
              if (!targetWindow.globalMode) {
                targetWindow.globalMode = true;
                shouldRefresh = true;
              }
            } else {
              if (targetWindow.globalMode) {
                targetWindow.globalMode = false;
                targetWindow.localTargetWindow = window;
                shouldRefresh = true;
              } else {
                if ((targetWindow.localTargetWindow && (targetWindow.localTargetWindow != window)) || 
                    (!targetWindow.localTargetWindow && (window.opener != window))) {
                  targetWindow.localTargetWindow = window;
                  shouldRefresh = true;
                }
              }
            }
            if (shouldRefresh)
              targetWindow.refreshScreen();

            targetWindow.focus();
            return;
          }
        }
      }

	// Check if we've to embed showcase in a tab
	if (embedTab) {
        // Look for any old instance
        var tabbrowser = document.getElementById("content");
        var tabs = tabbrowser.mTabContainer.childNodes;
        var totalTabs = tabs.length;
        var selectedTab = tabbrowser.getBrowserForTab(tabs[tabbrowser.mTabContainer.selectedIndex]);

        var found = false;
        for (var j = 0; (j < totalTabs) && !found; j++) {
          var targetTab = tabbrowser.getBrowserForTab(tabs[j]);
          if (targetTab.contentWindow) {
            var targetTabWindow = targetTab.contentWindow;
            if (targetTabWindow.wrappedJSObject) {
              targetTabWindow = targetTabWindow.wrappedJSObject;
            }
            if (targetTabWindow.isShowcaseWindow) {
              found = true;
              if (targetTab == selectedTab) {
                targetTabWindow.close();
              } else {
                if (targetTabWindow.globalMode != allWindows) {
                  targetTabWindow.location = "chrome://showcase/content/showcase.xul?global=" + allWindows;
                  //targetTabWindow.globalMode = allWindows;
                  //targetTabWindow.refreshScreen();
                }
                tabbrowser.mTabContainer.selectedIndex = j;
                targetTabWindow.focus();
              }
            }
          }
        }

        if (!found) {
          var showcaseTab = getBrowser().addTab("chrome://showcase/content/showcase.xul?global=" + allWindows);
          var initialPosition = prefs.getIntPref("tabInitialPosition");
          var tabbrowser = getBrowser();
          if (initialPosition == 0) {
            // Current position
            /*#if seamonkey*/
            tabbrowser.moveTabTo(tabbrowser.getTabIndex(showcaseTab), tabbrowser.getTabIndex(tabbrowser.selectedTab));
            /*#else*/
            tabbrowser.moveTabTo(showcaseTab, tabbrowser.selectedTab._tPos);
            /*#endif*/
          } else if (initialPosition == 2) {
            // First position
            /*#if seamonkey*/
            tabbrowser.moveTabTo(tabbrowser.getTabIndex(showcaseTab), 0);
            /*#else*/
            tabbrowser.moveTabTo(showcaseTab, 0);
            /*#endif*/
          }
          tabbrowser.selectedTab = showcaseTab;
        }
        return;
	}

      var windowHeight, windowWidth;
      var createWindowString = "chrome";
      
      var showcaseWidthType = prefs.getIntPref("windowWidth");
      var widthPercentage = parseFloat(prefs.getCharPref("windowWidthPercentage"));
      var widthModifier = prefs.getIntPref("windowWidthModifier");

      createWindowString += ",outerWidth=";

      if (showcaseWidthType == 0) {
        var contentArea = getBrowser().mCurrentBrowser;
        windowWidth = Math.floor(contentArea.boxObject.width * widthPercentage / 100 + widthModifier);
        createWindowString += windowWidth;
      } else if (showcaseWidthType == 1) {
        windowWidth = Math.floor(window.screen.availWidth * widthPercentage / 100 + widthModifier);
        createWindowString += windowWidth;
      } else if (showcaseWidthType == 2) {
        windowWidth = prefs.getIntPref("windowLastWidth");
        createWindowString += windowWidth;
        if (windowWidth < 1) {
          windowWidth = 300;
        }
      } else { // if (showcaseWidthType == 3) {
        windowWidth = Math.floor(window.outerWidth * widthPercentage / 100 + widthModifier);
        createWindowString += windowWidth;
      }

      var showcaseHeightType = prefs.getIntPref("windowHeight");
      var heightPercentage = parseFloat(prefs.getCharPref("windowHeightPercentage"));
      var heightModifier = prefs.getIntPref("windowHeightModifier");

      createWindowString += ",outerHeight=";

      if (showcaseHeightType == 0) {
        var contentArea = getBrowser().mCurrentBrowser;
        windowHeight = Math.floor(contentArea.boxObject.height * heightPercentage / 100 + heightModifier);
        createWindowString += windowHeight;
      } else if (showcaseHeightType == 1) {
        windowHeight = Math.floor(window.screen.availHeight * heightPercentage / 100 + heightModifier);
        createWindowString += windowHeight;
      } else if (showcaseHeightType == 2) {
        windowHeight = prefs.getIntPref("windowLastHeight");
        if (windowHeight < 1) {
          windowHeight = 300;
        }
        createWindowString += windowHeight;
      } else { // if (showcaseHeightType == 3) {
        windowHeight = Math.floor(window.outerHeight * heightPercentage / 100 + heightModifier);
        createWindowString += windowHeight;
      }

      if (prefs.getBoolPref("windowAttributeDialog")) {
        createWindowString += ",dialog=yes";
      } else {
        createWindowString += ",dialog=no";
      }

      if (prefs.getBoolPref("windowAttributeDependent")) {
        createWindowString += ",dependent=yes";
      }

      if (!prefs.getBoolPref("windowAttributeTitleBar")) {
        createWindowString += ",titlebar=no";
      }

      if (prefs.getBoolPref("windowAttributeModal")) {
        createWindowString += ",modal=yes";
      }

      if (prefs.getBoolPref("windowAttributeAlwaysRaised")) {
        createWindowString += ",alwaysRaised=yes";
      }

      var showcasePosition = prefs.getIntPref("windowPosition");
      if (showcasePosition == 0) {
        // Center on invoking content area
        var contentArea = getBrowser().mCurrentBrowser;
        createWindowString += ",left=" + 
         Math.floor(contentArea.boxObject.screenX + contentArea.boxObject.width / 2 - windowWidth / 2) +
         ",top=" +
         Math.floor(contentArea.boxObject.screenY + contentArea.boxObject.height / 2 - windowHeight / 2);
      } else if (showcasePosition == 1) {
        // Center on current screen
        createWindowString += ",centerscreen=yes";
      } else if (showcasePosition == 2) {
        // Remember last position
        createWindowString += ",left=" + 
         prefs.getIntPref("windowLastX") +
         ",top=" +
         prefs.getIntPref("windowLastY");
      } else if (showcasePosition == 3) {
        // Remember last position relative to invoking window
        createWindowString += ",left=" + 
         (window.screenX + prefs.getIntPref("windowLastRelativeX")) +
         ",top=" +
         (window.screenY + prefs.getIntPref("windowLastRelativeY"));
      } else { // if (showcasePosition == 4) {
        // Center on invoking window
        createWindowString += ",left=" + 
         Math.floor(window.screenX + window.outerWidth / 2 - windowWidth / 2) +
         ",top=" +
         Math.floor(window.screenY + window.outerHeight / 2 - windowHeight / 2);
      }
      // Add "normal" parameters
      createWindowString += ",close=yes,resizable=yes";
      
      var showcaseURL = "chrome://showcase/content/showcase.xul?global=" + allWindows;
      var showcaseWindow = window.openDialog(showcaseURL,
		"showcaseDialog", createWindowString, window);

      // Try to focus on new window (will fail if window is modal, but that's not an issue)
      try {
        showcaseWindow.focus();
      } catch (e) {}
}

/*#if !lite*/
function showShowcaseOptions() {
  /*#if seamonkey*/
  var NSIFILE = Components.interfaces.nsIFile;
  var dirLocator = Components.classes["@mozilla.org/file/directory_service;1"]
                             .getService(Components.interfaces.nsIProperties);
  var userChromePath = dirLocator.get("UChrm", NSIFILE).path;
  var file = Components.classes["@mozilla.org/file/local;1"]
                       .createInstance(Components.interfaces.nsILocalFile);
  file.initWithPath(userChromePath);
  file.append("xsidebar.jar");
  if(!file.exists()) {
    var seamonkeyShowcaseBundle = document.getElementById("bundle_seamonkeyshowcase");

    var visitXsidebar=confirm(seamonkeyShowcaseBundle.getString("requiresXSidebar"));
    if (visitXsidebar)
      open("http://xsidebar.mozdev.org", "_blank");
    return;
  }
  /*#endif*/
  var features;
  try {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);
    var instantApply = prefs.getBoolPref("browser.preferences.instantApply");
    features = "chrome,titlebar,toolbar,centerscreen," + (instantApply ? "dialog=no" : "modal,resizable");
  } catch (e) {
    features = "chrome,titlebar,toolbar,centerscreen,modal,resizable";
  }
  openDialog("chrome://showcase/content/settings/settings.xul", "", features);
}
/*#endif*/