/*
 * Decompiled with CFR 0.152.
 */
package fix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;

public class ZipFactory {
    private List<File> files = new ArrayList<File>();
    private ZipOutputStream zipOutput;
    private CRC32 crc = new CRC32();
    private long sum = 0L;
    private long done = 0L;
    private JProgressBar progressBar = null;

    public ZipFactory(JProgressBar jProgressBar) {
        this.crc.reset();
        this.progressBar = jProgressBar;
    }

    public void create(OutputStream outputStream) throws IOException {
        this.zipOutput = new ZipOutputStream(outputStream);
        this.zipOutput.setLevel(0);
        for (File file : this.files) {
            String string = file.getName();
            this.add(file, string);
        }
        this.zipOutput.close();
    }

    public void add(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.files.add(file);
    }

    public void remove(File file) {
        this.files.remove(file);
    }

    private void add(File file, String string) throws IOException {
        File[] fileArray;
        if (file.isFile()) {
            fileArray = new ZipEntry(string);
            fileArray.setTime(file.lastModified());
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            this.zipOutput.putNextEntry((ZipEntry)fileArray);
            while ((n = fileInputStream.read(byArray)) > 0) {
                this.zipOutput.write(byArray, 0, n);
                this.done += (long)n;
                this.progressBar.setValue((int)(this.done * (long)this.progressBar.getMaximum() / this.sum));
                RepaintManager.currentManager(this.progressBar).paintDirtyRegions();
            }
            fileInputStream.close();
            this.zipOutput.closeEntry();
        }
        if (file.isDirectory()) {
            fileArray = file.listFiles();
            for (File file2 : fileArray) {
                this.add(file2, string + "/" + file2.getName());
            }
        }
    }

    public long updateSum(File[] fileArray) {
        for (File file : fileArray) {
            if (file.isDirectory()) {
                this.updateSum(file.listFiles());
            }
            if (!file.isFile()) continue;
            this.sum += file.length();
        }
        return this.sum;
    }
}

