/*
 * $Id: loudspeaker.c,v 1.13 2009-06-03 11:34:08 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "loudspeaker.h"

struct cpssp {
	struct sig_sound *port_audio_sound;
};

static void
loudspeaker_sound_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_sound_samples_set(cpssp->port_audio_sound, cpssp, samples);
}

void *
loudspeaker_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_sound *port_sound_in,
	struct sig_sound *port_audio_sound
)
{
	static const struct sig_sound_funcs sound_funcs = {
		.samples_set = loudspeaker_sound_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_audio_sound = port_audio_sound;

	/* In */
	sig_sound_connect(port_sound_in, cpssp, &sound_funcs);

	return cpssp;
}

void
loudspeaker_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
