/* $Id: UndefinedSymbol.cpp 5085 2010-12-17 16:38:59Z potyra $ 
 * UndefinedSymbol: error meaning that a symbol could not get looked up.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#include "frontend/reporting/UndefinedSymbol.hpp"
#include "frontend/ast/SimpleName.hpp"

namespace ast {

/* FIXME new SimpleName */
UndefinedSymbol::UndefinedSymbol(
	const std::string &name,
	const Location &loc
	) : 	CompileError(loc, ""),
		failedName(name)
{
}

void 
UndefinedSymbol::put(std::ostream& stream) const
{
	stream << this->location << ": Symbol"
	       << " '" << this->failedName << "'";

	stream << " undefined.";
}


}; /* namespace ast */
