/* $Id: FAUhdlScanner.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __FAUHDLSCANNER_HPP_INCLUDED
#define __FAUHDLSCANNER_HPP_INCLUDED

/* make sure that yyFlexLexer will not get declared more than once */
#undef yyFlexLexer
#include <FlexLexer.h>
#include <string>

namespace yy {

/** custom lexer class with a overloaded yylex function
 */
class FAUhdlScanner : public yyFlexLexer {
public:
	// arg_yyin and arg_yyout default to the cin and cout, but we
	// only make that assignment when initializing in yylex().
	FAUhdlScanner(
		FLEX_STD istream* arg_yyin = 0, 
		FLEX_STD ostream* arg_yyout = 0
		) : 	yyFlexLexer(arg_yyin, arg_yyout),
			bracesCtr(0),
			isAssociation(false),
			backup(std::string()),
			scannedForAssociation(false) {}

	virtual ~FAUhdlScanner() {}

	/* defined from flex via mangling in ParserDriver.hpp for *this* 
   	 * class */
	virtual FAUhdlParser::token_type 
	yylex(
		yy::FAUhdlParser::semantic_type* yylval, 
		FAUhdlParser::location_type* yylloc,
		ParserDriver& driver
	);

private:
	/** unput all characters stored in backup */
	void putBack(void) {
		for (std::string::reverse_iterator i = this->backup.rbegin();
			i != this->backup.rend(); i++) {

			/* evil: copied definition of macro unput */
			this->yyunput(*i, yytext);
		}
	}

	/** reset bracesCtr, isAssociation and backup */
	void reset(void) {
		this->bracesCtr = 0;
		this->isAssociation = false;
		this->backup = "";
	}

	/** braces counter (e.g. association list checking ) */
	int bracesCtr;
	/** is an association? */
	bool isAssociation;
	/** backup stack for lookahead scanning. */
	std::string backup;
	/** already scanned for an association? */
	bool scannedForAssociation;
};

}

#endif /* __FAUHDLSCANNER_HPP_INCLUDED */
