# This file is part of the Falcon repository manager
# Copyright (C) 2005-2008 Dennis Kaarsemaker
# See the file named COPYING in the root of the source tree for license details

import glob,sys,os
j = os.path.join

# We need python2.4 since python-newt breaks with 2.5
if sys.version_info < (2,4,0) or sys.version_info >= (2,5,0):
    print >>sys.stderr, "Falcon requires python 2.4"
    sys.exit(1)

import subprocess

# Check for our dependencies
if 'falcon_skip_dep_check' not in os.environ:
    imports = ['chardet', 'django', 'apt', 'sqlite3', 'newt']
    for i in imports:
        try:
            eval("import %s" % i)
        except ImportError:
            print "Can't find the %s module" % i
            sys.exit(1)
    apps = ['ssh','mkisofs','rsync','msgfmt']
    paths = os.getenv('PATH').split(os.pathsep)
    for a in apps:
        for p in paths:
            if os.path.exists(j(p,a)):
                break
        else:
            print "Can't find %s on your $PATH" % a
            sys.exit(1)

# Template files
template_root = j('share','falcon')
templates = os.listdir(j('share','templates'))
templates = [(j('share','falcon','templates',t), glob.glob(j('share','templates',t,'*'))) for t in templates]

# Translations
translations = []
for f in os.listdir('po'):
    if not f.endswith('.po'): continue
    mo = j('share', 'locale', f[:-3], 'LC_MESSAGES', 'falcon.mo')
    translations.append((os.path.dirname(mo),[mo]))

from distutils.command.install_data import install_data
class falcon_install(install_data):
    def run(self):
        for f in os.listdir('po'):
            if not f.endswith('.po'): continue
            mo = j('share', 'locale', f[:-3], 'LC_MESSAGES', 'falcon.mo')
            os.makedirs(os.path.dirname(mo))
            subprocess.call(['msgfmt', j('po',f), '-o', mo])
        install_data.run(self)

from distutils.core import setup
setup(cmdclass={'install_data': falcon_install}, 
      name="Falcon",
      version="2.0.5",
      description="Falcon repository generator",
      author="Dennis Kaarsemaker",
      author_email="dennis@kaarsemaker.net",
      url="http://www.kaarsemaker.net/software/falcon",
      package_dir = {'': 'lib'},
      packages=["falcon", "falcon.plugins", "falcon.templatetags"],
      scripts=glob.glob(j('bin','*')),
      data_files=[(j("share","man","man1"), glob.glob('*.1')),
                  (j("share","falcon","app-install-data"), [j("share","app-install-data","99app-install-ORIGIN")]),
                  (j("share","falcon","app-install-data","debian"), glob.glob(j("share","app-install-data","debian","*")))] \
                + templates \
                + translations
     )
