/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright  CNRS, INRIA, Universit Bordeaux 1
 * See COPYING in top-level directory.
 */

#ifndef __GOMP_EV_CODES_H__
#define __GOMP_EV_CODES_H__

#include "ev_codes.h"

#define GOMP_EVENTS_ID    0x01
#define GOMP_PREFIX         (GOMP_EVENTS_ID << NB_BITS_EVENTS)

#define FUT_GOMP_PARALLEL_START (GOMP_PREFIX | 0x0001)
#define FUT_GOMP_NEW_FORK       (GOMP_PREFIX | 0x0002)
#define FUT_GOMP_NEW_JOIN       (GOMP_PREFIX | 0x0003)
#define FUT_GOMP_JOIN_DONE      (GOMP_PREFIX | 0x0004)

#define FUT_GOMP_CRITICAL_START       (GOMP_PREFIX | 0x0005)
#define FUT_GOMP_CRITICAL_START_DONE  (GOMP_PREFIX | 0x0006)
#define FUT_GOMP_CRITICAL_STOP        (GOMP_PREFIX | 0x0007)

#define FUT_POMP_FINALIZE        (GOMP_PREFIX | 0xffff)

#define FUT_POMP_ATOMIC_ENTER    (GOMP_PREFIX | 0x0010)
#define FUT_POMP_ATOMIC_EXIT     (GOMP_PREFIX | 0x0011)

#define FUT_POMP_BARRIER_ENTER   (GOMP_PREFIX | 0x0020)
#define FUT_POMP_BARRIER_EXIT    (GOMP_PREFIX | 0x0021)

#define FUT_POMP_FLUSH_ENTER     (GOMP_PREFIX | 0x0030)
#define FUT_POMP_FLUSH_EXIT      (GOMP_PREFIX | 0x0031)

#define FUT_POMP_CRITICAL_ENTER  (GOMP_PREFIX | 0x0040)
#define FUT_POMP_CRITICAL_EXIT   (GOMP_PREFIX | 0x0041)
#define FUT_POMP_CRITICAL_BEGIN  (GOMP_PREFIX | 0x0042)
#define FUT_POMP_CRITICAL_END    (GOMP_PREFIX | 0x0043)

#define FUT_POMP_FOR_ENTER       (GOMP_PREFIX | 0x0050)
#define FUT_POMP_FOR_EXIT        (GOMP_PREFIX | 0x0051)

#define FUT_POMP_MASTER_BEGIN    (GOMP_PREFIX | 0x0060)
#define FUT_POMP_MASTER_END      (GOMP_PREFIX | 0x0061)

#define FUT_POMP_PARALLEL_BEGIN  (GOMP_PREFIX | 0x0070)
#define FUT_POMP_PARALLEL_END    (GOMP_PREFIX | 0x0071)
#define FUT_POMP_PARALLEL_FORK   (GOMP_PREFIX | 0x0072)
#define FUT_POMP_PARALLEL_JOIN   (GOMP_PREFIX | 0x0073)

#define FUT_POMP_SECTIONS_ENTER  (GOMP_PREFIX | 0x0080)
#define FUT_POMP_SECTIONS_EXIT   (GOMP_PREFIX | 0x0081)

#define FUT_POMP_SECTION_BEGIN   (GOMP_PREFIX | 0x0082)
#define FUT_POMP_SECTION_END    (GOMP_PREFIX | 0x0083)

#define FUT_POMP_SINGLE_ENTER    (GOMP_PREFIX | 0x0090)
#define FUT_POMP_SINGLE_EXIT     (GOMP_PREFIX | 0x0091)
#define FUT_POMP_SINGLE_BEGIN    (GOMP_PREFIX | 0x0092)
#define FUT_POMP_SINGLE_END     (GOMP_PREFIX | 0x0093)

#define FUT_POMP_WORKSHARE_ENTER (GOMP_PREFIX | 0x00a0)
#define FUT_POMP_WORKSHARE_EXIT  (GOMP_PREFIX | 0x00a1)

#define FUT_POMP_TASK_BEGIN      (GOMP_PREFIX | 0x00b0)
#define FUT_POMP_TASK_END        (GOMP_PREFIX | 0x00b1)
#define FUT_POMP_TASKWAIT_ENTER  (GOMP_PREFIX | 0x00b2)
#define FUT_POMP_TASKWAIT_EXIT   (GOMP_PREFIX | 0x00b3)

#endif	/* __GOMP_EV_CODES_H__ */
