;; int13hook.inc
;;	These subroutines used(and modified) a part of LILO-21.3/chain.S.
;;	LILO is generic boot loader for Linux written by Werner Almesberger.
;;	Thanks.
;;
;;  $Id: hookup13.inc,v 1.2 2002/03/25 13:48:52 takamiti Exp $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

basemem_size	equ	0x0413
int13entry_ofs	equ	0x004c
int13entry_seg	equ	0x004e

;;
;;	Enter:	dl = drive unix
set_int13hook:	push	cx
		push	di
		mov	dh,0x80
		mov	[swap_drv],dx
swap_vect:	dec	word [basemem_size]
		mov	ax,[basemem_size]
		mov	cl,6
		shl	ax,cl
		xor	di,di
		mov	dx,[int13entry_ofs]
		mov	[old13ofs],dx
		mov	dx,[int13entry_seg]
		mov	[old13seg],dx
		push	di
		push	ax
		mov	si,int13hook
		mov	cx,int13hook_size
		push	es
		mov	es,ax
		rep movsb
		pop	es
		pop	ax
		pop	di
		cli
		mov	[int13entry_ofs],di
		mov	[int13entry_seg],ax
		sti
;%ifdef VERBOSE
;hook13_msg:
;		mov	si,int13hook_msg
;		call	tty_outmsg
;		call	CRLF
;%endif
		pop	di
		pop	cx
		ret

;; =====================================================
;;	int13hook function
;; =====================================================
int13hook:	push	ax		; save AX (contains function code on AH)
		push	bp		; need BP to mess with stack
		mov	bp,sp
					;; stack layout:
					;;	+8 INT flags
					;;	+6 INT CS
					;;	+4 INT IP
					;;	+2 AX
					;;    BP+0 BP
		pushf			; push flags (tp act like interrupt)
		mov	[bp + 8],dx	; overwrite old flags(to remember mapping)
		db	0xb8
swap_drv:	dw	0
		cmp	dl,al
		jz	swapping
		xchg	ah,al
		cmp	dl,al
		jnz	noswap
swapping:	mov	dl,ah
noswap:		mov	ax,[bp + 2]	; restore AX
		mov	bp,[bp]		; restore BP
		db	0x9a		; CALL FAR
old13ofs:	dw	0
old13seg:	dw	0
		push	bp		; save BP again
		mov	bp,sp
					;; New stack layout:
					;;     +10 mapping (was flag)
					;;	+8 INT CS
					;;	+6 INT IP
					;;	+4 AX
					;;	+2 obsolate BP
					;;    BP+0 BP
		xchg	ax,[bp + 4]	; save AX and get BIOS function
		pushf
		cmp	ah,0x08
		jz	end_int13
		cmp	ah,0x15
		jz	end_int13
		mov	ax,[bp + 10]
		mov	dl,al
end_int13:	mov	ax,[bp + 4]
		pop	word [bp + 10]
		pop	bp
		add	sp,4
		iret
int13hook_size	equ	$ - int13hook

;;
;; end of int13hook.inc
;;
