'''
expEYES program
Author  : Ajith Kumar B.P, bpajith@gmail.com
License : GNU GPL version 3
'''
from Tkinter import *
import expeyes.eyes as eyes, expeyes.eyeplot as eyeplot, expeyes.eyemath as eyemath, time, math, sys

TIMER = 100
WIDTH  = 500   # width of drawing canvas
HEIGHT = 350   # height 
VPERDIV = 1.0		# Volts per division, vertical scale
delay = 500			# Time interval between samples
NP = 200			# Number of samples
data = [ [], [] ]
history = []		# Data store
trial = 0			# trial number
data = [ [], [] ]	# Current & Voltage


def find_peaks(ta,va):
	vmin = 5.0
	vmax = -5.0
	t1 = t2 = 0
	size = len(ta)
	for i in range(size):
		if va[i] < vmin:
			vmin = va[i]
			t1 = ta[i]
		if va[i] > vmax:
			vmax = va[i]
			t2 = ta[i]
#    print vmin, vmax
	if t1 < t2:			# return left side peak first
		return (t1,vmin), (t2,vmax)
	else:
		return (t2,vmax),(t1,vmin)

def base_scan():
	global data, history, trial, NP, delay, noise
	t, v = p.capture(0,NP,delay)
	running = True
	data = [ [], [] ]
	noise = abs(find_peaks(t,v)[0][1])
	msgwin.config(text = 'Voltage Scan on Coil Done. Noise Voltage = %5.3f V'%noise)
	root.after(TIMER, update)

def update():
	global data, history, trial, NP, delay, noise
	t, v= p.capture(0,NP,delay)
	g.delete_lines()
	g.line(t,v,trial)
	peaks = find_peaks(t,v)
	if abs(peaks[0][1] - noise) > 0.5:
		tmax = NP * delay * 0.001   # mSec
		if peaks[0][0] > tmax*0.1 and peaks[1][0] < tmax*0.9:
			data = [t,v]
			history.append(data)
			trial += 1
			return				
	root.after(TIMER, update)

def clear():
	global history, trial
	g.delete_lines()
	history = []
	trial = 0

def save():
	global history
	s = fn.get()
	if s == '':
		return
	p.save(history, s)
	msgwin.config(text = 'Data saved to file '+s)

def viewall():		# Send the data to Xmgrace
	global history
	g.delete_lines()	
	i = 0
	for t,v in history:
		g.line(t,v,i)
		i += 1

p = eyes.open()
root = Tk()
Canvas(root, width = WIDTH, height = 5).pack(side=TOP)  # Some space at the top
g = eyeplot.graph(root, width=WIDTH, height=HEIGHT)	# make plot objects using draw.disp
g.setWorld(0,-5*VPERDIV, NP * delay * 0.001, 5*VPERDIV,'mS','V')

cf = Frame(root, width = WIDTH, height = 10)
cf.pack(side=TOP,  fill = BOTH, expand = 1)
b = Button(cf,text ='Start Scanning', command= base_scan)
b.pack(side=LEFT, anchor = SW)

b = Button(cf,text ='Save to', command=save)
b.pack(side=LEFT, anchor = SW)
fn = Entry(cf,width = 10, bg = 'white')
fn.pack(side=LEFT, anchor = SW)
fn.insert(END,'ind.dat')
b = Button(cf,text ='QUIT', command=sys.exit)
b.pack(side=RIGHT, anchor = SW)
b = Button(cf,text ='VIEW', command=viewall)
b.pack(side=RIGHT, anchor = SW)
b4 = Button(cf, text = 'CLEAR', command = clear)
b4.pack(side = RIGHT, anchor = N)

mf = Frame(root)				# Message Frame below command frame.
mf.pack(side=TOP, anchor = SW)
msgwin = Label(mf,text = 'Messages', fg = 'blue')
msgwin.pack(side=LEFT, anchor = SW)
root.title('EYES: Electromagnetic Induction')
root.mainloop()

