'''
expEYES program
Author  : Ajith Kumar B.P, bpajith@gmail.com
License : GNU GPL version 3
'''

from numpy import *
from Tkinter import *
import expeyes.eyes as eyes, time

#cpoints = [4.0, 0.0, -4.0]

cpoints = [4.0, 3.0, 2.0, 1.0, 0.0, -1.0, -2.0, -3.0, -4.0]
NP = len(cpoints)
setVar  = []
mesVar  = []
ADlab0  = []
ADlab1  = []
DAlab   = []

BPV = 0			# bipolar DAC

def setvoltage(n):
	global curchan
	v = cpoints[n]
	if -5.0 <= v <= 5.0:
		da = p.set_voltage(BPV,v)
		dabin[n] = da
		ss = '(%4.0f)'%da
		DAlab[n].config(text = ss, fg='blue')
		time.sleep(0.1)
		asum = 0
		for k in range(10):
			asum += p.read_adc(0)
		ad = float(asum)/10	
		adbin0[n] = ad
		ss = '(%4.0f)'%ad
		ADlab0[n].config(text = ss, fg='blue')
		asum = 0
		for k in range(10):
			asum += p.read_adc(1)
		ad = float(asum)/10	
		adbin1[n] = ad
		ss = '(%4.0f)'%ad
		ADlab1[n].config(text = ss, fg='blue')
	else:
		print 'ERROR'		

def calib():
	global curchan
	for k in range(NP):
		mv = float(mesVar[k].get())
		if (mv < -5.0) or (mv > 5.0):
			msg.config(text='Enter all Mesured Voltages Proper', fg='red')
			return
		advolts[k] = mv
		print cpoints[k], dabin[k], mv, adbin0[k], adbin1[k]

	x = adbin0				# Calculate m & c for CH0
	y = advolts
	xbar = mean(x)
	ybar = mean(y)
	m = sum(y*(x-xbar)) / sum(x*(x-xbar))
	c = ybar - xbar * m
	print 'ADC0 m & c ', m,c
	p.save_calib(0,m,c)		# Save it on EEPROM

	x = adbin1				# Calculate m & c for CH1
	y = advolts
	xbar = mean(x)
	ybar = mean(y)
	m = sum(y*(x-xbar)) / sum(x*(x-xbar))
	c = ybar - xbar * m
	print 'ADC1 m & c ', m,c
	p.save_calib(1,m,c)		# Save it on EEPROM

	x = advolts				# m & c for -5V to +5V DAC
	y = dabin
	xbar = mean(x)
	ybar = mean(y)
	m = sum(y*(x-xbar)) / sum(x*(x-xbar))
	c = ybar - xbar * m
	p.save_calib(8,m,c)		# Save it on EEPROM
	print 'DAC0 m & c ', m,c

def verify(ch):
	p.load_calib(8)
	p.load_calib(ch)
	f = open('calib%d.dat'%ch,'w')
	v = -4.5
	while v <= 4.5:
		p.set_voltage(0,v)
		time.sleep(0.01)	
		rv = p.get_voltage(ch)		
		ss = '%10.3f %10.4f'%(v,v-rv)
		f.write(ss+'\n')
		print ss
		v = v + 0.1
	f.close()

p = eyes.open()
if p == None:
	sys.exit()

adbin0 	= zeros(NP,dtype=float)
adbin1 	= zeros(NP,dtype=float)
advolts = zeros(NP,dtype=float)
dabin   = zeros(NP,dtype=float)
davolts = zeros(NP,dtype=float)

root = Tk()


for k in range(NP):
	lv = Frame(root, padx = 5, pady = 5)
	lv.pack(side=TOP, fill = X)
	l = Label(lv, text = '(0000)', fg = 'black')
	l.pack(side = LEFT, fill = Y)
	DAlab.append(l)
	Set = Button(lv,text='Set %3.0f Volts'%cpoints[k], command = lambda arg=k : setvoltage(arg))
	Set.pack(side=LEFT)
	l = Label(lv, text = '(0000)', fg = 'black')
	l.pack(side = LEFT, fill = Y)
	ADlab0.append(l)
	l = Label(lv, text = '(0000)', fg = 'black')
	l.pack(side = LEFT, fill = Y)
	ADlab1.append(l)
	l = Label(lv, text = 'Mesured =',)
	l.pack(side = LEFT, fill = Y)
	mv = StringVar()
	mesVar.append(mv)
	e = Entry(lv, width = 8, textvariable = mv, fg = 'blue', bg = 'white')
	e.pack(side = LEFT, fill = Y)
	mesVar[k].set('%5.0f'%cpoints[k])

f = Frame(root, padx = 5, pady = 5)
f.pack(side=TOP, fill = X)
l = Label(f, text = 'First you MUST Connect BPV to A0 & A1.\nThen click on each "Set Volts Button",'+\
		'Measure BPV with a 4.5 DMM and\n enter it in the "Measured=" Field.\n'+\
		'IMPROPER USE MAY SPOIL THE CALIBRATION', fg = 'blue')
l.pack(side = LEFT, fill = Y)


cmd = Frame(root, padx = 5, pady = 5)
cmd.pack(side=TOP, fill = X)
Cal = Button(cmd,text='Calibrate', fg='red', command = calib)
Cal.pack(side=LEFT)

b = Button(cmd,text='Verify CH0', command = lambda arg=0 : verify(arg))
b.pack(side=LEFT)
b = Button(cmd,text='Verify CH1', command = lambda arg=1 : verify(arg))
b.pack(side=LEFT)
b = Button(cmd,text='QUIT', command = sys.exit)
b.pack(side=LEFT)
f = Frame(root, padx = 5, pady = 5)
f.pack(side=TOP, fill = BOTH)
msg = Label(f, text = 'msg')
msg.pack(side=LEFT)

root.title('AD/DA CALIBRATION. NOT FOR EVERYONE!!')
root.mainloop()

