/*
 *   (C) Copyright IBM Corp. 2006
 *   (C) Copyright Novell, Inc. 2006 All Rights Reserved
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of version 2 of the GNU General Public License as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: OCFS2 FSIM
 * File: evms2/engine/plugins/ocfs2/ocfs2.h
 */

#ifndef _OCFS2_H_
#define _OCFS2_H_ 1

/******************
 *  EVMS defines  *
 ******************/
extern plugin_record_t oc2_plugin_record;


/************************************
 *  fsck.oc2fs, mkfs.oc2fs defines  *
 ************************************/

/* fsck.ocfs2, mkfs.ocfs2 option counts */
#define FSCK_OPTIONS_COUNT	1
#define MKFS_OPTIONS_COUNT	3

/* fsck.ocfs2 option array indices  */
#define FSCK_MODE_INDEX		0
#define FSCK_READONLY		"Check Read-Only"
#define FSCK_FIX		"Fix"
#define FSCK_REBUILD_TREE	"Rebuild Tree"

/* mkfs.ocfs2 option array indices */
#define MKFS_VERSION_INDEX	0
#define MKFS_SETVOL_INDEX	1
#define MKFS_SETLOGSIZE_INDEX	2

/* fsck exit codes */
#define FSCK_OK			0
#define FSCK_CORRECTED		1
#define FSCK_REBOOT		2
#define FSCK_ERRORS_UNCORRECTED	4
#define FSCK_OP_ERROR		8
#define FSCK_USAGE_ERROR	16


/*****************************
 *      ocfs2 defines        *
 *****************************/
#define OCFS2_HDR_SIGNATURE	"this is an ocfs2 volume"
#define MINOCFS2		(1024*33*2) /* 33MB in sectors - not sure of real limit. */
#define MEGABYTE		1024
#define MAX_LOG_PERCENTAGE	.4
#define OCFS2_SUPER_MAGIC_STRING "OCFSV2"
#define LABEL_LEN		64
#define UUID_LEN		16

/* generic defines */
#define GET			0
#define PUT			1


/*****************************
 *      structs              *
 *****************************/
struct ocfs2_super_block {
	int16_t s_major_rev_level;
	int16_t s_minor_rev_level;
	int16_t s_mnt_count;
	int16_t s_max_mnt_count;
	int16_t s_state;
	int16_t s_errors;
	int32_t s_checkinterval;
	int64_t s_lastcheck;
	int32_t s_creator_os;
	int32_t s_feature_compat;
	int32_t s_feature_incompat;
	int32_t s_feature_ro_compat;
	int64_t s_root_blkno;
	int64_t s_system_dir_blkno;
	int32_t s_blocksize_bits;
	int32_t s_clustersize_bits;
	int16_t s_max_slots;
	int16_t s_reserved1;
	int32_t s_reserved2;
	int64_t s_first_cluster_group;
	int8_t s_label[LABEL_LEN];
	int8_t s_uuid[UUID_LEN];
};

struct _ocfs2_dinode {
	int8_t h_signature[8];
	int32_t i_generation;
	uint16_t suballoc_slot;
	uint16_t suballoc_bit;
	uint32_t i_reserved0;
	uint32_t i_clusters;
	uint32_t i_uid;
	uint32_t i_gid;
	uint32_t i_size;
	uint32_t i_mode;
	uint32_t i_links_count;
	uint32_t i_flags;
	uint64_t i_atime;
	uint64_t i_ctime;
	uint64_t i_mtime;
	uint64_t i_dtime;
	uint64_t i_blkno;
	uint64_t i_last_eb_block;
	uint32_t i_fs_generation;
	uint32_t i_atime_nsec;
	uint32_t i_ctime_nsec;
	uint32_t i_mtime_nsec;
	uint64_t i_reserved1[9];
	union {
		uint64_t i_pad1;
	} id1;
	union {
		struct ocfs2_super_block i_super;
	} id2;
} __attribute__ ((__packed__));;

/* OCFS2 leaves the first 2048 bytes unused except at offset 560,
 * where it places a signature string.
 */
typedef struct _ocfs_vol_disk_hdr {
	int8_t offset[560];
	int8_t signature[24]; /* Contains "this is an ocfs2 volume" */
	int8_t more[440];     /* This defines the header as 1024 bytes */
} ocfs_vol_disk_hdr;

#define SB_SIZE     (sizeof(struct ocfs2_super_block))
#define DINODE_SIZE (sizeof(struct _ocfs2_dinode))
#define HDR_SIZE    (sizeof(struct _ocfs_vol_disk_hdr))

#endif

